/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package versioned

import (
	fmt "fmt"
	http "net/http"

	discovery "k8s.io/client-go/discovery"
	rest "k8s.io/client-go/rest"
	flowcontrol "k8s.io/client-go/util/flowcontrol"
	conflictingexamplev1 "k8s.io/code-generator/examples/crd/clientset/versioned/typed/conflicting/v1"
	examplev1 "k8s.io/code-generator/examples/crd/clientset/versioned/typed/example/v1"
	secondexamplev1 "k8s.io/code-generator/examples/crd/clientset/versioned/typed/example2/v1"
	extensionsexamplev1 "k8s.io/code-generator/examples/crd/clientset/versioned/typed/extensions/v1"
)

type Interface interface {
	Discovery() discovery.DiscoveryInterface
	ConflictingExampleV1() conflictingexamplev1.ConflictingExampleV1Interface
	ExampleV1() examplev1.ExampleV1Interface
	SecondExampleV1() secondexamplev1.SecondExampleV1Interface
	ExtensionsExampleV1() extensionsexamplev1.ExtensionsExampleV1Interface
}

// Clientset contains the clients for groups.
type Clientset struct {
	*discovery.DiscoveryClient
	conflictingExampleV1 *conflictingexamplev1.ConflictingExampleV1Client
	exampleV1            *examplev1.ExampleV1Client
	secondExampleV1      *secondexamplev1.SecondExampleV1Client
	extensionsExampleV1  *extensionsexamplev1.ExtensionsExampleV1Client
}

// ConflictingExampleV1 retrieves the ConflictingExampleV1Client
func (c *Clientset) ConflictingExampleV1() conflictingexamplev1.ConflictingExampleV1Interface {
	return c.conflictingExampleV1
}

// ExampleV1 retrieves the ExampleV1Client
func (c *Clientset) ExampleV1() examplev1.ExampleV1Interface {
	return c.exampleV1
}

// SecondExampleV1 retrieves the SecondExampleV1Client
func (c *Clientset) SecondExampleV1() secondexamplev1.SecondExampleV1Interface {
	return c.secondExampleV1
}

// ExtensionsExampleV1 retrieves the ExtensionsExampleV1Client
func (c *Clientset) ExtensionsExampleV1() extensionsexamplev1.ExtensionsExampleV1Interface {
	return c.extensionsExampleV1
}

// Discovery retrieves the DiscoveryClient
func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	if c == nil {
		return nil
	}
	return c.DiscoveryClient
}

// NewForConfig creates a new Clientset for the given config.
// If config's RateLimiter is not set and QPS and Burst are acceptable,
// NewForConfig will generate a rate-limiter in configShallowCopy.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*Clientset, error) {
	configShallowCopy := *c

	if configShallowCopy.UserAgent == "" {
		configShallowCopy.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	// share the transport between all clients
	httpClient, err := rest.HTTPClientFor(&configShallowCopy)
	if err != nil {
		return nil, err
	}

	return NewForConfigAndClient(&configShallowCopy, httpClient)
}

// NewForConfigAndClient creates a new Clientset for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
// If config's RateLimiter is not set and QPS and Burst are acceptable,
// NewForConfigAndClient will generate a rate-limiter in configShallowCopy.
func NewForConfigAndClient(c *rest.Config, httpClient *http.Client) (*Clientset, error) {
	configShallowCopy := *c
	if configShallowCopy.RateLimiter == nil && configShallowCopy.QPS > 0 {
		if configShallowCopy.Burst <= 0 {
			return nil, fmt.Errorf("burst is required to be greater than 0 when RateLimiter is not set and QPS is set to greater than 0")
		}
		configShallowCopy.RateLimiter = flowcontrol.NewTokenBucketRateLimiter(configShallowCopy.QPS, configShallowCopy.Burst)
	}

	var cs Clientset
	var err error
	cs.conflictingExampleV1, err = conflictingexamplev1.NewForConfigAndClient(&configShallowCopy, httpClient)
	if err != nil {
		return nil, err
	}
	cs.exampleV1, err = examplev1.NewForConfigAndClient(&configShallowCopy, httpClient)
	if err != nil {
		return nil, err
	}
	cs.secondExampleV1, err = secondexamplev1.NewForConfigAndClient(&configShallowCopy, httpClient)
	if err != nil {
		return nil, err
	}
	cs.extensionsExampleV1, err = extensionsexamplev1.NewForConfigAndClient(&configShallowCopy, httpClient)
	if err != nil {
		return nil, err
	}

	cs.DiscoveryClient, err = discovery.NewDiscoveryClientForConfigAndClient(&configShallowCopy, httpClient)
	if err != nil {
		return nil, err
	}
	return &cs, nil
}

// NewForConfigOrDie creates a new Clientset for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *Clientset {
	cs, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return cs
}

// New creates a new Clientset for the given RESTClient.
func New(c rest.Interface) *Clientset {
	var cs Clientset
	cs.conflictingExampleV1 = conflictingexamplev1.New(c)
	cs.exampleV1 = examplev1.New(c)
	cs.secondExampleV1 = secondexamplev1.New(c)
	cs.extensionsExampleV1 = extensionsexamplev1.New(c)

	cs.DiscoveryClient = discovery.NewDiscoveryClient(c)
	return &cs
}
