// Code generated by smithy-go-codegen DO NOT EDIT.

package eventbridge

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/eventbridge/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the specified event bus.
func (c *Client) UpdateEventBus(ctx context.Context, params *UpdateEventBusInput, optFns ...func(*Options)) (*UpdateEventBusOutput, error) {
	if params == nil {
		params = &UpdateEventBusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateEventBus", params, optFns, c.addOperationUpdateEventBusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateEventBusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateEventBusInput struct {

	// Configuration details of the Amazon SQS queue for EventBridge to use as a
	// dead-letter queue (DLQ).
	//
	// For more information, see [Using dead-letter queues to process undelivered events] in the EventBridge User Guide.
	//
	// [Using dead-letter queues to process undelivered events]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-rule-event-delivery.html#eb-rule-dlq
	DeadLetterConfig *types.DeadLetterConfig

	// The event bus description.
	Description *string

	// The identifier of the KMS customer managed key for EventBridge to use, if you
	// choose to use a customer managed key to encrypt events on this event bus. The
	// identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key
	// alias ARN.
	//
	// If you do not specify a customer managed key identifier, EventBridge uses an
	// Amazon Web Services owned key to encrypt events on the event bus.
	//
	// For more information, see [Identify and view keys] in the Key Management Service Developer Guide.
	//
	// Schema discovery is not supported for event buses encrypted using a customer
	// managed key. EventBridge returns an error if:
	//
	//   - You call [CreateDiscoverer]on an event bus set to use a customer managed key for encryption.
	//
	//   - You call [UpdatedEventBus]to set a customer managed key on an event bus with schema
	//   discovery enabled.
	//
	// To enable schema discovery on an event bus, choose to use an Amazon Web
	// Services owned key. For more information, see [Encrypting events]in the Amazon EventBridge User
	// Guide.
	//
	// If you have specified that EventBridge use a customer managed key for
	// encrypting the source event bus, we strongly recommend you also specify a
	// customer managed key for any archives for the event bus as well.
	//
	// For more information, see [Encrypting archives] in the Amazon EventBridge User Guide.
	//
	// [UpdatedEventBus]: https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UpdatedEventBus.html
	// [Encrypting events]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption-event-bus-cmkey.html
	// [Identify and view keys]: https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html
	// [Encrypting archives]: https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html
	// [CreateDiscoverer]: https://docs.aws.amazon.com/eventbridge/latest/schema-reference/v1-discoverers.html#CreateDiscoverer
	KmsKeyIdentifier *string

	// The logging configuration settings for the event bus.
	//
	// For more information, see [Configuring logs for event buses] in the EventBridge User Guide.
	//
	// [Configuring logs for event buses]: https://docs.aws.amazon.com/eb-event-bus-logs.html
	LogConfig *types.LogConfig

	// The name of the event bus.
	Name *string

	noSmithyDocumentSerde
}

type UpdateEventBusOutput struct {

	// The event bus Amazon Resource Name (ARN).
	Arn *string

	// Configuration details of the Amazon SQS queue for EventBridge to use as a
	// dead-letter queue (DLQ).
	//
	// For more information, see [Using dead-letter queues to process undelivered events] in the EventBridge User Guide.
	//
	// [Using dead-letter queues to process undelivered events]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-rule-event-delivery.html#eb-rule-dlq
	DeadLetterConfig *types.DeadLetterConfig

	// The event bus description.
	Description *string

	// The identifier of the KMS customer managed key for EventBridge to use to
	// encrypt events on this event bus, if one has been specified.
	//
	// For more information, see [Data encryption in EventBridge] in the Amazon EventBridge User Guide.
	//
	// [Data encryption in EventBridge]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-encryption.html
	KmsKeyIdentifier *string

	// The logging configuration settings for the event bus.
	//
	// For more information, see [Configuring logs for event buses] in the EventBridge User Guide.
	//
	// [Configuring logs for event buses]: https://docs.aws.amazon.com/eb-event-bus-logs.html
	LogConfig *types.LogConfig

	// The event bus name.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateEventBusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateEventBus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateEventBus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateEventBus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateEventBus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateEventBus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateEventBus",
	}
}
