/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
	acmev1 "github.com/cert-manager/cert-manager/pkg/client/clientset/versioned/typed/acme/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeOrders implements OrderInterface
type fakeOrders struct {
	*gentype.FakeClientWithList[*v1.Order, *v1.OrderList]
	Fake *FakeAcmeV1
}

func newFakeOrders(fake *FakeAcmeV1, namespace string) acmev1.OrderInterface {
	return &fakeOrders{
		gentype.NewFakeClientWithList[*v1.Order, *v1.OrderList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("orders"),
			v1.SchemeGroupVersion.WithKind("Order"),
			func() *v1.Order { return &v1.Order{} },
			func() *v1.OrderList { return &v1.OrderList{} },
			func(dst, src *v1.OrderList) { dst.ListMeta = src.ListMeta },
			func(list *v1.OrderList) []*v1.Order { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.OrderList, items []*v1.Order) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
