//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armauthorization

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// AlertOperationClient contains the methods for the AlertOperation group.
// Don't use this type directly, use NewAlertOperationClient() instead.
type AlertOperationClient struct {
	internal *arm.Client
}

// NewAlertOperationClient creates a new instance of AlertOperationClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAlertOperationClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AlertOperationClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AlertOperationClient{
		internal: cl,
	}
	return client, nil
}

// Get - Get the specified alert operation.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - scope - The scope of the alert operation.
//   - operationID - The id of the alert operation.
//   - options - AlertOperationClientGetOptions contains the optional parameters for the AlertOperationClient.Get method.
func (client *AlertOperationClient) Get(ctx context.Context, scope string, operationID string, options *AlertOperationClientGetOptions) (AlertOperationClientGetResponse, error) {
	var err error
	const operationName = "AlertOperationClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scope, operationID, options)
	if err != nil {
		return AlertOperationClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AlertOperationClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AlertOperationClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *AlertOperationClient) getCreateRequest(ctx context.Context, scope string, operationID string, options *AlertOperationClientGetOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleManagementAlertOperations/{operationId}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", operationID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AlertOperationClient) getHandleResponse(resp *http.Response) (AlertOperationClientGetResponse, error) {
	result := AlertOperationClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AlertOperationResult); err != nil {
		return AlertOperationClientGetResponse{}, err
	}
	return result, nil
}
