# Put the line below in ~/.bashrc or ~/bash_profile:
#
#   eval "$(jump shell bash)"
#
# The following lines are autogenerated:

__jump_prompt_command() {
  local status=$?
  jump chdir && return $status
}

__jump_hint() {
  [[ ${#COMP_WORDS[@]} -eq $((COMP_CWORD + 1)) ]] || return

  if [[ ${#COMP_WORDS[@]} -eq 2 ]]; then
    local term="${COMP_WORDS[COMP_CWORD]}"
    mapfile -t COMPREPLY < <(compgen -A directory -- "$term")
    if [[ ${#COMPREPLY[@]} -eq 0 && "$term" != */* ]]; then
      mapfile -t COMPREPLY < <(jump hint "${COMP_WORDS[@]:1}" | head -1)
    fi
  else
    mapfile -t COMPREPLY < <(jump hint "${COMP_WORDS[@]:1}")
  fi
}

__jump_base_dir() {
  local base_dir="$JUMP_BASED_PATH"
  if [ -z "$base_dir" ]; then
    base_dir="$(command git rev-parse --show-toplevel 2>/dev/null)"
  fi
  echo "$base_dir"
}

{{.Bind}}() {
  case "$1" in
    "..")
      builtin cd ..
      ;;
    "-")
      builtin cd -
      ;;
    ".")
      builtin cd "$(jump cd "$(__jump_base_dir)" ${@:2})"
      ;;
    *)
      local dir="$(jump cd $@)"
      test -d "$dir" && builtin cd "$dir"
      ;;
  esac
}

[[ "$PROMPT_COMMAND" =~ __jump_prompt_command ]] || {
  PROMPT_COMMAND="__jump_prompt_command;$PROMPT_COMMAND"
}

complete -F __jump_hint -o filenames -- {{.Bind}}
