{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='resourcePolicyRule', url='', help="\"ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==\\\"\\\"`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.\""),
  '#withApiGroups':: d.fn(help='"`apiGroups` is a list of matching API groups and may not be empty. \\"*\\" matches all API groups and, if present, must be the only entry. Required."', args=[d.arg(name='apiGroups', type=d.T.array)]),
  withApiGroups(apiGroups): { apiGroups: if std.isArray(v=apiGroups) then apiGroups else [apiGroups] },
  '#withApiGroupsMixin':: d.fn(help='"`apiGroups` is a list of matching API groups and may not be empty. \\"*\\" matches all API groups and, if present, must be the only entry. Required."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='apiGroups', type=d.T.array)]),
  withApiGroupsMixin(apiGroups): { apiGroups+: if std.isArray(v=apiGroups) then apiGroups else [apiGroups] },
  '#withClusterScope':: d.fn(help='"`clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list."', args=[d.arg(name='clusterScope', type=d.T.boolean)]),
  withClusterScope(clusterScope): { clusterScope: clusterScope },
  '#withNamespaces':: d.fn(help='"`namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains \\"*\\".  Note that \\"*\\" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true."', args=[d.arg(name='namespaces', type=d.T.array)]),
  withNamespaces(namespaces): { namespaces: if std.isArray(v=namespaces) then namespaces else [namespaces] },
  '#withNamespacesMixin':: d.fn(help='"`namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains \\"*\\".  Note that \\"*\\" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='namespaces', type=d.T.array)]),
  withNamespacesMixin(namespaces): { namespaces+: if std.isArray(v=namespaces) then namespaces else [namespaces] },
  '#withResources':: d.fn(help='"`resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ \\"services\\", \\"nodes/status\\" ].  This list may not be empty. \\"*\\" matches all resources and, if present, must be the only entry. Required."', args=[d.arg(name='resources', type=d.T.array)]),
  withResources(resources): { resources: if std.isArray(v=resources) then resources else [resources] },
  '#withResourcesMixin':: d.fn(help='"`resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ \\"services\\", \\"nodes/status\\" ].  This list may not be empty. \\"*\\" matches all resources and, if present, must be the only entry. Required."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='resources', type=d.T.array)]),
  withResourcesMixin(resources): { resources+: if std.isArray(v=resources) then resources else [resources] },
  '#withVerbs':: d.fn(help='"`verbs` is a list of matching verbs and may not be empty. \\"*\\" matches all verbs and, if present, must be the only entry. Required."', args=[d.arg(name='verbs', type=d.T.array)]),
  withVerbs(verbs): { verbs: if std.isArray(v=verbs) then verbs else [verbs] },
  '#withVerbsMixin':: d.fn(help='"`verbs` is a list of matching verbs and may not be empty. \\"*\\" matches all verbs and, if present, must be the only entry. Required."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='verbs', type=d.T.array)]),
  withVerbsMixin(verbs): { verbs+: if std.isArray(v=verbs) then verbs else [verbs] },
  '#mixin': 'ignore',
  mixin: self,
}
