{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='storageOSVolumeSource', url='', help='"Represents a StorageOS persistent volume resource."'),
  '#secretRef':: d.obj(help='"LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace."'),
  secretRef: {
    '#withName':: d.fn(help='"Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names"', args=[d.arg(name='name', type=d.T.string)]),
    withName(name): { secretRef+: { name: name } },
  },
  '#withFsType':: d.fn(help='"fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \\"ext4\\", \\"xfs\\", \\"ntfs\\". Implicitly inferred to be \\"ext4\\" if unspecified."', args=[d.arg(name='fsType', type=d.T.string)]),
  withFsType(fsType): { fsType: fsType },
  '#withReadOnly':: d.fn(help='"readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts."', args=[d.arg(name='readOnly', type=d.T.boolean)]),
  withReadOnly(readOnly): { readOnly: readOnly },
  '#withVolumeName':: d.fn(help='"volumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace."', args=[d.arg(name='volumeName', type=d.T.string)]),
  withVolumeName(volumeName): { volumeName: volumeName },
  '#withVolumeNamespace':: d.fn(help="\"volumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to \\\"default\\\" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.\"", args=[d.arg(name='volumeNamespace', type=d.T.string)]),
  withVolumeNamespace(volumeNamespace): { volumeNamespace: volumeNamespace },
  '#mixin': 'ignore',
  mixin: self,
}
