{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='statefulSetStatus', url='', help='"StatefulSetStatus represents the current state of a StatefulSet."'),
  '#withAvailableReplicas':: d.fn(help='"Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset."', args=[d.arg(name='availableReplicas', type=d.T.integer)]),
  withAvailableReplicas(availableReplicas): { availableReplicas: availableReplicas },
  '#withCollisionCount':: d.fn(help='"collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision."', args=[d.arg(name='collisionCount', type=d.T.integer)]),
  withCollisionCount(collisionCount): { collisionCount: collisionCount },
  '#withConditions':: d.fn(help="\"Represents the latest available observations of a statefulset's current state.\"", args=[d.arg(name='conditions', type=d.T.array)]),
  withConditions(conditions): { conditions: if std.isArray(v=conditions) then conditions else [conditions] },
  '#withConditionsMixin':: d.fn(help="\"Represents the latest available observations of a statefulset's current state.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='conditions', type=d.T.array)]),
  withConditionsMixin(conditions): { conditions+: if std.isArray(v=conditions) then conditions else [conditions] },
  '#withCurrentReplicas':: d.fn(help='"currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision."', args=[d.arg(name='currentReplicas', type=d.T.integer)]),
  withCurrentReplicas(currentReplicas): { currentReplicas: currentReplicas },
  '#withCurrentRevision':: d.fn(help='"currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas)."', args=[d.arg(name='currentRevision', type=d.T.string)]),
  withCurrentRevision(currentRevision): { currentRevision: currentRevision },
  '#withObservedGeneration':: d.fn(help="\"observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.\"", args=[d.arg(name='observedGeneration', type=d.T.integer)]),
  withObservedGeneration(observedGeneration): { observedGeneration: observedGeneration },
  '#withReadyReplicas':: d.fn(help='"readyReplicas is the number of pods created for this StatefulSet with a Ready Condition."', args=[d.arg(name='readyReplicas', type=d.T.integer)]),
  withReadyReplicas(readyReplicas): { readyReplicas: readyReplicas },
  '#withReplicas':: d.fn(help='"replicas is the number of Pods created by the StatefulSet controller."', args=[d.arg(name='replicas', type=d.T.integer)]),
  withReplicas(replicas): { replicas: replicas },
  '#withUpdateRevision':: d.fn(help='"updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)"', args=[d.arg(name='updateRevision', type=d.T.string)]),
  withUpdateRevision(updateRevision): { updateRevision: updateRevision },
  '#withUpdatedReplicas':: d.fn(help='"updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision."', args=[d.arg(name='updatedReplicas', type=d.T.integer)]),
  withUpdatedReplicas(updatedReplicas): { updatedReplicas: updatedReplicas },
  '#mixin': 'ignore',
  mixin: self,
}
