{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='daemonSet', url='', help='"DaemonSet represents the configuration of a daemon set."'),
  '#metadata':: d.obj(help='"ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create."'),
  metadata: {
    '#withAnnotations':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"', args=[d.arg(name='annotations', type=d.T.object)]),
    withAnnotations(annotations): { metadata+: { annotations: annotations } },
    '#withAnnotationsMixin':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='annotations', type=d.T.object)]),
    withAnnotationsMixin(annotations): { metadata+: { annotations+: annotations } },
    '#withCreationTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='creationTimestamp', type=d.T.string)]),
    withCreationTimestamp(creationTimestamp): { metadata+: { creationTimestamp: creationTimestamp } },
    '#withDeletionGracePeriodSeconds':: d.fn(help='"Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only."', args=[d.arg(name='deletionGracePeriodSeconds', type=d.T.integer)]),
    withDeletionGracePeriodSeconds(deletionGracePeriodSeconds): { metadata+: { deletionGracePeriodSeconds: deletionGracePeriodSeconds } },
    '#withDeletionTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='deletionTimestamp', type=d.T.string)]),
    withDeletionTimestamp(deletionTimestamp): { metadata+: { deletionTimestamp: deletionTimestamp } },
    '#withFinalizers':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."', args=[d.arg(name='finalizers', type=d.T.array)]),
    withFinalizers(finalizers): { metadata+: { finalizers: if std.isArray(v=finalizers) then finalizers else [finalizers] } },
    '#withFinalizersMixin':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='finalizers', type=d.T.array)]),
    withFinalizersMixin(finalizers): { metadata+: { finalizers+: if std.isArray(v=finalizers) then finalizers else [finalizers] } },
    '#withGenerateName':: d.fn(help='"GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\\n\\nIf this field is specified and the generated name exists, the server will return a 409.\\n\\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency"', args=[d.arg(name='generateName', type=d.T.string)]),
    withGenerateName(generateName): { metadata+: { generateName: generateName } },
    '#withGeneration':: d.fn(help='"A sequence number representing a specific generation of the desired state. Populated by the system. Read-only."', args=[d.arg(name='generation', type=d.T.integer)]),
    withGeneration(generation): { metadata+: { generation: generation } },
    '#withLabels':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"', args=[d.arg(name='labels', type=d.T.object)]),
    withLabels(labels): { metadata+: { labels: labels } },
    '#withLabelsMixin':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='labels', type=d.T.object)]),
    withLabelsMixin(labels): { metadata+: { labels+: labels } },
    '#withManagedFields':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"", args=[d.arg(name='managedFields', type=d.T.array)]),
    withManagedFields(managedFields): { metadata+: { managedFields: if std.isArray(v=managedFields) then managedFields else [managedFields] } },
    '#withManagedFieldsMixin':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='managedFields', type=d.T.array)]),
    withManagedFieldsMixin(managedFields): { metadata+: { managedFields+: if std.isArray(v=managedFields) then managedFields else [managedFields] } },
    '#withName':: d.fn(help='"Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names"', args=[d.arg(name='name', type=d.T.string)]),
    withName(name): { metadata+: { name: name } },
    '#withNamespace':: d.fn(help='"Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \\"default\\" namespace, but \\"default\\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\\n\\nMust be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces"', args=[d.arg(name='namespace', type=d.T.string)]),
    withNamespace(namespace): { metadata+: { namespace: namespace } },
    '#withOwnerReferences':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."', args=[d.arg(name='ownerReferences', type=d.T.array)]),
    withOwnerReferences(ownerReferences): { metadata+: { ownerReferences: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } },
    '#withOwnerReferencesMixin':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='ownerReferences', type=d.T.array)]),
    withOwnerReferencesMixin(ownerReferences): { metadata+: { ownerReferences+: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } },
    '#withResourceVersion':: d.fn(help='"An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\\n\\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
    withResourceVersion(resourceVersion): { metadata+: { resourceVersion: resourceVersion } },
    '#withSelfLink':: d.fn(help='"Deprecated: selfLink is a legacy read-only field that is no longer populated by the system."', args=[d.arg(name='selfLink', type=d.T.string)]),
    withSelfLink(selfLink): { metadata+: { selfLink: selfLink } },
    '#withUid':: d.fn(help='"UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\\n\\nPopulated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids"', args=[d.arg(name='uid', type=d.T.string)]),
    withUid(uid): { metadata+: { uid: uid } },
  },
  '#new':: d.fn(help='new returns an instance of DaemonSet', args=[d.arg(name='name', type=d.T.string)]),
  new(name): {
    apiVersion: 'apps/v1',
    kind: 'DaemonSet',
  } + self.metadata.withName(name=name),
  '#spec':: d.obj(help='"DaemonSetSpec is the specification of a daemon set."'),
  spec: {
    '#selector':: d.obj(help='"A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects."'),
    selector: {
      '#withMatchExpressions':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."', args=[d.arg(name='matchExpressions', type=d.T.array)]),
      withMatchExpressions(matchExpressions): { spec+: { selector+: { matchExpressions: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } },
      '#withMatchExpressionsMixin':: d.fn(help='"matchExpressions is a list of label selector requirements. The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchExpressions', type=d.T.array)]),
      withMatchExpressionsMixin(matchExpressions): { spec+: { selector+: { matchExpressions+: if std.isArray(v=matchExpressions) then matchExpressions else [matchExpressions] } } },
      '#withMatchLabels':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."', args=[d.arg(name='matchLabels', type=d.T.object)]),
      withMatchLabels(matchLabels): { spec+: { selector+: { matchLabels: matchLabels } } },
      '#withMatchLabelsMixin':: d.fn(help='"matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \\"key\\", the operator is \\"In\\", and the values array contains only \\"value\\". The requirements are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='matchLabels', type=d.T.object)]),
      withMatchLabelsMixin(matchLabels): { spec+: { selector+: { matchLabels+: matchLabels } } },
    },
    '#template':: d.obj(help='"PodTemplateSpec describes the data a pod should have when created from a template"'),
    template: {
      '#metadata':: d.obj(help='"ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create."'),
      metadata: {
        '#withAnnotations':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"', args=[d.arg(name='annotations', type=d.T.object)]),
        withAnnotations(annotations): { spec+: { template+: { metadata+: { annotations: annotations } } } },
        '#withAnnotationsMixin':: d.fn(help='"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='annotations', type=d.T.object)]),
        withAnnotationsMixin(annotations): { spec+: { template+: { metadata+: { annotations+: annotations } } } },
        '#withCreationTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='creationTimestamp', type=d.T.string)]),
        withCreationTimestamp(creationTimestamp): { spec+: { template+: { metadata+: { creationTimestamp: creationTimestamp } } } },
        '#withDeletionGracePeriodSeconds':: d.fn(help='"Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only."', args=[d.arg(name='deletionGracePeriodSeconds', type=d.T.integer)]),
        withDeletionGracePeriodSeconds(deletionGracePeriodSeconds): { spec+: { template+: { metadata+: { deletionGracePeriodSeconds: deletionGracePeriodSeconds } } } },
        '#withDeletionTimestamp':: d.fn(help='"Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers."', args=[d.arg(name='deletionTimestamp', type=d.T.string)]),
        withDeletionTimestamp(deletionTimestamp): { spec+: { template+: { metadata+: { deletionTimestamp: deletionTimestamp } } } },
        '#withFinalizers':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."', args=[d.arg(name='finalizers', type=d.T.array)]),
        withFinalizers(finalizers): { spec+: { template+: { metadata+: { finalizers: if std.isArray(v=finalizers) then finalizers else [finalizers] } } } },
        '#withFinalizersMixin':: d.fn(help='"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='finalizers', type=d.T.array)]),
        withFinalizersMixin(finalizers): { spec+: { template+: { metadata+: { finalizers+: if std.isArray(v=finalizers) then finalizers else [finalizers] } } } },
        '#withGenerateName':: d.fn(help='"GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\\n\\nIf this field is specified and the generated name exists, the server will return a 409.\\n\\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency"', args=[d.arg(name='generateName', type=d.T.string)]),
        withGenerateName(generateName): { spec+: { template+: { metadata+: { generateName: generateName } } } },
        '#withGeneration':: d.fn(help='"A sequence number representing a specific generation of the desired state. Populated by the system. Read-only."', args=[d.arg(name='generation', type=d.T.integer)]),
        withGeneration(generation): { spec+: { template+: { metadata+: { generation: generation } } } },
        '#withLabels':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"', args=[d.arg(name='labels', type=d.T.object)]),
        withLabels(labels): { spec+: { template+: { metadata+: { labels: labels } } } },
        '#withLabelsMixin':: d.fn(help='"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='labels', type=d.T.object)]),
        withLabelsMixin(labels): { spec+: { template+: { metadata+: { labels+: labels } } } },
        '#withManagedFields':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"", args=[d.arg(name='managedFields', type=d.T.array)]),
        withManagedFields(managedFields): { spec+: { template+: { metadata+: { managedFields: if std.isArray(v=managedFields) then managedFields else [managedFields] } } } },
        '#withManagedFieldsMixin':: d.fn(help="\"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \\\"ci-cd\\\". The set of fields is always in the version that the workflow used when modifying the object.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='managedFields', type=d.T.array)]),
        withManagedFieldsMixin(managedFields): { spec+: { template+: { metadata+: { managedFields+: if std.isArray(v=managedFields) then managedFields else [managedFields] } } } },
        '#withName':: d.fn(help='"Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names"', args=[d.arg(name='name', type=d.T.string)]),
        withName(name): { spec+: { template+: { metadata+: { name: name } } } },
        '#withNamespace':: d.fn(help='"Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \\"default\\" namespace, but \\"default\\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\\n\\nMust be a DNS_LABEL. Cannot be updated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces"', args=[d.arg(name='namespace', type=d.T.string)]),
        withNamespace(namespace): { spec+: { template+: { metadata+: { namespace: namespace } } } },
        '#withOwnerReferences':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."', args=[d.arg(name='ownerReferences', type=d.T.array)]),
        withOwnerReferences(ownerReferences): { spec+: { template+: { metadata+: { ownerReferences: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } } } },
        '#withOwnerReferencesMixin':: d.fn(help='"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='ownerReferences', type=d.T.array)]),
        withOwnerReferencesMixin(ownerReferences): { spec+: { template+: { metadata+: { ownerReferences+: if std.isArray(v=ownerReferences) then ownerReferences else [ownerReferences] } } } },
        '#withResourceVersion':: d.fn(help='"An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\\n\\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency"', args=[d.arg(name='resourceVersion', type=d.T.string)]),
        withResourceVersion(resourceVersion): { spec+: { template+: { metadata+: { resourceVersion: resourceVersion } } } },
        '#withSelfLink':: d.fn(help='"Deprecated: selfLink is a legacy read-only field that is no longer populated by the system."', args=[d.arg(name='selfLink', type=d.T.string)]),
        withSelfLink(selfLink): { spec+: { template+: { metadata+: { selfLink: selfLink } } } },
        '#withUid':: d.fn(help='"UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\\n\\nPopulated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids"', args=[d.arg(name='uid', type=d.T.string)]),
        withUid(uid): { spec+: { template+: { metadata+: { uid: uid } } } },
      },
      '#spec':: d.obj(help='"PodSpec is a description of a pod."'),
      spec: {
        '#affinity':: d.obj(help='"Affinity is a group of affinity scheduling rules."'),
        affinity: {
          '#nodeAffinity':: d.obj(help='"Node affinity is a group of node affinity scheduling rules."'),
          nodeAffinity: {
            '#requiredDuringSchedulingIgnoredDuringExecution':: d.obj(help='"A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms."'),
            requiredDuringSchedulingIgnoredDuringExecution: {
              '#withNodeSelectorTerms':: d.fn(help='"Required. A list of node selector terms. The terms are ORed."', args=[d.arg(name='nodeSelectorTerms', type=d.T.array)]),
              withNodeSelectorTerms(nodeSelectorTerms): { spec+: { template+: { spec+: { affinity+: { nodeAffinity+: { requiredDuringSchedulingIgnoredDuringExecution+: { nodeSelectorTerms: if std.isArray(v=nodeSelectorTerms) then nodeSelectorTerms else [nodeSelectorTerms] } } } } } } },
              '#withNodeSelectorTermsMixin':: d.fn(help='"Required. A list of node selector terms. The terms are ORed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='nodeSelectorTerms', type=d.T.array)]),
              withNodeSelectorTermsMixin(nodeSelectorTerms): { spec+: { template+: { spec+: { affinity+: { nodeAffinity+: { requiredDuringSchedulingIgnoredDuringExecution+: { nodeSelectorTerms+: if std.isArray(v=nodeSelectorTerms) then nodeSelectorTerms else [nodeSelectorTerms] } } } } } } },
            },
            '#withPreferredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred."', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withPreferredDuringSchedulingIgnoredDuringExecution(preferredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { nodeAffinity+: { preferredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } },
            '#withPreferredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withPreferredDuringSchedulingIgnoredDuringExecutionMixin(preferredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { nodeAffinity+: { preferredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } },
          },
          '#podAffinity':: d.obj(help='"Pod affinity is a group of inter pod affinity scheduling rules."'),
          podAffinity: {
            '#withPreferredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred."', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withPreferredDuringSchedulingIgnoredDuringExecution(preferredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { podAffinity+: { preferredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } },
            '#withPreferredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withPreferredDuringSchedulingIgnoredDuringExecutionMixin(preferredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { podAffinity+: { preferredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } },
            '#withRequiredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied."', args=[d.arg(name='requiredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withRequiredDuringSchedulingIgnoredDuringExecution(requiredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { podAffinity+: { requiredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=requiredDuringSchedulingIgnoredDuringExecution) then requiredDuringSchedulingIgnoredDuringExecution else [requiredDuringSchedulingIgnoredDuringExecution] } } } } } },
            '#withRequiredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='requiredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withRequiredDuringSchedulingIgnoredDuringExecutionMixin(requiredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { podAffinity+: { requiredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=requiredDuringSchedulingIgnoredDuringExecution) then requiredDuringSchedulingIgnoredDuringExecution else [requiredDuringSchedulingIgnoredDuringExecution] } } } } } },
          },
          '#podAntiAffinity':: d.obj(help='"Pod anti affinity is a group of inter pod anti affinity scheduling rules."'),
          podAntiAffinity: {
            '#withPreferredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred."', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withPreferredDuringSchedulingIgnoredDuringExecution(preferredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { podAntiAffinity+: { preferredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } },
            '#withPreferredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \\"weight\\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='preferredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withPreferredDuringSchedulingIgnoredDuringExecutionMixin(preferredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { podAntiAffinity+: { preferredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=preferredDuringSchedulingIgnoredDuringExecution) then preferredDuringSchedulingIgnoredDuringExecution else [preferredDuringSchedulingIgnoredDuringExecution] } } } } } },
            '#withRequiredDuringSchedulingIgnoredDuringExecution':: d.fn(help='"If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied."', args=[d.arg(name='requiredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withRequiredDuringSchedulingIgnoredDuringExecution(requiredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { podAntiAffinity+: { requiredDuringSchedulingIgnoredDuringExecution: if std.isArray(v=requiredDuringSchedulingIgnoredDuringExecution) then requiredDuringSchedulingIgnoredDuringExecution else [requiredDuringSchedulingIgnoredDuringExecution] } } } } } },
            '#withRequiredDuringSchedulingIgnoredDuringExecutionMixin':: d.fn(help='"If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='requiredDuringSchedulingIgnoredDuringExecution', type=d.T.array)]),
            withRequiredDuringSchedulingIgnoredDuringExecutionMixin(requiredDuringSchedulingIgnoredDuringExecution): { spec+: { template+: { spec+: { affinity+: { podAntiAffinity+: { requiredDuringSchedulingIgnoredDuringExecution+: if std.isArray(v=requiredDuringSchedulingIgnoredDuringExecution) then requiredDuringSchedulingIgnoredDuringExecution else [requiredDuringSchedulingIgnoredDuringExecution] } } } } } },
          },
        },
        '#dnsConfig':: d.obj(help='"PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy."'),
        dnsConfig: {
          '#withNameservers':: d.fn(help='"A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed."', args=[d.arg(name='nameservers', type=d.T.array)]),
          withNameservers(nameservers): { spec+: { template+: { spec+: { dnsConfig+: { nameservers: if std.isArray(v=nameservers) then nameservers else [nameservers] } } } } },
          '#withNameserversMixin':: d.fn(help='"A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='nameservers', type=d.T.array)]),
          withNameserversMixin(nameservers): { spec+: { template+: { spec+: { dnsConfig+: { nameservers+: if std.isArray(v=nameservers) then nameservers else [nameservers] } } } } },
          '#withOptions':: d.fn(help='"A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy."', args=[d.arg(name='options', type=d.T.array)]),
          withOptions(options): { spec+: { template+: { spec+: { dnsConfig+: { options: if std.isArray(v=options) then options else [options] } } } } },
          '#withOptionsMixin':: d.fn(help='"A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='options', type=d.T.array)]),
          withOptionsMixin(options): { spec+: { template+: { spec+: { dnsConfig+: { options+: if std.isArray(v=options) then options else [options] } } } } },
          '#withSearches':: d.fn(help='"A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed."', args=[d.arg(name='searches', type=d.T.array)]),
          withSearches(searches): { spec+: { template+: { spec+: { dnsConfig+: { searches: if std.isArray(v=searches) then searches else [searches] } } } } },
          '#withSearchesMixin':: d.fn(help='"A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='searches', type=d.T.array)]),
          withSearchesMixin(searches): { spec+: { template+: { spec+: { dnsConfig+: { searches+: if std.isArray(v=searches) then searches else [searches] } } } } },
        },
        '#os':: d.obj(help='"PodOS defines the OS parameters of a pod."'),
        os: {
          '#withName':: d.fn(help='"Name is the name of the operating system. The currently supported values are linux and windows. Additional value may be defined in future and can be one of: https://github.com/opencontainers/runtime-spec/blob/master/config.md#platform-specific-configuration Clients should expect to handle additional values and treat unrecognized values in this field as os: null"', args=[d.arg(name='name', type=d.T.string)]),
          withName(name): { spec+: { template+: { spec+: { os+: { name: name } } } } },
        },
        '#securityContext':: d.obj(help='"PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext."'),
        securityContext: {
          '#appArmorProfile':: d.obj(help="\"AppArmorProfile defines a pod or container's AppArmor settings.\""),
          appArmorProfile: {
            '#withLocalhostProfile':: d.fn(help='"localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is \\"Localhost\\"."', args=[d.arg(name='localhostProfile', type=d.T.string)]),
            withLocalhostProfile(localhostProfile): { spec+: { template+: { spec+: { securityContext+: { appArmorProfile+: { localhostProfile: localhostProfile } } } } } },
            '#withType':: d.fn(help="\"type indicates which kind of AppArmor profile will be applied. Valid options are:\\n  Localhost - a profile pre-loaded on the node.\\n  RuntimeDefault - the container runtime's default profile.\\n  Unconfined - no AppArmor enforcement.\"", args=[d.arg(name='type', type=d.T.string)]),
            withType(type): { spec+: { template+: { spec+: { securityContext+: { appArmorProfile+: { type: type } } } } } },
          },
          '#seLinuxOptions':: d.obj(help='"SELinuxOptions are the labels to be applied to the container"'),
          seLinuxOptions: {
            '#withLevel':: d.fn(help='"Level is SELinux level label that applies to the container."', args=[d.arg(name='level', type=d.T.string)]),
            withLevel(level): { spec+: { template+: { spec+: { securityContext+: { seLinuxOptions+: { level: level } } } } } },
            '#withRole':: d.fn(help='"Role is a SELinux role label that applies to the container."', args=[d.arg(name='role', type=d.T.string)]),
            withRole(role): { spec+: { template+: { spec+: { securityContext+: { seLinuxOptions+: { role: role } } } } } },
            '#withType':: d.fn(help='"Type is a SELinux type label that applies to the container."', args=[d.arg(name='type', type=d.T.string)]),
            withType(type): { spec+: { template+: { spec+: { securityContext+: { seLinuxOptions+: { type: type } } } } } },
            '#withUser':: d.fn(help='"User is a SELinux user label that applies to the container."', args=[d.arg(name='user', type=d.T.string)]),
            withUser(user): { spec+: { template+: { spec+: { securityContext+: { seLinuxOptions+: { user: user } } } } } },
          },
          '#seccompProfile':: d.obj(help="\"SeccompProfile defines a pod/container's seccomp profile settings. Only one profile source may be set.\""),
          seccompProfile: {
            '#withLocalhostProfile':: d.fn(help="\"localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must be set if type is \\\"Localhost\\\". Must NOT be set for any other type.\"", args=[d.arg(name='localhostProfile', type=d.T.string)]),
            withLocalhostProfile(localhostProfile): { spec+: { template+: { spec+: { securityContext+: { seccompProfile+: { localhostProfile: localhostProfile } } } } } },
            '#withType':: d.fn(help='"type indicates which kind of seccomp profile will be applied. Valid options are:\\n\\nLocalhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied."', args=[d.arg(name='type', type=d.T.string)]),
            withType(type): { spec+: { template+: { spec+: { securityContext+: { seccompProfile+: { type: type } } } } } },
          },
          '#windowsOptions':: d.obj(help='"WindowsSecurityContextOptions contain Windows-specific options and credentials."'),
          windowsOptions: {
            '#withGmsaCredentialSpec':: d.fn(help='"GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field."', args=[d.arg(name='gmsaCredentialSpec', type=d.T.string)]),
            withGmsaCredentialSpec(gmsaCredentialSpec): { spec+: { template+: { spec+: { securityContext+: { windowsOptions+: { gmsaCredentialSpec: gmsaCredentialSpec } } } } } },
            '#withGmsaCredentialSpecName':: d.fn(help='"GMSACredentialSpecName is the name of the GMSA credential spec to use."', args=[d.arg(name='gmsaCredentialSpecName', type=d.T.string)]),
            withGmsaCredentialSpecName(gmsaCredentialSpecName): { spec+: { template+: { spec+: { securityContext+: { windowsOptions+: { gmsaCredentialSpecName: gmsaCredentialSpecName } } } } } },
            '#withHostProcess':: d.fn(help="\"HostProcess determines if a container should be run as a 'Host Process' container. All of a Pod's containers must have the same effective HostProcess value (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers). In addition, if HostProcess is true then HostNetwork must also be set to true.\"", args=[d.arg(name='hostProcess', type=d.T.boolean)]),
            withHostProcess(hostProcess): { spec+: { template+: { spec+: { securityContext+: { windowsOptions+: { hostProcess: hostProcess } } } } } },
            '#withRunAsUserName':: d.fn(help='"The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence."', args=[d.arg(name='runAsUserName', type=d.T.string)]),
            withRunAsUserName(runAsUserName): { spec+: { template+: { spec+: { securityContext+: { windowsOptions+: { runAsUserName: runAsUserName } } } } } },
          },
          '#withFsGroup':: d.fn(help="\"A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:\\n\\n1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----\\n\\nIf unset, the Kubelet will not modify the ownership and permissions of any volume. Note that this field cannot be set when spec.os.name is windows.\"", args=[d.arg(name='fsGroup', type=d.T.integer)]),
          withFsGroup(fsGroup): { spec+: { template+: { spec+: { securityContext+: { fsGroup: fsGroup } } } } },
          '#withFsGroupChangePolicy':: d.fn(help='"fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are \\"OnRootMismatch\\" and \\"Always\\". If not specified, \\"Always\\" is used. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='fsGroupChangePolicy', type=d.T.string)]),
          withFsGroupChangePolicy(fsGroupChangePolicy): { spec+: { template+: { spec+: { securityContext+: { fsGroupChangePolicy: fsGroupChangePolicy } } } } },
          '#withRunAsGroup':: d.fn(help='"The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='runAsGroup', type=d.T.integer)]),
          withRunAsGroup(runAsGroup): { spec+: { template+: { spec+: { securityContext+: { runAsGroup: runAsGroup } } } } },
          '#withRunAsNonRoot':: d.fn(help='"Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence."', args=[d.arg(name='runAsNonRoot', type=d.T.boolean)]),
          withRunAsNonRoot(runAsNonRoot): { spec+: { template+: { spec+: { securityContext+: { runAsNonRoot: runAsNonRoot } } } } },
          '#withRunAsUser':: d.fn(help='"The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='runAsUser', type=d.T.integer)]),
          withRunAsUser(runAsUser): { spec+: { template+: { spec+: { securityContext+: { runAsUser: runAsUser } } } } },
          '#withSupplementalGroups':: d.fn(help="\"A list of groups applied to the first process run in each container, in addition to the container's primary GID, the fsGroup (if specified), and group memberships defined in the container image for the uid of the container process. If unspecified, no additional groups are added to any container. Note that group memberships defined in the container image for the uid of the container process are still effective, even if they are not included in this list. Note that this field cannot be set when spec.os.name is windows.\"", args=[d.arg(name='supplementalGroups', type=d.T.array)]),
          withSupplementalGroups(supplementalGroups): { spec+: { template+: { spec+: { securityContext+: { supplementalGroups: if std.isArray(v=supplementalGroups) then supplementalGroups else [supplementalGroups] } } } } },
          '#withSupplementalGroupsMixin':: d.fn(help="\"A list of groups applied to the first process run in each container, in addition to the container's primary GID, the fsGroup (if specified), and group memberships defined in the container image for the uid of the container process. If unspecified, no additional groups are added to any container. Note that group memberships defined in the container image for the uid of the container process are still effective, even if they are not included in this list. Note that this field cannot be set when spec.os.name is windows.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='supplementalGroups', type=d.T.array)]),
          withSupplementalGroupsMixin(supplementalGroups): { spec+: { template+: { spec+: { securityContext+: { supplementalGroups+: if std.isArray(v=supplementalGroups) then supplementalGroups else [supplementalGroups] } } } } },
          '#withSysctls':: d.fn(help='"Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Note that this field cannot be set when spec.os.name is windows."', args=[d.arg(name='sysctls', type=d.T.array)]),
          withSysctls(sysctls): { spec+: { template+: { spec+: { securityContext+: { sysctls: if std.isArray(v=sysctls) then sysctls else [sysctls] } } } } },
          '#withSysctlsMixin':: d.fn(help='"Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Note that this field cannot be set when spec.os.name is windows."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='sysctls', type=d.T.array)]),
          withSysctlsMixin(sysctls): { spec+: { template+: { spec+: { securityContext+: { sysctls+: if std.isArray(v=sysctls) then sysctls else [sysctls] } } } } },
        },
        '#withActiveDeadlineSeconds':: d.fn(help='"Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer."', args=[d.arg(name='activeDeadlineSeconds', type=d.T.integer)]),
        withActiveDeadlineSeconds(activeDeadlineSeconds): { spec+: { template+: { spec+: { activeDeadlineSeconds: activeDeadlineSeconds } } } },
        '#withAutomountServiceAccountToken':: d.fn(help='"AutomountServiceAccountToken indicates whether a service account token should be automatically mounted."', args=[d.arg(name='automountServiceAccountToken', type=d.T.boolean)]),
        withAutomountServiceAccountToken(automountServiceAccountToken): { spec+: { template+: { spec+: { automountServiceAccountToken: automountServiceAccountToken } } } },
        '#withContainers':: d.fn(help='"List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated."', args=[d.arg(name='containers', type=d.T.array)]),
        withContainers(containers): { spec+: { template+: { spec+: { containers: if std.isArray(v=containers) then containers else [containers] } } } },
        '#withContainersMixin':: d.fn(help='"List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='containers', type=d.T.array)]),
        withContainersMixin(containers): { spec+: { template+: { spec+: { containers+: if std.isArray(v=containers) then containers else [containers] } } } },
        '#withDnsPolicy':: d.fn(help="\"Set DNS policy for the pod. Defaults to \\\"ClusterFirst\\\". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.\"", args=[d.arg(name='dnsPolicy', type=d.T.string)]),
        withDnsPolicy(dnsPolicy): { spec+: { template+: { spec+: { dnsPolicy: dnsPolicy } } } },
        '#withEnableServiceLinks':: d.fn(help="\"EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links. Optional: Defaults to true.\"", args=[d.arg(name='enableServiceLinks', type=d.T.boolean)]),
        withEnableServiceLinks(enableServiceLinks): { spec+: { template+: { spec+: { enableServiceLinks: enableServiceLinks } } } },
        '#withEphemeralContainers':: d.fn(help="\"List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource.\"", args=[d.arg(name='ephemeralContainers', type=d.T.array)]),
        withEphemeralContainers(ephemeralContainers): { spec+: { template+: { spec+: { ephemeralContainers: if std.isArray(v=ephemeralContainers) then ephemeralContainers else [ephemeralContainers] } } } },
        '#withEphemeralContainersMixin':: d.fn(help="\"List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='ephemeralContainers', type=d.T.array)]),
        withEphemeralContainersMixin(ephemeralContainers): { spec+: { template+: { spec+: { ephemeralContainers+: if std.isArray(v=ephemeralContainers) then ephemeralContainers else [ephemeralContainers] } } } },
        '#withHostAliases':: d.fn(help="\"HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified.\"", args=[d.arg(name='hostAliases', type=d.T.array)]),
        withHostAliases(hostAliases): { spec+: { template+: { spec+: { hostAliases: if std.isArray(v=hostAliases) then hostAliases else [hostAliases] } } } },
        '#withHostAliasesMixin':: d.fn(help="\"HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='hostAliases', type=d.T.array)]),
        withHostAliasesMixin(hostAliases): { spec+: { template+: { spec+: { hostAliases+: if std.isArray(v=hostAliases) then hostAliases else [hostAliases] } } } },
        '#withHostIPC':: d.fn(help="\"Use the host's ipc namespace. Optional: Default to false.\"", args=[d.arg(name='hostIPC', type=d.T.boolean)]),
        withHostIPC(hostIPC): { spec+: { template+: { spec+: { hostIPC: hostIPC } } } },
        '#withHostNetwork':: d.fn(help="\"Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.\"", args=[d.arg(name='hostNetwork', type=d.T.boolean)]),
        withHostNetwork(hostNetwork): { spec+: { template+: { spec+: { hostNetwork: hostNetwork } } } },
        '#withHostPID':: d.fn(help="\"Use the host's pid namespace. Optional: Default to false.\"", args=[d.arg(name='hostPID', type=d.T.boolean)]),
        withHostPID(hostPID): { spec+: { template+: { spec+: { hostPID: hostPID } } } },
        '#withHostUsers':: d.fn(help="\"Use the host's user namespace. Optional: Default to true. If set to true or not present, the pod will be run in the host user namespace, useful for when the pod needs a feature only available to the host user namespace, such as loading a kernel module with CAP_SYS_MODULE. When set to false, a new userns is created for the pod. Setting false is useful for mitigating container breakout vulnerabilities even allowing users to run their containers as root without actually having root privileges on the host. This field is alpha-level and is only honored by servers that enable the UserNamespacesSupport feature.\"", args=[d.arg(name='hostUsers', type=d.T.boolean)]),
        withHostUsers(hostUsers): { spec+: { template+: { spec+: { hostUsers: hostUsers } } } },
        '#withHostname':: d.fn(help="\"Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.\"", args=[d.arg(name='hostname', type=d.T.string)]),
        withHostname(hostname): { spec+: { template+: { spec+: { hostname: hostname } } } },
        '#withImagePullSecrets':: d.fn(help='"ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod"', args=[d.arg(name='imagePullSecrets', type=d.T.array)]),
        withImagePullSecrets(imagePullSecrets): { spec+: { template+: { spec+: { imagePullSecrets: if std.isArray(v=imagePullSecrets) then imagePullSecrets else [imagePullSecrets] } } } },
        '#withImagePullSecretsMixin':: d.fn(help='"ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='imagePullSecrets', type=d.T.array)]),
        withImagePullSecretsMixin(imagePullSecrets): { spec+: { template+: { spec+: { imagePullSecrets+: if std.isArray(v=imagePullSecrets) then imagePullSecrets else [imagePullSecrets] } } } },
        '#withInitContainers':: d.fn(help='"List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/"', args=[d.arg(name='initContainers', type=d.T.array)]),
        withInitContainers(initContainers): { spec+: { template+: { spec+: { initContainers: if std.isArray(v=initContainers) then initContainers else [initContainers] } } } },
        '#withInitContainersMixin':: d.fn(help='"List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='initContainers', type=d.T.array)]),
        withInitContainersMixin(initContainers): { spec+: { template+: { spec+: { initContainers+: if std.isArray(v=initContainers) then initContainers else [initContainers] } } } },
        '#withNodeName':: d.fn(help='"NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements."', args=[d.arg(name='nodeName', type=d.T.string)]),
        withNodeName(nodeName): { spec+: { template+: { spec+: { nodeName: nodeName } } } },
        '#withNodeSelector':: d.fn(help="\"NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/\"", args=[d.arg(name='nodeSelector', type=d.T.object)]),
        withNodeSelector(nodeSelector): { spec+: { template+: { spec+: { nodeSelector: nodeSelector } } } },
        '#withNodeSelectorMixin':: d.fn(help="\"NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='nodeSelector', type=d.T.object)]),
        withNodeSelectorMixin(nodeSelector): { spec+: { template+: { spec+: { nodeSelector+: nodeSelector } } } },
        '#withOverhead':: d.fn(help='"Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md"', args=[d.arg(name='overhead', type=d.T.object)]),
        withOverhead(overhead): { spec+: { template+: { spec+: { overhead: overhead } } } },
        '#withOverheadMixin':: d.fn(help='"Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='overhead', type=d.T.object)]),
        withOverheadMixin(overhead): { spec+: { template+: { spec+: { overhead+: overhead } } } },
        '#withPreemptionPolicy':: d.fn(help='"PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset."', args=[d.arg(name='preemptionPolicy', type=d.T.string)]),
        withPreemptionPolicy(preemptionPolicy): { spec+: { template+: { spec+: { preemptionPolicy: preemptionPolicy } } } },
        '#withPriority':: d.fn(help='"The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority."', args=[d.arg(name='priority', type=d.T.integer)]),
        withPriority(priority): { spec+: { template+: { spec+: { priority: priority } } } },
        '#withPriorityClassName':: d.fn(help="\"If specified, indicates the pod's priority. \\\"system-node-critical\\\" and \\\"system-cluster-critical\\\" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.\"", args=[d.arg(name='priorityClassName', type=d.T.string)]),
        withPriorityClassName(priorityClassName): { spec+: { template+: { spec+: { priorityClassName: priorityClassName } } } },
        '#withReadinessGates':: d.fn(help='"If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to \\"True\\" More info: https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates"', args=[d.arg(name='readinessGates', type=d.T.array)]),
        withReadinessGates(readinessGates): { spec+: { template+: { spec+: { readinessGates: if std.isArray(v=readinessGates) then readinessGates else [readinessGates] } } } },
        '#withReadinessGatesMixin':: d.fn(help='"If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to \\"True\\" More info: https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='readinessGates', type=d.T.array)]),
        withReadinessGatesMixin(readinessGates): { spec+: { template+: { spec+: { readinessGates+: if std.isArray(v=readinessGates) then readinessGates else [readinessGates] } } } },
        '#withResourceClaims':: d.fn(help='"ResourceClaims defines which ResourceClaims must be allocated and reserved before the Pod is allowed to start. The resources will be made available to those containers which consume them by name.\\n\\nThis is an alpha field and requires enabling the DynamicResourceAllocation feature gate.\\n\\nThis field is immutable."', args=[d.arg(name='resourceClaims', type=d.T.array)]),
        withResourceClaims(resourceClaims): { spec+: { template+: { spec+: { resourceClaims: if std.isArray(v=resourceClaims) then resourceClaims else [resourceClaims] } } } },
        '#withResourceClaimsMixin':: d.fn(help='"ResourceClaims defines which ResourceClaims must be allocated and reserved before the Pod is allowed to start. The resources will be made available to those containers which consume them by name.\\n\\nThis is an alpha field and requires enabling the DynamicResourceAllocation feature gate.\\n\\nThis field is immutable."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='resourceClaims', type=d.T.array)]),
        withResourceClaimsMixin(resourceClaims): { spec+: { template+: { spec+: { resourceClaims+: if std.isArray(v=resourceClaims) then resourceClaims else [resourceClaims] } } } },
        '#withRestartPolicy':: d.fn(help='"Restart policy for all containers within the pod. One of Always, OnFailure, Never. In some contexts, only a subset of those values may be permitted. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy"', args=[d.arg(name='restartPolicy', type=d.T.string)]),
        withRestartPolicy(restartPolicy): { spec+: { template+: { spec+: { restartPolicy: restartPolicy } } } },
        '#withRuntimeClassName':: d.fn(help='"RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the \\"legacy\\" RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class"', args=[d.arg(name='runtimeClassName', type=d.T.string)]),
        withRuntimeClassName(runtimeClassName): { spec+: { template+: { spec+: { runtimeClassName: runtimeClassName } } } },
        '#withSchedulerName':: d.fn(help='"If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler."', args=[d.arg(name='schedulerName', type=d.T.string)]),
        withSchedulerName(schedulerName): { spec+: { template+: { spec+: { schedulerName: schedulerName } } } },
        '#withSchedulingGates':: d.fn(help='"SchedulingGates is an opaque list of values that if specified will block scheduling the pod. If schedulingGates is not empty, the pod will stay in the SchedulingGated state and the scheduler will not attempt to schedule the pod.\\n\\nSchedulingGates can only be set at pod creation time, and be removed only afterwards."', args=[d.arg(name='schedulingGates', type=d.T.array)]),
        withSchedulingGates(schedulingGates): { spec+: { template+: { spec+: { schedulingGates: if std.isArray(v=schedulingGates) then schedulingGates else [schedulingGates] } } } },
        '#withSchedulingGatesMixin':: d.fn(help='"SchedulingGates is an opaque list of values that if specified will block scheduling the pod. If schedulingGates is not empty, the pod will stay in the SchedulingGated state and the scheduler will not attempt to schedule the pod.\\n\\nSchedulingGates can only be set at pod creation time, and be removed only afterwards."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='schedulingGates', type=d.T.array)]),
        withSchedulingGatesMixin(schedulingGates): { spec+: { template+: { spec+: { schedulingGates+: if std.isArray(v=schedulingGates) then schedulingGates else [schedulingGates] } } } },
        '#withServiceAccount':: d.fn(help='"DeprecatedServiceAccount is a deprecated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead."', args=[d.arg(name='serviceAccount', type=d.T.string)]),
        withServiceAccount(serviceAccount): { spec+: { template+: { spec+: { serviceAccount: serviceAccount } } } },
        '#withServiceAccountName':: d.fn(help='"ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/"', args=[d.arg(name='serviceAccountName', type=d.T.string)]),
        withServiceAccountName(serviceAccountName): { spec+: { template+: { spec+: { serviceAccountName: serviceAccountName } } } },
        '#withSetHostnameAsFQDN':: d.fn(help="\"If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\\\SYSTEM\\\\CurrentControlSet\\\\Services\\\\Tcpip\\\\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.\"", args=[d.arg(name='setHostnameAsFQDN', type=d.T.boolean)]),
        withSetHostnameAsFQDN(setHostnameAsFQDN): { spec+: { template+: { spec+: { setHostnameAsFQDN: setHostnameAsFQDN } } } },
        '#withShareProcessNamespace':: d.fn(help='"Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false."', args=[d.arg(name='shareProcessNamespace', type=d.T.boolean)]),
        withShareProcessNamespace(shareProcessNamespace): { spec+: { template+: { spec+: { shareProcessNamespace: shareProcessNamespace } } } },
        '#withSubdomain':: d.fn(help='"If specified, the fully qualified Pod hostname will be \\"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\\". If not specified, the pod will not have a domainname at all."', args=[d.arg(name='subdomain', type=d.T.string)]),
        withSubdomain(subdomain): { spec+: { template+: { spec+: { subdomain: subdomain } } } },
        '#withTerminationGracePeriodSeconds':: d.fn(help='"Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds."', args=[d.arg(name='terminationGracePeriodSeconds', type=d.T.integer)]),
        withTerminationGracePeriodSeconds(terminationGracePeriodSeconds): { spec+: { template+: { spec+: { terminationGracePeriodSeconds: terminationGracePeriodSeconds } } } },
        '#withTolerations':: d.fn(help="\"If specified, the pod's tolerations.\"", args=[d.arg(name='tolerations', type=d.T.array)]),
        withTolerations(tolerations): { spec+: { template+: { spec+: { tolerations: if std.isArray(v=tolerations) then tolerations else [tolerations] } } } },
        '#withTolerationsMixin':: d.fn(help="\"If specified, the pod's tolerations.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='tolerations', type=d.T.array)]),
        withTolerationsMixin(tolerations): { spec+: { template+: { spec+: { tolerations+: if std.isArray(v=tolerations) then tolerations else [tolerations] } } } },
        '#withTopologySpreadConstraints':: d.fn(help='"TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed."', args=[d.arg(name='topologySpreadConstraints', type=d.T.array)]),
        withTopologySpreadConstraints(topologySpreadConstraints): { spec+: { template+: { spec+: { topologySpreadConstraints: if std.isArray(v=topologySpreadConstraints) then topologySpreadConstraints else [topologySpreadConstraints] } } } },
        '#withTopologySpreadConstraintsMixin':: d.fn(help='"TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='topologySpreadConstraints', type=d.T.array)]),
        withTopologySpreadConstraintsMixin(topologySpreadConstraints): { spec+: { template+: { spec+: { topologySpreadConstraints+: if std.isArray(v=topologySpreadConstraints) then topologySpreadConstraints else [topologySpreadConstraints] } } } },
        '#withVolumes':: d.fn(help='"List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes"', args=[d.arg(name='volumes', type=d.T.array)]),
        withVolumes(volumes): { spec+: { template+: { spec+: { volumes: if std.isArray(v=volumes) then volumes else [volumes] } } } },
        '#withVolumesMixin':: d.fn(help='"List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes"\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='volumes', type=d.T.array)]),
        withVolumesMixin(volumes): { spec+: { template+: { spec+: { volumes+: if std.isArray(v=volumes) then volumes else [volumes] } } } },
      },
    },
    '#updateStrategy':: d.obj(help='"DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet."'),
    updateStrategy: {
      '#rollingUpdate':: d.obj(help='"Spec to control the desired behavior of daemon set rolling update."'),
      rollingUpdate: {
        '#withMaxSurge':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='maxSurge', type=d.T.string)]),
        withMaxSurge(maxSurge): { spec+: { updateStrategy+: { rollingUpdate+: { maxSurge: maxSurge } } } },
        '#withMaxUnavailable':: d.fn(help='"IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number."', args=[d.arg(name='maxUnavailable', type=d.T.string)]),
        withMaxUnavailable(maxUnavailable): { spec+: { updateStrategy+: { rollingUpdate+: { maxUnavailable: maxUnavailable } } } },
      },
      '#withType':: d.fn(help='"Type of daemon set update. Can be \\"RollingUpdate\\" or \\"OnDelete\\". Default is RollingUpdate."', args=[d.arg(name='type', type=d.T.string)]),
      withType(type): { spec+: { updateStrategy+: { type: type } } },
    },
    '#withMinReadySeconds':: d.fn(help='"The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)."', args=[d.arg(name='minReadySeconds', type=d.T.integer)]),
    withMinReadySeconds(minReadySeconds): { spec+: { minReadySeconds: minReadySeconds } },
    '#withRevisionHistoryLimit':: d.fn(help='"The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10."', args=[d.arg(name='revisionHistoryLimit', type=d.T.integer)]),
    withRevisionHistoryLimit(revisionHistoryLimit): { spec+: { revisionHistoryLimit: revisionHistoryLimit } },
  },
  '#mixin': 'ignore',
  mixin: self,
}
