{
  local d = (import 'doc-util/main.libsonnet'),
  '#':: d.pkg(name='storageVersionStatus', url='', help='"API server instances report the versions they can decode and the version they encode objects to when persisting objects in the backend."'),
  '#withCommonEncodingVersion':: d.fn(help='"If all API server instances agree on the same encoding storage version, then this field is set to that version. Otherwise this field is left empty. API servers should finish updating its storageVersionStatus entry before serving write operations, so that this field will be in sync with the reality."', args=[d.arg(name='commonEncodingVersion', type=d.T.string)]),
  withCommonEncodingVersion(commonEncodingVersion): { commonEncodingVersion: commonEncodingVersion },
  '#withConditions':: d.fn(help="\"The latest available observations of the storageVersion's state.\"", args=[d.arg(name='conditions', type=d.T.array)]),
  withConditions(conditions): { conditions: if std.isArray(v=conditions) then conditions else [conditions] },
  '#withConditionsMixin':: d.fn(help="\"The latest available observations of the storageVersion's state.\"\n\n**Note:** This function appends passed data to existing values", args=[d.arg(name='conditions', type=d.T.array)]),
  withConditionsMixin(conditions): { conditions+: if std.isArray(v=conditions) then conditions else [conditions] },
  '#withStorageVersions':: d.fn(help='"The reported versions per API server instance."', args=[d.arg(name='storageVersions', type=d.T.array)]),
  withStorageVersions(storageVersions): { storageVersions: if std.isArray(v=storageVersions) then storageVersions else [storageVersions] },
  '#withStorageVersionsMixin':: d.fn(help='"The reported versions per API server instance."\n\n**Note:** This function appends passed data to existing values', args=[d.arg(name='storageVersions', type=d.T.array)]),
  withStorageVersionsMixin(storageVersions): { storageVersions+: if std.isArray(v=storageVersions) then storageVersions else [storageVersions] },
  '#mixin': 'ignore',
  mixin: self,
}
