---
date: 2024-12-15
slug: goreleaser-v2.5
categories: [announcements]
authors: [caarlos0]
---

# Announcing GoReleaser v2.5 - multi languages, 9th anniversary edition

Merry Christmas - the last release of 2024 is here!

<!-- more -->

This is hopefully the last big release of the year, and I think it's a good one!

## Rust and Zig joined the party!

![mascot party!](https://raw.githubusercontent.com/goreleaser/artwork/refs/heads/master/goreleaser_rust_zig_16_9.png)

The biggest highlight of this release surely is the start of the multi-language
support!

Over the years, more than once, I've seen comments saying something along the
lines of "I would love something like GoReleaser for <insert language>".

In fact, there are things like jReleaser, cargo-dist, rustreleaser, and probably
others, that are built based on some of GoReleaser's ideas.
As far as I know, all these projects are good and nice, and in fact, many years
ago, I had already refactored some of GoReleaser's codebase thinking about
adding more languages to it.

My idea at the time was to support plugins, so users could provide their own
builders.
I quickly realized, though, that Go plugin support is less than ideal, so I
kind of give that idea up, but left the refactor in there (and almost undo it a
few months ago).

But I digress... GoReleaser now officially, albeit in alpha, supports both
**Rust** and **Zig**!

You can use `goreleaser init` to create a configuration file and go from there.
It should detect that you are in a Rust project (if it has a `Cargo.toml`) file
or Zig project (if you have a `build.zig` file) automatically and initialize
accordingly.

But, in summary, you can do something like:

```yaml title=".goreleaser.yaml"
builds:
  - builder: rust # or zig
```

And it should already do _something_, with hopefully good defaults.

To add a few details: the Rust builder uses the excellent [cargo-zigbuild][] by
default, but you can change the configuration to use [cross][] as well.

On the other hand, the Zig builder uses its native `zig build` command.

In both cases, we're for now limiting to some targets that on our tests seemed
to work. If you disagree, please open an issue or hop in our [Discord][].

We also have example repositories for both: [example-rust][], [example-zig][].

Finally, Vedant made [goreleaser-rust-cross][], a Docker image with the
toolchains needed to cross compile Rust, which might be useful for some of you!

If you work with Zig and/or Rust, we'll be more than happy to have your feedback
and help improving all this!

### Thanks

This feature was quite a big undertaking, and while I'm sure it's not perfect,
it is something.

I want to thank [Raphael Amorim][rapha] for giving me the incentive I needed and
for helping reviewing it!

Also, [Vedant][vedant] for helping reviewing and asking many questions,
which helped shape the Rust integration quite a bit.

Finally, I want to thank the Go community, for using GoReleaser all these years,
and the Rust and Zig community for being (seemingly) open to the idea!

### What's next?

Probably more languages!
Join our [Discord][] and help prioritize and shape how they'll work.
I already created a [new discussion](https://github.com/orgs/goreleaser/discussions/5367)
on GitHub to help prioritize languages as well.
You are absolutely invited to chime in!

Once we stabilize all that, probably another major release refactoring some
things that are still too Go-centric (like the usage of `goos` nomenclature
everywhere).

## Testing on Windows

This is not technically in this release, but was added in v2.4.6 and is pretty
big/good news: we now run GoReleaser tests on Windows as well.

This should help reducing Windows-specific bugs - in fact, while doing that, I
already fixed some.

It was pretty painful to do this using VMs, so, if you use Windows and want to
help, please feel very welcome to! :)

## 9 years old!

December 21th marks the day of the [very first GoReleaser commit][first-commit].
The [first release][first-rel] came a couple of days later, on the 29th.

When I first started this, I had no idea it would last this long.

It has been a long, fun, and honoring ride! I met a lot of awesome people
through OpenSource, had a lot of opportunities I wouldn't have otherwise, and,
maybe more importantly, learned a lot!

Thank you all for being a part of it!

## Site and Logo

I experimented with some new logo designs, trying to make it less go-focused.

Our current logo is very good, in my opinion: it is playful, recognizable, looks
cute, all that good stuff.

<figure>
  <img src="https://github.com/user-attachments/assets/4f744ee9-895f-4ff2-a372-78fe3c418b0b" width="300px"/>
</figure>

Still, I tried some ideas to see how they would look like, but I didn't
think any of them would live up to the original one (you've seen one of them
in the beginning of the post), so, I'll keep it as is for now.

Our [homepage](https://goreleaser.com) got a relatively new look, though.
We reorganized some things, improved others, changed some colors, and, overall,
I think it looks better.

![New homepage design](https://github.com/user-attachments/assets/4c06ed2d-fb1b-48b6-9862-ad7a1cf28382)

All the artwork GoReleaser uses is made by [Carine Becker][carine], and is
available [here][artwork].

## Other Highlights

Most of the work in this release was around multi-language support, but
nevertheless, we have a few other news:

- **new**: `publishers.if` (only on [Pro][pro])
- **new**: AUR Sources integration
- **new**: webhooks `expected_status_codes`
- **new**: KOs can now build one time but publish to multiple registries[^crane]
- **new**: allow editing existent draft release on GitHub
- **fix**: we were using Homebrew's `on_arm` and `on_intel` constructs, but they
  shouldn't be used with `url` in it. So we changed back to checking
  `Hardware::CPU`. [Details](https://github.com/goreleaser/goreleaser/issues/5347)
- **deprecations**: we deprecated `builds.gobinary` in favor of `builds.tool`
  to be more language-agnostic, and `kos.registry` in favor of `kos.registries`
  to support multiple registries.
  [Details](/deprecations)

[^crane]:
    This is accomplished by using crane to copy from one registry to the
    others. Crane was already included as a dependency, so you don't need to
    install anything for it to work.

As always, bug fixes, dependency updates, housekeeping, and documentation
updates are included in this release as well.

## Other news

- GoReleaser now has ~14k stars and 413 contributors! Thanks, everyone!
- We eventually discuss new features in our Discord server. 
  [Join the conversation][discord]!
- nFPM had new releases as well, 
  [check it out](https://github.com/goreleaser/nfpm/releases).

## Download

You can [install][] or upgrade using your favorite package manager, or see the
full release notes and download the pre-compiled binaries [here][oss-rel] and
[here (for Pro)][pro-rel].

## Helping out

You can help by reporting issues, contributing features, documentation
improvements, and bug fixes.
You can also [sponsor the project](/sponsors), or get a
[GoReleaser Pro licence][pro].

[pro]: /pro
[install]: https://goreleaser.com/install
[pro-rel]: https://github.com/goreleaser/goreleaser-pro/releases/tag/v2.5.0-pro
[oss-rel]: https://github.com/goreleaser/goreleaser/releases/tag/v2.5.0
[discord]: https://goreleaser.com/discord
[cargo-zigbuild]: https://github.com/rust-cross/cargo-zigbuild
[cross]: https://github.com/cross-rs/cross
[example-rust]: https://github.com/goreleaser/example-rust/
[example-zig]: https://github.com/goreleaser/example-zig/
[goreleaser-rust-cross]: https://github.com/vedantmgoyal9/goreleaser-rust-cross
[first-commit]: https://github.com/goreleaser/goreleaser/commit/8b63e6555be45234c4c2a69576ca2ddab705302c
[first-rel]: https://github.com/goreleaser/goreleaser/releases/tag/v0.0.1
[rapha]: https://github.com/raphamorim
[vedant]: https://github.com/vedantmgoyal9
[carine]: https://github.com/carinebecker
[artwork]: https://github.com/goreleaser/artwork
