# NPM

<!-- md:version v2.8 -->

<!-- md:alpha -->

<!-- md:pro -->

The `npms` section configures how GoReleaser publishes your packages to NPM
registries.

## How it works

You can declare multiple NPM instances.
All binaries generated by your `builds` section will be available for use in
your NPM packages.

For each NPM configuration, GoReleaser will:

1. Generate a `package.json` file and other required scripts based on your
   configuration;
1. When the user `npm i -g` or `npx` your package, a `postinstall` script will
   download the archive, and extract/copy the binaries into the `./bin` folder;
1. Publish the package to a NPM registry (`npmjs.com` by default, customize with
   `npm config`).

## Options

```yaml
# .goreleaser.yaml
npms:
  - # ID of the resulting image.
    #
    # Default: the project name.
    id: foo

    # IDs of the archives to use.
    # Empty means all IDs.
    ids:
      - foo
      - bar

    # Package name.
    #
    # Required
    name: "@me/mypackage"

    # Your app's description.
    #
    # Templates: allowed.
    # Default: inferred from global metadata.
    description: My awesome npm package

    # Your app's homepage.
    #
    # Default: inferred from global metadata.
    homepage: https://example.org

    # Keywords for the package.
    keywords:
      - cli
      - golang
      - example

    # License name.
    #
    # Templates: allowed.
    # Required
    # Default: inferred from global metadata.
    license: MIT

    # Author of the package.
    #
    # Templates: allowed.
    # Default: inferred from global metadata.
    author: Your Name <your.email@example.com>

    # Repository URL.
    #
    # Templates: allowed.
    repository: https://github.com/foo/bar

    # URL to report bugs.
    #
    # Templates: allowed.
    bugs: https://github.com/foo/bar/issues

    # Additional files/globs you want to add to the package.
    #
    # Default: ["README*", "LICENSE*"]
    # Templates: allowed.
    extra_files:
      - glob: ./path/to/file.txt
        name_template: "file.txt"

    # Additional templated files to add to the app bundle.
    # Those files will have their contents pass through the template engine,
    # and its results will be added to the archive.
    # and/or to add more files.
    #
    # Templates: allowed.
    templated_extra_files:
      # src can also be a glob, as long as dst is a directory.
      - src: "LICENSE.md.tpl"
        dst: LICENSE.md

    # Access level: public or restricted.
    access: public

    # Package format: tar, tgz, tar.gz, zip, or binary.
    #
    # Required: if more than one archive format is being used.
    format: tgz

    # Allows to further filter the artifacts.
    #
    # Artifacts that do not match this expression will be ignored.
    #
    # Templates: allowed.
    if: '{{ eq .Os "linux" }}'

    # Disables the configuration.
    # Any value different of 'true' will be considered 'false'.
    #
    # Templates: allowed.
    disable: "{{ gt .Patch 0 }}"

    # URL which is determined by the given Token (github, gitlab or gitea).
    #
    # Default depends on the client.
    # Templates: allowed.
    # <!-- md:inline_version v2.10 -->.
    url_template: "https://github.mycompany.com/foo/bar/releases/download/{{ .Tag }}/{{ .ArtifactName }}"
```

!!! warning "Caveat"

    This will not work if the user installs with `--ignore-scripts`.

<!-- md:templates -->

## Supported platforms and formats

Initially, we are supporting the following platforms:

- `linux`: `amd64` and `arm64`
- `darwin`: `amd64` and `arm64`
- `windows`: `amd64` and `arm64`

And these archive formats:

- `tgz`, `tar.gz`
- `tar`
- `zip`
- `binary`

More formats and platforms might be added in the future.

## Why NPM?

Basically, to increase the distribution of your app.

Many people have `npm` and `npx` installed, and are used to
`npm i -g <package>`.

Its technically a hack, but works in most cases.

Its worth noting its still in an alpha state.
Feel free to provide feedback if you find issues or know ways in which it could
be improved.
