// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/support/v2/case_service.proto

package supportpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The request message for the GetCase endpoint.
type GetCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The fully qualified name of a case to be retrieved.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCaseRequest) Reset() {
	*x = GetCaseRequest{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCaseRequest) ProtoMessage() {}

func (x *GetCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCaseRequest.ProtoReflect.Descriptor instead.
func (*GetCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetCaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for the CreateCase endpoint.
type CreateCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Google Cloud Resource under which the case should
	// be created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The case to be created.
	Case *Case `protobuf:"bytes,2,opt,name=case,proto3" json:"case,omitempty"`
}

func (x *CreateCaseRequest) Reset() {
	*x = CreateCaseRequest{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCaseRequest) ProtoMessage() {}

func (x *CreateCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCaseRequest.ProtoReflect.Descriptor instead.
func (*CreateCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateCaseRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCaseRequest) GetCase() *Case {
	if x != nil {
		return x.Case
	}
	return nil
}

// The request message for the ListCases endpoint.
type ListCasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The fully qualified name of parent resource to list cases under.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression written in filter language. If non-empty, the query returns
	// the cases that match the filter. Else, the query doesn't filter the cases.
	//
	// Filter expressions use the following fields with the operators equals (`=`)
	// and `AND`:
	//
	// - `state`: The accepted values are `OPEN` or `CLOSED`.
	// - `priority`: The accepted values are `P0`, `P1`, `P2`, `P3`, or `P4`. You
	// can specify multiple values for priority using the `OR` operator. For
	// example, `priority=P1 OR priority=P2`.
	// - `creator.email`: The email address of the case creator.
	//
	// Examples:
	//
	// - `state=CLOSED`
	// - `state=OPEN AND creator.email="tester@example.com"`
	// - `state=OPEN AND (priority=P0 OR priority=P1)`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of cases fetched with each request. Defaults to 10.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return. If unspecified, the
	// first page is retrieved.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCasesRequest) Reset() {
	*x = ListCasesRequest{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCasesRequest) ProtoMessage() {}

func (x *ListCasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCasesRequest.ProtoReflect.Descriptor instead.
func (*ListCasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListCasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCasesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCasesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCasesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for the ListCases endpoint.
type ListCasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of cases associated with the Google Cloud Resource, after any
	// filters have been applied.
	Cases []*Case `protobuf:"bytes,1,rep,name=cases,proto3" json:"cases,omitempty"`
	// A token to retrieve the next page of results. This should be set in the
	// `page_token` field of the subsequent `ListCasesRequest` message that is
	// issued. If unspecified, there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCasesResponse) Reset() {
	*x = ListCasesResponse{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCasesResponse) ProtoMessage() {}

func (x *ListCasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCasesResponse.ProtoReflect.Descriptor instead.
func (*ListCasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListCasesResponse) GetCases() []*Case {
	if x != nil {
		return x.Cases
	}
	return nil
}

func (x *ListCasesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for the SearchCases endpoint.
type SearchCasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully qualified name of parent resource to search cases under.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression written in filter language.
	//
	// A query uses the following fields with the operators equals (`=`) and
	// `AND`:
	//
	// - `organization`: An organization name in the form
	// `organizations/<organization_id>`.
	// - `project`: A project name in the form `projects/<project_id>`.
	// - `state`: The accepted values are `OPEN` or `CLOSED`.
	// - `priority`: The accepted values are `P0`, `P1`, `P2`, `P3`, or `P4`. You
	// can specify multiple values for priority using the `OR` operator. For
	// example, `priority=P1 OR priority=P2`.
	// - `creator.email`: The email address of the case creator.
	// - `billingAccount`: A billing account in the form
	// `billingAccounts/<billing_account_id>`
	//
	// You must specify either `organization` or `project`.
	//
	// To search across `displayName`, `description`, and comments, use a global
	// restriction with no keyword or operator. For example, `"my search"`.
	//
	// To search only cases updated after a certain date, use `update_time`
	// restricted with that particular date, time, and timezone in ISO datetime
	// format. For example, `update_time>"2020-01-01T00:00:00-05:00"`.
	// `update_time` only supports the greater than operator (`>`).
	//
	// Examples:
	//
	// - `organization="organizations/123456789"`
	// - `project="projects/my-project-id"`
	// - `project="projects/123456789"`
	// - `billing_account="billingAccounts/123456-A0B0C0-CUZ789"`
	// - `organization="organizations/123456789" AND state=CLOSED`
	// - `project="projects/my-project-id" AND creator.email="tester@example.com"`
	// - `project="projects/my-project-id" AND (priority=P0 OR priority=P1)`
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of cases fetched with each request. The default page
	// size is 10.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return. If unspecified, the
	// first page is retrieved.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchCasesRequest) Reset() {
	*x = SearchCasesRequest{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchCasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCasesRequest) ProtoMessage() {}

func (x *SearchCasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCasesRequest.ProtoReflect.Descriptor instead.
func (*SearchCasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{4}
}

func (x *SearchCasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchCasesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchCasesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchCasesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for the SearchCases endpoint.
type SearchCasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of cases associated with the Google Cloud Resource, after any
	// filters have been applied.
	Cases []*Case `protobuf:"bytes,1,rep,name=cases,proto3" json:"cases,omitempty"`
	// A token to retrieve the next page of results. This should be set in the
	// `page_token` field of subsequent `SearchCaseRequest` message that is
	// issued. If unspecified, there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchCasesResponse) Reset() {
	*x = SearchCasesResponse{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchCasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCasesResponse) ProtoMessage() {}

func (x *SearchCasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCasesResponse.ProtoReflect.Descriptor instead.
func (*SearchCasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{5}
}

func (x *SearchCasesResponse) GetCases() []*Case {
	if x != nil {
		return x.Cases
	}
	return nil
}

func (x *SearchCasesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for the EscalateCase endpoint.
type EscalateCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The fully qualified name of the Case resource to be escalated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The escalation object to be sent with the escalation request.
	Escalation *Escalation `protobuf:"bytes,2,opt,name=escalation,proto3" json:"escalation,omitempty"`
}

func (x *EscalateCaseRequest) Reset() {
	*x = EscalateCaseRequest{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EscalateCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EscalateCaseRequest) ProtoMessage() {}

func (x *EscalateCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EscalateCaseRequest.ProtoReflect.Descriptor instead.
func (*EscalateCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{6}
}

func (x *EscalateCaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EscalateCaseRequest) GetEscalation() *Escalation {
	if x != nil {
		return x.Escalation
	}
	return nil
}

// The request message for the UpdateCase endpoint
type UpdateCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The case object to update.
	Case *Case `protobuf:"bytes,1,opt,name=case,proto3" json:"case,omitempty"`
	// A list of attributes of the case object that should be updated
	// as part of this request. Supported values are `priority`, `display_name`,
	// and `subscriber_email_addresses`. If no fields are specified, all supported
	// fields are updated.
	//
	// WARNING: If you do not provide a field mask, then you might accidentally
	// clear some fields. For example, if you leave the field mask empty and do
	// not provide a value for `subscriber_email_addresses`, then
	// `subscriber_email_addresses` is updated to empty.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCaseRequest) Reset() {
	*x = UpdateCaseRequest{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCaseRequest) ProtoMessage() {}

func (x *UpdateCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCaseRequest.ProtoReflect.Descriptor instead.
func (*UpdateCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateCaseRequest) GetCase() *Case {
	if x != nil {
		return x.Case
	}
	return nil
}

func (x *UpdateCaseRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for the CloseCase endpoint.
type CloseCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The fully qualified name of the case resource to be closed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CloseCaseRequest) Reset() {
	*x = CloseCaseRequest{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseCaseRequest) ProtoMessage() {}

func (x *CloseCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseCaseRequest.ProtoReflect.Descriptor instead.
func (*CloseCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{8}
}

func (x *CloseCaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for SearchCaseClassifications endpoint.
type SearchCaseClassificationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An expression written in the Google Cloud filter language. If non-empty,
	// then only cases whose fields match the filter are returned. If empty, then
	// no messages are filtered out.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of cases fetched with each request.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return. If unspecified, the
	// first page is retrieved.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchCaseClassificationsRequest) Reset() {
	*x = SearchCaseClassificationsRequest{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchCaseClassificationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCaseClassificationsRequest) ProtoMessage() {}

func (x *SearchCaseClassificationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCaseClassificationsRequest.ProtoReflect.Descriptor instead.
func (*SearchCaseClassificationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{9}
}

func (x *SearchCaseClassificationsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchCaseClassificationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchCaseClassificationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for SearchCaseClassifications endpoint.
type SearchCaseClassificationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The classifications retrieved.
	CaseClassifications []*CaseClassification `protobuf:"bytes,1,rep,name=case_classifications,json=caseClassifications,proto3" json:"case_classifications,omitempty"`
	// A token to retrieve the next page of results. This should be set in the
	// `page_token` field of subsequent `SearchCaseClassificationsRequest` message
	// that is issued. If unspecified, there are no more results to retrieve.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchCaseClassificationsResponse) Reset() {
	*x = SearchCaseClassificationsResponse{}
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchCaseClassificationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCaseClassificationsResponse) ProtoMessage() {}

func (x *SearchCaseClassificationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_support_v2_case_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCaseClassificationsResponse.ProtoReflect.Descriptor instead.
func (*SearchCaseClassificationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_support_v2_case_service_proto_rawDescGZIP(), []int{10}
}

func (x *SearchCaseClassificationsResponse) GetCaseClassifications() []*CaseClassification {
	if x != nil {
		return x.CaseClassifications
	}
	return nil
}

func (x *SearchCaseClassificationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_support_v2_case_service_proto protoreflect.FileDescriptor

var file_google_cloud_support_v2_case_service_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2f, 0x76,
	0x32, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4e, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61,
	0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8d, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x36, 0x0a, 0x04, 0x63, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x63, 0x61, 0x73, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x70, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x05, 0x63, 0x61, 0x73, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x52, 0x05, 0x63, 0x61, 0x73, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7e, 0x0a, 0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x72, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x05,
	0x63, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x52, 0x05, 0x63, 0x61, 0x73, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x13, 0x45, 0x73,
	0x63, 0x61, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x43, 0x0a, 0x0a, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x73,
	0x63, 0x61, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x63, 0x61,
	0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x63, 0x61,
	0x73, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x50, 0x0a, 0x10, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x74, 0x0a, 0x20, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x73, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xab, 0x01, 0x0a, 0x21, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x61, 0x73, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a,
	0x14, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x63, 0x61, 0x73, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xcf, 0x0c, 0x0a, 0x0b, 0x43, 0x61, 0x73, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa5, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x43, 0x61, 0x73,
	0x65, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x22, 0x52, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x1d,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01,
	0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x12, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x54, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x45, 0x5a, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x12, 0x1d, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x12, 0xc3, 0x01, 0x0a, 0x0b, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x61, 0x73, 0x65, 0x73, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x5a, 0x2b, 0x12, 0x29, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x73, 0x65,
	0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x24, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0xbe,
	0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65, 0x12, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61,
	0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x22, 0x65, 0xda, 0x41, 0x0b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x63, 0x61, 0x73, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x04,
	0x63, 0x61, 0x73, 0x65, 0x5a, 0x2a, 0x3a, 0x04, 0x63, 0x61, 0x73, 0x65, 0x22, 0x22, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73,
	0x22, 0x1d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x12,
	0xcd, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65, 0x12, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x22, 0x74, 0xda, 0x41, 0x10, 0x63, 0x61,
	0x73, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5b, 0x3a, 0x04, 0x63, 0x61, 0x73, 0x65, 0x5a, 0x2f, 0x3a, 0x04, 0x63, 0x61,
	0x73, 0x65, 0x32, 0x27, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x61, 0x73, 0x65, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x22, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x63, 0x61, 0x73, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc0, 0x01, 0x0a, 0x0c, 0x45, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65,
	0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x73, 0x63, 0x61, 0x6c,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x22, 0x63, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x01, 0x2a, 0x5a, 0x30, 0x3a, 0x01, 0x2a, 0x22, 0x2b, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x26, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x61,
	0x74, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x09, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x43, 0x61, 0x73, 0x65,
	0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6c, 0x6f, 0x73, 0x65,
	0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x61, 0x73, 0x65, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x57, 0x3a, 0x01, 0x2a, 0x5a, 0x2d, 0x3a, 0x01, 0x2a, 0x22, 0x28, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63,
	0x6c, 0x6f, 0x73, 0x65, 0x22, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x61, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x12, 0xba, 0x01, 0x0a, 0x19, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x73, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x73, 0x65, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x61, 0x73, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x61, 0x73, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x1a, 0x4f, 0xca, 0x41, 0x1b, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xb9, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x76, 0x32, 0x42, 0x10, 0x43, 0x61, 0x73, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x70, 0x62, 0x3b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x70, 0x62, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x17, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x3a,
	0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_support_v2_case_service_proto_rawDescOnce sync.Once
	file_google_cloud_support_v2_case_service_proto_rawDescData = file_google_cloud_support_v2_case_service_proto_rawDesc
)

func file_google_cloud_support_v2_case_service_proto_rawDescGZIP() []byte {
	file_google_cloud_support_v2_case_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_support_v2_case_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_support_v2_case_service_proto_rawDescData)
	})
	return file_google_cloud_support_v2_case_service_proto_rawDescData
}

var file_google_cloud_support_v2_case_service_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_support_v2_case_service_proto_goTypes = []any{
	(*GetCaseRequest)(nil),                    // 0: google.cloud.support.v2.GetCaseRequest
	(*CreateCaseRequest)(nil),                 // 1: google.cloud.support.v2.CreateCaseRequest
	(*ListCasesRequest)(nil),                  // 2: google.cloud.support.v2.ListCasesRequest
	(*ListCasesResponse)(nil),                 // 3: google.cloud.support.v2.ListCasesResponse
	(*SearchCasesRequest)(nil),                // 4: google.cloud.support.v2.SearchCasesRequest
	(*SearchCasesResponse)(nil),               // 5: google.cloud.support.v2.SearchCasesResponse
	(*EscalateCaseRequest)(nil),               // 6: google.cloud.support.v2.EscalateCaseRequest
	(*UpdateCaseRequest)(nil),                 // 7: google.cloud.support.v2.UpdateCaseRequest
	(*CloseCaseRequest)(nil),                  // 8: google.cloud.support.v2.CloseCaseRequest
	(*SearchCaseClassificationsRequest)(nil),  // 9: google.cloud.support.v2.SearchCaseClassificationsRequest
	(*SearchCaseClassificationsResponse)(nil), // 10: google.cloud.support.v2.SearchCaseClassificationsResponse
	(*Case)(nil),                              // 11: google.cloud.support.v2.Case
	(*Escalation)(nil),                        // 12: google.cloud.support.v2.Escalation
	(*fieldmaskpb.FieldMask)(nil),             // 13: google.protobuf.FieldMask
	(*CaseClassification)(nil),                // 14: google.cloud.support.v2.CaseClassification
}
var file_google_cloud_support_v2_case_service_proto_depIdxs = []int32{
	11, // 0: google.cloud.support.v2.CreateCaseRequest.case:type_name -> google.cloud.support.v2.Case
	11, // 1: google.cloud.support.v2.ListCasesResponse.cases:type_name -> google.cloud.support.v2.Case
	11, // 2: google.cloud.support.v2.SearchCasesResponse.cases:type_name -> google.cloud.support.v2.Case
	12, // 3: google.cloud.support.v2.EscalateCaseRequest.escalation:type_name -> google.cloud.support.v2.Escalation
	11, // 4: google.cloud.support.v2.UpdateCaseRequest.case:type_name -> google.cloud.support.v2.Case
	13, // 5: google.cloud.support.v2.UpdateCaseRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 6: google.cloud.support.v2.SearchCaseClassificationsResponse.case_classifications:type_name -> google.cloud.support.v2.CaseClassification
	0,  // 7: google.cloud.support.v2.CaseService.GetCase:input_type -> google.cloud.support.v2.GetCaseRequest
	2,  // 8: google.cloud.support.v2.CaseService.ListCases:input_type -> google.cloud.support.v2.ListCasesRequest
	4,  // 9: google.cloud.support.v2.CaseService.SearchCases:input_type -> google.cloud.support.v2.SearchCasesRequest
	1,  // 10: google.cloud.support.v2.CaseService.CreateCase:input_type -> google.cloud.support.v2.CreateCaseRequest
	7,  // 11: google.cloud.support.v2.CaseService.UpdateCase:input_type -> google.cloud.support.v2.UpdateCaseRequest
	6,  // 12: google.cloud.support.v2.CaseService.EscalateCase:input_type -> google.cloud.support.v2.EscalateCaseRequest
	8,  // 13: google.cloud.support.v2.CaseService.CloseCase:input_type -> google.cloud.support.v2.CloseCaseRequest
	9,  // 14: google.cloud.support.v2.CaseService.SearchCaseClassifications:input_type -> google.cloud.support.v2.SearchCaseClassificationsRequest
	11, // 15: google.cloud.support.v2.CaseService.GetCase:output_type -> google.cloud.support.v2.Case
	3,  // 16: google.cloud.support.v2.CaseService.ListCases:output_type -> google.cloud.support.v2.ListCasesResponse
	5,  // 17: google.cloud.support.v2.CaseService.SearchCases:output_type -> google.cloud.support.v2.SearchCasesResponse
	11, // 18: google.cloud.support.v2.CaseService.CreateCase:output_type -> google.cloud.support.v2.Case
	11, // 19: google.cloud.support.v2.CaseService.UpdateCase:output_type -> google.cloud.support.v2.Case
	11, // 20: google.cloud.support.v2.CaseService.EscalateCase:output_type -> google.cloud.support.v2.Case
	11, // 21: google.cloud.support.v2.CaseService.CloseCase:output_type -> google.cloud.support.v2.Case
	10, // 22: google.cloud.support.v2.CaseService.SearchCaseClassifications:output_type -> google.cloud.support.v2.SearchCaseClassificationsResponse
	15, // [15:23] is the sub-list for method output_type
	7,  // [7:15] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_support_v2_case_service_proto_init() }
func file_google_cloud_support_v2_case_service_proto_init() {
	if File_google_cloud_support_v2_case_service_proto != nil {
		return
	}
	file_google_cloud_support_v2_case_proto_init()
	file_google_cloud_support_v2_escalation_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_support_v2_case_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_support_v2_case_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_support_v2_case_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_support_v2_case_service_proto_msgTypes,
	}.Build()
	File_google_cloud_support_v2_case_service_proto = out.File
	file_google_cloud_support_v2_case_service_proto_rawDesc = nil
	file_google_cloud_support_v2_case_service_proto_goTypes = nil
	file_google_cloud_support_v2_case_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CaseServiceClient is the client API for CaseService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CaseServiceClient interface {
	// Retrieve the specified case.
	GetCase(ctx context.Context, in *GetCaseRequest, opts ...grpc.CallOption) (*Case, error)
	// Retrieve all cases under the specified parent.
	//
	// Note: Listing cases under an Organization returns only the cases directly
	// parented by that organization. To retrieve all cases under an organization,
	// including cases parented by projects under that organization, use
	// `cases.search`.
	ListCases(ctx context.Context, in *ListCasesRequest, opts ...grpc.CallOption) (*ListCasesResponse, error)
	// Search cases using the specified query.
	SearchCases(ctx context.Context, in *SearchCasesRequest, opts ...grpc.CallOption) (*SearchCasesResponse, error)
	// Create a new case and associate it with the given Google Cloud Resource.
	// The case object must have the following fields set: `display_name`,
	// `description`, `classification`, and `priority`.
	CreateCase(ctx context.Context, in *CreateCaseRequest, opts ...grpc.CallOption) (*Case, error)
	// Update the specified case. Only a subset of fields can be updated.
	UpdateCase(ctx context.Context, in *UpdateCaseRequest, opts ...grpc.CallOption) (*Case, error)
	// Escalate a case. Escalating a case will initiate the Google Cloud Support
	// escalation management process.
	//
	// This operation is only available to certain Customer Care tiers. Go to
	// https://cloud.google.com/support and look for 'Technical support
	// escalations' in the feature list to find out which tiers are able to
	// perform escalations.
	EscalateCase(ctx context.Context, in *EscalateCaseRequest, opts ...grpc.CallOption) (*Case, error)
	// Close the specified case.
	CloseCase(ctx context.Context, in *CloseCaseRequest, opts ...grpc.CallOption) (*Case, error)
	// Retrieve valid classifications to be used when creating a support case.
	// The classications are hierarchical, with each classification containing
	// all levels of the hierarchy, separated by " > ". For example "Technical
	// Issue > Compute > Compute Engine".
	SearchCaseClassifications(ctx context.Context, in *SearchCaseClassificationsRequest, opts ...grpc.CallOption) (*SearchCaseClassificationsResponse, error)
}

type caseServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCaseServiceClient(cc grpc.ClientConnInterface) CaseServiceClient {
	return &caseServiceClient{cc}
}

func (c *caseServiceClient) GetCase(ctx context.Context, in *GetCaseRequest, opts ...grpc.CallOption) (*Case, error) {
	out := new(Case)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v2.CaseService/GetCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *caseServiceClient) ListCases(ctx context.Context, in *ListCasesRequest, opts ...grpc.CallOption) (*ListCasesResponse, error) {
	out := new(ListCasesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v2.CaseService/ListCases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *caseServiceClient) SearchCases(ctx context.Context, in *SearchCasesRequest, opts ...grpc.CallOption) (*SearchCasesResponse, error) {
	out := new(SearchCasesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v2.CaseService/SearchCases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *caseServiceClient) CreateCase(ctx context.Context, in *CreateCaseRequest, opts ...grpc.CallOption) (*Case, error) {
	out := new(Case)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v2.CaseService/CreateCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *caseServiceClient) UpdateCase(ctx context.Context, in *UpdateCaseRequest, opts ...grpc.CallOption) (*Case, error) {
	out := new(Case)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v2.CaseService/UpdateCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *caseServiceClient) EscalateCase(ctx context.Context, in *EscalateCaseRequest, opts ...grpc.CallOption) (*Case, error) {
	out := new(Case)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v2.CaseService/EscalateCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *caseServiceClient) CloseCase(ctx context.Context, in *CloseCaseRequest, opts ...grpc.CallOption) (*Case, error) {
	out := new(Case)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v2.CaseService/CloseCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *caseServiceClient) SearchCaseClassifications(ctx context.Context, in *SearchCaseClassificationsRequest, opts ...grpc.CallOption) (*SearchCaseClassificationsResponse, error) {
	out := new(SearchCaseClassificationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.support.v2.CaseService/SearchCaseClassifications", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CaseServiceServer is the server API for CaseService service.
type CaseServiceServer interface {
	// Retrieve the specified case.
	GetCase(context.Context, *GetCaseRequest) (*Case, error)
	// Retrieve all cases under the specified parent.
	//
	// Note: Listing cases under an Organization returns only the cases directly
	// parented by that organization. To retrieve all cases under an organization,
	// including cases parented by projects under that organization, use
	// `cases.search`.
	ListCases(context.Context, *ListCasesRequest) (*ListCasesResponse, error)
	// Search cases using the specified query.
	SearchCases(context.Context, *SearchCasesRequest) (*SearchCasesResponse, error)
	// Create a new case and associate it with the given Google Cloud Resource.
	// The case object must have the following fields set: `display_name`,
	// `description`, `classification`, and `priority`.
	CreateCase(context.Context, *CreateCaseRequest) (*Case, error)
	// Update the specified case. Only a subset of fields can be updated.
	UpdateCase(context.Context, *UpdateCaseRequest) (*Case, error)
	// Escalate a case. Escalating a case will initiate the Google Cloud Support
	// escalation management process.
	//
	// This operation is only available to certain Customer Care tiers. Go to
	// https://cloud.google.com/support and look for 'Technical support
	// escalations' in the feature list to find out which tiers are able to
	// perform escalations.
	EscalateCase(context.Context, *EscalateCaseRequest) (*Case, error)
	// Close the specified case.
	CloseCase(context.Context, *CloseCaseRequest) (*Case, error)
	// Retrieve valid classifications to be used when creating a support case.
	// The classications are hierarchical, with each classification containing
	// all levels of the hierarchy, separated by " > ". For example "Technical
	// Issue > Compute > Compute Engine".
	SearchCaseClassifications(context.Context, *SearchCaseClassificationsRequest) (*SearchCaseClassificationsResponse, error)
}

// UnimplementedCaseServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCaseServiceServer struct {
}

func (*UnimplementedCaseServiceServer) GetCase(context.Context, *GetCaseRequest) (*Case, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCase not implemented")
}
func (*UnimplementedCaseServiceServer) ListCases(context.Context, *ListCasesRequest) (*ListCasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCases not implemented")
}
func (*UnimplementedCaseServiceServer) SearchCases(context.Context, *SearchCasesRequest) (*SearchCasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCases not implemented")
}
func (*UnimplementedCaseServiceServer) CreateCase(context.Context, *CreateCaseRequest) (*Case, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCase not implemented")
}
func (*UnimplementedCaseServiceServer) UpdateCase(context.Context, *UpdateCaseRequest) (*Case, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCase not implemented")
}
func (*UnimplementedCaseServiceServer) EscalateCase(context.Context, *EscalateCaseRequest) (*Case, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EscalateCase not implemented")
}
func (*UnimplementedCaseServiceServer) CloseCase(context.Context, *CloseCaseRequest) (*Case, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseCase not implemented")
}
func (*UnimplementedCaseServiceServer) SearchCaseClassifications(context.Context, *SearchCaseClassificationsRequest) (*SearchCaseClassificationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCaseClassifications not implemented")
}

func RegisterCaseServiceServer(s *grpc.Server, srv CaseServiceServer) {
	s.RegisterService(&_CaseService_serviceDesc, srv)
}

func _CaseService_GetCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CaseServiceServer).GetCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v2.CaseService/GetCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CaseServiceServer).GetCase(ctx, req.(*GetCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CaseService_ListCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CaseServiceServer).ListCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v2.CaseService/ListCases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CaseServiceServer).ListCases(ctx, req.(*ListCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CaseService_SearchCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CaseServiceServer).SearchCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v2.CaseService/SearchCases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CaseServiceServer).SearchCases(ctx, req.(*SearchCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CaseService_CreateCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CaseServiceServer).CreateCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v2.CaseService/CreateCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CaseServiceServer).CreateCase(ctx, req.(*CreateCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CaseService_UpdateCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CaseServiceServer).UpdateCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v2.CaseService/UpdateCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CaseServiceServer).UpdateCase(ctx, req.(*UpdateCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CaseService_EscalateCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EscalateCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CaseServiceServer).EscalateCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v2.CaseService/EscalateCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CaseServiceServer).EscalateCase(ctx, req.(*EscalateCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CaseService_CloseCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CaseServiceServer).CloseCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v2.CaseService/CloseCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CaseServiceServer).CloseCase(ctx, req.(*CloseCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CaseService_SearchCaseClassifications_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCaseClassificationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CaseServiceServer).SearchCaseClassifications(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.support.v2.CaseService/SearchCaseClassifications",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CaseServiceServer).SearchCaseClassifications(ctx, req.(*SearchCaseClassificationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CaseService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.support.v2.CaseService",
	HandlerType: (*CaseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCase",
			Handler:    _CaseService_GetCase_Handler,
		},
		{
			MethodName: "ListCases",
			Handler:    _CaseService_ListCases_Handler,
		},
		{
			MethodName: "SearchCases",
			Handler:    _CaseService_SearchCases_Handler,
		},
		{
			MethodName: "CreateCase",
			Handler:    _CaseService_CreateCase_Handler,
		},
		{
			MethodName: "UpdateCase",
			Handler:    _CaseService_UpdateCase_Handler,
		},
		{
			MethodName: "EscalateCase",
			Handler:    _CaseService_EscalateCase_Handler,
		},
		{
			MethodName: "CloseCase",
			Handler:    _CaseService_CloseCase_Handler,
		},
		{
			MethodName: "SearchCaseClassifications",
			Handler:    _CaseService_SearchCaseClassifications_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/support/v2/case_service.proto",
}
