// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/reviews/v1beta/productreviews_common.proto

package reviewspb

import (
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The method used to collect the review.
type ProductReviewAttributes_CollectionMethod int32

const (
	// Collection method unspecified.
	ProductReviewAttributes_COLLECTION_METHOD_UNSPECIFIED ProductReviewAttributes_CollectionMethod = 0
	// The user was not responding to a specific solicitation when they
	// submitted the review.
	ProductReviewAttributes_UNSOLICITED ProductReviewAttributes_CollectionMethod = 1
	// The user submitted the review in response to a solicitation after
	// fulfillment of the user's order.
	ProductReviewAttributes_POST_FULFILLMENT ProductReviewAttributes_CollectionMethod = 2
)

// Enum value maps for ProductReviewAttributes_CollectionMethod.
var (
	ProductReviewAttributes_CollectionMethod_name = map[int32]string{
		0: "COLLECTION_METHOD_UNSPECIFIED",
		1: "UNSOLICITED",
		2: "POST_FULFILLMENT",
	}
	ProductReviewAttributes_CollectionMethod_value = map[string]int32{
		"COLLECTION_METHOD_UNSPECIFIED": 0,
		"UNSOLICITED":                   1,
		"POST_FULFILLMENT":              2,
	}
)

func (x ProductReviewAttributes_CollectionMethod) Enum() *ProductReviewAttributes_CollectionMethod {
	p := new(ProductReviewAttributes_CollectionMethod)
	*p = x
	return p
}

func (x ProductReviewAttributes_CollectionMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProductReviewAttributes_CollectionMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_enumTypes[0].Descriptor()
}

func (ProductReviewAttributes_CollectionMethod) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_enumTypes[0]
}

func (x ProductReviewAttributes_CollectionMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProductReviewAttributes_CollectionMethod.Descriptor instead.
func (ProductReviewAttributes_CollectionMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescGZIP(), []int{0, 0}
}

// Type of the review URI.
type ProductReviewAttributes_ReviewLink_Type int32

const (
	// Type unspecified.
	ProductReviewAttributes_ReviewLink_TYPE_UNSPECIFIED ProductReviewAttributes_ReviewLink_Type = 0
	// The review page contains only this single review.
	ProductReviewAttributes_ReviewLink_SINGLETON ProductReviewAttributes_ReviewLink_Type = 1
	// The review page contains a group of reviews including this review.
	ProductReviewAttributes_ReviewLink_GROUP ProductReviewAttributes_ReviewLink_Type = 2
)

// Enum value maps for ProductReviewAttributes_ReviewLink_Type.
var (
	ProductReviewAttributes_ReviewLink_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SINGLETON",
		2: "GROUP",
	}
	ProductReviewAttributes_ReviewLink_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SINGLETON":        1,
		"GROUP":            2,
	}
)

func (x ProductReviewAttributes_ReviewLink_Type) Enum() *ProductReviewAttributes_ReviewLink_Type {
	p := new(ProductReviewAttributes_ReviewLink_Type)
	*p = x
	return p
}

func (x ProductReviewAttributes_ReviewLink_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProductReviewAttributes_ReviewLink_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_enumTypes[1].Descriptor()
}

func (ProductReviewAttributes_ReviewLink_Type) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_enumTypes[1]
}

func (x ProductReviewAttributes_ReviewLink_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProductReviewAttributes_ReviewLink_Type.Descriptor instead.
func (ProductReviewAttributes_ReviewLink_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescGZIP(), []int{0, 0, 0}
}

// How the issue affects the serving of the product review.
type ProductReviewStatus_ProductReviewItemLevelIssue_Severity int32

const (
	// Not specified.
	ProductReviewStatus_ProductReviewItemLevelIssue_SEVERITY_UNSPECIFIED ProductReviewStatus_ProductReviewItemLevelIssue_Severity = 0
	// This issue represents a warning and does not have a direct affect
	// on the product review.
	ProductReviewStatus_ProductReviewItemLevelIssue_NOT_IMPACTED ProductReviewStatus_ProductReviewItemLevelIssue_Severity = 1
	// Issue disapproves the product review.
	ProductReviewStatus_ProductReviewItemLevelIssue_DISAPPROVED ProductReviewStatus_ProductReviewItemLevelIssue_Severity = 2
)

// Enum value maps for ProductReviewStatus_ProductReviewItemLevelIssue_Severity.
var (
	ProductReviewStatus_ProductReviewItemLevelIssue_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "NOT_IMPACTED",
		2: "DISAPPROVED",
	}
	ProductReviewStatus_ProductReviewItemLevelIssue_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"NOT_IMPACTED":         1,
		"DISAPPROVED":          2,
	}
)

func (x ProductReviewStatus_ProductReviewItemLevelIssue_Severity) Enum() *ProductReviewStatus_ProductReviewItemLevelIssue_Severity {
	p := new(ProductReviewStatus_ProductReviewItemLevelIssue_Severity)
	*p = x
	return p
}

func (x ProductReviewStatus_ProductReviewItemLevelIssue_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProductReviewStatus_ProductReviewItemLevelIssue_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_enumTypes[2].Descriptor()
}

func (ProductReviewStatus_ProductReviewItemLevelIssue_Severity) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_enumTypes[2]
}

func (x ProductReviewStatus_ProductReviewItemLevelIssue_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProductReviewStatus_ProductReviewItemLevelIssue_Severity.Descriptor instead.
func (ProductReviewStatus_ProductReviewItemLevelIssue_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescGZIP(), []int{1, 1, 0}
}

// Attributes.
type ProductReviewAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the aggregator of the product reviews.
	//
	// A publisher may use a reviews aggregator to manage reviews and provide
	// the feeds. This element indicates the use of an aggregator and contains
	// information about the aggregator.
	AggregatorName *string `protobuf:"bytes,1,opt,name=aggregator_name,json=aggregatorName,proto3,oneof" json:"aggregator_name,omitempty"`
	// Optional. The name of the subclient of the product reviews.
	//
	// The subclient is an identifier of the product review source.
	// It should be equivalent to the directory provided in the file data source
	// path.
	SubclientName *string `protobuf:"bytes,2,opt,name=subclient_name,json=subclientName,proto3,oneof" json:"subclient_name,omitempty"`
	// Optional. The name of the publisher of the product reviews.
	//
	// The information about the publisher, which may be a retailer,
	// manufacturer, reviews service company, or any entity that publishes
	// product reviews.
	PublisherName *string `protobuf:"bytes,3,opt,name=publisher_name,json=publisherName,proto3,oneof" json:"publisher_name,omitempty"`
	// Optional. A link to the company favicon of the publisher. The image
	// dimensions should be favicon size: 16x16 pixels. The image format should be
	// GIF, JPG or PNG.
	PublisherFavicon *string `protobuf:"bytes,4,opt,name=publisher_favicon,json=publisherFavicon,proto3,oneof" json:"publisher_favicon,omitempty"`
	// Optional. The author of the product review.
	//
	// A permanent, unique identifier for the author of the review in the
	// publisher's system.
	ReviewerId *string `protobuf:"bytes,5,opt,name=reviewer_id,json=reviewerId,proto3,oneof" json:"reviewer_id,omitempty"`
	// Optional. Set to true if the reviewer should remain anonymous.
	ReviewerIsAnonymous *bool `protobuf:"varint,6,opt,name=reviewer_is_anonymous,json=reviewerIsAnonymous,proto3,oneof" json:"reviewer_is_anonymous,omitempty"`
	// Optional. The name of the reviewer of the product review.
	ReviewerUsername *string `protobuf:"bytes,7,opt,name=reviewer_username,json=reviewerUsername,proto3,oneof" json:"reviewer_username,omitempty"`
	// Optional. The language of the review defined by BCP-47 language code.
	ReviewLanguage *string `protobuf:"bytes,8,opt,name=review_language,json=reviewLanguage,proto3,oneof" json:"review_language,omitempty"`
	// Optional. The country of the review defined by ISO 3166-1 Alpha-2 Country
	// Code.
	ReviewCountry *string `protobuf:"bytes,9,opt,name=review_country,json=reviewCountry,proto3,oneof" json:"review_country,omitempty"`
	// Required. The timestamp indicating when the review was written.
	ReviewTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=review_time,json=reviewTime,proto3" json:"review_time,omitempty"`
	// Optional. The title of the review.
	Title *string `protobuf:"bytes,11,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Required. The content of the review.
	Content *string `protobuf:"bytes,12,opt,name=content,proto3,oneof" json:"content,omitempty"`
	// Optional. Contains the advantages based on the opinion of the reviewer.
	// Omit boilerplate text like "pro:" unless it was written by the reviewer.
	Pros []string `protobuf:"bytes,13,rep,name=pros,proto3" json:"pros,omitempty"`
	// Optional. Contains the disadvantages based on the opinion of the reviewer.
	// Omit boilerplate text like "con:" unless it was written by the reviewer.
	Cons []string `protobuf:"bytes,14,rep,name=cons,proto3" json:"cons,omitempty"`
	// Optional. The URI of the review landing page.
	ReviewLink *ProductReviewAttributes_ReviewLink `protobuf:"bytes,15,opt,name=review_link,json=reviewLink,proto3" json:"review_link,omitempty"`
	// Optional. A URI to an image of the reviewed product created by the review
	// author. The URI does not have to end with an image file extension.
	ReviewerImageLinks []string `protobuf:"bytes,16,rep,name=reviewer_image_links,json=reviewerImageLinks,proto3" json:"reviewer_image_links,omitempty"`
	// Optional. Contains the ratings associated with the review.
	// The minimum possible number for the rating. This should be the worst
	// possible rating and should not be a value for no rating.
	MinRating *int64 `protobuf:"varint,17,opt,name=min_rating,json=minRating,proto3,oneof" json:"min_rating,omitempty"`
	// Optional. The maximum possible number for the rating. The value of the max
	// rating must be greater than the value of the min attribute.
	MaxRating *int64 `protobuf:"varint,18,opt,name=max_rating,json=maxRating,proto3,oneof" json:"max_rating,omitempty"`
	// Optional. The reviewer's overall rating of the product.
	Rating *float64 `protobuf:"fixed64,19,opt,name=rating,proto3,oneof" json:"rating,omitempty"`
	// Optional. Descriptive name of a product.
	ProductNames []string `protobuf:"bytes,20,rep,name=product_names,json=productNames,proto3" json:"product_names,omitempty"`
	// Optional. The URI of the product. This URI can have the same value as the
	// `review_link` element, if the review URI and the product URI are the
	// same.
	ProductLinks []string `protobuf:"bytes,21,rep,name=product_links,json=productLinks,proto3" json:"product_links,omitempty"`
	// Optional. Contains ASINs (Amazon Standard Identification Numbers)
	// associated with a product.
	Asins []string `protobuf:"bytes,22,rep,name=asins,proto3" json:"asins,omitempty"`
	// Optional. Contains GTINs (global trade item numbers) associated with a
	// product. Sub-types of GTINs (e.g. UPC, EAN, ISBN, JAN) are supported.
	Gtins []string `protobuf:"bytes,23,rep,name=gtins,proto3" json:"gtins,omitempty"`
	// Optional. Contains MPNs (manufacturer part numbers) associated with a
	// product.
	Mpns []string `protobuf:"bytes,24,rep,name=mpns,proto3" json:"mpns,omitempty"`
	// Optional. Contains SKUs (stock keeping units) associated with a product.
	// Often this matches the product Offer Id in the product feed.
	Skus []string `protobuf:"bytes,25,rep,name=skus,proto3" json:"skus,omitempty"`
	// Optional. Contains brand names associated with a product.
	Brands []string `protobuf:"bytes,26,rep,name=brands,proto3" json:"brands,omitempty"`
	// Optional. Indicates whether the review is marked as spam in the publisher's
	// system.
	IsSpam *bool `protobuf:"varint,27,opt,name=is_spam,json=isSpam,proto3,oneof" json:"is_spam,omitempty"`
	// Optional. The method used to collect the review.
	CollectionMethod ProductReviewAttributes_CollectionMethod `protobuf:"varint,28,opt,name=collection_method,json=collectionMethod,proto3,enum=google.shopping.merchant.reviews.v1beta.ProductReviewAttributes_CollectionMethod" json:"collection_method,omitempty"`
	// Optional. A permanent, unique identifier for the transaction associated
	// with the review in the publisher's system. This ID can be used to indicate
	// that multiple reviews are associated with the same transaction.
	TransactionId string `protobuf:"bytes,29,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
}

func (x *ProductReviewAttributes) Reset() {
	*x = ProductReviewAttributes{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProductReviewAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductReviewAttributes) ProtoMessage() {}

func (x *ProductReviewAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductReviewAttributes.ProtoReflect.Descriptor instead.
func (*ProductReviewAttributes) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescGZIP(), []int{0}
}

func (x *ProductReviewAttributes) GetAggregatorName() string {
	if x != nil && x.AggregatorName != nil {
		return *x.AggregatorName
	}
	return ""
}

func (x *ProductReviewAttributes) GetSubclientName() string {
	if x != nil && x.SubclientName != nil {
		return *x.SubclientName
	}
	return ""
}

func (x *ProductReviewAttributes) GetPublisherName() string {
	if x != nil && x.PublisherName != nil {
		return *x.PublisherName
	}
	return ""
}

func (x *ProductReviewAttributes) GetPublisherFavicon() string {
	if x != nil && x.PublisherFavicon != nil {
		return *x.PublisherFavicon
	}
	return ""
}

func (x *ProductReviewAttributes) GetReviewerId() string {
	if x != nil && x.ReviewerId != nil {
		return *x.ReviewerId
	}
	return ""
}

func (x *ProductReviewAttributes) GetReviewerIsAnonymous() bool {
	if x != nil && x.ReviewerIsAnonymous != nil {
		return *x.ReviewerIsAnonymous
	}
	return false
}

func (x *ProductReviewAttributes) GetReviewerUsername() string {
	if x != nil && x.ReviewerUsername != nil {
		return *x.ReviewerUsername
	}
	return ""
}

func (x *ProductReviewAttributes) GetReviewLanguage() string {
	if x != nil && x.ReviewLanguage != nil {
		return *x.ReviewLanguage
	}
	return ""
}

func (x *ProductReviewAttributes) GetReviewCountry() string {
	if x != nil && x.ReviewCountry != nil {
		return *x.ReviewCountry
	}
	return ""
}

func (x *ProductReviewAttributes) GetReviewTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReviewTime
	}
	return nil
}

func (x *ProductReviewAttributes) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *ProductReviewAttributes) GetContent() string {
	if x != nil && x.Content != nil {
		return *x.Content
	}
	return ""
}

func (x *ProductReviewAttributes) GetPros() []string {
	if x != nil {
		return x.Pros
	}
	return nil
}

func (x *ProductReviewAttributes) GetCons() []string {
	if x != nil {
		return x.Cons
	}
	return nil
}

func (x *ProductReviewAttributes) GetReviewLink() *ProductReviewAttributes_ReviewLink {
	if x != nil {
		return x.ReviewLink
	}
	return nil
}

func (x *ProductReviewAttributes) GetReviewerImageLinks() []string {
	if x != nil {
		return x.ReviewerImageLinks
	}
	return nil
}

func (x *ProductReviewAttributes) GetMinRating() int64 {
	if x != nil && x.MinRating != nil {
		return *x.MinRating
	}
	return 0
}

func (x *ProductReviewAttributes) GetMaxRating() int64 {
	if x != nil && x.MaxRating != nil {
		return *x.MaxRating
	}
	return 0
}

func (x *ProductReviewAttributes) GetRating() float64 {
	if x != nil && x.Rating != nil {
		return *x.Rating
	}
	return 0
}

func (x *ProductReviewAttributes) GetProductNames() []string {
	if x != nil {
		return x.ProductNames
	}
	return nil
}

func (x *ProductReviewAttributes) GetProductLinks() []string {
	if x != nil {
		return x.ProductLinks
	}
	return nil
}

func (x *ProductReviewAttributes) GetAsins() []string {
	if x != nil {
		return x.Asins
	}
	return nil
}

func (x *ProductReviewAttributes) GetGtins() []string {
	if x != nil {
		return x.Gtins
	}
	return nil
}

func (x *ProductReviewAttributes) GetMpns() []string {
	if x != nil {
		return x.Mpns
	}
	return nil
}

func (x *ProductReviewAttributes) GetSkus() []string {
	if x != nil {
		return x.Skus
	}
	return nil
}

func (x *ProductReviewAttributes) GetBrands() []string {
	if x != nil {
		return x.Brands
	}
	return nil
}

func (x *ProductReviewAttributes) GetIsSpam() bool {
	if x != nil && x.IsSpam != nil {
		return *x.IsSpam
	}
	return false
}

func (x *ProductReviewAttributes) GetCollectionMethod() ProductReviewAttributes_CollectionMethod {
	if x != nil {
		return x.CollectionMethod
	}
	return ProductReviewAttributes_COLLECTION_METHOD_UNSPECIFIED
}

func (x *ProductReviewAttributes) GetTransactionId() string {
	if x != nil {
		return x.TransactionId
	}
	return ""
}

// Product review status.
type ProductReviewStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The intended destinations for the product review.
	DestinationStatuses []*ProductReviewStatus_ProductReviewDestinationStatus `protobuf:"bytes,3,rep,name=destination_statuses,json=destinationStatuses,proto3" json:"destination_statuses,omitempty"`
	// Output only. A list of all issues associated with the product review.
	ItemLevelIssues []*ProductReviewStatus_ProductReviewItemLevelIssue `protobuf:"bytes,4,rep,name=item_level_issues,json=itemLevelIssues,proto3" json:"item_level_issues,omitempty"`
	// Output only. Date on which the item has been created, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Date on which the item has been last updated, in [ISO
	// 8601](http://en.wikipedia.org/wiki/ISO_8601) format.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
}

func (x *ProductReviewStatus) Reset() {
	*x = ProductReviewStatus{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProductReviewStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductReviewStatus) ProtoMessage() {}

func (x *ProductReviewStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductReviewStatus.ProtoReflect.Descriptor instead.
func (*ProductReviewStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescGZIP(), []int{1}
}

func (x *ProductReviewStatus) GetDestinationStatuses() []*ProductReviewStatus_ProductReviewDestinationStatus {
	if x != nil {
		return x.DestinationStatuses
	}
	return nil
}

func (x *ProductReviewStatus) GetItemLevelIssues() []*ProductReviewStatus_ProductReviewItemLevelIssue {
	if x != nil {
		return x.ItemLevelIssues
	}
	return nil
}

func (x *ProductReviewStatus) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ProductReviewStatus) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

// The URI of the review landing page.
type ProductReviewAttributes_ReviewLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Type of the review URI.
	Type ProductReviewAttributes_ReviewLink_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.shopping.merchant.reviews.v1beta.ProductReviewAttributes_ReviewLink_Type" json:"type,omitempty"`
	// Optional. The URI of the review landing page.
	// For example: `http://www.example.com/review_5.html`.
	Link string `protobuf:"bytes,2,opt,name=link,proto3" json:"link,omitempty"`
}

func (x *ProductReviewAttributes_ReviewLink) Reset() {
	*x = ProductReviewAttributes_ReviewLink{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProductReviewAttributes_ReviewLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductReviewAttributes_ReviewLink) ProtoMessage() {}

func (x *ProductReviewAttributes_ReviewLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductReviewAttributes_ReviewLink.ProtoReflect.Descriptor instead.
func (*ProductReviewAttributes_ReviewLink) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ProductReviewAttributes_ReviewLink) GetType() ProductReviewAttributes_ReviewLink_Type {
	if x != nil {
		return x.Type
	}
	return ProductReviewAttributes_ReviewLink_TYPE_UNSPECIFIED
}

func (x *ProductReviewAttributes_ReviewLink) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

// The destination status of the product review status.
type ProductReviewStatus_ProductReviewDestinationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the reporting context.
	ReportingContext typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,1,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum" json:"reporting_context,omitempty"`
}

func (x *ProductReviewStatus_ProductReviewDestinationStatus) Reset() {
	*x = ProductReviewStatus_ProductReviewDestinationStatus{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProductReviewStatus_ProductReviewDestinationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductReviewStatus_ProductReviewDestinationStatus) ProtoMessage() {}

func (x *ProductReviewStatus_ProductReviewDestinationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductReviewStatus_ProductReviewDestinationStatus.ProtoReflect.Descriptor instead.
func (*ProductReviewStatus_ProductReviewDestinationStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ProductReviewStatus_ProductReviewDestinationStatus) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil {
		return x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

// The ItemLevelIssue of the product review status.
type ProductReviewStatus_ProductReviewItemLevelIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The error code of the issue.
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	// Output only. How this issue affects serving of the product review.
	Severity ProductReviewStatus_ProductReviewItemLevelIssue_Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=google.shopping.merchant.reviews.v1beta.ProductReviewStatus_ProductReviewItemLevelIssue_Severity" json:"severity,omitempty"`
	// Output only. Whether the issue can be resolved by the merchant.
	Resolution string `protobuf:"bytes,3,opt,name=resolution,proto3" json:"resolution,omitempty"`
	// Output only. The attribute's name, if the issue is caused by a single
	// attribute.
	Attribute string `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
	// Output only. The reporting context the issue applies to.
	ReportingContext typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,5,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum" json:"reporting_context,omitempty"`
	// Output only. A short issue description in English.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. A detailed issue description in English.
	Detail string `protobuf:"bytes,7,opt,name=detail,proto3" json:"detail,omitempty"`
	// Output only. The URL of a web page to help with resolving this issue.
	Documentation string `protobuf:"bytes,8,opt,name=documentation,proto3" json:"documentation,omitempty"`
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) Reset() {
	*x = ProductReviewStatus_ProductReviewItemLevelIssue{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductReviewStatus_ProductReviewItemLevelIssue) ProtoMessage() {}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductReviewStatus_ProductReviewItemLevelIssue.ProtoReflect.Descriptor instead.
func (*ProductReviewStatus_ProductReviewItemLevelIssue) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescGZIP(), []int{1, 1}
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) GetSeverity() ProductReviewStatus_ProductReviewItemLevelIssue_Severity {
	if x != nil {
		return x.Severity
	}
	return ProductReviewStatus_ProductReviewItemLevelIssue_SEVERITY_UNSPECIFIED
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) GetResolution() string {
	if x != nil {
		return x.Resolution
	}
	return ""
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil {
		return x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

func (x *ProductReviewStatus_ProductReviewItemLevelIssue) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

var File_google_shopping_merchant_reviews_v1beta_productreviews_common_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x98, 0x0f, 0x0a, 0x17, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x31,
	0x0a, 0x0f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e,
	0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x2f, 0x0a, 0x0e, 0x73, 0x75, 0x62, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01,
	0x52, 0x0d, 0x73, 0x75, 0x62, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x2f, 0x0a, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x02, 0x52, 0x0d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x5f, 0x66, 0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x46, 0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0b, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72,
	0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x3c, 0x0a, 0x15, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x65,
	0x72, 0x5f, 0x69, 0x73, 0x5f, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x05, 0x52, 0x13, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x65, 0x72, 0x49, 0x73, 0x41, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x11, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x5f,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x06, 0x52, 0x10, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x55,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x0f, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x07, 0x52, 0x0e, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a,
	0x0e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x08, 0x52, 0x0d, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x40,
	0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x1e, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x22, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x0a, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x72, 0x6f, 0x73, 0x18, 0x0d, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x70, 0x72, 0x6f, 0x73, 0x12, 0x17, 0x0a,
	0x04, 0x63, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x63, 0x6f, 0x6e, 0x73, 0x12, 0x71, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x35, 0x0a, 0x14, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x12, 0x27, 0x0a, 0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0b, 0x52, 0x09, 0x6d, 0x69, 0x6e,
	0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0a, 0x6d, 0x61, 0x78,
	0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x0c, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x88,
	0x01, 0x01, 0x12, 0x20, 0x0a, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0d, 0x52, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x28,
	0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18,
	0x15, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x61, 0x73, 0x69, 0x6e,
	0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x61, 0x73,
	0x69, 0x6e, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x67, 0x74, 0x69, 0x6e, 0x73, 0x18, 0x17, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x67, 0x74, 0x69, 0x6e, 0x73, 0x12, 0x17,
	0x0a, 0x04, 0x6d, 0x70, 0x6e, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x6d, 0x70, 0x6e, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x6b, 0x75, 0x73, 0x18,
	0x19, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x73, 0x6b, 0x75, 0x73,
	0x12, 0x1b, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x21, 0x0a,
	0x07, 0x69, 0x73, 0x5f, 0x73, 0x70, 0x61, 0x6d, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x0e, 0x52, 0x06, 0x69, 0x73, 0x53, 0x70, 0x61, 0x6d, 0x88, 0x01, 0x01,
	0x12, 0x83, 0x01, 0x0a, 0x11, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x1a, 0xc8, 0x01, 0x0a, 0x0a, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x69, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x36, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x54, 0x4f, 0x4e,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0x02, 0x22, 0x5c, 0x0a,
	0x10, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x4f, 0x4c, 0x49, 0x43, 0x49,
	0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x4f, 0x53, 0x54, 0x5f, 0x46, 0x55,
	0x4c, 0x46, 0x49, 0x4c, 0x4c, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42,
	0x11, 0x0a, 0x0f, 0x5f, 0x73, 0x75, 0x62, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x5f, 0x66, 0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x42, 0x18, 0x0a, 0x16, 0x5f,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x69, 0x73, 0x5f, 0x61, 0x6e, 0x6f, 0x6e,
	0x79, 0x6d, 0x6f, 0x75, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x65, 0x72, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x42,
	0x11, 0x0a, 0x0f, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x69, 0x6e,
	0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x61, 0x78, 0x5f,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x69, 0x73, 0x5f, 0x73, 0x70, 0x61, 0x6d, 0x22, 0x83, 0x09,
	0x0a, 0x13, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x93, 0x01, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x89, 0x01, 0x0a, 0x11,
	0x69, 0x74, 0x65, 0x6d, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x69, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0x8f, 0x01, 0x0a, 0x1e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x6d, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x1a, 0xaa, 0x04, 0x0a, 0x1b, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12,
	0x82, 0x01, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x49, 0x74,
	0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x53, 0x65, 0x76,
	0x65, 0x72, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65,
	0x72, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72,
	0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x6d, 0x0a, 0x11,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x45, 0x6e, 0x75, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12,
	0x29, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x47, 0x0a, 0x08, 0x53, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49,
	0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x49, 0x53, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45,
	0x44, 0x10, 0x02, 0x42, 0x99, 0x02, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x42, 0x19, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x4b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x27,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73,
	0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5c, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x5c, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74,
	0x61, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x3a, 0x3a,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescData = file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDesc
)

func file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescData)
	})
	return file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDescData
}

var file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_goTypes = []any{
	(ProductReviewAttributes_CollectionMethod)(0),                 // 0: google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.CollectionMethod
	(ProductReviewAttributes_ReviewLink_Type)(0),                  // 1: google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.ReviewLink.Type
	(ProductReviewStatus_ProductReviewItemLevelIssue_Severity)(0), // 2: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.ProductReviewItemLevelIssue.Severity
	(*ProductReviewAttributes)(nil),                               // 3: google.shopping.merchant.reviews.v1beta.ProductReviewAttributes
	(*ProductReviewStatus)(nil),                                   // 4: google.shopping.merchant.reviews.v1beta.ProductReviewStatus
	(*ProductReviewAttributes_ReviewLink)(nil),                    // 5: google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.ReviewLink
	(*ProductReviewStatus_ProductReviewDestinationStatus)(nil),    // 6: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.ProductReviewDestinationStatus
	(*ProductReviewStatus_ProductReviewItemLevelIssue)(nil),       // 7: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.ProductReviewItemLevelIssue
	(*timestamppb.Timestamp)(nil),                                 // 8: google.protobuf.Timestamp
	(typepb.ReportingContext_ReportingContextEnum)(0),             // 9: google.shopping.type.ReportingContext.ReportingContextEnum
}
var file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_depIdxs = []int32{
	8,  // 0: google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.review_time:type_name -> google.protobuf.Timestamp
	5,  // 1: google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.review_link:type_name -> google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.ReviewLink
	0,  // 2: google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.collection_method:type_name -> google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.CollectionMethod
	6,  // 3: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.destination_statuses:type_name -> google.shopping.merchant.reviews.v1beta.ProductReviewStatus.ProductReviewDestinationStatus
	7,  // 4: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.item_level_issues:type_name -> google.shopping.merchant.reviews.v1beta.ProductReviewStatus.ProductReviewItemLevelIssue
	8,  // 5: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.create_time:type_name -> google.protobuf.Timestamp
	8,  // 6: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.last_update_time:type_name -> google.protobuf.Timestamp
	1,  // 7: google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.ReviewLink.type:type_name -> google.shopping.merchant.reviews.v1beta.ProductReviewAttributes.ReviewLink.Type
	9,  // 8: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.ProductReviewDestinationStatus.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	2,  // 9: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.ProductReviewItemLevelIssue.severity:type_name -> google.shopping.merchant.reviews.v1beta.ProductReviewStatus.ProductReviewItemLevelIssue.Severity
	9,  // 10: google.shopping.merchant.reviews.v1beta.ProductReviewStatus.ProductReviewItemLevelIssue.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_init() }
func file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_init() {
	if File_google_shopping_merchant_reviews_v1beta_productreviews_common_proto != nil {
		return
	}
	file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_reviews_v1beta_productreviews_common_proto = out.File
	file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_rawDesc = nil
	file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_goTypes = nil
	file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_depIdxs = nil
}
