// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/reviews/v1beta/merchantreviews.proto

package reviewspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for the `GetMerchantReview` method.
type GetMerchantReviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the merchant review.
	// Format: accounts/{account}/merchantReviews/{merchantReview}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMerchantReviewRequest) Reset() {
	*x = GetMerchantReviewRequest{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMerchantReviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMerchantReviewRequest) ProtoMessage() {}

func (x *GetMerchantReviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMerchantReviewRequest.ProtoReflect.Descriptor instead.
func (*GetMerchantReviewRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescGZIP(), []int{0}
}

func (x *GetMerchantReviewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `DeleteMerchantReview` method.
type DeleteMerchantReviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the merchant review.
	// Format: accounts/{account}/merchantReviews/{merchantReview}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMerchantReviewRequest) Reset() {
	*x = DeleteMerchantReviewRequest{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteMerchantReviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMerchantReviewRequest) ProtoMessage() {}

func (x *DeleteMerchantReviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMerchantReviewRequest.ProtoReflect.Descriptor instead.
func (*DeleteMerchantReviewRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescGZIP(), []int{1}
}

func (x *DeleteMerchantReviewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `ListMerchantsReview` method.
type ListMerchantReviewsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account to list merchant reviews for.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of merchant reviews to return. The service can
	// return fewer than this value. The maximum value is 1000; values above 1000
	// are coerced to 1000. If unspecified, the maximum number of reviews is
	// returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListMerchantReviews`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListMerchantReviews`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMerchantReviewsRequest) Reset() {
	*x = ListMerchantReviewsRequest{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMerchantReviewsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMerchantReviewsRequest) ProtoMessage() {}

func (x *ListMerchantReviewsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMerchantReviewsRequest.ProtoReflect.Descriptor instead.
func (*ListMerchantReviewsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescGZIP(), []int{2}
}

func (x *ListMerchantReviewsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMerchantReviewsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMerchantReviewsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for the `InsertMerchantReview` method.
type InsertMerchantReviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account where the merchant review will be inserted.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The merchant review to insert.
	MerchantReview *MerchantReview `protobuf:"bytes,2,opt,name=merchant_review,json=merchantReview,proto3" json:"merchant_review,omitempty"`
	// Required. The data source of the
	// [merchantreview](https://support.google.com/merchants/answer/7045996?sjid=5253581244217581976-EU)
	// Format:
	// `accounts/{account}/dataSources/{datasource}`.
	DataSource string `protobuf:"bytes,3,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
}

func (x *InsertMerchantReviewRequest) Reset() {
	*x = InsertMerchantReviewRequest{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InsertMerchantReviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertMerchantReviewRequest) ProtoMessage() {}

func (x *InsertMerchantReviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertMerchantReviewRequest.ProtoReflect.Descriptor instead.
func (*InsertMerchantReviewRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescGZIP(), []int{3}
}

func (x *InsertMerchantReviewRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InsertMerchantReviewRequest) GetMerchantReview() *MerchantReview {
	if x != nil {
		return x.MerchantReview
	}
	return nil
}

func (x *InsertMerchantReviewRequest) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

// Response message for the `ListMerchantsReview` method.
type ListMerchantReviewsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The merchant review.
	MerchantReviews []*MerchantReview `protobuf:"bytes,1,rep,name=merchant_reviews,json=merchantReviews,proto3" json:"merchant_reviews,omitempty"`
	// The token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMerchantReviewsResponse) Reset() {
	*x = ListMerchantReviewsResponse{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMerchantReviewsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMerchantReviewsResponse) ProtoMessage() {}

func (x *ListMerchantReviewsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMerchantReviewsResponse.ProtoReflect.Descriptor instead.
func (*ListMerchantReviewsResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescGZIP(), []int{4}
}

func (x *ListMerchantReviewsResponse) GetMerchantReviews() []*MerchantReview {
	if x != nil {
		return x.MerchantReviews
	}
	return nil
}

func (x *ListMerchantReviewsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A review for a merchant. For more information, see
// [Introduction to Merchant Review
// Feeds](https://developers.google.com/merchant-review-feeds)
type MerchantReview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the merchant review.
	// Format:
	// `"{merchantreview.name=accounts/{account}/merchantReviews/{merchantReview}}"`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user provided merchant review ID to uniquely identify the
	// merchant review.
	MerchantReviewId string `protobuf:"bytes,2,opt,name=merchant_review_id,json=merchantReviewId,proto3" json:"merchant_review_id,omitempty"`
	// Optional. A list of merchant review attributes.
	Attributes *MerchantReviewAttributes `protobuf:"bytes,3,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// Required. A list of custom (merchant-provided) attributes. It can also be
	// used for submitting any attribute of the data specification in its generic
	// form (for example,
	// `{ "name": "size type", "value": "regular" }`).
	// This is useful for submitting attributes not explicitly exposed by the
	// API, such as experimental attributes.
	// Maximum allowed number of characters for each
	// custom attribute is 10240 (represents sum of characters for name and
	// value). Maximum 2500 custom attributes can be set per product, with total
	// size of 102.4kB. Underscores in custom attribute names are replaced by
	// spaces upon insertion.
	CustomAttributes []*typepb.CustomAttribute `protobuf:"bytes,4,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty"`
	// Output only. The primary data source of the merchant review.
	DataSource string `protobuf:"bytes,5,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	// Output only. The status of a merchant review, data validation issues, that
	// is, information about a merchant review computed asynchronously.
	MerchantReviewStatus *MerchantReviewStatus `protobuf:"bytes,6,opt,name=merchant_review_status,json=merchantReviewStatus,proto3" json:"merchant_review_status,omitempty"`
}

func (x *MerchantReview) Reset() {
	*x = MerchantReview{}
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MerchantReview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MerchantReview) ProtoMessage() {}

func (x *MerchantReview) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MerchantReview.ProtoReflect.Descriptor instead.
func (*MerchantReview) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescGZIP(), []int{5}
}

func (x *MerchantReview) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MerchantReview) GetMerchantReviewId() string {
	if x != nil {
		return x.MerchantReviewId
	}
	return ""
}

func (x *MerchantReview) GetAttributes() *MerchantReviewAttributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *MerchantReview) GetCustomAttributes() []*typepb.CustomAttribute {
	if x != nil {
		return x.CustomAttributes
	}
	return nil
}

func (x *MerchantReview) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

func (x *MerchantReview) GetMerchantReviewStatus() *MerchantReviewStatus {
	if x != nil {
		return x.MerchantReviewStatus
	}
	return nil
}

var File_google_shopping_merchant_reviews_v1beta_merchantreviews_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x61, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x64, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xad, 0x01, 0x0a, 0x1a, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b,
	0x12, 0x29, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc7, 0x01, 0x0a, 0x1b, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x65, 0x0a, 0x0f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x24, 0x0a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0xa9, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x62, 0x0a, 0x10, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x0f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xb9, 0x04, 0x0a, 0x0e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x49, 0x64, 0x12, 0x66,
	0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x24, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x78, 0x0a, 0x16, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x3a,
	0x7a, 0xea, 0x41, 0x77, 0x0a, 0x29, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12,
	0x29, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x7d, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x2a, 0x0f, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x32, 0x0e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x32, 0xc8, 0x07, 0x0a, 0x16,
	0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xd3, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe6, 0x01, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x44, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35,
	0x12, 0x33, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0xea, 0x01, 0x0a, 0x14, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74,
	0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x22, 0x53, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x0f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x22, 0x3a, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x3a, 0x69, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x12, 0xb8, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x47, 0xca,
	0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xcf, 0x02, 0xea, 0x41, 0x38, 0x0a, 0x22, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x12, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x7d, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x42, 0x14, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4b, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x5c, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5c, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x4d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x3a, 0x3a, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescData = file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDesc
)

func file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescData)
	})
	return file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDescData
}

var file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_goTypes = []any{
	(*GetMerchantReviewRequest)(nil),    // 0: google.shopping.merchant.reviews.v1beta.GetMerchantReviewRequest
	(*DeleteMerchantReviewRequest)(nil), // 1: google.shopping.merchant.reviews.v1beta.DeleteMerchantReviewRequest
	(*ListMerchantReviewsRequest)(nil),  // 2: google.shopping.merchant.reviews.v1beta.ListMerchantReviewsRequest
	(*InsertMerchantReviewRequest)(nil), // 3: google.shopping.merchant.reviews.v1beta.InsertMerchantReviewRequest
	(*ListMerchantReviewsResponse)(nil), // 4: google.shopping.merchant.reviews.v1beta.ListMerchantReviewsResponse
	(*MerchantReview)(nil),              // 5: google.shopping.merchant.reviews.v1beta.MerchantReview
	(*MerchantReviewAttributes)(nil),    // 6: google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes
	(*typepb.CustomAttribute)(nil),      // 7: google.shopping.type.CustomAttribute
	(*MerchantReviewStatus)(nil),        // 8: google.shopping.merchant.reviews.v1beta.MerchantReviewStatus
	(*emptypb.Empty)(nil),               // 9: google.protobuf.Empty
}
var file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_depIdxs = []int32{
	5, // 0: google.shopping.merchant.reviews.v1beta.InsertMerchantReviewRequest.merchant_review:type_name -> google.shopping.merchant.reviews.v1beta.MerchantReview
	5, // 1: google.shopping.merchant.reviews.v1beta.ListMerchantReviewsResponse.merchant_reviews:type_name -> google.shopping.merchant.reviews.v1beta.MerchantReview
	6, // 2: google.shopping.merchant.reviews.v1beta.MerchantReview.attributes:type_name -> google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes
	7, // 3: google.shopping.merchant.reviews.v1beta.MerchantReview.custom_attributes:type_name -> google.shopping.type.CustomAttribute
	8, // 4: google.shopping.merchant.reviews.v1beta.MerchantReview.merchant_review_status:type_name -> google.shopping.merchant.reviews.v1beta.MerchantReviewStatus
	0, // 5: google.shopping.merchant.reviews.v1beta.MerchantReviewsService.GetMerchantReview:input_type -> google.shopping.merchant.reviews.v1beta.GetMerchantReviewRequest
	2, // 6: google.shopping.merchant.reviews.v1beta.MerchantReviewsService.ListMerchantReviews:input_type -> google.shopping.merchant.reviews.v1beta.ListMerchantReviewsRequest
	3, // 7: google.shopping.merchant.reviews.v1beta.MerchantReviewsService.InsertMerchantReview:input_type -> google.shopping.merchant.reviews.v1beta.InsertMerchantReviewRequest
	1, // 8: google.shopping.merchant.reviews.v1beta.MerchantReviewsService.DeleteMerchantReview:input_type -> google.shopping.merchant.reviews.v1beta.DeleteMerchantReviewRequest
	5, // 9: google.shopping.merchant.reviews.v1beta.MerchantReviewsService.GetMerchantReview:output_type -> google.shopping.merchant.reviews.v1beta.MerchantReview
	4, // 10: google.shopping.merchant.reviews.v1beta.MerchantReviewsService.ListMerchantReviews:output_type -> google.shopping.merchant.reviews.v1beta.ListMerchantReviewsResponse
	5, // 11: google.shopping.merchant.reviews.v1beta.MerchantReviewsService.InsertMerchantReview:output_type -> google.shopping.merchant.reviews.v1beta.MerchantReview
	9, // 12: google.shopping.merchant.reviews.v1beta.MerchantReviewsService.DeleteMerchantReview:output_type -> google.protobuf.Empty
	9, // [9:13] is the sub-list for method output_type
	5, // [5:9] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_init() }
func file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_init() {
	if File_google_shopping_merchant_reviews_v1beta_merchantreviews_proto != nil {
		return
	}
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_common_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_reviews_v1beta_merchantreviews_proto = out.File
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_rawDesc = nil
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_goTypes = nil
	file_google_shopping_merchant_reviews_v1beta_merchantreviews_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MerchantReviewsServiceClient is the client API for MerchantReviewsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MerchantReviewsServiceClient interface {
	// Gets a merchant review.
	GetMerchantReview(ctx context.Context, in *GetMerchantReviewRequest, opts ...grpc.CallOption) (*MerchantReview, error)
	// Lists merchant reviews.
	ListMerchantReviews(ctx context.Context, in *ListMerchantReviewsRequest, opts ...grpc.CallOption) (*ListMerchantReviewsResponse, error)
	// Inserts a review for your Merchant Center account. If the review
	// already exists, then the review is replaced with the new instance.
	InsertMerchantReview(ctx context.Context, in *InsertMerchantReviewRequest, opts ...grpc.CallOption) (*MerchantReview, error)
	// Deletes merchant review.
	DeleteMerchantReview(ctx context.Context, in *DeleteMerchantReviewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type merchantReviewsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMerchantReviewsServiceClient(cc grpc.ClientConnInterface) MerchantReviewsServiceClient {
	return &merchantReviewsServiceClient{cc}
}

func (c *merchantReviewsServiceClient) GetMerchantReview(ctx context.Context, in *GetMerchantReviewRequest, opts ...grpc.CallOption) (*MerchantReview, error) {
	out := new(MerchantReview)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.reviews.v1beta.MerchantReviewsService/GetMerchantReview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merchantReviewsServiceClient) ListMerchantReviews(ctx context.Context, in *ListMerchantReviewsRequest, opts ...grpc.CallOption) (*ListMerchantReviewsResponse, error) {
	out := new(ListMerchantReviewsResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.reviews.v1beta.MerchantReviewsService/ListMerchantReviews", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merchantReviewsServiceClient) InsertMerchantReview(ctx context.Context, in *InsertMerchantReviewRequest, opts ...grpc.CallOption) (*MerchantReview, error) {
	out := new(MerchantReview)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.reviews.v1beta.MerchantReviewsService/InsertMerchantReview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merchantReviewsServiceClient) DeleteMerchantReview(ctx context.Context, in *DeleteMerchantReviewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.reviews.v1beta.MerchantReviewsService/DeleteMerchantReview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MerchantReviewsServiceServer is the server API for MerchantReviewsService service.
type MerchantReviewsServiceServer interface {
	// Gets a merchant review.
	GetMerchantReview(context.Context, *GetMerchantReviewRequest) (*MerchantReview, error)
	// Lists merchant reviews.
	ListMerchantReviews(context.Context, *ListMerchantReviewsRequest) (*ListMerchantReviewsResponse, error)
	// Inserts a review for your Merchant Center account. If the review
	// already exists, then the review is replaced with the new instance.
	InsertMerchantReview(context.Context, *InsertMerchantReviewRequest) (*MerchantReview, error)
	// Deletes merchant review.
	DeleteMerchantReview(context.Context, *DeleteMerchantReviewRequest) (*emptypb.Empty, error)
}

// UnimplementedMerchantReviewsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMerchantReviewsServiceServer struct {
}

func (*UnimplementedMerchantReviewsServiceServer) GetMerchantReview(context.Context, *GetMerchantReviewRequest) (*MerchantReview, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMerchantReview not implemented")
}
func (*UnimplementedMerchantReviewsServiceServer) ListMerchantReviews(context.Context, *ListMerchantReviewsRequest) (*ListMerchantReviewsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMerchantReviews not implemented")
}
func (*UnimplementedMerchantReviewsServiceServer) InsertMerchantReview(context.Context, *InsertMerchantReviewRequest) (*MerchantReview, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertMerchantReview not implemented")
}
func (*UnimplementedMerchantReviewsServiceServer) DeleteMerchantReview(context.Context, *DeleteMerchantReviewRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMerchantReview not implemented")
}

func RegisterMerchantReviewsServiceServer(s *grpc.Server, srv MerchantReviewsServiceServer) {
	s.RegisterService(&_MerchantReviewsService_serviceDesc, srv)
}

func _MerchantReviewsService_GetMerchantReview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMerchantReviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantReviewsServiceServer).GetMerchantReview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.reviews.v1beta.MerchantReviewsService/GetMerchantReview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantReviewsServiceServer).GetMerchantReview(ctx, req.(*GetMerchantReviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MerchantReviewsService_ListMerchantReviews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMerchantReviewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantReviewsServiceServer).ListMerchantReviews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.reviews.v1beta.MerchantReviewsService/ListMerchantReviews",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantReviewsServiceServer).ListMerchantReviews(ctx, req.(*ListMerchantReviewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MerchantReviewsService_InsertMerchantReview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertMerchantReviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantReviewsServiceServer).InsertMerchantReview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.reviews.v1beta.MerchantReviewsService/InsertMerchantReview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantReviewsServiceServer).InsertMerchantReview(ctx, req.(*InsertMerchantReviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MerchantReviewsService_DeleteMerchantReview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMerchantReviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantReviewsServiceServer).DeleteMerchantReview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.reviews.v1beta.MerchantReviewsService/DeleteMerchantReview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantReviewsServiceServer).DeleteMerchantReview(ctx, req.(*DeleteMerchantReviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MerchantReviewsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.reviews.v1beta.MerchantReviewsService",
	HandlerType: (*MerchantReviewsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMerchantReview",
			Handler:    _MerchantReviewsService_GetMerchantReview_Handler,
		},
		{
			MethodName: "ListMerchantReviews",
			Handler:    _MerchantReviewsService_ListMerchantReviews_Handler,
		},
		{
			MethodName: "InsertMerchantReview",
			Handler:    _MerchantReviewsService_InsertMerchantReview_Handler,
		},
		{
			MethodName: "DeleteMerchantReview",
			Handler:    _MerchantReviewsService_DeleteMerchantReview_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/reviews/v1beta/merchantreviews.proto",
}
