// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/promotions/v1beta/promotions_common.proto

package promotionspb

import (
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Which product or list of products the promotion applies to.
type ProductApplicability int32

const (
	// Which products the promotion applies to is unknown.
	ProductApplicability_PRODUCT_APPLICABILITY_UNSPECIFIED ProductApplicability = 0
	// Applicable to all products.
	ProductApplicability_ALL_PRODUCTS ProductApplicability = 1
	// Applicable to only a single product or list of products.
	ProductApplicability_SPECIFIC_PRODUCTS ProductApplicability = 2
)

// Enum value maps for ProductApplicability.
var (
	ProductApplicability_name = map[int32]string{
		0: "PRODUCT_APPLICABILITY_UNSPECIFIED",
		1: "ALL_PRODUCTS",
		2: "SPECIFIC_PRODUCTS",
	}
	ProductApplicability_value = map[string]int32{
		"PRODUCT_APPLICABILITY_UNSPECIFIED": 0,
		"ALL_PRODUCTS":                      1,
		"SPECIFIC_PRODUCTS":                 2,
	}
)

func (x ProductApplicability) Enum() *ProductApplicability {
	p := new(ProductApplicability)
	*p = x
	return p
}

func (x ProductApplicability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProductApplicability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[0].Descriptor()
}

func (ProductApplicability) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[0]
}

func (x ProductApplicability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProductApplicability.Descriptor instead.
func (ProductApplicability) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{0}
}

// Store codes or list of store codes the promotion applies to. Only for
// Local inventory ads promotions.
type StoreApplicability int32

const (
	// Which store codes the promotion applies to is unknown.
	StoreApplicability_STORE_APPLICABILITY_UNSPECIFIED StoreApplicability = 0
	// Promotion applies to all stores.
	StoreApplicability_ALL_STORES StoreApplicability = 1
	// Promotion applies to only the specified stores.
	StoreApplicability_SPECIFIC_STORES StoreApplicability = 2
)

// Enum value maps for StoreApplicability.
var (
	StoreApplicability_name = map[int32]string{
		0: "STORE_APPLICABILITY_UNSPECIFIED",
		1: "ALL_STORES",
		2: "SPECIFIC_STORES",
	}
	StoreApplicability_value = map[string]int32{
		"STORE_APPLICABILITY_UNSPECIFIED": 0,
		"ALL_STORES":                      1,
		"SPECIFIC_STORES":                 2,
	}
)

func (x StoreApplicability) Enum() *StoreApplicability {
	p := new(StoreApplicability)
	*p = x
	return p
}

func (x StoreApplicability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StoreApplicability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[1].Descriptor()
}

func (StoreApplicability) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[1]
}

func (x StoreApplicability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StoreApplicability.Descriptor instead.
func (StoreApplicability) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{1}
}

// Offer type of a promotion.
type OfferType int32

const (
	// Unknown offer type.
	OfferType_OFFER_TYPE_UNSPECIFIED OfferType = 0
	// Offer type without a code.
	OfferType_NO_CODE OfferType = 1
	// Offer type with a code. Generic redemption code for the promotion is
	// required when `offerType` = `GENERIC_CODE`.
	OfferType_GENERIC_CODE OfferType = 2
)

// Enum value maps for OfferType.
var (
	OfferType_name = map[int32]string{
		0: "OFFER_TYPE_UNSPECIFIED",
		1: "NO_CODE",
		2: "GENERIC_CODE",
	}
	OfferType_value = map[string]int32{
		"OFFER_TYPE_UNSPECIFIED": 0,
		"NO_CODE":                1,
		"GENERIC_CODE":           2,
	}
)

func (x OfferType) Enum() *OfferType {
	p := new(OfferType)
	*p = x
	return p
}

func (x OfferType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OfferType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[2].Descriptor()
}

func (OfferType) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[2]
}

func (x OfferType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OfferType.Descriptor instead.
func (OfferType) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{2}
}

// Channel of a promotion.
type RedemptionChannel int32

const (
	// Indicates that the channel is unspecified.
	RedemptionChannel_REDEMPTION_CHANNEL_UNSPECIFIED RedemptionChannel = 0
	// Indicates that the channel is in store.
	// This is same as `local` channel used for `products`.
	RedemptionChannel_IN_STORE RedemptionChannel = 1
	// Indicates that the channel is online.
	RedemptionChannel_ONLINE RedemptionChannel = 2
)

// Enum value maps for RedemptionChannel.
var (
	RedemptionChannel_name = map[int32]string{
		0: "REDEMPTION_CHANNEL_UNSPECIFIED",
		1: "IN_STORE",
		2: "ONLINE",
	}
	RedemptionChannel_value = map[string]int32{
		"REDEMPTION_CHANNEL_UNSPECIFIED": 0,
		"IN_STORE":                       1,
		"ONLINE":                         2,
	}
)

func (x RedemptionChannel) Enum() *RedemptionChannel {
	p := new(RedemptionChannel)
	*p = x
	return p
}

func (x RedemptionChannel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RedemptionChannel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[3].Descriptor()
}

func (RedemptionChannel) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[3]
}

func (x RedemptionChannel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RedemptionChannel.Descriptor instead.
func (RedemptionChannel) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{3}
}

// [Coupon value
// type](https://support.google.com/merchants/answer/13861986?ref_topic=13773355&sjid=17642868584668136159-NC)
// of a promotion.
type CouponValueType int32

const (
	// Indicates that the coupon value type is unspecified.
	CouponValueType_COUPON_VALUE_TYPE_UNSPECIFIED CouponValueType = 0
	// Money off coupon value type.
	CouponValueType_MONEY_OFF CouponValueType = 1
	// Percent off coupon value type.
	CouponValueType_PERCENT_OFF CouponValueType = 2
	// Buy M quantity, get N money off coupon value type.
	// `minimum_purchase_quantity` and `get_this_quantity_discounted` must be
	// present. `money_off_amount` must also be present.
	CouponValueType_BUY_M_GET_N_MONEY_OFF CouponValueType = 3
	// Buy M quantity, get N percent off coupon value type.
	// `minimum_purchase_quantity` and `get_this_quantity_discounted` must be
	// present. `percent_off_percentage` must also be present.
	CouponValueType_BUY_M_GET_N_PERCENT_OFF CouponValueType = 4
	// Buy M quantity, get money off. `minimum_purchase_quantity` and
	// `money_off_amount` must be present.
	CouponValueType_BUY_M_GET_MONEY_OFF CouponValueType = 5
	// Buy M quantity, get money off. `minimum_purchase_quantity` and
	// `percent_off_percentage` must be present.
	CouponValueType_BUY_M_GET_PERCENT_OFF CouponValueType = 6
	// Free gift with description only.
	CouponValueType_FREE_GIFT CouponValueType = 7
	// Free gift with monetary value.
	CouponValueType_FREE_GIFT_WITH_VALUE CouponValueType = 8
	// Free gift with item ID.
	CouponValueType_FREE_GIFT_WITH_ITEM_ID CouponValueType = 9
	// Standard free shipping coupon value type.
	CouponValueType_FREE_SHIPPING_STANDARD CouponValueType = 10
	// Overnight free shipping coupon value type.
	CouponValueType_FREE_SHIPPING_OVERNIGHT CouponValueType = 11
	// Two day free shipping coupon value type.
	CouponValueType_FREE_SHIPPING_TWO_DAY CouponValueType = 12
)

// Enum value maps for CouponValueType.
var (
	CouponValueType_name = map[int32]string{
		0:  "COUPON_VALUE_TYPE_UNSPECIFIED",
		1:  "MONEY_OFF",
		2:  "PERCENT_OFF",
		3:  "BUY_M_GET_N_MONEY_OFF",
		4:  "BUY_M_GET_N_PERCENT_OFF",
		5:  "BUY_M_GET_MONEY_OFF",
		6:  "BUY_M_GET_PERCENT_OFF",
		7:  "FREE_GIFT",
		8:  "FREE_GIFT_WITH_VALUE",
		9:  "FREE_GIFT_WITH_ITEM_ID",
		10: "FREE_SHIPPING_STANDARD",
		11: "FREE_SHIPPING_OVERNIGHT",
		12: "FREE_SHIPPING_TWO_DAY",
	}
	CouponValueType_value = map[string]int32{
		"COUPON_VALUE_TYPE_UNSPECIFIED": 0,
		"MONEY_OFF":                     1,
		"PERCENT_OFF":                   2,
		"BUY_M_GET_N_MONEY_OFF":         3,
		"BUY_M_GET_N_PERCENT_OFF":       4,
		"BUY_M_GET_MONEY_OFF":           5,
		"BUY_M_GET_PERCENT_OFF":         6,
		"FREE_GIFT":                     7,
		"FREE_GIFT_WITH_VALUE":          8,
		"FREE_GIFT_WITH_ITEM_ID":        9,
		"FREE_SHIPPING_STANDARD":        10,
		"FREE_SHIPPING_OVERNIGHT":       11,
		"FREE_SHIPPING_TWO_DAY":         12,
	}
)

func (x CouponValueType) Enum() *CouponValueType {
	p := new(CouponValueType)
	*p = x
	return p
}

func (x CouponValueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CouponValueType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[4].Descriptor()
}

func (CouponValueType) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[4]
}

func (x CouponValueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CouponValueType.Descriptor instead.
func (CouponValueType) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{4}
}

// The current state of the promotion.
type PromotionStatus_DestinationStatus_State int32

const (
	// Unknown promotion state.
	PromotionStatus_DestinationStatus_STATE_UNSPECIFIED PromotionStatus_DestinationStatus_State = 0
	// The promotion is under review.
	PromotionStatus_DestinationStatus_IN_REVIEW PromotionStatus_DestinationStatus_State = 1
	// The promotion is disapproved.
	PromotionStatus_DestinationStatus_REJECTED PromotionStatus_DestinationStatus_State = 2
	// The promotion is approved and active.
	PromotionStatus_DestinationStatus_LIVE PromotionStatus_DestinationStatus_State = 3
	// The promotion is stopped by merchant.
	PromotionStatus_DestinationStatus_STOPPED PromotionStatus_DestinationStatus_State = 4
	// The promotion is no longer active.
	PromotionStatus_DestinationStatus_EXPIRED PromotionStatus_DestinationStatus_State = 5
	// The promotion is not stopped, and all reviews are approved, but the
	// active date is in the future.
	PromotionStatus_DestinationStatus_PENDING PromotionStatus_DestinationStatus_State = 6
)

// Enum value maps for PromotionStatus_DestinationStatus_State.
var (
	PromotionStatus_DestinationStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "IN_REVIEW",
		2: "REJECTED",
		3: "LIVE",
		4: "STOPPED",
		5: "EXPIRED",
		6: "PENDING",
	}
	PromotionStatus_DestinationStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"IN_REVIEW":         1,
		"REJECTED":          2,
		"LIVE":              3,
		"STOPPED":           4,
		"EXPIRED":           5,
		"PENDING":           6,
	}
)

func (x PromotionStatus_DestinationStatus_State) Enum() *PromotionStatus_DestinationStatus_State {
	p := new(PromotionStatus_DestinationStatus_State)
	*p = x
	return p
}

func (x PromotionStatus_DestinationStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PromotionStatus_DestinationStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[5].Descriptor()
}

func (PromotionStatus_DestinationStatus_State) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[5]
}

func (x PromotionStatus_DestinationStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PromotionStatus_DestinationStatus_State.Descriptor instead.
func (PromotionStatus_DestinationStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{1, 0, 0}
}

// The severity of the issue.
type PromotionStatus_ItemLevelIssue_Severity int32

const (
	// Not specified.
	PromotionStatus_ItemLevelIssue_SEVERITY_UNSPECIFIED PromotionStatus_ItemLevelIssue_Severity = 0
	// This issue represents a warning and does not have a direct affect
	// on the promotion.
	PromotionStatus_ItemLevelIssue_NOT_IMPACTED PromotionStatus_ItemLevelIssue_Severity = 1
	// The promotion is demoted and most likely have limited performance
	// in search results
	PromotionStatus_ItemLevelIssue_DEMOTED PromotionStatus_ItemLevelIssue_Severity = 2
	// Issue disapproves the promotion.
	PromotionStatus_ItemLevelIssue_DISAPPROVED PromotionStatus_ItemLevelIssue_Severity = 3
)

// Enum value maps for PromotionStatus_ItemLevelIssue_Severity.
var (
	PromotionStatus_ItemLevelIssue_Severity_name = map[int32]string{
		0: "SEVERITY_UNSPECIFIED",
		1: "NOT_IMPACTED",
		2: "DEMOTED",
		3: "DISAPPROVED",
	}
	PromotionStatus_ItemLevelIssue_Severity_value = map[string]int32{
		"SEVERITY_UNSPECIFIED": 0,
		"NOT_IMPACTED":         1,
		"DEMOTED":              2,
		"DISAPPROVED":          3,
	}
)

func (x PromotionStatus_ItemLevelIssue_Severity) Enum() *PromotionStatus_ItemLevelIssue_Severity {
	p := new(PromotionStatus_ItemLevelIssue_Severity)
	*p = x
	return p
}

func (x PromotionStatus_ItemLevelIssue_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PromotionStatus_ItemLevelIssue_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[6].Descriptor()
}

func (PromotionStatus_ItemLevelIssue_Severity) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes[6]
}

func (x PromotionStatus_ItemLevelIssue_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PromotionStatus_ItemLevelIssue_Severity.Descriptor instead.
func (PromotionStatus_ItemLevelIssue_Severity) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{1, 1, 0}
}

// Attributes.
type Attributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Applicability of the promotion to either all products or
	// [only specific
	// products](https://support.google.com/merchants/answer/6396257?ref_topic=6396150&sjid=17642868584668136159-NC).
	ProductApplicability ProductApplicability `protobuf:"varint,1,opt,name=product_applicability,json=productApplicability,proto3,enum=google.shopping.merchant.promotions.v1beta.ProductApplicability" json:"product_applicability,omitempty"`
	// Required.
	// [Type](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC)
	// of the promotion. Use this attribute to indicate whether or not customers
	// need a coupon code to redeem your promotion.
	OfferType OfferType `protobuf:"varint,2,opt,name=offer_type,json=offerType,proto3,enum=google.shopping.merchant.promotions.v1beta.OfferType" json:"offer_type,omitempty"`
	// Optional. Generic redemption code for the promotion. To be used with the
	// `offerType` field and must meet the [minimum
	// requirements](https://support.google.com/merchants/answer/13837405?ref_topic=13773355&sjid=17642868584668136159-NC).
	GenericRedemptionCode string `protobuf:"bytes,3,opt,name=generic_redemption_code,json=genericRedemptionCode,proto3" json:"generic_redemption_code,omitempty"`
	// Required. [Long
	// title](https://support.google.com/merchants/answer/13838102?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	LongTitle string `protobuf:"bytes,4,opt,name=long_title,json=longTitle,proto3" json:"long_title,omitempty"`
	// Required. The [coupon value type]
	// (https://support.google.com/merchants/answer/13861986?ref_topic=13773355&sjid=17642868584668136159-NC)
	// attribute to signal the type of promotion that you are running. Depending
	// on type of the selected coupon value [some attributes are
	// required](https://support.google.com/merchants/answer/6393006?ref_topic=7322920).
	CouponValueType CouponValueType `protobuf:"varint,5,opt,name=coupon_value_type,json=couponValueType,proto3,enum=google.shopping.merchant.promotions.v1beta.CouponValueType" json:"coupon_value_type,omitempty"`
	// Required. The list of destinations where the promotion applies to. If you
	// don't specify a destination by including a supported value in your data
	// source, your promotion will display in Shopping ads and free listings by
	// default.
	//
	// You may have previously submitted the following values as destinations for
	// your products: Shopping Actions, Surfaces across Google, Local surfaces
	// across Google.  To represent these values use `FREE_LISTINGS`,
	// `FREE_LOCAL_LISTINGS`, `LOCAL_INVENTORY_ADS`. For more details see
	// [Promotion
	// destination](https://support.google.com/merchants/answer/13837465?sjid=5155774230887277618-NC)
	PromotionDestinations []typepb.Destination_DestinationEnum `protobuf:"varint,6,rep,packed,name=promotion_destinations,json=promotionDestinations,proto3,enum=google.shopping.type.Destination_DestinationEnum" json:"promotion_destinations,omitempty"`
	// Optional. Product filter by [item
	// ID](https://support.google.com/merchants/answer/13861565?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The product filter attributes only applies when the
	// products eligible for promotion product applicability
	// `product_applicability` attribute is set to
	// [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ItemIdInclusion []string `protobuf:"bytes,7,rep,name=item_id_inclusion,json=itemIdInclusion,proto3" json:"item_id_inclusion,omitempty"`
	// Optional. Product filter by brand for the promotion. The product filter
	// attributes only applies when the products eligible for promotion product
	// applicability `product_applicability` attribute is set to
	// [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	BrandInclusion []string `protobuf:"bytes,8,rep,name=brand_inclusion,json=brandInclusion,proto3" json:"brand_inclusion,omitempty"`
	// Optional. Product filter by item group ID for the promotion. The product
	// filter attributes only applies when the products eligible for promotion
	// product applicability [product_applicability] attribute is set to
	// [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ItemGroupIdInclusion []string `protobuf:"bytes,9,rep,name=item_group_id_inclusion,json=itemGroupIdInclusion,proto3" json:"item_group_id_inclusion,omitempty"`
	// Optional. Product filter by product type for the promotion. The product
	// filter attributes only applies when the products eligible for promotion
	// product applicability `product_applicability` attribute is set to
	// [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ProductTypeInclusion []string `protobuf:"bytes,10,rep,name=product_type_inclusion,json=productTypeInclusion,proto3" json:"product_type_inclusion,omitempty"`
	// Optional. Product filter by [item ID
	// exclusion](https://support.google.com/merchants/answer/13863524?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The product filter attributes only applies when the
	// products eligible for promotion product applicability
	// `product_applicability` attribute is set to
	// [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ItemIdExclusion []string `protobuf:"bytes,11,rep,name=item_id_exclusion,json=itemIdExclusion,proto3" json:"item_id_exclusion,omitempty"`
	// Optional. Product filter by [brand
	// exclusion](https://support.google.com/merchants/answer/13861679?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The product filter attributes only applies when the
	// products eligible for promotion product applicability
	// `product_applicability` attribute is set to
	// [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	BrandExclusion []string `protobuf:"bytes,12,rep,name=brand_exclusion,json=brandExclusion,proto3" json:"brand_exclusion,omitempty"`
	// Optional. Product filter by [item group
	// ID](https://support.google.com/merchants/answer/13837298?ref_topic=13773355&sjid=17642868584668136159-NC).
	// The product filter attributes only applies when the products eligible for
	// promotion product applicability `product_applicability` attribute is set to
	// [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	// exclusion for the promotion.
	ItemGroupIdExclusion []string `protobuf:"bytes,13,rep,name=item_group_id_exclusion,json=itemGroupIdExclusion,proto3" json:"item_group_id_exclusion,omitempty"`
	// Optional. Product filter by [product type
	// exclusion](https://support.google.com/merchants/answer/13863746?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The product filter attributes only applies when the
	// products eligible for promotion product applicability
	// `product_applicability` attribute is set to
	// [specific_products](https://support.google.com/merchants/answer/13837299?ref_topic=13773355&sjid=17642868584668136159-NC).
	ProductTypeExclusion []string `protobuf:"bytes,14,rep,name=product_type_exclusion,json=productTypeExclusion,proto3" json:"product_type_exclusion,omitempty"`
	// Optional. [Minimum purchase
	// amount](https://support.google.com/merchants/answer/13837705?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	MinimumPurchaseAmount *typepb.Price `protobuf:"bytes,15,opt,name=minimum_purchase_amount,json=minimumPurchaseAmount,proto3" json:"minimum_purchase_amount,omitempty"`
	// Optional. [Minimum purchase
	// quantity](https://support.google.com/merchants/answer/13838182?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	MinimumPurchaseQuantity int64 `protobuf:"varint,16,opt,name=minimum_purchase_quantity,json=minimumPurchaseQuantity,proto3" json:"minimum_purchase_quantity,omitempty"`
	// Optional. [Maximum purchase
	// quantity](https://support.google.com/merchants/answer/13861564?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	LimitQuantity int64 `protobuf:"varint,17,opt,name=limit_quantity,json=limitQuantity,proto3" json:"limit_quantity,omitempty"`
	// Optional. [Maximum product
	// price](https://support.google.com/merchants/answer/2906014) for
	// promotion.
	LimitValue *typepb.Price `protobuf:"bytes,18,opt,name=limit_value,json=limitValue,proto3" json:"limit_value,omitempty"`
	// Optional. The [percentage
	// discount](https://support.google.com/merchants/answer/13837404?sjid=17642868584668136159-NC)
	// offered in the promotion.
	PercentOff int64 `protobuf:"varint,19,opt,name=percent_off,json=percentOff,proto3" json:"percent_off,omitempty"`
	// Optional. The [money off
	// amount](https://support.google.com/merchants/answer/13838101?ref_topic=13773355&sjid=17642868584668136159-NC)
	// offered in the promotion.
	MoneyOffAmount *typepb.Price `protobuf:"bytes,20,opt,name=money_off_amount,json=moneyOffAmount,proto3" json:"money_off_amount,omitempty"`
	// Optional. The number of items discounted in the promotion. The attribute is
	// set when `couponValueType` is equal to `buy_m_get_n_money_off` or
	// `buy_m_get_n_percent_off`.
	GetThisQuantityDiscounted int64 `protobuf:"varint,21,opt,name=get_this_quantity_discounted,json=getThisQuantityDiscounted,proto3" json:"get_this_quantity_discounted,omitempty"`
	// Optional. [Free gift
	// value](https://support.google.com/merchants/answer/13844477?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	FreeGiftValue *typepb.Price `protobuf:"bytes,22,opt,name=free_gift_value,json=freeGiftValue,proto3" json:"free_gift_value,omitempty"`
	// Optional. [Free gift
	// description](https://support.google.com/merchants/answer/13847245?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	FreeGiftDescription string `protobuf:"bytes,23,opt,name=free_gift_description,json=freeGiftDescription,proto3" json:"free_gift_description,omitempty"`
	// Optional. [Free gift item
	// ID](https://support.google.com/merchants/answer/13857152?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion.
	FreeGiftItemId string `protobuf:"bytes,24,opt,name=free_gift_item_id,json=freeGiftItemId,proto3" json:"free_gift_item_id,omitempty"`
	// Required. `TimePeriod` representation of the promotion's effective dates.
	// This attribute specifies that the promotion can be tested on your online
	// store during this time period.
	PromotionEffectiveTimePeriod *interval.Interval `protobuf:"bytes,25,opt,name=promotion_effective_time_period,json=promotionEffectiveTimePeriod,proto3" json:"promotion_effective_time_period,omitempty"`
	// Optional. `TimePeriod` representation of the promotion's display dates.
	// This attribute specifies the date and time frame when the promotion will be
	// live on Google.com and Shopping ads. If the display time period for
	// promotion `promotion_display_time_period` attribute is not specified, the
	// promotion effective time period `promotion_effective_time_period`
	// determines the date and time frame when the promotion will be live on
	// Google.com and Shopping ads.
	PromotionDisplayTimePeriod *interval.Interval `protobuf:"bytes,26,opt,name=promotion_display_time_period,json=promotionDisplayTimePeriod,proto3" json:"promotion_display_time_period,omitempty"`
	// Optional. Whether the promotion applies to [all stores, or only specified
	// stores](https://support.google.com/merchants/answer/13857563?sjid=17642868584668136159-NC).
	// Local Inventory ads promotions throw an error if no store applicability is
	// included. An `INVALID_ARGUMENT` error is thrown if `store_applicability` is
	// set to `ALL_STORES` and `store_codes_inclusion` or `score_code_exclusion`
	// is set to a value.
	StoreApplicability StoreApplicability `protobuf:"varint,28,opt,name=store_applicability,json=storeApplicability,proto3,enum=google.shopping.merchant.promotions.v1beta.StoreApplicability" json:"store_applicability,omitempty"`
	// Optional. [Store codes to
	// include](https://support.google.com/merchants/answer/13857470?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The store filter attributes only applies when the
	// `store_applicability` attribute is set to
	// [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
	//
	// Store code (the store ID from
	// your Business Profile) of the physical store the product is sold in. See
	// the [Local product inventory data
	// specification](https://support.google.com/merchants/answer/3061342) for
	// more information.
	StoreCodesInclusion []string `protobuf:"bytes,29,rep,name=store_codes_inclusion,json=storeCodesInclusion,proto3" json:"store_codes_inclusion,omitempty"`
	// Optional. [Store codes to
	// exclude](https://support.google.com/merchants/answer/13859586?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. The store filter attributes only applies when the
	// `store_applicability` attribute is set to
	// [specific_stores](https://support.google.com/merchants/answer/13857563?ref_topic=13773355&sjid=17642868584668136159-NC).
	StoreCodesExclusion []string `protobuf:"bytes,30,rep,name=store_codes_exclusion,json=storeCodesExclusion,proto3" json:"store_codes_exclusion,omitempty"`
	// Optional. URL to the page on the merchant's site where the promotion shows.
	// Local Inventory ads promotions throw an error if no `promotion_url` is
	// included. URL is used to confirm that the promotion is valid and can be
	// redeemed.
	PromotionUrl string `protobuf:"bytes,31,opt,name=promotion_url,json=promotionUrl,proto3" json:"promotion_url,omitempty"`
}

func (x *Attributes) Reset() {
	*x = Attributes{}
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Attributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Attributes) ProtoMessage() {}

func (x *Attributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Attributes.ProtoReflect.Descriptor instead.
func (*Attributes) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{0}
}

func (x *Attributes) GetProductApplicability() ProductApplicability {
	if x != nil {
		return x.ProductApplicability
	}
	return ProductApplicability_PRODUCT_APPLICABILITY_UNSPECIFIED
}

func (x *Attributes) GetOfferType() OfferType {
	if x != nil {
		return x.OfferType
	}
	return OfferType_OFFER_TYPE_UNSPECIFIED
}

func (x *Attributes) GetGenericRedemptionCode() string {
	if x != nil {
		return x.GenericRedemptionCode
	}
	return ""
}

func (x *Attributes) GetLongTitle() string {
	if x != nil {
		return x.LongTitle
	}
	return ""
}

func (x *Attributes) GetCouponValueType() CouponValueType {
	if x != nil {
		return x.CouponValueType
	}
	return CouponValueType_COUPON_VALUE_TYPE_UNSPECIFIED
}

func (x *Attributes) GetPromotionDestinations() []typepb.Destination_DestinationEnum {
	if x != nil {
		return x.PromotionDestinations
	}
	return nil
}

func (x *Attributes) GetItemIdInclusion() []string {
	if x != nil {
		return x.ItemIdInclusion
	}
	return nil
}

func (x *Attributes) GetBrandInclusion() []string {
	if x != nil {
		return x.BrandInclusion
	}
	return nil
}

func (x *Attributes) GetItemGroupIdInclusion() []string {
	if x != nil {
		return x.ItemGroupIdInclusion
	}
	return nil
}

func (x *Attributes) GetProductTypeInclusion() []string {
	if x != nil {
		return x.ProductTypeInclusion
	}
	return nil
}

func (x *Attributes) GetItemIdExclusion() []string {
	if x != nil {
		return x.ItemIdExclusion
	}
	return nil
}

func (x *Attributes) GetBrandExclusion() []string {
	if x != nil {
		return x.BrandExclusion
	}
	return nil
}

func (x *Attributes) GetItemGroupIdExclusion() []string {
	if x != nil {
		return x.ItemGroupIdExclusion
	}
	return nil
}

func (x *Attributes) GetProductTypeExclusion() []string {
	if x != nil {
		return x.ProductTypeExclusion
	}
	return nil
}

func (x *Attributes) GetMinimumPurchaseAmount() *typepb.Price {
	if x != nil {
		return x.MinimumPurchaseAmount
	}
	return nil
}

func (x *Attributes) GetMinimumPurchaseQuantity() int64 {
	if x != nil {
		return x.MinimumPurchaseQuantity
	}
	return 0
}

func (x *Attributes) GetLimitQuantity() int64 {
	if x != nil {
		return x.LimitQuantity
	}
	return 0
}

func (x *Attributes) GetLimitValue() *typepb.Price {
	if x != nil {
		return x.LimitValue
	}
	return nil
}

func (x *Attributes) GetPercentOff() int64 {
	if x != nil {
		return x.PercentOff
	}
	return 0
}

func (x *Attributes) GetMoneyOffAmount() *typepb.Price {
	if x != nil {
		return x.MoneyOffAmount
	}
	return nil
}

func (x *Attributes) GetGetThisQuantityDiscounted() int64 {
	if x != nil {
		return x.GetThisQuantityDiscounted
	}
	return 0
}

func (x *Attributes) GetFreeGiftValue() *typepb.Price {
	if x != nil {
		return x.FreeGiftValue
	}
	return nil
}

func (x *Attributes) GetFreeGiftDescription() string {
	if x != nil {
		return x.FreeGiftDescription
	}
	return ""
}

func (x *Attributes) GetFreeGiftItemId() string {
	if x != nil {
		return x.FreeGiftItemId
	}
	return ""
}

func (x *Attributes) GetPromotionEffectiveTimePeriod() *interval.Interval {
	if x != nil {
		return x.PromotionEffectiveTimePeriod
	}
	return nil
}

func (x *Attributes) GetPromotionDisplayTimePeriod() *interval.Interval {
	if x != nil {
		return x.PromotionDisplayTimePeriod
	}
	return nil
}

func (x *Attributes) GetStoreApplicability() StoreApplicability {
	if x != nil {
		return x.StoreApplicability
	}
	return StoreApplicability_STORE_APPLICABILITY_UNSPECIFIED
}

func (x *Attributes) GetStoreCodesInclusion() []string {
	if x != nil {
		return x.StoreCodesInclusion
	}
	return nil
}

func (x *Attributes) GetStoreCodesExclusion() []string {
	if x != nil {
		return x.StoreCodesExclusion
	}
	return nil
}

func (x *Attributes) GetPromotionUrl() string {
	if x != nil {
		return x.PromotionUrl
	}
	return ""
}

// The status of the promotion.
type PromotionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The intended destinations for the promotion.
	DestinationStatuses []*PromotionStatus_DestinationStatus `protobuf:"bytes,1,rep,name=destination_statuses,json=destinationStatuses,proto3" json:"destination_statuses,omitempty"`
	// Output only. A list of issues associated with the promotion.
	ItemLevelIssues []*PromotionStatus_ItemLevelIssue `protobuf:"bytes,2,rep,name=item_level_issues,json=itemLevelIssues,proto3" json:"item_level_issues,omitempty"`
	// Output only. Date on which the promotion has been created
	// in [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time,
	// and offset, for example `2020-01-02T09:00:00+01:00` or
	// `2020-01-02T09:00:00Z`
	CreationDate *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=creation_date,json=creationDate,proto3" json:"creation_date,omitempty"`
	// Output only. Date on which the promotion status has been last updated
	// in [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time,
	// and offset, for example `2020-01-02T09:00:00+01:00` or
	// `2020-01-02T09:00:00Z`
	LastUpdateDate *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_update_date,json=lastUpdateDate,proto3" json:"last_update_date,omitempty"`
}

func (x *PromotionStatus) Reset() {
	*x = PromotionStatus{}
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PromotionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromotionStatus) ProtoMessage() {}

func (x *PromotionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromotionStatus.ProtoReflect.Descriptor instead.
func (*PromotionStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{1}
}

func (x *PromotionStatus) GetDestinationStatuses() []*PromotionStatus_DestinationStatus {
	if x != nil {
		return x.DestinationStatuses
	}
	return nil
}

func (x *PromotionStatus) GetItemLevelIssues() []*PromotionStatus_ItemLevelIssue {
	if x != nil {
		return x.ItemLevelIssues
	}
	return nil
}

func (x *PromotionStatus) GetCreationDate() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationDate
	}
	return nil
}

func (x *PromotionStatus) GetLastUpdateDate() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateDate
	}
	return nil
}

// The status for the specified destination.
type PromotionStatus_DestinationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the promotion destination.
	ReportingContext typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,1,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum" json:"reporting_context,omitempty"`
	// Output only. The status for the specified destination.
	Status PromotionStatus_DestinationStatus_State `protobuf:"varint,2,opt,name=status,proto3,enum=google.shopping.merchant.promotions.v1beta.PromotionStatus_DestinationStatus_State" json:"status,omitempty"`
}

func (x *PromotionStatus_DestinationStatus) Reset() {
	*x = PromotionStatus_DestinationStatus{}
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PromotionStatus_DestinationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromotionStatus_DestinationStatus) ProtoMessage() {}

func (x *PromotionStatus_DestinationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromotionStatus_DestinationStatus.ProtoReflect.Descriptor instead.
func (*PromotionStatus_DestinationStatus) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{1, 0}
}

func (x *PromotionStatus_DestinationStatus) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil {
		return x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

func (x *PromotionStatus_DestinationStatus) GetStatus() PromotionStatus_DestinationStatus_State {
	if x != nil {
		return x.Status
	}
	return PromotionStatus_DestinationStatus_STATE_UNSPECIFIED
}

// The issue associated with the promotion.
type PromotionStatus_ItemLevelIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The error code of the issue.
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	// Output only. How this issue affects serving of the promotion.
	Severity PromotionStatus_ItemLevelIssue_Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=google.shopping.merchant.promotions.v1beta.PromotionStatus_ItemLevelIssue_Severity" json:"severity,omitempty"`
	// Output only. Whether the issue can be resolved by the merchant.
	Resolution string `protobuf:"bytes,3,opt,name=resolution,proto3" json:"resolution,omitempty"`
	// Output only. The attribute's name, if the issue is caused by a single
	// attribute.
	Attribute string `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
	// Output only. The destination the issue applies to.
	ReportingContext typepb.ReportingContext_ReportingContextEnum `protobuf:"varint,5,opt,name=reporting_context,json=reportingContext,proto3,enum=google.shopping.type.ReportingContext_ReportingContextEnum" json:"reporting_context,omitempty"`
	// Output only. A short issue description in English.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. A detailed issue description in English.
	Detail string `protobuf:"bytes,7,opt,name=detail,proto3" json:"detail,omitempty"`
	// Output only. The URL of a web page to help with resolving this issue.
	Documentation string `protobuf:"bytes,8,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// Output only. List of country codes (ISO 3166-1 alpha-2) where issue
	// applies to the offer.
	ApplicableCountries []string `protobuf:"bytes,9,rep,name=applicable_countries,json=applicableCountries,proto3" json:"applicable_countries,omitempty"`
}

func (x *PromotionStatus_ItemLevelIssue) Reset() {
	*x = PromotionStatus_ItemLevelIssue{}
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PromotionStatus_ItemLevelIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromotionStatus_ItemLevelIssue) ProtoMessage() {}

func (x *PromotionStatus_ItemLevelIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromotionStatus_ItemLevelIssue.ProtoReflect.Descriptor instead.
func (*PromotionStatus_ItemLevelIssue) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP(), []int{1, 1}
}

func (x *PromotionStatus_ItemLevelIssue) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *PromotionStatus_ItemLevelIssue) GetSeverity() PromotionStatus_ItemLevelIssue_Severity {
	if x != nil {
		return x.Severity
	}
	return PromotionStatus_ItemLevelIssue_SEVERITY_UNSPECIFIED
}

func (x *PromotionStatus_ItemLevelIssue) GetResolution() string {
	if x != nil {
		return x.Resolution
	}
	return ""
}

func (x *PromotionStatus_ItemLevelIssue) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

func (x *PromotionStatus_ItemLevelIssue) GetReportingContext() typepb.ReportingContext_ReportingContextEnum {
	if x != nil {
		return x.ReportingContext
	}
	return typepb.ReportingContext_ReportingContextEnum(0)
}

func (x *PromotionStatus_ItemLevelIssue) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PromotionStatus_ItemLevelIssue) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

func (x *PromotionStatus_ItemLevelIssue) GetDocumentation() string {
	if x != nil {
		return x.Documentation
	}
	return ""
}

func (x *PromotionStatus_ItemLevelIssue) GetApplicableCountries() []string {
	if x != nil {
		return x.ApplicableCountries
	}
	return nil
}

var File_google_shopping_merchant_promotions_v1beta_promotions_common_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDesc = []byte{
	0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x96, 0x10, 0x0a, 0x0a, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x7a, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x59, 0x0a, 0x0a, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x66, 0x66,
	0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x5f, 0x72, 0x65, 0x64, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x52, 0x65, 0x64, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6c, 0x6f,
	0x6e, 0x67, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x6c, 0x0a, 0x11, 0x63, 0x6f, 0x75, 0x70, 0x6f,
	0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x6f, 0x75, 0x70, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x75, 0x70, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x6d, 0x0a, 0x16, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x70,
	0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x5f,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x49, 0x6e, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x17, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x69, 0x64, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x69, 0x74, 0x65, 0x6d, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x39, 0x0a, 0x16, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x74,
	0x65, 0x6d, 0x5f, 0x69, 0x64, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x74, 0x65, 0x6d,
	0x49, 0x64, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x62,
	0x72, 0x61, 0x6e, 0x64, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0c,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x17, 0x69, 0x74, 0x65,
	0x6d, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x14, 0x69, 0x74, 0x65, 0x6d, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x45, 0x78, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x16, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x0e, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x58, 0x0a, 0x17, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x70, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x65, 0x5f, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x15, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x50, 0x75, 0x72, 0x63,
	0x68, 0x61, 0x73, 0x65, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x19, 0x6d, 0x69,
	0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x71,
	0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x17, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x50, 0x75, 0x72, 0x63, 0x68,
	0x61, 0x73, 0x65, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x2a, 0x0a, 0x0e, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x51,
	0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x41, 0x0a, 0x0b, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x70, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x66, 0x66, 0x18, 0x13, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x4f, 0x66, 0x66,
	0x12, 0x4a, 0x0a, 0x10, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x5f, 0x6f, 0x66, 0x66, 0x5f, 0x61, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d, 0x6f,
	0x6e, 0x65, 0x79, 0x4f, 0x66, 0x66, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x1c,
	0x67, 0x65, 0x74, 0x5f, 0x74, 0x68, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x64, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x67, 0x65, 0x74, 0x54, 0x68, 0x69, 0x73,
	0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x65, 0x64, 0x12, 0x48, 0x0a, 0x0f, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x67, 0x69, 0x66, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x66,
	0x72, 0x65, 0x65, 0x47, 0x69, 0x66, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x37, 0x0a, 0x15,
	0x66, 0x72, 0x65, 0x65, 0x5f, 0x67, 0x69, 0x66, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x13, 0x66, 0x72, 0x65, 0x65, 0x47, 0x69, 0x66, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x11, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x67, 0x69,
	0x66, 0x74, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x66, 0x72, 0x65, 0x65, 0x47, 0x69, 0x66, 0x74, 0x49,
	0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x61, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1c, 0x70, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x5d, 0x0a, 0x1d, 0x70, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x70, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x54, 0x69, 0x6d,
	0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x74, 0x0a, 0x13, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x1c,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x37, 0x0a,
	0x15, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x1d, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x13, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x49, 0x6e, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x73, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x1e, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x28, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x70, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x6c, 0x22, 0xe2, 0x0a, 0x0a, 0x0f, 0x50, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x85, 0x01,
	0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x7b, 0x0a, 0x11, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x49, 0x74,
	0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0f, 0x69, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x73, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44,
	0x61, 0x74, 0x65, 0x1a, 0xe2, 0x02, 0x0a, 0x11, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x6d, 0x0a, 0x11, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x75,
	0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x70, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x6c, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e,
	0x5f, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4a,
	0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49, 0x56, 0x45, 0x10,
	0x03, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b,
	0x0a, 0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x1a, 0xd3, 0x04, 0x0a, 0x0e, 0x49, 0x74, 0x65,
	0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x63, 0x6f, 0x64, 0x65, 0x12, 0x74, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x2e, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x21, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x12, 0x6d, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x29, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x36, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x54, 0x0a, 0x08, 0x53, 0x65, 0x76, 0x65,
	0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a,
	0x0b, 0x44, 0x49, 0x53, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x66,
	0x0a, 0x14, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x25, 0x0a, 0x21, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43,
	0x54, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a,
	0x0c, 0x41, 0x4c, 0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x53, 0x10, 0x01, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x5f, 0x50, 0x52, 0x4f, 0x44,
	0x55, 0x43, 0x54, 0x53, 0x10, 0x02, 0x2a, 0x5e, 0x0a, 0x12, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x1f,
	0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x42, 0x49, 0x4c,
	0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x4c, 0x4c, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x53, 0x10,
	0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x43, 0x5f, 0x53, 0x54,
	0x4f, 0x52, 0x45, 0x53, 0x10, 0x02, 0x2a, 0x46, 0x0a, 0x09, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4f, 0x46, 0x46, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x4e, 0x4f, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c,
	0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x10, 0x02, 0x2a, 0x51,
	0x0a, 0x11, 0x52, 0x65, 0x64, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x44, 0x45, 0x4d, 0x50, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x5f, 0x53, 0x54,
	0x4f, 0x52, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x10,
	0x02, 0x2a, 0xd9, 0x02, 0x0a, 0x0f, 0x43, 0x6f, 0x75, 0x70, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x55, 0x50, 0x4f, 0x4e, 0x5f,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x4f, 0x4e, 0x45,
	0x59, 0x5f, 0x4f, 0x46, 0x46, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x45, 0x52, 0x43, 0x45,
	0x4e, 0x54, 0x5f, 0x4f, 0x46, 0x46, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x42, 0x55, 0x59, 0x5f,
	0x4d, 0x5f, 0x47, 0x45, 0x54, 0x5f, 0x4e, 0x5f, 0x4d, 0x4f, 0x4e, 0x45, 0x59, 0x5f, 0x4f, 0x46,
	0x46, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x42, 0x55, 0x59, 0x5f, 0x4d, 0x5f, 0x47, 0x45, 0x54,
	0x5f, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x5f, 0x4f, 0x46, 0x46, 0x10, 0x04,
	0x12, 0x17, 0x0a, 0x13, 0x42, 0x55, 0x59, 0x5f, 0x4d, 0x5f, 0x47, 0x45, 0x54, 0x5f, 0x4d, 0x4f,
	0x4e, 0x45, 0x59, 0x5f, 0x4f, 0x46, 0x46, 0x10, 0x05, 0x12, 0x19, 0x0a, 0x15, 0x42, 0x55, 0x59,
	0x5f, 0x4d, 0x5f, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x5f, 0x4f,
	0x46, 0x46, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x46, 0x52, 0x45, 0x45, 0x5f, 0x47, 0x49, 0x46,
	0x54, 0x10, 0x07, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x52, 0x45, 0x45, 0x5f, 0x47, 0x49, 0x46, 0x54,
	0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x08, 0x12, 0x1a, 0x0a,
	0x16, 0x46, 0x52, 0x45, 0x45, 0x5f, 0x47, 0x49, 0x46, 0x54, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f,
	0x49, 0x54, 0x45, 0x4d, 0x5f, 0x49, 0x44, 0x10, 0x09, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x52, 0x45,
	0x45, 0x5f, 0x53, 0x48, 0x49, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44,
	0x41, 0x52, 0x44, 0x10, 0x0a, 0x12, 0x1b, 0x0a, 0x17, 0x46, 0x52, 0x45, 0x45, 0x5f, 0x53, 0x48,
	0x49, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x56, 0x45, 0x52, 0x4e, 0x49, 0x47, 0x48, 0x54,
	0x10, 0x0b, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x52, 0x45, 0x45, 0x5f, 0x53, 0x48, 0x49, 0x50, 0x50,
	0x49, 0x4e, 0x47, 0x5f, 0x54, 0x57, 0x4f, 0x5f, 0x44, 0x41, 0x59, 0x10, 0x0c, 0x42, 0x9f, 0x01,
	0x0a, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x42, 0x15, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x54, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x70, 0x62, 0x3b, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescData = file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDesc
)

func file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescData)
	})
	return file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDescData
}

var file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_goTypes = []any{
	(ProductApplicability)(0),                         // 0: google.shopping.merchant.promotions.v1beta.ProductApplicability
	(StoreApplicability)(0),                           // 1: google.shopping.merchant.promotions.v1beta.StoreApplicability
	(OfferType)(0),                                    // 2: google.shopping.merchant.promotions.v1beta.OfferType
	(RedemptionChannel)(0),                            // 3: google.shopping.merchant.promotions.v1beta.RedemptionChannel
	(CouponValueType)(0),                              // 4: google.shopping.merchant.promotions.v1beta.CouponValueType
	(PromotionStatus_DestinationStatus_State)(0),      // 5: google.shopping.merchant.promotions.v1beta.PromotionStatus.DestinationStatus.State
	(PromotionStatus_ItemLevelIssue_Severity)(0),      // 6: google.shopping.merchant.promotions.v1beta.PromotionStatus.ItemLevelIssue.Severity
	(*Attributes)(nil),                                // 7: google.shopping.merchant.promotions.v1beta.Attributes
	(*PromotionStatus)(nil),                           // 8: google.shopping.merchant.promotions.v1beta.PromotionStatus
	(*PromotionStatus_DestinationStatus)(nil),         // 9: google.shopping.merchant.promotions.v1beta.PromotionStatus.DestinationStatus
	(*PromotionStatus_ItemLevelIssue)(nil),            // 10: google.shopping.merchant.promotions.v1beta.PromotionStatus.ItemLevelIssue
	(typepb.Destination_DestinationEnum)(0),           // 11: google.shopping.type.Destination.DestinationEnum
	(*typepb.Price)(nil),                              // 12: google.shopping.type.Price
	(*interval.Interval)(nil),                         // 13: google.type.Interval
	(*timestamppb.Timestamp)(nil),                     // 14: google.protobuf.Timestamp
	(typepb.ReportingContext_ReportingContextEnum)(0), // 15: google.shopping.type.ReportingContext.ReportingContextEnum
}
var file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_depIdxs = []int32{
	0,  // 0: google.shopping.merchant.promotions.v1beta.Attributes.product_applicability:type_name -> google.shopping.merchant.promotions.v1beta.ProductApplicability
	2,  // 1: google.shopping.merchant.promotions.v1beta.Attributes.offer_type:type_name -> google.shopping.merchant.promotions.v1beta.OfferType
	4,  // 2: google.shopping.merchant.promotions.v1beta.Attributes.coupon_value_type:type_name -> google.shopping.merchant.promotions.v1beta.CouponValueType
	11, // 3: google.shopping.merchant.promotions.v1beta.Attributes.promotion_destinations:type_name -> google.shopping.type.Destination.DestinationEnum
	12, // 4: google.shopping.merchant.promotions.v1beta.Attributes.minimum_purchase_amount:type_name -> google.shopping.type.Price
	12, // 5: google.shopping.merchant.promotions.v1beta.Attributes.limit_value:type_name -> google.shopping.type.Price
	12, // 6: google.shopping.merchant.promotions.v1beta.Attributes.money_off_amount:type_name -> google.shopping.type.Price
	12, // 7: google.shopping.merchant.promotions.v1beta.Attributes.free_gift_value:type_name -> google.shopping.type.Price
	13, // 8: google.shopping.merchant.promotions.v1beta.Attributes.promotion_effective_time_period:type_name -> google.type.Interval
	13, // 9: google.shopping.merchant.promotions.v1beta.Attributes.promotion_display_time_period:type_name -> google.type.Interval
	1,  // 10: google.shopping.merchant.promotions.v1beta.Attributes.store_applicability:type_name -> google.shopping.merchant.promotions.v1beta.StoreApplicability
	9,  // 11: google.shopping.merchant.promotions.v1beta.PromotionStatus.destination_statuses:type_name -> google.shopping.merchant.promotions.v1beta.PromotionStatus.DestinationStatus
	10, // 12: google.shopping.merchant.promotions.v1beta.PromotionStatus.item_level_issues:type_name -> google.shopping.merchant.promotions.v1beta.PromotionStatus.ItemLevelIssue
	14, // 13: google.shopping.merchant.promotions.v1beta.PromotionStatus.creation_date:type_name -> google.protobuf.Timestamp
	14, // 14: google.shopping.merchant.promotions.v1beta.PromotionStatus.last_update_date:type_name -> google.protobuf.Timestamp
	15, // 15: google.shopping.merchant.promotions.v1beta.PromotionStatus.DestinationStatus.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	5,  // 16: google.shopping.merchant.promotions.v1beta.PromotionStatus.DestinationStatus.status:type_name -> google.shopping.merchant.promotions.v1beta.PromotionStatus.DestinationStatus.State
	6,  // 17: google.shopping.merchant.promotions.v1beta.PromotionStatus.ItemLevelIssue.severity:type_name -> google.shopping.merchant.promotions.v1beta.PromotionStatus.ItemLevelIssue.Severity
	15, // 18: google.shopping.merchant.promotions.v1beta.PromotionStatus.ItemLevelIssue.reporting_context:type_name -> google.shopping.type.ReportingContext.ReportingContextEnum
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_init() }
func file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_init() {
	if File_google_shopping_merchant_promotions_v1beta_promotions_common_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_promotions_v1beta_promotions_common_proto = out.File
	file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_rawDesc = nil
	file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_goTypes = nil
	file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_depIdxs = nil
}
