// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/kubernetes.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Types of Kubernetes roles.
type Kubernetes_Role_Kind int32

const (
	// Role type is not specified.
	Kubernetes_Role_KIND_UNSPECIFIED Kubernetes_Role_Kind = 0
	// Kubernetes Role.
	Kubernetes_Role_ROLE Kubernetes_Role_Kind = 1
	// Kubernetes ClusterRole.
	Kubernetes_Role_CLUSTER_ROLE Kubernetes_Role_Kind = 2
)

// Enum value maps for Kubernetes_Role_Kind.
var (
	Kubernetes_Role_Kind_name = map[int32]string{
		0: "KIND_UNSPECIFIED",
		1: "ROLE",
		2: "CLUSTER_ROLE",
	}
	Kubernetes_Role_Kind_value = map[string]int32{
		"KIND_UNSPECIFIED": 0,
		"ROLE":             1,
		"CLUSTER_ROLE":     2,
	}
)

func (x Kubernetes_Role_Kind) Enum() *Kubernetes_Role_Kind {
	p := new(Kubernetes_Role_Kind)
	*p = x
	return p
}

func (x Kubernetes_Role_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Kubernetes_Role_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_enumTypes[0].Descriptor()
}

func (Kubernetes_Role_Kind) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_kubernetes_proto_enumTypes[0]
}

func (x Kubernetes_Role_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Kubernetes_Role_Kind.Descriptor instead.
func (Kubernetes_Role_Kind) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 3, 0}
}

// Auth types that can be used for the subject's kind field.
type Kubernetes_Subject_AuthType int32

const (
	// Authentication is not specified.
	Kubernetes_Subject_AUTH_TYPE_UNSPECIFIED Kubernetes_Subject_AuthType = 0
	// User with valid certificate.
	Kubernetes_Subject_USER Kubernetes_Subject_AuthType = 1
	// Users managed by Kubernetes API with credentials stored as secrets.
	Kubernetes_Subject_SERVICEACCOUNT Kubernetes_Subject_AuthType = 2
	// Collection of users.
	Kubernetes_Subject_GROUP Kubernetes_Subject_AuthType = 3
)

// Enum value maps for Kubernetes_Subject_AuthType.
var (
	Kubernetes_Subject_AuthType_name = map[int32]string{
		0: "AUTH_TYPE_UNSPECIFIED",
		1: "USER",
		2: "SERVICEACCOUNT",
		3: "GROUP",
	}
	Kubernetes_Subject_AuthType_value = map[string]int32{
		"AUTH_TYPE_UNSPECIFIED": 0,
		"USER":                  1,
		"SERVICEACCOUNT":        2,
		"GROUP":                 3,
	}
)

func (x Kubernetes_Subject_AuthType) Enum() *Kubernetes_Subject_AuthType {
	p := new(Kubernetes_Subject_AuthType)
	*p = x
	return p
}

func (x Kubernetes_Subject_AuthType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Kubernetes_Subject_AuthType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_enumTypes[1].Descriptor()
}

func (Kubernetes_Subject_AuthType) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_kubernetes_proto_enumTypes[1]
}

func (x Kubernetes_Subject_AuthType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Kubernetes_Subject_AuthType.Descriptor instead.
func (Kubernetes_Subject_AuthType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 5, 0}
}

// Kubernetes-related attributes.
type Kubernetes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kubernetes
	// [Pods](https://cloud.google.com/kubernetes-engine/docs/concepts/pod)
	// associated with the finding. This field contains Pod records for each
	// container that is owned by a Pod.
	Pods []*Kubernetes_Pod `protobuf:"bytes,1,rep,name=pods,proto3" json:"pods,omitempty"`
	// Provides Kubernetes
	// [node](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture#nodes)
	// information.
	Nodes []*Kubernetes_Node `protobuf:"bytes,2,rep,name=nodes,proto3" json:"nodes,omitempty"`
	// GKE [node
	// pools](https://cloud.google.com/kubernetes-engine/docs/concepts/node-pools)
	// associated with the finding. This field contains node pool information for
	// each node, when it is available.
	NodePools []*Kubernetes_NodePool `protobuf:"bytes,3,rep,name=node_pools,json=nodePools,proto3" json:"node_pools,omitempty"`
	// Provides Kubernetes role information for findings that involve [Roles or
	// ClusterRoles](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
	Roles []*Kubernetes_Role `protobuf:"bytes,4,rep,name=roles,proto3" json:"roles,omitempty"`
	// Provides Kubernetes role binding information for findings that involve
	// [RoleBindings or
	// ClusterRoleBindings](https://cloud.google.com/kubernetes-engine/docs/how-to/role-based-access-control).
	Bindings []*Kubernetes_Binding `protobuf:"bytes,5,rep,name=bindings,proto3" json:"bindings,omitempty"`
	// Provides information on any Kubernetes access reviews (privilege checks)
	// relevant to the finding.
	AccessReviews []*Kubernetes_AccessReview `protobuf:"bytes,6,rep,name=access_reviews,json=accessReviews,proto3" json:"access_reviews,omitempty"`
	// Kubernetes objects related to the finding.
	Objects []*Kubernetes_Object `protobuf:"bytes,7,rep,name=objects,proto3" json:"objects,omitempty"`
}

func (x *Kubernetes) Reset() {
	*x = Kubernetes{}
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kubernetes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kubernetes) ProtoMessage() {}

func (x *Kubernetes) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kubernetes.ProtoReflect.Descriptor instead.
func (*Kubernetes) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0}
}

func (x *Kubernetes) GetPods() []*Kubernetes_Pod {
	if x != nil {
		return x.Pods
	}
	return nil
}

func (x *Kubernetes) GetNodes() []*Kubernetes_Node {
	if x != nil {
		return x.Nodes
	}
	return nil
}

func (x *Kubernetes) GetNodePools() []*Kubernetes_NodePool {
	if x != nil {
		return x.NodePools
	}
	return nil
}

func (x *Kubernetes) GetRoles() []*Kubernetes_Role {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *Kubernetes) GetBindings() []*Kubernetes_Binding {
	if x != nil {
		return x.Bindings
	}
	return nil
}

func (x *Kubernetes) GetAccessReviews() []*Kubernetes_AccessReview {
	if x != nil {
		return x.AccessReviews
	}
	return nil
}

func (x *Kubernetes) GetObjects() []*Kubernetes_Object {
	if x != nil {
		return x.Objects
	}
	return nil
}

// A Kubernetes Pod.
type Kubernetes_Pod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kubernetes Pod namespace.
	Ns string `protobuf:"bytes,1,opt,name=ns,proto3" json:"ns,omitempty"`
	// Kubernetes Pod name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Pod labels.  For Kubernetes containers, these are applied to the
	// container.
	Labels []*Label `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty"`
	// Pod containers associated with this finding, if any.
	Containers []*Container `protobuf:"bytes,4,rep,name=containers,proto3" json:"containers,omitempty"`
}

func (x *Kubernetes_Pod) Reset() {
	*x = Kubernetes_Pod{}
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kubernetes_Pod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kubernetes_Pod) ProtoMessage() {}

func (x *Kubernetes_Pod) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kubernetes_Pod.ProtoReflect.Descriptor instead.
func (*Kubernetes_Pod) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Kubernetes_Pod) GetNs() string {
	if x != nil {
		return x.Ns
	}
	return ""
}

func (x *Kubernetes_Pod) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Kubernetes_Pod) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Kubernetes_Pod) GetContainers() []*Container {
	if x != nil {
		return x.Containers
	}
	return nil
}

// Kubernetes nodes associated with the finding.
type Kubernetes_Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Full resource name](https://google.aip.dev/122#full-resource-names) of
	// the Compute Engine VM running the cluster node.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Kubernetes_Node) Reset() {
	*x = Kubernetes_Node{}
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kubernetes_Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kubernetes_Node) ProtoMessage() {}

func (x *Kubernetes_Node) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kubernetes_Node.ProtoReflect.Descriptor instead.
func (*Kubernetes_Node) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Kubernetes_Node) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Provides GKE node pool information.
type Kubernetes_NodePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kubernetes node pool name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Nodes associated with the finding.
	Nodes []*Kubernetes_Node `protobuf:"bytes,2,rep,name=nodes,proto3" json:"nodes,omitempty"`
}

func (x *Kubernetes_NodePool) Reset() {
	*x = Kubernetes_NodePool{}
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kubernetes_NodePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kubernetes_NodePool) ProtoMessage() {}

func (x *Kubernetes_NodePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kubernetes_NodePool.ProtoReflect.Descriptor instead.
func (*Kubernetes_NodePool) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Kubernetes_NodePool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Kubernetes_NodePool) GetNodes() []*Kubernetes_Node {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// Kubernetes Role or ClusterRole.
type Kubernetes_Role struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Role type.
	Kind Kubernetes_Role_Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=google.cloud.securitycenter.v2.Kubernetes_Role_Kind" json:"kind,omitempty"`
	// Role namespace.
	Ns string `protobuf:"bytes,2,opt,name=ns,proto3" json:"ns,omitempty"`
	// Role name.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Kubernetes_Role) Reset() {
	*x = Kubernetes_Role{}
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kubernetes_Role) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kubernetes_Role) ProtoMessage() {}

func (x *Kubernetes_Role) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kubernetes_Role.ProtoReflect.Descriptor instead.
func (*Kubernetes_Role) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Kubernetes_Role) GetKind() Kubernetes_Role_Kind {
	if x != nil {
		return x.Kind
	}
	return Kubernetes_Role_KIND_UNSPECIFIED
}

func (x *Kubernetes_Role) GetNs() string {
	if x != nil {
		return x.Ns
	}
	return ""
}

func (x *Kubernetes_Role) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents a Kubernetes RoleBinding or ClusterRoleBinding.
type Kubernetes_Binding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Namespace for the binding.
	Ns string `protobuf:"bytes,1,opt,name=ns,proto3" json:"ns,omitempty"`
	// Name for the binding.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The Role or ClusterRole referenced by the binding.
	Role *Kubernetes_Role `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
	// Represents one or more subjects that are bound to the role. Not always
	// available for PATCH requests.
	Subjects []*Kubernetes_Subject `protobuf:"bytes,4,rep,name=subjects,proto3" json:"subjects,omitempty"`
}

func (x *Kubernetes_Binding) Reset() {
	*x = Kubernetes_Binding{}
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kubernetes_Binding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kubernetes_Binding) ProtoMessage() {}

func (x *Kubernetes_Binding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kubernetes_Binding.ProtoReflect.Descriptor instead.
func (*Kubernetes_Binding) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Kubernetes_Binding) GetNs() string {
	if x != nil {
		return x.Ns
	}
	return ""
}

func (x *Kubernetes_Binding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Kubernetes_Binding) GetRole() *Kubernetes_Role {
	if x != nil {
		return x.Role
	}
	return nil
}

func (x *Kubernetes_Binding) GetSubjects() []*Kubernetes_Subject {
	if x != nil {
		return x.Subjects
	}
	return nil
}

// Represents a Kubernetes subject.
type Kubernetes_Subject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Authentication type for the subject.
	Kind Kubernetes_Subject_AuthType `protobuf:"varint,1,opt,name=kind,proto3,enum=google.cloud.securitycenter.v2.Kubernetes_Subject_AuthType" json:"kind,omitempty"`
	// Namespace for the subject.
	Ns string `protobuf:"bytes,2,opt,name=ns,proto3" json:"ns,omitempty"`
	// Name for the subject.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Kubernetes_Subject) Reset() {
	*x = Kubernetes_Subject{}
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kubernetes_Subject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kubernetes_Subject) ProtoMessage() {}

func (x *Kubernetes_Subject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kubernetes_Subject.ProtoReflect.Descriptor instead.
func (*Kubernetes_Subject) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Kubernetes_Subject) GetKind() Kubernetes_Subject_AuthType {
	if x != nil {
		return x.Kind
	}
	return Kubernetes_Subject_AUTH_TYPE_UNSPECIFIED
}

func (x *Kubernetes_Subject) GetNs() string {
	if x != nil {
		return x.Ns
	}
	return ""
}

func (x *Kubernetes_Subject) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Conveys information about a Kubernetes access review (such as one returned
// by a [`kubectl auth
// can-i`](https://kubernetes.io/docs/reference/access-authn-authz/authorization/#checking-api-access)
// command) that was involved in a finding.
type Kubernetes_AccessReview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The API group of the resource. "*" means all.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// Namespace of the action being requested. Currently, there is no
	// distinction between no namespace and all namespaces.  Both
	// are represented by "" (empty).
	Ns string `protobuf:"bytes,2,opt,name=ns,proto3" json:"ns,omitempty"`
	// The name of the resource being requested. Empty means all.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The optional resource type requested. "*" means all.
	Resource string `protobuf:"bytes,4,opt,name=resource,proto3" json:"resource,omitempty"`
	// The optional subresource type.
	Subresource string `protobuf:"bytes,5,opt,name=subresource,proto3" json:"subresource,omitempty"`
	// A Kubernetes resource API verb, like get, list, watch, create, update,
	// delete, proxy. "*" means all.
	Verb string `protobuf:"bytes,6,opt,name=verb,proto3" json:"verb,omitempty"`
	// The API version of the resource. "*" means all.
	Version string `protobuf:"bytes,7,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Kubernetes_AccessReview) Reset() {
	*x = Kubernetes_AccessReview{}
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kubernetes_AccessReview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kubernetes_AccessReview) ProtoMessage() {}

func (x *Kubernetes_AccessReview) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kubernetes_AccessReview.ProtoReflect.Descriptor instead.
func (*Kubernetes_AccessReview) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Kubernetes_AccessReview) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *Kubernetes_AccessReview) GetNs() string {
	if x != nil {
		return x.Ns
	}
	return ""
}

func (x *Kubernetes_AccessReview) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Kubernetes_AccessReview) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *Kubernetes_AccessReview) GetSubresource() string {
	if x != nil {
		return x.Subresource
	}
	return ""
}

func (x *Kubernetes_AccessReview) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *Kubernetes_AccessReview) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Kubernetes object related to the finding, uniquely identified by GKNN.
// Used if the object Kind is not one of Pod, Node, NodePool, Binding, or
// AccessReview.
type Kubernetes_Object struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kubernetes object group, such as "policy.k8s.io/v1".
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// Kubernetes object kind, such as "Namespace".
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	// Kubernetes object namespace. Must be a valid DNS label. Named
	// "ns" to avoid collision with C++ namespace keyword. For details see
	// https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
	Ns string `protobuf:"bytes,3,opt,name=ns,proto3" json:"ns,omitempty"`
	// Kubernetes object name. For details see
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/names/.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Pod containers associated with this finding, if any.
	Containers []*Container `protobuf:"bytes,5,rep,name=containers,proto3" json:"containers,omitempty"`
}

func (x *Kubernetes_Object) Reset() {
	*x = Kubernetes_Object{}
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Kubernetes_Object) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Kubernetes_Object) ProtoMessage() {}

func (x *Kubernetes_Object) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Kubernetes_Object.ProtoReflect.Descriptor instead.
func (*Kubernetes_Object) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Kubernetes_Object) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *Kubernetes_Object) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Kubernetes_Object) GetNs() string {
	if x != nil {
		return x.Ns
	}
	return ""
}

func (x *Kubernetes_Object) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Kubernetes_Object) GetContainers() []*Container {
	if x != nil {
		return x.Containers
	}
	return nil
}

var File_google_cloud_securitycenter_v2_kubernetes_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_kubernetes_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x32, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8a, 0x0e,
	0x0a, 0x0a, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x04,
	0x70, 0x6f, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x50, 0x6f, 0x64, 0x52, 0x04, 0x70, 0x6f, 0x64, 0x73,
	0x12, 0x45, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x75, 0x62,
	0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x45, 0x0a, 0x05, 0x72,
	0x6f, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x6f, 0x6c,
	0x65, 0x73, 0x12, 0x4e, 0x0a, 0x08, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73,
	0x2e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x5e, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x52, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x12, 0x4b, 0x0a, 0x07, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x1a,
	0xb3, 0x01, 0x0a, 0x03, 0x50, 0x6f, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x49, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x73, 0x1a, 0x1a, 0x0a, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x1a, 0x65, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x45, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x1a, 0xae, 0x01, 0x0a, 0x04, 0x52, 0x6f, 0x6c,
	0x65, 0x12, 0x48, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x65,
	0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x38, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x10, 0x4b, 0x49, 0x4e, 0x44, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x52, 0x4f, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x4c, 0x55, 0x53, 0x54,
	0x45, 0x52, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x10, 0x02, 0x1a, 0xc2, 0x01, 0x0a, 0x07, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x04, 0x72, 0x6f, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65,
	0x74, 0x65, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x4e,
	0x0a, 0x08, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x2e, 0x53, 0x75, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x1a, 0xce,
	0x01, 0x0a, 0x07, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x4e, 0x0a, 0x08, 0x41, 0x75, 0x74, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x41,
	0x55, 0x54, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01,
	0x12, 0x12, 0x0a, 0x0e, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x41, 0x43, 0x43, 0x4f, 0x55,
	0x4e, 0x54, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0x03, 0x1a,
	0xb4, 0x01, 0x0a, 0x0c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x0e, 0x0a, 0x02, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x75, 0x62,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xa1, 0x01, 0x0a, 0x06, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x49, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x0a,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x42, 0xe9, 0x01, 0x0a, 0x22, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x42, 0x0f, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62,
	0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56,
	0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c,
	0x56, 0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescData = file_google_cloud_securitycenter_v2_kubernetes_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_kubernetes_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_kubernetes_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_securitycenter_v2_kubernetes_proto_goTypes = []any{
	(Kubernetes_Role_Kind)(0),        // 0: google.cloud.securitycenter.v2.Kubernetes.Role.Kind
	(Kubernetes_Subject_AuthType)(0), // 1: google.cloud.securitycenter.v2.Kubernetes.Subject.AuthType
	(*Kubernetes)(nil),               // 2: google.cloud.securitycenter.v2.Kubernetes
	(*Kubernetes_Pod)(nil),           // 3: google.cloud.securitycenter.v2.Kubernetes.Pod
	(*Kubernetes_Node)(nil),          // 4: google.cloud.securitycenter.v2.Kubernetes.Node
	(*Kubernetes_NodePool)(nil),      // 5: google.cloud.securitycenter.v2.Kubernetes.NodePool
	(*Kubernetes_Role)(nil),          // 6: google.cloud.securitycenter.v2.Kubernetes.Role
	(*Kubernetes_Binding)(nil),       // 7: google.cloud.securitycenter.v2.Kubernetes.Binding
	(*Kubernetes_Subject)(nil),       // 8: google.cloud.securitycenter.v2.Kubernetes.Subject
	(*Kubernetes_AccessReview)(nil),  // 9: google.cloud.securitycenter.v2.Kubernetes.AccessReview
	(*Kubernetes_Object)(nil),        // 10: google.cloud.securitycenter.v2.Kubernetes.Object
	(*Label)(nil),                    // 11: google.cloud.securitycenter.v2.Label
	(*Container)(nil),                // 12: google.cloud.securitycenter.v2.Container
}
var file_google_cloud_securitycenter_v2_kubernetes_proto_depIdxs = []int32{
	3,  // 0: google.cloud.securitycenter.v2.Kubernetes.pods:type_name -> google.cloud.securitycenter.v2.Kubernetes.Pod
	4,  // 1: google.cloud.securitycenter.v2.Kubernetes.nodes:type_name -> google.cloud.securitycenter.v2.Kubernetes.Node
	5,  // 2: google.cloud.securitycenter.v2.Kubernetes.node_pools:type_name -> google.cloud.securitycenter.v2.Kubernetes.NodePool
	6,  // 3: google.cloud.securitycenter.v2.Kubernetes.roles:type_name -> google.cloud.securitycenter.v2.Kubernetes.Role
	7,  // 4: google.cloud.securitycenter.v2.Kubernetes.bindings:type_name -> google.cloud.securitycenter.v2.Kubernetes.Binding
	9,  // 5: google.cloud.securitycenter.v2.Kubernetes.access_reviews:type_name -> google.cloud.securitycenter.v2.Kubernetes.AccessReview
	10, // 6: google.cloud.securitycenter.v2.Kubernetes.objects:type_name -> google.cloud.securitycenter.v2.Kubernetes.Object
	11, // 7: google.cloud.securitycenter.v2.Kubernetes.Pod.labels:type_name -> google.cloud.securitycenter.v2.Label
	12, // 8: google.cloud.securitycenter.v2.Kubernetes.Pod.containers:type_name -> google.cloud.securitycenter.v2.Container
	4,  // 9: google.cloud.securitycenter.v2.Kubernetes.NodePool.nodes:type_name -> google.cloud.securitycenter.v2.Kubernetes.Node
	0,  // 10: google.cloud.securitycenter.v2.Kubernetes.Role.kind:type_name -> google.cloud.securitycenter.v2.Kubernetes.Role.Kind
	6,  // 11: google.cloud.securitycenter.v2.Kubernetes.Binding.role:type_name -> google.cloud.securitycenter.v2.Kubernetes.Role
	8,  // 12: google.cloud.securitycenter.v2.Kubernetes.Binding.subjects:type_name -> google.cloud.securitycenter.v2.Kubernetes.Subject
	1,  // 13: google.cloud.securitycenter.v2.Kubernetes.Subject.kind:type_name -> google.cloud.securitycenter.v2.Kubernetes.Subject.AuthType
	12, // 14: google.cloud.securitycenter.v2.Kubernetes.Object.containers:type_name -> google.cloud.securitycenter.v2.Container
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_kubernetes_proto_init() }
func file_google_cloud_securitycenter_v2_kubernetes_proto_init() {
	if File_google_cloud_securitycenter_v2_kubernetes_proto != nil {
		return
	}
	file_google_cloud_securitycenter_v2_container_proto_init()
	file_google_cloud_securitycenter_v2_label_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_kubernetes_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_kubernetes_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_kubernetes_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_kubernetes_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_kubernetes_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_kubernetes_proto = out.File
	file_google_cloud_securitycenter_v2_kubernetes_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_kubernetes_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_kubernetes_proto_depIdxs = nil
}
