// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/policytroubleshooter/v1/explanations.proto

package policytroubleshooterpb

import (
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	expr "google.golang.org/genproto/googleapis/type/expr"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Whether a principal has a permission for a resource.
type AccessState int32

const (
	// Default value. This value is unused.
	AccessState_ACCESS_STATE_UNSPECIFIED AccessState = 0
	// The principal has the permission.
	AccessState_GRANTED AccessState = 1
	// The principal does not have the permission.
	AccessState_NOT_GRANTED AccessState = 2
	// The principal has the permission only if a condition expression evaluates
	// to `true`.
	AccessState_UNKNOWN_CONDITIONAL AccessState = 3
	// The sender of the request does not have access to all of the policies that
	// Policy Troubleshooter needs to evaluate.
	AccessState_UNKNOWN_INFO_DENIED AccessState = 4
)

// Enum value maps for AccessState.
var (
	AccessState_name = map[int32]string{
		0: "ACCESS_STATE_UNSPECIFIED",
		1: "GRANTED",
		2: "NOT_GRANTED",
		3: "UNKNOWN_CONDITIONAL",
		4: "UNKNOWN_INFO_DENIED",
	}
	AccessState_value = map[string]int32{
		"ACCESS_STATE_UNSPECIFIED": 0,
		"GRANTED":                  1,
		"NOT_GRANTED":              2,
		"UNKNOWN_CONDITIONAL":      3,
		"UNKNOWN_INFO_DENIED":      4,
	}
)

func (x AccessState) Enum() *AccessState {
	p := new(AccessState)
	*p = x
	return p
}

func (x AccessState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes[0].Descriptor()
}

func (AccessState) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes[0]
}

func (x AccessState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessState.Descriptor instead.
func (AccessState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescGZIP(), []int{0}
}

// The extent to which a single data point, such as the existence of a binding
// or whether a binding includes a specific principal, contributes to an overall
// determination.
type HeuristicRelevance int32

const (
	// Default value. This value is unused.
	HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED HeuristicRelevance = 0
	// The data point has a limited effect on the result. Changing the data point
	// is unlikely to affect the overall determination.
	HeuristicRelevance_NORMAL HeuristicRelevance = 1
	// The data point has a strong effect on the result. Changing the data point
	// is likely to affect the overall determination.
	HeuristicRelevance_HIGH HeuristicRelevance = 2
)

// Enum value maps for HeuristicRelevance.
var (
	HeuristicRelevance_name = map[int32]string{
		0: "HEURISTIC_RELEVANCE_UNSPECIFIED",
		1: "NORMAL",
		2: "HIGH",
	}
	HeuristicRelevance_value = map[string]int32{
		"HEURISTIC_RELEVANCE_UNSPECIFIED": 0,
		"NORMAL":                          1,
		"HIGH":                            2,
	}
)

func (x HeuristicRelevance) Enum() *HeuristicRelevance {
	p := new(HeuristicRelevance)
	*p = x
	return p
}

func (x HeuristicRelevance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HeuristicRelevance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes[1].Descriptor()
}

func (HeuristicRelevance) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes[1]
}

func (x HeuristicRelevance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HeuristicRelevance.Descriptor instead.
func (HeuristicRelevance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescGZIP(), []int{1}
}

// Whether a role includes a specific permission.
type BindingExplanation_RolePermission int32

const (
	// Default value. This value is unused.
	BindingExplanation_ROLE_PERMISSION_UNSPECIFIED BindingExplanation_RolePermission = 0
	// The permission is included in the role.
	BindingExplanation_ROLE_PERMISSION_INCLUDED BindingExplanation_RolePermission = 1
	// The permission is not included in the role.
	BindingExplanation_ROLE_PERMISSION_NOT_INCLUDED BindingExplanation_RolePermission = 2
	// The sender of the request is not allowed to access the binding.
	BindingExplanation_ROLE_PERMISSION_UNKNOWN_INFO_DENIED BindingExplanation_RolePermission = 3
)

// Enum value maps for BindingExplanation_RolePermission.
var (
	BindingExplanation_RolePermission_name = map[int32]string{
		0: "ROLE_PERMISSION_UNSPECIFIED",
		1: "ROLE_PERMISSION_INCLUDED",
		2: "ROLE_PERMISSION_NOT_INCLUDED",
		3: "ROLE_PERMISSION_UNKNOWN_INFO_DENIED",
	}
	BindingExplanation_RolePermission_value = map[string]int32{
		"ROLE_PERMISSION_UNSPECIFIED":         0,
		"ROLE_PERMISSION_INCLUDED":            1,
		"ROLE_PERMISSION_NOT_INCLUDED":        2,
		"ROLE_PERMISSION_UNKNOWN_INFO_DENIED": 3,
	}
)

func (x BindingExplanation_RolePermission) Enum() *BindingExplanation_RolePermission {
	p := new(BindingExplanation_RolePermission)
	*p = x
	return p
}

func (x BindingExplanation_RolePermission) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BindingExplanation_RolePermission) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes[2].Descriptor()
}

func (BindingExplanation_RolePermission) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes[2]
}

func (x BindingExplanation_RolePermission) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BindingExplanation_RolePermission.Descriptor instead.
func (BindingExplanation_RolePermission) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescGZIP(), []int{2, 0}
}

// Whether the binding includes the principal.
type BindingExplanation_Membership int32

const (
	// Default value. This value is unused.
	BindingExplanation_MEMBERSHIP_UNSPECIFIED BindingExplanation_Membership = 0
	// The binding includes the principal. The principal can be included
	// directly or indirectly. For example:
	//
	//   - A principal is included directly if that principal is listed in the
	//     binding.
	//   - A principal is included indirectly if that principal is in a Google
	//     group or Google Workspace domain that is listed in the binding.
	BindingExplanation_MEMBERSHIP_INCLUDED BindingExplanation_Membership = 1
	// The binding does not include the principal.
	BindingExplanation_MEMBERSHIP_NOT_INCLUDED BindingExplanation_Membership = 2
	// The sender of the request is not allowed to access the binding.
	BindingExplanation_MEMBERSHIP_UNKNOWN_INFO_DENIED BindingExplanation_Membership = 3
	// The principal is an unsupported type. Only Google Accounts and service
	// accounts are supported.
	BindingExplanation_MEMBERSHIP_UNKNOWN_UNSUPPORTED BindingExplanation_Membership = 4
)

// Enum value maps for BindingExplanation_Membership.
var (
	BindingExplanation_Membership_name = map[int32]string{
		0: "MEMBERSHIP_UNSPECIFIED",
		1: "MEMBERSHIP_INCLUDED",
		2: "MEMBERSHIP_NOT_INCLUDED",
		3: "MEMBERSHIP_UNKNOWN_INFO_DENIED",
		4: "MEMBERSHIP_UNKNOWN_UNSUPPORTED",
	}
	BindingExplanation_Membership_value = map[string]int32{
		"MEMBERSHIP_UNSPECIFIED":         0,
		"MEMBERSHIP_INCLUDED":            1,
		"MEMBERSHIP_NOT_INCLUDED":        2,
		"MEMBERSHIP_UNKNOWN_INFO_DENIED": 3,
		"MEMBERSHIP_UNKNOWN_UNSUPPORTED": 4,
	}
)

func (x BindingExplanation_Membership) Enum() *BindingExplanation_Membership {
	p := new(BindingExplanation_Membership)
	*p = x
	return p
}

func (x BindingExplanation_Membership) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BindingExplanation_Membership) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes[3].Descriptor()
}

func (BindingExplanation_Membership) Type() protoreflect.EnumType {
	return &file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes[3]
}

func (x BindingExplanation_Membership) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BindingExplanation_Membership.Descriptor instead.
func (BindingExplanation_Membership) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescGZIP(), []int{2, 1}
}

// Information about the principal, resource, and permission to check.
type AccessTuple struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The principal whose access you want to check, in the form of
	// the email address that represents that principal. For example,
	// `alice@example.com` or
	// `my-service-account@my-project.iam.gserviceaccount.com`.
	//
	// The principal must be a Google Account or a service account. Other types of
	// principals are not supported.
	Principal string `protobuf:"bytes,1,opt,name=principal,proto3" json:"principal,omitempty"`
	// Required. The full resource name that identifies the resource. For example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
	//
	// For examples of full resource names for Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `protobuf:"bytes,2,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// Required. The IAM permission to check for the specified principal and
	// resource.
	//
	// For a complete list of IAM permissions, see
	// https://cloud.google.com/iam/help/permissions/reference.
	//
	// For a complete list of predefined IAM roles and the permissions in each
	// role, see https://cloud.google.com/iam/help/roles/reference.
	Permission string `protobuf:"bytes,3,opt,name=permission,proto3" json:"permission,omitempty"`
}

func (x *AccessTuple) Reset() {
	*x = AccessTuple{}
	mi := &file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccessTuple) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessTuple) ProtoMessage() {}

func (x *AccessTuple) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessTuple.ProtoReflect.Descriptor instead.
func (*AccessTuple) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescGZIP(), []int{0}
}

func (x *AccessTuple) GetPrincipal() string {
	if x != nil {
		return x.Principal
	}
	return ""
}

func (x *AccessTuple) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *AccessTuple) GetPermission() string {
	if x != nil {
		return x.Permission
	}
	return ""
}

// Details about how a specific IAM [Policy][google.iam.v1.Policy] contributed
// to the access check.
type ExplainedPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether _this policy_ provides the specified permission to the
	// specified principal for the specified resource.
	//
	// This field does _not_ indicate whether the principal actually has the
	// permission for the resource. There might be another policy that overrides
	// this policy. To determine whether the principal actually has the
	// permission, use the `access` field in the
	// [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
	Access AccessState `protobuf:"varint,1,opt,name=access,proto3,enum=google.cloud.policytroubleshooter.v1.AccessState" json:"access,omitempty"`
	// The full resource name that identifies the resource. For example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	//
	// For examples of full resource names for Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `protobuf:"bytes,2,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// The IAM policy attached to the resource.
	//
	// If the sender of the request does not have access to the policy, this field
	// is empty.
	Policy *iampb.Policy `protobuf:"bytes,3,opt,name=policy,proto3" json:"policy,omitempty"`
	// Details about how each binding in the policy affects the principal's
	// ability, or inability, to use the permission for the resource.
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	BindingExplanations []*BindingExplanation `protobuf:"bytes,4,rep,name=binding_explanations,json=bindingExplanations,proto3" json:"binding_explanations,omitempty"`
	// The relevance of this policy to the overall determination in the
	// [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
	//
	// If the sender of the request does not have access to the policy, this field
	// is omitted.
	Relevance HeuristicRelevance `protobuf:"varint,5,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.v1.HeuristicRelevance" json:"relevance,omitempty"`
}

func (x *ExplainedPolicy) Reset() {
	*x = ExplainedPolicy{}
	mi := &file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExplainedPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplainedPolicy) ProtoMessage() {}

func (x *ExplainedPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplainedPolicy.ProtoReflect.Descriptor instead.
func (*ExplainedPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescGZIP(), []int{1}
}

func (x *ExplainedPolicy) GetAccess() AccessState {
	if x != nil {
		return x.Access
	}
	return AccessState_ACCESS_STATE_UNSPECIFIED
}

func (x *ExplainedPolicy) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *ExplainedPolicy) GetPolicy() *iampb.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *ExplainedPolicy) GetBindingExplanations() []*BindingExplanation {
	if x != nil {
		return x.BindingExplanations
	}
	return nil
}

func (x *ExplainedPolicy) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

// Details about how a binding in a policy affects a principal's ability to use
// a permission.
type BindingExplanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Indicates whether _this binding_ provides the specified
	// permission to the specified principal for the specified resource.
	//
	// This field does _not_ indicate whether the principal actually has the
	// permission for the resource. There might be another binding that overrides
	// this binding. To determine whether the principal actually has the
	// permission, use the `access` field in the
	// [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
	Access AccessState `protobuf:"varint,1,opt,name=access,proto3,enum=google.cloud.policytroubleshooter.v1.AccessState" json:"access,omitempty"`
	// The role that this binding grants. For example,
	// `roles/compute.serviceAgent`.
	//
	// For a complete list of predefined IAM roles, as well as the permissions in
	// each role, see https://cloud.google.com/iam/help/roles/reference.
	Role string `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	// Indicates whether the role granted by this binding contains the specified
	// permission.
	RolePermission BindingExplanation_RolePermission `protobuf:"varint,3,opt,name=role_permission,json=rolePermission,proto3,enum=google.cloud.policytroubleshooter.v1.BindingExplanation_RolePermission" json:"role_permission,omitempty"`
	// The relevance of the permission's existence, or nonexistence, in the role
	// to the overall determination for the entire policy.
	RolePermissionRelevance HeuristicRelevance `protobuf:"varint,4,opt,name=role_permission_relevance,json=rolePermissionRelevance,proto3,enum=google.cloud.policytroubleshooter.v1.HeuristicRelevance" json:"role_permission_relevance,omitempty"`
	// Indicates whether each principal in the binding includes the principal
	// specified in the request, either directly or indirectly. Each key
	// identifies a principal in the binding, and each value indicates whether the
	// principal in the binding includes the principal in the request.
	//
	// For example, suppose that a binding includes the following principals:
	//
	// * `user:alice@example.com`
	// * `group:product-eng@example.com`
	//
	// You want to troubleshoot access for `user:bob@example.com`. This user is a
	// principal of the group `group:product-eng@example.com`.
	//
	// For the first principal in the binding, the key is
	// `user:alice@example.com`, and the `membership` field in the value is set to
	// `MEMBERSHIP_NOT_INCLUDED`.
	//
	// For the second principal in the binding, the key is
	// `group:product-eng@example.com`, and the `membership` field in the value is
	// set to `MEMBERSHIP_INCLUDED`.
	Memberships map[string]*BindingExplanation_AnnotatedMembership `protobuf:"bytes,5,rep,name=memberships,proto3" json:"memberships,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The relevance of this binding to the overall determination for the entire
	// policy.
	Relevance HeuristicRelevance `protobuf:"varint,6,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.v1.HeuristicRelevance" json:"relevance,omitempty"`
	// A condition expression that prevents this binding from granting access
	// unless the expression evaluates to `true`.
	//
	// To learn about IAM Conditions, see
	// https://cloud.google.com/iam/help/conditions/overview.
	Condition *expr.Expr `protobuf:"bytes,7,opt,name=condition,proto3" json:"condition,omitempty"`
}

func (x *BindingExplanation) Reset() {
	*x = BindingExplanation{}
	mi := &file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BindingExplanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BindingExplanation) ProtoMessage() {}

func (x *BindingExplanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BindingExplanation.ProtoReflect.Descriptor instead.
func (*BindingExplanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescGZIP(), []int{2}
}

func (x *BindingExplanation) GetAccess() AccessState {
	if x != nil {
		return x.Access
	}
	return AccessState_ACCESS_STATE_UNSPECIFIED
}

func (x *BindingExplanation) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *BindingExplanation) GetRolePermission() BindingExplanation_RolePermission {
	if x != nil {
		return x.RolePermission
	}
	return BindingExplanation_ROLE_PERMISSION_UNSPECIFIED
}

func (x *BindingExplanation) GetRolePermissionRelevance() HeuristicRelevance {
	if x != nil {
		return x.RolePermissionRelevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

func (x *BindingExplanation) GetMemberships() map[string]*BindingExplanation_AnnotatedMembership {
	if x != nil {
		return x.Memberships
	}
	return nil
}

func (x *BindingExplanation) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

func (x *BindingExplanation) GetCondition() *expr.Expr {
	if x != nil {
		return x.Condition
	}
	return nil
}

// Details about whether the binding includes the principal.
type BindingExplanation_AnnotatedMembership struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether the binding includes the principal.
	Membership BindingExplanation_Membership `protobuf:"varint,1,opt,name=membership,proto3,enum=google.cloud.policytroubleshooter.v1.BindingExplanation_Membership" json:"membership,omitempty"`
	// The relevance of the principal's status to the overall determination for
	// the binding.
	Relevance HeuristicRelevance `protobuf:"varint,2,opt,name=relevance,proto3,enum=google.cloud.policytroubleshooter.v1.HeuristicRelevance" json:"relevance,omitempty"`
}

func (x *BindingExplanation_AnnotatedMembership) Reset() {
	*x = BindingExplanation_AnnotatedMembership{}
	mi := &file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BindingExplanation_AnnotatedMembership) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BindingExplanation_AnnotatedMembership) ProtoMessage() {}

func (x *BindingExplanation_AnnotatedMembership) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BindingExplanation_AnnotatedMembership.ProtoReflect.Descriptor instead.
func (*BindingExplanation_AnnotatedMembership) Descriptor() ([]byte, []int) {
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescGZIP(), []int{2, 0}
}

func (x *BindingExplanation_AnnotatedMembership) GetMembership() BindingExplanation_Membership {
	if x != nil {
		return x.Membership
	}
	return BindingExplanation_MEMBERSHIP_UNSPECIFIED
}

func (x *BindingExplanation_AnnotatedMembership) GetRelevance() HeuristicRelevance {
	if x != nil {
		return x.Relevance
	}
	return HeuristicRelevance_HEURISTIC_RELEVANCE_UNSPECIFIED
}

var File_google_cloud_policytroubleshooter_v1_explanations_proto protoreflect.FileDescriptor

var file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f,
	0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x88, 0x01, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54,
	0x75, 0x70, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x31, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x70, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xfe, 0x02, 0x0a, 0x0f, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x49, 0x0a, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x2c,
	0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x06,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6b, 0x0a, 0x14, 0x62,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74,
	0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x13, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x56, 0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x22, 0x80, 0x0a, 0x0a, 0x12, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x70, 0x0a, 0x0f, 0x72,
	0x6f, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52,
	0x6f, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x72,
	0x6f, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a,
	0x19, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f,
	0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69,
	0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x17, 0x72, 0x6f, 0x6c, 0x65,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x6b, 0x0a, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0b, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73,
	0x12, 0x56, 0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x75, 0x72, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x72,
	0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xd2, 0x01, 0x0a, 0x13, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x12, 0x63, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x56, 0x0a, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74,
	0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x8c,
	0x01, 0x0a, 0x10, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x62, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9a, 0x01,
	0x0a, 0x0e, 0x52, 0x6f, 0x6c, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x20, 0x0a, 0x1c, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x27, 0x0a, 0x23, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x4e, 0x46,
	0x4f, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x03, 0x22, 0xa6, 0x01, 0x0a, 0x0a, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x45, 0x4d,
	0x42, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x53,
	0x48, 0x49, 0x50, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1b,
	0x0a, 0x17, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x22, 0x0a, 0x1e, 0x4d,
	0x45, 0x4d, 0x42, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x22, 0x0a, 0x1e, 0x4d, 0x45, 0x4d, 0x42, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50, 0x5f, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x10, 0x04, 0x2a, 0x7b, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a,
	0x0b, 0x4e, 0x4f, 0x54, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x17,
	0x0a, 0x13, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54,
	0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x04,
	0x2a, 0x4f, 0x0a, 0x12, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x52, 0x65, 0x6c,
	0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x45, 0x55, 0x52, 0x49, 0x53,
	0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x4c, 0x45, 0x56, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4e,
	0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10,
	0x02, 0x42, 0xd6, 0x01, 0x5a, 0x5c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x74, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72,
	0x70, 0x62, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73,
	0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54,
	0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73, 0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x54, 0x72, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x73,
	0x68, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescOnce sync.Once
	file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescData = file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDesc
)

func file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescGZIP() []byte {
	file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescOnce.Do(func() {
		file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescData)
	})
	return file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDescData
}

var file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_policytroubleshooter_v1_explanations_proto_goTypes = []any{
	(AccessState)(0),                               // 0: google.cloud.policytroubleshooter.v1.AccessState
	(HeuristicRelevance)(0),                        // 1: google.cloud.policytroubleshooter.v1.HeuristicRelevance
	(BindingExplanation_RolePermission)(0),         // 2: google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission
	(BindingExplanation_Membership)(0),             // 3: google.cloud.policytroubleshooter.v1.BindingExplanation.Membership
	(*AccessTuple)(nil),                            // 4: google.cloud.policytroubleshooter.v1.AccessTuple
	(*ExplainedPolicy)(nil),                        // 5: google.cloud.policytroubleshooter.v1.ExplainedPolicy
	(*BindingExplanation)(nil),                     // 6: google.cloud.policytroubleshooter.v1.BindingExplanation
	(*BindingExplanation_AnnotatedMembership)(nil), // 7: google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership
	nil,                  // 8: google.cloud.policytroubleshooter.v1.BindingExplanation.MembershipsEntry
	(*iampb.Policy)(nil), // 9: google.iam.v1.Policy
	(*expr.Expr)(nil),    // 10: google.type.Expr
}
var file_google_cloud_policytroubleshooter_v1_explanations_proto_depIdxs = []int32{
	0,  // 0: google.cloud.policytroubleshooter.v1.ExplainedPolicy.access:type_name -> google.cloud.policytroubleshooter.v1.AccessState
	9,  // 1: google.cloud.policytroubleshooter.v1.ExplainedPolicy.policy:type_name -> google.iam.v1.Policy
	6,  // 2: google.cloud.policytroubleshooter.v1.ExplainedPolicy.binding_explanations:type_name -> google.cloud.policytroubleshooter.v1.BindingExplanation
	1,  // 3: google.cloud.policytroubleshooter.v1.ExplainedPolicy.relevance:type_name -> google.cloud.policytroubleshooter.v1.HeuristicRelevance
	0,  // 4: google.cloud.policytroubleshooter.v1.BindingExplanation.access:type_name -> google.cloud.policytroubleshooter.v1.AccessState
	2,  // 5: google.cloud.policytroubleshooter.v1.BindingExplanation.role_permission:type_name -> google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission
	1,  // 6: google.cloud.policytroubleshooter.v1.BindingExplanation.role_permission_relevance:type_name -> google.cloud.policytroubleshooter.v1.HeuristicRelevance
	8,  // 7: google.cloud.policytroubleshooter.v1.BindingExplanation.memberships:type_name -> google.cloud.policytroubleshooter.v1.BindingExplanation.MembershipsEntry
	1,  // 8: google.cloud.policytroubleshooter.v1.BindingExplanation.relevance:type_name -> google.cloud.policytroubleshooter.v1.HeuristicRelevance
	10, // 9: google.cloud.policytroubleshooter.v1.BindingExplanation.condition:type_name -> google.type.Expr
	3,  // 10: google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership.membership:type_name -> google.cloud.policytroubleshooter.v1.BindingExplanation.Membership
	1,  // 11: google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership.relevance:type_name -> google.cloud.policytroubleshooter.v1.HeuristicRelevance
	7,  // 12: google.cloud.policytroubleshooter.v1.BindingExplanation.MembershipsEntry.value:type_name -> google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_policytroubleshooter_v1_explanations_proto_init() }
func file_google_cloud_policytroubleshooter_v1_explanations_proto_init() {
	if File_google_cloud_policytroubleshooter_v1_explanations_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_policytroubleshooter_v1_explanations_proto_goTypes,
		DependencyIndexes: file_google_cloud_policytroubleshooter_v1_explanations_proto_depIdxs,
		EnumInfos:         file_google_cloud_policytroubleshooter_v1_explanations_proto_enumTypes,
		MessageInfos:      file_google_cloud_policytroubleshooter_v1_explanations_proto_msgTypes,
	}.Build()
	File_google_cloud_policytroubleshooter_v1_explanations_proto = out.File
	file_google_cloud_policytroubleshooter_v1_explanations_proto_rawDesc = nil
	file_google_cloud_policytroubleshooter_v1_explanations_proto_goTypes = nil
	file_google_cloud_policytroubleshooter_v1_explanations_proto_depIdxs = nil
}
