// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/oracledatabase/v1/vm_cluster.proto

package oracledatabasepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Different licenses supported.
type CloudVmClusterProperties_LicenseType int32

const (
	// Unspecified
	CloudVmClusterProperties_LICENSE_TYPE_UNSPECIFIED CloudVmClusterProperties_LicenseType = 0
	// License included part of offer
	CloudVmClusterProperties_LICENSE_INCLUDED CloudVmClusterProperties_LicenseType = 1
	// Bring your own license
	CloudVmClusterProperties_BRING_YOUR_OWN_LICENSE CloudVmClusterProperties_LicenseType = 2
)

// Enum value maps for CloudVmClusterProperties_LicenseType.
var (
	CloudVmClusterProperties_LicenseType_name = map[int32]string{
		0: "LICENSE_TYPE_UNSPECIFIED",
		1: "LICENSE_INCLUDED",
		2: "BRING_YOUR_OWN_LICENSE",
	}
	CloudVmClusterProperties_LicenseType_value = map[string]int32{
		"LICENSE_TYPE_UNSPECIFIED": 0,
		"LICENSE_INCLUDED":         1,
		"BRING_YOUR_OWN_LICENSE":   2,
	}
)

func (x CloudVmClusterProperties_LicenseType) Enum() *CloudVmClusterProperties_LicenseType {
	p := new(CloudVmClusterProperties_LicenseType)
	*p = x
	return p
}

func (x CloudVmClusterProperties_LicenseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudVmClusterProperties_LicenseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_enumTypes[0].Descriptor()
}

func (CloudVmClusterProperties_LicenseType) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_vm_cluster_proto_enumTypes[0]
}

func (x CloudVmClusterProperties_LicenseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudVmClusterProperties_LicenseType.Descriptor instead.
func (CloudVmClusterProperties_LicenseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescGZIP(), []int{1, 0}
}

// Types of disk redundancy provided by Oracle.
type CloudVmClusterProperties_DiskRedundancy int32

const (
	// Unspecified.
	CloudVmClusterProperties_DISK_REDUNDANCY_UNSPECIFIED CloudVmClusterProperties_DiskRedundancy = 0
	// High -  3 way mirror.
	CloudVmClusterProperties_HIGH CloudVmClusterProperties_DiskRedundancy = 1
	// Normal - 2 way mirror.
	CloudVmClusterProperties_NORMAL CloudVmClusterProperties_DiskRedundancy = 2
)

// Enum value maps for CloudVmClusterProperties_DiskRedundancy.
var (
	CloudVmClusterProperties_DiskRedundancy_name = map[int32]string{
		0: "DISK_REDUNDANCY_UNSPECIFIED",
		1: "HIGH",
		2: "NORMAL",
	}
	CloudVmClusterProperties_DiskRedundancy_value = map[string]int32{
		"DISK_REDUNDANCY_UNSPECIFIED": 0,
		"HIGH":                        1,
		"NORMAL":                      2,
	}
)

func (x CloudVmClusterProperties_DiskRedundancy) Enum() *CloudVmClusterProperties_DiskRedundancy {
	p := new(CloudVmClusterProperties_DiskRedundancy)
	*p = x
	return p
}

func (x CloudVmClusterProperties_DiskRedundancy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudVmClusterProperties_DiskRedundancy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_enumTypes[1].Descriptor()
}

func (CloudVmClusterProperties_DiskRedundancy) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_vm_cluster_proto_enumTypes[1]
}

func (x CloudVmClusterProperties_DiskRedundancy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudVmClusterProperties_DiskRedundancy.Descriptor instead.
func (CloudVmClusterProperties_DiskRedundancy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescGZIP(), []int{1, 1}
}

// The various lifecycle states of the VM cluster.
type CloudVmClusterProperties_State int32

const (
	// Default unspecified value.
	CloudVmClusterProperties_STATE_UNSPECIFIED CloudVmClusterProperties_State = 0
	// Indicates that the resource is in provisioning state.
	CloudVmClusterProperties_PROVISIONING CloudVmClusterProperties_State = 1
	// Indicates that the resource is in available state.
	CloudVmClusterProperties_AVAILABLE CloudVmClusterProperties_State = 2
	// Indicates that the resource is in updating state.
	CloudVmClusterProperties_UPDATING CloudVmClusterProperties_State = 3
	// Indicates that the resource is in terminating state.
	CloudVmClusterProperties_TERMINATING CloudVmClusterProperties_State = 4
	// Indicates that the resource is in terminated state.
	CloudVmClusterProperties_TERMINATED CloudVmClusterProperties_State = 5
	// Indicates that the resource is in failed state.
	CloudVmClusterProperties_FAILED CloudVmClusterProperties_State = 6
	// Indicates that the resource is in maintenance in progress state.
	CloudVmClusterProperties_MAINTENANCE_IN_PROGRESS CloudVmClusterProperties_State = 7
)

// Enum value maps for CloudVmClusterProperties_State.
var (
	CloudVmClusterProperties_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "AVAILABLE",
		3: "UPDATING",
		4: "TERMINATING",
		5: "TERMINATED",
		6: "FAILED",
		7: "MAINTENANCE_IN_PROGRESS",
	}
	CloudVmClusterProperties_State_value = map[string]int32{
		"STATE_UNSPECIFIED":       0,
		"PROVISIONING":            1,
		"AVAILABLE":               2,
		"UPDATING":                3,
		"TERMINATING":             4,
		"TERMINATED":              5,
		"FAILED":                  6,
		"MAINTENANCE_IN_PROGRESS": 7,
	}
)

func (x CloudVmClusterProperties_State) Enum() *CloudVmClusterProperties_State {
	p := new(CloudVmClusterProperties_State)
	*p = x
	return p
}

func (x CloudVmClusterProperties_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudVmClusterProperties_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_enumTypes[2].Descriptor()
}

func (CloudVmClusterProperties_State) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_vm_cluster_proto_enumTypes[2]
}

func (x CloudVmClusterProperties_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudVmClusterProperties_State.Descriptor instead.
func (CloudVmClusterProperties_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescGZIP(), []int{1, 2}
}

// Details of the Cloud VM Cluster resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/CloudVmCluster/
type CloudVmCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the VM Cluster resource with the format:
	// projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the Exadata Infrastructure resource on which VM
	// cluster resource is created, in the following format:
	// projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
	ExadataInfrastructure string `protobuf:"bytes,2,opt,name=exadata_infrastructure,json=exadataInfrastructure,proto3" json:"exadata_infrastructure,omitempty"`
	// Optional. User friendly name for this resource.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Google Cloud Platform location where Oracle Exadata is hosted.
	// It is same as Google Cloud Platform Oracle zone of Exadata infrastructure.
	GcpOracleZone string `protobuf:"bytes,12,opt,name=gcp_oracle_zone,json=gcpOracleZone,proto3" json:"gcp_oracle_zone,omitempty"`
	// Optional. Various properties of the VM Cluster.
	Properties *CloudVmClusterProperties `protobuf:"bytes,6,opt,name=properties,proto3" json:"properties,omitempty"`
	// Optional. Labels or tags associated with the VM Cluster.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The date and time that the VM cluster was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Required. Network settings. CIDR to use for cluster IP allocation.
	Cidr string `protobuf:"bytes,9,opt,name=cidr,proto3" json:"cidr,omitempty"`
	// Required. CIDR range of the backup subnet.
	BackupSubnetCidr string `protobuf:"bytes,10,opt,name=backup_subnet_cidr,json=backupSubnetCidr,proto3" json:"backup_subnet_cidr,omitempty"`
	// Required. The name of the VPC network.
	// Format: projects/{project}/global/networks/{network}
	Network string `protobuf:"bytes,11,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *CloudVmCluster) Reset() {
	*x = CloudVmCluster{}
	mi := &file_google_cloud_oracledatabase_v1_vm_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudVmCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudVmCluster) ProtoMessage() {}

func (x *CloudVmCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_vm_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudVmCluster.ProtoReflect.Descriptor instead.
func (*CloudVmCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *CloudVmCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CloudVmCluster) GetExadataInfrastructure() string {
	if x != nil {
		return x.ExadataInfrastructure
	}
	return ""
}

func (x *CloudVmCluster) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CloudVmCluster) GetGcpOracleZone() string {
	if x != nil {
		return x.GcpOracleZone
	}
	return ""
}

func (x *CloudVmCluster) GetProperties() *CloudVmClusterProperties {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *CloudVmCluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CloudVmCluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CloudVmCluster) GetCidr() string {
	if x != nil {
		return x.Cidr
	}
	return ""
}

func (x *CloudVmCluster) GetBackupSubnetCidr() string {
	if x != nil {
		return x.BackupSubnetCidr
	}
	return ""
}

func (x *CloudVmCluster) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

// Various properties and settings associated with Exadata VM cluster.
type CloudVmClusterProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Oracle Cloud Infrastructure ID of VM Cluster.
	Ocid string `protobuf:"bytes,1,opt,name=ocid,proto3" json:"ocid,omitempty"`
	// Required. License type of VM Cluster.
	LicenseType CloudVmClusterProperties_LicenseType `protobuf:"varint,2,opt,name=license_type,json=licenseType,proto3,enum=google.cloud.oracledatabase.v1.CloudVmClusterProperties_LicenseType" json:"license_type,omitempty"`
	// Optional. Grid Infrastructure Version.
	GiVersion string `protobuf:"bytes,3,opt,name=gi_version,json=giVersion,proto3" json:"gi_version,omitempty"`
	// Optional. Time zone of VM Cluster to set. Defaults to UTC if not specified.
	TimeZone *datetime.TimeZone `protobuf:"bytes,4,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. SSH public keys to be stored with cluster.
	SshPublicKeys []string `protobuf:"bytes,5,rep,name=ssh_public_keys,json=sshPublicKeys,proto3" json:"ssh_public_keys,omitempty"`
	// Optional. Number of database servers.
	NodeCount int32 `protobuf:"varint,6,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Output only. Shape of VM Cluster.
	Shape string `protobuf:"bytes,7,opt,name=shape,proto3" json:"shape,omitempty"`
	// Optional. OCPU count per VM. Minimum is 0.1.
	OcpuCount float32 `protobuf:"fixed32,8,opt,name=ocpu_count,json=ocpuCount,proto3" json:"ocpu_count,omitempty"`
	// Optional. Memory allocated in GBs.
	MemorySizeGb int32 `protobuf:"varint,9,opt,name=memory_size_gb,json=memorySizeGb,proto3" json:"memory_size_gb,omitempty"`
	// Optional. Local storage per VM.
	DbNodeStorageSizeGb int32 `protobuf:"varint,10,opt,name=db_node_storage_size_gb,json=dbNodeStorageSizeGb,proto3" json:"db_node_storage_size_gb,omitempty"`
	// Output only. The storage allocation for the disk group, in gigabytes (GB).
	StorageSizeGb int32 `protobuf:"varint,11,opt,name=storage_size_gb,json=storageSizeGb,proto3" json:"storage_size_gb,omitempty"`
	// Optional. The data disk group size to be allocated in TBs.
	DataStorageSizeTb float64 `protobuf:"fixed64,12,opt,name=data_storage_size_tb,json=dataStorageSizeTb,proto3" json:"data_storage_size_tb,omitempty"`
	// Optional. The type of redundancy.
	DiskRedundancy CloudVmClusterProperties_DiskRedundancy `protobuf:"varint,13,opt,name=disk_redundancy,json=diskRedundancy,proto3,enum=google.cloud.oracledatabase.v1.CloudVmClusterProperties_DiskRedundancy" json:"disk_redundancy,omitempty"`
	// Optional. Use exadata sparse snapshots.
	SparseDiskgroupEnabled bool `protobuf:"varint,14,opt,name=sparse_diskgroup_enabled,json=sparseDiskgroupEnabled,proto3" json:"sparse_diskgroup_enabled,omitempty"`
	// Optional. Use local backup.
	LocalBackupEnabled bool `protobuf:"varint,15,opt,name=local_backup_enabled,json=localBackupEnabled,proto3" json:"local_backup_enabled,omitempty"`
	// Optional. Prefix for VM cluster host names.
	HostnamePrefix string `protobuf:"bytes,16,opt,name=hostname_prefix,json=hostnamePrefix,proto3" json:"hostname_prefix,omitempty"`
	// Optional. Data collection options for diagnostics.
	DiagnosticsDataCollectionOptions *DataCollectionOptions `protobuf:"bytes,19,opt,name=diagnostics_data_collection_options,json=diagnosticsDataCollectionOptions,proto3" json:"diagnostics_data_collection_options,omitempty"`
	// Output only. State of the cluster.
	State CloudVmClusterProperties_State `protobuf:"varint,20,opt,name=state,proto3,enum=google.cloud.oracledatabase.v1.CloudVmClusterProperties_State" json:"state,omitempty"`
	// Output only. SCAN listener port - TCP
	ScanListenerPortTcp int32 `protobuf:"varint,21,opt,name=scan_listener_port_tcp,json=scanListenerPortTcp,proto3" json:"scan_listener_port_tcp,omitempty"`
	// Output only. SCAN listener port - TLS
	ScanListenerPortTcpSsl int32 `protobuf:"varint,22,opt,name=scan_listener_port_tcp_ssl,json=scanListenerPortTcpSsl,proto3" json:"scan_listener_port_tcp_ssl,omitempty"`
	// Output only. Parent DNS domain where SCAN DNS and hosts names are
	// qualified. ex: ocispdelegated.ocisp10jvnet.oraclevcn.com
	Domain string `protobuf:"bytes,23,opt,name=domain,proto3" json:"domain,omitempty"`
	// Output only. SCAN DNS name.
	// ex: sp2-yi0xq-scan.ocispdelegated.ocisp10jvnet.oraclevcn.com
	ScanDns string `protobuf:"bytes,24,opt,name=scan_dns,json=scanDns,proto3" json:"scan_dns,omitempty"`
	// Output only. host name without domain.
	// format: "<hostname_prefix>-" with some suffix.
	// ex: sp2-yi0xq where "sp2" is the hostname_prefix.
	Hostname string `protobuf:"bytes,25,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Required. Number of enabled CPU cores.
	CpuCoreCount int32 `protobuf:"varint,26,opt,name=cpu_core_count,json=cpuCoreCount,proto3" json:"cpu_core_count,omitempty"`
	// Optional. Operating system version of the image.
	SystemVersion string `protobuf:"bytes,27,opt,name=system_version,json=systemVersion,proto3" json:"system_version,omitempty"`
	// Output only. OCIDs of scan IPs.
	ScanIpIds []string `protobuf:"bytes,28,rep,name=scan_ip_ids,json=scanIpIds,proto3" json:"scan_ip_ids,omitempty"`
	// Output only. OCID of scan DNS record.
	ScanDnsRecordId string `protobuf:"bytes,29,opt,name=scan_dns_record_id,json=scanDnsRecordId,proto3" json:"scan_dns_record_id,omitempty"`
	// Output only. Deep link to the OCI console to view this resource.
	OciUrl string `protobuf:"bytes,30,opt,name=oci_url,json=ociUrl,proto3" json:"oci_url,omitempty"`
	// Optional. OCID of database servers.
	DbServerOcids []string `protobuf:"bytes,31,rep,name=db_server_ocids,json=dbServerOcids,proto3" json:"db_server_ocids,omitempty"`
	// Output only. Compartment ID of cluster.
	CompartmentId string `protobuf:"bytes,32,opt,name=compartment_id,json=compartmentId,proto3" json:"compartment_id,omitempty"`
	// Output only. DNS listener IP.
	DnsListenerIp string `protobuf:"bytes,35,opt,name=dns_listener_ip,json=dnsListenerIp,proto3" json:"dns_listener_ip,omitempty"`
	// Optional. OCI Cluster name.
	ClusterName string `protobuf:"bytes,36,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (x *CloudVmClusterProperties) Reset() {
	*x = CloudVmClusterProperties{}
	mi := &file_google_cloud_oracledatabase_v1_vm_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudVmClusterProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudVmClusterProperties) ProtoMessage() {}

func (x *CloudVmClusterProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_vm_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudVmClusterProperties.ProtoReflect.Descriptor instead.
func (*CloudVmClusterProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *CloudVmClusterProperties) GetOcid() string {
	if x != nil {
		return x.Ocid
	}
	return ""
}

func (x *CloudVmClusterProperties) GetLicenseType() CloudVmClusterProperties_LicenseType {
	if x != nil {
		return x.LicenseType
	}
	return CloudVmClusterProperties_LICENSE_TYPE_UNSPECIFIED
}

func (x *CloudVmClusterProperties) GetGiVersion() string {
	if x != nil {
		return x.GiVersion
	}
	return ""
}

func (x *CloudVmClusterProperties) GetTimeZone() *datetime.TimeZone {
	if x != nil {
		return x.TimeZone
	}
	return nil
}

func (x *CloudVmClusterProperties) GetSshPublicKeys() []string {
	if x != nil {
		return x.SshPublicKeys
	}
	return nil
}

func (x *CloudVmClusterProperties) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *CloudVmClusterProperties) GetShape() string {
	if x != nil {
		return x.Shape
	}
	return ""
}

func (x *CloudVmClusterProperties) GetOcpuCount() float32 {
	if x != nil {
		return x.OcpuCount
	}
	return 0
}

func (x *CloudVmClusterProperties) GetMemorySizeGb() int32 {
	if x != nil {
		return x.MemorySizeGb
	}
	return 0
}

func (x *CloudVmClusterProperties) GetDbNodeStorageSizeGb() int32 {
	if x != nil {
		return x.DbNodeStorageSizeGb
	}
	return 0
}

func (x *CloudVmClusterProperties) GetStorageSizeGb() int32 {
	if x != nil {
		return x.StorageSizeGb
	}
	return 0
}

func (x *CloudVmClusterProperties) GetDataStorageSizeTb() float64 {
	if x != nil {
		return x.DataStorageSizeTb
	}
	return 0
}

func (x *CloudVmClusterProperties) GetDiskRedundancy() CloudVmClusterProperties_DiskRedundancy {
	if x != nil {
		return x.DiskRedundancy
	}
	return CloudVmClusterProperties_DISK_REDUNDANCY_UNSPECIFIED
}

func (x *CloudVmClusterProperties) GetSparseDiskgroupEnabled() bool {
	if x != nil {
		return x.SparseDiskgroupEnabled
	}
	return false
}

func (x *CloudVmClusterProperties) GetLocalBackupEnabled() bool {
	if x != nil {
		return x.LocalBackupEnabled
	}
	return false
}

func (x *CloudVmClusterProperties) GetHostnamePrefix() string {
	if x != nil {
		return x.HostnamePrefix
	}
	return ""
}

func (x *CloudVmClusterProperties) GetDiagnosticsDataCollectionOptions() *DataCollectionOptions {
	if x != nil {
		return x.DiagnosticsDataCollectionOptions
	}
	return nil
}

func (x *CloudVmClusterProperties) GetState() CloudVmClusterProperties_State {
	if x != nil {
		return x.State
	}
	return CloudVmClusterProperties_STATE_UNSPECIFIED
}

func (x *CloudVmClusterProperties) GetScanListenerPortTcp() int32 {
	if x != nil {
		return x.ScanListenerPortTcp
	}
	return 0
}

func (x *CloudVmClusterProperties) GetScanListenerPortTcpSsl() int32 {
	if x != nil {
		return x.ScanListenerPortTcpSsl
	}
	return 0
}

func (x *CloudVmClusterProperties) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *CloudVmClusterProperties) GetScanDns() string {
	if x != nil {
		return x.ScanDns
	}
	return ""
}

func (x *CloudVmClusterProperties) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *CloudVmClusterProperties) GetCpuCoreCount() int32 {
	if x != nil {
		return x.CpuCoreCount
	}
	return 0
}

func (x *CloudVmClusterProperties) GetSystemVersion() string {
	if x != nil {
		return x.SystemVersion
	}
	return ""
}

func (x *CloudVmClusterProperties) GetScanIpIds() []string {
	if x != nil {
		return x.ScanIpIds
	}
	return nil
}

func (x *CloudVmClusterProperties) GetScanDnsRecordId() string {
	if x != nil {
		return x.ScanDnsRecordId
	}
	return ""
}

func (x *CloudVmClusterProperties) GetOciUrl() string {
	if x != nil {
		return x.OciUrl
	}
	return ""
}

func (x *CloudVmClusterProperties) GetDbServerOcids() []string {
	if x != nil {
		return x.DbServerOcids
	}
	return nil
}

func (x *CloudVmClusterProperties) GetCompartmentId() string {
	if x != nil {
		return x.CompartmentId
	}
	return ""
}

func (x *CloudVmClusterProperties) GetDnsListenerIp() string {
	if x != nil {
		return x.DnsListenerIp
	}
	return ""
}

func (x *CloudVmClusterProperties) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

// Data collection options for diagnostics.
type DataCollectionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Indicates whether diagnostic collection is enabled for the VM
	// cluster
	DiagnosticsEventsEnabled bool `protobuf:"varint,1,opt,name=diagnostics_events_enabled,json=diagnosticsEventsEnabled,proto3" json:"diagnostics_events_enabled,omitempty"`
	// Optional. Indicates whether health monitoring is enabled for the VM cluster
	HealthMonitoringEnabled bool `protobuf:"varint,2,opt,name=health_monitoring_enabled,json=healthMonitoringEnabled,proto3" json:"health_monitoring_enabled,omitempty"`
	// Optional. Indicates whether incident logs and trace collection are enabled
	// for the VM cluster
	IncidentLogsEnabled bool `protobuf:"varint,3,opt,name=incident_logs_enabled,json=incidentLogsEnabled,proto3" json:"incident_logs_enabled,omitempty"`
}

func (x *DataCollectionOptions) Reset() {
	*x = DataCollectionOptions{}
	mi := &file_google_cloud_oracledatabase_v1_vm_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataCollectionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataCollectionOptions) ProtoMessage() {}

func (x *DataCollectionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_vm_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataCollectionOptions.ProtoReflect.Descriptor instead.
func (*DataCollectionOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *DataCollectionOptions) GetDiagnosticsEventsEnabled() bool {
	if x != nil {
		return x.DiagnosticsEventsEnabled
	}
	return false
}

func (x *DataCollectionOptions) GetHealthMonitoringEnabled() bool {
	if x != nil {
		return x.HealthMonitoringEnabled
	}
	return false
}

func (x *DataCollectionOptions) GetIncidentLogsEnabled() bool {
	if x != nil {
		return x.IncidentLogsEnabled
	}
	return false
}

var File_google_cloud_oracledatabase_v1_vm_cluster_proto protoreflect.FileDescriptor

var file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x76, 0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdc, 0x06, 0x0a, 0x0e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x77, 0x0a, 0x16, 0x65, 0x78, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x15, 0x65, 0x78, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x67, 0x63, 0x70, 0x5f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x67, 0x63, 0x70, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x5d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56,
	0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x63, 0x69, 0x64, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x63, 0x69, 0x64, 0x72, 0x12, 0x31, 0x0a, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x43, 0x69, 0x64, 0x72, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x9f, 0x01, 0xea, 0x41, 0x9b, 0x01, 0x0a, 0x2c,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x4a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x76, 0x6d, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2a, 0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56,
	0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x32, 0x0e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0xee, 0x0f, 0x0a, 0x18, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6f, 0x63, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6f, 0x63, 0x69, 0x64, 0x12,
	0x6c, 0x0a, 0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e,
	0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x67, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x67, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x37, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x73, 0x73,
	0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x73, 0x68, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73,
	0x68, 0x61, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x68, 0x61, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x63, 0x70, 0x75, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x6f, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x53,
	0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x39, 0x0a, 0x17, 0x64, 0x62, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x64, 0x62, 0x4e,
	0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62,
	0x12, 0x2b, 0x0a, 0x0f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x67, 0x62, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x34, 0x0a,
	0x14, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x74, 0x62, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x54, 0x62, 0x12, 0x75, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x72, 0x65, 0x64, 0x75,
	0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x64, 0x75, 0x6e,
	0x64, 0x61, 0x6e, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x6b,
	0x52, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x12, 0x3d, 0x0a, 0x18, 0x73, 0x70,
	0x61, 0x72, 0x73, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x16, 0x73, 0x70, 0x61, 0x72, 0x73, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x35, 0x0a, 0x14, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x2c, 0x0a, 0x0f, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x89,
	0x01, 0x0a, 0x23, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f,
	0x73, 0x74, 0x69, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x38, 0x0a, 0x16, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x63, 0x70, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x73, 0x63, 0x61, 0x6e,
	0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x54, 0x63, 0x70, 0x12,
	0x3f, 0x0a, 0x1a, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72,
	0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x63, 0x70, 0x5f, 0x73, 0x73, 0x6c, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x73, 0x63, 0x61, 0x6e, 0x4c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x54, 0x63, 0x70, 0x53, 0x73, 0x6c,
	0x12, 0x1b, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x1e, 0x0a,
	0x08, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x64, 0x6e, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73, 0x63, 0x61, 0x6e, 0x44, 0x6e, 0x73, 0x12, 0x1f, 0x0a,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29,
	0x0a, 0x0e, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x1a, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x70, 0x75,
	0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x1b, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0b, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x69, 0x70,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x1c, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x73, 0x63, 0x61, 0x6e, 0x49, 0x70, 0x49, 0x64, 0x73, 0x12, 0x30, 0x0a, 0x12, 0x73, 0x63,
	0x61, 0x6e, 0x5f, 0x64, 0x6e, 0x73, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x69, 0x64,
	0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x63, 0x61,
	0x6e, 0x44, 0x6e, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x07,
	0x6f, 0x63, 0x69, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x6f, 0x63, 0x69, 0x55, 0x72, 0x6c, 0x12, 0x2b, 0x0a, 0x0f, 0x64, 0x62,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6f, 0x63, 0x69, 0x64, 0x73, 0x18, 0x1f, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64, 0x62, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x4f, 0x63, 0x69, 0x64, 0x73, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x61,
	0x72, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x20, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x0f, 0x64, 0x6e, 0x73, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x18, 0x23, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x64, 0x6e, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x49, 0x70,
	0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x24, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x5d, 0x0a, 0x0b, 0x4c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4c, 0x49, 0x43, 0x45, 0x4e,
	0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45,
	0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x42,
	0x52, 0x49, 0x4e, 0x47, 0x5f, 0x59, 0x4f, 0x55, 0x52, 0x5f, 0x4f, 0x57, 0x4e, 0x5f, 0x4c, 0x49,
	0x43, 0x45, 0x4e, 0x53, 0x45, 0x10, 0x02, 0x22, 0x47, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x6b, 0x52,
	0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x49, 0x53,
	0x4b, 0x5f, 0x52, 0x45, 0x44, 0x55, 0x4e, 0x44, 0x41, 0x4e, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49,
	0x47, 0x48, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x02,
	0x22, 0x97, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03,
	0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x44, 0x10,
	0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x1b, 0x0a,
	0x17, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x49, 0x4e, 0x5f,
	0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x07, 0x22, 0xd4, 0x01, 0x0a, 0x15, 0x44,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x1a, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x64,
	0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3f, 0x0a, 0x19, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x17, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x37, 0x0a, 0x15, 0x69, 0x6e, 0x63, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x69, 0x6e,
	0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x42, 0xed, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56,
	0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0x3b, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescOnce sync.Once
	file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescData = file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDesc
)

func file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescGZIP() []byte {
	file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescOnce.Do(func() {
		file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescData)
	})
	return file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDescData
}

var file_google_cloud_oracledatabase_v1_vm_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_oracledatabase_v1_vm_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_oracledatabase_v1_vm_cluster_proto_goTypes = []any{
	(CloudVmClusterProperties_LicenseType)(0),    // 0: google.cloud.oracledatabase.v1.CloudVmClusterProperties.LicenseType
	(CloudVmClusterProperties_DiskRedundancy)(0), // 1: google.cloud.oracledatabase.v1.CloudVmClusterProperties.DiskRedundancy
	(CloudVmClusterProperties_State)(0),          // 2: google.cloud.oracledatabase.v1.CloudVmClusterProperties.State
	(*CloudVmCluster)(nil),                       // 3: google.cloud.oracledatabase.v1.CloudVmCluster
	(*CloudVmClusterProperties)(nil),             // 4: google.cloud.oracledatabase.v1.CloudVmClusterProperties
	(*DataCollectionOptions)(nil),                // 5: google.cloud.oracledatabase.v1.DataCollectionOptions
	nil,                                          // 6: google.cloud.oracledatabase.v1.CloudVmCluster.LabelsEntry
	(*timestamppb.Timestamp)(nil),                // 7: google.protobuf.Timestamp
	(*datetime.TimeZone)(nil),                    // 8: google.type.TimeZone
}
var file_google_cloud_oracledatabase_v1_vm_cluster_proto_depIdxs = []int32{
	4, // 0: google.cloud.oracledatabase.v1.CloudVmCluster.properties:type_name -> google.cloud.oracledatabase.v1.CloudVmClusterProperties
	6, // 1: google.cloud.oracledatabase.v1.CloudVmCluster.labels:type_name -> google.cloud.oracledatabase.v1.CloudVmCluster.LabelsEntry
	7, // 2: google.cloud.oracledatabase.v1.CloudVmCluster.create_time:type_name -> google.protobuf.Timestamp
	0, // 3: google.cloud.oracledatabase.v1.CloudVmClusterProperties.license_type:type_name -> google.cloud.oracledatabase.v1.CloudVmClusterProperties.LicenseType
	8, // 4: google.cloud.oracledatabase.v1.CloudVmClusterProperties.time_zone:type_name -> google.type.TimeZone
	1, // 5: google.cloud.oracledatabase.v1.CloudVmClusterProperties.disk_redundancy:type_name -> google.cloud.oracledatabase.v1.CloudVmClusterProperties.DiskRedundancy
	5, // 6: google.cloud.oracledatabase.v1.CloudVmClusterProperties.diagnostics_data_collection_options:type_name -> google.cloud.oracledatabase.v1.DataCollectionOptions
	2, // 7: google.cloud.oracledatabase.v1.CloudVmClusterProperties.state:type_name -> google.cloud.oracledatabase.v1.CloudVmClusterProperties.State
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_oracledatabase_v1_vm_cluster_proto_init() }
func file_google_cloud_oracledatabase_v1_vm_cluster_proto_init() {
	if File_google_cloud_oracledatabase_v1_vm_cluster_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_oracledatabase_v1_vm_cluster_proto_goTypes,
		DependencyIndexes: file_google_cloud_oracledatabase_v1_vm_cluster_proto_depIdxs,
		EnumInfos:         file_google_cloud_oracledatabase_v1_vm_cluster_proto_enumTypes,
		MessageInfos:      file_google_cloud_oracledatabase_v1_vm_cluster_proto_msgTypes,
	}.Build()
	File_google_cloud_oracledatabase_v1_vm_cluster_proto = out.File
	file_google_cloud_oracledatabase_v1_vm_cluster_proto_rawDesc = nil
	file_google_cloud_oracledatabase_v1_vm_cluster_proto_goTypes = nil
	file_google_cloud_oracledatabase_v1_vm_cluster_proto_depIdxs = nil
}
