// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/oracledatabase/v1/exadata_infra.proto

package oracledatabasepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	month "google.golang.org/genproto/googleapis/type/month"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The various lifecycle states of the Exadata Infrastructure.
type CloudExadataInfrastructureProperties_State int32

const (
	// Default unspecified value.
	CloudExadataInfrastructureProperties_STATE_UNSPECIFIED CloudExadataInfrastructureProperties_State = 0
	// The Exadata Infrastructure is being provisioned.
	CloudExadataInfrastructureProperties_PROVISIONING CloudExadataInfrastructureProperties_State = 1
	// The Exadata Infrastructure is available for use.
	CloudExadataInfrastructureProperties_AVAILABLE CloudExadataInfrastructureProperties_State = 2
	// The Exadata Infrastructure is being updated.
	CloudExadataInfrastructureProperties_UPDATING CloudExadataInfrastructureProperties_State = 3
	// The Exadata Infrastructure is being terminated.
	CloudExadataInfrastructureProperties_TERMINATING CloudExadataInfrastructureProperties_State = 4
	// The Exadata Infrastructure is terminated.
	CloudExadataInfrastructureProperties_TERMINATED CloudExadataInfrastructureProperties_State = 5
	// The Exadata Infrastructure is in failed state.
	CloudExadataInfrastructureProperties_FAILED CloudExadataInfrastructureProperties_State = 6
	// The Exadata Infrastructure is in maintenance.
	CloudExadataInfrastructureProperties_MAINTENANCE_IN_PROGRESS CloudExadataInfrastructureProperties_State = 7
)

// Enum value maps for CloudExadataInfrastructureProperties_State.
var (
	CloudExadataInfrastructureProperties_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "AVAILABLE",
		3: "UPDATING",
		4: "TERMINATING",
		5: "TERMINATED",
		6: "FAILED",
		7: "MAINTENANCE_IN_PROGRESS",
	}
	CloudExadataInfrastructureProperties_State_value = map[string]int32{
		"STATE_UNSPECIFIED":       0,
		"PROVISIONING":            1,
		"AVAILABLE":               2,
		"UPDATING":                3,
		"TERMINATING":             4,
		"TERMINATED":              5,
		"FAILED":                  6,
		"MAINTENANCE_IN_PROGRESS": 7,
	}
)

func (x CloudExadataInfrastructureProperties_State) Enum() *CloudExadataInfrastructureProperties_State {
	p := new(CloudExadataInfrastructureProperties_State)
	*p = x
	return p
}

func (x CloudExadataInfrastructureProperties_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudExadataInfrastructureProperties_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_enumTypes[0].Descriptor()
}

func (CloudExadataInfrastructureProperties_State) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_exadata_infra_proto_enumTypes[0]
}

func (x CloudExadataInfrastructureProperties_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudExadataInfrastructureProperties_State.Descriptor instead.
func (CloudExadataInfrastructureProperties_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescGZIP(), []int{1, 0}
}

// Maintenance window preference.
type MaintenanceWindow_MaintenanceWindowPreference int32

const (
	// Default unspecified value.
	MaintenanceWindow_MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED MaintenanceWindow_MaintenanceWindowPreference = 0
	// Custom preference.
	MaintenanceWindow_CUSTOM_PREFERENCE MaintenanceWindow_MaintenanceWindowPreference = 1
	// No preference.
	MaintenanceWindow_NO_PREFERENCE MaintenanceWindow_MaintenanceWindowPreference = 2
)

// Enum value maps for MaintenanceWindow_MaintenanceWindowPreference.
var (
	MaintenanceWindow_MaintenanceWindowPreference_name = map[int32]string{
		0: "MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED",
		1: "CUSTOM_PREFERENCE",
		2: "NO_PREFERENCE",
	}
	MaintenanceWindow_MaintenanceWindowPreference_value = map[string]int32{
		"MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED": 0,
		"CUSTOM_PREFERENCE":                         1,
		"NO_PREFERENCE":                             2,
	}
)

func (x MaintenanceWindow_MaintenanceWindowPreference) Enum() *MaintenanceWindow_MaintenanceWindowPreference {
	p := new(MaintenanceWindow_MaintenanceWindowPreference)
	*p = x
	return p
}

func (x MaintenanceWindow_MaintenanceWindowPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MaintenanceWindow_MaintenanceWindowPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_enumTypes[1].Descriptor()
}

func (MaintenanceWindow_MaintenanceWindowPreference) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_exadata_infra_proto_enumTypes[1]
}

func (x MaintenanceWindow_MaintenanceWindowPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MaintenanceWindow_MaintenanceWindowPreference.Descriptor instead.
func (MaintenanceWindow_MaintenanceWindowPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescGZIP(), []int{2, 0}
}

// Patching mode.
type MaintenanceWindow_PatchingMode int32

const (
	// Default unspecified value.
	MaintenanceWindow_PATCHING_MODE_UNSPECIFIED MaintenanceWindow_PatchingMode = 0
	// Updates the Cloud Exadata database server hosts in a rolling fashion.
	MaintenanceWindow_ROLLING MaintenanceWindow_PatchingMode = 1
	// The non-rolling maintenance method first updates your storage servers at
	// the same time, then your database servers at the same time.
	MaintenanceWindow_NON_ROLLING MaintenanceWindow_PatchingMode = 2
)

// Enum value maps for MaintenanceWindow_PatchingMode.
var (
	MaintenanceWindow_PatchingMode_name = map[int32]string{
		0: "PATCHING_MODE_UNSPECIFIED",
		1: "ROLLING",
		2: "NON_ROLLING",
	}
	MaintenanceWindow_PatchingMode_value = map[string]int32{
		"PATCHING_MODE_UNSPECIFIED": 0,
		"ROLLING":                   1,
		"NON_ROLLING":               2,
	}
)

func (x MaintenanceWindow_PatchingMode) Enum() *MaintenanceWindow_PatchingMode {
	p := new(MaintenanceWindow_PatchingMode)
	*p = x
	return p
}

func (x MaintenanceWindow_PatchingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MaintenanceWindow_PatchingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_enumTypes[2].Descriptor()
}

func (MaintenanceWindow_PatchingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_exadata_infra_proto_enumTypes[2]
}

func (x MaintenanceWindow_PatchingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MaintenanceWindow_PatchingMode.Descriptor instead.
func (MaintenanceWindow_PatchingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescGZIP(), []int{2, 1}
}

// Represents CloudExadataInfrastructure resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/CloudExadataInfrastructure/
type CloudExadataInfrastructure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the Exadata Infrastructure resource with the
	// format:
	// projects/{project}/locations/{region}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. User friendly name for this resource.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Google Cloud Platform location where Oracle Exadata is hosted.
	GcpOracleZone string `protobuf:"bytes,8,opt,name=gcp_oracle_zone,json=gcpOracleZone,proto3" json:"gcp_oracle_zone,omitempty"`
	// Output only. Entitlement ID of the private offer against which this
	// infrastructure resource is provisioned.
	EntitlementId string `protobuf:"bytes,4,opt,name=entitlement_id,json=entitlementId,proto3" json:"entitlement_id,omitempty"`
	// Optional. Various properties of the infra.
	Properties *CloudExadataInfrastructureProperties `protobuf:"bytes,5,opt,name=properties,proto3" json:"properties,omitempty"`
	// Optional. Labels or tags associated with the resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The date and time that the Exadata Infrastructure was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *CloudExadataInfrastructure) Reset() {
	*x = CloudExadataInfrastructure{}
	mi := &file_google_cloud_oracledatabase_v1_exadata_infra_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudExadataInfrastructure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudExadataInfrastructure) ProtoMessage() {}

func (x *CloudExadataInfrastructure) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_exadata_infra_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudExadataInfrastructure.ProtoReflect.Descriptor instead.
func (*CloudExadataInfrastructure) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescGZIP(), []int{0}
}

func (x *CloudExadataInfrastructure) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CloudExadataInfrastructure) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CloudExadataInfrastructure) GetGcpOracleZone() string {
	if x != nil {
		return x.GcpOracleZone
	}
	return ""
}

func (x *CloudExadataInfrastructure) GetEntitlementId() string {
	if x != nil {
		return x.EntitlementId
	}
	return ""
}

func (x *CloudExadataInfrastructure) GetProperties() *CloudExadataInfrastructureProperties {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *CloudExadataInfrastructure) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CloudExadataInfrastructure) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Various properties of Exadata Infrastructure.
type CloudExadataInfrastructureProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. OCID of created infra.
	// https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
	Ocid string `protobuf:"bytes,1,opt,name=ocid,proto3" json:"ocid,omitempty"`
	// Optional. The number of compute servers for the Exadata Infrastructure.
	ComputeCount int32 `protobuf:"varint,2,opt,name=compute_count,json=computeCount,proto3" json:"compute_count,omitempty"`
	// Optional. The number of Cloud Exadata storage servers for the Exadata
	// Infrastructure.
	StorageCount int32 `protobuf:"varint,3,opt,name=storage_count,json=storageCount,proto3" json:"storage_count,omitempty"`
	// Optional. The total storage allocated to the Exadata Infrastructure
	// resource, in gigabytes (GB).
	TotalStorageSizeGb int32 `protobuf:"varint,4,opt,name=total_storage_size_gb,json=totalStorageSizeGb,proto3" json:"total_storage_size_gb,omitempty"`
	// Output only. The available storage can be allocated to the Exadata
	// Infrastructure resource, in gigabytes (GB).
	AvailableStorageSizeGb int32 `protobuf:"varint,5,opt,name=available_storage_size_gb,json=availableStorageSizeGb,proto3" json:"available_storage_size_gb,omitempty"`
	// Optional. Maintenance window for repair.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,6,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Output only. The current lifecycle state of the Exadata Infrastructure.
	State CloudExadataInfrastructureProperties_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties_State" json:"state,omitempty"`
	// Required. The shape of the Exadata Infrastructure. The shape determines the
	// amount of CPU, storage, and memory resources allocated to the instance.
	Shape string `protobuf:"bytes,8,opt,name=shape,proto3" json:"shape,omitempty"`
	// Output only. Deep link to the OCI console to view this resource.
	OciUrl string `protobuf:"bytes,9,opt,name=oci_url,json=ociUrl,proto3" json:"oci_url,omitempty"`
	// Output only. The number of enabled CPU cores.
	CpuCount int32 `protobuf:"varint,10,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// Output only. The total number of CPU cores available.
	MaxCpuCount int32 `protobuf:"varint,11,opt,name=max_cpu_count,json=maxCpuCount,proto3" json:"max_cpu_count,omitempty"`
	// Output only. The memory allocated in GBs.
	MemorySizeGb int32 `protobuf:"varint,12,opt,name=memory_size_gb,json=memorySizeGb,proto3" json:"memory_size_gb,omitempty"`
	// Output only. The total memory available in GBs.
	MaxMemoryGb int32 `protobuf:"varint,13,opt,name=max_memory_gb,json=maxMemoryGb,proto3" json:"max_memory_gb,omitempty"`
	// Output only. The local node storage allocated in GBs.
	DbNodeStorageSizeGb int32 `protobuf:"varint,14,opt,name=db_node_storage_size_gb,json=dbNodeStorageSizeGb,proto3" json:"db_node_storage_size_gb,omitempty"`
	// Output only. The total local node storage available in GBs.
	MaxDbNodeStorageSizeGb int32 `protobuf:"varint,15,opt,name=max_db_node_storage_size_gb,json=maxDbNodeStorageSizeGb,proto3" json:"max_db_node_storage_size_gb,omitempty"`
	// Output only. Size, in terabytes, of the DATA disk group.
	DataStorageSizeTb float64 `protobuf:"fixed64,16,opt,name=data_storage_size_tb,json=dataStorageSizeTb,proto3" json:"data_storage_size_tb,omitempty"`
	// Output only. The total available DATA disk group size.
	MaxDataStorageTb float64 `protobuf:"fixed64,17,opt,name=max_data_storage_tb,json=maxDataStorageTb,proto3" json:"max_data_storage_tb,omitempty"`
	// Output only. The requested number of additional storage servers activated
	// for the Exadata Infrastructure.
	ActivatedStorageCount int32 `protobuf:"varint,18,opt,name=activated_storage_count,json=activatedStorageCount,proto3" json:"activated_storage_count,omitempty"`
	// Output only. The requested number of additional storage servers for the
	// Exadata Infrastructure.
	AdditionalStorageCount int32 `protobuf:"varint,19,opt,name=additional_storage_count,json=additionalStorageCount,proto3" json:"additional_storage_count,omitempty"`
	// Output only. The software version of the database servers (dom0) in the
	// Exadata Infrastructure.
	DbServerVersion string `protobuf:"bytes,20,opt,name=db_server_version,json=dbServerVersion,proto3" json:"db_server_version,omitempty"`
	// Output only. The software version of the storage servers (cells) in the
	// Exadata Infrastructure.
	StorageServerVersion string `protobuf:"bytes,21,opt,name=storage_server_version,json=storageServerVersion,proto3" json:"storage_server_version,omitempty"`
	// Output only. The OCID of the next maintenance run.
	NextMaintenanceRunId string `protobuf:"bytes,22,opt,name=next_maintenance_run_id,json=nextMaintenanceRunId,proto3" json:"next_maintenance_run_id,omitempty"`
	// Output only. The time when the next maintenance run will occur.
	NextMaintenanceRunTime *timestamppb.Timestamp `protobuf:"bytes,23,opt,name=next_maintenance_run_time,json=nextMaintenanceRunTime,proto3" json:"next_maintenance_run_time,omitempty"`
	// Output only. The time when the next security maintenance run will occur.
	NextSecurityMaintenanceRunTime *timestamppb.Timestamp `protobuf:"bytes,24,opt,name=next_security_maintenance_run_time,json=nextSecurityMaintenanceRunTime,proto3" json:"next_security_maintenance_run_time,omitempty"`
	// Optional. The list of customer contacts.
	CustomerContacts []*CustomerContact `protobuf:"bytes,25,rep,name=customer_contacts,json=customerContacts,proto3" json:"customer_contacts,omitempty"`
	// Output only. The monthly software version of the storage servers (cells)
	// in the Exadata Infrastructure. Example: 20.1.15
	MonthlyStorageServerVersion string `protobuf:"bytes,26,opt,name=monthly_storage_server_version,json=monthlyStorageServerVersion,proto3" json:"monthly_storage_server_version,omitempty"`
	// Output only. The monthly software version of the database servers (dom0)
	// in the Exadata Infrastructure. Example: 20.1.15
	MonthlyDbServerVersion string `protobuf:"bytes,27,opt,name=monthly_db_server_version,json=monthlyDbServerVersion,proto3" json:"monthly_db_server_version,omitempty"`
}

func (x *CloudExadataInfrastructureProperties) Reset() {
	*x = CloudExadataInfrastructureProperties{}
	mi := &file_google_cloud_oracledatabase_v1_exadata_infra_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudExadataInfrastructureProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudExadataInfrastructureProperties) ProtoMessage() {}

func (x *CloudExadataInfrastructureProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_exadata_infra_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudExadataInfrastructureProperties.ProtoReflect.Descriptor instead.
func (*CloudExadataInfrastructureProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescGZIP(), []int{1}
}

func (x *CloudExadataInfrastructureProperties) GetOcid() string {
	if x != nil {
		return x.Ocid
	}
	return ""
}

func (x *CloudExadataInfrastructureProperties) GetComputeCount() int32 {
	if x != nil {
		return x.ComputeCount
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetStorageCount() int32 {
	if x != nil {
		return x.StorageCount
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetTotalStorageSizeGb() int32 {
	if x != nil {
		return x.TotalStorageSizeGb
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetAvailableStorageSizeGb() int32 {
	if x != nil {
		return x.AvailableStorageSizeGb
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *CloudExadataInfrastructureProperties) GetState() CloudExadataInfrastructureProperties_State {
	if x != nil {
		return x.State
	}
	return CloudExadataInfrastructureProperties_STATE_UNSPECIFIED
}

func (x *CloudExadataInfrastructureProperties) GetShape() string {
	if x != nil {
		return x.Shape
	}
	return ""
}

func (x *CloudExadataInfrastructureProperties) GetOciUrl() string {
	if x != nil {
		return x.OciUrl
	}
	return ""
}

func (x *CloudExadataInfrastructureProperties) GetCpuCount() int32 {
	if x != nil {
		return x.CpuCount
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetMaxCpuCount() int32 {
	if x != nil {
		return x.MaxCpuCount
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetMemorySizeGb() int32 {
	if x != nil {
		return x.MemorySizeGb
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetMaxMemoryGb() int32 {
	if x != nil {
		return x.MaxMemoryGb
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetDbNodeStorageSizeGb() int32 {
	if x != nil {
		return x.DbNodeStorageSizeGb
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetMaxDbNodeStorageSizeGb() int32 {
	if x != nil {
		return x.MaxDbNodeStorageSizeGb
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetDataStorageSizeTb() float64 {
	if x != nil {
		return x.DataStorageSizeTb
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetMaxDataStorageTb() float64 {
	if x != nil {
		return x.MaxDataStorageTb
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetActivatedStorageCount() int32 {
	if x != nil {
		return x.ActivatedStorageCount
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetAdditionalStorageCount() int32 {
	if x != nil {
		return x.AdditionalStorageCount
	}
	return 0
}

func (x *CloudExadataInfrastructureProperties) GetDbServerVersion() string {
	if x != nil {
		return x.DbServerVersion
	}
	return ""
}

func (x *CloudExadataInfrastructureProperties) GetStorageServerVersion() string {
	if x != nil {
		return x.StorageServerVersion
	}
	return ""
}

func (x *CloudExadataInfrastructureProperties) GetNextMaintenanceRunId() string {
	if x != nil {
		return x.NextMaintenanceRunId
	}
	return ""
}

func (x *CloudExadataInfrastructureProperties) GetNextMaintenanceRunTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextMaintenanceRunTime
	}
	return nil
}

func (x *CloudExadataInfrastructureProperties) GetNextSecurityMaintenanceRunTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextSecurityMaintenanceRunTime
	}
	return nil
}

func (x *CloudExadataInfrastructureProperties) GetCustomerContacts() []*CustomerContact {
	if x != nil {
		return x.CustomerContacts
	}
	return nil
}

func (x *CloudExadataInfrastructureProperties) GetMonthlyStorageServerVersion() string {
	if x != nil {
		return x.MonthlyStorageServerVersion
	}
	return ""
}

func (x *CloudExadataInfrastructureProperties) GetMonthlyDbServerVersion() string {
	if x != nil {
		return x.MonthlyDbServerVersion
	}
	return ""
}

// Maintenance window as defined by Oracle.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/MaintenanceWindow
type MaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The maintenance window scheduling preference.
	Preference MaintenanceWindow_MaintenanceWindowPreference `protobuf:"varint,1,opt,name=preference,proto3,enum=google.cloud.oracledatabase.v1.MaintenanceWindow_MaintenanceWindowPreference" json:"preference,omitempty"`
	// Optional. Months during the year when maintenance should be performed.
	Months []month.Month `protobuf:"varint,2,rep,packed,name=months,proto3,enum=google.type.Month" json:"months,omitempty"`
	// Optional. Weeks during the month when maintenance should be performed.
	// Weeks start on the 1st, 8th, 15th, and 22nd days of the month, and have a
	// duration of 7 days. Weeks start and end based on calendar dates, not days
	// of the week.
	WeeksOfMonth []int32 `protobuf:"varint,3,rep,packed,name=weeks_of_month,json=weeksOfMonth,proto3" json:"weeks_of_month,omitempty"`
	// Optional. Days during the week when maintenance should be performed.
	DaysOfWeek []dayofweek.DayOfWeek `protobuf:"varint,4,rep,packed,name=days_of_week,json=daysOfWeek,proto3,enum=google.type.DayOfWeek" json:"days_of_week,omitempty"`
	// Optional. The window of hours during the day when maintenance should be
	// performed. The window is a 4 hour slot. Valid values are:
	//
	//	0 - represents time slot 0:00 - 3:59 UTC
	//	4 - represents time slot 4:00 - 7:59 UTC
	//	8 - represents time slot 8:00 - 11:59 UTC
	//	12 - represents time slot 12:00 - 15:59 UTC
	//	16 - represents time slot 16:00 - 19:59 UTC
	//	20 - represents time slot 20:00 - 23:59 UTC
	HoursOfDay []int32 `protobuf:"varint,5,rep,packed,name=hours_of_day,json=hoursOfDay,proto3" json:"hours_of_day,omitempty"`
	// Optional. Lead time window allows user to set a lead time to prepare for a
	// down time. The lead time is in weeks and valid value is between 1 to 4.
	LeadTimeWeek int32 `protobuf:"varint,6,opt,name=lead_time_week,json=leadTimeWeek,proto3" json:"lead_time_week,omitempty"`
	// Optional. Cloud CloudExadataInfrastructure node patching method, either
	// "ROLLING" or "NONROLLING". Default value is ROLLING.
	PatchingMode MaintenanceWindow_PatchingMode `protobuf:"varint,7,opt,name=patching_mode,json=patchingMode,proto3,enum=google.cloud.oracledatabase.v1.MaintenanceWindow_PatchingMode" json:"patching_mode,omitempty"`
	// Optional. Determines the amount of time the system will wait before the
	// start of each database server patching operation. Custom action timeout is
	// in minutes and valid value is between 15 to 120 (inclusive).
	CustomActionTimeoutMins int32 `protobuf:"varint,8,opt,name=custom_action_timeout_mins,json=customActionTimeoutMins,proto3" json:"custom_action_timeout_mins,omitempty"`
	// Optional. If true, enables the configuration of a custom action timeout
	// (waiting period) between database server patching operations.
	IsCustomActionTimeoutEnabled bool `protobuf:"varint,9,opt,name=is_custom_action_timeout_enabled,json=isCustomActionTimeoutEnabled,proto3" json:"is_custom_action_timeout_enabled,omitempty"`
}

func (x *MaintenanceWindow) Reset() {
	*x = MaintenanceWindow{}
	mi := &file_google_cloud_oracledatabase_v1_exadata_infra_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceWindow) ProtoMessage() {}

func (x *MaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_exadata_infra_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceWindow.ProtoReflect.Descriptor instead.
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescGZIP(), []int{2}
}

func (x *MaintenanceWindow) GetPreference() MaintenanceWindow_MaintenanceWindowPreference {
	if x != nil {
		return x.Preference
	}
	return MaintenanceWindow_MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED
}

func (x *MaintenanceWindow) GetMonths() []month.Month {
	if x != nil {
		return x.Months
	}
	return nil
}

func (x *MaintenanceWindow) GetWeeksOfMonth() []int32 {
	if x != nil {
		return x.WeeksOfMonth
	}
	return nil
}

func (x *MaintenanceWindow) GetDaysOfWeek() []dayofweek.DayOfWeek {
	if x != nil {
		return x.DaysOfWeek
	}
	return nil
}

func (x *MaintenanceWindow) GetHoursOfDay() []int32 {
	if x != nil {
		return x.HoursOfDay
	}
	return nil
}

func (x *MaintenanceWindow) GetLeadTimeWeek() int32 {
	if x != nil {
		return x.LeadTimeWeek
	}
	return 0
}

func (x *MaintenanceWindow) GetPatchingMode() MaintenanceWindow_PatchingMode {
	if x != nil {
		return x.PatchingMode
	}
	return MaintenanceWindow_PATCHING_MODE_UNSPECIFIED
}

func (x *MaintenanceWindow) GetCustomActionTimeoutMins() int32 {
	if x != nil {
		return x.CustomActionTimeoutMins
	}
	return 0
}

func (x *MaintenanceWindow) GetIsCustomActionTimeoutEnabled() bool {
	if x != nil {
		return x.IsCustomActionTimeoutEnabled
	}
	return false
}

var File_google_cloud_oracledatabase_v1_exadata_infra_proto protoreflect.FileDescriptor

var file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x65, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x79, 0x6f,
	0x66, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe1, 0x05, 0x0a, 0x1a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x67, 0x63, 0x70, 0x5f, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x67, 0x63, 0x70, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5a, 0x6f, 0x6e,
	0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x69, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49,
	0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x63, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45,
	0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xdb, 0x01, 0xea, 0x41, 0xd7,
	0x01, 0x0a, 0x38, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x62, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x2f, 0x7b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x7d, 0x2a,
	0x1b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x32, 0x1a, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x22, 0x8c, 0x0e, 0x0a, 0x24, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x17, 0x0a, 0x04, 0x6f, 0x63, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6f, 0x63, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x36,
	0x0a, 0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x3e, 0x0a, 0x19, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x67, 0x62, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x65, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x65, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x70, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x68, 0x61, 0x70, 0x65, 0x12,
	0x1c, 0x0a, 0x07, 0x6f, 0x63, 0x69, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6f, 0x63, 0x69, 0x55, 0x72, 0x6c, 0x12, 0x20, 0x0a,
	0x09, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x27, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6d, 0x61, 0x78,
	0x43, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x53, 0x69, 0x7a,
	0x65, 0x47, 0x62, 0x12, 0x27, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x5f, 0x67, 0x62, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x47, 0x62, 0x12, 0x39, 0x0a, 0x17,
	0x64, 0x62, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x13, 0x64, 0x62, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x40, 0x0a, 0x1b, 0x6d, 0x61, 0x78, 0x5f, 0x64,
	0x62, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x16, 0x6d, 0x61, 0x78, 0x44, 0x62, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x34, 0x0a, 0x14, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x74,
	0x62, 0x18, 0x10, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x54, 0x62, 0x12,
	0x32, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x62, 0x18, 0x11, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x10, 0x6d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x54, 0x62, 0x12, 0x3b, 0x0a, 0x17, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x3d, 0x0a, 0x18, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x2f, 0x0a, 0x11, 0x64, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0f, 0x64, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x39, 0x0a, 0x16, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x17, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x14, 0x6e, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x75, 0x6e, 0x49, 0x64, 0x12, 0x5a, 0x0a, 0x19, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x75, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x6e, 0x65, 0x78,
	0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x22, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1e, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x61, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x73, 0x12, 0x48, 0x0a, 0x1e, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1b, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a,
	0x19, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x5f, 0x64, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x44, 0x62,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x01,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0f, 0x0a,
	0x0b, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0e,
	0x0a, 0x0a, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x41,
	0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f,
	0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x07, 0x22, 0xb2, 0x06, 0x0a, 0x11, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x72, 0x0a,
	0x0a, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x2f, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x74,
	0x68, 0x73, 0x12, 0x29, 0x0a, 0x0e, 0x77, 0x65, 0x65, 0x6b, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x6d,
	0x6f, 0x6e, 0x74, 0x68, 0x18, 0x03, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x77, 0x65, 0x65, 0x6b, 0x73, 0x4f, 0x66, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x3d, 0x0a,
	0x0c, 0x64, 0x61, 0x79, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x64, 0x61, 0x79, 0x73, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x12, 0x25, 0x0a, 0x0c,
	0x68, 0x6f, 0x75, 0x72, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x4f, 0x66,
	0x44, 0x61, 0x79, 0x12, 0x29, 0x0a, 0x0e, 0x6c, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x6c, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x65, 0x65, 0x6b, 0x12, 0x68,
	0x0a, 0x0d, 0x70, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e,
	0x67, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x70, 0x61, 0x74, 0x63,
	0x68, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x69, 0x6e, 0x73, 0x12, 0x4b, 0x0a, 0x20, 0x69, 0x73,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x69, 0x73, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x76, 0x0a, 0x1b, 0x4d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2d, 0x0a, 0x29, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45,
	0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x5f, 0x50, 0x52, 0x45,
	0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f,
	0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d,
	0x4e, 0x4f, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x22,
	0x4b, 0x0a, 0x0c, 0x50, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x50, 0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x4f, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4e,
	0x4f, 0x4e, 0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x42, 0xf9, 0x01, 0x0a,
	0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x42, 0x1f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70,
	0x62, 0x3b, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescOnce sync.Once
	file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescData = file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDesc
)

func file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescGZIP() []byte {
	file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescOnce.Do(func() {
		file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescData)
	})
	return file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDescData
}

var file_google_cloud_oracledatabase_v1_exadata_infra_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_oracledatabase_v1_exadata_infra_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_oracledatabase_v1_exadata_infra_proto_goTypes = []any{
	(CloudExadataInfrastructureProperties_State)(0),    // 0: google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties.State
	(MaintenanceWindow_MaintenanceWindowPreference)(0), // 1: google.cloud.oracledatabase.v1.MaintenanceWindow.MaintenanceWindowPreference
	(MaintenanceWindow_PatchingMode)(0),                // 2: google.cloud.oracledatabase.v1.MaintenanceWindow.PatchingMode
	(*CloudExadataInfrastructure)(nil),                 // 3: google.cloud.oracledatabase.v1.CloudExadataInfrastructure
	(*CloudExadataInfrastructureProperties)(nil),       // 4: google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties
	(*MaintenanceWindow)(nil),                          // 5: google.cloud.oracledatabase.v1.MaintenanceWindow
	nil,                                                // 6: google.cloud.oracledatabase.v1.CloudExadataInfrastructure.LabelsEntry
	(*timestamppb.Timestamp)(nil),                      // 7: google.protobuf.Timestamp
	(*CustomerContact)(nil),                            // 8: google.cloud.oracledatabase.v1.CustomerContact
	(month.Month)(0),                                   // 9: google.type.Month
	(dayofweek.DayOfWeek)(0),                           // 10: google.type.DayOfWeek
}
var file_google_cloud_oracledatabase_v1_exadata_infra_proto_depIdxs = []int32{
	4,  // 0: google.cloud.oracledatabase.v1.CloudExadataInfrastructure.properties:type_name -> google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties
	6,  // 1: google.cloud.oracledatabase.v1.CloudExadataInfrastructure.labels:type_name -> google.cloud.oracledatabase.v1.CloudExadataInfrastructure.LabelsEntry
	7,  // 2: google.cloud.oracledatabase.v1.CloudExadataInfrastructure.create_time:type_name -> google.protobuf.Timestamp
	5,  // 3: google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties.maintenance_window:type_name -> google.cloud.oracledatabase.v1.MaintenanceWindow
	0,  // 4: google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties.state:type_name -> google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties.State
	7,  // 5: google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties.next_maintenance_run_time:type_name -> google.protobuf.Timestamp
	7,  // 6: google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties.next_security_maintenance_run_time:type_name -> google.protobuf.Timestamp
	8,  // 7: google.cloud.oracledatabase.v1.CloudExadataInfrastructureProperties.customer_contacts:type_name -> google.cloud.oracledatabase.v1.CustomerContact
	1,  // 8: google.cloud.oracledatabase.v1.MaintenanceWindow.preference:type_name -> google.cloud.oracledatabase.v1.MaintenanceWindow.MaintenanceWindowPreference
	9,  // 9: google.cloud.oracledatabase.v1.MaintenanceWindow.months:type_name -> google.type.Month
	10, // 10: google.cloud.oracledatabase.v1.MaintenanceWindow.days_of_week:type_name -> google.type.DayOfWeek
	2,  // 11: google.cloud.oracledatabase.v1.MaintenanceWindow.patching_mode:type_name -> google.cloud.oracledatabase.v1.MaintenanceWindow.PatchingMode
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_oracledatabase_v1_exadata_infra_proto_init() }
func file_google_cloud_oracledatabase_v1_exadata_infra_proto_init() {
	if File_google_cloud_oracledatabase_v1_exadata_infra_proto != nil {
		return
	}
	file_google_cloud_oracledatabase_v1_common_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_oracledatabase_v1_exadata_infra_proto_goTypes,
		DependencyIndexes: file_google_cloud_oracledatabase_v1_exadata_infra_proto_depIdxs,
		EnumInfos:         file_google_cloud_oracledatabase_v1_exadata_infra_proto_enumTypes,
		MessageInfos:      file_google_cloud_oracledatabase_v1_exadata_infra_proto_msgTypes,
	}.Build()
	File_google_cloud_oracledatabase_v1_exadata_infra_proto = out.File
	file_google_cloud_oracledatabase_v1_exadata_infra_proto_rawDesc = nil
	file_google_cloud_oracledatabase_v1_exadata_infra_proto_goTypes = nil
	file_google_cloud_oracledatabase_v1_exadata_infra_proto_depIdxs = nil
}
