// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package oracledatabase

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	oracledatabasepb "cloud.google.com/go/oracledatabase/apiv1/oracledatabasepb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListCloudExadataInfrastructures     []gax.CallOption
	GetCloudExadataInfrastructure       []gax.CallOption
	CreateCloudExadataInfrastructure    []gax.CallOption
	DeleteCloudExadataInfrastructure    []gax.CallOption
	ListCloudVmClusters                 []gax.CallOption
	GetCloudVmCluster                   []gax.CallOption
	CreateCloudVmCluster                []gax.CallOption
	DeleteCloudVmCluster                []gax.CallOption
	ListEntitlements                    []gax.CallOption
	ListDbServers                       []gax.CallOption
	ListDbNodes                         []gax.CallOption
	ListGiVersions                      []gax.CallOption
	ListDbSystemShapes                  []gax.CallOption
	ListAutonomousDatabases             []gax.CallOption
	GetAutonomousDatabase               []gax.CallOption
	CreateAutonomousDatabase            []gax.CallOption
	DeleteAutonomousDatabase            []gax.CallOption
	RestoreAutonomousDatabase           []gax.CallOption
	GenerateAutonomousDatabaseWallet    []gax.CallOption
	ListAutonomousDbVersions            []gax.CallOption
	ListAutonomousDatabaseCharacterSets []gax.CallOption
	ListAutonomousDatabaseBackups       []gax.CallOption
	GetLocation                         []gax.CallOption
	ListLocations                       []gax.CallOption
	CancelOperation                     []gax.CallOption
	DeleteOperation                     []gax.CallOption
	GetOperation                        []gax.CallOption
	ListOperations                      []gax.CallOption
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListCloudExadataInfrastructures: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		GetCloudExadataInfrastructure: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		CreateCloudExadataInfrastructure: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteCloudExadataInfrastructure: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListCloudVmClusters: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		GetCloudVmCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		CreateCloudVmCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteCloudVmCluster: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListEntitlements: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		ListDbServers: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		ListDbNodes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		ListGiVersions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		ListDbSystemShapes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		ListAutonomousDatabases: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		GetAutonomousDatabase: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		CreateAutonomousDatabase: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteAutonomousDatabase: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RestoreAutonomousDatabase: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GenerateAutonomousDatabaseWallet: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListAutonomousDbVersions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		ListAutonomousDatabaseCharacterSets: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		ListAutonomousDatabaseBackups: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusTooManyRequests,
					http.StatusServiceUnavailable,
					http.StatusInternalServerError,
					http.StatusGatewayTimeout)
			}),
		},
		GetLocation:     []gax.CallOption{},
		ListLocations:   []gax.CallOption{},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Oracle Database@Google Cloud API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListCloudExadataInfrastructures(context.Context, *oracledatabasepb.ListCloudExadataInfrastructuresRequest, ...gax.CallOption) *CloudExadataInfrastructureIterator
	GetCloudExadataInfrastructure(context.Context, *oracledatabasepb.GetCloudExadataInfrastructureRequest, ...gax.CallOption) (*oracledatabasepb.CloudExadataInfrastructure, error)
	CreateCloudExadataInfrastructure(context.Context, *oracledatabasepb.CreateCloudExadataInfrastructureRequest, ...gax.CallOption) (*CreateCloudExadataInfrastructureOperation, error)
	CreateCloudExadataInfrastructureOperation(name string) *CreateCloudExadataInfrastructureOperation
	DeleteCloudExadataInfrastructure(context.Context, *oracledatabasepb.DeleteCloudExadataInfrastructureRequest, ...gax.CallOption) (*DeleteCloudExadataInfrastructureOperation, error)
	DeleteCloudExadataInfrastructureOperation(name string) *DeleteCloudExadataInfrastructureOperation
	ListCloudVmClusters(context.Context, *oracledatabasepb.ListCloudVmClustersRequest, ...gax.CallOption) *CloudVmClusterIterator
	GetCloudVmCluster(context.Context, *oracledatabasepb.GetCloudVmClusterRequest, ...gax.CallOption) (*oracledatabasepb.CloudVmCluster, error)
	CreateCloudVmCluster(context.Context, *oracledatabasepb.CreateCloudVmClusterRequest, ...gax.CallOption) (*CreateCloudVmClusterOperation, error)
	CreateCloudVmClusterOperation(name string) *CreateCloudVmClusterOperation
	DeleteCloudVmCluster(context.Context, *oracledatabasepb.DeleteCloudVmClusterRequest, ...gax.CallOption) (*DeleteCloudVmClusterOperation, error)
	DeleteCloudVmClusterOperation(name string) *DeleteCloudVmClusterOperation
	ListEntitlements(context.Context, *oracledatabasepb.ListEntitlementsRequest, ...gax.CallOption) *EntitlementIterator
	ListDbServers(context.Context, *oracledatabasepb.ListDbServersRequest, ...gax.CallOption) *DbServerIterator
	ListDbNodes(context.Context, *oracledatabasepb.ListDbNodesRequest, ...gax.CallOption) *DbNodeIterator
	ListGiVersions(context.Context, *oracledatabasepb.ListGiVersionsRequest, ...gax.CallOption) *GiVersionIterator
	ListDbSystemShapes(context.Context, *oracledatabasepb.ListDbSystemShapesRequest, ...gax.CallOption) *DbSystemShapeIterator
	ListAutonomousDatabases(context.Context, *oracledatabasepb.ListAutonomousDatabasesRequest, ...gax.CallOption) *AutonomousDatabaseIterator
	GetAutonomousDatabase(context.Context, *oracledatabasepb.GetAutonomousDatabaseRequest, ...gax.CallOption) (*oracledatabasepb.AutonomousDatabase, error)
	CreateAutonomousDatabase(context.Context, *oracledatabasepb.CreateAutonomousDatabaseRequest, ...gax.CallOption) (*CreateAutonomousDatabaseOperation, error)
	CreateAutonomousDatabaseOperation(name string) *CreateAutonomousDatabaseOperation
	DeleteAutonomousDatabase(context.Context, *oracledatabasepb.DeleteAutonomousDatabaseRequest, ...gax.CallOption) (*DeleteAutonomousDatabaseOperation, error)
	DeleteAutonomousDatabaseOperation(name string) *DeleteAutonomousDatabaseOperation
	RestoreAutonomousDatabase(context.Context, *oracledatabasepb.RestoreAutonomousDatabaseRequest, ...gax.CallOption) (*RestoreAutonomousDatabaseOperation, error)
	RestoreAutonomousDatabaseOperation(name string) *RestoreAutonomousDatabaseOperation
	GenerateAutonomousDatabaseWallet(context.Context, *oracledatabasepb.GenerateAutonomousDatabaseWalletRequest, ...gax.CallOption) (*oracledatabasepb.GenerateAutonomousDatabaseWalletResponse, error)
	ListAutonomousDbVersions(context.Context, *oracledatabasepb.ListAutonomousDbVersionsRequest, ...gax.CallOption) *AutonomousDbVersionIterator
	ListAutonomousDatabaseCharacterSets(context.Context, *oracledatabasepb.ListAutonomousDatabaseCharacterSetsRequest, ...gax.CallOption) *AutonomousDatabaseCharacterSetIterator
	ListAutonomousDatabaseBackups(context.Context, *oracledatabasepb.ListAutonomousDatabaseBackupsRequest, ...gax.CallOption) *AutonomousDatabaseBackupIterator
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// Client is a client for interacting with Oracle Database@Google Cloud API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service describing handlers for resources
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListCloudExadataInfrastructures lists Exadata Infrastructures in a given project and location.
func (c *Client) ListCloudExadataInfrastructures(ctx context.Context, req *oracledatabasepb.ListCloudExadataInfrastructuresRequest, opts ...gax.CallOption) *CloudExadataInfrastructureIterator {
	return c.internalClient.ListCloudExadataInfrastructures(ctx, req, opts...)
}

// GetCloudExadataInfrastructure gets details of a single Exadata Infrastructure.
func (c *Client) GetCloudExadataInfrastructure(ctx context.Context, req *oracledatabasepb.GetCloudExadataInfrastructureRequest, opts ...gax.CallOption) (*oracledatabasepb.CloudExadataInfrastructure, error) {
	return c.internalClient.GetCloudExadataInfrastructure(ctx, req, opts...)
}

// CreateCloudExadataInfrastructure creates a new Exadata Infrastructure in a given project and location.
func (c *Client) CreateCloudExadataInfrastructure(ctx context.Context, req *oracledatabasepb.CreateCloudExadataInfrastructureRequest, opts ...gax.CallOption) (*CreateCloudExadataInfrastructureOperation, error) {
	return c.internalClient.CreateCloudExadataInfrastructure(ctx, req, opts...)
}

// CreateCloudExadataInfrastructureOperation returns a new CreateCloudExadataInfrastructureOperation from a given name.
// The name must be that of a previously created CreateCloudExadataInfrastructureOperation, possibly from a different process.
func (c *Client) CreateCloudExadataInfrastructureOperation(name string) *CreateCloudExadataInfrastructureOperation {
	return c.internalClient.CreateCloudExadataInfrastructureOperation(name)
}

// DeleteCloudExadataInfrastructure deletes a single Exadata Infrastructure.
func (c *Client) DeleteCloudExadataInfrastructure(ctx context.Context, req *oracledatabasepb.DeleteCloudExadataInfrastructureRequest, opts ...gax.CallOption) (*DeleteCloudExadataInfrastructureOperation, error) {
	return c.internalClient.DeleteCloudExadataInfrastructure(ctx, req, opts...)
}

// DeleteCloudExadataInfrastructureOperation returns a new DeleteCloudExadataInfrastructureOperation from a given name.
// The name must be that of a previously created DeleteCloudExadataInfrastructureOperation, possibly from a different process.
func (c *Client) DeleteCloudExadataInfrastructureOperation(name string) *DeleteCloudExadataInfrastructureOperation {
	return c.internalClient.DeleteCloudExadataInfrastructureOperation(name)
}

// ListCloudVmClusters lists the VM Clusters in a given project and location.
func (c *Client) ListCloudVmClusters(ctx context.Context, req *oracledatabasepb.ListCloudVmClustersRequest, opts ...gax.CallOption) *CloudVmClusterIterator {
	return c.internalClient.ListCloudVmClusters(ctx, req, opts...)
}

// GetCloudVmCluster gets details of a single VM Cluster.
func (c *Client) GetCloudVmCluster(ctx context.Context, req *oracledatabasepb.GetCloudVmClusterRequest, opts ...gax.CallOption) (*oracledatabasepb.CloudVmCluster, error) {
	return c.internalClient.GetCloudVmCluster(ctx, req, opts...)
}

// CreateCloudVmCluster creates a new VM Cluster in a given project and location.
func (c *Client) CreateCloudVmCluster(ctx context.Context, req *oracledatabasepb.CreateCloudVmClusterRequest, opts ...gax.CallOption) (*CreateCloudVmClusterOperation, error) {
	return c.internalClient.CreateCloudVmCluster(ctx, req, opts...)
}

// CreateCloudVmClusterOperation returns a new CreateCloudVmClusterOperation from a given name.
// The name must be that of a previously created CreateCloudVmClusterOperation, possibly from a different process.
func (c *Client) CreateCloudVmClusterOperation(name string) *CreateCloudVmClusterOperation {
	return c.internalClient.CreateCloudVmClusterOperation(name)
}

// DeleteCloudVmCluster deletes a single VM Cluster.
func (c *Client) DeleteCloudVmCluster(ctx context.Context, req *oracledatabasepb.DeleteCloudVmClusterRequest, opts ...gax.CallOption) (*DeleteCloudVmClusterOperation, error) {
	return c.internalClient.DeleteCloudVmCluster(ctx, req, opts...)
}

// DeleteCloudVmClusterOperation returns a new DeleteCloudVmClusterOperation from a given name.
// The name must be that of a previously created DeleteCloudVmClusterOperation, possibly from a different process.
func (c *Client) DeleteCloudVmClusterOperation(name string) *DeleteCloudVmClusterOperation {
	return c.internalClient.DeleteCloudVmClusterOperation(name)
}

// ListEntitlements lists the entitlements in a given project.
func (c *Client) ListEntitlements(ctx context.Context, req *oracledatabasepb.ListEntitlementsRequest, opts ...gax.CallOption) *EntitlementIterator {
	return c.internalClient.ListEntitlements(ctx, req, opts...)
}

// ListDbServers lists the database servers of an Exadata Infrastructure instance.
func (c *Client) ListDbServers(ctx context.Context, req *oracledatabasepb.ListDbServersRequest, opts ...gax.CallOption) *DbServerIterator {
	return c.internalClient.ListDbServers(ctx, req, opts...)
}

// ListDbNodes lists the database nodes of a VM Cluster.
func (c *Client) ListDbNodes(ctx context.Context, req *oracledatabasepb.ListDbNodesRequest, opts ...gax.CallOption) *DbNodeIterator {
	return c.internalClient.ListDbNodes(ctx, req, opts...)
}

// ListGiVersions lists all the valid Oracle Grid Infrastructure (GI) versions for the given
// project and location.
func (c *Client) ListGiVersions(ctx context.Context, req *oracledatabasepb.ListGiVersionsRequest, opts ...gax.CallOption) *GiVersionIterator {
	return c.internalClient.ListGiVersions(ctx, req, opts...)
}

// ListDbSystemShapes lists the database system shapes available for the project and location.
func (c *Client) ListDbSystemShapes(ctx context.Context, req *oracledatabasepb.ListDbSystemShapesRequest, opts ...gax.CallOption) *DbSystemShapeIterator {
	return c.internalClient.ListDbSystemShapes(ctx, req, opts...)
}

// ListAutonomousDatabases lists the Autonomous Databases in a given project and location.
func (c *Client) ListAutonomousDatabases(ctx context.Context, req *oracledatabasepb.ListAutonomousDatabasesRequest, opts ...gax.CallOption) *AutonomousDatabaseIterator {
	return c.internalClient.ListAutonomousDatabases(ctx, req, opts...)
}

// GetAutonomousDatabase gets the details of a single Autonomous Database.
func (c *Client) GetAutonomousDatabase(ctx context.Context, req *oracledatabasepb.GetAutonomousDatabaseRequest, opts ...gax.CallOption) (*oracledatabasepb.AutonomousDatabase, error) {
	return c.internalClient.GetAutonomousDatabase(ctx, req, opts...)
}

// CreateAutonomousDatabase creates a new Autonomous Database in a given project and location.
func (c *Client) CreateAutonomousDatabase(ctx context.Context, req *oracledatabasepb.CreateAutonomousDatabaseRequest, opts ...gax.CallOption) (*CreateAutonomousDatabaseOperation, error) {
	return c.internalClient.CreateAutonomousDatabase(ctx, req, opts...)
}

// CreateAutonomousDatabaseOperation returns a new CreateAutonomousDatabaseOperation from a given name.
// The name must be that of a previously created CreateAutonomousDatabaseOperation, possibly from a different process.
func (c *Client) CreateAutonomousDatabaseOperation(name string) *CreateAutonomousDatabaseOperation {
	return c.internalClient.CreateAutonomousDatabaseOperation(name)
}

// DeleteAutonomousDatabase deletes a single Autonomous Database.
func (c *Client) DeleteAutonomousDatabase(ctx context.Context, req *oracledatabasepb.DeleteAutonomousDatabaseRequest, opts ...gax.CallOption) (*DeleteAutonomousDatabaseOperation, error) {
	return c.internalClient.DeleteAutonomousDatabase(ctx, req, opts...)
}

// DeleteAutonomousDatabaseOperation returns a new DeleteAutonomousDatabaseOperation from a given name.
// The name must be that of a previously created DeleteAutonomousDatabaseOperation, possibly from a different process.
func (c *Client) DeleteAutonomousDatabaseOperation(name string) *DeleteAutonomousDatabaseOperation {
	return c.internalClient.DeleteAutonomousDatabaseOperation(name)
}

// RestoreAutonomousDatabase restores a single Autonomous Database.
func (c *Client) RestoreAutonomousDatabase(ctx context.Context, req *oracledatabasepb.RestoreAutonomousDatabaseRequest, opts ...gax.CallOption) (*RestoreAutonomousDatabaseOperation, error) {
	return c.internalClient.RestoreAutonomousDatabase(ctx, req, opts...)
}

// RestoreAutonomousDatabaseOperation returns a new RestoreAutonomousDatabaseOperation from a given name.
// The name must be that of a previously created RestoreAutonomousDatabaseOperation, possibly from a different process.
func (c *Client) RestoreAutonomousDatabaseOperation(name string) *RestoreAutonomousDatabaseOperation {
	return c.internalClient.RestoreAutonomousDatabaseOperation(name)
}

// GenerateAutonomousDatabaseWallet generates a wallet for an Autonomous Database.
func (c *Client) GenerateAutonomousDatabaseWallet(ctx context.Context, req *oracledatabasepb.GenerateAutonomousDatabaseWalletRequest, opts ...gax.CallOption) (*oracledatabasepb.GenerateAutonomousDatabaseWalletResponse, error) {
	return c.internalClient.GenerateAutonomousDatabaseWallet(ctx, req, opts...)
}

// ListAutonomousDbVersions lists all the available Autonomous Database versions for a project and
// location.
func (c *Client) ListAutonomousDbVersions(ctx context.Context, req *oracledatabasepb.ListAutonomousDbVersionsRequest, opts ...gax.CallOption) *AutonomousDbVersionIterator {
	return c.internalClient.ListAutonomousDbVersions(ctx, req, opts...)
}

// ListAutonomousDatabaseCharacterSets lists Autonomous Database Character Sets in a given project and location.
func (c *Client) ListAutonomousDatabaseCharacterSets(ctx context.Context, req *oracledatabasepb.ListAutonomousDatabaseCharacterSetsRequest, opts ...gax.CallOption) *AutonomousDatabaseCharacterSetIterator {
	return c.internalClient.ListAutonomousDatabaseCharacterSets(ctx, req, opts...)
}

// ListAutonomousDatabaseBackups lists the long-term and automatic backups of an Autonomous Database.
func (c *Client) ListAutonomousDatabaseBackups(ctx context.Context, req *oracledatabasepb.ListAutonomousDatabaseBackupsRequest, opts ...gax.CallOption) *AutonomousDatabaseBackupIterator {
	return c.internalClient.ListAutonomousDatabaseBackups(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *Client) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *Client) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *Client) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *Client) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *Client) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *Client) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	logger *slog.Logger
}

// NewRESTClient creates a new oracle database rest client.
//
// Service describing handlers for resources
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://oracledatabase.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://oracledatabase.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://oracledatabase.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://oracledatabase.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}

// ListCloudExadataInfrastructures lists Exadata Infrastructures in a given project and location.
func (c *restClient) ListCloudExadataInfrastructures(ctx context.Context, req *oracledatabasepb.ListCloudExadataInfrastructuresRequest, opts ...gax.CallOption) *CloudExadataInfrastructureIterator {
	it := &CloudExadataInfrastructureIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListCloudExadataInfrastructuresRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.CloudExadataInfrastructure, string, error) {
		resp := &oracledatabasepb.ListCloudExadataInfrastructuresResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/cloudExadataInfrastructures", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListCloudExadataInfrastructures")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetCloudExadataInfrastructures(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetCloudExadataInfrastructure gets details of a single Exadata Infrastructure.
func (c *restClient) GetCloudExadataInfrastructure(ctx context.Context, req *oracledatabasepb.GetCloudExadataInfrastructureRequest, opts ...gax.CallOption) (*oracledatabasepb.CloudExadataInfrastructure, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetCloudExadataInfrastructure[0:len((*c.CallOptions).GetCloudExadataInfrastructure):len((*c.CallOptions).GetCloudExadataInfrastructure)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &oracledatabasepb.CloudExadataInfrastructure{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetCloudExadataInfrastructure")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateCloudExadataInfrastructure creates a new Exadata Infrastructure in a given project and location.
func (c *restClient) CreateCloudExadataInfrastructure(ctx context.Context, req *oracledatabasepb.CreateCloudExadataInfrastructureRequest, opts ...gax.CallOption) (*CreateCloudExadataInfrastructureOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCloudExadataInfrastructure()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/cloudExadataInfrastructures", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("cloudExadataInfrastructureId", fmt.Sprintf("%v", req.GetCloudExadataInfrastructureId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateCloudExadataInfrastructure")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateCloudExadataInfrastructureOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteCloudExadataInfrastructure deletes a single Exadata Infrastructure.
func (c *restClient) DeleteCloudExadataInfrastructure(ctx context.Context, req *oracledatabasepb.DeleteCloudExadataInfrastructureRequest, opts ...gax.CallOption) (*DeleteCloudExadataInfrastructureOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteCloudExadataInfrastructure")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteCloudExadataInfrastructureOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListCloudVmClusters lists the VM Clusters in a given project and location.
func (c *restClient) ListCloudVmClusters(ctx context.Context, req *oracledatabasepb.ListCloudVmClustersRequest, opts ...gax.CallOption) *CloudVmClusterIterator {
	it := &CloudVmClusterIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListCloudVmClustersRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.CloudVmCluster, string, error) {
		resp := &oracledatabasepb.ListCloudVmClustersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/cloudVmClusters", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListCloudVmClusters")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetCloudVmClusters(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetCloudVmCluster gets details of a single VM Cluster.
func (c *restClient) GetCloudVmCluster(ctx context.Context, req *oracledatabasepb.GetCloudVmClusterRequest, opts ...gax.CallOption) (*oracledatabasepb.CloudVmCluster, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetCloudVmCluster[0:len((*c.CallOptions).GetCloudVmCluster):len((*c.CallOptions).GetCloudVmCluster)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &oracledatabasepb.CloudVmCluster{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetCloudVmCluster")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateCloudVmCluster creates a new VM Cluster in a given project and location.
func (c *restClient) CreateCloudVmCluster(ctx context.Context, req *oracledatabasepb.CreateCloudVmClusterRequest, opts ...gax.CallOption) (*CreateCloudVmClusterOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCloudVmCluster()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/cloudVmClusters", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("cloudVmClusterId", fmt.Sprintf("%v", req.GetCloudVmClusterId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateCloudVmCluster")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateCloudVmClusterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteCloudVmCluster deletes a single VM Cluster.
func (c *restClient) DeleteCloudVmCluster(ctx context.Context, req *oracledatabasepb.DeleteCloudVmClusterRequest, opts ...gax.CallOption) (*DeleteCloudVmClusterOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForce() {
		params.Add("force", fmt.Sprintf("%v", req.GetForce()))
	}
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteCloudVmCluster")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteCloudVmClusterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListEntitlements lists the entitlements in a given project.
func (c *restClient) ListEntitlements(ctx context.Context, req *oracledatabasepb.ListEntitlementsRequest, opts ...gax.CallOption) *EntitlementIterator {
	it := &EntitlementIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListEntitlementsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.Entitlement, string, error) {
		resp := &oracledatabasepb.ListEntitlementsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/entitlements", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListEntitlements")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEntitlements(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListDbServers lists the database servers of an Exadata Infrastructure instance.
func (c *restClient) ListDbServers(ctx context.Context, req *oracledatabasepb.ListDbServersRequest, opts ...gax.CallOption) *DbServerIterator {
	it := &DbServerIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListDbServersRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.DbServer, string, error) {
		resp := &oracledatabasepb.ListDbServersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/dbServers", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListDbServers")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDbServers(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListDbNodes lists the database nodes of a VM Cluster.
func (c *restClient) ListDbNodes(ctx context.Context, req *oracledatabasepb.ListDbNodesRequest, opts ...gax.CallOption) *DbNodeIterator {
	it := &DbNodeIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListDbNodesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.DbNode, string, error) {
		resp := &oracledatabasepb.ListDbNodesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/dbNodes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListDbNodes")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDbNodes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListGiVersions lists all the valid Oracle Grid Infrastructure (GI) versions for the given
// project and location.
func (c *restClient) ListGiVersions(ctx context.Context, req *oracledatabasepb.ListGiVersionsRequest, opts ...gax.CallOption) *GiVersionIterator {
	it := &GiVersionIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListGiVersionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.GiVersion, string, error) {
		resp := &oracledatabasepb.ListGiVersionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/giVersions", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListGiVersions")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetGiVersions(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListDbSystemShapes lists the database system shapes available for the project and location.
func (c *restClient) ListDbSystemShapes(ctx context.Context, req *oracledatabasepb.ListDbSystemShapesRequest, opts ...gax.CallOption) *DbSystemShapeIterator {
	it := &DbSystemShapeIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListDbSystemShapesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.DbSystemShape, string, error) {
		resp := &oracledatabasepb.ListDbSystemShapesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/dbSystemShapes", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListDbSystemShapes")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDbSystemShapes(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListAutonomousDatabases lists the Autonomous Databases in a given project and location.
func (c *restClient) ListAutonomousDatabases(ctx context.Context, req *oracledatabasepb.ListAutonomousDatabasesRequest, opts ...gax.CallOption) *AutonomousDatabaseIterator {
	it := &AutonomousDatabaseIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListAutonomousDatabasesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.AutonomousDatabase, string, error) {
		resp := &oracledatabasepb.ListAutonomousDatabasesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/autonomousDatabases", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAutonomousDatabases")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAutonomousDatabases(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetAutonomousDatabase gets the details of a single Autonomous Database.
func (c *restClient) GetAutonomousDatabase(ctx context.Context, req *oracledatabasepb.GetAutonomousDatabaseRequest, opts ...gax.CallOption) (*oracledatabasepb.AutonomousDatabase, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetAutonomousDatabase[0:len((*c.CallOptions).GetAutonomousDatabase):len((*c.CallOptions).GetAutonomousDatabase)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &oracledatabasepb.AutonomousDatabase{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetAutonomousDatabase")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateAutonomousDatabase creates a new Autonomous Database in a given project and location.
func (c *restClient) CreateAutonomousDatabase(ctx context.Context, req *oracledatabasepb.CreateAutonomousDatabaseRequest, opts ...gax.CallOption) (*CreateAutonomousDatabaseOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetAutonomousDatabase()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/autonomousDatabases", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("autonomousDatabaseId", fmt.Sprintf("%v", req.GetAutonomousDatabaseId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateAutonomousDatabase")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateAutonomousDatabaseOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteAutonomousDatabase deletes a single Autonomous Database.
func (c *restClient) DeleteAutonomousDatabase(ctx context.Context, req *oracledatabasepb.DeleteAutonomousDatabaseRequest, opts ...gax.CallOption) (*DeleteAutonomousDatabaseOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteAutonomousDatabase")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteAutonomousDatabaseOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RestoreAutonomousDatabase restores a single Autonomous Database.
func (c *restClient) RestoreAutonomousDatabase(ctx context.Context, req *oracledatabasepb.RestoreAutonomousDatabaseRequest, opts ...gax.CallOption) (*RestoreAutonomousDatabaseOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:restore", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RestoreAutonomousDatabase")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RestoreAutonomousDatabaseOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GenerateAutonomousDatabaseWallet generates a wallet for an Autonomous Database.
func (c *restClient) GenerateAutonomousDatabaseWallet(ctx context.Context, req *oracledatabasepb.GenerateAutonomousDatabaseWalletRequest, opts ...gax.CallOption) (*oracledatabasepb.GenerateAutonomousDatabaseWalletResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:generateWallet", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GenerateAutonomousDatabaseWallet[0:len((*c.CallOptions).GenerateAutonomousDatabaseWallet):len((*c.CallOptions).GenerateAutonomousDatabaseWallet)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &oracledatabasepb.GenerateAutonomousDatabaseWalletResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "GenerateAutonomousDatabaseWallet")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListAutonomousDbVersions lists all the available Autonomous Database versions for a project and
// location.
func (c *restClient) ListAutonomousDbVersions(ctx context.Context, req *oracledatabasepb.ListAutonomousDbVersionsRequest, opts ...gax.CallOption) *AutonomousDbVersionIterator {
	it := &AutonomousDbVersionIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListAutonomousDbVersionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.AutonomousDbVersion, string, error) {
		resp := &oracledatabasepb.ListAutonomousDbVersionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/autonomousDbVersions", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAutonomousDbVersions")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAutonomousDbVersions(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListAutonomousDatabaseCharacterSets lists Autonomous Database Character Sets in a given project and location.
func (c *restClient) ListAutonomousDatabaseCharacterSets(ctx context.Context, req *oracledatabasepb.ListAutonomousDatabaseCharacterSetsRequest, opts ...gax.CallOption) *AutonomousDatabaseCharacterSetIterator {
	it := &AutonomousDatabaseCharacterSetIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListAutonomousDatabaseCharacterSetsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.AutonomousDatabaseCharacterSet, string, error) {
		resp := &oracledatabasepb.ListAutonomousDatabaseCharacterSetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/autonomousDatabaseCharacterSets", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAutonomousDatabaseCharacterSets")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAutonomousDatabaseCharacterSets(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListAutonomousDatabaseBackups lists the long-term and automatic backups of an Autonomous Database.
func (c *restClient) ListAutonomousDatabaseBackups(ctx context.Context, req *oracledatabasepb.ListAutonomousDatabaseBackupsRequest, opts ...gax.CallOption) *AutonomousDatabaseBackupIterator {
	it := &AutonomousDatabaseBackupIterator{}
	req = proto.Clone(req).(*oracledatabasepb.ListAutonomousDatabaseBackupsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*oracledatabasepb.AutonomousDatabaseBackup, string, error) {
		resp := &oracledatabasepb.ListAutonomousDatabaseBackupsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/autonomousDatabaseBackups", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListAutonomousDatabaseBackups")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetAutonomousDatabaseBackups(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetLocation gets information about a location.
func (c *restClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLocation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *restClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListLocations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *restClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelOperation")
		return err
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *restClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *restClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *restClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateAutonomousDatabaseOperation returns a new CreateAutonomousDatabaseOperation from a given name.
// The name must be that of a previously created CreateAutonomousDatabaseOperation, possibly from a different process.
func (c *restClient) CreateAutonomousDatabaseOperation(name string) *CreateAutonomousDatabaseOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateAutonomousDatabaseOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateCloudExadataInfrastructureOperation returns a new CreateCloudExadataInfrastructureOperation from a given name.
// The name must be that of a previously created CreateCloudExadataInfrastructureOperation, possibly from a different process.
func (c *restClient) CreateCloudExadataInfrastructureOperation(name string) *CreateCloudExadataInfrastructureOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateCloudExadataInfrastructureOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateCloudVmClusterOperation returns a new CreateCloudVmClusterOperation from a given name.
// The name must be that of a previously created CreateCloudVmClusterOperation, possibly from a different process.
func (c *restClient) CreateCloudVmClusterOperation(name string) *CreateCloudVmClusterOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateCloudVmClusterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteAutonomousDatabaseOperation returns a new DeleteAutonomousDatabaseOperation from a given name.
// The name must be that of a previously created DeleteAutonomousDatabaseOperation, possibly from a different process.
func (c *restClient) DeleteAutonomousDatabaseOperation(name string) *DeleteAutonomousDatabaseOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteAutonomousDatabaseOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteCloudExadataInfrastructureOperation returns a new DeleteCloudExadataInfrastructureOperation from a given name.
// The name must be that of a previously created DeleteCloudExadataInfrastructureOperation, possibly from a different process.
func (c *restClient) DeleteCloudExadataInfrastructureOperation(name string) *DeleteCloudExadataInfrastructureOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteCloudExadataInfrastructureOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteCloudVmClusterOperation returns a new DeleteCloudVmClusterOperation from a given name.
// The name must be that of a previously created DeleteCloudVmClusterOperation, possibly from a different process.
func (c *restClient) DeleteCloudVmClusterOperation(name string) *DeleteCloudVmClusterOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteCloudVmClusterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RestoreAutonomousDatabaseOperation returns a new RestoreAutonomousDatabaseOperation from a given name.
// The name must be that of a previously created RestoreAutonomousDatabaseOperation, possibly from a different process.
func (c *restClient) RestoreAutonomousDatabaseOperation(name string) *RestoreAutonomousDatabaseOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RestoreAutonomousDatabaseOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
