// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/modelarmor/v1/service.proto

package modelarmorpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Option to specify filter match state.
type FilterMatchState int32

const (
	// Unused
	FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED FilterMatchState = 0
	// Matching criteria is not achieved for filters.
	FilterMatchState_NO_MATCH_FOUND FilterMatchState = 1
	// Matching criteria is achieved for the filter.
	FilterMatchState_MATCH_FOUND FilterMatchState = 2
)

// Enum value maps for FilterMatchState.
var (
	FilterMatchState_name = map[int32]string{
		0: "FILTER_MATCH_STATE_UNSPECIFIED",
		1: "NO_MATCH_FOUND",
		2: "MATCH_FOUND",
	}
	FilterMatchState_value = map[string]int32{
		"FILTER_MATCH_STATE_UNSPECIFIED": 0,
		"NO_MATCH_FOUND":                 1,
		"MATCH_FOUND":                    2,
	}
)

func (x FilterMatchState) Enum() *FilterMatchState {
	p := new(FilterMatchState)
	*p = x
	return p
}

func (x FilterMatchState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FilterMatchState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[0].Descriptor()
}

func (FilterMatchState) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[0]
}

func (x FilterMatchState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FilterMatchState.Descriptor instead.
func (FilterMatchState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{0}
}

// Enum which reports whether a specific filter executed successfully or not.
type FilterExecutionState int32

const (
	// Unused
	FilterExecutionState_FILTER_EXECUTION_STATE_UNSPECIFIED FilterExecutionState = 0
	// Filter executed successfully
	FilterExecutionState_EXECUTION_SUCCESS FilterExecutionState = 1
	// Filter execution was skipped. This can happen due to server-side error
	// or permission issue.
	FilterExecutionState_EXECUTION_SKIPPED FilterExecutionState = 2
)

// Enum value maps for FilterExecutionState.
var (
	FilterExecutionState_name = map[int32]string{
		0: "FILTER_EXECUTION_STATE_UNSPECIFIED",
		1: "EXECUTION_SUCCESS",
		2: "EXECUTION_SKIPPED",
	}
	FilterExecutionState_value = map[string]int32{
		"FILTER_EXECUTION_STATE_UNSPECIFIED": 0,
		"EXECUTION_SUCCESS":                  1,
		"EXECUTION_SKIPPED":                  2,
	}
)

func (x FilterExecutionState) Enum() *FilterExecutionState {
	p := new(FilterExecutionState)
	*p = x
	return p
}

func (x FilterExecutionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FilterExecutionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[1].Descriptor()
}

func (FilterExecutionState) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[1]
}

func (x FilterExecutionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FilterExecutionState.Descriptor instead.
func (FilterExecutionState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{1}
}

// Options for responsible AI Filter Types.
type RaiFilterType int32

const (
	// Unspecified filter type.
	RaiFilterType_RAI_FILTER_TYPE_UNSPECIFIED RaiFilterType = 0
	// Sexually Explicit.
	RaiFilterType_SEXUALLY_EXPLICIT RaiFilterType = 2
	// Hate Speech.
	RaiFilterType_HATE_SPEECH RaiFilterType = 3
	// Harassment.
	RaiFilterType_HARASSMENT RaiFilterType = 6
	// Danger
	RaiFilterType_DANGEROUS RaiFilterType = 17
)

// Enum value maps for RaiFilterType.
var (
	RaiFilterType_name = map[int32]string{
		0:  "RAI_FILTER_TYPE_UNSPECIFIED",
		2:  "SEXUALLY_EXPLICIT",
		3:  "HATE_SPEECH",
		6:  "HARASSMENT",
		17: "DANGEROUS",
	}
	RaiFilterType_value = map[string]int32{
		"RAI_FILTER_TYPE_UNSPECIFIED": 0,
		"SEXUALLY_EXPLICIT":           2,
		"HATE_SPEECH":                 3,
		"HARASSMENT":                  6,
		"DANGEROUS":                   17,
	}
)

func (x RaiFilterType) Enum() *RaiFilterType {
	p := new(RaiFilterType)
	*p = x
	return p
}

func (x RaiFilterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RaiFilterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[2].Descriptor()
}

func (RaiFilterType) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[2]
}

func (x RaiFilterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RaiFilterType.Descriptor instead.
func (RaiFilterType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{2}
}

// Confidence levels for detectors.
// Higher value maps to a greater confidence level. To enforce stricter level a
// lower value should be used.
type DetectionConfidenceLevel int32

const (
	// Same as LOW_AND_ABOVE.
	DetectionConfidenceLevel_DETECTION_CONFIDENCE_LEVEL_UNSPECIFIED DetectionConfidenceLevel = 0
	// Highest chance of a false positive.
	DetectionConfidenceLevel_LOW_AND_ABOVE DetectionConfidenceLevel = 1
	// Some chance of false positives.
	DetectionConfidenceLevel_MEDIUM_AND_ABOVE DetectionConfidenceLevel = 2
	// Low chance of false positives.
	DetectionConfidenceLevel_HIGH DetectionConfidenceLevel = 3
)

// Enum value maps for DetectionConfidenceLevel.
var (
	DetectionConfidenceLevel_name = map[int32]string{
		0: "DETECTION_CONFIDENCE_LEVEL_UNSPECIFIED",
		1: "LOW_AND_ABOVE",
		2: "MEDIUM_AND_ABOVE",
		3: "HIGH",
	}
	DetectionConfidenceLevel_value = map[string]int32{
		"DETECTION_CONFIDENCE_LEVEL_UNSPECIFIED": 0,
		"LOW_AND_ABOVE":                          1,
		"MEDIUM_AND_ABOVE":                       2,
		"HIGH":                                   3,
	}
)

func (x DetectionConfidenceLevel) Enum() *DetectionConfidenceLevel {
	p := new(DetectionConfidenceLevel)
	*p = x
	return p
}

func (x DetectionConfidenceLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DetectionConfidenceLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[3].Descriptor()
}

func (DetectionConfidenceLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[3]
}

func (x DetectionConfidenceLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DetectionConfidenceLevel.Descriptor instead.
func (DetectionConfidenceLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{3}
}

// For more information about each Sensitive Data Protection likelihood level,
// see https://cloud.google.com/sensitive-data-protection/docs/likelihood.
type SdpFindingLikelihood int32

const (
	// Default value; same as POSSIBLE.
	SdpFindingLikelihood_SDP_FINDING_LIKELIHOOD_UNSPECIFIED SdpFindingLikelihood = 0
	// Highest chance of a false positive.
	SdpFindingLikelihood_VERY_UNLIKELY SdpFindingLikelihood = 1
	// High chance of a false positive.
	SdpFindingLikelihood_UNLIKELY SdpFindingLikelihood = 2
	// Some matching signals. The default value.
	SdpFindingLikelihood_POSSIBLE SdpFindingLikelihood = 3
	// Low chance of a false positive.
	SdpFindingLikelihood_LIKELY SdpFindingLikelihood = 4
	// Confidence level is high. Lowest chance of a false positive.
	SdpFindingLikelihood_VERY_LIKELY SdpFindingLikelihood = 5
)

// Enum value maps for SdpFindingLikelihood.
var (
	SdpFindingLikelihood_name = map[int32]string{
		0: "SDP_FINDING_LIKELIHOOD_UNSPECIFIED",
		1: "VERY_UNLIKELY",
		2: "UNLIKELY",
		3: "POSSIBLE",
		4: "LIKELY",
		5: "VERY_LIKELY",
	}
	SdpFindingLikelihood_value = map[string]int32{
		"SDP_FINDING_LIKELIHOOD_UNSPECIFIED": 0,
		"VERY_UNLIKELY":                      1,
		"UNLIKELY":                           2,
		"POSSIBLE":                           3,
		"LIKELY":                             4,
		"VERY_LIKELY":                        5,
	}
)

func (x SdpFindingLikelihood) Enum() *SdpFindingLikelihood {
	p := new(SdpFindingLikelihood)
	*p = x
	return p
}

func (x SdpFindingLikelihood) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SdpFindingLikelihood) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[4].Descriptor()
}

func (SdpFindingLikelihood) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[4]
}

func (x SdpFindingLikelihood) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SdpFindingLikelihood.Descriptor instead.
func (SdpFindingLikelihood) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{4}
}

// A field indicating the outcome of the invocation, irrespective of match
// status.
type InvocationResult int32

const (
	// Unused. Default value.
	InvocationResult_INVOCATION_RESULT_UNSPECIFIED InvocationResult = 0
	// All filters were invoked successfully.
	InvocationResult_SUCCESS InvocationResult = 1
	// Some filters were skipped or failed.
	InvocationResult_PARTIAL InvocationResult = 2
	// All filters were skipped or failed.
	InvocationResult_FAILURE InvocationResult = 3
)

// Enum value maps for InvocationResult.
var (
	InvocationResult_name = map[int32]string{
		0: "INVOCATION_RESULT_UNSPECIFIED",
		1: "SUCCESS",
		2: "PARTIAL",
		3: "FAILURE",
	}
	InvocationResult_value = map[string]int32{
		"INVOCATION_RESULT_UNSPECIFIED": 0,
		"SUCCESS":                       1,
		"PARTIAL":                       2,
		"FAILURE":                       3,
	}
)

func (x InvocationResult) Enum() *InvocationResult {
	p := new(InvocationResult)
	*p = x
	return p
}

func (x InvocationResult) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InvocationResult) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[5].Descriptor()
}

func (InvocationResult) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[5]
}

func (x InvocationResult) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InvocationResult.Descriptor instead.
func (InvocationResult) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{5}
}

// Option to specify the state of Prompt Injection and Jailbreak filter
// (ENABLED/DISABLED).
type PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement int32

const (
	// Same as Disabled
	PiAndJailbreakFilterSettings_PI_AND_JAILBREAK_FILTER_ENFORCEMENT_UNSPECIFIED PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement = 0
	// Enabled
	PiAndJailbreakFilterSettings_ENABLED PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement = 1
	// Enabled
	PiAndJailbreakFilterSettings_DISABLED PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement = 2
)

// Enum value maps for PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement.
var (
	PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement_name = map[int32]string{
		0: "PI_AND_JAILBREAK_FILTER_ENFORCEMENT_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
	}
	PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement_value = map[string]int32{
		"PI_AND_JAILBREAK_FILTER_ENFORCEMENT_UNSPECIFIED": 0,
		"ENABLED":  1,
		"DISABLED": 2,
	}
)

func (x PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement) Enum() *PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement {
	p := new(PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement)
	*p = x
	return p
}

func (x PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[6].Descriptor()
}

func (PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[6]
}

func (x PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement.Descriptor instead.
func (PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{11, 0}
}

// Option to specify the state of Malicious URI filter (ENABLED/DISABLED).
type MaliciousUriFilterSettings_MaliciousUriFilterEnforcement int32

const (
	// Same as Disabled
	MaliciousUriFilterSettings_MALICIOUS_URI_FILTER_ENFORCEMENT_UNSPECIFIED MaliciousUriFilterSettings_MaliciousUriFilterEnforcement = 0
	// Enabled
	MaliciousUriFilterSettings_ENABLED MaliciousUriFilterSettings_MaliciousUriFilterEnforcement = 1
	// Disabled
	MaliciousUriFilterSettings_DISABLED MaliciousUriFilterSettings_MaliciousUriFilterEnforcement = 2
)

// Enum value maps for MaliciousUriFilterSettings_MaliciousUriFilterEnforcement.
var (
	MaliciousUriFilterSettings_MaliciousUriFilterEnforcement_name = map[int32]string{
		0: "MALICIOUS_URI_FILTER_ENFORCEMENT_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
	}
	MaliciousUriFilterSettings_MaliciousUriFilterEnforcement_value = map[string]int32{
		"MALICIOUS_URI_FILTER_ENFORCEMENT_UNSPECIFIED": 0,
		"ENABLED":  1,
		"DISABLED": 2,
	}
)

func (x MaliciousUriFilterSettings_MaliciousUriFilterEnforcement) Enum() *MaliciousUriFilterSettings_MaliciousUriFilterEnforcement {
	p := new(MaliciousUriFilterSettings_MaliciousUriFilterEnforcement)
	*p = x
	return p
}

func (x MaliciousUriFilterSettings_MaliciousUriFilterEnforcement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MaliciousUriFilterSettings_MaliciousUriFilterEnforcement) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[7].Descriptor()
}

func (MaliciousUriFilterSettings_MaliciousUriFilterEnforcement) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[7]
}

func (x MaliciousUriFilterSettings_MaliciousUriFilterEnforcement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MaliciousUriFilterSettings_MaliciousUriFilterEnforcement.Descriptor instead.
func (MaliciousUriFilterSettings_MaliciousUriFilterEnforcement) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{12, 0}
}

// Option to specify the state of Sensitive Data Protection basic config
// (ENABLED/DISABLED).
type SdpBasicConfig_SdpBasicConfigEnforcement int32

const (
	// Same as Disabled
	SdpBasicConfig_SDP_BASIC_CONFIG_ENFORCEMENT_UNSPECIFIED SdpBasicConfig_SdpBasicConfigEnforcement = 0
	// Enabled
	SdpBasicConfig_ENABLED SdpBasicConfig_SdpBasicConfigEnforcement = 1
	// Disabled
	SdpBasicConfig_DISABLED SdpBasicConfig_SdpBasicConfigEnforcement = 2
)

// Enum value maps for SdpBasicConfig_SdpBasicConfigEnforcement.
var (
	SdpBasicConfig_SdpBasicConfigEnforcement_name = map[int32]string{
		0: "SDP_BASIC_CONFIG_ENFORCEMENT_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
	}
	SdpBasicConfig_SdpBasicConfigEnforcement_value = map[string]int32{
		"SDP_BASIC_CONFIG_ENFORCEMENT_UNSPECIFIED": 0,
		"ENABLED":  1,
		"DISABLED": 2,
	}
)

func (x SdpBasicConfig_SdpBasicConfigEnforcement) Enum() *SdpBasicConfig_SdpBasicConfigEnforcement {
	p := new(SdpBasicConfig_SdpBasicConfigEnforcement)
	*p = x
	return p
}

func (x SdpBasicConfig_SdpBasicConfigEnforcement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SdpBasicConfig_SdpBasicConfigEnforcement) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[8].Descriptor()
}

func (SdpBasicConfig_SdpBasicConfigEnforcement) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[8]
}

func (x SdpBasicConfig_SdpBasicConfigEnforcement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SdpBasicConfig_SdpBasicConfigEnforcement.Descriptor instead.
func (SdpBasicConfig_SdpBasicConfigEnforcement) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{15, 0}
}

// Option to specify the type of byte data.
type ByteDataItem_ByteItemType int32

const (
	// Unused
	ByteDataItem_BYTE_ITEM_TYPE_UNSPECIFIED ByteDataItem_ByteItemType = 0
	// plain text
	ByteDataItem_PLAINTEXT_UTF8 ByteDataItem_ByteItemType = 1
	// PDF
	ByteDataItem_PDF ByteDataItem_ByteItemType = 2
)

// Enum value maps for ByteDataItem_ByteItemType.
var (
	ByteDataItem_ByteItemType_name = map[int32]string{
		0: "BYTE_ITEM_TYPE_UNSPECIFIED",
		1: "PLAINTEXT_UTF8",
		2: "PDF",
	}
	ByteDataItem_ByteItemType_value = map[string]int32{
		"BYTE_ITEM_TYPE_UNSPECIFIED": 0,
		"PLAINTEXT_UTF8":             1,
		"PDF":                        2,
	}
)

func (x ByteDataItem_ByteItemType) Enum() *ByteDataItem_ByteItemType {
	p := new(ByteDataItem_ByteItemType)
	*p = x
	return p
}

func (x ByteDataItem_ByteItemType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ByteDataItem_ByteItemType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[9].Descriptor()
}

func (ByteDataItem_ByteItemType) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[9]
}

func (x ByteDataItem_ByteItemType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ByteDataItem_ByteItemType.Descriptor instead.
func (ByteDataItem_ByteItemType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{27, 0}
}

// Type of content scanned.
type VirusScanFilterResult_ScannedContentType int32

const (
	// Unused
	VirusScanFilterResult_SCANNED_CONTENT_TYPE_UNSPECIFIED VirusScanFilterResult_ScannedContentType = 0
	// Unknown content
	VirusScanFilterResult_UNKNOWN VirusScanFilterResult_ScannedContentType = 1
	// Plaintext
	VirusScanFilterResult_PLAINTEXT VirusScanFilterResult_ScannedContentType = 2
	// PDF
	// Scanning for only PDF is supported.
	VirusScanFilterResult_PDF VirusScanFilterResult_ScannedContentType = 3
)

// Enum value maps for VirusScanFilterResult_ScannedContentType.
var (
	VirusScanFilterResult_ScannedContentType_name = map[int32]string{
		0: "SCANNED_CONTENT_TYPE_UNSPECIFIED",
		1: "UNKNOWN",
		2: "PLAINTEXT",
		3: "PDF",
	}
	VirusScanFilterResult_ScannedContentType_value = map[string]int32{
		"SCANNED_CONTENT_TYPE_UNSPECIFIED": 0,
		"UNKNOWN":                          1,
		"PLAINTEXT":                        2,
		"PDF":                              3,
	}
)

func (x VirusScanFilterResult_ScannedContentType) Enum() *VirusScanFilterResult_ScannedContentType {
	p := new(VirusScanFilterResult_ScannedContentType)
	*p = x
	return p
}

func (x VirusScanFilterResult_ScannedContentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VirusScanFilterResult_ScannedContentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[10].Descriptor()
}

func (VirusScanFilterResult_ScannedContentType) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[10]
}

func (x VirusScanFilterResult_ScannedContentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VirusScanFilterResult_ScannedContentType.Descriptor instead.
func (VirusScanFilterResult_ScannedContentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{32, 0}
}

// Defines all the threat types of a virus
type VirusDetail_ThreatType int32

const (
	// Unused
	VirusDetail_THREAT_TYPE_UNSPECIFIED VirusDetail_ThreatType = 0
	// Unable to categorize threat
	VirusDetail_UNKNOWN VirusDetail_ThreatType = 1
	// Virus or Worm threat.
	VirusDetail_VIRUS_OR_WORM VirusDetail_ThreatType = 2
	// Malicious program. E.g. Spyware, Trojan.
	VirusDetail_MALICIOUS_PROGRAM VirusDetail_ThreatType = 3
	// Potentially harmful content. E.g. Injected code, Macro
	VirusDetail_POTENTIALLY_HARMFUL_CONTENT VirusDetail_ThreatType = 4
	// Potentially unwanted content. E.g. Adware.
	VirusDetail_POTENTIALLY_UNWANTED_CONTENT VirusDetail_ThreatType = 5
)

// Enum value maps for VirusDetail_ThreatType.
var (
	VirusDetail_ThreatType_name = map[int32]string{
		0: "THREAT_TYPE_UNSPECIFIED",
		1: "UNKNOWN",
		2: "VIRUS_OR_WORM",
		3: "MALICIOUS_PROGRAM",
		4: "POTENTIALLY_HARMFUL_CONTENT",
		5: "POTENTIALLY_UNWANTED_CONTENT",
	}
	VirusDetail_ThreatType_value = map[string]int32{
		"THREAT_TYPE_UNSPECIFIED":      0,
		"UNKNOWN":                      1,
		"VIRUS_OR_WORM":                2,
		"MALICIOUS_PROGRAM":            3,
		"POTENTIALLY_HARMFUL_CONTENT":  4,
		"POTENTIALLY_UNWANTED_CONTENT": 5,
	}
)

func (x VirusDetail_ThreatType) Enum() *VirusDetail_ThreatType {
	p := new(VirusDetail_ThreatType)
	*p = x
	return p
}

func (x VirusDetail_ThreatType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VirusDetail_ThreatType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[11].Descriptor()
}

func (VirusDetail_ThreatType) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[11]
}

func (x VirusDetail_ThreatType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VirusDetail_ThreatType.Descriptor instead.
func (VirusDetail_ThreatType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{33, 0}
}

// Option to specify the type of message.
type MessageItem_MessageType int32

const (
	// Unused
	MessageItem_MESSAGE_TYPE_UNSPECIFIED MessageItem_MessageType = 0
	// Information related message.
	MessageItem_INFO MessageItem_MessageType = 1
	// Warning related message.
	MessageItem_WARNING MessageItem_MessageType = 2
	// Error message.
	MessageItem_ERROR MessageItem_MessageType = 3
)

// Enum value maps for MessageItem_MessageType.
var (
	MessageItem_MessageType_name = map[int32]string{
		0: "MESSAGE_TYPE_UNSPECIFIED",
		1: "INFO",
		2: "WARNING",
		3: "ERROR",
	}
	MessageItem_MessageType_value = map[string]int32{
		"MESSAGE_TYPE_UNSPECIFIED": 0,
		"INFO":                     1,
		"WARNING":                  2,
		"ERROR":                    3,
	}
)

func (x MessageItem_MessageType) Enum() *MessageItem_MessageType {
	p := new(MessageItem_MessageType)
	*p = x
	return p
}

func (x MessageItem_MessageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MessageItem_MessageType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_modelarmor_v1_service_proto_enumTypes[12].Descriptor()
}

func (MessageItem_MessageType) Type() protoreflect.EnumType {
	return &file_google_cloud_modelarmor_v1_service_proto_enumTypes[12]
}

func (x MessageItem_MessageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MessageItem_MessageType.Descriptor instead.
func (MessageItem_MessageType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{35, 0}
}

// Message describing Template resource
type Template struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. name of resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. [Output only] Create time stamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update time stamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. filter configuration for this template
	FilterConfig *FilterConfig `protobuf:"bytes,5,opt,name=filter_config,json=filterConfig,proto3" json:"filter_config,omitempty"`
	// Optional. metadata for this template
	TemplateMetadata *Template_TemplateMetadata `protobuf:"bytes,6,opt,name=template_metadata,json=templateMetadata,proto3" json:"template_metadata,omitempty"`
}

func (x *Template) Reset() {
	*x = Template{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Template) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Template) ProtoMessage() {}

func (x *Template) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Template.ProtoReflect.Descriptor instead.
func (*Template) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{0}
}

func (x *Template) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Template) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Template) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Template) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Template) GetFilterConfig() *FilterConfig {
	if x != nil {
		return x.FilterConfig
	}
	return nil
}

func (x *Template) GetTemplateMetadata() *Template_TemplateMetadata {
	if x != nil {
		return x.TemplateMetadata
	}
	return nil
}

// Message describing FloorSetting resource
type FloorSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. [Output only] Create timestamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update timestamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. ModelArmor filter configuration.
	FilterConfig *FilterConfig `protobuf:"bytes,4,opt,name=filter_config,json=filterConfig,proto3" json:"filter_config,omitempty"`
	// Optional. Floor Settings enforcement status.
	EnableFloorSettingEnforcement *bool `protobuf:"varint,5,opt,name=enable_floor_setting_enforcement,json=enableFloorSettingEnforcement,proto3,oneof" json:"enable_floor_setting_enforcement,omitempty"`
}

func (x *FloorSetting) Reset() {
	*x = FloorSetting{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FloorSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FloorSetting) ProtoMessage() {}

func (x *FloorSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FloorSetting.ProtoReflect.Descriptor instead.
func (*FloorSetting) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{1}
}

func (x *FloorSetting) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FloorSetting) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *FloorSetting) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *FloorSetting) GetFilterConfig() *FilterConfig {
	if x != nil {
		return x.FilterConfig
	}
	return nil
}

func (x *FloorSetting) GetEnableFloorSettingEnforcement() bool {
	if x != nil && x.EnableFloorSettingEnforcement != nil {
		return *x.EnableFloorSettingEnforcement
	}
	return false
}

// Message for requesting list of Templates
type ListTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListTemplatesRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListTemplatesRequest) Reset() {
	*x = ListTemplatesRequest{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTemplatesRequest) ProtoMessage() {}

func (x *ListTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTemplatesRequest.ProtoReflect.Descriptor instead.
func (*ListTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListTemplatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTemplatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTemplatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTemplatesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTemplatesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Templates
type ListTemplatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Template
	Templates []*Template `protobuf:"bytes,1,rep,name=templates,proto3" json:"templates,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListTemplatesResponse) Reset() {
	*x = ListTemplatesResponse{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTemplatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTemplatesResponse) ProtoMessage() {}

func (x *ListTemplatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTemplatesResponse.ProtoReflect.Descriptor instead.
func (*ListTemplatesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListTemplatesResponse) GetTemplates() []*Template {
	if x != nil {
		return x.Templates
	}
	return nil
}

func (x *ListTemplatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTemplatesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Template
type GetTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTemplateRequest) Reset() {
	*x = GetTemplateRequest{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTemplateRequest) ProtoMessage() {}

func (x *GetTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{4}
}

func (x *GetTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a Template
type CreateTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object
	// If auto-generating Id server-side, remove this field and
	// template_id from the method_signature of Create RPC
	TemplateId string `protobuf:"bytes,2,opt,name=template_id,json=templateId,proto3" json:"template_id,omitempty"`
	// Required. The resource being created
	Template *Template `protobuf:"bytes,3,opt,name=template,proto3" json:"template,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server stores the
	// request ID for 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateTemplateRequest) Reset() {
	*x = CreateTemplateRequest{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTemplateRequest) ProtoMessage() {}

func (x *CreateTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTemplateRequest.ProtoReflect.Descriptor instead.
func (*CreateTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateTemplateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTemplateRequest) GetTemplateId() string {
	if x != nil {
		return x.TemplateId
	}
	return ""
}

func (x *CreateTemplateRequest) GetTemplate() *Template {
	if x != nil {
		return x.Template
	}
	return nil
}

func (x *CreateTemplateRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating a Template
type UpdateTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Template resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	Template *Template `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server stores the
	// request ID for 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateTemplateRequest) Reset() {
	*x = UpdateTemplateRequest{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTemplateRequest) ProtoMessage() {}

func (x *UpdateTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTemplateRequest.ProtoReflect.Descriptor instead.
func (*UpdateTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateTemplateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTemplateRequest) GetTemplate() *Template {
	if x != nil {
		return x.Template
	}
	return nil
}

func (x *UpdateTemplateRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a Template
type DeleteTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server stores the
	// request ID for 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteTemplateRequest) Reset() {
	*x = DeleteTemplateRequest{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTemplateRequest) ProtoMessage() {}

func (x *DeleteTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTemplateRequest.ProtoReflect.Descriptor instead.
func (*DeleteTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTemplateRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for getting a Floor Setting
type GetFloorSettingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the floor setting to get, example
	// projects/123/floorsetting.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFloorSettingRequest) Reset() {
	*x = GetFloorSettingRequest{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFloorSettingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFloorSettingRequest) ProtoMessage() {}

func (x *GetFloorSettingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFloorSettingRequest.ProtoReflect.Descriptor instead.
func (*GetFloorSettingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetFloorSettingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for Updating a Floor Setting
type UpdateFloorSettingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The floor setting being updated.
	FloorSetting *FloorSetting `protobuf:"bytes,1,opt,name=floor_setting,json=floorSetting,proto3" json:"floor_setting,omitempty"`
	// Optional. Field mask is used to specify the fields to be overwritten in the
	// FloorSetting resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFloorSettingRequest) Reset() {
	*x = UpdateFloorSettingRequest{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFloorSettingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFloorSettingRequest) ProtoMessage() {}

func (x *UpdateFloorSettingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFloorSettingRequest.ProtoReflect.Descriptor instead.
func (*UpdateFloorSettingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateFloorSettingRequest) GetFloorSetting() *FloorSetting {
	if x != nil {
		return x.FloorSetting
	}
	return nil
}

func (x *UpdateFloorSettingRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Filters configuration.
type FilterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Responsible AI settings.
	RaiSettings *RaiFilterSettings `protobuf:"bytes,1,opt,name=rai_settings,json=raiSettings,proto3" json:"rai_settings,omitempty"`
	// Optional. Sensitive Data Protection settings.
	SdpSettings *SdpFilterSettings `protobuf:"bytes,2,opt,name=sdp_settings,json=sdpSettings,proto3" json:"sdp_settings,omitempty"`
	// Optional. Prompt injection and Jailbreak filter settings.
	PiAndJailbreakFilterSettings *PiAndJailbreakFilterSettings `protobuf:"bytes,3,opt,name=pi_and_jailbreak_filter_settings,json=piAndJailbreakFilterSettings,proto3" json:"pi_and_jailbreak_filter_settings,omitempty"`
	// Optional. Malicious URI filter settings.
	MaliciousUriFilterSettings *MaliciousUriFilterSettings `protobuf:"bytes,4,opt,name=malicious_uri_filter_settings,json=maliciousUriFilterSettings,proto3" json:"malicious_uri_filter_settings,omitempty"`
}

func (x *FilterConfig) Reset() {
	*x = FilterConfig{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterConfig) ProtoMessage() {}

func (x *FilterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterConfig.ProtoReflect.Descriptor instead.
func (*FilterConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{10}
}

func (x *FilterConfig) GetRaiSettings() *RaiFilterSettings {
	if x != nil {
		return x.RaiSettings
	}
	return nil
}

func (x *FilterConfig) GetSdpSettings() *SdpFilterSettings {
	if x != nil {
		return x.SdpSettings
	}
	return nil
}

func (x *FilterConfig) GetPiAndJailbreakFilterSettings() *PiAndJailbreakFilterSettings {
	if x != nil {
		return x.PiAndJailbreakFilterSettings
	}
	return nil
}

func (x *FilterConfig) GetMaliciousUriFilterSettings() *MaliciousUriFilterSettings {
	if x != nil {
		return x.MaliciousUriFilterSettings
	}
	return nil
}

// Prompt injection and Jailbreak Filter settings.
type PiAndJailbreakFilterSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Tells whether Prompt injection and Jailbreak filter is enabled or
	// disabled.
	FilterEnforcement PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement `protobuf:"varint,1,opt,name=filter_enforcement,json=filterEnforcement,proto3,enum=google.cloud.modelarmor.v1.PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement" json:"filter_enforcement,omitempty"`
	// Optional. Confidence level for this filter.
	// Confidence level is used to determine the threshold for the filter. If
	// detection confidence is equal to or greater than the specified level, a
	// positive match is reported. Confidence level will only be used if the
	// filter is enabled.
	ConfidenceLevel DetectionConfidenceLevel `protobuf:"varint,3,opt,name=confidence_level,json=confidenceLevel,proto3,enum=google.cloud.modelarmor.v1.DetectionConfidenceLevel" json:"confidence_level,omitempty"`
}

func (x *PiAndJailbreakFilterSettings) Reset() {
	*x = PiAndJailbreakFilterSettings{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PiAndJailbreakFilterSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PiAndJailbreakFilterSettings) ProtoMessage() {}

func (x *PiAndJailbreakFilterSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PiAndJailbreakFilterSettings.ProtoReflect.Descriptor instead.
func (*PiAndJailbreakFilterSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{11}
}

func (x *PiAndJailbreakFilterSettings) GetFilterEnforcement() PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement {
	if x != nil {
		return x.FilterEnforcement
	}
	return PiAndJailbreakFilterSettings_PI_AND_JAILBREAK_FILTER_ENFORCEMENT_UNSPECIFIED
}

func (x *PiAndJailbreakFilterSettings) GetConfidenceLevel() DetectionConfidenceLevel {
	if x != nil {
		return x.ConfidenceLevel
	}
	return DetectionConfidenceLevel_DETECTION_CONFIDENCE_LEVEL_UNSPECIFIED
}

// Malicious URI filter settings.
type MaliciousUriFilterSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Tells whether the Malicious URI filter is enabled or disabled.
	FilterEnforcement MaliciousUriFilterSettings_MaliciousUriFilterEnforcement `protobuf:"varint,1,opt,name=filter_enforcement,json=filterEnforcement,proto3,enum=google.cloud.modelarmor.v1.MaliciousUriFilterSettings_MaliciousUriFilterEnforcement" json:"filter_enforcement,omitempty"`
}

func (x *MaliciousUriFilterSettings) Reset() {
	*x = MaliciousUriFilterSettings{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaliciousUriFilterSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaliciousUriFilterSettings) ProtoMessage() {}

func (x *MaliciousUriFilterSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaliciousUriFilterSettings.ProtoReflect.Descriptor instead.
func (*MaliciousUriFilterSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{12}
}

func (x *MaliciousUriFilterSettings) GetFilterEnforcement() MaliciousUriFilterSettings_MaliciousUriFilterEnforcement {
	if x != nil {
		return x.FilterEnforcement
	}
	return MaliciousUriFilterSettings_MALICIOUS_URI_FILTER_ENFORCEMENT_UNSPECIFIED
}

// Responsible AI Filter settings.
type RaiFilterSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of Responsible AI filters enabled for template.
	RaiFilters []*RaiFilterSettings_RaiFilter `protobuf:"bytes,1,rep,name=rai_filters,json=raiFilters,proto3" json:"rai_filters,omitempty"`
}

func (x *RaiFilterSettings) Reset() {
	*x = RaiFilterSettings{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaiFilterSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaiFilterSettings) ProtoMessage() {}

func (x *RaiFilterSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaiFilterSettings.ProtoReflect.Descriptor instead.
func (*RaiFilterSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{13}
}

func (x *RaiFilterSettings) GetRaiFilters() []*RaiFilterSettings_RaiFilter {
	if x != nil {
		return x.RaiFilters
	}
	return nil
}

// Sensitive Data Protection settings.
type SdpFilterSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Either of Sensitive Data Protection basic or advanced configuration.
	//
	// Types that are assignable to SdpConfiguration:
	//
	//	*SdpFilterSettings_BasicConfig
	//	*SdpFilterSettings_AdvancedConfig
	SdpConfiguration isSdpFilterSettings_SdpConfiguration `protobuf_oneof:"sdp_configuration"`
}

func (x *SdpFilterSettings) Reset() {
	*x = SdpFilterSettings{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SdpFilterSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdpFilterSettings) ProtoMessage() {}

func (x *SdpFilterSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdpFilterSettings.ProtoReflect.Descriptor instead.
func (*SdpFilterSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{14}
}

func (m *SdpFilterSettings) GetSdpConfiguration() isSdpFilterSettings_SdpConfiguration {
	if m != nil {
		return m.SdpConfiguration
	}
	return nil
}

func (x *SdpFilterSettings) GetBasicConfig() *SdpBasicConfig {
	if x, ok := x.GetSdpConfiguration().(*SdpFilterSettings_BasicConfig); ok {
		return x.BasicConfig
	}
	return nil
}

func (x *SdpFilterSettings) GetAdvancedConfig() *SdpAdvancedConfig {
	if x, ok := x.GetSdpConfiguration().(*SdpFilterSettings_AdvancedConfig); ok {
		return x.AdvancedConfig
	}
	return nil
}

type isSdpFilterSettings_SdpConfiguration interface {
	isSdpFilterSettings_SdpConfiguration()
}

type SdpFilterSettings_BasicConfig struct {
	// Optional. Basic Sensitive Data Protection configuration inspects the
	// content for sensitive data using a fixed set of six info-types. Sensitive
	// Data Protection templates cannot be used with basic configuration. Only
	// Sensitive Data Protection inspection operation is supported with basic
	// configuration.
	BasicConfig *SdpBasicConfig `protobuf:"bytes,1,opt,name=basic_config,json=basicConfig,proto3,oneof"`
}

type SdpFilterSettings_AdvancedConfig struct {
	// Optional. Advanced Sensitive Data Protection configuration which enables
	// use of Sensitive Data Protection templates. Supports both Sensitive Data
	// Protection inspection and de-identification operations.
	AdvancedConfig *SdpAdvancedConfig `protobuf:"bytes,2,opt,name=advanced_config,json=advancedConfig,proto3,oneof"`
}

func (*SdpFilterSettings_BasicConfig) isSdpFilterSettings_SdpConfiguration() {}

func (*SdpFilterSettings_AdvancedConfig) isSdpFilterSettings_SdpConfiguration() {}

// Sensitive Data Protection basic configuration.
type SdpBasicConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Tells whether the Sensitive Data Protection basic config is
	// enabled or disabled.
	FilterEnforcement SdpBasicConfig_SdpBasicConfigEnforcement `protobuf:"varint,3,opt,name=filter_enforcement,json=filterEnforcement,proto3,enum=google.cloud.modelarmor.v1.SdpBasicConfig_SdpBasicConfigEnforcement" json:"filter_enforcement,omitempty"`
}

func (x *SdpBasicConfig) Reset() {
	*x = SdpBasicConfig{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SdpBasicConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdpBasicConfig) ProtoMessage() {}

func (x *SdpBasicConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdpBasicConfig.ProtoReflect.Descriptor instead.
func (*SdpBasicConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{15}
}

func (x *SdpBasicConfig) GetFilterEnforcement() SdpBasicConfig_SdpBasicConfigEnforcement {
	if x != nil {
		return x.FilterEnforcement
	}
	return SdpBasicConfig_SDP_BASIC_CONFIG_ENFORCEMENT_UNSPECIFIED
}

// Sensitive Data Protection Advanced configuration.
type SdpAdvancedConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Sensitive Data Protection inspect template resource name
	//
	// If only inspect template is provided (de-identify template not provided),
	// then Sensitive Data Protection InspectContent action is performed during
	// Sanitization. All Sensitive Data Protection findings identified during
	// inspection will be returned as SdpFinding in SdpInsepctionResult.
	//
	//	e.g.
	//
	// `projects/{project}/locations/{location}/inspectTemplates/{inspect_template}`
	InspectTemplate string `protobuf:"bytes,1,opt,name=inspect_template,json=inspectTemplate,proto3" json:"inspect_template,omitempty"`
	// Optional. Optional Sensitive Data Protection Deidentify template resource
	// name.
	//
	// If provided then DeidentifyContent action is performed during Sanitization
	// using this template and inspect template. The De-identified data will
	// be returned in SdpDeidentifyResult.
	// Note that all info-types present in the deidentify template must be present
	// in inspect template.
	//
	// e.g.
	// `projects/{project}/locations/{location}/deidentifyTemplates/{deidentify_template}`
	DeidentifyTemplate string `protobuf:"bytes,2,opt,name=deidentify_template,json=deidentifyTemplate,proto3" json:"deidentify_template,omitempty"`
}

func (x *SdpAdvancedConfig) Reset() {
	*x = SdpAdvancedConfig{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SdpAdvancedConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdpAdvancedConfig) ProtoMessage() {}

func (x *SdpAdvancedConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdpAdvancedConfig.ProtoReflect.Descriptor instead.
func (*SdpAdvancedConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{16}
}

func (x *SdpAdvancedConfig) GetInspectTemplate() string {
	if x != nil {
		return x.InspectTemplate
	}
	return ""
}

func (x *SdpAdvancedConfig) GetDeidentifyTemplate() string {
	if x != nil {
		return x.DeidentifyTemplate
	}
	return ""
}

// Sanitize User Prompt request.
type SanitizeUserPromptRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Represents resource name of template
	// e.g. name=projects/sample-project/locations/us-central1/templates/templ01
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. User prompt data to sanitize.
	UserPromptData *DataItem `protobuf:"bytes,2,opt,name=user_prompt_data,json=userPromptData,proto3" json:"user_prompt_data,omitempty"`
}

func (x *SanitizeUserPromptRequest) Reset() {
	*x = SanitizeUserPromptRequest{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SanitizeUserPromptRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SanitizeUserPromptRequest) ProtoMessage() {}

func (x *SanitizeUserPromptRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SanitizeUserPromptRequest.ProtoReflect.Descriptor instead.
func (*SanitizeUserPromptRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{17}
}

func (x *SanitizeUserPromptRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SanitizeUserPromptRequest) GetUserPromptData() *DataItem {
	if x != nil {
		return x.UserPromptData
	}
	return nil
}

// Sanitize Model Response request.
type SanitizeModelResponseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Represents resource name of template
	// e.g. name=projects/sample-project/locations/us-central1/templates/templ01
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Model response data to sanitize.
	ModelResponseData *DataItem `protobuf:"bytes,2,opt,name=model_response_data,json=modelResponseData,proto3" json:"model_response_data,omitempty"`
	// Optional. User Prompt associated with Model response.
	UserPrompt string `protobuf:"bytes,4,opt,name=user_prompt,json=userPrompt,proto3" json:"user_prompt,omitempty"`
}

func (x *SanitizeModelResponseRequest) Reset() {
	*x = SanitizeModelResponseRequest{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SanitizeModelResponseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SanitizeModelResponseRequest) ProtoMessage() {}

func (x *SanitizeModelResponseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SanitizeModelResponseRequest.ProtoReflect.Descriptor instead.
func (*SanitizeModelResponseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{18}
}

func (x *SanitizeModelResponseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SanitizeModelResponseRequest) GetModelResponseData() *DataItem {
	if x != nil {
		return x.ModelResponseData
	}
	return nil
}

func (x *SanitizeModelResponseRequest) GetUserPrompt() string {
	if x != nil {
		return x.UserPrompt
	}
	return ""
}

// Sanitized User Prompt Response.
type SanitizeUserPromptResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Sanitization Result.
	SanitizationResult *SanitizationResult `protobuf:"bytes,1,opt,name=sanitization_result,json=sanitizationResult,proto3" json:"sanitization_result,omitempty"`
}

func (x *SanitizeUserPromptResponse) Reset() {
	*x = SanitizeUserPromptResponse{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SanitizeUserPromptResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SanitizeUserPromptResponse) ProtoMessage() {}

func (x *SanitizeUserPromptResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SanitizeUserPromptResponse.ProtoReflect.Descriptor instead.
func (*SanitizeUserPromptResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{19}
}

func (x *SanitizeUserPromptResponse) GetSanitizationResult() *SanitizationResult {
	if x != nil {
		return x.SanitizationResult
	}
	return nil
}

// Sanitized Model Response Response.
type SanitizeModelResponseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Sanitization Result.
	SanitizationResult *SanitizationResult `protobuf:"bytes,1,opt,name=sanitization_result,json=sanitizationResult,proto3" json:"sanitization_result,omitempty"`
}

func (x *SanitizeModelResponseResponse) Reset() {
	*x = SanitizeModelResponseResponse{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SanitizeModelResponseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SanitizeModelResponseResponse) ProtoMessage() {}

func (x *SanitizeModelResponseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SanitizeModelResponseResponse.ProtoReflect.Descriptor instead.
func (*SanitizeModelResponseResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{20}
}

func (x *SanitizeModelResponseResponse) GetSanitizationResult() *SanitizationResult {
	if x != nil {
		return x.SanitizationResult
	}
	return nil
}

// Sanitization result after applying all the filters on input content.
type SanitizationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Overall filter match state for Sanitization.
	// The state can have below two values.
	//
	// 1) NO_MATCH_FOUND: No filters in configuration satisfy matching criteria.
	// In other words, input passed all filters.
	//
	// 2) MATCH_FOUND: At least one filter in configuration satisfies matching.
	// In other words, input did not pass one or more filters.
	FilterMatchState FilterMatchState `protobuf:"varint,1,opt,name=filter_match_state,json=filterMatchState,proto3,enum=google.cloud.modelarmor.v1.FilterMatchState" json:"filter_match_state,omitempty"`
	// Output only. Results for all filters where the key is the filter name -
	// either of "csam", "malicious_uris", "rai", "pi_and_jailbreak" ,"sdp".
	FilterResults map[string]*FilterResult `protobuf:"bytes,2,rep,name=filter_results,json=filterResults,proto3" json:"filter_results,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. A field indicating the outcome of the invocation, irrespective
	// of match status. It can have the following three values: SUCCESS: All
	// filters were executed successfully. PARTIAL: Some filters were skipped or
	// failed execution. FAILURE: All filters were skipped or failed execution.
	InvocationResult InvocationResult `protobuf:"varint,4,opt,name=invocation_result,json=invocationResult,proto3,enum=google.cloud.modelarmor.v1.InvocationResult" json:"invocation_result,omitempty"`
	// Output only. Metadata related to Sanitization.
	SanitizationMetadata *SanitizationResult_SanitizationMetadata `protobuf:"bytes,3,opt,name=sanitization_metadata,json=sanitizationMetadata,proto3" json:"sanitization_metadata,omitempty"`
}

func (x *SanitizationResult) Reset() {
	*x = SanitizationResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SanitizationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SanitizationResult) ProtoMessage() {}

func (x *SanitizationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SanitizationResult.ProtoReflect.Descriptor instead.
func (*SanitizationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{21}
}

func (x *SanitizationResult) GetFilterMatchState() FilterMatchState {
	if x != nil {
		return x.FilterMatchState
	}
	return FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED
}

func (x *SanitizationResult) GetFilterResults() map[string]*FilterResult {
	if x != nil {
		return x.FilterResults
	}
	return nil
}

func (x *SanitizationResult) GetInvocationResult() InvocationResult {
	if x != nil {
		return x.InvocationResult
	}
	return InvocationResult_INVOCATION_RESULT_UNSPECIFIED
}

func (x *SanitizationResult) GetSanitizationMetadata() *SanitizationResult_SanitizationMetadata {
	if x != nil {
		return x.SanitizationMetadata
	}
	return nil
}

// Filter Result obtained after Sanitization operations.
type FilterResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Encapsulates one of responsible AI, Sensitive Data Protection, Prompt
	// Injection and Jailbreak, Malicious URI, CSAM, Virus Scan related filter
	// results.
	//
	// Types that are assignable to FilterResult:
	//
	//	*FilterResult_RaiFilterResult
	//	*FilterResult_SdpFilterResult
	//	*FilterResult_PiAndJailbreakFilterResult
	//	*FilterResult_MaliciousUriFilterResult
	//	*FilterResult_CsamFilterFilterResult
	//	*FilterResult_VirusScanFilterResult
	FilterResult isFilterResult_FilterResult `protobuf_oneof:"filter_result"`
}

func (x *FilterResult) Reset() {
	*x = FilterResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilterResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterResult) ProtoMessage() {}

func (x *FilterResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterResult.ProtoReflect.Descriptor instead.
func (*FilterResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{22}
}

func (m *FilterResult) GetFilterResult() isFilterResult_FilterResult {
	if m != nil {
		return m.FilterResult
	}
	return nil
}

func (x *FilterResult) GetRaiFilterResult() *RaiFilterResult {
	if x, ok := x.GetFilterResult().(*FilterResult_RaiFilterResult); ok {
		return x.RaiFilterResult
	}
	return nil
}

func (x *FilterResult) GetSdpFilterResult() *SdpFilterResult {
	if x, ok := x.GetFilterResult().(*FilterResult_SdpFilterResult); ok {
		return x.SdpFilterResult
	}
	return nil
}

func (x *FilterResult) GetPiAndJailbreakFilterResult() *PiAndJailbreakFilterResult {
	if x, ok := x.GetFilterResult().(*FilterResult_PiAndJailbreakFilterResult); ok {
		return x.PiAndJailbreakFilterResult
	}
	return nil
}

func (x *FilterResult) GetMaliciousUriFilterResult() *MaliciousUriFilterResult {
	if x, ok := x.GetFilterResult().(*FilterResult_MaliciousUriFilterResult); ok {
		return x.MaliciousUriFilterResult
	}
	return nil
}

func (x *FilterResult) GetCsamFilterFilterResult() *CsamFilterResult {
	if x, ok := x.GetFilterResult().(*FilterResult_CsamFilterFilterResult); ok {
		return x.CsamFilterFilterResult
	}
	return nil
}

func (x *FilterResult) GetVirusScanFilterResult() *VirusScanFilterResult {
	if x, ok := x.GetFilterResult().(*FilterResult_VirusScanFilterResult); ok {
		return x.VirusScanFilterResult
	}
	return nil
}

type isFilterResult_FilterResult interface {
	isFilterResult_FilterResult()
}

type FilterResult_RaiFilterResult struct {
	// Responsible AI filter results.
	RaiFilterResult *RaiFilterResult `protobuf:"bytes,1,opt,name=rai_filter_result,json=raiFilterResult,proto3,oneof"`
}

type FilterResult_SdpFilterResult struct {
	// Sensitive Data Protection results.
	SdpFilterResult *SdpFilterResult `protobuf:"bytes,2,opt,name=sdp_filter_result,json=sdpFilterResult,proto3,oneof"`
}

type FilterResult_PiAndJailbreakFilterResult struct {
	// Prompt injection and Jailbreak filter results.
	PiAndJailbreakFilterResult *PiAndJailbreakFilterResult `protobuf:"bytes,3,opt,name=pi_and_jailbreak_filter_result,json=piAndJailbreakFilterResult,proto3,oneof"`
}

type FilterResult_MaliciousUriFilterResult struct {
	// Malicious URI filter results.
	MaliciousUriFilterResult *MaliciousUriFilterResult `protobuf:"bytes,4,opt,name=malicious_uri_filter_result,json=maliciousUriFilterResult,proto3,oneof"`
}

type FilterResult_CsamFilterFilterResult struct {
	// CSAM filter results.
	CsamFilterFilterResult *CsamFilterResult `protobuf:"bytes,5,opt,name=csam_filter_filter_result,json=csamFilterFilterResult,proto3,oneof"`
}

type FilterResult_VirusScanFilterResult struct {
	// Virus scan results.
	VirusScanFilterResult *VirusScanFilterResult `protobuf:"bytes,6,opt,name=virus_scan_filter_result,json=virusScanFilterResult,proto3,oneof"`
}

func (*FilterResult_RaiFilterResult) isFilterResult_FilterResult() {}

func (*FilterResult_SdpFilterResult) isFilterResult_FilterResult() {}

func (*FilterResult_PiAndJailbreakFilterResult) isFilterResult_FilterResult() {}

func (*FilterResult_MaliciousUriFilterResult) isFilterResult_FilterResult() {}

func (*FilterResult_CsamFilterFilterResult) isFilterResult_FilterResult() {}

func (*FilterResult_VirusScanFilterResult) isFilterResult_FilterResult() {}

// Responsible AI Result.
type RaiFilterResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Reports whether the RAI filter was successfully executed or
	// not.
	ExecutionState FilterExecutionState `protobuf:"varint,1,opt,name=execution_state,json=executionState,proto3,enum=google.cloud.modelarmor.v1.FilterExecutionState" json:"execution_state,omitempty"`
	// Optional messages corresponding to the result.
	// A message can provide warnings or error details.
	// For example, if execution state is skipped then this field provides
	// related reason/explanation.
	MessageItems []*MessageItem `protobuf:"bytes,2,rep,name=message_items,json=messageItems,proto3" json:"message_items,omitempty"`
	// Output only. Overall filter match state for RAI.
	// Value is MATCH_FOUND if at least one RAI filter confidence level is
	// equal to or higher than the confidence level defined in configuration.
	MatchState FilterMatchState `protobuf:"varint,3,opt,name=match_state,json=matchState,proto3,enum=google.cloud.modelarmor.v1.FilterMatchState" json:"match_state,omitempty"`
	// The map of RAI filter results where key is RAI filter type - either of
	// "sexually_explicit", "hate_speech", "harassment", "dangerous".
	RaiFilterTypeResults map[string]*RaiFilterResult_RaiFilterTypeResult `protobuf:"bytes,4,rep,name=rai_filter_type_results,json=raiFilterTypeResults,proto3" json:"rai_filter_type_results,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RaiFilterResult) Reset() {
	*x = RaiFilterResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaiFilterResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaiFilterResult) ProtoMessage() {}

func (x *RaiFilterResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaiFilterResult.ProtoReflect.Descriptor instead.
func (*RaiFilterResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{23}
}

func (x *RaiFilterResult) GetExecutionState() FilterExecutionState {
	if x != nil {
		return x.ExecutionState
	}
	return FilterExecutionState_FILTER_EXECUTION_STATE_UNSPECIFIED
}

func (x *RaiFilterResult) GetMessageItems() []*MessageItem {
	if x != nil {
		return x.MessageItems
	}
	return nil
}

func (x *RaiFilterResult) GetMatchState() FilterMatchState {
	if x != nil {
		return x.MatchState
	}
	return FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED
}

func (x *RaiFilterResult) GetRaiFilterTypeResults() map[string]*RaiFilterResult_RaiFilterTypeResult {
	if x != nil {
		return x.RaiFilterTypeResults
	}
	return nil
}

// Sensitive Data Protection filter result.
type SdpFilterResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Either of Sensitive Data Protection Inspect result or Deidentify result.
	//
	// Types that are assignable to Result:
	//
	//	*SdpFilterResult_InspectResult
	//	*SdpFilterResult_DeidentifyResult
	Result isSdpFilterResult_Result `protobuf_oneof:"result"`
}

func (x *SdpFilterResult) Reset() {
	*x = SdpFilterResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SdpFilterResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdpFilterResult) ProtoMessage() {}

func (x *SdpFilterResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdpFilterResult.ProtoReflect.Descriptor instead.
func (*SdpFilterResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{24}
}

func (m *SdpFilterResult) GetResult() isSdpFilterResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *SdpFilterResult) GetInspectResult() *SdpInspectResult {
	if x, ok := x.GetResult().(*SdpFilterResult_InspectResult); ok {
		return x.InspectResult
	}
	return nil
}

func (x *SdpFilterResult) GetDeidentifyResult() *SdpDeidentifyResult {
	if x, ok := x.GetResult().(*SdpFilterResult_DeidentifyResult); ok {
		return x.DeidentifyResult
	}
	return nil
}

type isSdpFilterResult_Result interface {
	isSdpFilterResult_Result()
}

type SdpFilterResult_InspectResult struct {
	// Sensitive Data Protection Inspection result if inspection is performed.
	InspectResult *SdpInspectResult `protobuf:"bytes,1,opt,name=inspect_result,json=inspectResult,proto3,oneof"`
}

type SdpFilterResult_DeidentifyResult struct {
	// Sensitive Data Protection Deidentification result if deidentification is
	// performed.
	DeidentifyResult *SdpDeidentifyResult `protobuf:"bytes,2,opt,name=deidentify_result,json=deidentifyResult,proto3,oneof"`
}

func (*SdpFilterResult_InspectResult) isSdpFilterResult_Result() {}

func (*SdpFilterResult_DeidentifyResult) isSdpFilterResult_Result() {}

// Sensitive Data Protection Inspection Result.
type SdpInspectResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Reports whether Sensitive Data Protection inspection was
	// successfully executed or not.
	ExecutionState FilterExecutionState `protobuf:"varint,1,opt,name=execution_state,json=executionState,proto3,enum=google.cloud.modelarmor.v1.FilterExecutionState" json:"execution_state,omitempty"`
	// Optional messages corresponding to the result.
	// A message can provide warnings or error details.
	// For example, if execution state is skipped then this field provides
	// related reason/explanation.
	MessageItems []*MessageItem `protobuf:"bytes,2,rep,name=message_items,json=messageItems,proto3" json:"message_items,omitempty"`
	// Output only. Match state for SDP Inspection.
	// Value is MATCH_FOUND if at least one Sensitive Data Protection finding is
	// identified.
	MatchState FilterMatchState `protobuf:"varint,3,opt,name=match_state,json=matchState,proto3,enum=google.cloud.modelarmor.v1.FilterMatchState" json:"match_state,omitempty"`
	// List of Sensitive Data Protection findings.
	Findings []*SdpFinding `protobuf:"bytes,4,rep,name=findings,proto3" json:"findings,omitempty"`
	// If true, then there is possibility that more findings were identified and
	// the findings returned are a subset of all findings. The findings
	// list might be truncated because the input items were too large, or because
	// the server reached the maximum amount of resources allowed for a single API
	// call.
	FindingsTruncated bool `protobuf:"varint,5,opt,name=findings_truncated,json=findingsTruncated,proto3" json:"findings_truncated,omitempty"`
}

func (x *SdpInspectResult) Reset() {
	*x = SdpInspectResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SdpInspectResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdpInspectResult) ProtoMessage() {}

func (x *SdpInspectResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdpInspectResult.ProtoReflect.Descriptor instead.
func (*SdpInspectResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{25}
}

func (x *SdpInspectResult) GetExecutionState() FilterExecutionState {
	if x != nil {
		return x.ExecutionState
	}
	return FilterExecutionState_FILTER_EXECUTION_STATE_UNSPECIFIED
}

func (x *SdpInspectResult) GetMessageItems() []*MessageItem {
	if x != nil {
		return x.MessageItems
	}
	return nil
}

func (x *SdpInspectResult) GetMatchState() FilterMatchState {
	if x != nil {
		return x.MatchState
	}
	return FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED
}

func (x *SdpInspectResult) GetFindings() []*SdpFinding {
	if x != nil {
		return x.Findings
	}
	return nil
}

func (x *SdpInspectResult) GetFindingsTruncated() bool {
	if x != nil {
		return x.FindingsTruncated
	}
	return false
}

// Represents Data item
type DataItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Either of text or bytes data.
	//
	// Types that are assignable to DataItem:
	//
	//	*DataItem_Text
	//	*DataItem_ByteItem
	DataItem isDataItem_DataItem `protobuf_oneof:"data_item"`
}

func (x *DataItem) Reset() {
	*x = DataItem{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataItem) ProtoMessage() {}

func (x *DataItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataItem.ProtoReflect.Descriptor instead.
func (*DataItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{26}
}

func (m *DataItem) GetDataItem() isDataItem_DataItem {
	if m != nil {
		return m.DataItem
	}
	return nil
}

func (x *DataItem) GetText() string {
	if x, ok := x.GetDataItem().(*DataItem_Text); ok {
		return x.Text
	}
	return ""
}

func (x *DataItem) GetByteItem() *ByteDataItem {
	if x, ok := x.GetDataItem().(*DataItem_ByteItem); ok {
		return x.ByteItem
	}
	return nil
}

type isDataItem_DataItem interface {
	isDataItem_DataItem()
}

type DataItem_Text struct {
	// Plaintext string data for sanitization.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type DataItem_ByteItem struct {
	// Data provided in the form of bytes.
	ByteItem *ByteDataItem `protobuf:"bytes,2,opt,name=byte_item,json=byteItem,proto3,oneof"`
}

func (*DataItem_Text) isDataItem_DataItem() {}

func (*DataItem_ByteItem) isDataItem_DataItem() {}

// Represents Byte Data item.
type ByteDataItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of byte data
	ByteDataType ByteDataItem_ByteItemType `protobuf:"varint,1,opt,name=byte_data_type,json=byteDataType,proto3,enum=google.cloud.modelarmor.v1.ByteDataItem_ByteItemType" json:"byte_data_type,omitempty"`
	// Required. Bytes Data
	ByteData []byte `protobuf:"bytes,2,opt,name=byte_data,json=byteData,proto3" json:"byte_data,omitempty"`
}

func (x *ByteDataItem) Reset() {
	*x = ByteDataItem{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ByteDataItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ByteDataItem) ProtoMessage() {}

func (x *ByteDataItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ByteDataItem.ProtoReflect.Descriptor instead.
func (*ByteDataItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{27}
}

func (x *ByteDataItem) GetByteDataType() ByteDataItem_ByteItemType {
	if x != nil {
		return x.ByteDataType
	}
	return ByteDataItem_BYTE_ITEM_TYPE_UNSPECIFIED
}

func (x *ByteDataItem) GetByteData() []byte {
	if x != nil {
		return x.ByteData
	}
	return nil
}

// Sensitive Data Protection Deidentification Result.
type SdpDeidentifyResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Reports whether Sensitive Data Protection deidentification was
	// successfully executed or not.
	ExecutionState FilterExecutionState `protobuf:"varint,1,opt,name=execution_state,json=executionState,proto3,enum=google.cloud.modelarmor.v1.FilterExecutionState" json:"execution_state,omitempty"`
	// Optional messages corresponding to the result.
	// A message can provide warnings or error details.
	// For example, if execution state is skipped then this field provides
	// related reason/explanation.
	MessageItems []*MessageItem `protobuf:"bytes,2,rep,name=message_items,json=messageItems,proto3" json:"message_items,omitempty"`
	// Output only. Match state for Sensitive Data Protection Deidentification.
	// Value is MATCH_FOUND if content is de-identified.
	MatchState FilterMatchState `protobuf:"varint,3,opt,name=match_state,json=matchState,proto3,enum=google.cloud.modelarmor.v1.FilterMatchState" json:"match_state,omitempty"`
	// De-identified data.
	Data *DataItem `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	// Total size in bytes that were transformed during deidentification.
	TransformedBytes int64 `protobuf:"varint,5,opt,name=transformed_bytes,json=transformedBytes,proto3" json:"transformed_bytes,omitempty"`
	// List of Sensitive Data Protection info-types that were de-identified.
	InfoTypes []string `protobuf:"bytes,6,rep,name=info_types,json=infoTypes,proto3" json:"info_types,omitempty"`
}

func (x *SdpDeidentifyResult) Reset() {
	*x = SdpDeidentifyResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SdpDeidentifyResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdpDeidentifyResult) ProtoMessage() {}

func (x *SdpDeidentifyResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdpDeidentifyResult.ProtoReflect.Descriptor instead.
func (*SdpDeidentifyResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{28}
}

func (x *SdpDeidentifyResult) GetExecutionState() FilterExecutionState {
	if x != nil {
		return x.ExecutionState
	}
	return FilterExecutionState_FILTER_EXECUTION_STATE_UNSPECIFIED
}

func (x *SdpDeidentifyResult) GetMessageItems() []*MessageItem {
	if x != nil {
		return x.MessageItems
	}
	return nil
}

func (x *SdpDeidentifyResult) GetMatchState() FilterMatchState {
	if x != nil {
		return x.MatchState
	}
	return FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED
}

func (x *SdpDeidentifyResult) GetData() *DataItem {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *SdpDeidentifyResult) GetTransformedBytes() int64 {
	if x != nil {
		return x.TransformedBytes
	}
	return 0
}

func (x *SdpDeidentifyResult) GetInfoTypes() []string {
	if x != nil {
		return x.InfoTypes
	}
	return nil
}

// Finding corresponding to Sensitive Data Protection filter.
type SdpFinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of Sensitive Data Protection info type for this finding.
	InfoType string `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Identified confidence likelihood for `info_type`.
	Likelihood SdpFindingLikelihood `protobuf:"varint,2,opt,name=likelihood,proto3,enum=google.cloud.modelarmor.v1.SdpFindingLikelihood" json:"likelihood,omitempty"`
	// Location for this finding.
	Location *SdpFinding_SdpFindingLocation `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *SdpFinding) Reset() {
	*x = SdpFinding{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SdpFinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdpFinding) ProtoMessage() {}

func (x *SdpFinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdpFinding.ProtoReflect.Descriptor instead.
func (*SdpFinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{29}
}

func (x *SdpFinding) GetInfoType() string {
	if x != nil {
		return x.InfoType
	}
	return ""
}

func (x *SdpFinding) GetLikelihood() SdpFindingLikelihood {
	if x != nil {
		return x.Likelihood
	}
	return SdpFindingLikelihood_SDP_FINDING_LIKELIHOOD_UNSPECIFIED
}

func (x *SdpFinding) GetLocation() *SdpFinding_SdpFindingLocation {
	if x != nil {
		return x.Location
	}
	return nil
}

// Prompt injection and Jailbreak Filter Result.
type PiAndJailbreakFilterResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Reports whether Prompt injection and Jailbreak filter was
	// successfully executed or not.
	ExecutionState FilterExecutionState `protobuf:"varint,1,opt,name=execution_state,json=executionState,proto3,enum=google.cloud.modelarmor.v1.FilterExecutionState" json:"execution_state,omitempty"`
	// Optional messages corresponding to the result.
	// A message can provide warnings or error details.
	// For example, if execution state is skipped then this field provides
	// related reason/explanation.
	MessageItems []*MessageItem `protobuf:"bytes,2,rep,name=message_items,json=messageItems,proto3" json:"message_items,omitempty"`
	// Output only. Match state for Prompt injection and Jailbreak.
	MatchState FilterMatchState `protobuf:"varint,3,opt,name=match_state,json=matchState,proto3,enum=google.cloud.modelarmor.v1.FilterMatchState" json:"match_state,omitempty"`
	// Confidence level identified for Prompt injection and Jailbreak.
	ConfidenceLevel DetectionConfidenceLevel `protobuf:"varint,5,opt,name=confidence_level,json=confidenceLevel,proto3,enum=google.cloud.modelarmor.v1.DetectionConfidenceLevel" json:"confidence_level,omitempty"`
}

func (x *PiAndJailbreakFilterResult) Reset() {
	*x = PiAndJailbreakFilterResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PiAndJailbreakFilterResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PiAndJailbreakFilterResult) ProtoMessage() {}

func (x *PiAndJailbreakFilterResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PiAndJailbreakFilterResult.ProtoReflect.Descriptor instead.
func (*PiAndJailbreakFilterResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{30}
}

func (x *PiAndJailbreakFilterResult) GetExecutionState() FilterExecutionState {
	if x != nil {
		return x.ExecutionState
	}
	return FilterExecutionState_FILTER_EXECUTION_STATE_UNSPECIFIED
}

func (x *PiAndJailbreakFilterResult) GetMessageItems() []*MessageItem {
	if x != nil {
		return x.MessageItems
	}
	return nil
}

func (x *PiAndJailbreakFilterResult) GetMatchState() FilterMatchState {
	if x != nil {
		return x.MatchState
	}
	return FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED
}

func (x *PiAndJailbreakFilterResult) GetConfidenceLevel() DetectionConfidenceLevel {
	if x != nil {
		return x.ConfidenceLevel
	}
	return DetectionConfidenceLevel_DETECTION_CONFIDENCE_LEVEL_UNSPECIFIED
}

// Malicious URI Filter Result.
type MaliciousUriFilterResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Reports whether Malicious URI filter was successfully executed
	// or not.
	ExecutionState FilterExecutionState `protobuf:"varint,1,opt,name=execution_state,json=executionState,proto3,enum=google.cloud.modelarmor.v1.FilterExecutionState" json:"execution_state,omitempty"`
	// Optional messages corresponding to the result.
	// A message can provide warnings or error details.
	// For example, if execution state is skipped then this field provides
	// related reason/explanation.
	MessageItems []*MessageItem `protobuf:"bytes,2,rep,name=message_items,json=messageItems,proto3" json:"message_items,omitempty"`
	// Output only. Match state for this Malicious URI.
	// Value is MATCH_FOUND if at least one Malicious URI is found.
	MatchState FilterMatchState `protobuf:"varint,3,opt,name=match_state,json=matchState,proto3,enum=google.cloud.modelarmor.v1.FilterMatchState" json:"match_state,omitempty"`
	// List of Malicious URIs found in data.
	MaliciousUriMatchedItems []*MaliciousUriFilterResult_MaliciousUriMatchedItem `protobuf:"bytes,4,rep,name=malicious_uri_matched_items,json=maliciousUriMatchedItems,proto3" json:"malicious_uri_matched_items,omitempty"`
}

func (x *MaliciousUriFilterResult) Reset() {
	*x = MaliciousUriFilterResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaliciousUriFilterResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaliciousUriFilterResult) ProtoMessage() {}

func (x *MaliciousUriFilterResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaliciousUriFilterResult.ProtoReflect.Descriptor instead.
func (*MaliciousUriFilterResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{31}
}

func (x *MaliciousUriFilterResult) GetExecutionState() FilterExecutionState {
	if x != nil {
		return x.ExecutionState
	}
	return FilterExecutionState_FILTER_EXECUTION_STATE_UNSPECIFIED
}

func (x *MaliciousUriFilterResult) GetMessageItems() []*MessageItem {
	if x != nil {
		return x.MessageItems
	}
	return nil
}

func (x *MaliciousUriFilterResult) GetMatchState() FilterMatchState {
	if x != nil {
		return x.MatchState
	}
	return FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED
}

func (x *MaliciousUriFilterResult) GetMaliciousUriMatchedItems() []*MaliciousUriFilterResult_MaliciousUriMatchedItem {
	if x != nil {
		return x.MaliciousUriMatchedItems
	}
	return nil
}

// Virus scan results.
type VirusScanFilterResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Reports whether Virus Scan was successfully executed or not.
	ExecutionState FilterExecutionState `protobuf:"varint,1,opt,name=execution_state,json=executionState,proto3,enum=google.cloud.modelarmor.v1.FilterExecutionState" json:"execution_state,omitempty"`
	// Optional messages corresponding to the result.
	// A message can provide warnings or error details.
	// For example, if execution status is skipped then this field provides
	// related reason/explanation.
	MessageItems []*MessageItem `protobuf:"bytes,2,rep,name=message_items,json=messageItems,proto3" json:"message_items,omitempty"`
	// Output only. Match status for Virus.
	// Value is MATCH_FOUND if the data is infected with a virus.
	MatchState FilterMatchState `protobuf:"varint,3,opt,name=match_state,json=matchState,proto3,enum=google.cloud.modelarmor.v1.FilterMatchState" json:"match_state,omitempty"`
	// Type of content scanned.
	ScannedContentType VirusScanFilterResult_ScannedContentType `protobuf:"varint,4,opt,name=scanned_content_type,json=scannedContentType,proto3,enum=google.cloud.modelarmor.v1.VirusScanFilterResult_ScannedContentType" json:"scanned_content_type,omitempty"`
	// Size of scanned content in bytes.
	ScannedSize *int64 `protobuf:"varint,5,opt,name=scanned_size,json=scannedSize,proto3,oneof" json:"scanned_size,omitempty"`
	// List of Viruses identified.
	// This field will be empty if no virus was detected.
	VirusDetails []*VirusDetail `protobuf:"bytes,6,rep,name=virus_details,json=virusDetails,proto3" json:"virus_details,omitempty"`
}

func (x *VirusScanFilterResult) Reset() {
	*x = VirusScanFilterResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VirusScanFilterResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirusScanFilterResult) ProtoMessage() {}

func (x *VirusScanFilterResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirusScanFilterResult.ProtoReflect.Descriptor instead.
func (*VirusScanFilterResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{32}
}

func (x *VirusScanFilterResult) GetExecutionState() FilterExecutionState {
	if x != nil {
		return x.ExecutionState
	}
	return FilterExecutionState_FILTER_EXECUTION_STATE_UNSPECIFIED
}

func (x *VirusScanFilterResult) GetMessageItems() []*MessageItem {
	if x != nil {
		return x.MessageItems
	}
	return nil
}

func (x *VirusScanFilterResult) GetMatchState() FilterMatchState {
	if x != nil {
		return x.MatchState
	}
	return FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED
}

func (x *VirusScanFilterResult) GetScannedContentType() VirusScanFilterResult_ScannedContentType {
	if x != nil {
		return x.ScannedContentType
	}
	return VirusScanFilterResult_SCANNED_CONTENT_TYPE_UNSPECIFIED
}

func (x *VirusScanFilterResult) GetScannedSize() int64 {
	if x != nil && x.ScannedSize != nil {
		return *x.ScannedSize
	}
	return 0
}

func (x *VirusScanFilterResult) GetVirusDetails() []*VirusDetail {
	if x != nil {
		return x.VirusDetails
	}
	return nil
}

// Details of an identified virus
type VirusDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of vendor that produced this virus identification.
	Vendor string `protobuf:"bytes,1,opt,name=vendor,proto3" json:"vendor,omitempty"`
	// Names of this Virus.
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
	// Threat type of the identified virus
	ThreatType VirusDetail_ThreatType `protobuf:"varint,3,opt,name=threat_type,json=threatType,proto3,enum=google.cloud.modelarmor.v1.VirusDetail_ThreatType" json:"threat_type,omitempty"`
}

func (x *VirusDetail) Reset() {
	*x = VirusDetail{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VirusDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VirusDetail) ProtoMessage() {}

func (x *VirusDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VirusDetail.ProtoReflect.Descriptor instead.
func (*VirusDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{33}
}

func (x *VirusDetail) GetVendor() string {
	if x != nil {
		return x.Vendor
	}
	return ""
}

func (x *VirusDetail) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

func (x *VirusDetail) GetThreatType() VirusDetail_ThreatType {
	if x != nil {
		return x.ThreatType
	}
	return VirusDetail_THREAT_TYPE_UNSPECIFIED
}

// CSAM (Child Safety Abuse Material) Filter Result
type CsamFilterResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Reports whether the CSAM filter was successfully executed or
	// not.
	ExecutionState FilterExecutionState `protobuf:"varint,1,opt,name=execution_state,json=executionState,proto3,enum=google.cloud.modelarmor.v1.FilterExecutionState" json:"execution_state,omitempty"`
	// Optional messages corresponding to the result.
	// A message can provide warnings or error details.
	// For example, if execution state is skipped then this field provides
	// related reason/explanation.
	MessageItems []*MessageItem `protobuf:"bytes,2,rep,name=message_items,json=messageItems,proto3" json:"message_items,omitempty"`
	// Output only. Match state for CSAM.
	MatchState FilterMatchState `protobuf:"varint,3,opt,name=match_state,json=matchState,proto3,enum=google.cloud.modelarmor.v1.FilterMatchState" json:"match_state,omitempty"`
}

func (x *CsamFilterResult) Reset() {
	*x = CsamFilterResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CsamFilterResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CsamFilterResult) ProtoMessage() {}

func (x *CsamFilterResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CsamFilterResult.ProtoReflect.Descriptor instead.
func (*CsamFilterResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{34}
}

func (x *CsamFilterResult) GetExecutionState() FilterExecutionState {
	if x != nil {
		return x.ExecutionState
	}
	return FilterExecutionState_FILTER_EXECUTION_STATE_UNSPECIFIED
}

func (x *CsamFilterResult) GetMessageItems() []*MessageItem {
	if x != nil {
		return x.MessageItems
	}
	return nil
}

func (x *CsamFilterResult) GetMatchState() FilterMatchState {
	if x != nil {
		return x.MatchState
	}
	return FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED
}

// Message item to report information, warning or error messages.
type MessageItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of message.
	MessageType MessageItem_MessageType `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=google.cloud.modelarmor.v1.MessageItem_MessageType" json:"message_type,omitempty"`
	// The message content.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *MessageItem) Reset() {
	*x = MessageItem{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageItem) ProtoMessage() {}

func (x *MessageItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageItem.ProtoReflect.Descriptor instead.
func (*MessageItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{35}
}

func (x *MessageItem) GetMessageType() MessageItem_MessageType {
	if x != nil {
		return x.MessageType
	}
	return MessageItem_MESSAGE_TYPE_UNSPECIFIED
}

func (x *MessageItem) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// Half-open range interval [start, end)
type RangeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// For proto3, value cannot be set to 0 unless the field is optional.
	// Ref: https://protobuf.dev/programming-guides/proto3/#default
	// Index of first character (inclusive).
	Start *int64 `protobuf:"varint,1,opt,name=start,proto3,oneof" json:"start,omitempty"`
	// Index of last character (exclusive).
	End *int64 `protobuf:"varint,2,opt,name=end,proto3,oneof" json:"end,omitempty"`
}

func (x *RangeInfo) Reset() {
	*x = RangeInfo{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RangeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RangeInfo) ProtoMessage() {}

func (x *RangeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RangeInfo.ProtoReflect.Descriptor instead.
func (*RangeInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{36}
}

func (x *RangeInfo) GetStart() int64 {
	if x != nil && x.Start != nil {
		return *x.Start
	}
	return 0
}

func (x *RangeInfo) GetEnd() int64 {
	if x != nil && x.End != nil {
		return *x.End
	}
	return 0
}

// Message describing TemplateMetadata
type Template_TemplateMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If true, partial detector failures should be ignored.
	IgnorePartialInvocationFailures bool `protobuf:"varint,1,opt,name=ignore_partial_invocation_failures,json=ignorePartialInvocationFailures,proto3" json:"ignore_partial_invocation_failures,omitempty"`
	// Optional. Indicates the custom error code set by the user to be returned
	// to the end user by the service extension if the prompt trips Model Armor
	// filters.
	CustomPromptSafetyErrorCode int32 `protobuf:"varint,2,opt,name=custom_prompt_safety_error_code,json=customPromptSafetyErrorCode,proto3" json:"custom_prompt_safety_error_code,omitempty"`
	// Optional. Indicates the custom error message set by the user to be
	// returned to the end user if the prompt trips Model Armor filters.
	CustomPromptSafetyErrorMessage string `protobuf:"bytes,3,opt,name=custom_prompt_safety_error_message,json=customPromptSafetyErrorMessage,proto3" json:"custom_prompt_safety_error_message,omitempty"`
	// Optional. Indicates the custom error code set by the user to be returned
	// to the end user if the LLM response trips Model Armor filters.
	CustomLlmResponseSafetyErrorCode int32 `protobuf:"varint,4,opt,name=custom_llm_response_safety_error_code,json=customLlmResponseSafetyErrorCode,proto3" json:"custom_llm_response_safety_error_code,omitempty"`
	// Optional. Indicates the custom error message set by the user to be
	// returned to the end user if the LLM response trips Model Armor filters.
	CustomLlmResponseSafetyErrorMessage string `protobuf:"bytes,5,opt,name=custom_llm_response_safety_error_message,json=customLlmResponseSafetyErrorMessage,proto3" json:"custom_llm_response_safety_error_message,omitempty"`
	// Optional. If true, log template crud operations.
	LogTemplateOperations bool `protobuf:"varint,6,opt,name=log_template_operations,json=logTemplateOperations,proto3" json:"log_template_operations,omitempty"`
	// Optional. If true, log sanitize operations.
	LogSanitizeOperations bool `protobuf:"varint,7,opt,name=log_sanitize_operations,json=logSanitizeOperations,proto3" json:"log_sanitize_operations,omitempty"`
}

func (x *Template_TemplateMetadata) Reset() {
	*x = Template_TemplateMetadata{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Template_TemplateMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Template_TemplateMetadata) ProtoMessage() {}

func (x *Template_TemplateMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Template_TemplateMetadata.ProtoReflect.Descriptor instead.
func (*Template_TemplateMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Template_TemplateMetadata) GetIgnorePartialInvocationFailures() bool {
	if x != nil {
		return x.IgnorePartialInvocationFailures
	}
	return false
}

func (x *Template_TemplateMetadata) GetCustomPromptSafetyErrorCode() int32 {
	if x != nil {
		return x.CustomPromptSafetyErrorCode
	}
	return 0
}

func (x *Template_TemplateMetadata) GetCustomPromptSafetyErrorMessage() string {
	if x != nil {
		return x.CustomPromptSafetyErrorMessage
	}
	return ""
}

func (x *Template_TemplateMetadata) GetCustomLlmResponseSafetyErrorCode() int32 {
	if x != nil {
		return x.CustomLlmResponseSafetyErrorCode
	}
	return 0
}

func (x *Template_TemplateMetadata) GetCustomLlmResponseSafetyErrorMessage() string {
	if x != nil {
		return x.CustomLlmResponseSafetyErrorMessage
	}
	return ""
}

func (x *Template_TemplateMetadata) GetLogTemplateOperations() bool {
	if x != nil {
		return x.LogTemplateOperations
	}
	return false
}

func (x *Template_TemplateMetadata) GetLogSanitizeOperations() bool {
	if x != nil {
		return x.LogSanitizeOperations
	}
	return false
}

// Responsible AI filter.
type RaiFilterSettings_RaiFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Type of responsible AI filter.
	FilterType RaiFilterType `protobuf:"varint,1,opt,name=filter_type,json=filterType,proto3,enum=google.cloud.modelarmor.v1.RaiFilterType" json:"filter_type,omitempty"`
	// Optional. Confidence level for this RAI filter.
	// During data sanitization, if data is classified under this filter with a
	// confidence level equal to or greater than the specified level, a positive
	// match is reported. If the confidence level is unspecified (i.e., 0), the
	// system will use a reasonable default level based on the `filter_type`.
	ConfidenceLevel DetectionConfidenceLevel `protobuf:"varint,2,opt,name=confidence_level,json=confidenceLevel,proto3,enum=google.cloud.modelarmor.v1.DetectionConfidenceLevel" json:"confidence_level,omitempty"`
}

func (x *RaiFilterSettings_RaiFilter) Reset() {
	*x = RaiFilterSettings_RaiFilter{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaiFilterSettings_RaiFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaiFilterSettings_RaiFilter) ProtoMessage() {}

func (x *RaiFilterSettings_RaiFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaiFilterSettings_RaiFilter.ProtoReflect.Descriptor instead.
func (*RaiFilterSettings_RaiFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{13, 0}
}

func (x *RaiFilterSettings_RaiFilter) GetFilterType() RaiFilterType {
	if x != nil {
		return x.FilterType
	}
	return RaiFilterType_RAI_FILTER_TYPE_UNSPECIFIED
}

func (x *RaiFilterSettings_RaiFilter) GetConfidenceLevel() DetectionConfidenceLevel {
	if x != nil {
		return x.ConfidenceLevel
	}
	return DetectionConfidenceLevel_DETECTION_CONFIDENCE_LEVEL_UNSPECIFIED
}

// Message describing Sanitization metadata.
type SanitizationResult_SanitizationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error code if any.
	ErrorCode int64 `protobuf:"varint,1,opt,name=error_code,json=errorCode,proto3" json:"error_code,omitempty"`
	// Error message if any.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *SanitizationResult_SanitizationMetadata) Reset() {
	*x = SanitizationResult_SanitizationMetadata{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SanitizationResult_SanitizationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SanitizationResult_SanitizationMetadata) ProtoMessage() {}

func (x *SanitizationResult_SanitizationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SanitizationResult_SanitizationMetadata.ProtoReflect.Descriptor instead.
func (*SanitizationResult_SanitizationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{21, 0}
}

func (x *SanitizationResult_SanitizationMetadata) GetErrorCode() int64 {
	if x != nil {
		return x.ErrorCode
	}
	return 0
}

func (x *SanitizationResult_SanitizationMetadata) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// Detailed Filter result for each of the responsible AI Filter Types.
type RaiFilterResult_RaiFilterTypeResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of responsible AI filter.
	FilterType RaiFilterType `protobuf:"varint,1,opt,name=filter_type,json=filterType,proto3,enum=google.cloud.modelarmor.v1.RaiFilterType" json:"filter_type,omitempty"`
	// Confidence level identified for this RAI filter.
	ConfidenceLevel DetectionConfidenceLevel `protobuf:"varint,2,opt,name=confidence_level,json=confidenceLevel,proto3,enum=google.cloud.modelarmor.v1.DetectionConfidenceLevel" json:"confidence_level,omitempty"`
	// Output only. Match state for this RAI filter.
	MatchState FilterMatchState `protobuf:"varint,3,opt,name=match_state,json=matchState,proto3,enum=google.cloud.modelarmor.v1.FilterMatchState" json:"match_state,omitempty"`
}

func (x *RaiFilterResult_RaiFilterTypeResult) Reset() {
	*x = RaiFilterResult_RaiFilterTypeResult{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaiFilterResult_RaiFilterTypeResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaiFilterResult_RaiFilterTypeResult) ProtoMessage() {}

func (x *RaiFilterResult_RaiFilterTypeResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaiFilterResult_RaiFilterTypeResult.ProtoReflect.Descriptor instead.
func (*RaiFilterResult_RaiFilterTypeResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{23, 0}
}

func (x *RaiFilterResult_RaiFilterTypeResult) GetFilterType() RaiFilterType {
	if x != nil {
		return x.FilterType
	}
	return RaiFilterType_RAI_FILTER_TYPE_UNSPECIFIED
}

func (x *RaiFilterResult_RaiFilterTypeResult) GetConfidenceLevel() DetectionConfidenceLevel {
	if x != nil {
		return x.ConfidenceLevel
	}
	return DetectionConfidenceLevel_DETECTION_CONFIDENCE_LEVEL_UNSPECIFIED
}

func (x *RaiFilterResult_RaiFilterTypeResult) GetMatchState() FilterMatchState {
	if x != nil {
		return x.MatchState
	}
	return FilterMatchState_FILTER_MATCH_STATE_UNSPECIFIED
}

// Location of this Sensitive Data Protection Finding within input content.
type SdpFinding_SdpFindingLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Zero-based byte offsets delimiting the finding.
	// These are relative to the finding's containing element.
	// Note that when the content is not textual, this references
	// the UTF-8 encoded textual representation of the content.
	ByteRange *RangeInfo `protobuf:"bytes,1,opt,name=byte_range,json=byteRange,proto3" json:"byte_range,omitempty"`
	// Unicode character offsets delimiting the finding.
	// These are relative to the finding's containing element.
	// Provided when the content is text.
	CodepointRange *RangeInfo `protobuf:"bytes,2,opt,name=codepoint_range,json=codepointRange,proto3" json:"codepoint_range,omitempty"`
}

func (x *SdpFinding_SdpFindingLocation) Reset() {
	*x = SdpFinding_SdpFindingLocation{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SdpFinding_SdpFindingLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SdpFinding_SdpFindingLocation) ProtoMessage() {}

func (x *SdpFinding_SdpFindingLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SdpFinding_SdpFindingLocation.ProtoReflect.Descriptor instead.
func (*SdpFinding_SdpFindingLocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{29, 0}
}

func (x *SdpFinding_SdpFindingLocation) GetByteRange() *RangeInfo {
	if x != nil {
		return x.ByteRange
	}
	return nil
}

func (x *SdpFinding_SdpFindingLocation) GetCodepointRange() *RangeInfo {
	if x != nil {
		return x.CodepointRange
	}
	return nil
}

// Information regarding malicious URI and its location within the input
// content.
type MaliciousUriFilterResult_MaliciousUriMatchedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Malicious URI.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// List of locations where Malicious URI is identified.
	// The `locations` field is supported only for plaintext content i.e.
	// ByteItemType.PLAINTEXT_UTF8
	Locations []*RangeInfo `protobuf:"bytes,2,rep,name=locations,proto3" json:"locations,omitempty"`
}

func (x *MaliciousUriFilterResult_MaliciousUriMatchedItem) Reset() {
	*x = MaliciousUriFilterResult_MaliciousUriMatchedItem{}
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaliciousUriFilterResult_MaliciousUriMatchedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaliciousUriFilterResult_MaliciousUriMatchedItem) ProtoMessage() {}

func (x *MaliciousUriFilterResult_MaliciousUriMatchedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_modelarmor_v1_service_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaliciousUriFilterResult_MaliciousUriMatchedItem.ProtoReflect.Descriptor instead.
func (*MaliciousUriFilterResult_MaliciousUriMatchedItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP(), []int{31, 0}
}

func (x *MaliciousUriFilterResult_MaliciousUriMatchedItem) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *MaliciousUriFilterResult_MaliciousUriMatchedItem) GetLocations() []*RangeInfo {
	if x != nil {
		return x.Locations
	}
	return nil
}

var File_google_cloud_modelarmor_v1_service_proto protoreflect.FileDescriptor

var file_google_cloud_modelarmor_v1_service_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72,
	0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x99, 0x09, 0x0a, 0x08, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x52, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x11, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0xac, 0x04, 0x0a,
	0x10, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x50, 0x0a, 0x22, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x1f, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61,
	0x6c, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x1f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x1b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x4f,
	0x0a, 0x22, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f,
	0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x1e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x53, 0x61, 0x66,
	0x65, 0x74, 0x79, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x54, 0x0a, 0x25, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x6c, 0x6d, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x20, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x6c, 0x6d, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x5a, 0x0a, 0x28, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6c, 0x6c, 0x6d, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x73, 0x61, 0x66,
	0x65, 0x74, 0x79, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x23, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4c, 0x6c, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x3b, 0x0a, 0x17, 0x6c, 0x6f, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x6c, 0x6f, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3b,
	0x0a, 0x17, 0x6c, 0x6f, 0x67, 0x5f, 0x73, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x5f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x6c, 0x6f, 0x67, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a,
	0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x7a, 0xea, 0x41, 0x77, 0x0a, 0x22, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x2a, 0x09, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x32, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x22, 0xed, 0x04, 0x0a, 0x0c, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x52, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x0a, 0x20, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66,
	0x6c, 0x6f, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x1d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6c, 0x6f,
	0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x3a, 0xf3, 0x01, 0xea, 0x41, 0xef, 0x01, 0x0a, 0x26,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x32, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x3e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x2a, 0x0d, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32,
	0x0c, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x23, 0x0a,
	0x21, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0xdd, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x24, 0x12, 0x22, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xa5, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x09,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x09, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x54, 0x0a, 0x12, 0x47, 0x65,
	0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d,
	0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xf4, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x12, 0x22, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x24,
	0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xcc, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x45, 0x0a, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b,
	0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x83, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d,
	0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x5c, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x19, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x0d, 0x66, 0x6c, 0x6f, 0x6f,
	0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6c, 0x6f,
	0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc4,
	0x03, 0x0a, 0x0c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x55, 0x0a, 0x0c, 0x72, 0x61, 0x69, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x61, 0x69, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x55, 0x0a, 0x0c, 0x73, 0x64, 0x70, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x64, 0x70, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x73, 0x64, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x85, 0x01,
	0x0a, 0x20, 0x70, 0x69, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x6a, 0x61, 0x69, 0x6c, 0x62, 0x72, 0x65,
	0x61, 0x6b, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x41, 0x6e, 0x64, 0x4a, 0x61, 0x69, 0x6c, 0x62,
	0x72, 0x65, 0x61, 0x6b, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x70, 0x69, 0x41, 0x6e, 0x64, 0x4a, 0x61,
	0x69, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x7e, 0x0a, 0x1d, 0x6d, 0x61, 0x6c, 0x69, 0x63, 0x69, 0x6f,
	0x75, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6c, 0x69, 0x63, 0x69,
	0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x6d, 0x61, 0x6c, 0x69, 0x63,
	0x69, 0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x86, 0x03, 0x0a, 0x1c, 0x50, 0x69, 0x41, 0x6e, 0x64, 0x4a,
	0x61, 0x69, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x8c, 0x01, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x5f, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x69, 0x41, 0x6e, 0x64, 0x4a, 0x61, 0x69, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x69,
	0x41, 0x6e, 0x64, 0x4a, 0x61, 0x69, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x11, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x64, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x71, 0x0a, 0x1f, 0x50,
	0x69, 0x41, 0x6e, 0x64, 0x4a, 0x61, 0x69, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x33,
	0x0a, 0x2f, 0x50, 0x49, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4a, 0x41, 0x49, 0x4c, 0x42, 0x52, 0x45,
	0x41, 0x4b, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43,
	0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0x95,
	0x02, 0x0a, 0x1a, 0x4d, 0x61, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x88, 0x01,
	0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61,
	0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75,
	0x73, 0x55, 0x72, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x4d, 0x61, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x6c, 0x0a, 0x1d, 0x4d, 0x61, 0x6c, 0x69,
	0x63, 0x69, 0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x6e,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x2c, 0x4d, 0x41, 0x4c,
	0x49, 0x43, 0x49, 0x4f, 0x55, 0x53, 0x5f, 0x55, 0x52, 0x49, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45,
	0x52, 0x5f, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45,
	0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0xb7, 0x02, 0x0a, 0x11, 0x52, 0x61, 0x69, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5d, 0x0a, 0x0b,
	0x72, 0x61, 0x69, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x72, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x1a, 0xc2, 0x01, 0x0a, 0x09,
	0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x4f, 0x0a, 0x0b, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x64, 0x0a, 0x10, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x22, 0xdd, 0x01, 0x0a, 0x11, 0x53, 0x64, 0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x54, 0x0a, 0x0c, 0x62, 0x61, 0x73, 0x69, 0x63, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x64, 0x70, 0x42, 0x61, 0x73,
	0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x0b, 0x62, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a, 0x0f,
	0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x64, 0x70, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x13, 0x0a, 0x11, 0x73,
	0x64, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xf0, 0x01, 0x0a, 0x0e, 0x53, 0x64, 0x70, 0x42, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x78, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x64, 0x70,
	0x42, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x64, 0x70, 0x42,
	0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x64, 0x0a,
	0x19, 0x53, 0x64, 0x70, 0x42, 0x61, 0x73, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45,
	0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x28, 0x53, 0x44,
	0x50, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x45,
	0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x44, 0x10, 0x02, 0x22, 0x79, 0x0a, 0x11, 0x53, 0x64, 0x70, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x13, 0x64, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x64, 0x65, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0xb0,
	0x01, 0x0a, 0x19, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x55, 0x73, 0x65, 0x72, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x10,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x22, 0xdf, 0x01, 0x0a, 0x1c, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61,
	0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x59, 0x0a, 0x13, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x24, 0x0a,
	0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x22, 0x82, 0x01, 0x0a, 0x1a, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x73, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x6e,
	0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x85, 0x01, 0x0a, 0x1d, 0x53, 0x61, 0x6e,
	0x69, 0x74, 0x69, 0x7a, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x73, 0x61,
	0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x61,
	0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0x8b, 0x05, 0x0a, 0x12, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5f, 0x0a, 0x12, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x6d, 0x0a, 0x0e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61,
	0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x5e, 0x0a, 0x11, 0x69, 0x6e, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7d, 0x0a, 0x15, 0x73, 0x61, 0x6e, 0x69, 0x74,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x14, 0x73, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x5a, 0x0a, 0x14, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1d,
	0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x1a, 0x6a, 0x0a, 0x12, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3e, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72,
	0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa3,
	0x05, 0x0a, 0x0c, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x59, 0x0a, 0x11, 0x72, 0x61, 0x69, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61,
	0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x61, 0x69, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x59, 0x0a, 0x11, 0x73, 0x64,
	0x70, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x64, 0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x64, 0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7c, 0x0a, 0x1e, 0x70, 0x69, 0x5f, 0x61, 0x6e, 0x64, 0x5f,
	0x6a, 0x61, 0x69, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x41, 0x6e, 0x64,
	0x4a, 0x61, 0x69, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1a, 0x70, 0x69, 0x41, 0x6e, 0x64, 0x4a, 0x61,
	0x69, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x75, 0x0a, 0x1b, 0x6d, 0x61, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73,
	0x5f, 0x75, 0x72, 0x69, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x55,
	0x72, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00,
	0x52, 0x18, 0x6d, 0x61, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x69, 0x0a, 0x19, 0x63, 0x73,
	0x61, 0x6d, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x73, 0x61, 0x6d, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x16, 0x63,
	0x73, 0x61, 0x6d, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x6c, 0x0a, 0x18, 0x76, 0x69, 0x72, 0x75, 0x73, 0x5f, 0x73,
	0x63, 0x61, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x75, 0x73, 0x53, 0x63, 0x61, 0x6e, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x15, 0x76, 0x69,
	0x72, 0x75, 0x73, 0x53, 0x63, 0x61, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x22, 0xb5, 0x06, 0x0a, 0x0f, 0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x7c, 0x0a, 0x17, 0x72, 0x61,
	0x69, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x14, 0x72, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x96, 0x02, 0x0a, 0x13, 0x52, 0x61, 0x69,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x4a, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0a, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5f, 0x0a, 0x10,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x52, 0x0a,
	0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x1a, 0x88, 0x01, 0x0a, 0x19, 0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x55, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61,
	0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x61,
	0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd2, 0x01, 0x0a,
	0x0f, 0x53, 0x64, 0x70, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x55, 0x0a, 0x0e, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x64, 0x70, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5e, 0x0a, 0x11, 0x64, 0x65, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x64, 0x70, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x10, 0x64, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x22, 0x87, 0x03, 0x0a, 0x10, 0x53, 0x64, 0x70, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49,
	0x74, 0x65, 0x6d, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72,
	0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x08, 0x66, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61,
	0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x64, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x08, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2d, 0x0a, 0x12,
	0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x22, 0x76, 0x0a, 0x08, 0x44,
	0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x47, 0x0a,
	0x09, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x79,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x48, 0x00, 0x52, 0x08, 0x62, 0x79,
	0x74, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x0b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69,
	0x74, 0x65, 0x6d, 0x22, 0xdf, 0x01, 0x0a, 0x0c, 0x42, 0x79, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x49, 0x74, 0x65, 0x6d, 0x12, 0x60, 0x0a, 0x0e, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x79, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x62, 0x79, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x22, 0x4b, 0x0a, 0x0c, 0x42, 0x79, 0x74, 0x65,
	0x49, 0x74, 0x65, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x42, 0x59, 0x54, 0x45,
	0x5f, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x4c, 0x41, 0x49,
	0x4e, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x55, 0x54, 0x46, 0x38, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03,
	0x50, 0x44, 0x46, 0x10, 0x02, 0x22, 0x9d, 0x03, 0x0a, 0x13, 0x53, 0x64, 0x70, 0x44, 0x65, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5e, 0x0a,
	0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4c, 0x0a,
	0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x0c, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x38, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x49,
	0x74, 0x65, 0x6d, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2b, 0x0a, 0x11, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65,
	0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x66, 0x6f,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xff, 0x02, 0x0a, 0x0a, 0x53, 0x64, 0x70, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x50, 0x0a, 0x0a, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x64, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6b,
	0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x0a, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68,
	0x6f, 0x6f, 0x64, 0x12, 0x55, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x64, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x64,
	0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xaa, 0x01, 0x0a, 0x12, 0x53,
	0x64, 0x70, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x44, 0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x62, 0x79,
	0x74, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x4e, 0x0a, 0x0f, 0x63, 0x6f, 0x64, 0x65, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x63, 0x6f, 0x64, 0x65, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0xff, 0x02, 0x0a, 0x1a, 0x50, 0x69, 0x41, 0x6e,
	0x64, 0x4a, 0x61, 0x69, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49,
	0x74, 0x65, 0x6d, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72,
	0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5f, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x9c, 0x04, 0x0a, 0x18, 0x4d, 0x61,
	0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49,
	0x74, 0x65, 0x6d, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72,
	0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x8b, 0x01, 0x0a, 0x1b, 0x6d, 0x61, 0x6c,
	0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6c, 0x69,
	0x63, 0x69, 0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4d, 0x61, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x55, 0x72,
	0x69, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x18, 0x6d, 0x61,
	0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x64, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x1a, 0x70, 0x0a, 0x17, 0x4d, 0x61, 0x6c, 0x69, 0x63, 0x69,
	0x6f, 0x75, 0x73, 0x55, 0x72, 0x69, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x69, 0x12, 0x43, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xf9, 0x04, 0x0a, 0x15, 0x56, 0x69, 0x72,
	0x75, 0x73, 0x53, 0x63, 0x61, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x74,
	0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72,
	0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x74,
	0x65, 0x6d, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x12, 0x52, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x76, 0x0a, 0x14, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x69, 0x72, 0x75, 0x73, 0x53, 0x63, 0x61, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x53, 0x69, 0x7a,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x4c, 0x0a, 0x0d, 0x76, 0x69, 0x72, 0x75, 0x73, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x75, 0x73, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x52, 0x0c, 0x76, 0x69, 0x72, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x22, 0x5f, 0x0a, 0x12, 0x53, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x43, 0x41, 0x4e,
	0x4e, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50,
	0x4c, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x58, 0x54, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x44,
	0x46, 0x10, 0x03, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x22, 0xb6, 0x02, 0x0a, 0x0b, 0x56, 0x69, 0x72, 0x75, 0x73, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x12, 0x53, 0x0a, 0x0b, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x72, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x54, 0x68, 0x72, 0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0xa3, 0x01, 0x0a, 0x0a, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x48, 0x52, 0x45, 0x41, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x01,
	0x12, 0x11, 0x0a, 0x0d, 0x56, 0x49, 0x52, 0x55, 0x53, 0x5f, 0x4f, 0x52, 0x5f, 0x57, 0x4f, 0x52,
	0x4d, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x41, 0x4c, 0x49, 0x43, 0x49, 0x4f, 0x55, 0x53,
	0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x41, 0x4d, 0x10, 0x03, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x4f,
	0x54, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x48, 0x41, 0x52, 0x4d, 0x46, 0x55,
	0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x20, 0x0a, 0x1c, 0x50,
	0x4f, 0x54, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x55, 0x4e, 0x57, 0x41, 0x4e,
	0x54, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x05, 0x22, 0x94, 0x02,
	0x0a, 0x10, 0x43, 0x73, 0x61, 0x6d, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x74,
	0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72,
	0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x74,
	0x65, 0x6d, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x12, 0x52, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x0b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x49, 0x74, 0x65, 0x6d, 0x12, 0x56, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61,
	0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49,
	0x74, 0x65, 0x6d, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x4d, 0x0a, 0x0b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x03, 0x22, 0x4f, 0x0a, 0x09, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x15, 0x0a,
	0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x03, 0x65, 0x6e,
	0x64, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x42, 0x06,
	0x0a, 0x04, 0x5f, 0x65, 0x6e, 0x64, 0x2a, 0x5b, 0x0a, 0x10, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x46, 0x49,
	0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12,
	0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x46, 0x4f, 0x55, 0x4e,
	0x44, 0x10, 0x02, 0x2a, 0x6c, 0x0a, 0x14, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x46,
	0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x58,
	0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10,
	0x02, 0x2a, 0x77, 0x0a, 0x0d, 0x52, 0x61, 0x69, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x41, 0x49, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x45, 0x58, 0x55, 0x41, 0x4c, 0x4c, 0x59, 0x5f,
	0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x41,
	0x54, 0x45, 0x5f, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x48,
	0x41, 0x52, 0x41, 0x53, 0x53, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x44,
	0x41, 0x4e, 0x47, 0x45, 0x52, 0x4f, 0x55, 0x53, 0x10, 0x11, 0x2a, 0x79, 0x0a, 0x18, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x2a, 0x0a, 0x26, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x44, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x4c,
	0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42,
	0x4f, 0x56, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x5f,
	0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x48,
	0x49, 0x47, 0x48, 0x10, 0x03, 0x2a, 0x8a, 0x01, 0x0a, 0x14, 0x53, 0x64, 0x70, 0x46, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x26,
	0x0a, 0x22, 0x53, 0x44, 0x50, 0x5f, 0x46, 0x49, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x4c, 0x49,
	0x4b, 0x45, 0x4c, 0x49, 0x48, 0x4f, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x55,
	0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x4e, 0x4c,
	0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x4f, 0x53, 0x53, 0x49,
	0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10,
	0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59,
	0x10, 0x05, 0x2a, 0x5c, 0x0a, 0x10, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x56, 0x4f, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41,
	0x4c, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x10, 0x03,
	0x32, 0xc4, 0x10, 0x0a, 0x0a, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x72, 0x6d, 0x6f, 0x72, 0x12,
	0xb4, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0xa1, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x3c, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x0e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x5d, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2c, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x08, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0xca, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d,
	0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x22, 0x5f, 0xda, 0x41, 0x14, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42,
	0x3a, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x32, 0x36, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x99, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a,
	0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x98,
	0x02, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x22, 0xa6, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x98,
	0x01, 0x5a, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x7d, 0x5a, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x6f,
	0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x6f,
	0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0x8a, 0x03, 0x0a, 0x12, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x22, 0x92, 0x02, 0xda, 0x41, 0x19, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xef, 0x01, 0x3a, 0x0d, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5a, 0x4c, 0x3a, 0x0d, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x6c,
	0x6f, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x7d, 0x5a, 0x52, 0x3a, 0x0d, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x6c, 0x6f, 0x6f,
	0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x6f, 0x72,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x7d, 0x32, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66,
	0x6c, 0x6f, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0xd0, 0x01, 0x0a, 0x12, 0x53, 0x61, 0x6e, 0x69, 0x74,
	0x69, 0x7a, 0x65, 0x55, 0x73, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x6e, 0x69, 0x74,
	0x69, 0x7a, 0x65, 0x55, 0x73, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x55, 0x73, 0x65, 0x72, 0x50, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0xdc, 0x01, 0x0a, 0x15, 0x53, 0x61,
	0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x6e, 0x69, 0x74,
	0x69, 0x7a, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48,
	0x3a, 0x01, 0x2a, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6f, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x56, 0x31, 0x6d, 0x61, 0x69,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x70, 0x62, 0x3b, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_modelarmor_v1_service_proto_rawDescOnce sync.Once
	file_google_cloud_modelarmor_v1_service_proto_rawDescData = file_google_cloud_modelarmor_v1_service_proto_rawDesc
)

func file_google_cloud_modelarmor_v1_service_proto_rawDescGZIP() []byte {
	file_google_cloud_modelarmor_v1_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_modelarmor_v1_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_modelarmor_v1_service_proto_rawDescData)
	})
	return file_google_cloud_modelarmor_v1_service_proto_rawDescData
}

var file_google_cloud_modelarmor_v1_service_proto_enumTypes = make([]protoimpl.EnumInfo, 13)
var file_google_cloud_modelarmor_v1_service_proto_msgTypes = make([]protoimpl.MessageInfo, 46)
var file_google_cloud_modelarmor_v1_service_proto_goTypes = []any{
	(FilterMatchState)(0),         // 0: google.cloud.modelarmor.v1.FilterMatchState
	(FilterExecutionState)(0),     // 1: google.cloud.modelarmor.v1.FilterExecutionState
	(RaiFilterType)(0),            // 2: google.cloud.modelarmor.v1.RaiFilterType
	(DetectionConfidenceLevel)(0), // 3: google.cloud.modelarmor.v1.DetectionConfidenceLevel
	(SdpFindingLikelihood)(0),     // 4: google.cloud.modelarmor.v1.SdpFindingLikelihood
	(InvocationResult)(0),         // 5: google.cloud.modelarmor.v1.InvocationResult
	(PiAndJailbreakFilterSettings_PiAndJailbreakFilterEnforcement)(0), // 6: google.cloud.modelarmor.v1.PiAndJailbreakFilterSettings.PiAndJailbreakFilterEnforcement
	(MaliciousUriFilterSettings_MaliciousUriFilterEnforcement)(0),     // 7: google.cloud.modelarmor.v1.MaliciousUriFilterSettings.MaliciousUriFilterEnforcement
	(SdpBasicConfig_SdpBasicConfigEnforcement)(0),                     // 8: google.cloud.modelarmor.v1.SdpBasicConfig.SdpBasicConfigEnforcement
	(ByteDataItem_ByteItemType)(0),                                    // 9: google.cloud.modelarmor.v1.ByteDataItem.ByteItemType
	(VirusScanFilterResult_ScannedContentType)(0),                     // 10: google.cloud.modelarmor.v1.VirusScanFilterResult.ScannedContentType
	(VirusDetail_ThreatType)(0),                                       // 11: google.cloud.modelarmor.v1.VirusDetail.ThreatType
	(MessageItem_MessageType)(0),                                      // 12: google.cloud.modelarmor.v1.MessageItem.MessageType
	(*Template)(nil),                                                  // 13: google.cloud.modelarmor.v1.Template
	(*FloorSetting)(nil),                                              // 14: google.cloud.modelarmor.v1.FloorSetting
	(*ListTemplatesRequest)(nil),                                      // 15: google.cloud.modelarmor.v1.ListTemplatesRequest
	(*ListTemplatesResponse)(nil),                                     // 16: google.cloud.modelarmor.v1.ListTemplatesResponse
	(*GetTemplateRequest)(nil),                                        // 17: google.cloud.modelarmor.v1.GetTemplateRequest
	(*CreateTemplateRequest)(nil),                                     // 18: google.cloud.modelarmor.v1.CreateTemplateRequest
	(*UpdateTemplateRequest)(nil),                                     // 19: google.cloud.modelarmor.v1.UpdateTemplateRequest
	(*DeleteTemplateRequest)(nil),                                     // 20: google.cloud.modelarmor.v1.DeleteTemplateRequest
	(*GetFloorSettingRequest)(nil),                                    // 21: google.cloud.modelarmor.v1.GetFloorSettingRequest
	(*UpdateFloorSettingRequest)(nil),                                 // 22: google.cloud.modelarmor.v1.UpdateFloorSettingRequest
	(*FilterConfig)(nil),                                              // 23: google.cloud.modelarmor.v1.FilterConfig
	(*PiAndJailbreakFilterSettings)(nil),                              // 24: google.cloud.modelarmor.v1.PiAndJailbreakFilterSettings
	(*MaliciousUriFilterSettings)(nil),                                // 25: google.cloud.modelarmor.v1.MaliciousUriFilterSettings
	(*RaiFilterSettings)(nil),                                         // 26: google.cloud.modelarmor.v1.RaiFilterSettings
	(*SdpFilterSettings)(nil),                                         // 27: google.cloud.modelarmor.v1.SdpFilterSettings
	(*SdpBasicConfig)(nil),                                            // 28: google.cloud.modelarmor.v1.SdpBasicConfig
	(*SdpAdvancedConfig)(nil),                                         // 29: google.cloud.modelarmor.v1.SdpAdvancedConfig
	(*SanitizeUserPromptRequest)(nil),                                 // 30: google.cloud.modelarmor.v1.SanitizeUserPromptRequest
	(*SanitizeModelResponseRequest)(nil),                              // 31: google.cloud.modelarmor.v1.SanitizeModelResponseRequest
	(*SanitizeUserPromptResponse)(nil),                                // 32: google.cloud.modelarmor.v1.SanitizeUserPromptResponse
	(*SanitizeModelResponseResponse)(nil),                             // 33: google.cloud.modelarmor.v1.SanitizeModelResponseResponse
	(*SanitizationResult)(nil),                                        // 34: google.cloud.modelarmor.v1.SanitizationResult
	(*FilterResult)(nil),                                              // 35: google.cloud.modelarmor.v1.FilterResult
	(*RaiFilterResult)(nil),                                           // 36: google.cloud.modelarmor.v1.RaiFilterResult
	(*SdpFilterResult)(nil),                                           // 37: google.cloud.modelarmor.v1.SdpFilterResult
	(*SdpInspectResult)(nil),                                          // 38: google.cloud.modelarmor.v1.SdpInspectResult
	(*DataItem)(nil),                                                  // 39: google.cloud.modelarmor.v1.DataItem
	(*ByteDataItem)(nil),                                              // 40: google.cloud.modelarmor.v1.ByteDataItem
	(*SdpDeidentifyResult)(nil),                                       // 41: google.cloud.modelarmor.v1.SdpDeidentifyResult
	(*SdpFinding)(nil),                                                // 42: google.cloud.modelarmor.v1.SdpFinding
	(*PiAndJailbreakFilterResult)(nil),                                // 43: google.cloud.modelarmor.v1.PiAndJailbreakFilterResult
	(*MaliciousUriFilterResult)(nil),                                  // 44: google.cloud.modelarmor.v1.MaliciousUriFilterResult
	(*VirusScanFilterResult)(nil),                                     // 45: google.cloud.modelarmor.v1.VirusScanFilterResult
	(*VirusDetail)(nil),                                               // 46: google.cloud.modelarmor.v1.VirusDetail
	(*CsamFilterResult)(nil),                                          // 47: google.cloud.modelarmor.v1.CsamFilterResult
	(*MessageItem)(nil),                                               // 48: google.cloud.modelarmor.v1.MessageItem
	(*RangeInfo)(nil),                                                 // 49: google.cloud.modelarmor.v1.RangeInfo
	(*Template_TemplateMetadata)(nil),                                 // 50: google.cloud.modelarmor.v1.Template.TemplateMetadata
	nil,                                                               // 51: google.cloud.modelarmor.v1.Template.LabelsEntry
	(*RaiFilterSettings_RaiFilter)(nil),                               // 52: google.cloud.modelarmor.v1.RaiFilterSettings.RaiFilter
	(*SanitizationResult_SanitizationMetadata)(nil),                   // 53: google.cloud.modelarmor.v1.SanitizationResult.SanitizationMetadata
	nil, // 54: google.cloud.modelarmor.v1.SanitizationResult.FilterResultsEntry
	(*RaiFilterResult_RaiFilterTypeResult)(nil), // 55: google.cloud.modelarmor.v1.RaiFilterResult.RaiFilterTypeResult
	nil,                                   // 56: google.cloud.modelarmor.v1.RaiFilterResult.RaiFilterTypeResultsEntry
	(*SdpFinding_SdpFindingLocation)(nil), // 57: google.cloud.modelarmor.v1.SdpFinding.SdpFindingLocation
	(*MaliciousUriFilterResult_MaliciousUriMatchedItem)(nil), // 58: google.cloud.modelarmor.v1.MaliciousUriFilterResult.MaliciousUriMatchedItem
	(*timestamppb.Timestamp)(nil),                            // 59: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                            // 60: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                                    // 61: google.protobuf.Empty
}
var file_google_cloud_modelarmor_v1_service_proto_depIdxs = []int32{
	59, // 0: google.cloud.modelarmor.v1.Template.create_time:type_name -> google.protobuf.Timestamp
	59, // 1: google.cloud.modelarmor.v1.Template.update_time:type_name -> google.protobuf.Timestamp
	51, // 2: google.cloud.modelarmor.v1.Template.labels:type_name -> google.cloud.modelarmor.v1.Template.LabelsEntry
	23, // 3: google.cloud.modelarmor.v1.Template.filter_config:type_name -> google.cloud.modelarmor.v1.FilterConfig
	50, // 4: google.cloud.modelarmor.v1.Template.template_metadata:type_name -> google.cloud.modelarmor.v1.Template.TemplateMetadata
	59, // 5: google.cloud.modelarmor.v1.FloorSetting.create_time:type_name -> google.protobuf.Timestamp
	59, // 6: google.cloud.modelarmor.v1.FloorSetting.update_time:type_name -> google.protobuf.Timestamp
	23, // 7: google.cloud.modelarmor.v1.FloorSetting.filter_config:type_name -> google.cloud.modelarmor.v1.FilterConfig
	13, // 8: google.cloud.modelarmor.v1.ListTemplatesResponse.templates:type_name -> google.cloud.modelarmor.v1.Template
	13, // 9: google.cloud.modelarmor.v1.CreateTemplateRequest.template:type_name -> google.cloud.modelarmor.v1.Template
	60, // 10: google.cloud.modelarmor.v1.UpdateTemplateRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 11: google.cloud.modelarmor.v1.UpdateTemplateRequest.template:type_name -> google.cloud.modelarmor.v1.Template
	14, // 12: google.cloud.modelarmor.v1.UpdateFloorSettingRequest.floor_setting:type_name -> google.cloud.modelarmor.v1.FloorSetting
	60, // 13: google.cloud.modelarmor.v1.UpdateFloorSettingRequest.update_mask:type_name -> google.protobuf.FieldMask
	26, // 14: google.cloud.modelarmor.v1.FilterConfig.rai_settings:type_name -> google.cloud.modelarmor.v1.RaiFilterSettings
	27, // 15: google.cloud.modelarmor.v1.FilterConfig.sdp_settings:type_name -> google.cloud.modelarmor.v1.SdpFilterSettings
	24, // 16: google.cloud.modelarmor.v1.FilterConfig.pi_and_jailbreak_filter_settings:type_name -> google.cloud.modelarmor.v1.PiAndJailbreakFilterSettings
	25, // 17: google.cloud.modelarmor.v1.FilterConfig.malicious_uri_filter_settings:type_name -> google.cloud.modelarmor.v1.MaliciousUriFilterSettings
	6,  // 18: google.cloud.modelarmor.v1.PiAndJailbreakFilterSettings.filter_enforcement:type_name -> google.cloud.modelarmor.v1.PiAndJailbreakFilterSettings.PiAndJailbreakFilterEnforcement
	3,  // 19: google.cloud.modelarmor.v1.PiAndJailbreakFilterSettings.confidence_level:type_name -> google.cloud.modelarmor.v1.DetectionConfidenceLevel
	7,  // 20: google.cloud.modelarmor.v1.MaliciousUriFilterSettings.filter_enforcement:type_name -> google.cloud.modelarmor.v1.MaliciousUriFilterSettings.MaliciousUriFilterEnforcement
	52, // 21: google.cloud.modelarmor.v1.RaiFilterSettings.rai_filters:type_name -> google.cloud.modelarmor.v1.RaiFilterSettings.RaiFilter
	28, // 22: google.cloud.modelarmor.v1.SdpFilterSettings.basic_config:type_name -> google.cloud.modelarmor.v1.SdpBasicConfig
	29, // 23: google.cloud.modelarmor.v1.SdpFilterSettings.advanced_config:type_name -> google.cloud.modelarmor.v1.SdpAdvancedConfig
	8,  // 24: google.cloud.modelarmor.v1.SdpBasicConfig.filter_enforcement:type_name -> google.cloud.modelarmor.v1.SdpBasicConfig.SdpBasicConfigEnforcement
	39, // 25: google.cloud.modelarmor.v1.SanitizeUserPromptRequest.user_prompt_data:type_name -> google.cloud.modelarmor.v1.DataItem
	39, // 26: google.cloud.modelarmor.v1.SanitizeModelResponseRequest.model_response_data:type_name -> google.cloud.modelarmor.v1.DataItem
	34, // 27: google.cloud.modelarmor.v1.SanitizeUserPromptResponse.sanitization_result:type_name -> google.cloud.modelarmor.v1.SanitizationResult
	34, // 28: google.cloud.modelarmor.v1.SanitizeModelResponseResponse.sanitization_result:type_name -> google.cloud.modelarmor.v1.SanitizationResult
	0,  // 29: google.cloud.modelarmor.v1.SanitizationResult.filter_match_state:type_name -> google.cloud.modelarmor.v1.FilterMatchState
	54, // 30: google.cloud.modelarmor.v1.SanitizationResult.filter_results:type_name -> google.cloud.modelarmor.v1.SanitizationResult.FilterResultsEntry
	5,  // 31: google.cloud.modelarmor.v1.SanitizationResult.invocation_result:type_name -> google.cloud.modelarmor.v1.InvocationResult
	53, // 32: google.cloud.modelarmor.v1.SanitizationResult.sanitization_metadata:type_name -> google.cloud.modelarmor.v1.SanitizationResult.SanitizationMetadata
	36, // 33: google.cloud.modelarmor.v1.FilterResult.rai_filter_result:type_name -> google.cloud.modelarmor.v1.RaiFilterResult
	37, // 34: google.cloud.modelarmor.v1.FilterResult.sdp_filter_result:type_name -> google.cloud.modelarmor.v1.SdpFilterResult
	43, // 35: google.cloud.modelarmor.v1.FilterResult.pi_and_jailbreak_filter_result:type_name -> google.cloud.modelarmor.v1.PiAndJailbreakFilterResult
	44, // 36: google.cloud.modelarmor.v1.FilterResult.malicious_uri_filter_result:type_name -> google.cloud.modelarmor.v1.MaliciousUriFilterResult
	47, // 37: google.cloud.modelarmor.v1.FilterResult.csam_filter_filter_result:type_name -> google.cloud.modelarmor.v1.CsamFilterResult
	45, // 38: google.cloud.modelarmor.v1.FilterResult.virus_scan_filter_result:type_name -> google.cloud.modelarmor.v1.VirusScanFilterResult
	1,  // 39: google.cloud.modelarmor.v1.RaiFilterResult.execution_state:type_name -> google.cloud.modelarmor.v1.FilterExecutionState
	48, // 40: google.cloud.modelarmor.v1.RaiFilterResult.message_items:type_name -> google.cloud.modelarmor.v1.MessageItem
	0,  // 41: google.cloud.modelarmor.v1.RaiFilterResult.match_state:type_name -> google.cloud.modelarmor.v1.FilterMatchState
	56, // 42: google.cloud.modelarmor.v1.RaiFilterResult.rai_filter_type_results:type_name -> google.cloud.modelarmor.v1.RaiFilterResult.RaiFilterTypeResultsEntry
	38, // 43: google.cloud.modelarmor.v1.SdpFilterResult.inspect_result:type_name -> google.cloud.modelarmor.v1.SdpInspectResult
	41, // 44: google.cloud.modelarmor.v1.SdpFilterResult.deidentify_result:type_name -> google.cloud.modelarmor.v1.SdpDeidentifyResult
	1,  // 45: google.cloud.modelarmor.v1.SdpInspectResult.execution_state:type_name -> google.cloud.modelarmor.v1.FilterExecutionState
	48, // 46: google.cloud.modelarmor.v1.SdpInspectResult.message_items:type_name -> google.cloud.modelarmor.v1.MessageItem
	0,  // 47: google.cloud.modelarmor.v1.SdpInspectResult.match_state:type_name -> google.cloud.modelarmor.v1.FilterMatchState
	42, // 48: google.cloud.modelarmor.v1.SdpInspectResult.findings:type_name -> google.cloud.modelarmor.v1.SdpFinding
	40, // 49: google.cloud.modelarmor.v1.DataItem.byte_item:type_name -> google.cloud.modelarmor.v1.ByteDataItem
	9,  // 50: google.cloud.modelarmor.v1.ByteDataItem.byte_data_type:type_name -> google.cloud.modelarmor.v1.ByteDataItem.ByteItemType
	1,  // 51: google.cloud.modelarmor.v1.SdpDeidentifyResult.execution_state:type_name -> google.cloud.modelarmor.v1.FilterExecutionState
	48, // 52: google.cloud.modelarmor.v1.SdpDeidentifyResult.message_items:type_name -> google.cloud.modelarmor.v1.MessageItem
	0,  // 53: google.cloud.modelarmor.v1.SdpDeidentifyResult.match_state:type_name -> google.cloud.modelarmor.v1.FilterMatchState
	39, // 54: google.cloud.modelarmor.v1.SdpDeidentifyResult.data:type_name -> google.cloud.modelarmor.v1.DataItem
	4,  // 55: google.cloud.modelarmor.v1.SdpFinding.likelihood:type_name -> google.cloud.modelarmor.v1.SdpFindingLikelihood
	57, // 56: google.cloud.modelarmor.v1.SdpFinding.location:type_name -> google.cloud.modelarmor.v1.SdpFinding.SdpFindingLocation
	1,  // 57: google.cloud.modelarmor.v1.PiAndJailbreakFilterResult.execution_state:type_name -> google.cloud.modelarmor.v1.FilterExecutionState
	48, // 58: google.cloud.modelarmor.v1.PiAndJailbreakFilterResult.message_items:type_name -> google.cloud.modelarmor.v1.MessageItem
	0,  // 59: google.cloud.modelarmor.v1.PiAndJailbreakFilterResult.match_state:type_name -> google.cloud.modelarmor.v1.FilterMatchState
	3,  // 60: google.cloud.modelarmor.v1.PiAndJailbreakFilterResult.confidence_level:type_name -> google.cloud.modelarmor.v1.DetectionConfidenceLevel
	1,  // 61: google.cloud.modelarmor.v1.MaliciousUriFilterResult.execution_state:type_name -> google.cloud.modelarmor.v1.FilterExecutionState
	48, // 62: google.cloud.modelarmor.v1.MaliciousUriFilterResult.message_items:type_name -> google.cloud.modelarmor.v1.MessageItem
	0,  // 63: google.cloud.modelarmor.v1.MaliciousUriFilterResult.match_state:type_name -> google.cloud.modelarmor.v1.FilterMatchState
	58, // 64: google.cloud.modelarmor.v1.MaliciousUriFilterResult.malicious_uri_matched_items:type_name -> google.cloud.modelarmor.v1.MaliciousUriFilterResult.MaliciousUriMatchedItem
	1,  // 65: google.cloud.modelarmor.v1.VirusScanFilterResult.execution_state:type_name -> google.cloud.modelarmor.v1.FilterExecutionState
	48, // 66: google.cloud.modelarmor.v1.VirusScanFilterResult.message_items:type_name -> google.cloud.modelarmor.v1.MessageItem
	0,  // 67: google.cloud.modelarmor.v1.VirusScanFilterResult.match_state:type_name -> google.cloud.modelarmor.v1.FilterMatchState
	10, // 68: google.cloud.modelarmor.v1.VirusScanFilterResult.scanned_content_type:type_name -> google.cloud.modelarmor.v1.VirusScanFilterResult.ScannedContentType
	46, // 69: google.cloud.modelarmor.v1.VirusScanFilterResult.virus_details:type_name -> google.cloud.modelarmor.v1.VirusDetail
	11, // 70: google.cloud.modelarmor.v1.VirusDetail.threat_type:type_name -> google.cloud.modelarmor.v1.VirusDetail.ThreatType
	1,  // 71: google.cloud.modelarmor.v1.CsamFilterResult.execution_state:type_name -> google.cloud.modelarmor.v1.FilterExecutionState
	48, // 72: google.cloud.modelarmor.v1.CsamFilterResult.message_items:type_name -> google.cloud.modelarmor.v1.MessageItem
	0,  // 73: google.cloud.modelarmor.v1.CsamFilterResult.match_state:type_name -> google.cloud.modelarmor.v1.FilterMatchState
	12, // 74: google.cloud.modelarmor.v1.MessageItem.message_type:type_name -> google.cloud.modelarmor.v1.MessageItem.MessageType
	2,  // 75: google.cloud.modelarmor.v1.RaiFilterSettings.RaiFilter.filter_type:type_name -> google.cloud.modelarmor.v1.RaiFilterType
	3,  // 76: google.cloud.modelarmor.v1.RaiFilterSettings.RaiFilter.confidence_level:type_name -> google.cloud.modelarmor.v1.DetectionConfidenceLevel
	35, // 77: google.cloud.modelarmor.v1.SanitizationResult.FilterResultsEntry.value:type_name -> google.cloud.modelarmor.v1.FilterResult
	2,  // 78: google.cloud.modelarmor.v1.RaiFilterResult.RaiFilterTypeResult.filter_type:type_name -> google.cloud.modelarmor.v1.RaiFilterType
	3,  // 79: google.cloud.modelarmor.v1.RaiFilterResult.RaiFilterTypeResult.confidence_level:type_name -> google.cloud.modelarmor.v1.DetectionConfidenceLevel
	0,  // 80: google.cloud.modelarmor.v1.RaiFilterResult.RaiFilterTypeResult.match_state:type_name -> google.cloud.modelarmor.v1.FilterMatchState
	55, // 81: google.cloud.modelarmor.v1.RaiFilterResult.RaiFilterTypeResultsEntry.value:type_name -> google.cloud.modelarmor.v1.RaiFilterResult.RaiFilterTypeResult
	49, // 82: google.cloud.modelarmor.v1.SdpFinding.SdpFindingLocation.byte_range:type_name -> google.cloud.modelarmor.v1.RangeInfo
	49, // 83: google.cloud.modelarmor.v1.SdpFinding.SdpFindingLocation.codepoint_range:type_name -> google.cloud.modelarmor.v1.RangeInfo
	49, // 84: google.cloud.modelarmor.v1.MaliciousUriFilterResult.MaliciousUriMatchedItem.locations:type_name -> google.cloud.modelarmor.v1.RangeInfo
	15, // 85: google.cloud.modelarmor.v1.ModelArmor.ListTemplates:input_type -> google.cloud.modelarmor.v1.ListTemplatesRequest
	17, // 86: google.cloud.modelarmor.v1.ModelArmor.GetTemplate:input_type -> google.cloud.modelarmor.v1.GetTemplateRequest
	18, // 87: google.cloud.modelarmor.v1.ModelArmor.CreateTemplate:input_type -> google.cloud.modelarmor.v1.CreateTemplateRequest
	19, // 88: google.cloud.modelarmor.v1.ModelArmor.UpdateTemplate:input_type -> google.cloud.modelarmor.v1.UpdateTemplateRequest
	20, // 89: google.cloud.modelarmor.v1.ModelArmor.DeleteTemplate:input_type -> google.cloud.modelarmor.v1.DeleteTemplateRequest
	21, // 90: google.cloud.modelarmor.v1.ModelArmor.GetFloorSetting:input_type -> google.cloud.modelarmor.v1.GetFloorSettingRequest
	22, // 91: google.cloud.modelarmor.v1.ModelArmor.UpdateFloorSetting:input_type -> google.cloud.modelarmor.v1.UpdateFloorSettingRequest
	30, // 92: google.cloud.modelarmor.v1.ModelArmor.SanitizeUserPrompt:input_type -> google.cloud.modelarmor.v1.SanitizeUserPromptRequest
	31, // 93: google.cloud.modelarmor.v1.ModelArmor.SanitizeModelResponse:input_type -> google.cloud.modelarmor.v1.SanitizeModelResponseRequest
	16, // 94: google.cloud.modelarmor.v1.ModelArmor.ListTemplates:output_type -> google.cloud.modelarmor.v1.ListTemplatesResponse
	13, // 95: google.cloud.modelarmor.v1.ModelArmor.GetTemplate:output_type -> google.cloud.modelarmor.v1.Template
	13, // 96: google.cloud.modelarmor.v1.ModelArmor.CreateTemplate:output_type -> google.cloud.modelarmor.v1.Template
	13, // 97: google.cloud.modelarmor.v1.ModelArmor.UpdateTemplate:output_type -> google.cloud.modelarmor.v1.Template
	61, // 98: google.cloud.modelarmor.v1.ModelArmor.DeleteTemplate:output_type -> google.protobuf.Empty
	14, // 99: google.cloud.modelarmor.v1.ModelArmor.GetFloorSetting:output_type -> google.cloud.modelarmor.v1.FloorSetting
	14, // 100: google.cloud.modelarmor.v1.ModelArmor.UpdateFloorSetting:output_type -> google.cloud.modelarmor.v1.FloorSetting
	32, // 101: google.cloud.modelarmor.v1.ModelArmor.SanitizeUserPrompt:output_type -> google.cloud.modelarmor.v1.SanitizeUserPromptResponse
	33, // 102: google.cloud.modelarmor.v1.ModelArmor.SanitizeModelResponse:output_type -> google.cloud.modelarmor.v1.SanitizeModelResponseResponse
	94, // [94:103] is the sub-list for method output_type
	85, // [85:94] is the sub-list for method input_type
	85, // [85:85] is the sub-list for extension type_name
	85, // [85:85] is the sub-list for extension extendee
	0,  // [0:85] is the sub-list for field type_name
}

func init() { file_google_cloud_modelarmor_v1_service_proto_init() }
func file_google_cloud_modelarmor_v1_service_proto_init() {
	if File_google_cloud_modelarmor_v1_service_proto != nil {
		return
	}
	file_google_cloud_modelarmor_v1_service_proto_msgTypes[1].OneofWrappers = []any{}
	file_google_cloud_modelarmor_v1_service_proto_msgTypes[14].OneofWrappers = []any{
		(*SdpFilterSettings_BasicConfig)(nil),
		(*SdpFilterSettings_AdvancedConfig)(nil),
	}
	file_google_cloud_modelarmor_v1_service_proto_msgTypes[22].OneofWrappers = []any{
		(*FilterResult_RaiFilterResult)(nil),
		(*FilterResult_SdpFilterResult)(nil),
		(*FilterResult_PiAndJailbreakFilterResult)(nil),
		(*FilterResult_MaliciousUriFilterResult)(nil),
		(*FilterResult_CsamFilterFilterResult)(nil),
		(*FilterResult_VirusScanFilterResult)(nil),
	}
	file_google_cloud_modelarmor_v1_service_proto_msgTypes[24].OneofWrappers = []any{
		(*SdpFilterResult_InspectResult)(nil),
		(*SdpFilterResult_DeidentifyResult)(nil),
	}
	file_google_cloud_modelarmor_v1_service_proto_msgTypes[26].OneofWrappers = []any{
		(*DataItem_Text)(nil),
		(*DataItem_ByteItem)(nil),
	}
	file_google_cloud_modelarmor_v1_service_proto_msgTypes[32].OneofWrappers = []any{}
	file_google_cloud_modelarmor_v1_service_proto_msgTypes[36].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_modelarmor_v1_service_proto_rawDesc,
			NumEnums:      13,
			NumMessages:   46,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_modelarmor_v1_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_modelarmor_v1_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_modelarmor_v1_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_modelarmor_v1_service_proto_msgTypes,
	}.Build()
	File_google_cloud_modelarmor_v1_service_proto = out.File
	file_google_cloud_modelarmor_v1_service_proto_rawDesc = nil
	file_google_cloud_modelarmor_v1_service_proto_goTypes = nil
	file_google_cloud_modelarmor_v1_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ModelArmorClient is the client API for ModelArmor service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ModelArmorClient interface {
	// Lists Templates in a given project and location.
	ListTemplates(ctx context.Context, in *ListTemplatesRequest, opts ...grpc.CallOption) (*ListTemplatesResponse, error)
	// Gets details of a single Template.
	GetTemplate(ctx context.Context, in *GetTemplateRequest, opts ...grpc.CallOption) (*Template, error)
	// Creates a new Template in a given project and location.
	CreateTemplate(ctx context.Context, in *CreateTemplateRequest, opts ...grpc.CallOption) (*Template, error)
	// Updates the parameters of a single Template.
	UpdateTemplate(ctx context.Context, in *UpdateTemplateRequest, opts ...grpc.CallOption) (*Template, error)
	// Deletes a single Template.
	DeleteTemplate(ctx context.Context, in *DeleteTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets details of a single floor setting of a project
	GetFloorSetting(ctx context.Context, in *GetFloorSettingRequest, opts ...grpc.CallOption) (*FloorSetting, error)
	// Updates the parameters of a single floor setting of a project
	UpdateFloorSetting(ctx context.Context, in *UpdateFloorSettingRequest, opts ...grpc.CallOption) (*FloorSetting, error)
	// Sanitizes User Prompt.
	SanitizeUserPrompt(ctx context.Context, in *SanitizeUserPromptRequest, opts ...grpc.CallOption) (*SanitizeUserPromptResponse, error)
	// Sanitizes Model Response.
	SanitizeModelResponse(ctx context.Context, in *SanitizeModelResponseRequest, opts ...grpc.CallOption) (*SanitizeModelResponseResponse, error)
}

type modelArmorClient struct {
	cc grpc.ClientConnInterface
}

func NewModelArmorClient(cc grpc.ClientConnInterface) ModelArmorClient {
	return &modelArmorClient{cc}
}

func (c *modelArmorClient) ListTemplates(ctx context.Context, in *ListTemplatesRequest, opts ...grpc.CallOption) (*ListTemplatesResponse, error) {
	out := new(ListTemplatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.modelarmor.v1.ModelArmor/ListTemplates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelArmorClient) GetTemplate(ctx context.Context, in *GetTemplateRequest, opts ...grpc.CallOption) (*Template, error) {
	out := new(Template)
	err := c.cc.Invoke(ctx, "/google.cloud.modelarmor.v1.ModelArmor/GetTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelArmorClient) CreateTemplate(ctx context.Context, in *CreateTemplateRequest, opts ...grpc.CallOption) (*Template, error) {
	out := new(Template)
	err := c.cc.Invoke(ctx, "/google.cloud.modelarmor.v1.ModelArmor/CreateTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelArmorClient) UpdateTemplate(ctx context.Context, in *UpdateTemplateRequest, opts ...grpc.CallOption) (*Template, error) {
	out := new(Template)
	err := c.cc.Invoke(ctx, "/google.cloud.modelarmor.v1.ModelArmor/UpdateTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelArmorClient) DeleteTemplate(ctx context.Context, in *DeleteTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.modelarmor.v1.ModelArmor/DeleteTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelArmorClient) GetFloorSetting(ctx context.Context, in *GetFloorSettingRequest, opts ...grpc.CallOption) (*FloorSetting, error) {
	out := new(FloorSetting)
	err := c.cc.Invoke(ctx, "/google.cloud.modelarmor.v1.ModelArmor/GetFloorSetting", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelArmorClient) UpdateFloorSetting(ctx context.Context, in *UpdateFloorSettingRequest, opts ...grpc.CallOption) (*FloorSetting, error) {
	out := new(FloorSetting)
	err := c.cc.Invoke(ctx, "/google.cloud.modelarmor.v1.ModelArmor/UpdateFloorSetting", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelArmorClient) SanitizeUserPrompt(ctx context.Context, in *SanitizeUserPromptRequest, opts ...grpc.CallOption) (*SanitizeUserPromptResponse, error) {
	out := new(SanitizeUserPromptResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.modelarmor.v1.ModelArmor/SanitizeUserPrompt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelArmorClient) SanitizeModelResponse(ctx context.Context, in *SanitizeModelResponseRequest, opts ...grpc.CallOption) (*SanitizeModelResponseResponse, error) {
	out := new(SanitizeModelResponseResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.modelarmor.v1.ModelArmor/SanitizeModelResponse", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelArmorServer is the server API for ModelArmor service.
type ModelArmorServer interface {
	// Lists Templates in a given project and location.
	ListTemplates(context.Context, *ListTemplatesRequest) (*ListTemplatesResponse, error)
	// Gets details of a single Template.
	GetTemplate(context.Context, *GetTemplateRequest) (*Template, error)
	// Creates a new Template in a given project and location.
	CreateTemplate(context.Context, *CreateTemplateRequest) (*Template, error)
	// Updates the parameters of a single Template.
	UpdateTemplate(context.Context, *UpdateTemplateRequest) (*Template, error)
	// Deletes a single Template.
	DeleteTemplate(context.Context, *DeleteTemplateRequest) (*emptypb.Empty, error)
	// Gets details of a single floor setting of a project
	GetFloorSetting(context.Context, *GetFloorSettingRequest) (*FloorSetting, error)
	// Updates the parameters of a single floor setting of a project
	UpdateFloorSetting(context.Context, *UpdateFloorSettingRequest) (*FloorSetting, error)
	// Sanitizes User Prompt.
	SanitizeUserPrompt(context.Context, *SanitizeUserPromptRequest) (*SanitizeUserPromptResponse, error)
	// Sanitizes Model Response.
	SanitizeModelResponse(context.Context, *SanitizeModelResponseRequest) (*SanitizeModelResponseResponse, error)
}

// UnimplementedModelArmorServer can be embedded to have forward compatible implementations.
type UnimplementedModelArmorServer struct {
}

func (*UnimplementedModelArmorServer) ListTemplates(context.Context, *ListTemplatesRequest) (*ListTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTemplates not implemented")
}
func (*UnimplementedModelArmorServer) GetTemplate(context.Context, *GetTemplateRequest) (*Template, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTemplate not implemented")
}
func (*UnimplementedModelArmorServer) CreateTemplate(context.Context, *CreateTemplateRequest) (*Template, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTemplate not implemented")
}
func (*UnimplementedModelArmorServer) UpdateTemplate(context.Context, *UpdateTemplateRequest) (*Template, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTemplate not implemented")
}
func (*UnimplementedModelArmorServer) DeleteTemplate(context.Context, *DeleteTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTemplate not implemented")
}
func (*UnimplementedModelArmorServer) GetFloorSetting(context.Context, *GetFloorSettingRequest) (*FloorSetting, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFloorSetting not implemented")
}
func (*UnimplementedModelArmorServer) UpdateFloorSetting(context.Context, *UpdateFloorSettingRequest) (*FloorSetting, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFloorSetting not implemented")
}
func (*UnimplementedModelArmorServer) SanitizeUserPrompt(context.Context, *SanitizeUserPromptRequest) (*SanitizeUserPromptResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SanitizeUserPrompt not implemented")
}
func (*UnimplementedModelArmorServer) SanitizeModelResponse(context.Context, *SanitizeModelResponseRequest) (*SanitizeModelResponseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SanitizeModelResponse not implemented")
}

func RegisterModelArmorServer(s *grpc.Server, srv ModelArmorServer) {
	s.RegisterService(&_ModelArmor_serviceDesc, srv)
}

func _ModelArmor_ListTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelArmorServer).ListTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.modelarmor.v1.ModelArmor/ListTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelArmorServer).ListTemplates(ctx, req.(*ListTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelArmor_GetTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelArmorServer).GetTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.modelarmor.v1.ModelArmor/GetTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelArmorServer).GetTemplate(ctx, req.(*GetTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelArmor_CreateTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelArmorServer).CreateTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.modelarmor.v1.ModelArmor/CreateTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelArmorServer).CreateTemplate(ctx, req.(*CreateTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelArmor_UpdateTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelArmorServer).UpdateTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.modelarmor.v1.ModelArmor/UpdateTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelArmorServer).UpdateTemplate(ctx, req.(*UpdateTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelArmor_DeleteTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelArmorServer).DeleteTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.modelarmor.v1.ModelArmor/DeleteTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelArmorServer).DeleteTemplate(ctx, req.(*DeleteTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelArmor_GetFloorSetting_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFloorSettingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelArmorServer).GetFloorSetting(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.modelarmor.v1.ModelArmor/GetFloorSetting",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelArmorServer).GetFloorSetting(ctx, req.(*GetFloorSettingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelArmor_UpdateFloorSetting_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFloorSettingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelArmorServer).UpdateFloorSetting(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.modelarmor.v1.ModelArmor/UpdateFloorSetting",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelArmorServer).UpdateFloorSetting(ctx, req.(*UpdateFloorSettingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelArmor_SanitizeUserPrompt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SanitizeUserPromptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelArmorServer).SanitizeUserPrompt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.modelarmor.v1.ModelArmor/SanitizeUserPrompt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelArmorServer).SanitizeUserPrompt(ctx, req.(*SanitizeUserPromptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelArmor_SanitizeModelResponse_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SanitizeModelResponseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelArmorServer).SanitizeModelResponse(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.modelarmor.v1.ModelArmor/SanitizeModelResponse",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelArmorServer).SanitizeModelResponse(ctx, req.(*SanitizeModelResponseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ModelArmor_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.modelarmor.v1.ModelArmor",
	HandlerType: (*ModelArmorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTemplates",
			Handler:    _ModelArmor_ListTemplates_Handler,
		},
		{
			MethodName: "GetTemplate",
			Handler:    _ModelArmor_GetTemplate_Handler,
		},
		{
			MethodName: "CreateTemplate",
			Handler:    _ModelArmor_CreateTemplate_Handler,
		},
		{
			MethodName: "UpdateTemplate",
			Handler:    _ModelArmor_UpdateTemplate_Handler,
		},
		{
			MethodName: "DeleteTemplate",
			Handler:    _ModelArmor_DeleteTemplate_Handler,
		},
		{
			MethodName: "GetFloorSetting",
			Handler:    _ModelArmor_GetFloorSetting_Handler,
		},
		{
			MethodName: "UpdateFloorSetting",
			Handler:    _ModelArmor_UpdateFloorSetting_Handler,
		},
		{
			MethodName: "SanitizeUserPrompt",
			Handler:    _ModelArmor_SanitizeUserPrompt_Handler,
		},
		{
			MethodName: "SanitizeModelResponse",
			Handler:    _ModelArmor_SanitizeModelResponse_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/modelarmor/v1/service.proto",
}
