// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package managedidentities

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	managedidentitiespb "cloud.google.com/go/managedidentities/apiv1/managedidentitiespb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	CreateMicrosoftAdDomain []gax.CallOption
	ResetAdminPassword      []gax.CallOption
	ListDomains             []gax.CallOption
	GetDomain               []gax.CallOption
	UpdateDomain            []gax.CallOption
	DeleteDomain            []gax.CallOption
	AttachTrust             []gax.CallOption
	ReconfigureTrust        []gax.CallOption
	DetachTrust             []gax.CallOption
	ValidateTrust           []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("managedidentities.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("managedidentities.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("managedidentities.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://managedidentities.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		CreateMicrosoftAdDomain: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResetAdminPassword: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListDomains: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetDomain: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateDomain: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteDomain: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		AttachTrust: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ReconfigureTrust: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DetachTrust: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ValidateTrust: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
	}
}

// internalClient is an interface that defines the methods available from Managed Service for Microsoft Active Directory API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateMicrosoftAdDomain(context.Context, *managedidentitiespb.CreateMicrosoftAdDomainRequest, ...gax.CallOption) (*CreateMicrosoftAdDomainOperation, error)
	CreateMicrosoftAdDomainOperation(name string) *CreateMicrosoftAdDomainOperation
	ResetAdminPassword(context.Context, *managedidentitiespb.ResetAdminPasswordRequest, ...gax.CallOption) (*managedidentitiespb.ResetAdminPasswordResponse, error)
	ListDomains(context.Context, *managedidentitiespb.ListDomainsRequest, ...gax.CallOption) *DomainIterator
	GetDomain(context.Context, *managedidentitiespb.GetDomainRequest, ...gax.CallOption) (*managedidentitiespb.Domain, error)
	UpdateDomain(context.Context, *managedidentitiespb.UpdateDomainRequest, ...gax.CallOption) (*UpdateDomainOperation, error)
	UpdateDomainOperation(name string) *UpdateDomainOperation
	DeleteDomain(context.Context, *managedidentitiespb.DeleteDomainRequest, ...gax.CallOption) (*DeleteDomainOperation, error)
	DeleteDomainOperation(name string) *DeleteDomainOperation
	AttachTrust(context.Context, *managedidentitiespb.AttachTrustRequest, ...gax.CallOption) (*AttachTrustOperation, error)
	AttachTrustOperation(name string) *AttachTrustOperation
	ReconfigureTrust(context.Context, *managedidentitiespb.ReconfigureTrustRequest, ...gax.CallOption) (*ReconfigureTrustOperation, error)
	ReconfigureTrustOperation(name string) *ReconfigureTrustOperation
	DetachTrust(context.Context, *managedidentitiespb.DetachTrustRequest, ...gax.CallOption) (*DetachTrustOperation, error)
	DetachTrustOperation(name string) *DetachTrustOperation
	ValidateTrust(context.Context, *managedidentitiespb.ValidateTrustRequest, ...gax.CallOption) (*ValidateTrustOperation, error)
	ValidateTrustOperation(name string) *ValidateTrustOperation
}

// Client is a client for interacting with Managed Service for Microsoft Active Directory API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// # API Overview
//
// The managedidentites.googleapis.com service implements the Google Cloud
// Managed Identites API for identity services
// (e.g. Microsoft Active Directory).
//
// The Managed Identities service provides methods to manage
// (create/read/update/delete) domains, reset managed identities admin password,
// add/remove domain controllers in GCP regions and add/remove VPC peering.
//
// # Data Model
//
// The Managed Identities service exposes the following resources:
//
//	Locations as global, named as follows:
//	projects/{project_id}/locations/global.
//
//	Domains, named as follows:
//	/projects/{project_id}/locations/global/domain/{domain_name}.
//
// The {domain_name} refers to fully qualified domain name in the customer
// project e.g. mydomain.myorganization.com (at http://mydomain.myorganization.com), with the following restrictions:
//
//	Must contain only lowercase letters, numbers, periods and hyphens.
//
//	Must start with a letter.
//
//	Must contain between 2-64 characters.
//
//	Must end with a number or a letter.
//
//	Must not start with period.
//
//	First segement length (mydomain form example above) shouldn’t exceed
//	15 chars.
//
//	The last segment cannot be fully numeric.
//
//	Must be unique within the customer project.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateMicrosoftAdDomain creates a Microsoft AD domain.
func (c *Client) CreateMicrosoftAdDomain(ctx context.Context, req *managedidentitiespb.CreateMicrosoftAdDomainRequest, opts ...gax.CallOption) (*CreateMicrosoftAdDomainOperation, error) {
	return c.internalClient.CreateMicrosoftAdDomain(ctx, req, opts...)
}

// CreateMicrosoftAdDomainOperation returns a new CreateMicrosoftAdDomainOperation from a given name.
// The name must be that of a previously created CreateMicrosoftAdDomainOperation, possibly from a different process.
func (c *Client) CreateMicrosoftAdDomainOperation(name string) *CreateMicrosoftAdDomainOperation {
	return c.internalClient.CreateMicrosoftAdDomainOperation(name)
}

// ResetAdminPassword resets a domain’s administrator password.
func (c *Client) ResetAdminPassword(ctx context.Context, req *managedidentitiespb.ResetAdminPasswordRequest, opts ...gax.CallOption) (*managedidentitiespb.ResetAdminPasswordResponse, error) {
	return c.internalClient.ResetAdminPassword(ctx, req, opts...)
}

// ListDomains lists domains in a project.
func (c *Client) ListDomains(ctx context.Context, req *managedidentitiespb.ListDomainsRequest, opts ...gax.CallOption) *DomainIterator {
	return c.internalClient.ListDomains(ctx, req, opts...)
}

// GetDomain gets information about a domain.
func (c *Client) GetDomain(ctx context.Context, req *managedidentitiespb.GetDomainRequest, opts ...gax.CallOption) (*managedidentitiespb.Domain, error) {
	return c.internalClient.GetDomain(ctx, req, opts...)
}

// UpdateDomain updates the metadata and configuration of a domain.
func (c *Client) UpdateDomain(ctx context.Context, req *managedidentitiespb.UpdateDomainRequest, opts ...gax.CallOption) (*UpdateDomainOperation, error) {
	return c.internalClient.UpdateDomain(ctx, req, opts...)
}

// UpdateDomainOperation returns a new UpdateDomainOperation from a given name.
// The name must be that of a previously created UpdateDomainOperation, possibly from a different process.
func (c *Client) UpdateDomainOperation(name string) *UpdateDomainOperation {
	return c.internalClient.UpdateDomainOperation(name)
}

// DeleteDomain deletes a domain.
func (c *Client) DeleteDomain(ctx context.Context, req *managedidentitiespb.DeleteDomainRequest, opts ...gax.CallOption) (*DeleteDomainOperation, error) {
	return c.internalClient.DeleteDomain(ctx, req, opts...)
}

// DeleteDomainOperation returns a new DeleteDomainOperation from a given name.
// The name must be that of a previously created DeleteDomainOperation, possibly from a different process.
func (c *Client) DeleteDomainOperation(name string) *DeleteDomainOperation {
	return c.internalClient.DeleteDomainOperation(name)
}

// AttachTrust adds an AD trust to a domain.
func (c *Client) AttachTrust(ctx context.Context, req *managedidentitiespb.AttachTrustRequest, opts ...gax.CallOption) (*AttachTrustOperation, error) {
	return c.internalClient.AttachTrust(ctx, req, opts...)
}

// AttachTrustOperation returns a new AttachTrustOperation from a given name.
// The name must be that of a previously created AttachTrustOperation, possibly from a different process.
func (c *Client) AttachTrustOperation(name string) *AttachTrustOperation {
	return c.internalClient.AttachTrustOperation(name)
}

// ReconfigureTrust updates the DNS conditional forwarder.
func (c *Client) ReconfigureTrust(ctx context.Context, req *managedidentitiespb.ReconfigureTrustRequest, opts ...gax.CallOption) (*ReconfigureTrustOperation, error) {
	return c.internalClient.ReconfigureTrust(ctx, req, opts...)
}

// ReconfigureTrustOperation returns a new ReconfigureTrustOperation from a given name.
// The name must be that of a previously created ReconfigureTrustOperation, possibly from a different process.
func (c *Client) ReconfigureTrustOperation(name string) *ReconfigureTrustOperation {
	return c.internalClient.ReconfigureTrustOperation(name)
}

// DetachTrust removes an AD trust.
func (c *Client) DetachTrust(ctx context.Context, req *managedidentitiespb.DetachTrustRequest, opts ...gax.CallOption) (*DetachTrustOperation, error) {
	return c.internalClient.DetachTrust(ctx, req, opts...)
}

// DetachTrustOperation returns a new DetachTrustOperation from a given name.
// The name must be that of a previously created DetachTrustOperation, possibly from a different process.
func (c *Client) DetachTrustOperation(name string) *DetachTrustOperation {
	return c.internalClient.DetachTrustOperation(name)
}

// ValidateTrust validates a trust state, that the target domain is reachable, and that the
// target domain is able to accept incoming trust requests.
func (c *Client) ValidateTrust(ctx context.Context, req *managedidentitiespb.ValidateTrustRequest, opts ...gax.CallOption) (*ValidateTrustOperation, error) {
	return c.internalClient.ValidateTrust(ctx, req, opts...)
}

// ValidateTrustOperation returns a new ValidateTrustOperation from a given name.
// The name must be that of a previously created ValidateTrustOperation, possibly from a different process.
func (c *Client) ValidateTrustOperation(name string) *ValidateTrustOperation {
	return c.internalClient.ValidateTrustOperation(name)
}

// gRPCClient is a client for interacting with Managed Service for Microsoft Active Directory API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client managedidentitiespb.ManagedIdentitiesServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewClient creates a new managed identities service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// # API Overview
//
// The managedidentites.googleapis.com service implements the Google Cloud
// Managed Identites API for identity services
// (e.g. Microsoft Active Directory).
//
// The Managed Identities service provides methods to manage
// (create/read/update/delete) domains, reset managed identities admin password,
// add/remove domain controllers in GCP regions and add/remove VPC peering.
//
// # Data Model
//
// The Managed Identities service exposes the following resources:
//
//	Locations as global, named as follows:
//	projects/{project_id}/locations/global.
//
//	Domains, named as follows:
//	/projects/{project_id}/locations/global/domain/{domain_name}.
//
// The {domain_name} refers to fully qualified domain name in the customer
// project e.g. mydomain.myorganization.com (at http://mydomain.myorganization.com), with the following restrictions:
//
//	Must contain only lowercase letters, numbers, periods and hyphens.
//
//	Must start with a letter.
//
//	Must contain between 2-64 characters.
//
//	Must end with a number or a letter.
//
//	Must not start with period.
//
//	First segement length (mydomain form example above) shouldn’t exceed
//	15 chars.
//
//	The last segment cannot be fully numeric.
//
//	Must be unique within the customer project.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:    connPool,
		client:      managedidentitiespb.NewManagedIdentitiesServiceClient(connPool),
		CallOptions: &client.CallOptions,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *gRPCClient) CreateMicrosoftAdDomain(ctx context.Context, req *managedidentitiespb.CreateMicrosoftAdDomainRequest, opts ...gax.CallOption) (*CreateMicrosoftAdDomainOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateMicrosoftAdDomain[0:len((*c.CallOptions).CreateMicrosoftAdDomain):len((*c.CallOptions).CreateMicrosoftAdDomain)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateMicrosoftAdDomain, req, settings.GRPC, c.logger, "CreateMicrosoftAdDomain")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateMicrosoftAdDomainOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ResetAdminPassword(ctx context.Context, req *managedidentitiespb.ResetAdminPasswordRequest, opts ...gax.CallOption) (*managedidentitiespb.ResetAdminPasswordResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ResetAdminPassword[0:len((*c.CallOptions).ResetAdminPassword):len((*c.CallOptions).ResetAdminPassword)], opts...)
	var resp *managedidentitiespb.ResetAdminPasswordResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ResetAdminPassword, req, settings.GRPC, c.logger, "ResetAdminPassword")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListDomains(ctx context.Context, req *managedidentitiespb.ListDomainsRequest, opts ...gax.CallOption) *DomainIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDomains[0:len((*c.CallOptions).ListDomains):len((*c.CallOptions).ListDomains)], opts...)
	it := &DomainIterator{}
	req = proto.Clone(req).(*managedidentitiespb.ListDomainsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*managedidentitiespb.Domain, string, error) {
		resp := &managedidentitiespb.ListDomainsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListDomains, req, settings.GRPC, c.logger, "ListDomains")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDomains(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetDomain(ctx context.Context, req *managedidentitiespb.GetDomainRequest, opts ...gax.CallOption) (*managedidentitiespb.Domain, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetDomain[0:len((*c.CallOptions).GetDomain):len((*c.CallOptions).GetDomain)], opts...)
	var resp *managedidentitiespb.Domain
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetDomain, req, settings.GRPC, c.logger, "GetDomain")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateDomain(ctx context.Context, req *managedidentitiespb.UpdateDomainRequest, opts ...gax.CallOption) (*UpdateDomainOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "domain.name", url.QueryEscape(req.GetDomain().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDomain[0:len((*c.CallOptions).UpdateDomain):len((*c.CallOptions).UpdateDomain)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateDomain, req, settings.GRPC, c.logger, "UpdateDomain")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateDomainOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteDomain(ctx context.Context, req *managedidentitiespb.DeleteDomainRequest, opts ...gax.CallOption) (*DeleteDomainOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteDomain[0:len((*c.CallOptions).DeleteDomain):len((*c.CallOptions).DeleteDomain)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteDomain, req, settings.GRPC, c.logger, "DeleteDomain")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteDomainOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) AttachTrust(ctx context.Context, req *managedidentitiespb.AttachTrustRequest, opts ...gax.CallOption) (*AttachTrustOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AttachTrust[0:len((*c.CallOptions).AttachTrust):len((*c.CallOptions).AttachTrust)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.AttachTrust, req, settings.GRPC, c.logger, "AttachTrust")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &AttachTrustOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ReconfigureTrust(ctx context.Context, req *managedidentitiespb.ReconfigureTrustRequest, opts ...gax.CallOption) (*ReconfigureTrustOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReconfigureTrust[0:len((*c.CallOptions).ReconfigureTrust):len((*c.CallOptions).ReconfigureTrust)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ReconfigureTrust, req, settings.GRPC, c.logger, "ReconfigureTrust")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReconfigureTrustOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DetachTrust(ctx context.Context, req *managedidentitiespb.DetachTrustRequest, opts ...gax.CallOption) (*DetachTrustOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DetachTrust[0:len((*c.CallOptions).DetachTrust):len((*c.CallOptions).DetachTrust)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DetachTrust, req, settings.GRPC, c.logger, "DetachTrust")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DetachTrustOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ValidateTrust(ctx context.Context, req *managedidentitiespb.ValidateTrustRequest, opts ...gax.CallOption) (*ValidateTrustOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ValidateTrust[0:len((*c.CallOptions).ValidateTrust):len((*c.CallOptions).ValidateTrust)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ValidateTrust, req, settings.GRPC, c.logger, "ValidateTrust")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ValidateTrustOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

// AttachTrustOperation returns a new AttachTrustOperation from a given name.
// The name must be that of a previously created AttachTrustOperation, possibly from a different process.
func (c *gRPCClient) AttachTrustOperation(name string) *AttachTrustOperation {
	return &AttachTrustOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateMicrosoftAdDomainOperation returns a new CreateMicrosoftAdDomainOperation from a given name.
// The name must be that of a previously created CreateMicrosoftAdDomainOperation, possibly from a different process.
func (c *gRPCClient) CreateMicrosoftAdDomainOperation(name string) *CreateMicrosoftAdDomainOperation {
	return &CreateMicrosoftAdDomainOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteDomainOperation returns a new DeleteDomainOperation from a given name.
// The name must be that of a previously created DeleteDomainOperation, possibly from a different process.
func (c *gRPCClient) DeleteDomainOperation(name string) *DeleteDomainOperation {
	return &DeleteDomainOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DetachTrustOperation returns a new DetachTrustOperation from a given name.
// The name must be that of a previously created DetachTrustOperation, possibly from a different process.
func (c *gRPCClient) DetachTrustOperation(name string) *DetachTrustOperation {
	return &DetachTrustOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ReconfigureTrustOperation returns a new ReconfigureTrustOperation from a given name.
// The name must be that of a previously created ReconfigureTrustOperation, possibly from a different process.
func (c *gRPCClient) ReconfigureTrustOperation(name string) *ReconfigureTrustOperation {
	return &ReconfigureTrustOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateDomainOperation returns a new UpdateDomainOperation from a given name.
// The name must be that of a previously created UpdateDomainOperation, possibly from a different process.
func (c *gRPCClient) UpdateDomainOperation(name string) *UpdateDomainOperation {
	return &UpdateDomainOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ValidateTrustOperation returns a new ValidateTrustOperation from a given name.
// The name must be that of a previously created ValidateTrustOperation, possibly from a different process.
func (c *gRPCClient) ValidateTrustOperation(name string) *ValidateTrustOperation {
	return &ValidateTrustOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
