// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/financialservices/v1/bigquery_destination.proto

package financialservicespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// WriteDisposition controls the behavior when the destination table already
// exists.
type BigQueryDestination_WriteDisposition int32

const (
	// Default behavior is the same as WRITE_EMPTY.
	BigQueryDestination_WRITE_DISPOSITION_UNSPECIFIED BigQueryDestination_WriteDisposition = 0
	// If the table already exists and contains data, an error is returned.
	BigQueryDestination_WRITE_EMPTY BigQueryDestination_WriteDisposition = 1
	// If the table already exists, the data will be overwritten.
	BigQueryDestination_WRITE_TRUNCATE BigQueryDestination_WriteDisposition = 2
)

// Enum value maps for BigQueryDestination_WriteDisposition.
var (
	BigQueryDestination_WriteDisposition_name = map[int32]string{
		0: "WRITE_DISPOSITION_UNSPECIFIED",
		1: "WRITE_EMPTY",
		2: "WRITE_TRUNCATE",
	}
	BigQueryDestination_WriteDisposition_value = map[string]int32{
		"WRITE_DISPOSITION_UNSPECIFIED": 0,
		"WRITE_EMPTY":                   1,
		"WRITE_TRUNCATE":                2,
	}
)

func (x BigQueryDestination_WriteDisposition) Enum() *BigQueryDestination_WriteDisposition {
	p := new(BigQueryDestination_WriteDisposition)
	*p = x
	return p
}

func (x BigQueryDestination_WriteDisposition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BigQueryDestination_WriteDisposition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_financialservices_v1_bigquery_destination_proto_enumTypes[0].Descriptor()
}

func (BigQueryDestination_WriteDisposition) Type() protoreflect.EnumType {
	return &file_google_cloud_financialservices_v1_bigquery_destination_proto_enumTypes[0]
}

func (x BigQueryDestination_WriteDisposition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BigQueryDestination_WriteDisposition.Descriptor instead.
func (BigQueryDestination_WriteDisposition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDescGZIP(), []int{0, 0}
}

// BigQueryDestination is a wrapper for BigQuery output information.
type BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. BigQuery URI to a table, must be of the form
	// bq://projectId.bqDatasetId.tableId.
	// Note that the BigQuery dataset must already exist.
	// VPC-SC restrictions apply.
	TableUri string `protobuf:"bytes,1,opt,name=table_uri,json=tableUri,proto3" json:"table_uri,omitempty"`
	// Required. Whether or not to overwrite destination table. By default the
	// table won't be overwritten and an error will be returned if the table
	// exists and contains data.
	WriteDisposition BigQueryDestination_WriteDisposition `protobuf:"varint,2,opt,name=write_disposition,json=writeDisposition,proto3,enum=google.cloud.financialservices.v1.BigQueryDestination_WriteDisposition" json:"write_disposition,omitempty"`
}

func (x *BigQueryDestination) Reset() {
	*x = BigQueryDestination{}
	mi := &file_google_cloud_financialservices_v1_bigquery_destination_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestination) ProtoMessage() {}

func (x *BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_bigquery_destination_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestination.ProtoReflect.Descriptor instead.
func (*BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDescGZIP(), []int{0}
}

func (x *BigQueryDestination) GetTableUri() string {
	if x != nil {
		return x.TableUri
	}
	return ""
}

func (x *BigQueryDestination) GetWriteDisposition() BigQueryDestination_WriteDisposition {
	if x != nil {
		return x.WriteDisposition
	}
	return BigQueryDestination_WRITE_DISPOSITION_UNSPECIFIED
}

var File_google_cloud_financialservices_v1_bigquery_destination_proto protoreflect.FileDescriptor

var file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e,
	0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x8e, 0x02, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x72, 0x69, 0x12, 0x79, 0x0a, 0x11,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5a, 0x0a, 0x10, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x57,
	0x52, 0x49, 0x54, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x45, 0x4d, 0x50, 0x54, 0x59, 0x10, 0x01, 0x12,
	0x12, 0x0a, 0x0e, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x54, 0x52, 0x55, 0x4e, 0x43, 0x41, 0x54,
	0x45, 0x10, 0x02, 0x42, 0x98, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x18, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x66, 0x69, 0x6e, 0x61, 0x6e,
	0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDescOnce sync.Once
	file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDescData = file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDesc
)

func file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDescGZIP() []byte {
	file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDescOnce.Do(func() {
		file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDescData)
	})
	return file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDescData
}

var file_google_cloud_financialservices_v1_bigquery_destination_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_financialservices_v1_bigquery_destination_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_financialservices_v1_bigquery_destination_proto_goTypes = []any{
	(BigQueryDestination_WriteDisposition)(0), // 0: google.cloud.financialservices.v1.BigQueryDestination.WriteDisposition
	(*BigQueryDestination)(nil),               // 1: google.cloud.financialservices.v1.BigQueryDestination
}
var file_google_cloud_financialservices_v1_bigquery_destination_proto_depIdxs = []int32{
	0, // 0: google.cloud.financialservices.v1.BigQueryDestination.write_disposition:type_name -> google.cloud.financialservices.v1.BigQueryDestination.WriteDisposition
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_financialservices_v1_bigquery_destination_proto_init() }
func file_google_cloud_financialservices_v1_bigquery_destination_proto_init() {
	if File_google_cloud_financialservices_v1_bigquery_destination_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_financialservices_v1_bigquery_destination_proto_goTypes,
		DependencyIndexes: file_google_cloud_financialservices_v1_bigquery_destination_proto_depIdxs,
		EnumInfos:         file_google_cloud_financialservices_v1_bigquery_destination_proto_enumTypes,
		MessageInfos:      file_google_cloud_financialservices_v1_bigquery_destination_proto_msgTypes,
	}.Build()
	File_google_cloud_financialservices_v1_bigquery_destination_proto = out.File
	file_google_cloud_financialservices_v1_bigquery_destination_proto_rawDesc = nil
	file_google_cloud_financialservices_v1_bigquery_destination_proto_goTypes = nil
	file_google_cloud_financialservices_v1_bigquery_destination_proto_depIdxs = nil
}
