// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1beta/sample_query_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [SampleQueryService.GetSampleQuery][google.cloud.discoveryengine.v1beta.SampleQueryService.GetSampleQuery]
// method.
type GetSampleQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], such as
	// `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
	//
	// If the caller does not have permission to access the
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], regardless
	// of whether or not it exists, a PERMISSION_DENIED error is returned.
	//
	// If the requested
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] does not
	// exist, a NOT_FOUND error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSampleQueryRequest) Reset() {
	*x = GetSampleQueryRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSampleQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSampleQueryRequest) ProtoMessage() {}

func (x *GetSampleQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSampleQueryRequest.ProtoReflect.Descriptor instead.
func (*GetSampleQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetSampleQueryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [SampleQueryService.ListSampleQueries][google.cloud.discoveryengine.v1beta.SampleQueryService.ListSampleQueries]
// method.
type ListSampleQueriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent sample query set resource name, such as
	// `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
	//
	// If the caller does not have permission to list
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s under this
	// sample query set, regardless of whether or not this sample query set
	// exists, a `PERMISSION_DENIED` error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s to return.
	// If unspecified, defaults to 100. The maximum allowed value is 1000. Values
	// above 1000 will be coerced to 1000.
	//
	// If this field is negative, an `INVALID_ARGUMENT` error is returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token
	// [ListSampleQueriesResponse.next_page_token][google.cloud.discoveryengine.v1beta.ListSampleQueriesResponse.next_page_token],
	// received from a previous
	// [SampleQueryService.ListSampleQueries][google.cloud.discoveryengine.v1beta.SampleQueryService.ListSampleQueries]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [SampleQueryService.ListSampleQueries][google.cloud.discoveryengine.v1beta.SampleQueryService.ListSampleQueries]
	// must match the call that provided the page token. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSampleQueriesRequest) Reset() {
	*x = ListSampleQueriesRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSampleQueriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSampleQueriesRequest) ProtoMessage() {}

func (x *ListSampleQueriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSampleQueriesRequest.ProtoReflect.Descriptor instead.
func (*ListSampleQueriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListSampleQueriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSampleQueriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSampleQueriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [SampleQueryService.ListSampleQueries][google.cloud.discoveryengine.v1beta.SampleQueryService.ListSampleQueries]
// method.
type ListSampleQueriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s.
	SampleQueries []*SampleQuery `protobuf:"bytes,1,rep,name=sample_queries,json=sampleQueries,proto3" json:"sample_queries,omitempty"`
	// A token that can be sent as
	// [ListSampleQueriesRequest.page_token][google.cloud.discoveryengine.v1beta.ListSampleQueriesRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSampleQueriesResponse) Reset() {
	*x = ListSampleQueriesResponse{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSampleQueriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSampleQueriesResponse) ProtoMessage() {}

func (x *ListSampleQueriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSampleQueriesResponse.ProtoReflect.Descriptor instead.
func (*ListSampleQueriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListSampleQueriesResponse) GetSampleQueries() []*SampleQuery {
	if x != nil {
		return x.SampleQueries
	}
	return nil
}

func (x *ListSampleQueriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [SampleQueryService.CreateSampleQuery][google.cloud.discoveryengine.v1beta.SampleQueryService.CreateSampleQuery]
// method.
type CreateSampleQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name, such as
	// `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] to create.
	SampleQuery *SampleQuery `protobuf:"bytes,2,opt,name=sample_query,json=sampleQuery,proto3" json:"sample_query,omitempty"`
	// Required. The ID to use for the
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], which will
	// become the final component of the
	// [SampleQuery.name][google.cloud.discoveryengine.v1beta.SampleQuery.name].
	//
	// If the caller does not have permission to create the
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], regardless
	// of whether or not it exists, a `PERMISSION_DENIED` error is returned.
	//
	// This field must be unique among all
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s with the
	// same
	// [parent][google.cloud.discoveryengine.v1beta.CreateSampleQueryRequest.parent].
	// Otherwise, an `ALREADY_EXISTS` error is returned.
	//
	// This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
	// standard with a length limit of 63 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	SampleQueryId string `protobuf:"bytes,3,opt,name=sample_query_id,json=sampleQueryId,proto3" json:"sample_query_id,omitempty"`
}

func (x *CreateSampleQueryRequest) Reset() {
	*x = CreateSampleQueryRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSampleQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSampleQueryRequest) ProtoMessage() {}

func (x *CreateSampleQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSampleQueryRequest.ProtoReflect.Descriptor instead.
func (*CreateSampleQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateSampleQueryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSampleQueryRequest) GetSampleQuery() *SampleQuery {
	if x != nil {
		return x.SampleQuery
	}
	return nil
}

func (x *CreateSampleQueryRequest) GetSampleQueryId() string {
	if x != nil {
		return x.SampleQueryId
	}
	return ""
}

// Request message for
// [SampleQueryService.UpdateSampleQuery][google.cloud.discoveryengine.v1beta.SampleQueryService.UpdateSampleQuery]
// method.
type UpdateSampleQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The simple query to update.
	//
	// If the caller does not have permission to update the
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], regardless
	// of whether or not it exists, a `PERMISSION_DENIED` error is returned.
	//
	// If the [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] to
	// update does not exist a `NOT_FOUND` error is returned.
	SampleQuery *SampleQuery `protobuf:"bytes,1,opt,name=sample_query,json=sampleQuery,proto3" json:"sample_query,omitempty"`
	// Indicates which fields in the provided imported 'simple query' to update.
	// If not set, will by default update all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSampleQueryRequest) Reset() {
	*x = UpdateSampleQueryRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSampleQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSampleQueryRequest) ProtoMessage() {}

func (x *UpdateSampleQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSampleQueryRequest.ProtoReflect.Descriptor instead.
func (*UpdateSampleQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateSampleQueryRequest) GetSampleQuery() *SampleQuery {
	if x != nil {
		return x.SampleQuery
	}
	return nil
}

func (x *UpdateSampleQueryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [SampleQueryService.DeleteSampleQuery][google.cloud.discoveryengine.v1beta.SampleQueryService.DeleteSampleQuery]
// method.
type DeleteSampleQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], such as
	// `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}/sampleQueries/{sample_query}`.
	//
	// If the caller does not have permission to delete the
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery], regardless
	// of whether or not it exists, a `PERMISSION_DENIED` error is returned.
	//
	// If the [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery] to
	// delete does not exist, a `NOT_FOUND` error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSampleQueryRequest) Reset() {
	*x = DeleteSampleQueryRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSampleQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSampleQueryRequest) ProtoMessage() {}

func (x *DeleteSampleQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSampleQueryRequest.ProtoReflect.Descriptor instead.
func (*DeleteSampleQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteSampleQueryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_discoveryengine_v1beta_sample_query_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5f, 0x0a,
	0x15, 0x47, 0x65, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa5,
	0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9c, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0e, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x0d,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf0, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x58, 0x0a, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2b, 0x0a, 0x0f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x64, 0x22, 0xb1, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x62, 0x0a, 0x18,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x32, 0xeb, 0x0c, 0x0a, 0x12, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xd6, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xec, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51,
	0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x8a, 0x02, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0x83, 0x01, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x22, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x8c, 0x02, 0x0a,
	0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x22, 0x85, 0x01, 0xda, 0x41, 0x18, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x64, 0x3a, 0x0c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x32, 0x54, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x11,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x2a, 0x47, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xd7, 0x02, 0x0a, 0x13, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdf, 0x01, 0xca, 0x41, 0x82, 0x01, 0x0a,
	0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x9e,
	0x02, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x17, 0x53, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x51, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f,
	0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c,
	0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_goTypes = []any{
	(*GetSampleQueryRequest)(nil),      // 0: google.cloud.discoveryengine.v1beta.GetSampleQueryRequest
	(*ListSampleQueriesRequest)(nil),   // 1: google.cloud.discoveryengine.v1beta.ListSampleQueriesRequest
	(*ListSampleQueriesResponse)(nil),  // 2: google.cloud.discoveryengine.v1beta.ListSampleQueriesResponse
	(*CreateSampleQueryRequest)(nil),   // 3: google.cloud.discoveryengine.v1beta.CreateSampleQueryRequest
	(*UpdateSampleQueryRequest)(nil),   // 4: google.cloud.discoveryengine.v1beta.UpdateSampleQueryRequest
	(*DeleteSampleQueryRequest)(nil),   // 5: google.cloud.discoveryengine.v1beta.DeleteSampleQueryRequest
	(*SampleQuery)(nil),                // 6: google.cloud.discoveryengine.v1beta.SampleQuery
	(*fieldmaskpb.FieldMask)(nil),      // 7: google.protobuf.FieldMask
	(*ImportSampleQueriesRequest)(nil), // 8: google.cloud.discoveryengine.v1beta.ImportSampleQueriesRequest
	(*emptypb.Empty)(nil),              // 9: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),    // 10: google.longrunning.Operation
}
var file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_depIdxs = []int32{
	6,  // 0: google.cloud.discoveryengine.v1beta.ListSampleQueriesResponse.sample_queries:type_name -> google.cloud.discoveryengine.v1beta.SampleQuery
	6,  // 1: google.cloud.discoveryengine.v1beta.CreateSampleQueryRequest.sample_query:type_name -> google.cloud.discoveryengine.v1beta.SampleQuery
	6,  // 2: google.cloud.discoveryengine.v1beta.UpdateSampleQueryRequest.sample_query:type_name -> google.cloud.discoveryengine.v1beta.SampleQuery
	7,  // 3: google.cloud.discoveryengine.v1beta.UpdateSampleQueryRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 4: google.cloud.discoveryengine.v1beta.SampleQueryService.GetSampleQuery:input_type -> google.cloud.discoveryengine.v1beta.GetSampleQueryRequest
	1,  // 5: google.cloud.discoveryengine.v1beta.SampleQueryService.ListSampleQueries:input_type -> google.cloud.discoveryengine.v1beta.ListSampleQueriesRequest
	3,  // 6: google.cloud.discoveryengine.v1beta.SampleQueryService.CreateSampleQuery:input_type -> google.cloud.discoveryengine.v1beta.CreateSampleQueryRequest
	4,  // 7: google.cloud.discoveryengine.v1beta.SampleQueryService.UpdateSampleQuery:input_type -> google.cloud.discoveryengine.v1beta.UpdateSampleQueryRequest
	5,  // 8: google.cloud.discoveryengine.v1beta.SampleQueryService.DeleteSampleQuery:input_type -> google.cloud.discoveryengine.v1beta.DeleteSampleQueryRequest
	8,  // 9: google.cloud.discoveryengine.v1beta.SampleQueryService.ImportSampleQueries:input_type -> google.cloud.discoveryengine.v1beta.ImportSampleQueriesRequest
	6,  // 10: google.cloud.discoveryengine.v1beta.SampleQueryService.GetSampleQuery:output_type -> google.cloud.discoveryengine.v1beta.SampleQuery
	2,  // 11: google.cloud.discoveryengine.v1beta.SampleQueryService.ListSampleQueries:output_type -> google.cloud.discoveryengine.v1beta.ListSampleQueriesResponse
	6,  // 12: google.cloud.discoveryengine.v1beta.SampleQueryService.CreateSampleQuery:output_type -> google.cloud.discoveryengine.v1beta.SampleQuery
	6,  // 13: google.cloud.discoveryengine.v1beta.SampleQueryService.UpdateSampleQuery:output_type -> google.cloud.discoveryengine.v1beta.SampleQuery
	9,  // 14: google.cloud.discoveryengine.v1beta.SampleQueryService.DeleteSampleQuery:output_type -> google.protobuf.Empty
	10, // 15: google.cloud.discoveryengine.v1beta.SampleQueryService.ImportSampleQueries:output_type -> google.longrunning.Operation
	10, // [10:16] is the sub-list for method output_type
	4,  // [4:10] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_init() }
func file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_sample_query_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_import_config_proto_init()
	file_google_cloud_discoveryengine_v1beta_sample_query_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_sample_query_service_proto = out.File
	file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_sample_query_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SampleQueryServiceClient is the client API for SampleQueryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SampleQueryServiceClient interface {
	// Gets a [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery].
	GetSampleQuery(ctx context.Context, in *GetSampleQueryRequest, opts ...grpc.CallOption) (*SampleQuery, error)
	// Gets a list of
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s.
	ListSampleQueries(ctx context.Context, in *ListSampleQueriesRequest, opts ...grpc.CallOption) (*ListSampleQueriesResponse, error)
	// Creates a [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
	CreateSampleQuery(ctx context.Context, in *CreateSampleQueryRequest, opts ...grpc.CallOption) (*SampleQuery, error)
	// Updates a [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery].
	UpdateSampleQuery(ctx context.Context, in *UpdateSampleQueryRequest, opts ...grpc.CallOption) (*SampleQuery, error)
	// Deletes a [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery].
	DeleteSampleQuery(ctx context.Context, in *DeleteSampleQueryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Bulk import of multiple
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s. Sample
	// queries that already exist may be deleted.
	//
	// Note: It is possible for a subset of the
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s to be
	// successfully imported.
	ImportSampleQueries(ctx context.Context, in *ImportSampleQueriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type sampleQueryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSampleQueryServiceClient(cc grpc.ClientConnInterface) SampleQueryServiceClient {
	return &sampleQueryServiceClient{cc}
}

func (c *sampleQueryServiceClient) GetSampleQuery(ctx context.Context, in *GetSampleQueryRequest, opts ...grpc.CallOption) (*SampleQuery, error) {
	out := new(SampleQuery)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQueryService/GetSampleQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sampleQueryServiceClient) ListSampleQueries(ctx context.Context, in *ListSampleQueriesRequest, opts ...grpc.CallOption) (*ListSampleQueriesResponse, error) {
	out := new(ListSampleQueriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQueryService/ListSampleQueries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sampleQueryServiceClient) CreateSampleQuery(ctx context.Context, in *CreateSampleQueryRequest, opts ...grpc.CallOption) (*SampleQuery, error) {
	out := new(SampleQuery)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQueryService/CreateSampleQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sampleQueryServiceClient) UpdateSampleQuery(ctx context.Context, in *UpdateSampleQueryRequest, opts ...grpc.CallOption) (*SampleQuery, error) {
	out := new(SampleQuery)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQueryService/UpdateSampleQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sampleQueryServiceClient) DeleteSampleQuery(ctx context.Context, in *DeleteSampleQueryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQueryService/DeleteSampleQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sampleQueryServiceClient) ImportSampleQueries(ctx context.Context, in *ImportSampleQueriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQueryService/ImportSampleQueries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SampleQueryServiceServer is the server API for SampleQueryService service.
type SampleQueryServiceServer interface {
	// Gets a [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery].
	GetSampleQuery(context.Context, *GetSampleQueryRequest) (*SampleQuery, error)
	// Gets a list of
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s.
	ListSampleQueries(context.Context, *ListSampleQueriesRequest) (*ListSampleQueriesResponse, error)
	// Creates a [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]
	CreateSampleQuery(context.Context, *CreateSampleQueryRequest) (*SampleQuery, error)
	// Updates a [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery].
	UpdateSampleQuery(context.Context, *UpdateSampleQueryRequest) (*SampleQuery, error)
	// Deletes a [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery].
	DeleteSampleQuery(context.Context, *DeleteSampleQueryRequest) (*emptypb.Empty, error)
	// Bulk import of multiple
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s. Sample
	// queries that already exist may be deleted.
	//
	// Note: It is possible for a subset of the
	// [SampleQuery][google.cloud.discoveryengine.v1beta.SampleQuery]s to be
	// successfully imported.
	ImportSampleQueries(context.Context, *ImportSampleQueriesRequest) (*longrunningpb.Operation, error)
}

// UnimplementedSampleQueryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSampleQueryServiceServer struct {
}

func (*UnimplementedSampleQueryServiceServer) GetSampleQuery(context.Context, *GetSampleQueryRequest) (*SampleQuery, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSampleQuery not implemented")
}
func (*UnimplementedSampleQueryServiceServer) ListSampleQueries(context.Context, *ListSampleQueriesRequest) (*ListSampleQueriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSampleQueries not implemented")
}
func (*UnimplementedSampleQueryServiceServer) CreateSampleQuery(context.Context, *CreateSampleQueryRequest) (*SampleQuery, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSampleQuery not implemented")
}
func (*UnimplementedSampleQueryServiceServer) UpdateSampleQuery(context.Context, *UpdateSampleQueryRequest) (*SampleQuery, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSampleQuery not implemented")
}
func (*UnimplementedSampleQueryServiceServer) DeleteSampleQuery(context.Context, *DeleteSampleQueryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSampleQuery not implemented")
}
func (*UnimplementedSampleQueryServiceServer) ImportSampleQueries(context.Context, *ImportSampleQueriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportSampleQueries not implemented")
}

func RegisterSampleQueryServiceServer(s *grpc.Server, srv SampleQueryServiceServer) {
	s.RegisterService(&_SampleQueryService_serviceDesc, srv)
}

func _SampleQueryService_GetSampleQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSampleQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQueryServiceServer).GetSampleQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQueryService/GetSampleQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQueryServiceServer).GetSampleQuery(ctx, req.(*GetSampleQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SampleQueryService_ListSampleQueries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSampleQueriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQueryServiceServer).ListSampleQueries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQueryService/ListSampleQueries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQueryServiceServer).ListSampleQueries(ctx, req.(*ListSampleQueriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SampleQueryService_CreateSampleQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSampleQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQueryServiceServer).CreateSampleQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQueryService/CreateSampleQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQueryServiceServer).CreateSampleQuery(ctx, req.(*CreateSampleQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SampleQueryService_UpdateSampleQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSampleQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQueryServiceServer).UpdateSampleQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQueryService/UpdateSampleQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQueryServiceServer).UpdateSampleQuery(ctx, req.(*UpdateSampleQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SampleQueryService_DeleteSampleQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSampleQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQueryServiceServer).DeleteSampleQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQueryService/DeleteSampleQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQueryServiceServer).DeleteSampleQuery(ctx, req.(*DeleteSampleQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SampleQueryService_ImportSampleQueries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportSampleQueriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQueryServiceServer).ImportSampleQueries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQueryService/ImportSampleQueries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQueryServiceServer).ImportSampleQueries(ctx, req.(*ImportSampleQueriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SampleQueryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1beta.SampleQueryService",
	HandlerType: (*SampleQueryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSampleQuery",
			Handler:    _SampleQueryService_GetSampleQuery_Handler,
		},
		{
			MethodName: "ListSampleQueries",
			Handler:    _SampleQueryService_ListSampleQueries_Handler,
		},
		{
			MethodName: "CreateSampleQuery",
			Handler:    _SampleQueryService_CreateSampleQuery_Handler,
		},
		{
			MethodName: "UpdateSampleQuery",
			Handler:    _SampleQueryService_UpdateSampleQuery_Handler,
		},
		{
			MethodName: "DeleteSampleQuery",
			Handler:    _SampleQueryService_DeleteSampleQuery_Handler,
		},
		{
			MethodName: "ImportSampleQueries",
			Handler:    _SampleQueryService_ImportSampleQueries_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1beta/sample_query_service.proto",
}
