// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/developerconnect/v1/developer_connect.proto

package developerconnectpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Stage of the installation process.
type InstallationState_Stage int32

const (
	// No stage specified.
	InstallationState_STAGE_UNSPECIFIED InstallationState_Stage = 0
	// Only for GitHub Enterprise. An App creation has been requested.
	// The user needs to confirm the creation in their GitHub enterprise host.
	InstallationState_PENDING_CREATE_APP InstallationState_Stage = 1
	// User needs to authorize the GitHub (or Enterprise) App via OAuth.
	InstallationState_PENDING_USER_OAUTH InstallationState_Stage = 2
	// User needs to follow the link to install the GitHub (or Enterprise) App.
	InstallationState_PENDING_INSTALL_APP InstallationState_Stage = 3
	// Installation process has been completed.
	InstallationState_COMPLETE InstallationState_Stage = 10
)

// Enum value maps for InstallationState_Stage.
var (
	InstallationState_Stage_name = map[int32]string{
		0:  "STAGE_UNSPECIFIED",
		1:  "PENDING_CREATE_APP",
		2:  "PENDING_USER_OAUTH",
		3:  "PENDING_INSTALL_APP",
		10: "COMPLETE",
	}
	InstallationState_Stage_value = map[string]int32{
		"STAGE_UNSPECIFIED":   0,
		"PENDING_CREATE_APP":  1,
		"PENDING_USER_OAUTH":  2,
		"PENDING_INSTALL_APP": 3,
		"COMPLETE":            10,
	}
)

func (x InstallationState_Stage) Enum() *InstallationState_Stage {
	p := new(InstallationState_Stage)
	*p = x
	return p
}

func (x InstallationState_Stage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstallationState_Stage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_enumTypes[0].Descriptor()
}

func (InstallationState_Stage) Type() protoreflect.EnumType {
	return &file_google_cloud_developerconnect_v1_developer_connect_proto_enumTypes[0]
}

func (x InstallationState_Stage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstallationState_Stage.Descriptor instead.
func (InstallationState_Stage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{2, 0}
}

// Represents the various GitHub Applications that can be installed to a
// GitHub user or organization and used with Developer Connect.
type GitHubConfig_GitHubApp int32

const (
	// GitHub App not specified.
	GitHubConfig_GIT_HUB_APP_UNSPECIFIED GitHubConfig_GitHubApp = 0
	// The Developer Connect GitHub Application.
	GitHubConfig_DEVELOPER_CONNECT GitHubConfig_GitHubApp = 1
	// The Firebase GitHub Application.
	GitHubConfig_FIREBASE GitHubConfig_GitHubApp = 2
)

// Enum value maps for GitHubConfig_GitHubApp.
var (
	GitHubConfig_GitHubApp_name = map[int32]string{
		0: "GIT_HUB_APP_UNSPECIFIED",
		1: "DEVELOPER_CONNECT",
		2: "FIREBASE",
	}
	GitHubConfig_GitHubApp_value = map[string]int32{
		"GIT_HUB_APP_UNSPECIFIED": 0,
		"DEVELOPER_CONNECT":       1,
		"FIREBASE":                2,
	}
)

func (x GitHubConfig_GitHubApp) Enum() *GitHubConfig_GitHubApp {
	p := new(GitHubConfig_GitHubApp)
	*p = x
	return p
}

func (x GitHubConfig_GitHubApp) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GitHubConfig_GitHubApp) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_enumTypes[1].Descriptor()
}

func (GitHubConfig_GitHubApp) Type() protoreflect.EnumType {
	return &file_google_cloud_developerconnect_v1_developer_connect_proto_enumTypes[1]
}

func (x GitHubConfig_GitHubApp) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GitHubConfig_GitHubApp.Descriptor instead.
func (GitHubConfig_GitHubApp) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{3, 0}
}

// Type of refs.
type FetchGitRefsRequest_RefType int32

const (
	// No type specified.
	FetchGitRefsRequest_REF_TYPE_UNSPECIFIED FetchGitRefsRequest_RefType = 0
	// To fetch tags.
	FetchGitRefsRequest_TAG FetchGitRefsRequest_RefType = 1
	// To fetch branches.
	FetchGitRefsRequest_BRANCH FetchGitRefsRequest_RefType = 2
)

// Enum value maps for FetchGitRefsRequest_RefType.
var (
	FetchGitRefsRequest_RefType_name = map[int32]string{
		0: "REF_TYPE_UNSPECIFIED",
		1: "TAG",
		2: "BRANCH",
	}
	FetchGitRefsRequest_RefType_value = map[string]int32{
		"REF_TYPE_UNSPECIFIED": 0,
		"TAG":                  1,
		"BRANCH":               2,
	}
)

func (x FetchGitRefsRequest_RefType) Enum() *FetchGitRefsRequest_RefType {
	p := new(FetchGitRefsRequest_RefType)
	*p = x
	return p
}

func (x FetchGitRefsRequest_RefType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FetchGitRefsRequest_RefType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_enumTypes[2].Descriptor()
}

func (FetchGitRefsRequest_RefType) Type() protoreflect.EnumType {
	return &file_google_cloud_developerconnect_v1_developer_connect_proto_enumTypes[2]
}

func (x FetchGitRefsRequest_RefType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FetchGitRefsRequest_RefType.Descriptor instead.
func (FetchGitRefsRequest_RefType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{32, 0}
}

// Message describing Connection object
type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for the connection depending on the type of provider.
	//
	// Types that are assignable to ConnectionConfig:
	//
	//	*Connection_GithubConfig
	//	*Connection_GithubEnterpriseConfig
	//	*Connection_GitlabConfig
	//	*Connection_GitlabEnterpriseConfig
	ConnectionConfig isConnection_ConnectionConfig `protobuf_oneof:"connection_config"`
	// Identifier. The resource name of the connection, in the format
	// `projects/{project}/locations/{location}/connections/{connection_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. [Output only] Create timestamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update timestamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. [Output only] Delete timestamp
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Optional. Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Installation state of the Connection.
	InstallationState *InstallationState `protobuf:"bytes,6,opt,name=installation_state,json=installationState,proto3" json:"installation_state,omitempty"`
	// Optional. If disabled is set to true, functionality is disabled for this
	// connection. Repository based API methods and webhooks processing for
	// repositories in this connection will be disabled.
	Disabled bool `protobuf:"varint,7,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Output only. Set to true when the connection is being set up or updated in
	// the background.
	Reconciling bool `protobuf:"varint,8,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Optional. Allows clients to store small amounts of arbitrary data.
	Annotations map[string]string `protobuf:"bytes,9,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. A system-assigned unique identifier for a the
	// GitRepositoryLink.
	Uid string `protobuf:"bytes,12,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. The crypto key configuration. This field is used by the
	// Customer-Managed Encryption Keys (CMEK) feature.
	CryptoKeyConfig *CryptoKeyConfig `protobuf:"bytes,15,opt,name=crypto_key_config,json=cryptoKeyConfig,proto3" json:"crypto_key_config,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{0}
}

func (m *Connection) GetConnectionConfig() isConnection_ConnectionConfig {
	if m != nil {
		return m.ConnectionConfig
	}
	return nil
}

func (x *Connection) GetGithubConfig() *GitHubConfig {
	if x, ok := x.GetConnectionConfig().(*Connection_GithubConfig); ok {
		return x.GithubConfig
	}
	return nil
}

func (x *Connection) GetGithubEnterpriseConfig() *GitHubEnterpriseConfig {
	if x, ok := x.GetConnectionConfig().(*Connection_GithubEnterpriseConfig); ok {
		return x.GithubEnterpriseConfig
	}
	return nil
}

func (x *Connection) GetGitlabConfig() *GitLabConfig {
	if x, ok := x.GetConnectionConfig().(*Connection_GitlabConfig); ok {
		return x.GitlabConfig
	}
	return nil
}

func (x *Connection) GetGitlabEnterpriseConfig() *GitLabEnterpriseConfig {
	if x, ok := x.GetConnectionConfig().(*Connection_GitlabEnterpriseConfig); ok {
		return x.GitlabEnterpriseConfig
	}
	return nil
}

func (x *Connection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Connection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Connection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Connection) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Connection) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Connection) GetInstallationState() *InstallationState {
	if x != nil {
		return x.InstallationState
	}
	return nil
}

func (x *Connection) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *Connection) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *Connection) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Connection) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Connection) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Connection) GetCryptoKeyConfig() *CryptoKeyConfig {
	if x != nil {
		return x.CryptoKeyConfig
	}
	return nil
}

type isConnection_ConnectionConfig interface {
	isConnection_ConnectionConfig()
}

type Connection_GithubConfig struct {
	// Configuration for connections to github.com.
	GithubConfig *GitHubConfig `protobuf:"bytes,5,opt,name=github_config,json=githubConfig,proto3,oneof"`
}

type Connection_GithubEnterpriseConfig struct {
	// Configuration for connections to an instance of GitHub Enterprise.
	GithubEnterpriseConfig *GitHubEnterpriseConfig `protobuf:"bytes,13,opt,name=github_enterprise_config,json=githubEnterpriseConfig,proto3,oneof"`
}

type Connection_GitlabConfig struct {
	// Configuration for connections to gitlab.com.
	GitlabConfig *GitLabConfig `protobuf:"bytes,14,opt,name=gitlab_config,json=gitlabConfig,proto3,oneof"`
}

type Connection_GitlabEnterpriseConfig struct {
	// Configuration for connections to an instance of GitLab Enterprise.
	GitlabEnterpriseConfig *GitLabEnterpriseConfig `protobuf:"bytes,16,opt,name=gitlab_enterprise_config,json=gitlabEnterpriseConfig,proto3,oneof"`
}

func (*Connection_GithubConfig) isConnection_ConnectionConfig() {}

func (*Connection_GithubEnterpriseConfig) isConnection_ConnectionConfig() {}

func (*Connection_GitlabConfig) isConnection_ConnectionConfig() {}

func (*Connection_GitlabEnterpriseConfig) isConnection_ConnectionConfig() {}

// The crypto key configuration. This field is used by the Customer-managed
// encryption keys (CMEK) feature.
type CryptoKeyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the key which is used to encrypt/decrypt customer
	// data. For key in Cloud KMS, the key should be in the format of
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	KeyReference string `protobuf:"bytes,1,opt,name=key_reference,json=keyReference,proto3" json:"key_reference,omitempty"`
}

func (x *CryptoKeyConfig) Reset() {
	*x = CryptoKeyConfig{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CryptoKeyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CryptoKeyConfig) ProtoMessage() {}

func (x *CryptoKeyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CryptoKeyConfig.ProtoReflect.Descriptor instead.
func (*CryptoKeyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{1}
}

func (x *CryptoKeyConfig) GetKeyReference() string {
	if x != nil {
		return x.KeyReference
	}
	return ""
}

// Describes stage and necessary actions to be taken by the
// user to complete the installation. Used for GitHub and GitHub Enterprise
// based connections.
type InstallationState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Current step of the installation process.
	Stage InstallationState_Stage `protobuf:"varint,1,opt,name=stage,proto3,enum=google.cloud.developerconnect.v1.InstallationState_Stage" json:"stage,omitempty"`
	// Output only. Message of what the user should do next to continue the
	// installation. Empty string if the installation is already complete.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Output only. Link to follow for next action. Empty string if the
	// installation is already complete.
	ActionUri string `protobuf:"bytes,3,opt,name=action_uri,json=actionUri,proto3" json:"action_uri,omitempty"`
}

func (x *InstallationState) Reset() {
	*x = InstallationState{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InstallationState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallationState) ProtoMessage() {}

func (x *InstallationState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallationState.ProtoReflect.Descriptor instead.
func (*InstallationState) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{2}
}

func (x *InstallationState) GetStage() InstallationState_Stage {
	if x != nil {
		return x.Stage
	}
	return InstallationState_STAGE_UNSPECIFIED
}

func (x *InstallationState) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *InstallationState) GetActionUri() string {
	if x != nil {
		return x.ActionUri
	}
	return ""
}

// Configuration for connections to github.com.
type GitHubConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The GitHub Application that was installed to the
	// GitHub user or organization.
	GithubApp GitHubConfig_GitHubApp `protobuf:"varint,1,opt,name=github_app,json=githubApp,proto3,enum=google.cloud.developerconnect.v1.GitHubConfig_GitHubApp" json:"github_app,omitempty"`
	// Optional. OAuth credential of the account that authorized the GitHub App.
	// It is recommended to use a robot account instead of a human user account.
	// The OAuth token must be tied to the GitHub App of this config.
	AuthorizerCredential *OAuthCredential `protobuf:"bytes,2,opt,name=authorizer_credential,json=authorizerCredential,proto3" json:"authorizer_credential,omitempty"`
	// Optional. GitHub App installation id.
	AppInstallationId int64 `protobuf:"varint,3,opt,name=app_installation_id,json=appInstallationId,proto3" json:"app_installation_id,omitempty"`
	// Output only. The URI to navigate to in order to manage the installation
	// associated with this GitHubConfig.
	InstallationUri string `protobuf:"bytes,4,opt,name=installation_uri,json=installationUri,proto3" json:"installation_uri,omitempty"`
}

func (x *GitHubConfig) Reset() {
	*x = GitHubConfig{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GitHubConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitHubConfig) ProtoMessage() {}

func (x *GitHubConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitHubConfig.ProtoReflect.Descriptor instead.
func (*GitHubConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{3}
}

func (x *GitHubConfig) GetGithubApp() GitHubConfig_GitHubApp {
	if x != nil {
		return x.GithubApp
	}
	return GitHubConfig_GIT_HUB_APP_UNSPECIFIED
}

func (x *GitHubConfig) GetAuthorizerCredential() *OAuthCredential {
	if x != nil {
		return x.AuthorizerCredential
	}
	return nil
}

func (x *GitHubConfig) GetAppInstallationId() int64 {
	if x != nil {
		return x.AppInstallationId
	}
	return 0
}

func (x *GitHubConfig) GetInstallationUri() string {
	if x != nil {
		return x.InstallationUri
	}
	return ""
}

// Configuration for connections to an instance of GitHub Enterprise.
type GitHubEnterpriseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI of the GitHub Enterprise host this connection is for.
	HostUri string `protobuf:"bytes,1,opt,name=host_uri,json=hostUri,proto3" json:"host_uri,omitempty"`
	// Optional. ID of the GitHub App created from the manifest.
	AppId int64 `protobuf:"varint,2,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// Output only. The URL-friendly name of the GitHub App.
	AppSlug string `protobuf:"bytes,3,opt,name=app_slug,json=appSlug,proto3" json:"app_slug,omitempty"`
	// Optional. SecretManager resource containing the private key of the GitHub
	// App, formatted as `projects/*/secrets/*/versions/*`.
	PrivateKeySecretVersion string `protobuf:"bytes,4,opt,name=private_key_secret_version,json=privateKeySecretVersion,proto3" json:"private_key_secret_version,omitempty"`
	// Optional. SecretManager resource containing the webhook secret of the
	// GitHub App, formatted as `projects/*/secrets/*/versions/*`.
	WebhookSecretSecretVersion string `protobuf:"bytes,5,opt,name=webhook_secret_secret_version,json=webhookSecretSecretVersion,proto3" json:"webhook_secret_secret_version,omitempty"`
	// Optional. ID of the installation of the GitHub App.
	AppInstallationId int64 `protobuf:"varint,8,opt,name=app_installation_id,json=appInstallationId,proto3" json:"app_installation_id,omitempty"`
	// Output only. The URI to navigate to in order to manage the installation
	// associated with this GitHubEnterpriseConfig.
	InstallationUri string `protobuf:"bytes,9,opt,name=installation_uri,json=installationUri,proto3" json:"installation_uri,omitempty"`
	// Optional. Configuration for using Service Directory to privately connect to
	// a GitHub Enterprise server. This should only be set if the GitHub
	// Enterprise server is hosted on-premises and not reachable by public
	// internet. If this field is left empty, calls to the GitHub Enterprise
	// server will be made over the public internet.
	ServiceDirectoryConfig *ServiceDirectoryConfig `protobuf:"bytes,10,opt,name=service_directory_config,json=serviceDirectoryConfig,proto3" json:"service_directory_config,omitempty"`
	// Output only. GitHub Enterprise version installed at the host_uri.
	ServerVersion string `protobuf:"bytes,12,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
	// Optional. SSL certificate to use for requests to GitHub Enterprise.
	SslCaCertificate string `protobuf:"bytes,14,opt,name=ssl_ca_certificate,json=sslCaCertificate,proto3" json:"ssl_ca_certificate,omitempty"`
}

func (x *GitHubEnterpriseConfig) Reset() {
	*x = GitHubEnterpriseConfig{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GitHubEnterpriseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitHubEnterpriseConfig) ProtoMessage() {}

func (x *GitHubEnterpriseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitHubEnterpriseConfig.ProtoReflect.Descriptor instead.
func (*GitHubEnterpriseConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{4}
}

func (x *GitHubEnterpriseConfig) GetHostUri() string {
	if x != nil {
		return x.HostUri
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetAppId() int64 {
	if x != nil {
		return x.AppId
	}
	return 0
}

func (x *GitHubEnterpriseConfig) GetAppSlug() string {
	if x != nil {
		return x.AppSlug
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetPrivateKeySecretVersion() string {
	if x != nil {
		return x.PrivateKeySecretVersion
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetWebhookSecretSecretVersion() string {
	if x != nil {
		return x.WebhookSecretSecretVersion
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetAppInstallationId() int64 {
	if x != nil {
		return x.AppInstallationId
	}
	return 0
}

func (x *GitHubEnterpriseConfig) GetInstallationUri() string {
	if x != nil {
		return x.InstallationUri
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetServiceDirectoryConfig() *ServiceDirectoryConfig {
	if x != nil {
		return x.ServiceDirectoryConfig
	}
	return nil
}

func (x *GitHubEnterpriseConfig) GetServerVersion() string {
	if x != nil {
		return x.ServerVersion
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetSslCaCertificate() string {
	if x != nil {
		return x.SslCaCertificate
	}
	return ""
}

// ServiceDirectoryConfig represents Service Directory configuration for a
// connection.
type ServiceDirectoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Service Directory service name.
	// Format:
	// projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *ServiceDirectoryConfig) Reset() {
	*x = ServiceDirectoryConfig{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceDirectoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceDirectoryConfig) ProtoMessage() {}

func (x *ServiceDirectoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceDirectoryConfig.ProtoReflect.Descriptor instead.
func (*ServiceDirectoryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{5}
}

func (x *ServiceDirectoryConfig) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

// Represents an OAuth token of the account that authorized the Connection,
// and associated metadata.
type OAuthCredential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A SecretManager resource containing the OAuth token that
	// authorizes the connection. Format: `projects/*/secrets/*/versions/*`.
	OauthTokenSecretVersion string `protobuf:"bytes,1,opt,name=oauth_token_secret_version,json=oauthTokenSecretVersion,proto3" json:"oauth_token_secret_version,omitempty"`
	// Output only. The username associated with this token.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *OAuthCredential) Reset() {
	*x = OAuthCredential{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OAuthCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuthCredential) ProtoMessage() {}

func (x *OAuthCredential) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuthCredential.ProtoReflect.Descriptor instead.
func (*OAuthCredential) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{6}
}

func (x *OAuthCredential) GetOauthTokenSecretVersion() string {
	if x != nil {
		return x.OauthTokenSecretVersion
	}
	return ""
}

func (x *OAuthCredential) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Configuration for connections to gitlab.com.
type GitLabConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. SecretManager resource containing the webhook secret
	// of a GitLab project, formatted as `projects/*/secrets/*/versions/*`. This
	// is used to validate webhooks.
	WebhookSecretSecretVersion string `protobuf:"bytes,1,opt,name=webhook_secret_secret_version,json=webhookSecretSecretVersion,proto3" json:"webhook_secret_secret_version,omitempty"`
	// Required. A GitLab personal access token with the minimum `read_api` scope
	// access and a minimum role of `reporter`. The GitLab Projects visible to
	// this Personal Access Token will control which Projects Developer Connect
	// has access to.
	ReadAuthorizerCredential *UserCredential `protobuf:"bytes,2,opt,name=read_authorizer_credential,json=readAuthorizerCredential,proto3" json:"read_authorizer_credential,omitempty"`
	// Required. A GitLab personal access token with the minimum `api` scope
	// access and a minimum role of `maintainer`. The GitLab Projects visible to
	// this Personal Access Token will control which Projects Developer Connect
	// has access to.
	AuthorizerCredential *UserCredential `protobuf:"bytes,3,opt,name=authorizer_credential,json=authorizerCredential,proto3" json:"authorizer_credential,omitempty"`
}

func (x *GitLabConfig) Reset() {
	*x = GitLabConfig{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GitLabConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitLabConfig) ProtoMessage() {}

func (x *GitLabConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitLabConfig.ProtoReflect.Descriptor instead.
func (*GitLabConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{7}
}

func (x *GitLabConfig) GetWebhookSecretSecretVersion() string {
	if x != nil {
		return x.WebhookSecretSecretVersion
	}
	return ""
}

func (x *GitLabConfig) GetReadAuthorizerCredential() *UserCredential {
	if x != nil {
		return x.ReadAuthorizerCredential
	}
	return nil
}

func (x *GitLabConfig) GetAuthorizerCredential() *UserCredential {
	if x != nil {
		return x.AuthorizerCredential
	}
	return nil
}

// Represents a personal access token that authorized the Connection,
// and associated metadata.
type UserCredential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A SecretManager resource containing the user token that
	// authorizes the Developer Connect connection. Format:
	// `projects/*/secrets/*/versions/*`.
	UserTokenSecretVersion string `protobuf:"bytes,1,opt,name=user_token_secret_version,json=userTokenSecretVersion,proto3" json:"user_token_secret_version,omitempty"`
	// Output only. The username associated with this token.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *UserCredential) Reset() {
	*x = UserCredential{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCredential) ProtoMessage() {}

func (x *UserCredential) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCredential.ProtoReflect.Descriptor instead.
func (*UserCredential) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{8}
}

func (x *UserCredential) GetUserTokenSecretVersion() string {
	if x != nil {
		return x.UserTokenSecretVersion
	}
	return ""
}

func (x *UserCredential) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Configuration for connections to an instance of GitLab Enterprise.
type GitLabEnterpriseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI of the GitLab Enterprise host this connection is for.
	HostUri string `protobuf:"bytes,1,opt,name=host_uri,json=hostUri,proto3" json:"host_uri,omitempty"`
	// Required. Immutable. SecretManager resource containing the webhook secret
	// of a GitLab project, formatted as `projects/*/secrets/*/versions/*`. This
	// is used to validate webhooks.
	WebhookSecretSecretVersion string `protobuf:"bytes,2,opt,name=webhook_secret_secret_version,json=webhookSecretSecretVersion,proto3" json:"webhook_secret_secret_version,omitempty"`
	// Required. A GitLab personal access token with the minimum `read_api` scope
	// access and a minimum role of `reporter`. The GitLab Projects visible to
	// this Personal Access Token will control which Projects Developer Connect
	// has access to.
	ReadAuthorizerCredential *UserCredential `protobuf:"bytes,3,opt,name=read_authorizer_credential,json=readAuthorizerCredential,proto3" json:"read_authorizer_credential,omitempty"`
	// Required. A GitLab personal access token with the minimum `api` scope
	// access and a minimum role of `maintainer`. The GitLab Projects visible to
	// this Personal Access Token will control which Projects Developer Connect
	// has access to.
	AuthorizerCredential *UserCredential `protobuf:"bytes,4,opt,name=authorizer_credential,json=authorizerCredential,proto3" json:"authorizer_credential,omitempty"`
	// Optional. Configuration for using Service Directory to privately connect to
	// a GitLab Enterprise instance. This should only be set if the GitLab
	// Enterprise server is hosted on-premises and not reachable by public
	// internet. If this field is left empty, calls to the GitLab Enterprise
	// server will be made over the public internet.
	ServiceDirectoryConfig *ServiceDirectoryConfig `protobuf:"bytes,5,opt,name=service_directory_config,json=serviceDirectoryConfig,proto3" json:"service_directory_config,omitempty"`
	// Optional. SSL Certificate Authority certificate to use for requests to
	// GitLab Enterprise instance.
	SslCaCertificate string `protobuf:"bytes,6,opt,name=ssl_ca_certificate,json=sslCaCertificate,proto3" json:"ssl_ca_certificate,omitempty"`
	// Output only. Version of the GitLab Enterprise server running on the
	// `host_uri`.
	ServerVersion string `protobuf:"bytes,7,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
}

func (x *GitLabEnterpriseConfig) Reset() {
	*x = GitLabEnterpriseConfig{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GitLabEnterpriseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitLabEnterpriseConfig) ProtoMessage() {}

func (x *GitLabEnterpriseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitLabEnterpriseConfig.ProtoReflect.Descriptor instead.
func (*GitLabEnterpriseConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{9}
}

func (x *GitLabEnterpriseConfig) GetHostUri() string {
	if x != nil {
		return x.HostUri
	}
	return ""
}

func (x *GitLabEnterpriseConfig) GetWebhookSecretSecretVersion() string {
	if x != nil {
		return x.WebhookSecretSecretVersion
	}
	return ""
}

func (x *GitLabEnterpriseConfig) GetReadAuthorizerCredential() *UserCredential {
	if x != nil {
		return x.ReadAuthorizerCredential
	}
	return nil
}

func (x *GitLabEnterpriseConfig) GetAuthorizerCredential() *UserCredential {
	if x != nil {
		return x.AuthorizerCredential
	}
	return nil
}

func (x *GitLabEnterpriseConfig) GetServiceDirectoryConfig() *ServiceDirectoryConfig {
	if x != nil {
		return x.ServiceDirectoryConfig
	}
	return nil
}

func (x *GitLabEnterpriseConfig) GetSslCaCertificate() string {
	if x != nil {
		return x.SslCaCertificate
	}
	return ""
}

func (x *GitLabEnterpriseConfig) GetServerVersion() string {
	if x != nil {
		return x.ServerVersion
	}
	return ""
}

// Message for requesting list of Connections
type ListConnectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListConnectionsRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListConnectionsRequest) Reset() {
	*x = ListConnectionsRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConnectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionsRequest) ProtoMessage() {}

func (x *ListConnectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionsRequest.ProtoReflect.Descriptor instead.
func (*ListConnectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{10}
}

func (x *ListConnectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConnectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConnectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConnectionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListConnectionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Connections
type ListConnectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Connection
	Connections []*Connection `protobuf:"bytes,1,rep,name=connections,proto3" json:"connections,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListConnectionsResponse) Reset() {
	*x = ListConnectionsResponse{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConnectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionsResponse) ProtoMessage() {}

func (x *ListConnectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionsResponse.ProtoReflect.Descriptor instead.
func (*ListConnectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{11}
}

func (x *ListConnectionsResponse) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

func (x *ListConnectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListConnectionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Connection
type GetConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConnectionRequest) Reset() {
	*x = GetConnectionRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectionRequest) ProtoMessage() {}

func (x *GetConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectionRequest.ProtoReflect.Descriptor instead.
func (*GetConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{12}
}

func (x *GetConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a Connection
type CreateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object
	// If auto-generating Id server-side, remove this field and
	// connection_id from the method_signature of Create RPC
	ConnectionId string `protobuf:"bytes,2,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	// Required. The resource being created
	Connection *Connection `protobuf:"bytes,3,opt,name=connection,proto3" json:"connection,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validate the request, but do not actually post it.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateConnectionRequest) Reset() {
	*x = CreateConnectionRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectionRequest) ProtoMessage() {}

func (x *CreateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectionRequest.ProtoReflect.Descriptor instead.
func (*CreateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{13}
}

func (x *CreateConnectionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConnectionRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *CreateConnectionRequest) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

func (x *CreateConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateConnectionRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for updating a Connection
type UpdateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Connection resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	Connection *Connection `protobuf:"bytes,2,opt,name=connection,proto3" json:"connection,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, and the connection is not found a new connection
	// will be created. In this situation `update_mask` is ignored.
	// The creation will succeed only if the input connection has all the
	// necessary information (e.g a github_config with both  user_oauth_token and
	// installation_id properties).
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set, validate the request, but do not actually post it.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateConnectionRequest) Reset() {
	*x = UpdateConnectionRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConnectionRequest) ProtoMessage() {}

func (x *UpdateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConnectionRequest.ProtoReflect.Descriptor instead.
func (*UpdateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateConnectionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConnectionRequest) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

func (x *UpdateConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateConnectionRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateConnectionRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for deleting a Connection
type DeleteConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validate the request, but do not actually post it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. The current etag of the Connection.
	// If an etag is provided and does not match the current etag of the
	// Connection, deletion will be blocked and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteConnectionRequest) Reset() {
	*x = DeleteConnectionRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConnectionRequest) ProtoMessage() {}

func (x *DeleteConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConnectionRequest.ProtoReflect.Descriptor instead.
func (*DeleteConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteConnectionRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteConnectionRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been cancelled successfully
	// have
	// [google.longrunning.Operation.error][google.longrunning.Operation.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{16}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Message describing the GitRepositoryLink object
type GitRepositoryLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Resource name of the repository, in the format
	// `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Git Clone URI.
	CloneUri string `protobuf:"bytes,2,opt,name=clone_uri,json=cloneUri,proto3" json:"clone_uri,omitempty"`
	// Output only. [Output only] Create timestamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update timestamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. [Output only] Delete timestamp
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Optional. Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Set to true when the connection is being set up or updated in
	// the background.
	Reconciling bool `protobuf:"varint,8,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Optional. Allows clients to store small amounts of arbitrary data.
	Annotations map[string]string `protobuf:"bytes,9,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. A system-assigned unique identifier for a the
	// GitRepositoryLink.
	Uid string `protobuf:"bytes,10,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. External ID of the webhook created for the repository.
	WebhookId string `protobuf:"bytes,11,opt,name=webhook_id,json=webhookId,proto3" json:"webhook_id,omitempty"`
}

func (x *GitRepositoryLink) Reset() {
	*x = GitRepositoryLink{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GitRepositoryLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitRepositoryLink) ProtoMessage() {}

func (x *GitRepositoryLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitRepositoryLink.ProtoReflect.Descriptor instead.
func (*GitRepositoryLink) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{17}
}

func (x *GitRepositoryLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GitRepositoryLink) GetCloneUri() string {
	if x != nil {
		return x.CloneUri
	}
	return ""
}

func (x *GitRepositoryLink) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GitRepositoryLink) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *GitRepositoryLink) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *GitRepositoryLink) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *GitRepositoryLink) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *GitRepositoryLink) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *GitRepositoryLink) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *GitRepositoryLink) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *GitRepositoryLink) GetWebhookId() string {
	if x != nil {
		return x.WebhookId
	}
	return ""
}

// Message for creating a GitRepositoryLink
type CreateGitRepositoryLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource being created
	GitRepositoryLink *GitRepositoryLink `protobuf:"bytes,2,opt,name=git_repository_link,json=gitRepositoryLink,proto3" json:"git_repository_link,omitempty"`
	// Required. The ID to use for the repository, which will become the final
	// component of the repository's resource name. This ID should be unique in
	// the connection. Allows alphanumeric characters and any of
	// -._~%!$&'()*+,;=@.
	GitRepositoryLinkId string `protobuf:"bytes,3,opt,name=git_repository_link_id,json=gitRepositoryLinkId,proto3" json:"git_repository_link_id,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validate the request, but do not actually post it.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateGitRepositoryLinkRequest) Reset() {
	*x = CreateGitRepositoryLinkRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGitRepositoryLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGitRepositoryLinkRequest) ProtoMessage() {}

func (x *CreateGitRepositoryLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGitRepositoryLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateGitRepositoryLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{18}
}

func (x *CreateGitRepositoryLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGitRepositoryLinkRequest) GetGitRepositoryLink() *GitRepositoryLink {
	if x != nil {
		return x.GitRepositoryLink
	}
	return nil
}

func (x *CreateGitRepositoryLinkRequest) GetGitRepositoryLinkId() string {
	if x != nil {
		return x.GitRepositoryLinkId
	}
	return ""
}

func (x *CreateGitRepositoryLinkRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateGitRepositoryLinkRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for deleting a GitRepositoryLink
type DeleteGitRepositoryLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validate the request, but do not actually post it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteGitRepositoryLinkRequest) Reset() {
	*x = DeleteGitRepositoryLinkRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteGitRepositoryLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGitRepositoryLinkRequest) ProtoMessage() {}

func (x *DeleteGitRepositoryLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGitRepositoryLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteGitRepositoryLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteGitRepositoryLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteGitRepositoryLinkRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteGitRepositoryLinkRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteGitRepositoryLinkRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Message for requesting a list of GitRepositoryLinks
type ListGitRepositoryLinksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListGitRepositoryLinksRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListGitRepositoryLinksRequest) Reset() {
	*x = ListGitRepositoryLinksRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGitRepositoryLinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGitRepositoryLinksRequest) ProtoMessage() {}

func (x *ListGitRepositoryLinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGitRepositoryLinksRequest.ProtoReflect.Descriptor instead.
func (*ListGitRepositoryLinksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{20}
}

func (x *ListGitRepositoryLinksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGitRepositoryLinksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGitRepositoryLinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGitRepositoryLinksRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListGitRepositoryLinksRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing GitRepositoryLinks
type ListGitRepositoryLinksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of GitRepositoryLinks
	GitRepositoryLinks []*GitRepositoryLink `protobuf:"bytes,1,rep,name=git_repository_links,json=gitRepositoryLinks,proto3" json:"git_repository_links,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListGitRepositoryLinksResponse) Reset() {
	*x = ListGitRepositoryLinksResponse{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGitRepositoryLinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGitRepositoryLinksResponse) ProtoMessage() {}

func (x *ListGitRepositoryLinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGitRepositoryLinksResponse.ProtoReflect.Descriptor instead.
func (*ListGitRepositoryLinksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{21}
}

func (x *ListGitRepositoryLinksResponse) GetGitRepositoryLinks() []*GitRepositoryLink {
	if x != nil {
		return x.GitRepositoryLinks
	}
	return nil
}

func (x *ListGitRepositoryLinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListGitRepositoryLinksResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a GitRepositoryLink
type GetGitRepositoryLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGitRepositoryLinkRequest) Reset() {
	*x = GetGitRepositoryLinkRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGitRepositoryLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGitRepositoryLinkRequest) ProtoMessage() {}

func (x *GetGitRepositoryLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGitRepositoryLinkRequest.ProtoReflect.Descriptor instead.
func (*GetGitRepositoryLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{22}
}

func (x *GetGitRepositoryLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for fetching SCM read/write token.
type FetchReadWriteTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the gitRepositoryLink in the format
	// `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
	GitRepositoryLink string `protobuf:"bytes,1,opt,name=git_repository_link,json=gitRepositoryLink,proto3" json:"git_repository_link,omitempty"`
}

func (x *FetchReadWriteTokenRequest) Reset() {
	*x = FetchReadWriteTokenRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchReadWriteTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReadWriteTokenRequest) ProtoMessage() {}

func (x *FetchReadWriteTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReadWriteTokenRequest.ProtoReflect.Descriptor instead.
func (*FetchReadWriteTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{23}
}

func (x *FetchReadWriteTokenRequest) GetGitRepositoryLink() string {
	if x != nil {
		return x.GitRepositoryLink
	}
	return ""
}

// Message for fetching SCM read token.
type FetchReadTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the gitRepositoryLink in the format
	// `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
	GitRepositoryLink string `protobuf:"bytes,1,opt,name=git_repository_link,json=gitRepositoryLink,proto3" json:"git_repository_link,omitempty"`
}

func (x *FetchReadTokenRequest) Reset() {
	*x = FetchReadTokenRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchReadTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReadTokenRequest) ProtoMessage() {}

func (x *FetchReadTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReadTokenRequest.ProtoReflect.Descriptor instead.
func (*FetchReadTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{24}
}

func (x *FetchReadTokenRequest) GetGitRepositoryLink() string {
	if x != nil {
		return x.GitRepositoryLink
	}
	return ""
}

// Message for responding to get read token.
type FetchReadTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The token content.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Expiration timestamp. Can be empty if unknown or non-expiring.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// The git_username to specify when making a git clone with the
	// token. For example, for GitHub GitRepositoryLinks, this would be
	// "x-access-token"
	GitUsername string `protobuf:"bytes,3,opt,name=git_username,json=gitUsername,proto3" json:"git_username,omitempty"`
}

func (x *FetchReadTokenResponse) Reset() {
	*x = FetchReadTokenResponse{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchReadTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReadTokenResponse) ProtoMessage() {}

func (x *FetchReadTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReadTokenResponse.ProtoReflect.Descriptor instead.
func (*FetchReadTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{25}
}

func (x *FetchReadTokenResponse) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *FetchReadTokenResponse) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *FetchReadTokenResponse) GetGitUsername() string {
	if x != nil {
		return x.GitUsername
	}
	return ""
}

// Message for responding to get read/write token.
type FetchReadWriteTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The token content.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Expiration timestamp. Can be empty if unknown or non-expiring.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// The git_username to specify when making a git clone with the
	// token. For example, for GitHub GitRepositoryLinks, this would be
	// "x-access-token"
	GitUsername string `protobuf:"bytes,3,opt,name=git_username,json=gitUsername,proto3" json:"git_username,omitempty"`
}

func (x *FetchReadWriteTokenResponse) Reset() {
	*x = FetchReadWriteTokenResponse{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchReadWriteTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReadWriteTokenResponse) ProtoMessage() {}

func (x *FetchReadWriteTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReadWriteTokenResponse.ProtoReflect.Descriptor instead.
func (*FetchReadWriteTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{26}
}

func (x *FetchReadWriteTokenResponse) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *FetchReadWriteTokenResponse) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *FetchReadWriteTokenResponse) GetGitUsername() string {
	if x != nil {
		return x.GitUsername
	}
	return ""
}

// Request message for FetchLinkableGitRepositoriesRequest.
type FetchLinkableGitRepositoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Connection.
	// Format: `projects/*/locations/*/connections/*`.
	Connection string `protobuf:"bytes,1,opt,name=connection,proto3" json:"connection,omitempty"`
	// Optional. Number of results to return in the list. Defaults to 20.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page start.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *FetchLinkableGitRepositoriesRequest) Reset() {
	*x = FetchLinkableGitRepositoriesRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchLinkableGitRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchLinkableGitRepositoriesRequest) ProtoMessage() {}

func (x *FetchLinkableGitRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchLinkableGitRepositoriesRequest.ProtoReflect.Descriptor instead.
func (*FetchLinkableGitRepositoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{27}
}

func (x *FetchLinkableGitRepositoriesRequest) GetConnection() string {
	if x != nil {
		return x.Connection
	}
	return ""
}

func (x *FetchLinkableGitRepositoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchLinkableGitRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for FetchLinkableGitRepositories.
type FetchLinkableGitRepositoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The git repositories that can be linked to the connection.
	LinkableGitRepositories []*LinkableGitRepository `protobuf:"bytes,1,rep,name=linkable_git_repositories,json=linkableGitRepositories,proto3" json:"linkable_git_repositories,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *FetchLinkableGitRepositoriesResponse) Reset() {
	*x = FetchLinkableGitRepositoriesResponse{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchLinkableGitRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchLinkableGitRepositoriesResponse) ProtoMessage() {}

func (x *FetchLinkableGitRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchLinkableGitRepositoriesResponse.ProtoReflect.Descriptor instead.
func (*FetchLinkableGitRepositoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{28}
}

func (x *FetchLinkableGitRepositoriesResponse) GetLinkableGitRepositories() []*LinkableGitRepository {
	if x != nil {
		return x.LinkableGitRepositories
	}
	return nil
}

func (x *FetchLinkableGitRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// LinkableGitRepository represents a git repository that can be linked to a
// connection.
type LinkableGitRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The clone uri of the repository.
	CloneUri string `protobuf:"bytes,1,opt,name=clone_uri,json=cloneUri,proto3" json:"clone_uri,omitempty"`
}

func (x *LinkableGitRepository) Reset() {
	*x = LinkableGitRepository{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LinkableGitRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkableGitRepository) ProtoMessage() {}

func (x *LinkableGitRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkableGitRepository.ProtoReflect.Descriptor instead.
func (*LinkableGitRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{29}
}

func (x *LinkableGitRepository) GetCloneUri() string {
	if x != nil {
		return x.CloneUri
	}
	return ""
}

// Request for fetching github installations.
type FetchGitHubInstallationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the connection in the format
	// `projects/*/locations/*/connections/*`.
	Connection string `protobuf:"bytes,1,opt,name=connection,proto3" json:"connection,omitempty"`
}

func (x *FetchGitHubInstallationsRequest) Reset() {
	*x = FetchGitHubInstallationsRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchGitHubInstallationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchGitHubInstallationsRequest) ProtoMessage() {}

func (x *FetchGitHubInstallationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchGitHubInstallationsRequest.ProtoReflect.Descriptor instead.
func (*FetchGitHubInstallationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{30}
}

func (x *FetchGitHubInstallationsRequest) GetConnection() string {
	if x != nil {
		return x.Connection
	}
	return ""
}

// Response of fetching github installations.
type FetchGitHubInstallationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of installations available to the OAuth user (for github.com)
	// or all the installations (for GitHub enterprise).
	Installations []*FetchGitHubInstallationsResponse_Installation `protobuf:"bytes,1,rep,name=installations,proto3" json:"installations,omitempty"`
}

func (x *FetchGitHubInstallationsResponse) Reset() {
	*x = FetchGitHubInstallationsResponse{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchGitHubInstallationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchGitHubInstallationsResponse) ProtoMessage() {}

func (x *FetchGitHubInstallationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchGitHubInstallationsResponse.ProtoReflect.Descriptor instead.
func (*FetchGitHubInstallationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{31}
}

func (x *FetchGitHubInstallationsResponse) GetInstallations() []*FetchGitHubInstallationsResponse_Installation {
	if x != nil {
		return x.Installations
	}
	return nil
}

// Request for fetching git refs.
type FetchGitRefsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of GitRepositoryLink in the format
	// `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
	GitRepositoryLink string `protobuf:"bytes,1,opt,name=git_repository_link,json=gitRepositoryLink,proto3" json:"git_repository_link,omitempty"`
	// Required. Type of refs to fetch.
	RefType FetchGitRefsRequest_RefType `protobuf:"varint,2,opt,name=ref_type,json=refType,proto3,enum=google.cloud.developerconnect.v1.FetchGitRefsRequest_RefType" json:"ref_type,omitempty"`
	// Optional. Number of results to return in the list. Default to 20.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page start.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *FetchGitRefsRequest) Reset() {
	*x = FetchGitRefsRequest{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchGitRefsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchGitRefsRequest) ProtoMessage() {}

func (x *FetchGitRefsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchGitRefsRequest.ProtoReflect.Descriptor instead.
func (*FetchGitRefsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{32}
}

func (x *FetchGitRefsRequest) GetGitRepositoryLink() string {
	if x != nil {
		return x.GitRepositoryLink
	}
	return ""
}

func (x *FetchGitRefsRequest) GetRefType() FetchGitRefsRequest_RefType {
	if x != nil {
		return x.RefType
	}
	return FetchGitRefsRequest_REF_TYPE_UNSPECIFIED
}

func (x *FetchGitRefsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchGitRefsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for fetching git refs.
type FetchGitRefsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the refs fetched.
	RefNames []string `protobuf:"bytes,1,rep,name=ref_names,json=refNames,proto3" json:"ref_names,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *FetchGitRefsResponse) Reset() {
	*x = FetchGitRefsResponse{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchGitRefsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchGitRefsResponse) ProtoMessage() {}

func (x *FetchGitRefsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchGitRefsResponse.ProtoReflect.Descriptor instead.
func (*FetchGitRefsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{33}
}

func (x *FetchGitRefsResponse) GetRefNames() []string {
	if x != nil {
		return x.RefNames
	}
	return nil
}

func (x *FetchGitRefsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents an installation of the GitHub App.
type FetchGitHubInstallationsResponse_Installation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the installation in GitHub.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the GitHub user or organization that owns this installation.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Either "user" or "organization".
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *FetchGitHubInstallationsResponse_Installation) Reset() {
	*x = FetchGitHubInstallationsResponse_Installation{}
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchGitHubInstallationsResponse_Installation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchGitHubInstallationsResponse_Installation) ProtoMessage() {}

func (x *FetchGitHubInstallationsResponse_Installation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchGitHubInstallationsResponse_Installation.ProtoReflect.Descriptor instead.
func (*FetchGitHubInstallationsResponse_Installation) Descriptor() ([]byte, []int) {
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP(), []int{31, 0}
}

func (x *FetchGitHubInstallationsResponse_Installation) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *FetchGitHubInstallationsResponse_Installation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FetchGitHubInstallationsResponse_Installation) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

var File_google_cloud_developerconnect_v1_developer_connect_proto protoreflect.FileDescriptor

var file_google_cloud_developerconnect_v1_developer_connect_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2f,
	0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xb0, 0x0b, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x55, 0x0a, 0x0d, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x48, 0x75,
	0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x18, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74,
	0x48, 0x75, 0x62, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x16, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x45, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a,
	0x0d, 0x67, 0x69, 0x74, 0x6c, 0x61, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x4c, 0x61, 0x62, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x67, 0x69, 0x74, 0x6c, 0x61, 0x62, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x18, 0x67, 0x69, 0x74, 0x6c, 0x61, 0x62, 0x5f, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x4c, 0x61, 0x62,
	0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x16, 0x67, 0x69, 0x74, 0x6c, 0x61, 0x62, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x67, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65,
	0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65,
	0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e,
	0x67, 0x12, 0x64, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0,
	0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12,
	0x62, 0x0a, 0x11, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e,
	0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x8e,
	0x01, 0xea, 0x41, 0x8a, 0x01, 0x0a, 0x2a, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x32, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x01, 0x01, 0x42,
	0x13, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x61, 0x0a, 0x0f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x6b, 0x65, 0x79, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xa3, 0x02, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x54, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65,
	0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x2e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x55, 0x72, 0x69, 0x22, 0x75, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4f,
	0x41, 0x55, 0x54, 0x48, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x5f, 0x41, 0x50, 0x50, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x0a, 0x22, 0x90, 0x03,
	0x0a, 0x0c, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f,
	0x0a, 0x0a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x5f, 0x61, 0x70, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x41, 0x70, 0x70, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x41, 0x70, 0x70, 0x12,
	0x6b, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x63, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x33, 0x0a, 0x13,
	0x61, 0x70, 0x70, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x61, 0x70, 0x70, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x2e, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72,
	0x69, 0x22, 0x4d, 0x0a, 0x09, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x41, 0x70, 0x70, 0x12, 0x1b,
	0x0a, 0x17, 0x47, 0x49, 0x54, 0x5f, 0x48, 0x55, 0x42, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x44,
	0x45, 0x56, 0x45, 0x4c, 0x4f, 0x50, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x49, 0x52, 0x45, 0x42, 0x41, 0x53, 0x45, 0x10, 0x02,
	0x22, 0x99, 0x05, 0x0a, 0x16, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x45, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x08, 0x68,
	0x6f, 0x73, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x55, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x06, 0x61,
	0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x61, 0x70, 0x70, 0x5f, 0x73,
	0x6c, 0x75, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x61, 0x70, 0x70, 0x53, 0x6c, 0x75, 0x67, 0x12, 0x6f, 0x0a, 0x1a, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x17, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x75, 0x0a, 0x1d, 0x77, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x32, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x1a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x33, 0x0a, 0x13, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x11, 0x61, 0x70, 0x70, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x55, 0x72, 0x69, 0x12, 0x77, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a,
	0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x73, 0x6c,
	0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x73, 0x6c, 0x43,
	0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22, 0x63, 0x0a, 0x16,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x22, 0xa3, 0x01, 0x0a, 0x0f, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x6f, 0x0a, 0x1a, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x6f,
	0x61, 0x75, 0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe9, 0x02, 0x0a, 0x0c, 0x47, 0x69, 0x74, 0x4c,
	0x61, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x78, 0x0a, 0x1d, 0x77, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x35, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x1a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x1a, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x72,
	0x65, 0x61, 0x64, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x72, 0x43, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x6a, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x22, 0xa0, 0x01, 0x0a, 0x0e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x6d, 0x0a, 0x19, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x75,
	0x73, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xeb, 0x04, 0x0a, 0x16, 0x47, 0x69, 0x74, 0x4c, 0x61,
	0x62, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1e, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x68, 0x6f, 0x73, 0x74, 0x55, 0x72,
	0x69, 0x12, 0x78, 0x0a, 0x1d, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05,
	0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x1a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x1a, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x63,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x72, 0x65, 0x61, 0x64, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x12, 0x6a, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x63,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x77, 0x0a, 0x18,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x73, 0x6c, 0x5f, 0x63, 0x61, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x73, 0x6c, 0x43, 0x61, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0xe7, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb3,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x5e, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb8, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x51, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0,
	0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22,
	0xae, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x51, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x22, 0xd0, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf,
	0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a,
	0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xac, 0x07, 0x0a, 0x11,
	0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6c,
	0x6f, 0x6e, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x55, 0x72, 0x69, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67,
	0x12, 0x6b, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1d, 0x0a,
	0x03, 0x75, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2,
	0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x22, 0x0a, 0x0a,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xcc, 0x01, 0xea, 0x41,
	0xc8, 0x01, 0x0a, 0x31, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x69, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x67, 0x69, 0x74, 0x5f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x7d,
	0x2a, 0x12, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x32, 0x11, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x01, 0x01, 0x22, 0xed, 0x02, 0x0a, 0x1e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x68, 0x0a, 0x13, 0x67, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69,
	0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x38, 0x0a, 0x16, 0x67, 0x69,
	0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x13, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69,
	0x6e, 0x6b, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf,
	0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xde, 0x01, 0x0a, 0x1e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x33, 0x0a, 0x31, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xf5, 0x01, 0x0a, 0x1d,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x22, 0xd1, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x69, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x67, 0x69, 0x74, 0x5f, 0x72, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x12, 0x67, 0x69, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x6c, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x47, 0x69,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x69,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x87, 0x01, 0x0a, 0x1a, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x13, 0x67, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x64, 0x65, 0x76, 0x65, 0x6c,
	0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x69, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x11, 0x67, 0x69,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x22,
	0x82, 0x01, 0x0a, 0x15, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x13, 0x67, 0x69, 0x74,
	0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31,
	0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e,
	0x6b, 0x52, 0x11, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x96, 0x01, 0x0a, 0x16, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65,
	0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x67, 0x69,
	0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x67, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9b, 0x01,
	0x0a, 0x1b, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x67, 0x69, 0x74, 0x5f,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x67, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbf, 0x01, 0x0a, 0x23,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x69, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc3, 0x01,
	0x0a, 0x24, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x47,
	0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x73, 0x0a, 0x19, 0x6c, 0x69, 0x6e, 0x6b, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x67, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e,
	0x6b, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x17, 0x6c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x34, 0x0a, 0x15, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x47,
	0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1b, 0x0a, 0x09,
	0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x55, 0x72, 0x69, 0x22, 0x75, 0x0a, 0x1f, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xe1, 0x01, 0x0a, 0x20, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x75, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65,
	0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x46, 0x0a, 0x0c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x22, 0xdf, 0x02, 0x0a, 0x13, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69,
	0x74, 0x52, 0x65, 0x66, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x13,
	0x67, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x33, 0x0a, 0x31, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x11, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x5d, 0x0a, 0x08, 0x72, 0x65, 0x66, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x47, 0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x52, 0x65, 0x66, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72,
	0x65, 0x66, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x38, 0x0a, 0x07,
	0x52, 0x65, 0x66, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x46, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x41, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x52,
	0x41, 0x4e, 0x43, 0x48, 0x10, 0x02, 0x22, 0x5b, 0x0a, 0x14, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47,
	0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x72, 0x65, 0x66, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x08, 0x72, 0x65, 0x66, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x32, 0xa7, 0x1c, 0x0a, 0x10, 0x44, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0xc8, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65,
	0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0xb5, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf6, 0x01, 0x0a, 0x10,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41, 0x1f,
	0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xf8, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x16, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x32, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xd9, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b,
	0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbb, 0x02, 0x0a, 0x17,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbe, 0x01, 0xca, 0x41, 0x26, 0x0a, 0x11,
	0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x31, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x69,
	0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x2c, 0x67, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x3a, 0x13,
	0x67, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xfd, 0x01, 0x0a, 0x17, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47,
	0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x46, 0x2a, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf2, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x69, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x69, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x69, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0xdf,
	0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x69,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x53, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x69, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x9d, 0x02, 0x0a, 0x13, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
	0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x88, 0x01, 0xda, 0x41, 0x13, 0x67, 0x69, 0x74, 0x5f, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x6c, 0x3a, 0x01, 0x2a, 0x22, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67, 0x69,
	0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74,
	0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x89, 0x02, 0x0a, 0x0e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65,
	0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x83, 0x01, 0xda, 0x41, 0x13, 0x67, 0x69, 0x74, 0x5f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x67, 0x3a, 0x01, 0x2a, 0x22, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67,
	0x69, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x96, 0x02, 0x0a,
	0x1c, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x69,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x69,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e,
	0x6b, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x67, 0xda, 0x41,
	0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x54, 0x12, 0x52, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69,
	0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x86, 0x02, 0x0a, 0x18, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47,
	0x69, 0x74, 0x48, 0x75, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x48, 0x75,
	0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69,
	0x74, 0x48, 0x75, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x63, 0xda, 0x41, 0x0a, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x12, 0x4e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x48, 0x75,
	0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x87,
	0x02, 0x0a, 0x0c, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47,
	0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x87,
	0x01, 0xda, 0x41, 0x1c, 0x67, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2c, 0x72, 0x65, 0x66, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x62, 0x12, 0x60, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67, 0x69, 0x74,
	0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x69, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63,
	0x68, 0x47, 0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x1a, 0x53, 0xca, 0x41, 0x1f, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xf8, 0x04,
	0xea, 0x41, 0x6b, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x7d, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41,
	0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65,
	0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67,
	0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0xea, 0x41, 0x7c, 0x0a, 0x27, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c,
	0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x15,
	0x44, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x70, 0x62, 0x3b, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x70, 0x62, 0xa2, 0x02, 0x10, 0x44, 0x65, 0x76, 0x65,
	0x6c, 0x6f, 0x70, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0xaa, 0x02, 0x20, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x65, 0x76, 0x65,
	0x6c, 0x6f, 0x70, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x44, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescOnce sync.Once
	file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescData = file_google_cloud_developerconnect_v1_developer_connect_proto_rawDesc
)

func file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescGZIP() []byte {
	file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescOnce.Do(func() {
		file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescData)
	})
	return file_google_cloud_developerconnect_v1_developer_connect_proto_rawDescData
}

var file_google_cloud_developerconnect_v1_developer_connect_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes = make([]protoimpl.MessageInfo, 39)
var file_google_cloud_developerconnect_v1_developer_connect_proto_goTypes = []any{
	(InstallationState_Stage)(0),                          // 0: google.cloud.developerconnect.v1.InstallationState.Stage
	(GitHubConfig_GitHubApp)(0),                           // 1: google.cloud.developerconnect.v1.GitHubConfig.GitHubApp
	(FetchGitRefsRequest_RefType)(0),                      // 2: google.cloud.developerconnect.v1.FetchGitRefsRequest.RefType
	(*Connection)(nil),                                    // 3: google.cloud.developerconnect.v1.Connection
	(*CryptoKeyConfig)(nil),                               // 4: google.cloud.developerconnect.v1.CryptoKeyConfig
	(*InstallationState)(nil),                             // 5: google.cloud.developerconnect.v1.InstallationState
	(*GitHubConfig)(nil),                                  // 6: google.cloud.developerconnect.v1.GitHubConfig
	(*GitHubEnterpriseConfig)(nil),                        // 7: google.cloud.developerconnect.v1.GitHubEnterpriseConfig
	(*ServiceDirectoryConfig)(nil),                        // 8: google.cloud.developerconnect.v1.ServiceDirectoryConfig
	(*OAuthCredential)(nil),                               // 9: google.cloud.developerconnect.v1.OAuthCredential
	(*GitLabConfig)(nil),                                  // 10: google.cloud.developerconnect.v1.GitLabConfig
	(*UserCredential)(nil),                                // 11: google.cloud.developerconnect.v1.UserCredential
	(*GitLabEnterpriseConfig)(nil),                        // 12: google.cloud.developerconnect.v1.GitLabEnterpriseConfig
	(*ListConnectionsRequest)(nil),                        // 13: google.cloud.developerconnect.v1.ListConnectionsRequest
	(*ListConnectionsResponse)(nil),                       // 14: google.cloud.developerconnect.v1.ListConnectionsResponse
	(*GetConnectionRequest)(nil),                          // 15: google.cloud.developerconnect.v1.GetConnectionRequest
	(*CreateConnectionRequest)(nil),                       // 16: google.cloud.developerconnect.v1.CreateConnectionRequest
	(*UpdateConnectionRequest)(nil),                       // 17: google.cloud.developerconnect.v1.UpdateConnectionRequest
	(*DeleteConnectionRequest)(nil),                       // 18: google.cloud.developerconnect.v1.DeleteConnectionRequest
	(*OperationMetadata)(nil),                             // 19: google.cloud.developerconnect.v1.OperationMetadata
	(*GitRepositoryLink)(nil),                             // 20: google.cloud.developerconnect.v1.GitRepositoryLink
	(*CreateGitRepositoryLinkRequest)(nil),                // 21: google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest
	(*DeleteGitRepositoryLinkRequest)(nil),                // 22: google.cloud.developerconnect.v1.DeleteGitRepositoryLinkRequest
	(*ListGitRepositoryLinksRequest)(nil),                 // 23: google.cloud.developerconnect.v1.ListGitRepositoryLinksRequest
	(*ListGitRepositoryLinksResponse)(nil),                // 24: google.cloud.developerconnect.v1.ListGitRepositoryLinksResponse
	(*GetGitRepositoryLinkRequest)(nil),                   // 25: google.cloud.developerconnect.v1.GetGitRepositoryLinkRequest
	(*FetchReadWriteTokenRequest)(nil),                    // 26: google.cloud.developerconnect.v1.FetchReadWriteTokenRequest
	(*FetchReadTokenRequest)(nil),                         // 27: google.cloud.developerconnect.v1.FetchReadTokenRequest
	(*FetchReadTokenResponse)(nil),                        // 28: google.cloud.developerconnect.v1.FetchReadTokenResponse
	(*FetchReadWriteTokenResponse)(nil),                   // 29: google.cloud.developerconnect.v1.FetchReadWriteTokenResponse
	(*FetchLinkableGitRepositoriesRequest)(nil),           // 30: google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesRequest
	(*FetchLinkableGitRepositoriesResponse)(nil),          // 31: google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesResponse
	(*LinkableGitRepository)(nil),                         // 32: google.cloud.developerconnect.v1.LinkableGitRepository
	(*FetchGitHubInstallationsRequest)(nil),               // 33: google.cloud.developerconnect.v1.FetchGitHubInstallationsRequest
	(*FetchGitHubInstallationsResponse)(nil),              // 34: google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse
	(*FetchGitRefsRequest)(nil),                           // 35: google.cloud.developerconnect.v1.FetchGitRefsRequest
	(*FetchGitRefsResponse)(nil),                          // 36: google.cloud.developerconnect.v1.FetchGitRefsResponse
	nil,                                                   // 37: google.cloud.developerconnect.v1.Connection.LabelsEntry
	nil,                                                   // 38: google.cloud.developerconnect.v1.Connection.AnnotationsEntry
	nil,                                                   // 39: google.cloud.developerconnect.v1.GitRepositoryLink.LabelsEntry
	nil,                                                   // 40: google.cloud.developerconnect.v1.GitRepositoryLink.AnnotationsEntry
	(*FetchGitHubInstallationsResponse_Installation)(nil), // 41: google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse.Installation
	(*timestamppb.Timestamp)(nil),                         // 42: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                         // 43: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),                       // 44: google.longrunning.Operation
}
var file_google_cloud_developerconnect_v1_developer_connect_proto_depIdxs = []int32{
	6,  // 0: google.cloud.developerconnect.v1.Connection.github_config:type_name -> google.cloud.developerconnect.v1.GitHubConfig
	7,  // 1: google.cloud.developerconnect.v1.Connection.github_enterprise_config:type_name -> google.cloud.developerconnect.v1.GitHubEnterpriseConfig
	10, // 2: google.cloud.developerconnect.v1.Connection.gitlab_config:type_name -> google.cloud.developerconnect.v1.GitLabConfig
	12, // 3: google.cloud.developerconnect.v1.Connection.gitlab_enterprise_config:type_name -> google.cloud.developerconnect.v1.GitLabEnterpriseConfig
	42, // 4: google.cloud.developerconnect.v1.Connection.create_time:type_name -> google.protobuf.Timestamp
	42, // 5: google.cloud.developerconnect.v1.Connection.update_time:type_name -> google.protobuf.Timestamp
	42, // 6: google.cloud.developerconnect.v1.Connection.delete_time:type_name -> google.protobuf.Timestamp
	37, // 7: google.cloud.developerconnect.v1.Connection.labels:type_name -> google.cloud.developerconnect.v1.Connection.LabelsEntry
	5,  // 8: google.cloud.developerconnect.v1.Connection.installation_state:type_name -> google.cloud.developerconnect.v1.InstallationState
	38, // 9: google.cloud.developerconnect.v1.Connection.annotations:type_name -> google.cloud.developerconnect.v1.Connection.AnnotationsEntry
	4,  // 10: google.cloud.developerconnect.v1.Connection.crypto_key_config:type_name -> google.cloud.developerconnect.v1.CryptoKeyConfig
	0,  // 11: google.cloud.developerconnect.v1.InstallationState.stage:type_name -> google.cloud.developerconnect.v1.InstallationState.Stage
	1,  // 12: google.cloud.developerconnect.v1.GitHubConfig.github_app:type_name -> google.cloud.developerconnect.v1.GitHubConfig.GitHubApp
	9,  // 13: google.cloud.developerconnect.v1.GitHubConfig.authorizer_credential:type_name -> google.cloud.developerconnect.v1.OAuthCredential
	8,  // 14: google.cloud.developerconnect.v1.GitHubEnterpriseConfig.service_directory_config:type_name -> google.cloud.developerconnect.v1.ServiceDirectoryConfig
	11, // 15: google.cloud.developerconnect.v1.GitLabConfig.read_authorizer_credential:type_name -> google.cloud.developerconnect.v1.UserCredential
	11, // 16: google.cloud.developerconnect.v1.GitLabConfig.authorizer_credential:type_name -> google.cloud.developerconnect.v1.UserCredential
	11, // 17: google.cloud.developerconnect.v1.GitLabEnterpriseConfig.read_authorizer_credential:type_name -> google.cloud.developerconnect.v1.UserCredential
	11, // 18: google.cloud.developerconnect.v1.GitLabEnterpriseConfig.authorizer_credential:type_name -> google.cloud.developerconnect.v1.UserCredential
	8,  // 19: google.cloud.developerconnect.v1.GitLabEnterpriseConfig.service_directory_config:type_name -> google.cloud.developerconnect.v1.ServiceDirectoryConfig
	3,  // 20: google.cloud.developerconnect.v1.ListConnectionsResponse.connections:type_name -> google.cloud.developerconnect.v1.Connection
	3,  // 21: google.cloud.developerconnect.v1.CreateConnectionRequest.connection:type_name -> google.cloud.developerconnect.v1.Connection
	43, // 22: google.cloud.developerconnect.v1.UpdateConnectionRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 23: google.cloud.developerconnect.v1.UpdateConnectionRequest.connection:type_name -> google.cloud.developerconnect.v1.Connection
	42, // 24: google.cloud.developerconnect.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	42, // 25: google.cloud.developerconnect.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	42, // 26: google.cloud.developerconnect.v1.GitRepositoryLink.create_time:type_name -> google.protobuf.Timestamp
	42, // 27: google.cloud.developerconnect.v1.GitRepositoryLink.update_time:type_name -> google.protobuf.Timestamp
	42, // 28: google.cloud.developerconnect.v1.GitRepositoryLink.delete_time:type_name -> google.protobuf.Timestamp
	39, // 29: google.cloud.developerconnect.v1.GitRepositoryLink.labels:type_name -> google.cloud.developerconnect.v1.GitRepositoryLink.LabelsEntry
	40, // 30: google.cloud.developerconnect.v1.GitRepositoryLink.annotations:type_name -> google.cloud.developerconnect.v1.GitRepositoryLink.AnnotationsEntry
	20, // 31: google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest.git_repository_link:type_name -> google.cloud.developerconnect.v1.GitRepositoryLink
	20, // 32: google.cloud.developerconnect.v1.ListGitRepositoryLinksResponse.git_repository_links:type_name -> google.cloud.developerconnect.v1.GitRepositoryLink
	42, // 33: google.cloud.developerconnect.v1.FetchReadTokenResponse.expiration_time:type_name -> google.protobuf.Timestamp
	42, // 34: google.cloud.developerconnect.v1.FetchReadWriteTokenResponse.expiration_time:type_name -> google.protobuf.Timestamp
	32, // 35: google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesResponse.linkable_git_repositories:type_name -> google.cloud.developerconnect.v1.LinkableGitRepository
	41, // 36: google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse.installations:type_name -> google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse.Installation
	2,  // 37: google.cloud.developerconnect.v1.FetchGitRefsRequest.ref_type:type_name -> google.cloud.developerconnect.v1.FetchGitRefsRequest.RefType
	13, // 38: google.cloud.developerconnect.v1.DeveloperConnect.ListConnections:input_type -> google.cloud.developerconnect.v1.ListConnectionsRequest
	15, // 39: google.cloud.developerconnect.v1.DeveloperConnect.GetConnection:input_type -> google.cloud.developerconnect.v1.GetConnectionRequest
	16, // 40: google.cloud.developerconnect.v1.DeveloperConnect.CreateConnection:input_type -> google.cloud.developerconnect.v1.CreateConnectionRequest
	17, // 41: google.cloud.developerconnect.v1.DeveloperConnect.UpdateConnection:input_type -> google.cloud.developerconnect.v1.UpdateConnectionRequest
	18, // 42: google.cloud.developerconnect.v1.DeveloperConnect.DeleteConnection:input_type -> google.cloud.developerconnect.v1.DeleteConnectionRequest
	21, // 43: google.cloud.developerconnect.v1.DeveloperConnect.CreateGitRepositoryLink:input_type -> google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest
	22, // 44: google.cloud.developerconnect.v1.DeveloperConnect.DeleteGitRepositoryLink:input_type -> google.cloud.developerconnect.v1.DeleteGitRepositoryLinkRequest
	23, // 45: google.cloud.developerconnect.v1.DeveloperConnect.ListGitRepositoryLinks:input_type -> google.cloud.developerconnect.v1.ListGitRepositoryLinksRequest
	25, // 46: google.cloud.developerconnect.v1.DeveloperConnect.GetGitRepositoryLink:input_type -> google.cloud.developerconnect.v1.GetGitRepositoryLinkRequest
	26, // 47: google.cloud.developerconnect.v1.DeveloperConnect.FetchReadWriteToken:input_type -> google.cloud.developerconnect.v1.FetchReadWriteTokenRequest
	27, // 48: google.cloud.developerconnect.v1.DeveloperConnect.FetchReadToken:input_type -> google.cloud.developerconnect.v1.FetchReadTokenRequest
	30, // 49: google.cloud.developerconnect.v1.DeveloperConnect.FetchLinkableGitRepositories:input_type -> google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesRequest
	33, // 50: google.cloud.developerconnect.v1.DeveloperConnect.FetchGitHubInstallations:input_type -> google.cloud.developerconnect.v1.FetchGitHubInstallationsRequest
	35, // 51: google.cloud.developerconnect.v1.DeveloperConnect.FetchGitRefs:input_type -> google.cloud.developerconnect.v1.FetchGitRefsRequest
	14, // 52: google.cloud.developerconnect.v1.DeveloperConnect.ListConnections:output_type -> google.cloud.developerconnect.v1.ListConnectionsResponse
	3,  // 53: google.cloud.developerconnect.v1.DeveloperConnect.GetConnection:output_type -> google.cloud.developerconnect.v1.Connection
	44, // 54: google.cloud.developerconnect.v1.DeveloperConnect.CreateConnection:output_type -> google.longrunning.Operation
	44, // 55: google.cloud.developerconnect.v1.DeveloperConnect.UpdateConnection:output_type -> google.longrunning.Operation
	44, // 56: google.cloud.developerconnect.v1.DeveloperConnect.DeleteConnection:output_type -> google.longrunning.Operation
	44, // 57: google.cloud.developerconnect.v1.DeveloperConnect.CreateGitRepositoryLink:output_type -> google.longrunning.Operation
	44, // 58: google.cloud.developerconnect.v1.DeveloperConnect.DeleteGitRepositoryLink:output_type -> google.longrunning.Operation
	24, // 59: google.cloud.developerconnect.v1.DeveloperConnect.ListGitRepositoryLinks:output_type -> google.cloud.developerconnect.v1.ListGitRepositoryLinksResponse
	20, // 60: google.cloud.developerconnect.v1.DeveloperConnect.GetGitRepositoryLink:output_type -> google.cloud.developerconnect.v1.GitRepositoryLink
	29, // 61: google.cloud.developerconnect.v1.DeveloperConnect.FetchReadWriteToken:output_type -> google.cloud.developerconnect.v1.FetchReadWriteTokenResponse
	28, // 62: google.cloud.developerconnect.v1.DeveloperConnect.FetchReadToken:output_type -> google.cloud.developerconnect.v1.FetchReadTokenResponse
	31, // 63: google.cloud.developerconnect.v1.DeveloperConnect.FetchLinkableGitRepositories:output_type -> google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesResponse
	34, // 64: google.cloud.developerconnect.v1.DeveloperConnect.FetchGitHubInstallations:output_type -> google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse
	36, // 65: google.cloud.developerconnect.v1.DeveloperConnect.FetchGitRefs:output_type -> google.cloud.developerconnect.v1.FetchGitRefsResponse
	52, // [52:66] is the sub-list for method output_type
	38, // [38:52] is the sub-list for method input_type
	38, // [38:38] is the sub-list for extension type_name
	38, // [38:38] is the sub-list for extension extendee
	0,  // [0:38] is the sub-list for field type_name
}

func init() { file_google_cloud_developerconnect_v1_developer_connect_proto_init() }
func file_google_cloud_developerconnect_v1_developer_connect_proto_init() {
	if File_google_cloud_developerconnect_v1_developer_connect_proto != nil {
		return
	}
	file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes[0].OneofWrappers = []any{
		(*Connection_GithubConfig)(nil),
		(*Connection_GithubEnterpriseConfig)(nil),
		(*Connection_GitlabConfig)(nil),
		(*Connection_GitlabEnterpriseConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_developerconnect_v1_developer_connect_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   39,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_developerconnect_v1_developer_connect_proto_goTypes,
		DependencyIndexes: file_google_cloud_developerconnect_v1_developer_connect_proto_depIdxs,
		EnumInfos:         file_google_cloud_developerconnect_v1_developer_connect_proto_enumTypes,
		MessageInfos:      file_google_cloud_developerconnect_v1_developer_connect_proto_msgTypes,
	}.Build()
	File_google_cloud_developerconnect_v1_developer_connect_proto = out.File
	file_google_cloud_developerconnect_v1_developer_connect_proto_rawDesc = nil
	file_google_cloud_developerconnect_v1_developer_connect_proto_goTypes = nil
	file_google_cloud_developerconnect_v1_developer_connect_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DeveloperConnectClient is the client API for DeveloperConnect service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DeveloperConnectClient interface {
	// Lists Connections in a given project and location.
	ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error)
	// Gets details of a single Connection.
	GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Creates a new Connection in a given project and location.
	CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Connection.
	UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Connection.
	DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a GitRepositoryLink. Upon linking a Git Repository, Developer
	// Connect will configure the Git Repository to send webhook events to
	// Developer Connect. Connections that use Firebase GitHub Application will
	// have events forwarded to the Firebase service. All other Connections will
	// have events forwarded to Cloud Build.
	CreateGitRepositoryLink(ctx context.Context, in *CreateGitRepositoryLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single GitRepositoryLink.
	DeleteGitRepositoryLink(ctx context.Context, in *DeleteGitRepositoryLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists GitRepositoryLinks in a given project, location, and connection.
	ListGitRepositoryLinks(ctx context.Context, in *ListGitRepositoryLinksRequest, opts ...grpc.CallOption) (*ListGitRepositoryLinksResponse, error)
	// Gets details of a single GitRepositoryLink.
	GetGitRepositoryLink(ctx context.Context, in *GetGitRepositoryLinkRequest, opts ...grpc.CallOption) (*GitRepositoryLink, error)
	// Fetches read/write token of a given gitRepositoryLink.
	FetchReadWriteToken(ctx context.Context, in *FetchReadWriteTokenRequest, opts ...grpc.CallOption) (*FetchReadWriteTokenResponse, error)
	// Fetches read token of a given gitRepositoryLink.
	FetchReadToken(ctx context.Context, in *FetchReadTokenRequest, opts ...grpc.CallOption) (*FetchReadTokenResponse, error)
	// FetchLinkableGitRepositories returns a list of git repositories from an SCM
	// that are available to be added to a Connection.
	FetchLinkableGitRepositories(ctx context.Context, in *FetchLinkableGitRepositoriesRequest, opts ...grpc.CallOption) (*FetchLinkableGitRepositoriesResponse, error)
	// FetchGitHubInstallations returns the list of GitHub Installations that
	// are available to be added to a Connection.
	// For github.com, only installations accessible to the authorizer token
	// are returned. For GitHub Enterprise, all installations are returned.
	FetchGitHubInstallations(ctx context.Context, in *FetchGitHubInstallationsRequest, opts ...grpc.CallOption) (*FetchGitHubInstallationsResponse, error)
	// Fetch the list of branches or tags for a given repository.
	FetchGitRefs(ctx context.Context, in *FetchGitRefsRequest, opts ...grpc.CallOption) (*FetchGitRefsResponse, error)
}

type developerConnectClient struct {
	cc grpc.ClientConnInterface
}

func NewDeveloperConnectClient(cc grpc.ClientConnInterface) DeveloperConnectClient {
	return &developerConnectClient{cc}
}

func (c *developerConnectClient) ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error) {
	out := new(ListConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/ListConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/GetConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/CreateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/UpdateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/DeleteConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) CreateGitRepositoryLink(ctx context.Context, in *CreateGitRepositoryLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/CreateGitRepositoryLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) DeleteGitRepositoryLink(ctx context.Context, in *DeleteGitRepositoryLinkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/DeleteGitRepositoryLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) ListGitRepositoryLinks(ctx context.Context, in *ListGitRepositoryLinksRequest, opts ...grpc.CallOption) (*ListGitRepositoryLinksResponse, error) {
	out := new(ListGitRepositoryLinksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/ListGitRepositoryLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) GetGitRepositoryLink(ctx context.Context, in *GetGitRepositoryLinkRequest, opts ...grpc.CallOption) (*GitRepositoryLink, error) {
	out := new(GitRepositoryLink)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/GetGitRepositoryLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) FetchReadWriteToken(ctx context.Context, in *FetchReadWriteTokenRequest, opts ...grpc.CallOption) (*FetchReadWriteTokenResponse, error) {
	out := new(FetchReadWriteTokenResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/FetchReadWriteToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) FetchReadToken(ctx context.Context, in *FetchReadTokenRequest, opts ...grpc.CallOption) (*FetchReadTokenResponse, error) {
	out := new(FetchReadTokenResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/FetchReadToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) FetchLinkableGitRepositories(ctx context.Context, in *FetchLinkableGitRepositoriesRequest, opts ...grpc.CallOption) (*FetchLinkableGitRepositoriesResponse, error) {
	out := new(FetchLinkableGitRepositoriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/FetchLinkableGitRepositories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) FetchGitHubInstallations(ctx context.Context, in *FetchGitHubInstallationsRequest, opts ...grpc.CallOption) (*FetchGitHubInstallationsResponse, error) {
	out := new(FetchGitHubInstallationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/FetchGitHubInstallations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *developerConnectClient) FetchGitRefs(ctx context.Context, in *FetchGitRefsRequest, opts ...grpc.CallOption) (*FetchGitRefsResponse, error) {
	out := new(FetchGitRefsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.developerconnect.v1.DeveloperConnect/FetchGitRefs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DeveloperConnectServer is the server API for DeveloperConnect service.
type DeveloperConnectServer interface {
	// Lists Connections in a given project and location.
	ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error)
	// Gets details of a single Connection.
	GetConnection(context.Context, *GetConnectionRequest) (*Connection, error)
	// Creates a new Connection in a given project and location.
	CreateConnection(context.Context, *CreateConnectionRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Connection.
	UpdateConnection(context.Context, *UpdateConnectionRequest) (*longrunningpb.Operation, error)
	// Deletes a single Connection.
	DeleteConnection(context.Context, *DeleteConnectionRequest) (*longrunningpb.Operation, error)
	// Creates a GitRepositoryLink. Upon linking a Git Repository, Developer
	// Connect will configure the Git Repository to send webhook events to
	// Developer Connect. Connections that use Firebase GitHub Application will
	// have events forwarded to the Firebase service. All other Connections will
	// have events forwarded to Cloud Build.
	CreateGitRepositoryLink(context.Context, *CreateGitRepositoryLinkRequest) (*longrunningpb.Operation, error)
	// Deletes a single GitRepositoryLink.
	DeleteGitRepositoryLink(context.Context, *DeleteGitRepositoryLinkRequest) (*longrunningpb.Operation, error)
	// Lists GitRepositoryLinks in a given project, location, and connection.
	ListGitRepositoryLinks(context.Context, *ListGitRepositoryLinksRequest) (*ListGitRepositoryLinksResponse, error)
	// Gets details of a single GitRepositoryLink.
	GetGitRepositoryLink(context.Context, *GetGitRepositoryLinkRequest) (*GitRepositoryLink, error)
	// Fetches read/write token of a given gitRepositoryLink.
	FetchReadWriteToken(context.Context, *FetchReadWriteTokenRequest) (*FetchReadWriteTokenResponse, error)
	// Fetches read token of a given gitRepositoryLink.
	FetchReadToken(context.Context, *FetchReadTokenRequest) (*FetchReadTokenResponse, error)
	// FetchLinkableGitRepositories returns a list of git repositories from an SCM
	// that are available to be added to a Connection.
	FetchLinkableGitRepositories(context.Context, *FetchLinkableGitRepositoriesRequest) (*FetchLinkableGitRepositoriesResponse, error)
	// FetchGitHubInstallations returns the list of GitHub Installations that
	// are available to be added to a Connection.
	// For github.com, only installations accessible to the authorizer token
	// are returned. For GitHub Enterprise, all installations are returned.
	FetchGitHubInstallations(context.Context, *FetchGitHubInstallationsRequest) (*FetchGitHubInstallationsResponse, error)
	// Fetch the list of branches or tags for a given repository.
	FetchGitRefs(context.Context, *FetchGitRefsRequest) (*FetchGitRefsResponse, error)
}

// UnimplementedDeveloperConnectServer can be embedded to have forward compatible implementations.
type UnimplementedDeveloperConnectServer struct {
}

func (*UnimplementedDeveloperConnectServer) ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnections not implemented")
}
func (*UnimplementedDeveloperConnectServer) GetConnection(context.Context, *GetConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnection not implemented")
}
func (*UnimplementedDeveloperConnectServer) CreateConnection(context.Context, *CreateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnection not implemented")
}
func (*UnimplementedDeveloperConnectServer) UpdateConnection(context.Context, *UpdateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnection not implemented")
}
func (*UnimplementedDeveloperConnectServer) DeleteConnection(context.Context, *DeleteConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnection not implemented")
}
func (*UnimplementedDeveloperConnectServer) CreateGitRepositoryLink(context.Context, *CreateGitRepositoryLinkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGitRepositoryLink not implemented")
}
func (*UnimplementedDeveloperConnectServer) DeleteGitRepositoryLink(context.Context, *DeleteGitRepositoryLinkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGitRepositoryLink not implemented")
}
func (*UnimplementedDeveloperConnectServer) ListGitRepositoryLinks(context.Context, *ListGitRepositoryLinksRequest) (*ListGitRepositoryLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGitRepositoryLinks not implemented")
}
func (*UnimplementedDeveloperConnectServer) GetGitRepositoryLink(context.Context, *GetGitRepositoryLinkRequest) (*GitRepositoryLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGitRepositoryLink not implemented")
}
func (*UnimplementedDeveloperConnectServer) FetchReadWriteToken(context.Context, *FetchReadWriteTokenRequest) (*FetchReadWriteTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchReadWriteToken not implemented")
}
func (*UnimplementedDeveloperConnectServer) FetchReadToken(context.Context, *FetchReadTokenRequest) (*FetchReadTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchReadToken not implemented")
}
func (*UnimplementedDeveloperConnectServer) FetchLinkableGitRepositories(context.Context, *FetchLinkableGitRepositoriesRequest) (*FetchLinkableGitRepositoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchLinkableGitRepositories not implemented")
}
func (*UnimplementedDeveloperConnectServer) FetchGitHubInstallations(context.Context, *FetchGitHubInstallationsRequest) (*FetchGitHubInstallationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchGitHubInstallations not implemented")
}
func (*UnimplementedDeveloperConnectServer) FetchGitRefs(context.Context, *FetchGitRefsRequest) (*FetchGitRefsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchGitRefs not implemented")
}

func RegisterDeveloperConnectServer(s *grpc.Server, srv DeveloperConnectServer) {
	s.RegisterService(&_DeveloperConnect_serviceDesc, srv)
}

func _DeveloperConnect_ListConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).ListConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/ListConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).ListConnections(ctx, req.(*ListConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_GetConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).GetConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/GetConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).GetConnection(ctx, req.(*GetConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_CreateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).CreateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/CreateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).CreateConnection(ctx, req.(*CreateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_UpdateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).UpdateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/UpdateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).UpdateConnection(ctx, req.(*UpdateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_DeleteConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).DeleteConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/DeleteConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).DeleteConnection(ctx, req.(*DeleteConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_CreateGitRepositoryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGitRepositoryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).CreateGitRepositoryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/CreateGitRepositoryLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).CreateGitRepositoryLink(ctx, req.(*CreateGitRepositoryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_DeleteGitRepositoryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGitRepositoryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).DeleteGitRepositoryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/DeleteGitRepositoryLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).DeleteGitRepositoryLink(ctx, req.(*DeleteGitRepositoryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_ListGitRepositoryLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGitRepositoryLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).ListGitRepositoryLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/ListGitRepositoryLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).ListGitRepositoryLinks(ctx, req.(*ListGitRepositoryLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_GetGitRepositoryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGitRepositoryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).GetGitRepositoryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/GetGitRepositoryLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).GetGitRepositoryLink(ctx, req.(*GetGitRepositoryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_FetchReadWriteToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchReadWriteTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).FetchReadWriteToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/FetchReadWriteToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).FetchReadWriteToken(ctx, req.(*FetchReadWriteTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_FetchReadToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchReadTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).FetchReadToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/FetchReadToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).FetchReadToken(ctx, req.(*FetchReadTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_FetchLinkableGitRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchLinkableGitRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).FetchLinkableGitRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/FetchLinkableGitRepositories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).FetchLinkableGitRepositories(ctx, req.(*FetchLinkableGitRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_FetchGitHubInstallations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchGitHubInstallationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).FetchGitHubInstallations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/FetchGitHubInstallations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).FetchGitHubInstallations(ctx, req.(*FetchGitHubInstallationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeveloperConnect_FetchGitRefs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchGitRefsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeveloperConnectServer).FetchGitRefs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.developerconnect.v1.DeveloperConnect/FetchGitRefs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeveloperConnectServer).FetchGitRefs(ctx, req.(*FetchGitRefsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DeveloperConnect_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.developerconnect.v1.DeveloperConnect",
	HandlerType: (*DeveloperConnectServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConnections",
			Handler:    _DeveloperConnect_ListConnections_Handler,
		},
		{
			MethodName: "GetConnection",
			Handler:    _DeveloperConnect_GetConnection_Handler,
		},
		{
			MethodName: "CreateConnection",
			Handler:    _DeveloperConnect_CreateConnection_Handler,
		},
		{
			MethodName: "UpdateConnection",
			Handler:    _DeveloperConnect_UpdateConnection_Handler,
		},
		{
			MethodName: "DeleteConnection",
			Handler:    _DeveloperConnect_DeleteConnection_Handler,
		},
		{
			MethodName: "CreateGitRepositoryLink",
			Handler:    _DeveloperConnect_CreateGitRepositoryLink_Handler,
		},
		{
			MethodName: "DeleteGitRepositoryLink",
			Handler:    _DeveloperConnect_DeleteGitRepositoryLink_Handler,
		},
		{
			MethodName: "ListGitRepositoryLinks",
			Handler:    _DeveloperConnect_ListGitRepositoryLinks_Handler,
		},
		{
			MethodName: "GetGitRepositoryLink",
			Handler:    _DeveloperConnect_GetGitRepositoryLink_Handler,
		},
		{
			MethodName: "FetchReadWriteToken",
			Handler:    _DeveloperConnect_FetchReadWriteToken_Handler,
		},
		{
			MethodName: "FetchReadToken",
			Handler:    _DeveloperConnect_FetchReadToken_Handler,
		},
		{
			MethodName: "FetchLinkableGitRepositories",
			Handler:    _DeveloperConnect_FetchLinkableGitRepositories_Handler,
		},
		{
			MethodName: "FetchGitHubInstallations",
			Handler:    _DeveloperConnect_FetchGitHubInstallations_Handler,
		},
		{
			MethodName: "FetchGitRefs",
			Handler:    _DeveloperConnect_FetchGitRefs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/developerconnect/v1/developer_connect.proto",
}
