// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/api/cloudquotas/v1beta/quota_adjuster_settings.proto

package cloudquotaspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The enablement status of the quota adjuster.
type QuotaAdjusterSettings_Enablement int32

const (
	// The quota adjuster is in an unknown state.
	QuotaAdjusterSettings_ENABLEMENT_UNSPECIFIED QuotaAdjusterSettings_Enablement = 0
	// The quota adjuster is enabled.
	QuotaAdjusterSettings_ENABLED QuotaAdjusterSettings_Enablement = 2
	// The quota adjuster is disabled.
	QuotaAdjusterSettings_DISABLED QuotaAdjusterSettings_Enablement = 3
)

// Enum value maps for QuotaAdjusterSettings_Enablement.
var (
	QuotaAdjusterSettings_Enablement_name = map[int32]string{
		0: "ENABLEMENT_UNSPECIFIED",
		2: "ENABLED",
		3: "DISABLED",
	}
	QuotaAdjusterSettings_Enablement_value = map[string]int32{
		"ENABLEMENT_UNSPECIFIED": 0,
		"ENABLED":                2,
		"DISABLED":               3,
	}
)

func (x QuotaAdjusterSettings_Enablement) Enum() *QuotaAdjusterSettings_Enablement {
	p := new(QuotaAdjusterSettings_Enablement)
	*p = x
	return p
}

func (x QuotaAdjusterSettings_Enablement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaAdjusterSettings_Enablement) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_enumTypes[0].Descriptor()
}

func (QuotaAdjusterSettings_Enablement) Type() protoreflect.EnumType {
	return &file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_enumTypes[0]
}

func (x QuotaAdjusterSettings_Enablement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaAdjusterSettings_Enablement.Descriptor instead.
func (QuotaAdjusterSettings_Enablement) EnumDescriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescGZIP(), []int{2, 0}
}

// Request for getting QuotaAdjusterSettings
type GetQuotaAdjusterSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the `quotaAdjusterSettings` configuration. Only a single
	// setting per project is supported.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetQuotaAdjusterSettingsRequest) Reset() {
	*x = GetQuotaAdjusterSettingsRequest{}
	mi := &file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetQuotaAdjusterSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQuotaAdjusterSettingsRequest) ProtoMessage() {}

func (x *GetQuotaAdjusterSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQuotaAdjusterSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetQuotaAdjusterSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescGZIP(), []int{0}
}

func (x *GetQuotaAdjusterSettingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for updating QuotaAdjusterSettings
type UpdateQuotaAdjusterSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The QuotaAdjusterSettings to update.
	QuotaAdjusterSettings *QuotaAdjusterSettings `protobuf:"bytes,1,opt,name=quota_adjuster_settings,json=quotaAdjusterSettings,proto3" json:"quota_adjuster_settings,omitempty"`
	// Optional. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. If set to true, checks the syntax of the request but doesn't
	// update the quota adjuster settings value. Note that although a request can
	// be valid, that doesn't guarantee that the request will be fulfilled.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateQuotaAdjusterSettingsRequest) Reset() {
	*x = UpdateQuotaAdjusterSettingsRequest{}
	mi := &file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateQuotaAdjusterSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateQuotaAdjusterSettingsRequest) ProtoMessage() {}

func (x *UpdateQuotaAdjusterSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateQuotaAdjusterSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateQuotaAdjusterSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateQuotaAdjusterSettingsRequest) GetQuotaAdjusterSettings() *QuotaAdjusterSettings {
	if x != nil {
		return x.QuotaAdjusterSettings
	}
	return nil
}

func (x *UpdateQuotaAdjusterSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateQuotaAdjusterSettingsRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The QuotaAdjusterSettings resource defines the settings for the Quota
// Adjuster.
type QuotaAdjusterSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Name of the configuration, in the following format:
	//
	//	`projects/PROJECT_NUMBER/locations/global/quotaAdjusterSettings`.
	//
	// Replace PROJECT_NUMBER with the project number for your project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The configured value of the enablement at the given resource.
	Enablement QuotaAdjusterSettings_Enablement `protobuf:"varint,2,opt,name=enablement,proto3,enum=google.api.cloudquotas.v1beta.QuotaAdjusterSettings_Enablement" json:"enablement,omitempty"`
	// Output only. The timestamp when the QuotaAdjusterSettings resource was last
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The current ETag of the QuotaAdjusterSettings. If an ETag is
	// provided on update and does not match the current server's ETag in the
	// QuotaAdjusterSettings, the request is blocked and returns an ABORTED error.
	// See https://google.aip.dev/134#etags for more details on ETags.
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *QuotaAdjusterSettings) Reset() {
	*x = QuotaAdjusterSettings{}
	mi := &file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuotaAdjusterSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaAdjusterSettings) ProtoMessage() {}

func (x *QuotaAdjusterSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaAdjusterSettings.ProtoReflect.Descriptor instead.
func (*QuotaAdjusterSettings) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescGZIP(), []int{2}
}

func (x *QuotaAdjusterSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QuotaAdjusterSettings) GetEnablement() QuotaAdjusterSettings_Enablement {
	if x != nil {
		return x.Enablement
	}
	return QuotaAdjusterSettings_ENABLEMENT_UNSPECIFIED
}

func (x *QuotaAdjusterSettings) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *QuotaAdjusterSettings) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

var File_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto protoreflect.FileDescriptor

var file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x6f, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64,
	0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x83, 0x02, 0x0a, 0x22, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x71, 0x0a, 0x17, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xdf, 0x03, 0x0a, 0x15, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x0a,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x43, 0x0a,
	0x0a, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x16, 0x45,
	0x4e, 0x41, 0x42, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x03, 0x3a, 0xa6, 0x01, 0xea, 0x41, 0xa2, 0x01, 0x0a, 0x30, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2a, 0x15, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x32, 0x15, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x01, 0x01, 0x32, 0x83, 0x05, 0x0a, 0x1c,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0xb3, 0x02, 0x0a,
	0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x9a, 0x01, 0xda, 0x41, 0x23, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x6e, 0x3a, 0x17, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x61, 0x64, 0x6a, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x53, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x61, 0x64,
	0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x7d, 0x12, 0xdc, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x41,
	0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x47, 0x65, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x7d, 0x1a, 0x4e, 0xca, 0x41, 0x1a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0xf1, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x1a, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x41, 0x64,
	0x6a, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x45, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x70, 0x62, 0x3b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02,
	0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescOnce sync.Once
	file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescData = file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDesc
)

func file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescGZIP() []byte {
	file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescOnce.Do(func() {
		file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescData)
	})
	return file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDescData
}

var file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_goTypes = []any{
	(QuotaAdjusterSettings_Enablement)(0),      // 0: google.api.cloudquotas.v1beta.QuotaAdjusterSettings.Enablement
	(*GetQuotaAdjusterSettingsRequest)(nil),    // 1: google.api.cloudquotas.v1beta.GetQuotaAdjusterSettingsRequest
	(*UpdateQuotaAdjusterSettingsRequest)(nil), // 2: google.api.cloudquotas.v1beta.UpdateQuotaAdjusterSettingsRequest
	(*QuotaAdjusterSettings)(nil),              // 3: google.api.cloudquotas.v1beta.QuotaAdjusterSettings
	(*fieldmaskpb.FieldMask)(nil),              // 4: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),              // 5: google.protobuf.Timestamp
}
var file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_depIdxs = []int32{
	3, // 0: google.api.cloudquotas.v1beta.UpdateQuotaAdjusterSettingsRequest.quota_adjuster_settings:type_name -> google.api.cloudquotas.v1beta.QuotaAdjusterSettings
	4, // 1: google.api.cloudquotas.v1beta.UpdateQuotaAdjusterSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	0, // 2: google.api.cloudquotas.v1beta.QuotaAdjusterSettings.enablement:type_name -> google.api.cloudquotas.v1beta.QuotaAdjusterSettings.Enablement
	5, // 3: google.api.cloudquotas.v1beta.QuotaAdjusterSettings.update_time:type_name -> google.protobuf.Timestamp
	2, // 4: google.api.cloudquotas.v1beta.QuotaAdjusterSettingsManager.UpdateQuotaAdjusterSettings:input_type -> google.api.cloudquotas.v1beta.UpdateQuotaAdjusterSettingsRequest
	1, // 5: google.api.cloudquotas.v1beta.QuotaAdjusterSettingsManager.GetQuotaAdjusterSettings:input_type -> google.api.cloudquotas.v1beta.GetQuotaAdjusterSettingsRequest
	3, // 6: google.api.cloudquotas.v1beta.QuotaAdjusterSettingsManager.UpdateQuotaAdjusterSettings:output_type -> google.api.cloudquotas.v1beta.QuotaAdjusterSettings
	3, // 7: google.api.cloudquotas.v1beta.QuotaAdjusterSettingsManager.GetQuotaAdjusterSettings:output_type -> google.api.cloudquotas.v1beta.QuotaAdjusterSettings
	6, // [6:8] is the sub-list for method output_type
	4, // [4:6] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_init() }
func file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_init() {
	if File_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_goTypes,
		DependencyIndexes: file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_depIdxs,
		EnumInfos:         file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_enumTypes,
		MessageInfos:      file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_msgTypes,
	}.Build()
	File_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto = out.File
	file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_rawDesc = nil
	file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_goTypes = nil
	file_google_api_cloudquotas_v1beta_quota_adjuster_settings_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// QuotaAdjusterSettingsManagerClient is the client API for QuotaAdjusterSettingsManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type QuotaAdjusterSettingsManagerClient interface {
	// RPC Method for updating QuotaAdjusterSettings based on the request
	UpdateQuotaAdjusterSettings(ctx context.Context, in *UpdateQuotaAdjusterSettingsRequest, opts ...grpc.CallOption) (*QuotaAdjusterSettings, error)
	// RPC Method for getting QuotaAdjusterSettings based on the request
	GetQuotaAdjusterSettings(ctx context.Context, in *GetQuotaAdjusterSettingsRequest, opts ...grpc.CallOption) (*QuotaAdjusterSettings, error)
}

type quotaAdjusterSettingsManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewQuotaAdjusterSettingsManagerClient(cc grpc.ClientConnInterface) QuotaAdjusterSettingsManagerClient {
	return &quotaAdjusterSettingsManagerClient{cc}
}

func (c *quotaAdjusterSettingsManagerClient) UpdateQuotaAdjusterSettings(ctx context.Context, in *UpdateQuotaAdjusterSettingsRequest, opts ...grpc.CallOption) (*QuotaAdjusterSettings, error) {
	out := new(QuotaAdjusterSettings)
	err := c.cc.Invoke(ctx, "/google.api.cloudquotas.v1beta.QuotaAdjusterSettingsManager/UpdateQuotaAdjusterSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *quotaAdjusterSettingsManagerClient) GetQuotaAdjusterSettings(ctx context.Context, in *GetQuotaAdjusterSettingsRequest, opts ...grpc.CallOption) (*QuotaAdjusterSettings, error) {
	out := new(QuotaAdjusterSettings)
	err := c.cc.Invoke(ctx, "/google.api.cloudquotas.v1beta.QuotaAdjusterSettingsManager/GetQuotaAdjusterSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// QuotaAdjusterSettingsManagerServer is the server API for QuotaAdjusterSettingsManager service.
type QuotaAdjusterSettingsManagerServer interface {
	// RPC Method for updating QuotaAdjusterSettings based on the request
	UpdateQuotaAdjusterSettings(context.Context, *UpdateQuotaAdjusterSettingsRequest) (*QuotaAdjusterSettings, error)
	// RPC Method for getting QuotaAdjusterSettings based on the request
	GetQuotaAdjusterSettings(context.Context, *GetQuotaAdjusterSettingsRequest) (*QuotaAdjusterSettings, error)
}

// UnimplementedQuotaAdjusterSettingsManagerServer can be embedded to have forward compatible implementations.
type UnimplementedQuotaAdjusterSettingsManagerServer struct {
}

func (*UnimplementedQuotaAdjusterSettingsManagerServer) UpdateQuotaAdjusterSettings(context.Context, *UpdateQuotaAdjusterSettingsRequest) (*QuotaAdjusterSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateQuotaAdjusterSettings not implemented")
}
func (*UnimplementedQuotaAdjusterSettingsManagerServer) GetQuotaAdjusterSettings(context.Context, *GetQuotaAdjusterSettingsRequest) (*QuotaAdjusterSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQuotaAdjusterSettings not implemented")
}

func RegisterQuotaAdjusterSettingsManagerServer(s *grpc.Server, srv QuotaAdjusterSettingsManagerServer) {
	s.RegisterService(&_QuotaAdjusterSettingsManager_serviceDesc, srv)
}

func _QuotaAdjusterSettingsManager_UpdateQuotaAdjusterSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateQuotaAdjusterSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuotaAdjusterSettingsManagerServer).UpdateQuotaAdjusterSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.cloudquotas.v1beta.QuotaAdjusterSettingsManager/UpdateQuotaAdjusterSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuotaAdjusterSettingsManagerServer).UpdateQuotaAdjusterSettings(ctx, req.(*UpdateQuotaAdjusterSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _QuotaAdjusterSettingsManager_GetQuotaAdjusterSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQuotaAdjusterSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QuotaAdjusterSettingsManagerServer).GetQuotaAdjusterSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.cloudquotas.v1beta.QuotaAdjusterSettingsManager/GetQuotaAdjusterSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QuotaAdjusterSettingsManagerServer).GetQuotaAdjusterSettings(ctx, req.(*GetQuotaAdjusterSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _QuotaAdjusterSettingsManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.cloudquotas.v1beta.QuotaAdjusterSettingsManager",
	HandlerType: (*QuotaAdjusterSettingsManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UpdateQuotaAdjusterSettings",
			Handler:    _QuotaAdjusterSettingsManager_UpdateQuotaAdjusterSettings_Handler,
		},
		{
			MethodName: "GetQuotaAdjusterSettings",
			Handler:    _QuotaAdjusterSettingsManager_GetQuotaAdjusterSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/cloudquotas/v1beta/quota_adjuster_settings.proto",
}
