// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/backupdr/v1/backupplan.proto

package backupdrpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	month "google.golang.org/genproto/googleapis/type/month"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// `State` enumerates the possible states for a `BackupPlan`.
type BackupPlan_State int32

const (
	// State not set.
	BackupPlan_STATE_UNSPECIFIED BackupPlan_State = 0
	// The resource is being created.
	BackupPlan_CREATING BackupPlan_State = 1
	// The resource has been created and is fully usable.
	BackupPlan_ACTIVE BackupPlan_State = 2
	// The resource is being deleted.
	BackupPlan_DELETING BackupPlan_State = 3
	// The resource has been created but is not usable.
	BackupPlan_INACTIVE BackupPlan_State = 4
)

// Enum value maps for BackupPlan_State.
var (
	BackupPlan_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "INACTIVE",
	}
	BackupPlan_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"INACTIVE":          4,
	}
)

func (x BackupPlan_State) Enum() *BackupPlan_State {
	p := new(BackupPlan_State)
	*p = x
	return p
}

func (x BackupPlan_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupPlan_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupplan_proto_enumTypes[0].Descriptor()
}

func (BackupPlan_State) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupplan_proto_enumTypes[0]
}

func (x BackupPlan_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupPlan_State.Descriptor instead.
func (BackupPlan_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{0, 0}
}

// `RecurrenceTypes` enumerates the applicable periodicity for the schedule.
type StandardSchedule_RecurrenceType int32

const (
	// recurrence type not set
	StandardSchedule_RECURRENCE_TYPE_UNSPECIFIED StandardSchedule_RecurrenceType = 0
	// The `BackupRule` is to be applied hourly.
	StandardSchedule_HOURLY StandardSchedule_RecurrenceType = 1
	// The `BackupRule` is to be applied daily.
	StandardSchedule_DAILY StandardSchedule_RecurrenceType = 2
	// The `BackupRule` is to be applied weekly.
	StandardSchedule_WEEKLY StandardSchedule_RecurrenceType = 3
	// The `BackupRule` is to be applied monthly.
	StandardSchedule_MONTHLY StandardSchedule_RecurrenceType = 4
	// The `BackupRule` is to be applied yearly.
	StandardSchedule_YEARLY StandardSchedule_RecurrenceType = 5
)

// Enum value maps for StandardSchedule_RecurrenceType.
var (
	StandardSchedule_RecurrenceType_name = map[int32]string{
		0: "RECURRENCE_TYPE_UNSPECIFIED",
		1: "HOURLY",
		2: "DAILY",
		3: "WEEKLY",
		4: "MONTHLY",
		5: "YEARLY",
	}
	StandardSchedule_RecurrenceType_value = map[string]int32{
		"RECURRENCE_TYPE_UNSPECIFIED": 0,
		"HOURLY":                      1,
		"DAILY":                       2,
		"WEEKLY":                      3,
		"MONTHLY":                     4,
		"YEARLY":                      5,
	}
)

func (x StandardSchedule_RecurrenceType) Enum() *StandardSchedule_RecurrenceType {
	p := new(StandardSchedule_RecurrenceType)
	*p = x
	return p
}

func (x StandardSchedule_RecurrenceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StandardSchedule_RecurrenceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupplan_proto_enumTypes[1].Descriptor()
}

func (StandardSchedule_RecurrenceType) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupplan_proto_enumTypes[1]
}

func (x StandardSchedule_RecurrenceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StandardSchedule_RecurrenceType.Descriptor instead.
func (StandardSchedule_RecurrenceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{2, 0}
}

// `WeekOfMonth` enumerates possible weeks in the month, e.g. the first,
// third, or last week of the month.
type WeekDayOfMonth_WeekOfMonth int32

const (
	// The zero value. Do not use.
	WeekDayOfMonth_WEEK_OF_MONTH_UNSPECIFIED WeekDayOfMonth_WeekOfMonth = 0
	// The first week of the month.
	WeekDayOfMonth_FIRST WeekDayOfMonth_WeekOfMonth = 1
	// The second week of the month.
	WeekDayOfMonth_SECOND WeekDayOfMonth_WeekOfMonth = 2
	// The third week of the month.
	WeekDayOfMonth_THIRD WeekDayOfMonth_WeekOfMonth = 3
	// The fourth  week of the month.
	WeekDayOfMonth_FOURTH WeekDayOfMonth_WeekOfMonth = 4
	// The last  week of the month.
	WeekDayOfMonth_LAST WeekDayOfMonth_WeekOfMonth = 5
)

// Enum value maps for WeekDayOfMonth_WeekOfMonth.
var (
	WeekDayOfMonth_WeekOfMonth_name = map[int32]string{
		0: "WEEK_OF_MONTH_UNSPECIFIED",
		1: "FIRST",
		2: "SECOND",
		3: "THIRD",
		4: "FOURTH",
		5: "LAST",
	}
	WeekDayOfMonth_WeekOfMonth_value = map[string]int32{
		"WEEK_OF_MONTH_UNSPECIFIED": 0,
		"FIRST":                     1,
		"SECOND":                    2,
		"THIRD":                     3,
		"FOURTH":                    4,
		"LAST":                      5,
	}
)

func (x WeekDayOfMonth_WeekOfMonth) Enum() *WeekDayOfMonth_WeekOfMonth {
	p := new(WeekDayOfMonth_WeekOfMonth)
	*p = x
	return p
}

func (x WeekDayOfMonth_WeekOfMonth) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WeekDayOfMonth_WeekOfMonth) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupplan_proto_enumTypes[2].Descriptor()
}

func (WeekDayOfMonth_WeekOfMonth) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupplan_proto_enumTypes[2]
}

func (x WeekDayOfMonth_WeekOfMonth) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WeekDayOfMonth_WeekOfMonth.Descriptor instead.
func (WeekDayOfMonth_WeekOfMonth) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{4, 0}
}

// A `BackupPlan` specifies some common fields, such as `description` as well
// as one or more `BackupRule` messages. Each `BackupRule` has a retention
// policy and defines a schedule by which the system is to perform backup
// workloads.
type BackupPlan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of the `BackupPlan`.
	//
	// Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The description of the `BackupPlan` resource.
	//
	// The description allows for additional details about `BackupPlan` and its
	// use cases to be provided. An example description is the following:  "This
	// is a backup plan that performs a daily backup at 6pm and retains data for 3
	// months". The description must be at most 2048 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. This collection of key/value pairs allows for custom labels to be
	// supplied by the user.  Example, {"tag": "Weekly"}.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. When the `BackupPlan` was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. When the `BackupPlan` was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. The backup rules for this `BackupPlan`. There must be at least
	// one `BackupRule` message.
	BackupRules []*BackupRule `protobuf:"bytes,6,rep,name=backup_rules,json=backupRules,proto3" json:"backup_rules,omitempty"`
	// Output only. The `State` for the `BackupPlan`.
	State BackupPlan_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.backupdr.v1.BackupPlan_State" json:"state,omitempty"`
	// Required. The resource type to which the `BackupPlan` will be applied.
	// Examples include, "compute.googleapis.com/Instance",
	// "sqladmin.googleapis.com/Instance", or "alloydb.googleapis.com/Cluster".
	ResourceType string `protobuf:"bytes,8,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Optional. `etag` is returned from the service in the response. As a user of
	// the service, you may provide an etag value in this field to prevent stale
	// resources.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// Required. Resource name of backup vault which will be used as storage
	// location for backups. Format:
	// projects/{project}/locations/{location}/backupVaults/{backupvault}
	BackupVault string `protobuf:"bytes,10,opt,name=backup_vault,json=backupVault,proto3" json:"backup_vault,omitempty"`
	// Output only. The Google Cloud Platform Service Account to be used by the
	// BackupVault for taking backups. Specify the email address of the Backup
	// Vault Service Account.
	BackupVaultServiceAccount string `protobuf:"bytes,11,opt,name=backup_vault_service_account,json=backupVaultServiceAccount,proto3" json:"backup_vault_service_account,omitempty"`
}

func (x *BackupPlan) Reset() {
	*x = BackupPlan{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupPlan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupPlan) ProtoMessage() {}

func (x *BackupPlan) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupPlan.ProtoReflect.Descriptor instead.
func (*BackupPlan) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{0}
}

func (x *BackupPlan) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackupPlan) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *BackupPlan) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *BackupPlan) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BackupPlan) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BackupPlan) GetBackupRules() []*BackupRule {
	if x != nil {
		return x.BackupRules
	}
	return nil
}

func (x *BackupPlan) GetState() BackupPlan_State {
	if x != nil {
		return x.State
	}
	return BackupPlan_STATE_UNSPECIFIED
}

func (x *BackupPlan) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *BackupPlan) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *BackupPlan) GetBackupVault() string {
	if x != nil {
		return x.BackupVault
	}
	return ""
}

func (x *BackupPlan) GetBackupVaultServiceAccount() string {
	if x != nil {
		return x.BackupVaultServiceAccount
	}
	return ""
}

// `BackupRule` binds the backup schedule to a retention policy.
type BackupRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The unique id of this `BackupRule`. The `rule_id` is
	// unique per `BackupPlan`.The `rule_id` must start with a lowercase letter
	// followed by up to 62 lowercase letters, numbers, or hyphens. Pattern,
	// /[a-z][a-z0-9-]{,62}/.
	RuleId string `protobuf:"bytes,1,opt,name=rule_id,json=ruleId,proto3" json:"rule_id,omitempty"`
	// Required. Configures the duration for which backup data will be kept. It is
	// defined in “days”. The value should be greater than or equal to minimum
	// enforced retention of the backup vault.
	//
	// Minimum value is 1 and maximum value is 90 for hourly backups.
	// Minimum value is 1 and maximum value is 90 for daily backups.
	// Minimum value is 7 and maximum value is 186 for weekly backups.
	// Minimum value is 30 and maximum value is 732 for monthly backups.
	// Minimum value is 365 and maximum value is 36159 for yearly backups.
	BackupRetentionDays int32 `protobuf:"varint,4,opt,name=backup_retention_days,json=backupRetentionDays,proto3" json:"backup_retention_days,omitempty"`
	// The schedule that defines the automated backup workloads for this
	// `BackupRule`.
	//
	// Types that are assignable to BackupScheduleOneof:
	//
	//	*BackupRule_StandardSchedule
	BackupScheduleOneof isBackupRule_BackupScheduleOneof `protobuf_oneof:"backup_schedule_oneof"`
}

func (x *BackupRule) Reset() {
	*x = BackupRule{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupRule) ProtoMessage() {}

func (x *BackupRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupRule.ProtoReflect.Descriptor instead.
func (*BackupRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{1}
}

func (x *BackupRule) GetRuleId() string {
	if x != nil {
		return x.RuleId
	}
	return ""
}

func (x *BackupRule) GetBackupRetentionDays() int32 {
	if x != nil {
		return x.BackupRetentionDays
	}
	return 0
}

func (m *BackupRule) GetBackupScheduleOneof() isBackupRule_BackupScheduleOneof {
	if m != nil {
		return m.BackupScheduleOneof
	}
	return nil
}

func (x *BackupRule) GetStandardSchedule() *StandardSchedule {
	if x, ok := x.GetBackupScheduleOneof().(*BackupRule_StandardSchedule); ok {
		return x.StandardSchedule
	}
	return nil
}

type isBackupRule_BackupScheduleOneof interface {
	isBackupRule_BackupScheduleOneof()
}

type BackupRule_StandardSchedule struct {
	// Required. Defines a schedule that runs within the confines of a defined
	// window of time.
	StandardSchedule *StandardSchedule `protobuf:"bytes,5,opt,name=standard_schedule,json=standardSchedule,proto3,oneof"`
}

func (*BackupRule_StandardSchedule) isBackupRule_BackupScheduleOneof() {}

// `StandardSchedule` defines a schedule that run within the confines of a
// defined window of days. We can define recurrence type for schedule as
// HOURLY, DAILY, WEEKLY, MONTHLY or YEARLY.
type StandardSchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies the `RecurrenceType` for the schedule.
	RecurrenceType StandardSchedule_RecurrenceType `protobuf:"varint,1,opt,name=recurrence_type,json=recurrenceType,proto3,enum=google.cloud.backupdr.v1.StandardSchedule_RecurrenceType" json:"recurrence_type,omitempty"`
	// Optional. Specifies frequency for hourly backups. A hourly frequency of 2
	// means jobs will run every 2 hours from start time till end time defined.
	//
	// This is required for `recurrence_type`, `HOURLY` and is not applicable
	// otherwise. A validation error will occur if a value is supplied and
	// `recurrence_type` is not `HOURLY`.
	//
	// Value of hourly frequency should be between 6 and 23.
	//
	// Reason for limit : We found that there is bandwidth limitation of 3GB/S for
	// GMI while taking a backup and 5GB/S while doing a restore. Given the amount
	// of parallel backups and restore we are targeting, this will potentially
	// take the backup time to mins and hours (in worst case scenario).
	HourlyFrequency int32 `protobuf:"varint,2,opt,name=hourly_frequency,json=hourlyFrequency,proto3" json:"hourly_frequency,omitempty"`
	// Optional. Specifies days of week like, MONDAY or TUESDAY, on which jobs
	// will run.
	//
	// This is required for `recurrence_type`, `WEEKLY` and is not applicable
	// otherwise. A validation error will occur if a value is supplied and
	// `recurrence_type` is not `WEEKLY`.
	DaysOfWeek []dayofweek.DayOfWeek `protobuf:"varint,3,rep,packed,name=days_of_week,json=daysOfWeek,proto3,enum=google.type.DayOfWeek" json:"days_of_week,omitempty"`
	// Optional. Specifies days of months like 1, 5, or 14 on which jobs will run.
	//
	// Values for `days_of_month` are only applicable for `recurrence_type`,
	// `MONTHLY` and `YEARLY`. A validation error will occur if other values are
	// supplied.
	DaysOfMonth []int32 `protobuf:"varint,4,rep,packed,name=days_of_month,json=daysOfMonth,proto3" json:"days_of_month,omitempty"`
	// Optional. Specifies a week day of the month like, FIRST SUNDAY or LAST
	// MONDAY, on which jobs will run. This will be specified by two fields in
	// `WeekDayOfMonth`, one for the day, e.g. `MONDAY`, and one for the week,
	// e.g. `LAST`.
	//
	// This field is only applicable for `recurrence_type`, `MONTHLY` and
	// `YEARLY`. A validation error will occur if other values are supplied.
	WeekDayOfMonth *WeekDayOfMonth `protobuf:"bytes,5,opt,name=week_day_of_month,json=weekDayOfMonth,proto3" json:"week_day_of_month,omitempty"`
	// Optional. Specifies the months of year, like `FEBRUARY` and/or `MAY`, on
	// which jobs will run.
	//
	// This field is only applicable when `recurrence_type` is `YEARLY`. A
	// validation error will occur if other values are supplied.
	Months []month.Month `protobuf:"varint,6,rep,packed,name=months,proto3,enum=google.type.Month" json:"months,omitempty"`
	// Required. A BackupWindow defines the window of day during which backup jobs
	// will run. Jobs are queued at the beginning of the window and will be marked
	// as `NOT_RUN` if they do not start by the end of the window.
	//
	// Note: running jobs will not be cancelled at the end of the window.
	BackupWindow *BackupWindow `protobuf:"bytes,7,opt,name=backup_window,json=backupWindow,proto3" json:"backup_window,omitempty"`
	// Required. The time zone to be used when interpreting the schedule.
	// The value of this field must be a time zone name from the IANA tz database.
	// See https://en.wikipedia.org/wiki/List_of_tz_database_time_zones for the
	// list of valid timezone names. For e.g., Europe/Paris.
	TimeZone string `protobuf:"bytes,8,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
}

func (x *StandardSchedule) Reset() {
	*x = StandardSchedule{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StandardSchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardSchedule) ProtoMessage() {}

func (x *StandardSchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardSchedule.ProtoReflect.Descriptor instead.
func (*StandardSchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{2}
}

func (x *StandardSchedule) GetRecurrenceType() StandardSchedule_RecurrenceType {
	if x != nil {
		return x.RecurrenceType
	}
	return StandardSchedule_RECURRENCE_TYPE_UNSPECIFIED
}

func (x *StandardSchedule) GetHourlyFrequency() int32 {
	if x != nil {
		return x.HourlyFrequency
	}
	return 0
}

func (x *StandardSchedule) GetDaysOfWeek() []dayofweek.DayOfWeek {
	if x != nil {
		return x.DaysOfWeek
	}
	return nil
}

func (x *StandardSchedule) GetDaysOfMonth() []int32 {
	if x != nil {
		return x.DaysOfMonth
	}
	return nil
}

func (x *StandardSchedule) GetWeekDayOfMonth() *WeekDayOfMonth {
	if x != nil {
		return x.WeekDayOfMonth
	}
	return nil
}

func (x *StandardSchedule) GetMonths() []month.Month {
	if x != nil {
		return x.Months
	}
	return nil
}

func (x *StandardSchedule) GetBackupWindow() *BackupWindow {
	if x != nil {
		return x.BackupWindow
	}
	return nil
}

func (x *StandardSchedule) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

// `BackupWindow` defines a window of the day during which backup jobs will run.
type BackupWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The hour of day (0-23) when the window starts for e.g. if value
	// of start hour of day is 6 that mean backup window start at 6:00.
	StartHourOfDay int32 `protobuf:"varint,1,opt,name=start_hour_of_day,json=startHourOfDay,proto3" json:"start_hour_of_day,omitempty"`
	// Required. The hour of day (1-24) when the window end for e.g. if value of
	// end hour of day is 10 that mean backup window end time is 10:00.
	//
	// End hour of day should be greater than start hour of day.
	// 0 <= start_hour_of_day < end_hour_of_day <= 24
	//
	// End hour of day is not include in backup window that mean if
	// end_hour_of_day= 10 jobs should start before 10:00.
	EndHourOfDay int32 `protobuf:"varint,2,opt,name=end_hour_of_day,json=endHourOfDay,proto3" json:"end_hour_of_day,omitempty"`
}

func (x *BackupWindow) Reset() {
	*x = BackupWindow{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupWindow) ProtoMessage() {}

func (x *BackupWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupWindow.ProtoReflect.Descriptor instead.
func (*BackupWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{3}
}

func (x *BackupWindow) GetStartHourOfDay() int32 {
	if x != nil {
		return x.StartHourOfDay
	}
	return 0
}

func (x *BackupWindow) GetEndHourOfDay() int32 {
	if x != nil {
		return x.EndHourOfDay
	}
	return 0
}

// `WeekDayOfMonth` defines the week day of the month on which the backups will
// run. The message combines a `WeekOfMonth` and `DayOfWeek` to produce values
// like `FIRST`/`MONDAY` or `LAST`/`FRIDAY`.
type WeekDayOfMonth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies the week of the month.
	WeekOfMonth WeekDayOfMonth_WeekOfMonth `protobuf:"varint,1,opt,name=week_of_month,json=weekOfMonth,proto3,enum=google.cloud.backupdr.v1.WeekDayOfMonth_WeekOfMonth" json:"week_of_month,omitempty"`
	// Required. Specifies the day of the week.
	DayOfWeek dayofweek.DayOfWeek `protobuf:"varint,2,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
}

func (x *WeekDayOfMonth) Reset() {
	*x = WeekDayOfMonth{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WeekDayOfMonth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WeekDayOfMonth) ProtoMessage() {}

func (x *WeekDayOfMonth) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WeekDayOfMonth.ProtoReflect.Descriptor instead.
func (*WeekDayOfMonth) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{4}
}

func (x *WeekDayOfMonth) GetWeekOfMonth() WeekDayOfMonth_WeekOfMonth {
	if x != nil {
		return x.WeekOfMonth
	}
	return WeekDayOfMonth_WEEK_OF_MONTH_UNSPECIFIED
}

func (x *WeekDayOfMonth) GetDayOfWeek() dayofweek.DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return dayofweek.DayOfWeek(0)
}

// The request message for creating a `BackupPlan`.
type CreateBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `BackupPlan` project and location in the format
	// `projects/{project}/locations/{location}`. In Cloud BackupDR locations
	// map to GCP regions, for example **us-central1**.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of the `BackupPlan` to create. The name must be unique
	// for the specified project and location.The name must start with a lowercase
	// letter followed by up to 62 lowercase letters, numbers, or hyphens.
	// Pattern, /[a-z][a-z0-9-]{,62}/.
	BackupPlanId string `protobuf:"bytes,2,opt,name=backup_plan_id,json=backupPlanId,proto3" json:"backup_plan_id,omitempty"`
	// Required. The `BackupPlan` resource object to create.
	BackupPlan *BackupPlan `protobuf:"bytes,3,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateBackupPlanRequest) Reset() {
	*x = CreateBackupPlanRequest{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupPlanRequest) ProtoMessage() {}

func (x *CreateBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{5}
}

func (x *CreateBackupPlanRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupPlanRequest) GetBackupPlanId() string {
	if x != nil {
		return x.BackupPlanId
	}
	return ""
}

func (x *CreateBackupPlanRequest) GetBackupPlan() *BackupPlan {
	if x != nil {
		return x.BackupPlan
	}
	return nil
}

func (x *CreateBackupPlanRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request message for getting a list `BackupPlan`.
type ListBackupPlansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location for which to retrieve `BackupPlans`
	// information. Format: `projects/{project}/locations/{location}`. In Cloud
	// BackupDR, locations map to GCP regions, for e.g. **us-central1**. To
	// retrieve backup plans for all locations, use "-" for the
	// `{location}` value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `BackupPlans` to return in a single
	// response. If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.backupdr.v1.ListBackupPlansResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.backupdr.v1.ListBackupPlansResponse.next_page_token]
	// received from a previous `ListBackupPlans` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListBackupPlans` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListBackupPlansRequest) Reset() {
	*x = ListBackupPlansRequest{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupPlansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlansRequest) ProtoMessage() {}

func (x *ListBackupPlansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlansRequest.ProtoReflect.Descriptor instead.
func (*ListBackupPlansRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{6}
}

func (x *ListBackupPlansRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupPlansRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupPlansRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupPlansRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupPlansRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response message for getting a list of `BackupPlan`.
type ListBackupPlansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of `BackupPlans` in the project for the specified
	// location.
	//
	// If the `{location}` value in the request is "-", the response contains a
	// list of resources from all locations. In case any location is unreachable,
	// the response will only return backup plans in reachable locations and
	// the 'unreachable' field will be populated with a list of unreachable
	// locations.
	// BackupPlan
	BackupPlans []*BackupPlan `protobuf:"bytes,1,rep,name=backup_plans,json=backupPlans,proto3" json:"backup_plans,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.backupdr.v1.ListBackupPlansRequest.page_token] in
	// a subsequent `ListBackupPlans` call to retrieve the next page of results.
	// If this field is omitted or empty, then there are no more results to
	// return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupPlansResponse) Reset() {
	*x = ListBackupPlansResponse{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupPlansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlansResponse) ProtoMessage() {}

func (x *ListBackupPlansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlansResponse.ProtoReflect.Descriptor instead.
func (*ListBackupPlansResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{7}
}

func (x *ListBackupPlansResponse) GetBackupPlans() []*BackupPlan {
	if x != nil {
		return x.BackupPlans
	}
	return nil
}

func (x *ListBackupPlansResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupPlansResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request message for getting a `BackupPlan`.
type GetBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the `BackupPlan` to retrieve.
	//
	// Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupPlanRequest) Reset() {
	*x = GetBackupPlanRequest{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupPlanRequest) ProtoMessage() {}

func (x *GetBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*GetBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{8}
}

func (x *GetBackupPlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for deleting a `BackupPlan`.
type DeleteBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the `BackupPlan` to delete.
	//
	// Format: `projects/{project}/locations/{location}/backupPlans/{backup_plan}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteBackupPlanRequest) Reset() {
	*x = DeleteBackupPlanRequest{}
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupPlanRequest) ProtoMessage() {}

func (x *DeleteBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteBackupPlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupPlanRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

var File_google_cloud_backupdr_v1_backupplan_proto protoreflect.FileDescriptor

var file_google_cloud_backupdr_v1_backupplan_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x64, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x79,
	0x6f, 0x66, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa8, 0x07, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x0c, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x4e, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x76, 0x61, 0x75,
	0x6c, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x56, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75,
	0x6c, 0x74, 0x12, 0x44, 0x0a, 0x1c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x76, 0x61, 0x75,
	0x6c, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x56, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x49,
	0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x04, 0x3a, 0x84, 0x01, 0xea, 0x41, 0x80, 0x01,
	0x0a, 0x22, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x7d, 0x2a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x73, 0x32, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x22, 0xdf, 0x01, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x12,
	0x1f, 0x0a, 0x07, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x72, 0x75, 0x6c, 0x65, 0x49, 0x64,
	0x12, 0x37, 0x0a, 0x15, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x12, 0x5e, 0x0a, 0x11, 0x73, 0x74, 0x61,
	0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x10, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72,
	0x64, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x17, 0x0a, 0x15, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x6f, 0x6e, 0x65,
	0x6f, 0x66, 0x22, 0x81, 0x05, 0x0a, 0x10, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x67, 0x0a, 0x0f, 0x72, 0x65, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x6e,
	0x64, 0x61, 0x72, 0x64, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x52, 0x65, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x2e, 0x0a, 0x10, 0x68, 0x6f, 0x75, 0x72, 0x6c, 0x79, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x68, 0x6f, 0x75, 0x72, 0x6c, 0x79, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x12, 0x3d, 0x0a, 0x0c, 0x64, 0x61, 0x79, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x61, 0x79, 0x73, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x12,
	0x27, 0x0a, 0x0d, 0x64, 0x61, 0x79, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x61, 0x79,
	0x73, 0x4f, 0x66, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x58, 0x0a, 0x11, 0x77, 0x65, 0x65, 0x6b,
	0x5f, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x65, 0x65, 0x6b, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x77, 0x65, 0x65, 0x6b, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x4d, 0x6f, 0x6e,
	0x74, 0x68, 0x12, 0x2f, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6d, 0x6f, 0x6e,
	0x74, 0x68, 0x73, 0x12, 0x50, 0x0a, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f,
	0x6e, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74,
	0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x22, 0x6d, 0x0a, 0x0e, 0x52, 0x65, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x43,
	0x55, 0x52, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x4f,
	0x55, 0x52, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x41, 0x49, 0x4c, 0x59, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x45, 0x45, 0x4b, 0x4c, 0x59, 0x10, 0x03, 0x12, 0x0b, 0x0a,
	0x07, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x4c, 0x59, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x59, 0x45,
	0x41, 0x52, 0x4c, 0x59, 0x10, 0x05, 0x22, 0x6a, 0x0a, 0x0c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x2e, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x68, 0x6f, 0x75, 0x72, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x48, 0x6f, 0x75,
	0x72, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x12, 0x2a, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x68, 0x6f,
	0x75, 0x72, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x48, 0x6f, 0x75, 0x72, 0x4f, 0x66, 0x44,
	0x61, 0x79, 0x22, 0x92, 0x02, 0x0a, 0x0e, 0x57, 0x65, 0x65, 0x6b, 0x44, 0x61, 0x79, 0x4f, 0x66,
	0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x5d, 0x0a, 0x0d, 0x77, 0x65, 0x65, 0x6b, 0x5f, 0x6f, 0x66,
	0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x65, 0x6b, 0x44, 0x61, 0x79, 0x4f,
	0x66, 0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x2e, 0x57, 0x65, 0x65, 0x6b, 0x4f, 0x66, 0x4d, 0x6f, 0x6e,
	0x74, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x77, 0x65, 0x65, 0x6b, 0x4f, 0x66, 0x4d,
	0x6f, 0x6e, 0x74, 0x68, 0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77,
	0x65, 0x65, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65,
	0x6b, 0x22, 0x64, 0x0a, 0x0b, 0x57, 0x65, 0x65, 0x6b, 0x4f, 0x66, 0x4d, 0x6f, 0x6e, 0x74, 0x68,
	0x12, 0x1d, 0x0a, 0x19, 0x57, 0x45, 0x45, 0x4b, 0x5f, 0x4f, 0x46, 0x5f, 0x4d, 0x4f, 0x4e, 0x54,
	0x48, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x46, 0x49, 0x52, 0x53, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x45,
	0x43, 0x4f, 0x4e, 0x44, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x48, 0x49, 0x52, 0x44, 0x10,
	0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x4f, 0x55, 0x52, 0x54, 0x48, 0x10, 0x04, 0x12, 0x08, 0x0a,
	0x04, 0x4c, 0x41, 0x53, 0x54, 0x10, 0x05, 0x22, 0x80, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x49, 0x64, 0x12, 0x4a, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x2a,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xdf, 0x01, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xac, 0x01, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x56, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x42, 0xbf, 0x01, 0x0a, 0x1c,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x70, 0x62, 0x3b, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44,
	0x52, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_backupdr_v1_backupplan_proto_rawDescOnce sync.Once
	file_google_cloud_backupdr_v1_backupplan_proto_rawDescData = file_google_cloud_backupdr_v1_backupplan_proto_rawDesc
)

func file_google_cloud_backupdr_v1_backupplan_proto_rawDescGZIP() []byte {
	file_google_cloud_backupdr_v1_backupplan_proto_rawDescOnce.Do(func() {
		file_google_cloud_backupdr_v1_backupplan_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_backupdr_v1_backupplan_proto_rawDescData)
	})
	return file_google_cloud_backupdr_v1_backupplan_proto_rawDescData
}

var file_google_cloud_backupdr_v1_backupplan_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_backupdr_v1_backupplan_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_backupdr_v1_backupplan_proto_goTypes = []any{
	(BackupPlan_State)(0),                // 0: google.cloud.backupdr.v1.BackupPlan.State
	(StandardSchedule_RecurrenceType)(0), // 1: google.cloud.backupdr.v1.StandardSchedule.RecurrenceType
	(WeekDayOfMonth_WeekOfMonth)(0),      // 2: google.cloud.backupdr.v1.WeekDayOfMonth.WeekOfMonth
	(*BackupPlan)(nil),                   // 3: google.cloud.backupdr.v1.BackupPlan
	(*BackupRule)(nil),                   // 4: google.cloud.backupdr.v1.BackupRule
	(*StandardSchedule)(nil),             // 5: google.cloud.backupdr.v1.StandardSchedule
	(*BackupWindow)(nil),                 // 6: google.cloud.backupdr.v1.BackupWindow
	(*WeekDayOfMonth)(nil),               // 7: google.cloud.backupdr.v1.WeekDayOfMonth
	(*CreateBackupPlanRequest)(nil),      // 8: google.cloud.backupdr.v1.CreateBackupPlanRequest
	(*ListBackupPlansRequest)(nil),       // 9: google.cloud.backupdr.v1.ListBackupPlansRequest
	(*ListBackupPlansResponse)(nil),      // 10: google.cloud.backupdr.v1.ListBackupPlansResponse
	(*GetBackupPlanRequest)(nil),         // 11: google.cloud.backupdr.v1.GetBackupPlanRequest
	(*DeleteBackupPlanRequest)(nil),      // 12: google.cloud.backupdr.v1.DeleteBackupPlanRequest
	nil,                                  // 13: google.cloud.backupdr.v1.BackupPlan.LabelsEntry
	(*timestamppb.Timestamp)(nil),        // 14: google.protobuf.Timestamp
	(dayofweek.DayOfWeek)(0),             // 15: google.type.DayOfWeek
	(month.Month)(0),                     // 16: google.type.Month
}
var file_google_cloud_backupdr_v1_backupplan_proto_depIdxs = []int32{
	13, // 0: google.cloud.backupdr.v1.BackupPlan.labels:type_name -> google.cloud.backupdr.v1.BackupPlan.LabelsEntry
	14, // 1: google.cloud.backupdr.v1.BackupPlan.create_time:type_name -> google.protobuf.Timestamp
	14, // 2: google.cloud.backupdr.v1.BackupPlan.update_time:type_name -> google.protobuf.Timestamp
	4,  // 3: google.cloud.backupdr.v1.BackupPlan.backup_rules:type_name -> google.cloud.backupdr.v1.BackupRule
	0,  // 4: google.cloud.backupdr.v1.BackupPlan.state:type_name -> google.cloud.backupdr.v1.BackupPlan.State
	5,  // 5: google.cloud.backupdr.v1.BackupRule.standard_schedule:type_name -> google.cloud.backupdr.v1.StandardSchedule
	1,  // 6: google.cloud.backupdr.v1.StandardSchedule.recurrence_type:type_name -> google.cloud.backupdr.v1.StandardSchedule.RecurrenceType
	15, // 7: google.cloud.backupdr.v1.StandardSchedule.days_of_week:type_name -> google.type.DayOfWeek
	7,  // 8: google.cloud.backupdr.v1.StandardSchedule.week_day_of_month:type_name -> google.cloud.backupdr.v1.WeekDayOfMonth
	16, // 9: google.cloud.backupdr.v1.StandardSchedule.months:type_name -> google.type.Month
	6,  // 10: google.cloud.backupdr.v1.StandardSchedule.backup_window:type_name -> google.cloud.backupdr.v1.BackupWindow
	2,  // 11: google.cloud.backupdr.v1.WeekDayOfMonth.week_of_month:type_name -> google.cloud.backupdr.v1.WeekDayOfMonth.WeekOfMonth
	15, // 12: google.cloud.backupdr.v1.WeekDayOfMonth.day_of_week:type_name -> google.type.DayOfWeek
	3,  // 13: google.cloud.backupdr.v1.CreateBackupPlanRequest.backup_plan:type_name -> google.cloud.backupdr.v1.BackupPlan
	3,  // 14: google.cloud.backupdr.v1.ListBackupPlansResponse.backup_plans:type_name -> google.cloud.backupdr.v1.BackupPlan
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_backupdr_v1_backupplan_proto_init() }
func file_google_cloud_backupdr_v1_backupplan_proto_init() {
	if File_google_cloud_backupdr_v1_backupplan_proto != nil {
		return
	}
	file_google_cloud_backupdr_v1_backupplan_proto_msgTypes[1].OneofWrappers = []any{
		(*BackupRule_StandardSchedule)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_backupdr_v1_backupplan_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_backupdr_v1_backupplan_proto_goTypes,
		DependencyIndexes: file_google_cloud_backupdr_v1_backupplan_proto_depIdxs,
		EnumInfos:         file_google_cloud_backupdr_v1_backupplan_proto_enumTypes,
		MessageInfos:      file_google_cloud_backupdr_v1_backupplan_proto_msgTypes,
	}.Build()
	File_google_cloud_backupdr_v1_backupplan_proto = out.File
	file_google_cloud_backupdr_v1_backupplan_proto_rawDesc = nil
	file_google_cloud_backupdr_v1_backupplan_proto_goTypes = nil
	file_google_cloud_backupdr_v1_backupplan_proto_depIdxs = nil
}
