// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/assuredworkloads/v1/assuredworkloads.proto

package assuredworkloadspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported Compliance Regimes.
type Workload_ComplianceRegime int32

const (
	// Unknown compliance regime.
	Workload_COMPLIANCE_REGIME_UNSPECIFIED Workload_ComplianceRegime = 0
	// Information protection as per DoD IL4 requirements.
	Workload_IL4 Workload_ComplianceRegime = 1
	// Criminal Justice Information Services (CJIS) Security policies.
	Workload_CJIS Workload_ComplianceRegime = 2
	// FedRAMP High data protection controls
	Workload_FEDRAMP_HIGH Workload_ComplianceRegime = 3
	// FedRAMP Moderate data protection controls
	Workload_FEDRAMP_MODERATE Workload_ComplianceRegime = 4
	// Assured Workloads For US Regions data protection controls
	Workload_US_REGIONAL_ACCESS Workload_ComplianceRegime = 5
	// Health Insurance Portability and Accountability Act controls
	Workload_HIPAA Workload_ComplianceRegime = 6
	// Health Information Trust Alliance controls
	Workload_HITRUST Workload_ComplianceRegime = 7
	// Assured Workloads For EU Regions and Support controls
	Workload_EU_REGIONS_AND_SUPPORT Workload_ComplianceRegime = 8
	// Assured Workloads For Canada Regions and Support controls
	Workload_CA_REGIONS_AND_SUPPORT Workload_ComplianceRegime = 9
	// International Traffic in Arms Regulations
	Workload_ITAR Workload_ComplianceRegime = 10
	// Assured Workloads for Australia Regions and Support controls
	// Available for public preview consumption.
	// Don't create production workloads.
	Workload_AU_REGIONS_AND_US_SUPPORT Workload_ComplianceRegime = 11
	// Assured Workloads for Partners
	Workload_ASSURED_WORKLOADS_FOR_PARTNERS Workload_ComplianceRegime = 12
)

// Enum value maps for Workload_ComplianceRegime.
var (
	Workload_ComplianceRegime_name = map[int32]string{
		0:  "COMPLIANCE_REGIME_UNSPECIFIED",
		1:  "IL4",
		2:  "CJIS",
		3:  "FEDRAMP_HIGH",
		4:  "FEDRAMP_MODERATE",
		5:  "US_REGIONAL_ACCESS",
		6:  "HIPAA",
		7:  "HITRUST",
		8:  "EU_REGIONS_AND_SUPPORT",
		9:  "CA_REGIONS_AND_SUPPORT",
		10: "ITAR",
		11: "AU_REGIONS_AND_US_SUPPORT",
		12: "ASSURED_WORKLOADS_FOR_PARTNERS",
	}
	Workload_ComplianceRegime_value = map[string]int32{
		"COMPLIANCE_REGIME_UNSPECIFIED":  0,
		"IL4":                            1,
		"CJIS":                           2,
		"FEDRAMP_HIGH":                   3,
		"FEDRAMP_MODERATE":               4,
		"US_REGIONAL_ACCESS":             5,
		"HIPAA":                          6,
		"HITRUST":                        7,
		"EU_REGIONS_AND_SUPPORT":         8,
		"CA_REGIONS_AND_SUPPORT":         9,
		"ITAR":                           10,
		"AU_REGIONS_AND_US_SUPPORT":      11,
		"ASSURED_WORKLOADS_FOR_PARTNERS": 12,
	}
)

func (x Workload_ComplianceRegime) Enum() *Workload_ComplianceRegime {
	p := new(Workload_ComplianceRegime)
	*p = x
	return p
}

func (x Workload_ComplianceRegime) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_ComplianceRegime) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[0].Descriptor()
}

func (Workload_ComplianceRegime) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[0]
}

func (x Workload_ComplianceRegime) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_ComplianceRegime.Descriptor instead.
func (Workload_ComplianceRegime) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 0}
}

// Key Access Justifications(KAJ) Enrollment State.
type Workload_KajEnrollmentState int32

const (
	// Default State for KAJ Enrollment.
	Workload_KAJ_ENROLLMENT_STATE_UNSPECIFIED Workload_KajEnrollmentState = 0
	// Pending State for KAJ Enrollment.
	Workload_KAJ_ENROLLMENT_STATE_PENDING Workload_KajEnrollmentState = 1
	// Complete State for KAJ Enrollment.
	Workload_KAJ_ENROLLMENT_STATE_COMPLETE Workload_KajEnrollmentState = 2
)

// Enum value maps for Workload_KajEnrollmentState.
var (
	Workload_KajEnrollmentState_name = map[int32]string{
		0: "KAJ_ENROLLMENT_STATE_UNSPECIFIED",
		1: "KAJ_ENROLLMENT_STATE_PENDING",
		2: "KAJ_ENROLLMENT_STATE_COMPLETE",
	}
	Workload_KajEnrollmentState_value = map[string]int32{
		"KAJ_ENROLLMENT_STATE_UNSPECIFIED": 0,
		"KAJ_ENROLLMENT_STATE_PENDING":     1,
		"KAJ_ENROLLMENT_STATE_COMPLETE":    2,
	}
)

func (x Workload_KajEnrollmentState) Enum() *Workload_KajEnrollmentState {
	p := new(Workload_KajEnrollmentState)
	*p = x
	return p
}

func (x Workload_KajEnrollmentState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_KajEnrollmentState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[1].Descriptor()
}

func (Workload_KajEnrollmentState) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[1]
}

func (x Workload_KajEnrollmentState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_KajEnrollmentState.Descriptor instead.
func (Workload_KajEnrollmentState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 1}
}

// Supported Assured Workloads Partners.
type Workload_Partner int32

const (
	// Unknown partner regime/controls.
	Workload_PARTNER_UNSPECIFIED Workload_Partner = 0
	// S3NS regime/controls.
	Workload_LOCAL_CONTROLS_BY_S3NS Workload_Partner = 1
)

// Enum value maps for Workload_Partner.
var (
	Workload_Partner_name = map[int32]string{
		0: "PARTNER_UNSPECIFIED",
		1: "LOCAL_CONTROLS_BY_S3NS",
	}
	Workload_Partner_value = map[string]int32{
		"PARTNER_UNSPECIFIED":    0,
		"LOCAL_CONTROLS_BY_S3NS": 1,
	}
)

func (x Workload_Partner) Enum() *Workload_Partner {
	p := new(Workload_Partner)
	*p = x
	return p
}

func (x Workload_Partner) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_Partner) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[2].Descriptor()
}

func (Workload_Partner) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[2]
}

func (x Workload_Partner) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_Partner.Descriptor instead.
func (Workload_Partner) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 2}
}

// The type of resource.
type Workload_ResourceInfo_ResourceType int32

const (
	// Unknown resource type.
	Workload_ResourceInfo_RESOURCE_TYPE_UNSPECIFIED Workload_ResourceInfo_ResourceType = 0
	// Consumer project.
	// AssuredWorkloads Projects are no longer supported. This field will be
	// ignored only in CreateWorkload requests. ListWorkloads and GetWorkload
	// will continue to provide projects information.
	// Use CONSUMER_FOLDER instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/assuredworkloads/v1/assuredworkloads.proto.
	Workload_ResourceInfo_CONSUMER_PROJECT Workload_ResourceInfo_ResourceType = 1
	// Consumer Folder.
	Workload_ResourceInfo_CONSUMER_FOLDER Workload_ResourceInfo_ResourceType = 4
	// Consumer project containing encryption keys.
	Workload_ResourceInfo_ENCRYPTION_KEYS_PROJECT Workload_ResourceInfo_ResourceType = 2
	// Keyring resource that hosts encryption keys.
	Workload_ResourceInfo_KEYRING Workload_ResourceInfo_ResourceType = 3
)

// Enum value maps for Workload_ResourceInfo_ResourceType.
var (
	Workload_ResourceInfo_ResourceType_name = map[int32]string{
		0: "RESOURCE_TYPE_UNSPECIFIED",
		1: "CONSUMER_PROJECT",
		4: "CONSUMER_FOLDER",
		2: "ENCRYPTION_KEYS_PROJECT",
		3: "KEYRING",
	}
	Workload_ResourceInfo_ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED": 0,
		"CONSUMER_PROJECT":          1,
		"CONSUMER_FOLDER":           4,
		"ENCRYPTION_KEYS_PROJECT":   2,
		"KEYRING":                   3,
	}
)

func (x Workload_ResourceInfo_ResourceType) Enum() *Workload_ResourceInfo_ResourceType {
	p := new(Workload_ResourceInfo_ResourceType)
	*p = x
	return p
}

func (x Workload_ResourceInfo_ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_ResourceInfo_ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[3].Descriptor()
}

func (Workload_ResourceInfo_ResourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[3]
}

func (x Workload_ResourceInfo_ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_ResourceInfo_ResourceType.Descriptor instead.
func (Workload_ResourceInfo_ResourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 0, 0}
}

// Setup state of SAA enrollment.
type Workload_SaaEnrollmentResponse_SetupState int32

const (
	// Unspecified.
	Workload_SaaEnrollmentResponse_SETUP_STATE_UNSPECIFIED Workload_SaaEnrollmentResponse_SetupState = 0
	// SAA enrollment pending.
	Workload_SaaEnrollmentResponse_STATUS_PENDING Workload_SaaEnrollmentResponse_SetupState = 1
	// SAA enrollment comopleted.
	Workload_SaaEnrollmentResponse_STATUS_COMPLETE Workload_SaaEnrollmentResponse_SetupState = 2
)

// Enum value maps for Workload_SaaEnrollmentResponse_SetupState.
var (
	Workload_SaaEnrollmentResponse_SetupState_name = map[int32]string{
		0: "SETUP_STATE_UNSPECIFIED",
		1: "STATUS_PENDING",
		2: "STATUS_COMPLETE",
	}
	Workload_SaaEnrollmentResponse_SetupState_value = map[string]int32{
		"SETUP_STATE_UNSPECIFIED": 0,
		"STATUS_PENDING":          1,
		"STATUS_COMPLETE":         2,
	}
)

func (x Workload_SaaEnrollmentResponse_SetupState) Enum() *Workload_SaaEnrollmentResponse_SetupState {
	p := new(Workload_SaaEnrollmentResponse_SetupState)
	*p = x
	return p
}

func (x Workload_SaaEnrollmentResponse_SetupState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_SaaEnrollmentResponse_SetupState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[4].Descriptor()
}

func (Workload_SaaEnrollmentResponse_SetupState) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[4]
}

func (x Workload_SaaEnrollmentResponse_SetupState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_SaaEnrollmentResponse_SetupState.Descriptor instead.
func (Workload_SaaEnrollmentResponse_SetupState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 3, 0}
}

// Setup error of SAA enrollment.
type Workload_SaaEnrollmentResponse_SetupError int32

const (
	// Unspecified.
	Workload_SaaEnrollmentResponse_SETUP_ERROR_UNSPECIFIED Workload_SaaEnrollmentResponse_SetupError = 0
	// Invalid states for all customers, to be redirected to AA UI for
	// additional details.
	Workload_SaaEnrollmentResponse_ERROR_INVALID_BASE_SETUP Workload_SaaEnrollmentResponse_SetupError = 1
	// Returned when there is not an EKM key configured.
	Workload_SaaEnrollmentResponse_ERROR_MISSING_EXTERNAL_SIGNING_KEY Workload_SaaEnrollmentResponse_SetupError = 2
	// Returned when there are no enrolled services or the customer is
	// enrolled in CAA only for a subset of services.
	Workload_SaaEnrollmentResponse_ERROR_NOT_ALL_SERVICES_ENROLLED Workload_SaaEnrollmentResponse_SetupError = 3
	// Returned when exception was encountered during evaluation of other
	// criteria.
	Workload_SaaEnrollmentResponse_ERROR_SETUP_CHECK_FAILED Workload_SaaEnrollmentResponse_SetupError = 4
)

// Enum value maps for Workload_SaaEnrollmentResponse_SetupError.
var (
	Workload_SaaEnrollmentResponse_SetupError_name = map[int32]string{
		0: "SETUP_ERROR_UNSPECIFIED",
		1: "ERROR_INVALID_BASE_SETUP",
		2: "ERROR_MISSING_EXTERNAL_SIGNING_KEY",
		3: "ERROR_NOT_ALL_SERVICES_ENROLLED",
		4: "ERROR_SETUP_CHECK_FAILED",
	}
	Workload_SaaEnrollmentResponse_SetupError_value = map[string]int32{
		"SETUP_ERROR_UNSPECIFIED":            0,
		"ERROR_INVALID_BASE_SETUP":           1,
		"ERROR_MISSING_EXTERNAL_SIGNING_KEY": 2,
		"ERROR_NOT_ALL_SERVICES_ENROLLED":    3,
		"ERROR_SETUP_CHECK_FAILED":           4,
	}
)

func (x Workload_SaaEnrollmentResponse_SetupError) Enum() *Workload_SaaEnrollmentResponse_SetupError {
	p := new(Workload_SaaEnrollmentResponse_SetupError)
	*p = x
	return p
}

func (x Workload_SaaEnrollmentResponse_SetupError) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Workload_SaaEnrollmentResponse_SetupError) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[5].Descriptor()
}

func (Workload_SaaEnrollmentResponse_SetupError) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[5]
}

func (x Workload_SaaEnrollmentResponse_SetupError) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Workload_SaaEnrollmentResponse_SetupError.Descriptor instead.
func (Workload_SaaEnrollmentResponse_SetupError) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 3, 1}
}

// The type of restriction.
type RestrictAllowedResourcesRequest_RestrictionType int32

const (
	// Unknown restriction type.
	RestrictAllowedResourcesRequest_RESTRICTION_TYPE_UNSPECIFIED RestrictAllowedResourcesRequest_RestrictionType = 0
	// Allow the use all of all gcp products, irrespective of the compliance
	// posture. This effectively removes gcp.restrictServiceUsage OrgPolicy
	// on the AssuredWorkloads Folder.
	RestrictAllowedResourcesRequest_ALLOW_ALL_GCP_RESOURCES RestrictAllowedResourcesRequest_RestrictionType = 1
	// Based on Workload's compliance regime, allowed list changes.
	// See - https://cloud.google.com/assured-workloads/docs/supported-products
	// for the list of supported resources.
	RestrictAllowedResourcesRequest_ALLOW_COMPLIANT_RESOURCES RestrictAllowedResourcesRequest_RestrictionType = 2
)

// Enum value maps for RestrictAllowedResourcesRequest_RestrictionType.
var (
	RestrictAllowedResourcesRequest_RestrictionType_name = map[int32]string{
		0: "RESTRICTION_TYPE_UNSPECIFIED",
		1: "ALLOW_ALL_GCP_RESOURCES",
		2: "ALLOW_COMPLIANT_RESOURCES",
	}
	RestrictAllowedResourcesRequest_RestrictionType_value = map[string]int32{
		"RESTRICTION_TYPE_UNSPECIFIED": 0,
		"ALLOW_ALL_GCP_RESOURCES":      1,
		"ALLOW_COMPLIANT_RESOURCES":    2,
	}
)

func (x RestrictAllowedResourcesRequest_RestrictionType) Enum() *RestrictAllowedResourcesRequest_RestrictionType {
	p := new(RestrictAllowedResourcesRequest_RestrictionType)
	*p = x
	return p
}

func (x RestrictAllowedResourcesRequest_RestrictionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestrictAllowedResourcesRequest_RestrictionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[6].Descriptor()
}

func (RestrictAllowedResourcesRequest_RestrictionType) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[6]
}

func (x RestrictAllowedResourcesRequest_RestrictionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestrictAllowedResourcesRequest_RestrictionType.Descriptor instead.
func (RestrictAllowedResourcesRequest_RestrictionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{8, 0}
}

// Violation State Values
type Violation_State int32

const (
	// Unspecified state.
	Violation_STATE_UNSPECIFIED Violation_State = 0
	// Violation is resolved.
	Violation_RESOLVED Violation_State = 2
	// Violation is Unresolved
	Violation_UNRESOLVED Violation_State = 3
	// Violation is Exception
	Violation_EXCEPTION Violation_State = 4
)

// Enum value maps for Violation_State.
var (
	Violation_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		2: "RESOLVED",
		3: "UNRESOLVED",
		4: "EXCEPTION",
	}
	Violation_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RESOLVED":          2,
		"UNRESOLVED":        3,
		"EXCEPTION":         4,
	}
)

func (x Violation_State) Enum() *Violation_State {
	p := new(Violation_State)
	*p = x
	return p
}

func (x Violation_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Violation_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[7].Descriptor()
}

func (Violation_State) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[7]
}

func (x Violation_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Violation_State.Descriptor instead.
func (Violation_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{16, 0}
}

// Classifying remediation into various types based on the kind of
// violation. For example, violations caused due to changes in boolean org
// policy requires different remediation instructions compared to violation
// caused due to changes in allowed values of list org policy.
type Violation_Remediation_RemediationType int32

const (
	// Unspecified remediation type
	Violation_Remediation_REMEDIATION_TYPE_UNSPECIFIED Violation_Remediation_RemediationType = 0
	// Remediation type for boolean org policy
	Violation_Remediation_REMEDIATION_BOOLEAN_ORG_POLICY_VIOLATION Violation_Remediation_RemediationType = 1
	// Remediation type for list org policy which have allowed values in the
	// monitoring rule
	Violation_Remediation_REMEDIATION_LIST_ALLOWED_VALUES_ORG_POLICY_VIOLATION Violation_Remediation_RemediationType = 2
	// Remediation type for list org policy which have denied values in the
	// monitoring rule
	Violation_Remediation_REMEDIATION_LIST_DENIED_VALUES_ORG_POLICY_VIOLATION Violation_Remediation_RemediationType = 3
	// Remediation type for gcp.restrictCmekCryptoKeyProjects
	Violation_Remediation_REMEDIATION_RESTRICT_CMEK_CRYPTO_KEY_PROJECTS_ORG_POLICY_VIOLATION Violation_Remediation_RemediationType = 4
)

// Enum value maps for Violation_Remediation_RemediationType.
var (
	Violation_Remediation_RemediationType_name = map[int32]string{
		0: "REMEDIATION_TYPE_UNSPECIFIED",
		1: "REMEDIATION_BOOLEAN_ORG_POLICY_VIOLATION",
		2: "REMEDIATION_LIST_ALLOWED_VALUES_ORG_POLICY_VIOLATION",
		3: "REMEDIATION_LIST_DENIED_VALUES_ORG_POLICY_VIOLATION",
		4: "REMEDIATION_RESTRICT_CMEK_CRYPTO_KEY_PROJECTS_ORG_POLICY_VIOLATION",
	}
	Violation_Remediation_RemediationType_value = map[string]int32{
		"REMEDIATION_TYPE_UNSPECIFIED":                                       0,
		"REMEDIATION_BOOLEAN_ORG_POLICY_VIOLATION":                           1,
		"REMEDIATION_LIST_ALLOWED_VALUES_ORG_POLICY_VIOLATION":               2,
		"REMEDIATION_LIST_DENIED_VALUES_ORG_POLICY_VIOLATION":                3,
		"REMEDIATION_RESTRICT_CMEK_CRYPTO_KEY_PROJECTS_ORG_POLICY_VIOLATION": 4,
	}
)

func (x Violation_Remediation_RemediationType) Enum() *Violation_Remediation_RemediationType {
	p := new(Violation_Remediation_RemediationType)
	*p = x
	return p
}

func (x Violation_Remediation_RemediationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Violation_Remediation_RemediationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[8].Descriptor()
}

func (Violation_Remediation_RemediationType) Type() protoreflect.EnumType {
	return &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes[8]
}

func (x Violation_Remediation_RemediationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Violation_Remediation_RemediationType.Descriptor instead.
func (Violation_Remediation_RemediationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{16, 0, 0}
}

// Request for creating a workload.
type CreateWorkloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the new Workload's parent.
	// Must be of the form `organizations/{org_id}/locations/{location_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Assured Workload to create
	Workload *Workload `protobuf:"bytes,2,opt,name=workload,proto3" json:"workload,omitempty"`
	// Optional. A identifier associated with the workload and underlying projects which
	// allows for the break down of billing costs for a workload. The value
	// provided for the identifier will add a label to the workload and contained
	// projects with the identifier as the value.
	ExternalId string `protobuf:"bytes,3,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
}

func (x *CreateWorkloadRequest) Reset() {
	*x = CreateWorkloadRequest{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateWorkloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkloadRequest) ProtoMessage() {}

func (x *CreateWorkloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkloadRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkloadRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{0}
}

func (x *CreateWorkloadRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkloadRequest) GetWorkload() *Workload {
	if x != nil {
		return x.Workload
	}
	return nil
}

func (x *CreateWorkloadRequest) GetExternalId() string {
	if x != nil {
		return x.ExternalId
	}
	return ""
}

// Request for Updating a workload.
type UpdateWorkloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The workload to update.
	// The workload's `name` field is used to identify the workload to be updated.
	// Format:
	// organizations/{org_id}/locations/{location_id}/workloads/{workload_id}
	Workload *Workload `protobuf:"bytes,1,opt,name=workload,proto3" json:"workload,omitempty"`
	// Required. The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateWorkloadRequest) Reset() {
	*x = UpdateWorkloadRequest{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateWorkloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkloadRequest) ProtoMessage() {}

func (x *UpdateWorkloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkloadRequest.ProtoReflect.Descriptor instead.
func (*UpdateWorkloadRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateWorkloadRequest) GetWorkload() *Workload {
	if x != nil {
		return x.Workload
	}
	return nil
}

func (x *UpdateWorkloadRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for deleting a Workload.
type DeleteWorkloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `name` field is used to identify the workload.
	// Format:
	// organizations/{org_id}/locations/{location_id}/workloads/{workload_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The etag of the workload.
	// If this is provided, it must match the server's etag.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteWorkloadRequest) Reset() {
	*x = DeleteWorkloadRequest{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteWorkloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkloadRequest) ProtoMessage() {}

func (x *DeleteWorkloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkloadRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkloadRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{2}
}

func (x *DeleteWorkloadRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteWorkloadRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request for fetching a workload.
type GetWorkloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Workload to fetch. This is the workload's
	// relative path in the API, formatted as
	// "organizations/{organization_id}/locations/{location_id}/workloads/{workload_id}".
	// For example,
	// "organizations/123/locations/us-east1/workloads/assured-workload-1".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkloadRequest) Reset() {
	*x = GetWorkloadRequest{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetWorkloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkloadRequest) ProtoMessage() {}

func (x *GetWorkloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkloadRequest.ProtoReflect.Descriptor instead.
func (*GetWorkloadRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{3}
}

func (x *GetWorkloadRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for fetching workloads in an organization.
type ListWorkloadsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent Resource to list workloads from.
	// Must be of the form `organizations/{org_id}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token returned from previous request. Page token contains context from
	// previous request. Page token needs to be passed in the second and following
	// requests.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A custom filter for filtering by properties of a workload. At this time,
	// only filtering by labels is supported.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListWorkloadsRequest) Reset() {
	*x = ListWorkloadsRequest{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListWorkloadsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadsRequest) ProtoMessage() {}

func (x *ListWorkloadsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadsRequest.ProtoReflect.Descriptor instead.
func (*ListWorkloadsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{4}
}

func (x *ListWorkloadsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWorkloadsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWorkloadsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListWorkloadsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response of ListWorkloads endpoint.
type ListWorkloadsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Workloads under a given parent.
	Workloads []*Workload `protobuf:"bytes,1,rep,name=workloads,proto3" json:"workloads,omitempty"`
	// The next page token. Return empty if reached the last page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListWorkloadsResponse) Reset() {
	*x = ListWorkloadsResponse{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListWorkloadsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkloadsResponse) ProtoMessage() {}

func (x *ListWorkloadsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkloadsResponse.ProtoReflect.Descriptor instead.
func (*ListWorkloadsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{5}
}

func (x *ListWorkloadsResponse) GetWorkloads() []*Workload {
	if x != nil {
		return x.Workloads
	}
	return nil
}

func (x *ListWorkloadsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A Workload object for managing highly regulated workloads of cloud
// customers.
type Workload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The resource name of the workload.
	// Format:
	// organizations/{organization}/locations/{location}/workloads/{workload}
	//
	// Read-only.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user-assigned display name of the Workload.
	// When present it must be between 4 to 30 characters.
	// Allowed characters are: lowercase and uppercase letters, numbers,
	// hyphen, and spaces.
	//
	// Example: My Workload
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The resources associated with this workload.
	// These resources will be created when creating the workload.
	// If any of the projects already exist, the workload creation will fail.
	// Always read only.
	Resources []*Workload_ResourceInfo `protobuf:"bytes,3,rep,name=resources,proto3" json:"resources,omitempty"`
	// Required. Immutable. Compliance Regime associated with this workload.
	ComplianceRegime Workload_ComplianceRegime `protobuf:"varint,4,opt,name=compliance_regime,json=complianceRegime,proto3,enum=google.cloud.assuredworkloads.v1.Workload_ComplianceRegime" json:"compliance_regime,omitempty"`
	// Output only. Immutable. The Workload creation timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. The billing account used for the resources which are
	// direct children of workload. This billing account is initially associated
	// with the resources created as part of Workload creation.
	// After the initial creation of these resources, the customer can change
	// the assigned billing account.
	// The resource name has the form
	// `billingAccounts/{billing_account_id}`. For example,
	// `billingAccounts/012345-567890-ABCDEF`.
	BillingAccount string `protobuf:"bytes,6,opt,name=billing_account,json=billingAccount,proto3" json:"billing_account,omitempty"`
	// Optional. ETag of the workload, it is calculated on the basis
	// of the Workload contents. It will be used in Update & Delete operations.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Labels applied to the workload.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Input only. The parent resource for the resources managed by this Assured Workload. May
	// be either empty or a folder resource which is a child of the
	// Workload parent. If not specified all resources are created under the
	// parent organization.
	// Format:
	// folders/{folder_id}
	ProvisionedResourcesParent string `protobuf:"bytes,13,opt,name=provisioned_resources_parent,json=provisionedResourcesParent,proto3" json:"provisioned_resources_parent,omitempty"`
	// Input only. Settings used to create a CMEK crypto key. When set, a project with a KMS
	// CMEK key is provisioned.
	// This field is deprecated as of Feb 28, 2022.
	// In order to create a Keyring, callers should specify,
	// ENCRYPTION_KEYS_PROJECT or KEYRING in ResourceSettings.resource_type field.
	//
	// Deprecated: Marked as deprecated in google/cloud/assuredworkloads/v1/assuredworkloads.proto.
	KmsSettings *Workload_KMSSettings `protobuf:"bytes,14,opt,name=kms_settings,json=kmsSettings,proto3" json:"kms_settings,omitempty"`
	// Input only. Resource properties that are used to customize workload resources.
	// These properties (such as custom project id) will be used to create
	// workload resources if possible. This field is optional.
	ResourceSettings []*Workload_ResourceSettings `protobuf:"bytes,15,rep,name=resource_settings,json=resourceSettings,proto3" json:"resource_settings,omitempty"`
	// Output only. Represents the KAJ enrollment state of the given workload.
	KajEnrollmentState Workload_KajEnrollmentState `protobuf:"varint,17,opt,name=kaj_enrollment_state,json=kajEnrollmentState,proto3,enum=google.cloud.assuredworkloads.v1.Workload_KajEnrollmentState" json:"kaj_enrollment_state,omitempty"`
	// Optional. Indicates the sovereignty status of the given workload.
	// Currently meant to be used by Europe/Canada customers.
	EnableSovereignControls bool `protobuf:"varint,18,opt,name=enable_sovereign_controls,json=enableSovereignControls,proto3" json:"enable_sovereign_controls,omitempty"`
	// Output only. Represents the SAA enrollment response of the given workload.
	// SAA enrollment response is queried during GetWorkload call.
	// In failure cases, user friendly error message is shown in SAA details page.
	SaaEnrollmentResponse *Workload_SaaEnrollmentResponse `protobuf:"bytes,20,opt,name=saa_enrollment_response,json=saaEnrollmentResponse,proto3" json:"saa_enrollment_response,omitempty"`
	// Output only. Urls for services which are compliant for this Assured Workload, but which
	// are currently disallowed by the ResourceUsageRestriction org policy.
	// Invoke RestrictAllowedResources endpoint to allow your project developers
	// to use these services in their environment."
	CompliantButDisallowedServices []string `protobuf:"bytes,24,rep,name=compliant_but_disallowed_services,json=compliantButDisallowedServices,proto3" json:"compliant_but_disallowed_services,omitempty"`
	// Optional. Compliance Regime associated with this workload.
	Partner Workload_Partner `protobuf:"varint,25,opt,name=partner,proto3,enum=google.cloud.assuredworkloads.v1.Workload_Partner" json:"partner,omitempty"`
}

func (x *Workload) Reset() {
	*x = Workload{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Workload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload) ProtoMessage() {}

func (x *Workload) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload.ProtoReflect.Descriptor instead.
func (*Workload) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6}
}

func (x *Workload) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Workload) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Workload) GetResources() []*Workload_ResourceInfo {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Workload) GetComplianceRegime() Workload_ComplianceRegime {
	if x != nil {
		return x.ComplianceRegime
	}
	return Workload_COMPLIANCE_REGIME_UNSPECIFIED
}

func (x *Workload) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Workload) GetBillingAccount() string {
	if x != nil {
		return x.BillingAccount
	}
	return ""
}

func (x *Workload) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Workload) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Workload) GetProvisionedResourcesParent() string {
	if x != nil {
		return x.ProvisionedResourcesParent
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/assuredworkloads/v1/assuredworkloads.proto.
func (x *Workload) GetKmsSettings() *Workload_KMSSettings {
	if x != nil {
		return x.KmsSettings
	}
	return nil
}

func (x *Workload) GetResourceSettings() []*Workload_ResourceSettings {
	if x != nil {
		return x.ResourceSettings
	}
	return nil
}

func (x *Workload) GetKajEnrollmentState() Workload_KajEnrollmentState {
	if x != nil {
		return x.KajEnrollmentState
	}
	return Workload_KAJ_ENROLLMENT_STATE_UNSPECIFIED
}

func (x *Workload) GetEnableSovereignControls() bool {
	if x != nil {
		return x.EnableSovereignControls
	}
	return false
}

func (x *Workload) GetSaaEnrollmentResponse() *Workload_SaaEnrollmentResponse {
	if x != nil {
		return x.SaaEnrollmentResponse
	}
	return nil
}

func (x *Workload) GetCompliantButDisallowedServices() []string {
	if x != nil {
		return x.CompliantButDisallowedServices
	}
	return nil
}

func (x *Workload) GetPartner() Workload_Partner {
	if x != nil {
		return x.Partner
	}
	return Workload_PARTNER_UNSPECIFIED
}

// Operation metadata to give request details of CreateWorkload.
type CreateWorkloadOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Time when the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. The display name of the workload.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The parent of the workload.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Compliance controls that should be applied to the resources managed by
	// the workload.
	ComplianceRegime Workload_ComplianceRegime `protobuf:"varint,4,opt,name=compliance_regime,json=complianceRegime,proto3,enum=google.cloud.assuredworkloads.v1.Workload_ComplianceRegime" json:"compliance_regime,omitempty"`
}

func (x *CreateWorkloadOperationMetadata) Reset() {
	*x = CreateWorkloadOperationMetadata{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateWorkloadOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkloadOperationMetadata) ProtoMessage() {}

func (x *CreateWorkloadOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkloadOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateWorkloadOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{7}
}

func (x *CreateWorkloadOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CreateWorkloadOperationMetadata) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CreateWorkloadOperationMetadata) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkloadOperationMetadata) GetComplianceRegime() Workload_ComplianceRegime {
	if x != nil {
		return x.ComplianceRegime
	}
	return Workload_COMPLIANCE_REGIME_UNSPECIFIED
}

// Request for restricting list of available resources in Workload environment.
type RestrictAllowedResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Workload. This is the workloads's
	// relative path in the API, formatted as
	// "organizations/{organization_id}/locations/{location_id}/workloads/{workload_id}".
	// For example,
	// "organizations/123/locations/us-east1/workloads/assured-workload-1".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The type of restriction for using gcp products in the Workload environment.
	RestrictionType RestrictAllowedResourcesRequest_RestrictionType `protobuf:"varint,2,opt,name=restriction_type,json=restrictionType,proto3,enum=google.cloud.assuredworkloads.v1.RestrictAllowedResourcesRequest_RestrictionType" json:"restriction_type,omitempty"`
}

func (x *RestrictAllowedResourcesRequest) Reset() {
	*x = RestrictAllowedResourcesRequest{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestrictAllowedResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestrictAllowedResourcesRequest) ProtoMessage() {}

func (x *RestrictAllowedResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestrictAllowedResourcesRequest.ProtoReflect.Descriptor instead.
func (*RestrictAllowedResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{8}
}

func (x *RestrictAllowedResourcesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RestrictAllowedResourcesRequest) GetRestrictionType() RestrictAllowedResourcesRequest_RestrictionType {
	if x != nil {
		return x.RestrictionType
	}
	return RestrictAllowedResourcesRequest_RESTRICTION_TYPE_UNSPECIFIED
}

// Response for restricting the list of allowed resources.
type RestrictAllowedResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RestrictAllowedResourcesResponse) Reset() {
	*x = RestrictAllowedResourcesResponse{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestrictAllowedResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestrictAllowedResourcesResponse) ProtoMessage() {}

func (x *RestrictAllowedResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestrictAllowedResourcesResponse.ProtoReflect.Descriptor instead.
func (*RestrictAllowedResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{9}
}

// Request for acknowledging the violation
// Next Id: 4
type AcknowledgeViolationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Violation to acknowledge.
	// Format:
	// organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Business justification explaining the need for violation acknowledgement
	Comment string `protobuf:"bytes,2,opt,name=comment,proto3" json:"comment,omitempty"`
	// Optional. This field is deprecated and will be removed in future version of the API.
	// Name of the OrgPolicy which was modified with non-compliant change and
	// resulted in this violation.
	// Format:
	// projects/{project_number}/policies/{constraint_name}
	// folders/{folder_id}/policies/{constraint_name}
	// organizations/{organization_id}/policies/{constraint_name}
	//
	// Deprecated: Marked as deprecated in google/cloud/assuredworkloads/v1/assuredworkloads.proto.
	NonCompliantOrgPolicy string `protobuf:"bytes,3,opt,name=non_compliant_org_policy,json=nonCompliantOrgPolicy,proto3" json:"non_compliant_org_policy,omitempty"`
}

func (x *AcknowledgeViolationRequest) Reset() {
	*x = AcknowledgeViolationRequest{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcknowledgeViolationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcknowledgeViolationRequest) ProtoMessage() {}

func (x *AcknowledgeViolationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcknowledgeViolationRequest.ProtoReflect.Descriptor instead.
func (*AcknowledgeViolationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{10}
}

func (x *AcknowledgeViolationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AcknowledgeViolationRequest) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/assuredworkloads/v1/assuredworkloads.proto.
func (x *AcknowledgeViolationRequest) GetNonCompliantOrgPolicy() string {
	if x != nil {
		return x.NonCompliantOrgPolicy
	}
	return ""
}

// Response for violation acknowledgement
type AcknowledgeViolationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AcknowledgeViolationResponse) Reset() {
	*x = AcknowledgeViolationResponse{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcknowledgeViolationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcknowledgeViolationResponse) ProtoMessage() {}

func (x *AcknowledgeViolationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcknowledgeViolationResponse.ProtoReflect.Descriptor instead.
func (*AcknowledgeViolationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{11}
}

// Interval defining a time window.
type TimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start of the time window.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end of the time window.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TimeWindow) Reset() {
	*x = TimeWindow{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeWindow) ProtoMessage() {}

func (x *TimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeWindow.ProtoReflect.Descriptor instead.
func (*TimeWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{12}
}

func (x *TimeWindow) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimeWindow) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Request for fetching violations in an organization.
type ListViolationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Workload name.
	// Format `organizations/{org_id}/locations/{location}/workloads/{workload}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Specifies the time window for retrieving active Violations.
	// When specified, retrieves Violations that were active between start_time
	// and end_time.
	Interval *TimeWindow `protobuf:"bytes,2,opt,name=interval,proto3" json:"interval,omitempty"`
	// Optional. Page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token returned from previous request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A custom filter for filtering by the Violations properties.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListViolationsRequest) Reset() {
	*x = ListViolationsRequest{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListViolationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListViolationsRequest) ProtoMessage() {}

func (x *ListViolationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListViolationsRequest.ProtoReflect.Descriptor instead.
func (*ListViolationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{13}
}

func (x *ListViolationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListViolationsRequest) GetInterval() *TimeWindow {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *ListViolationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListViolationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListViolationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response of ListViolations endpoint.
type ListViolationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of Violations under a Workload.
	Violations []*Violation `protobuf:"bytes,1,rep,name=violations,proto3" json:"violations,omitempty"`
	// The next page token. Returns empty if reached the last page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListViolationsResponse) Reset() {
	*x = ListViolationsResponse{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListViolationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListViolationsResponse) ProtoMessage() {}

func (x *ListViolationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListViolationsResponse.ProtoReflect.Descriptor instead.
func (*ListViolationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{14}
}

func (x *ListViolationsResponse) GetViolations() []*Violation {
	if x != nil {
		return x.Violations
	}
	return nil
}

func (x *ListViolationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for fetching a Workload Violation.
type GetViolationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Violation to fetch (ie. Violation.name).
	// Format:
	// organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetViolationRequest) Reset() {
	*x = GetViolationRequest{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetViolationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetViolationRequest) ProtoMessage() {}

func (x *GetViolationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetViolationRequest.ProtoReflect.Descriptor instead.
func (*GetViolationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{15}
}

func (x *GetViolationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Workload monitoring Violation.
type Violation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Immutable. Name of the Violation.
	// Format:
	// organizations/{organization}/locations/{location}/workloads/{workload_id}/violations/{violations_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Description for the Violation.
	// e.g. OrgPolicy gcp.resourceLocations has non compliant value.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time of the event which triggered the Violation.
	BeginTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=begin_time,json=beginTime,proto3" json:"begin_time,omitempty"`
	// Output only. The last time when the Violation record was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time of the event which fixed the Violation.
	// If the violation is ACTIVE this will be empty.
	ResolveTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=resolve_time,json=resolveTime,proto3" json:"resolve_time,omitempty"`
	// Output only. Category under which this violation is mapped.
	// e.g. Location, Service Usage, Access, Encryption, etc.
	Category string `protobuf:"bytes,6,opt,name=category,proto3" json:"category,omitempty"`
	// Output only. State of the violation
	State Violation_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.assuredworkloads.v1.Violation_State" json:"state,omitempty"`
	// Output only. Immutable. The org-policy-constraint that was incorrectly changed, which resulted in
	// this violation.
	OrgPolicyConstraint string `protobuf:"bytes,8,opt,name=org_policy_constraint,json=orgPolicyConstraint,proto3" json:"org_policy_constraint,omitempty"`
	// Output only. Immutable. Audit Log Link for violated resource
	// Format:
	// https://console.cloud.google.com/logs/query;query={logName}{protoPayload.resourceName}{timeRange}{folder}
	AuditLogLink string `protobuf:"bytes,11,opt,name=audit_log_link,json=auditLogLink,proto3" json:"audit_log_link,omitempty"`
	// Output only. Immutable. Name of the OrgPolicy which was modified with non-compliant change and
	// resulted this violation.
	//
	//	Format:
	//	projects/{project_number}/policies/{constraint_name}
	//	folders/{folder_id}/policies/{constraint_name}
	//	organizations/{organization_id}/policies/{constraint_name}
	NonCompliantOrgPolicy string `protobuf:"bytes,12,opt,name=non_compliant_org_policy,json=nonCompliantOrgPolicy,proto3" json:"non_compliant_org_policy,omitempty"`
	// Output only. Compliance violation remediation
	Remediation *Violation_Remediation `protobuf:"bytes,13,opt,name=remediation,proto3" json:"remediation,omitempty"`
	// Output only. A boolean that indicates if the violation is acknowledged
	Acknowledged bool `protobuf:"varint,14,opt,name=acknowledged,proto3" json:"acknowledged,omitempty"`
	// Optional. Timestamp when this violation was acknowledged last.
	// This will be absent when acknowledged field is marked as false.
	AcknowledgementTime *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=acknowledgement_time,json=acknowledgementTime,proto3,oneof" json:"acknowledgement_time,omitempty"`
	// Output only. Immutable. Audit Log link to find business justification provided for violation
	// exception. Format:
	// https://console.cloud.google.com/logs/query;query={logName}{protoPayload.resourceName}{protoPayload.methodName}{timeRange}{organization}
	ExceptionAuditLogLink string `protobuf:"bytes,16,opt,name=exception_audit_log_link,json=exceptionAuditLogLink,proto3" json:"exception_audit_log_link,omitempty"`
}

func (x *Violation) Reset() {
	*x = Violation{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Violation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation) ProtoMessage() {}

func (x *Violation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation.ProtoReflect.Descriptor instead.
func (*Violation) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{16}
}

func (x *Violation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Violation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Violation) GetBeginTime() *timestamppb.Timestamp {
	if x != nil {
		return x.BeginTime
	}
	return nil
}

func (x *Violation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Violation) GetResolveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ResolveTime
	}
	return nil
}

func (x *Violation) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *Violation) GetState() Violation_State {
	if x != nil {
		return x.State
	}
	return Violation_STATE_UNSPECIFIED
}

func (x *Violation) GetOrgPolicyConstraint() string {
	if x != nil {
		return x.OrgPolicyConstraint
	}
	return ""
}

func (x *Violation) GetAuditLogLink() string {
	if x != nil {
		return x.AuditLogLink
	}
	return ""
}

func (x *Violation) GetNonCompliantOrgPolicy() string {
	if x != nil {
		return x.NonCompliantOrgPolicy
	}
	return ""
}

func (x *Violation) GetRemediation() *Violation_Remediation {
	if x != nil {
		return x.Remediation
	}
	return nil
}

func (x *Violation) GetAcknowledged() bool {
	if x != nil {
		return x.Acknowledged
	}
	return false
}

func (x *Violation) GetAcknowledgementTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AcknowledgementTime
	}
	return nil
}

func (x *Violation) GetExceptionAuditLogLink() string {
	if x != nil {
		return x.ExceptionAuditLogLink
	}
	return ""
}

// Represent the resources that are children of this Workload.
type Workload_ResourceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource identifier.
	// For a project this represents project_number.
	ResourceId int64 `protobuf:"varint,1,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// Indicates the type of resource.
	ResourceType Workload_ResourceInfo_ResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,proto3,enum=google.cloud.assuredworkloads.v1.Workload_ResourceInfo_ResourceType" json:"resource_type,omitempty"`
}

func (x *Workload_ResourceInfo) Reset() {
	*x = Workload_ResourceInfo{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Workload_ResourceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_ResourceInfo) ProtoMessage() {}

func (x *Workload_ResourceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_ResourceInfo.ProtoReflect.Descriptor instead.
func (*Workload_ResourceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Workload_ResourceInfo) GetResourceId() int64 {
	if x != nil {
		return x.ResourceId
	}
	return 0
}

func (x *Workload_ResourceInfo) GetResourceType() Workload_ResourceInfo_ResourceType {
	if x != nil {
		return x.ResourceType
	}
	return Workload_ResourceInfo_RESOURCE_TYPE_UNSPECIFIED
}

// Settings specific to the Key Management Service.
// This message is deprecated.
// In order to create a Keyring, callers should specify,
// ENCRYPTION_KEYS_PROJECT or KEYRING in ResourceSettings.resource_type field.
//
// Deprecated: Marked as deprecated in google/cloud/assuredworkloads/v1/assuredworkloads.proto.
type Workload_KMSSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Input only. Immutable. The time at which the Key Management Service will automatically create a
	// new version of the crypto key and mark it as the primary.
	NextRotationTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=next_rotation_time,json=nextRotationTime,proto3" json:"next_rotation_time,omitempty"`
	// Required. Input only. Immutable. [next_rotation_time] will be advanced by this period when the Key
	// Management Service automatically rotates a key. Must be at least 24 hours
	// and at most 876,000 hours.
	RotationPeriod *durationpb.Duration `protobuf:"bytes,2,opt,name=rotation_period,json=rotationPeriod,proto3" json:"rotation_period,omitempty"`
}

func (x *Workload_KMSSettings) Reset() {
	*x = Workload_KMSSettings{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Workload_KMSSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_KMSSettings) ProtoMessage() {}

func (x *Workload_KMSSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_KMSSettings.ProtoReflect.Descriptor instead.
func (*Workload_KMSSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Workload_KMSSettings) GetNextRotationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextRotationTime
	}
	return nil
}

func (x *Workload_KMSSettings) GetRotationPeriod() *durationpb.Duration {
	if x != nil {
		return x.RotationPeriod
	}
	return nil
}

// Represent the custom settings for the resources to be created.
type Workload_ResourceSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource identifier.
	// For a project this represents project_id. If the project is already
	// taken, the workload creation will fail.
	// For KeyRing, this represents the keyring_id.
	// For a folder, don't set this value as folder_id is assigned by Google.
	ResourceId string `protobuf:"bytes,1,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// Indicates the type of resource. This field should be specified to
	// correspond the id to the right resource type (CONSUMER_FOLDER or
	// ENCRYPTION_KEYS_PROJECT)
	ResourceType Workload_ResourceInfo_ResourceType `protobuf:"varint,2,opt,name=resource_type,json=resourceType,proto3,enum=google.cloud.assuredworkloads.v1.Workload_ResourceInfo_ResourceType" json:"resource_type,omitempty"`
	// User-assigned resource display name.
	// If not empty it will be used to create a resource with the specified
	// name.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *Workload_ResourceSettings) Reset() {
	*x = Workload_ResourceSettings{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Workload_ResourceSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_ResourceSettings) ProtoMessage() {}

func (x *Workload_ResourceSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_ResourceSettings.ProtoReflect.Descriptor instead.
func (*Workload_ResourceSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 2}
}

func (x *Workload_ResourceSettings) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

func (x *Workload_ResourceSettings) GetResourceType() Workload_ResourceInfo_ResourceType {
	if x != nil {
		return x.ResourceType
	}
	return Workload_ResourceInfo_RESOURCE_TYPE_UNSPECIFIED
}

func (x *Workload_ResourceSettings) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Signed Access Approvals (SAA) enrollment response.
type Workload_SaaEnrollmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates SAA enrollment status of a given workload.
	SetupStatus *Workload_SaaEnrollmentResponse_SetupState `protobuf:"varint,1,opt,name=setup_status,json=setupStatus,proto3,enum=google.cloud.assuredworkloads.v1.Workload_SaaEnrollmentResponse_SetupState,oneof" json:"setup_status,omitempty"`
	// Indicates SAA enrollment setup error if any.
	SetupErrors []Workload_SaaEnrollmentResponse_SetupError `protobuf:"varint,2,rep,packed,name=setup_errors,json=setupErrors,proto3,enum=google.cloud.assuredworkloads.v1.Workload_SaaEnrollmentResponse_SetupError" json:"setup_errors,omitempty"`
}

func (x *Workload_SaaEnrollmentResponse) Reset() {
	*x = Workload_SaaEnrollmentResponse{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Workload_SaaEnrollmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload_SaaEnrollmentResponse) ProtoMessage() {}

func (x *Workload_SaaEnrollmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload_SaaEnrollmentResponse.ProtoReflect.Descriptor instead.
func (*Workload_SaaEnrollmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{6, 3}
}

func (x *Workload_SaaEnrollmentResponse) GetSetupStatus() Workload_SaaEnrollmentResponse_SetupState {
	if x != nil && x.SetupStatus != nil {
		return *x.SetupStatus
	}
	return Workload_SaaEnrollmentResponse_SETUP_STATE_UNSPECIFIED
}

func (x *Workload_SaaEnrollmentResponse) GetSetupErrors() []Workload_SaaEnrollmentResponse_SetupError {
	if x != nil {
		return x.SetupErrors
	}
	return nil
}

// Represents remediation guidance to resolve compliance violation for
// AssuredWorkload
type Violation_Remediation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Remediation instructions to resolve violations
	Instructions *Violation_Remediation_Instructions `protobuf:"bytes,1,opt,name=instructions,proto3" json:"instructions,omitempty"`
	// Values that can resolve the violation
	// For example: for list org policy violations, this will either be the list
	// of allowed or denied values
	CompliantValues []string `protobuf:"bytes,2,rep,name=compliant_values,json=compliantValues,proto3" json:"compliant_values,omitempty"`
	// Output only. Reemediation type based on the type of org policy values violated
	RemediationType Violation_Remediation_RemediationType `protobuf:"varint,3,opt,name=remediation_type,json=remediationType,proto3,enum=google.cloud.assuredworkloads.v1.Violation_Remediation_RemediationType" json:"remediation_type,omitempty"`
}

func (x *Violation_Remediation) Reset() {
	*x = Violation_Remediation{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Violation_Remediation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation_Remediation) ProtoMessage() {}

func (x *Violation_Remediation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation_Remediation.ProtoReflect.Descriptor instead.
func (*Violation_Remediation) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{16, 0}
}

func (x *Violation_Remediation) GetInstructions() *Violation_Remediation_Instructions {
	if x != nil {
		return x.Instructions
	}
	return nil
}

func (x *Violation_Remediation) GetCompliantValues() []string {
	if x != nil {
		return x.CompliantValues
	}
	return nil
}

func (x *Violation_Remediation) GetRemediationType() Violation_Remediation_RemediationType {
	if x != nil {
		return x.RemediationType
	}
	return Violation_Remediation_REMEDIATION_TYPE_UNSPECIFIED
}

// Instructions to remediate violation
type Violation_Remediation_Instructions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Remediation instructions to resolve violation via gcloud cli
	GcloudInstructions *Violation_Remediation_Instructions_Gcloud `protobuf:"bytes,1,opt,name=gcloud_instructions,json=gcloudInstructions,proto3" json:"gcloud_instructions,omitempty"`
	// Remediation instructions to resolve violation via cloud console
	ConsoleInstructions *Violation_Remediation_Instructions_Console `protobuf:"bytes,2,opt,name=console_instructions,json=consoleInstructions,proto3" json:"console_instructions,omitempty"`
}

func (x *Violation_Remediation_Instructions) Reset() {
	*x = Violation_Remediation_Instructions{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Violation_Remediation_Instructions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation_Remediation_Instructions) ProtoMessage() {}

func (x *Violation_Remediation_Instructions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation_Remediation_Instructions.ProtoReflect.Descriptor instead.
func (*Violation_Remediation_Instructions) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{16, 0, 0}
}

func (x *Violation_Remediation_Instructions) GetGcloudInstructions() *Violation_Remediation_Instructions_Gcloud {
	if x != nil {
		return x.GcloudInstructions
	}
	return nil
}

func (x *Violation_Remediation_Instructions) GetConsoleInstructions() *Violation_Remediation_Instructions_Console {
	if x != nil {
		return x.ConsoleInstructions
	}
	return nil
}

// Remediation instructions to resolve violation via gcloud cli
type Violation_Remediation_Instructions_Gcloud struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gcloud command to resolve violation
	GcloudCommands []string `protobuf:"bytes,1,rep,name=gcloud_commands,json=gcloudCommands,proto3" json:"gcloud_commands,omitempty"`
	// Steps to resolve violation via gcloud cli
	Steps []string `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
	// Additional urls for more information about steps
	AdditionalLinks []string `protobuf:"bytes,3,rep,name=additional_links,json=additionalLinks,proto3" json:"additional_links,omitempty"`
}

func (x *Violation_Remediation_Instructions_Gcloud) Reset() {
	*x = Violation_Remediation_Instructions_Gcloud{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Violation_Remediation_Instructions_Gcloud) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation_Remediation_Instructions_Gcloud) ProtoMessage() {}

func (x *Violation_Remediation_Instructions_Gcloud) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation_Remediation_Instructions_Gcloud.ProtoReflect.Descriptor instead.
func (*Violation_Remediation_Instructions_Gcloud) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{16, 0, 0, 0}
}

func (x *Violation_Remediation_Instructions_Gcloud) GetGcloudCommands() []string {
	if x != nil {
		return x.GcloudCommands
	}
	return nil
}

func (x *Violation_Remediation_Instructions_Gcloud) GetSteps() []string {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *Violation_Remediation_Instructions_Gcloud) GetAdditionalLinks() []string {
	if x != nil {
		return x.AdditionalLinks
	}
	return nil
}

// Remediation instructions to resolve violation via cloud console
type Violation_Remediation_Instructions_Console struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Link to console page where violations can be resolved
	ConsoleUris []string `protobuf:"bytes,1,rep,name=console_uris,json=consoleUris,proto3" json:"console_uris,omitempty"`
	// Steps to resolve violation via cloud console
	Steps []string `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
	// Additional urls for more information about steps
	AdditionalLinks []string `protobuf:"bytes,3,rep,name=additional_links,json=additionalLinks,proto3" json:"additional_links,omitempty"`
}

func (x *Violation_Remediation_Instructions_Console) Reset() {
	*x = Violation_Remediation_Instructions_Console{}
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Violation_Remediation_Instructions_Console) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation_Remediation_Instructions_Console) ProtoMessage() {}

func (x *Violation_Remediation_Instructions_Console) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Violation_Remediation_Instructions_Console.ProtoReflect.Descriptor instead.
func (*Violation_Remediation_Instructions_Console) Descriptor() ([]byte, []int) {
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP(), []int{16, 0, 0, 1}
}

func (x *Violation_Remediation_Instructions_Console) GetConsoleUris() []string {
	if x != nil {
		return x.ConsoleUris
	}
	return nil
}

func (x *Violation_Remediation_Instructions_Console) GetSteps() []string {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *Violation_Remediation_Instructions_Console) GetAdditionalLinks() []string {
	if x != nil {
		return x.AdditionalLinks
	}
	return nil
}

var File_google_cloud_assuredworkloads_v1_assuredworkloads_proto protoreflect.FileDescriptor

var file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x22, 0xa6, 0x01, 0x0a, 0x15, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x76, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x5a, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x89,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72,
	0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc1, 0x18, 0x0a, 0x08, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72,
	0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x70, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x62,
	0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x45, 0x0a, 0x1c, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x04, 0x52, 0x1a, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x60,
	0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x2e, 0x4b, 0x4d, 0x53, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x05, 0xe0, 0x41,
	0x04, 0x18, 0x01, 0x52, 0x0b, 0x6b, 0x6d, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x6d, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72,
	0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x10, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x74, 0x0a, 0x14, 0x6b, 0x61, 0x6a, 0x5f, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x4b, 0x61, 0x6a, 0x45, 0x6e, 0x72,
	0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x12, 0x6b, 0x61, 0x6a, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x73, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x69, 0x67, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x69, 0x67, 0x6e, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x12, 0x7d, 0x0a, 0x17, 0x73, 0x61, 0x61, 0x5f, 0x65, 0x6e,
	0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x2e, 0x53, 0x61, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x73, 0x61, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x74, 0x5f, 0x62, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x74,
	0x42, 0x75, 0x74, 0x44, 0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x07, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x1a, 0xa3, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x69, 0x0a, 0x0d, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x10, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45,
	0x52, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12,
	0x13, 0x0a, 0x0f, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x46, 0x4f, 0x4c, 0x44,
	0x45, 0x52, 0x10, 0x04, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10,
	0x02, 0x12, 0x0b, 0x0a, 0x07, 0x4b, 0x45, 0x59, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x1a, 0xb5,
	0x01, 0x0a, 0x0b, 0x4b, 0x4d, 0x53, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x53,
	0x0a, 0x12, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0, 0x41,
	0x05, 0x52, 0x10, 0x6e, 0x65, 0x78, 0x74, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x0f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x04, 0xe0,
	0x41, 0x05, 0x52, 0x0e, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0xc1, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x69, 0x0a, 0x0d,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x96, 0x04, 0x0a, 0x15, 0x53,
	0x61, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x73, 0x0a, 0x0c, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x53, 0x61, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x65, 0x74,
	0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x74, 0x75, 0x70,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x88, 0x01, 0x01, 0x12, 0x6e, 0x0a, 0x0c, 0x73, 0x65, 0x74,
	0x75, 0x70, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x53, 0x61, 0x61, 0x45,
	0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x53, 0x65, 0x74, 0x75, 0x70, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x0b, 0x73, 0x65,
	0x74, 0x75, 0x70, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x52, 0x0a, 0x0a, 0x53, 0x65, 0x74,
	0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x54, 0x55, 0x50,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x02, 0x22, 0xb2, 0x01,
	0x0a, 0x0a, 0x53, 0x65, 0x74, 0x75, 0x70, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x1b, 0x0a, 0x17,
	0x53, 0x45, 0x54, 0x55, 0x50, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x42, 0x41, 0x53, 0x45, 0x5f,
	0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x01, 0x12, 0x26, 0x0a, 0x22, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x5f, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41,
	0x4c, 0x5f, 0x53, 0x49, 0x47, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x02, 0x12,
	0x23, 0x0a, 0x1f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x4c, 0x4c,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x53, 0x5f, 0x45, 0x4e, 0x52, 0x4f, 0x4c, 0x4c,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x53, 0x45,
	0x54, 0x55, 0x50, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x04, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa5,
	0x02, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x67,
	0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x49, 0x41, 0x4e, 0x43,
	0x45, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4d, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x49, 0x4c, 0x34, 0x10, 0x01, 0x12,
	0x08, 0x0a, 0x04, 0x43, 0x4a, 0x49, 0x53, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x46, 0x45, 0x44,
	0x52, 0x41, 0x4d, 0x50, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x46,
	0x45, 0x44, 0x52, 0x41, 0x4d, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x52, 0x41, 0x54, 0x45, 0x10,
	0x04, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x53, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x41, 0x4c,
	0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x49, 0x50,
	0x41, 0x41, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x49, 0x54, 0x52, 0x55, 0x53, 0x54, 0x10,
	0x07, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x55, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x53, 0x5f,
	0x41, 0x4e, 0x44, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x08, 0x12, 0x1a, 0x0a,
	0x16, 0x43, 0x41, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x09, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x54, 0x41,
	0x52, 0x10, 0x0a, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x55, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e,
	0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x55, 0x53, 0x5f, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54,
	0x10, 0x0b, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x53, 0x53, 0x55, 0x52, 0x45, 0x44, 0x5f, 0x57, 0x4f,
	0x52, 0x4b, 0x4c, 0x4f, 0x41, 0x44, 0x53, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x50, 0x41, 0x52, 0x54,
	0x4e, 0x45, 0x52, 0x53, 0x10, 0x0c, 0x22, 0x7f, 0x0a, 0x12, 0x4b, 0x61, 0x6a, 0x45, 0x6e, 0x72,
	0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x20,
	0x4b, 0x41, 0x4a, 0x5f, 0x45, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x4b, 0x41, 0x4a, 0x5f, 0x45, 0x4e, 0x52, 0x4f, 0x4c, 0x4c,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x21, 0x0a, 0x1d, 0x4b, 0x41, 0x4a, 0x5f, 0x45, 0x4e, 0x52, 0x4f,
	0x4c, 0x4c, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4d,
	0x50, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x02, 0x22, 0x3e, 0x0a, 0x07, 0x50, 0x61, 0x72, 0x74, 0x6e,
	0x65, 0x72, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x41, 0x52, 0x54, 0x4e, 0x45, 0x52, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x4c,
	0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x53, 0x5f, 0x42, 0x59,
	0x5f, 0x53, 0x33, 0x4e, 0x53, 0x10, 0x01, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a, 0x28, 0x61, 0x73,
	0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x46, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x7d, 0x22, 0x97,
	0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x6d, 0x0a, 0x11, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6d,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6d, 0x65, 0x22, 0xaf, 0x02, 0x0a, 0x1f, 0x52, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x6f,
	0x77, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0x6f, 0x0a, 0x0f, 0x52, 0x65, 0x73,
	0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c,
	0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b,
	0x0a, 0x17, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x47, 0x43, 0x50, 0x5f,
	0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x53, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x41,
	0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x49, 0x41, 0x4e, 0x54, 0x5f, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x53, 0x10, 0x02, 0x22, 0x22, 0x0a, 0x20, 0x52, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x95,
	0x01, 0x0a, 0x1b, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x56, 0x69,
	0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x18, 0x6e, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x6f, 0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52,
	0x15, 0x6e, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x74, 0x4f, 0x72, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x1e, 0x0a, 0x1c, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7e, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x94, 0x02, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x56,
	0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x08, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8d, 0x01,
	0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0a, 0x76, 0x69, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75,
	0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x76, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5c, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x73, 0x73, 0x75,
	0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x69, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xfd, 0x10, 0x0a, 0x09,
	0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0a,
	0x62, 0x65, 0x67, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42,
	0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x3a, 0x0a, 0x15, 0x6f, 0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x13, 0x6f, 0x72, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x2c, 0x0a,
	0x0e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3f, 0x0a, 0x18, 0x6e,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x6f, 0x72, 0x67,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x15, 0x6e, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x74, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5e, 0x0a, 0x0b,
	0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52,
	0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0c,
	0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x64, 0x12, 0x57, 0x0a, 0x14, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x13, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65,
	0x64, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3f,
	0x0a, 0x18, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x15, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x4c, 0x69, 0x6e, 0x6b, 0x1a,
	0xb2, 0x08, 0x0a, 0x0b, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x6d, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x29,
	0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x77, 0x0a, 0x10, 0x72, 0x65, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0f, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x1a, 0xf0, 0x03, 0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x7c, 0x0a, 0x13, 0x67, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x12, 0x67,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x7f, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x52, 0x13, 0x63,
	0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x1a, 0x72, 0x0a, 0x06, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x27, 0x0a, 0x0f,
	0x67, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x67, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x61,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x1a, 0x6d, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65,
	0x55, 0x72, 0x69, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x9c, 0x02, 0x0a, 0x0f, 0x52, 0x65, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x4d,
	0x45, 0x44, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2c, 0x0a, 0x28, 0x52,
	0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x4f, 0x4f, 0x4c, 0x45,
	0x41, 0x4e, 0x5f, 0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x56, 0x49,
	0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x38, 0x0a, 0x34, 0x52, 0x45, 0x4d,
	0x45, 0x44, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x41, 0x4c,
	0x4c, 0x4f, 0x57, 0x45, 0x44, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x53, 0x5f, 0x4f, 0x52, 0x47,
	0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x02, 0x12, 0x37, 0x0a, 0x33, 0x52, 0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x5f, 0x56,
	0x41, 0x4c, 0x55, 0x45, 0x53, 0x5f, 0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x46, 0x0a, 0x42,
	0x52, 0x45, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x54,
	0x52, 0x49, 0x43, 0x54, 0x5f, 0x43, 0x4d, 0x45, 0x4b, 0x5f, 0x43, 0x52, 0x59, 0x50, 0x54, 0x4f,
	0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x53, 0x5f, 0x4f, 0x52,
	0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x04, 0x22, 0x4b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x4e, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x58, 0x43, 0x45, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x04, 0x3a, 0x8e, 0x01, 0xea, 0x41, 0x8a, 0x01, 0x0a, 0x29, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x7d, 0x2f, 0x76, 0x69, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x32, 0x86, 0x0e, 0x0a, 0x17,
	0x41, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xef, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x84, 0x01, 0xca, 0x41, 0x2b, 0x0a, 0x08, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x12, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x08, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0xdb, 0x01, 0x0a, 0x0e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75,
	0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x22, 0x64, 0xda, 0x41, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47,
	0x3a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf9, 0x01, 0x0a, 0x18, 0x52, 0x65, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x50, 0x3a, 0x01, 0x2a, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0xa4, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb2, 0x01, 0x0a, 0x0b, 0x47,
	0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x41, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc5, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x69, 0x6f, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x09, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x7b, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x56,
	0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56,
	0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x07, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x97, 0x01, 0x0a, 0x14, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x56, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x56, 0x69, 0x6f,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x56, 0x69, 0x6f, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x1a,
	0x53, 0xca, 0x41, 0x1f, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x42, 0xdd, 0x02, 0xea, 0x41, 0x5d, 0x0a, 0x28, 0x61, 0x73, 0x73, 0x75,
	0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65,
	0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x15, 0x41,
	0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x73, 0x73, 0x75,
	0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x70, 0x62, 0x3b, 0x61, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x57,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x20, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x73, 0x73, 0x75, 0x72,
	0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02,
	0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x41, 0x73, 0x73, 0x75, 0x72, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x73,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescOnce sync.Once
	file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescData = file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDesc
)

func file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescGZIP() []byte {
	file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescOnce.Do(func() {
		file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescData)
	})
	return file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDescData
}

var file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_goTypes = []any{
	(Workload_ComplianceRegime)(0),                       // 0: google.cloud.assuredworkloads.v1.Workload.ComplianceRegime
	(Workload_KajEnrollmentState)(0),                     // 1: google.cloud.assuredworkloads.v1.Workload.KajEnrollmentState
	(Workload_Partner)(0),                                // 2: google.cloud.assuredworkloads.v1.Workload.Partner
	(Workload_ResourceInfo_ResourceType)(0),              // 3: google.cloud.assuredworkloads.v1.Workload.ResourceInfo.ResourceType
	(Workload_SaaEnrollmentResponse_SetupState)(0),       // 4: google.cloud.assuredworkloads.v1.Workload.SaaEnrollmentResponse.SetupState
	(Workload_SaaEnrollmentResponse_SetupError)(0),       // 5: google.cloud.assuredworkloads.v1.Workload.SaaEnrollmentResponse.SetupError
	(RestrictAllowedResourcesRequest_RestrictionType)(0), // 6: google.cloud.assuredworkloads.v1.RestrictAllowedResourcesRequest.RestrictionType
	(Violation_State)(0),                                 // 7: google.cloud.assuredworkloads.v1.Violation.State
	(Violation_Remediation_RemediationType)(0),           // 8: google.cloud.assuredworkloads.v1.Violation.Remediation.RemediationType
	(*CreateWorkloadRequest)(nil),                        // 9: google.cloud.assuredworkloads.v1.CreateWorkloadRequest
	(*UpdateWorkloadRequest)(nil),                        // 10: google.cloud.assuredworkloads.v1.UpdateWorkloadRequest
	(*DeleteWorkloadRequest)(nil),                        // 11: google.cloud.assuredworkloads.v1.DeleteWorkloadRequest
	(*GetWorkloadRequest)(nil),                           // 12: google.cloud.assuredworkloads.v1.GetWorkloadRequest
	(*ListWorkloadsRequest)(nil),                         // 13: google.cloud.assuredworkloads.v1.ListWorkloadsRequest
	(*ListWorkloadsResponse)(nil),                        // 14: google.cloud.assuredworkloads.v1.ListWorkloadsResponse
	(*Workload)(nil),                                     // 15: google.cloud.assuredworkloads.v1.Workload
	(*CreateWorkloadOperationMetadata)(nil),              // 16: google.cloud.assuredworkloads.v1.CreateWorkloadOperationMetadata
	(*RestrictAllowedResourcesRequest)(nil),              // 17: google.cloud.assuredworkloads.v1.RestrictAllowedResourcesRequest
	(*RestrictAllowedResourcesResponse)(nil),             // 18: google.cloud.assuredworkloads.v1.RestrictAllowedResourcesResponse
	(*AcknowledgeViolationRequest)(nil),                  // 19: google.cloud.assuredworkloads.v1.AcknowledgeViolationRequest
	(*AcknowledgeViolationResponse)(nil),                 // 20: google.cloud.assuredworkloads.v1.AcknowledgeViolationResponse
	(*TimeWindow)(nil),                                   // 21: google.cloud.assuredworkloads.v1.TimeWindow
	(*ListViolationsRequest)(nil),                        // 22: google.cloud.assuredworkloads.v1.ListViolationsRequest
	(*ListViolationsResponse)(nil),                       // 23: google.cloud.assuredworkloads.v1.ListViolationsResponse
	(*GetViolationRequest)(nil),                          // 24: google.cloud.assuredworkloads.v1.GetViolationRequest
	(*Violation)(nil),                                    // 25: google.cloud.assuredworkloads.v1.Violation
	(*Workload_ResourceInfo)(nil),                        // 26: google.cloud.assuredworkloads.v1.Workload.ResourceInfo
	(*Workload_KMSSettings)(nil),                         // 27: google.cloud.assuredworkloads.v1.Workload.KMSSettings
	(*Workload_ResourceSettings)(nil),                    // 28: google.cloud.assuredworkloads.v1.Workload.ResourceSettings
	(*Workload_SaaEnrollmentResponse)(nil),               // 29: google.cloud.assuredworkloads.v1.Workload.SaaEnrollmentResponse
	nil,                                                  // 30: google.cloud.assuredworkloads.v1.Workload.LabelsEntry
	(*Violation_Remediation)(nil),                        // 31: google.cloud.assuredworkloads.v1.Violation.Remediation
	(*Violation_Remediation_Instructions)(nil),           // 32: google.cloud.assuredworkloads.v1.Violation.Remediation.Instructions
	(*Violation_Remediation_Instructions_Gcloud)(nil),    // 33: google.cloud.assuredworkloads.v1.Violation.Remediation.Instructions.Gcloud
	(*Violation_Remediation_Instructions_Console)(nil),   // 34: google.cloud.assuredworkloads.v1.Violation.Remediation.Instructions.Console
	(*fieldmaskpb.FieldMask)(nil),                        // 35: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                        // 36: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                          // 37: google.protobuf.Duration
	(*longrunningpb.Operation)(nil),                      // 38: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                // 39: google.protobuf.Empty
}
var file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_depIdxs = []int32{
	15, // 0: google.cloud.assuredworkloads.v1.CreateWorkloadRequest.workload:type_name -> google.cloud.assuredworkloads.v1.Workload
	15, // 1: google.cloud.assuredworkloads.v1.UpdateWorkloadRequest.workload:type_name -> google.cloud.assuredworkloads.v1.Workload
	35, // 2: google.cloud.assuredworkloads.v1.UpdateWorkloadRequest.update_mask:type_name -> google.protobuf.FieldMask
	15, // 3: google.cloud.assuredworkloads.v1.ListWorkloadsResponse.workloads:type_name -> google.cloud.assuredworkloads.v1.Workload
	26, // 4: google.cloud.assuredworkloads.v1.Workload.resources:type_name -> google.cloud.assuredworkloads.v1.Workload.ResourceInfo
	0,  // 5: google.cloud.assuredworkloads.v1.Workload.compliance_regime:type_name -> google.cloud.assuredworkloads.v1.Workload.ComplianceRegime
	36, // 6: google.cloud.assuredworkloads.v1.Workload.create_time:type_name -> google.protobuf.Timestamp
	30, // 7: google.cloud.assuredworkloads.v1.Workload.labels:type_name -> google.cloud.assuredworkloads.v1.Workload.LabelsEntry
	27, // 8: google.cloud.assuredworkloads.v1.Workload.kms_settings:type_name -> google.cloud.assuredworkloads.v1.Workload.KMSSettings
	28, // 9: google.cloud.assuredworkloads.v1.Workload.resource_settings:type_name -> google.cloud.assuredworkloads.v1.Workload.ResourceSettings
	1,  // 10: google.cloud.assuredworkloads.v1.Workload.kaj_enrollment_state:type_name -> google.cloud.assuredworkloads.v1.Workload.KajEnrollmentState
	29, // 11: google.cloud.assuredworkloads.v1.Workload.saa_enrollment_response:type_name -> google.cloud.assuredworkloads.v1.Workload.SaaEnrollmentResponse
	2,  // 12: google.cloud.assuredworkloads.v1.Workload.partner:type_name -> google.cloud.assuredworkloads.v1.Workload.Partner
	36, // 13: google.cloud.assuredworkloads.v1.CreateWorkloadOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	0,  // 14: google.cloud.assuredworkloads.v1.CreateWorkloadOperationMetadata.compliance_regime:type_name -> google.cloud.assuredworkloads.v1.Workload.ComplianceRegime
	6,  // 15: google.cloud.assuredworkloads.v1.RestrictAllowedResourcesRequest.restriction_type:type_name -> google.cloud.assuredworkloads.v1.RestrictAllowedResourcesRequest.RestrictionType
	36, // 16: google.cloud.assuredworkloads.v1.TimeWindow.start_time:type_name -> google.protobuf.Timestamp
	36, // 17: google.cloud.assuredworkloads.v1.TimeWindow.end_time:type_name -> google.protobuf.Timestamp
	21, // 18: google.cloud.assuredworkloads.v1.ListViolationsRequest.interval:type_name -> google.cloud.assuredworkloads.v1.TimeWindow
	25, // 19: google.cloud.assuredworkloads.v1.ListViolationsResponse.violations:type_name -> google.cloud.assuredworkloads.v1.Violation
	36, // 20: google.cloud.assuredworkloads.v1.Violation.begin_time:type_name -> google.protobuf.Timestamp
	36, // 21: google.cloud.assuredworkloads.v1.Violation.update_time:type_name -> google.protobuf.Timestamp
	36, // 22: google.cloud.assuredworkloads.v1.Violation.resolve_time:type_name -> google.protobuf.Timestamp
	7,  // 23: google.cloud.assuredworkloads.v1.Violation.state:type_name -> google.cloud.assuredworkloads.v1.Violation.State
	31, // 24: google.cloud.assuredworkloads.v1.Violation.remediation:type_name -> google.cloud.assuredworkloads.v1.Violation.Remediation
	36, // 25: google.cloud.assuredworkloads.v1.Violation.acknowledgement_time:type_name -> google.protobuf.Timestamp
	3,  // 26: google.cloud.assuredworkloads.v1.Workload.ResourceInfo.resource_type:type_name -> google.cloud.assuredworkloads.v1.Workload.ResourceInfo.ResourceType
	36, // 27: google.cloud.assuredworkloads.v1.Workload.KMSSettings.next_rotation_time:type_name -> google.protobuf.Timestamp
	37, // 28: google.cloud.assuredworkloads.v1.Workload.KMSSettings.rotation_period:type_name -> google.protobuf.Duration
	3,  // 29: google.cloud.assuredworkloads.v1.Workload.ResourceSettings.resource_type:type_name -> google.cloud.assuredworkloads.v1.Workload.ResourceInfo.ResourceType
	4,  // 30: google.cloud.assuredworkloads.v1.Workload.SaaEnrollmentResponse.setup_status:type_name -> google.cloud.assuredworkloads.v1.Workload.SaaEnrollmentResponse.SetupState
	5,  // 31: google.cloud.assuredworkloads.v1.Workload.SaaEnrollmentResponse.setup_errors:type_name -> google.cloud.assuredworkloads.v1.Workload.SaaEnrollmentResponse.SetupError
	32, // 32: google.cloud.assuredworkloads.v1.Violation.Remediation.instructions:type_name -> google.cloud.assuredworkloads.v1.Violation.Remediation.Instructions
	8,  // 33: google.cloud.assuredworkloads.v1.Violation.Remediation.remediation_type:type_name -> google.cloud.assuredworkloads.v1.Violation.Remediation.RemediationType
	33, // 34: google.cloud.assuredworkloads.v1.Violation.Remediation.Instructions.gcloud_instructions:type_name -> google.cloud.assuredworkloads.v1.Violation.Remediation.Instructions.Gcloud
	34, // 35: google.cloud.assuredworkloads.v1.Violation.Remediation.Instructions.console_instructions:type_name -> google.cloud.assuredworkloads.v1.Violation.Remediation.Instructions.Console
	9,  // 36: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.CreateWorkload:input_type -> google.cloud.assuredworkloads.v1.CreateWorkloadRequest
	10, // 37: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.UpdateWorkload:input_type -> google.cloud.assuredworkloads.v1.UpdateWorkloadRequest
	17, // 38: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.RestrictAllowedResources:input_type -> google.cloud.assuredworkloads.v1.RestrictAllowedResourcesRequest
	11, // 39: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.DeleteWorkload:input_type -> google.cloud.assuredworkloads.v1.DeleteWorkloadRequest
	12, // 40: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.GetWorkload:input_type -> google.cloud.assuredworkloads.v1.GetWorkloadRequest
	13, // 41: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.ListWorkloads:input_type -> google.cloud.assuredworkloads.v1.ListWorkloadsRequest
	22, // 42: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.ListViolations:input_type -> google.cloud.assuredworkloads.v1.ListViolationsRequest
	24, // 43: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.GetViolation:input_type -> google.cloud.assuredworkloads.v1.GetViolationRequest
	19, // 44: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.AcknowledgeViolation:input_type -> google.cloud.assuredworkloads.v1.AcknowledgeViolationRequest
	38, // 45: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.CreateWorkload:output_type -> google.longrunning.Operation
	15, // 46: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.UpdateWorkload:output_type -> google.cloud.assuredworkloads.v1.Workload
	18, // 47: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.RestrictAllowedResources:output_type -> google.cloud.assuredworkloads.v1.RestrictAllowedResourcesResponse
	39, // 48: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.DeleteWorkload:output_type -> google.protobuf.Empty
	15, // 49: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.GetWorkload:output_type -> google.cloud.assuredworkloads.v1.Workload
	14, // 50: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.ListWorkloads:output_type -> google.cloud.assuredworkloads.v1.ListWorkloadsResponse
	23, // 51: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.ListViolations:output_type -> google.cloud.assuredworkloads.v1.ListViolationsResponse
	25, // 52: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.GetViolation:output_type -> google.cloud.assuredworkloads.v1.Violation
	20, // 53: google.cloud.assuredworkloads.v1.AssuredWorkloadsService.AcknowledgeViolation:output_type -> google.cloud.assuredworkloads.v1.AcknowledgeViolationResponse
	45, // [45:54] is the sub-list for method output_type
	36, // [36:45] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_init() }
func file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_init() {
	if File_google_cloud_assuredworkloads_v1_assuredworkloads_proto != nil {
		return
	}
	file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[16].OneofWrappers = []any{}
	file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes[20].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_goTypes,
		DependencyIndexes: file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_depIdxs,
		EnumInfos:         file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_enumTypes,
		MessageInfos:      file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_msgTypes,
	}.Build()
	File_google_cloud_assuredworkloads_v1_assuredworkloads_proto = out.File
	file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_rawDesc = nil
	file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_goTypes = nil
	file_google_cloud_assuredworkloads_v1_assuredworkloads_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssuredWorkloadsServiceClient is the client API for AssuredWorkloadsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssuredWorkloadsServiceClient interface {
	// Creates Assured Workload.
	CreateWorkload(ctx context.Context, in *CreateWorkloadRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing workload.
	// Currently allows updating of workload display_name and labels.
	// For force updates don't set etag field in the Workload.
	// Only one update operation per workload can be in progress.
	UpdateWorkload(ctx context.Context, in *UpdateWorkloadRequest, opts ...grpc.CallOption) (*Workload, error)
	// Restrict the list of resources allowed in the Workload environment.
	// The current list of allowed products can be found at
	// https://cloud.google.com/assured-workloads/docs/supported-products
	// In addition to assuredworkloads.workload.update permission, the user should
	// also have orgpolicy.policy.set permission on the folder resource
	// to use this functionality.
	RestrictAllowedResources(ctx context.Context, in *RestrictAllowedResourcesRequest, opts ...grpc.CallOption) (*RestrictAllowedResourcesResponse, error)
	// Deletes the workload. Make sure that workload's direct children are already
	// in a deleted state, otherwise the request will fail with a
	// FAILED_PRECONDITION error.
	DeleteWorkload(ctx context.Context, in *DeleteWorkloadRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets Assured Workload associated with a CRM Node
	GetWorkload(ctx context.Context, in *GetWorkloadRequest, opts ...grpc.CallOption) (*Workload, error)
	// Lists Assured Workloads under a CRM Node.
	ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error)
	// Lists the Violations in the AssuredWorkload Environment.
	// Callers may also choose to read across multiple Workloads as per
	// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
	// character) as a wildcard character instead of workload-id in the parent.
	// Format `organizations/{org_id}/locations/{location}/workloads/-`
	ListViolations(ctx context.Context, in *ListViolationsRequest, opts ...grpc.CallOption) (*ListViolationsResponse, error)
	// Retrieves Assured Workload Violation based on ID.
	GetViolation(ctx context.Context, in *GetViolationRequest, opts ...grpc.CallOption) (*Violation, error)
	// Acknowledges an existing violation. By acknowledging a violation, users
	// acknowledge the existence of a compliance violation in their workload and
	// decide to ignore it due to a valid business justification. Acknowledgement
	// is a permanent operation and it cannot be reverted.
	AcknowledgeViolation(ctx context.Context, in *AcknowledgeViolationRequest, opts ...grpc.CallOption) (*AcknowledgeViolationResponse, error)
}

type assuredWorkloadsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssuredWorkloadsServiceClient(cc grpc.ClientConnInterface) AssuredWorkloadsServiceClient {
	return &assuredWorkloadsServiceClient{cc}
}

func (c *assuredWorkloadsServiceClient) CreateWorkload(ctx context.Context, in *CreateWorkloadRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/CreateWorkload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) UpdateWorkload(ctx context.Context, in *UpdateWorkloadRequest, opts ...grpc.CallOption) (*Workload, error) {
	out := new(Workload)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/UpdateWorkload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) RestrictAllowedResources(ctx context.Context, in *RestrictAllowedResourcesRequest, opts ...grpc.CallOption) (*RestrictAllowedResourcesResponse, error) {
	out := new(RestrictAllowedResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/RestrictAllowedResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) DeleteWorkload(ctx context.Context, in *DeleteWorkloadRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/DeleteWorkload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) GetWorkload(ctx context.Context, in *GetWorkloadRequest, opts ...grpc.CallOption) (*Workload, error) {
	out := new(Workload)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/GetWorkload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error) {
	out := new(ListWorkloadsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/ListWorkloads", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) ListViolations(ctx context.Context, in *ListViolationsRequest, opts ...grpc.CallOption) (*ListViolationsResponse, error) {
	out := new(ListViolationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/ListViolations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) GetViolation(ctx context.Context, in *GetViolationRequest, opts ...grpc.CallOption) (*Violation, error) {
	out := new(Violation)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/GetViolation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assuredWorkloadsServiceClient) AcknowledgeViolation(ctx context.Context, in *AcknowledgeViolationRequest, opts ...grpc.CallOption) (*AcknowledgeViolationResponse, error) {
	out := new(AcknowledgeViolationResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/AcknowledgeViolation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssuredWorkloadsServiceServer is the server API for AssuredWorkloadsService service.
type AssuredWorkloadsServiceServer interface {
	// Creates Assured Workload.
	CreateWorkload(context.Context, *CreateWorkloadRequest) (*longrunningpb.Operation, error)
	// Updates an existing workload.
	// Currently allows updating of workload display_name and labels.
	// For force updates don't set etag field in the Workload.
	// Only one update operation per workload can be in progress.
	UpdateWorkload(context.Context, *UpdateWorkloadRequest) (*Workload, error)
	// Restrict the list of resources allowed in the Workload environment.
	// The current list of allowed products can be found at
	// https://cloud.google.com/assured-workloads/docs/supported-products
	// In addition to assuredworkloads.workload.update permission, the user should
	// also have orgpolicy.policy.set permission on the folder resource
	// to use this functionality.
	RestrictAllowedResources(context.Context, *RestrictAllowedResourcesRequest) (*RestrictAllowedResourcesResponse, error)
	// Deletes the workload. Make sure that workload's direct children are already
	// in a deleted state, otherwise the request will fail with a
	// FAILED_PRECONDITION error.
	DeleteWorkload(context.Context, *DeleteWorkloadRequest) (*emptypb.Empty, error)
	// Gets Assured Workload associated with a CRM Node
	GetWorkload(context.Context, *GetWorkloadRequest) (*Workload, error)
	// Lists Assured Workloads under a CRM Node.
	ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error)
	// Lists the Violations in the AssuredWorkload Environment.
	// Callers may also choose to read across multiple Workloads as per
	// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
	// character) as a wildcard character instead of workload-id in the parent.
	// Format `organizations/{org_id}/locations/{location}/workloads/-`
	ListViolations(context.Context, *ListViolationsRequest) (*ListViolationsResponse, error)
	// Retrieves Assured Workload Violation based on ID.
	GetViolation(context.Context, *GetViolationRequest) (*Violation, error)
	// Acknowledges an existing violation. By acknowledging a violation, users
	// acknowledge the existence of a compliance violation in their workload and
	// decide to ignore it due to a valid business justification. Acknowledgement
	// is a permanent operation and it cannot be reverted.
	AcknowledgeViolation(context.Context, *AcknowledgeViolationRequest) (*AcknowledgeViolationResponse, error)
}

// UnimplementedAssuredWorkloadsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssuredWorkloadsServiceServer struct {
}

func (*UnimplementedAssuredWorkloadsServiceServer) CreateWorkload(context.Context, *CreateWorkloadRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkload not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) UpdateWorkload(context.Context, *UpdateWorkloadRequest) (*Workload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkload not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) RestrictAllowedResources(context.Context, *RestrictAllowedResourcesRequest) (*RestrictAllowedResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestrictAllowedResources not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) DeleteWorkload(context.Context, *DeleteWorkloadRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkload not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) GetWorkload(context.Context, *GetWorkloadRequest) (*Workload, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkload not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkloads not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) ListViolations(context.Context, *ListViolationsRequest) (*ListViolationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListViolations not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) GetViolation(context.Context, *GetViolationRequest) (*Violation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetViolation not implemented")
}
func (*UnimplementedAssuredWorkloadsServiceServer) AcknowledgeViolation(context.Context, *AcknowledgeViolationRequest) (*AcknowledgeViolationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcknowledgeViolation not implemented")
}

func RegisterAssuredWorkloadsServiceServer(s *grpc.Server, srv AssuredWorkloadsServiceServer) {
	s.RegisterService(&_AssuredWorkloadsService_serviceDesc, srv)
}

func _AssuredWorkloadsService_CreateWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).CreateWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/CreateWorkload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).CreateWorkload(ctx, req.(*CreateWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_UpdateWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).UpdateWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/UpdateWorkload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).UpdateWorkload(ctx, req.(*UpdateWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_RestrictAllowedResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestrictAllowedResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).RestrictAllowedResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/RestrictAllowedResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).RestrictAllowedResources(ctx, req.(*RestrictAllowedResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_DeleteWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).DeleteWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/DeleteWorkload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).DeleteWorkload(ctx, req.(*DeleteWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_GetWorkload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkloadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).GetWorkload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/GetWorkload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).GetWorkload(ctx, req.(*GetWorkloadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_ListWorkloads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkloadsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).ListWorkloads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/ListWorkloads",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).ListWorkloads(ctx, req.(*ListWorkloadsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_ListViolations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListViolationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).ListViolations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/ListViolations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).ListViolations(ctx, req.(*ListViolationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_GetViolation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetViolationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).GetViolation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/GetViolation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).GetViolation(ctx, req.(*GetViolationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssuredWorkloadsService_AcknowledgeViolation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeViolationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssuredWorkloadsServiceServer).AcknowledgeViolation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.assuredworkloads.v1.AssuredWorkloadsService/AcknowledgeViolation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssuredWorkloadsServiceServer).AcknowledgeViolation(ctx, req.(*AcknowledgeViolationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssuredWorkloadsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.assuredworkloads.v1.AssuredWorkloadsService",
	HandlerType: (*AssuredWorkloadsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWorkload",
			Handler:    _AssuredWorkloadsService_CreateWorkload_Handler,
		},
		{
			MethodName: "UpdateWorkload",
			Handler:    _AssuredWorkloadsService_UpdateWorkload_Handler,
		},
		{
			MethodName: "RestrictAllowedResources",
			Handler:    _AssuredWorkloadsService_RestrictAllowedResources_Handler,
		},
		{
			MethodName: "DeleteWorkload",
			Handler:    _AssuredWorkloadsService_DeleteWorkload_Handler,
		},
		{
			MethodName: "GetWorkload",
			Handler:    _AssuredWorkloadsService_GetWorkload_Handler,
		},
		{
			MethodName: "ListWorkloads",
			Handler:    _AssuredWorkloadsService_ListWorkloads_Handler,
		},
		{
			MethodName: "ListViolations",
			Handler:    _AssuredWorkloadsService_ListViolations_Handler,
		},
		{
			MethodName: "GetViolation",
			Handler:    _AssuredWorkloadsService_GetViolation_Handler,
		},
		{
			MethodName: "AcknowledgeViolation",
			Handler:    _AssuredWorkloadsService_AcknowledgeViolation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/assuredworkloads/v1/assuredworkloads.proto",
}
