// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/apihub/v1/runtime_project_attachment_service.proto

package apihubpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The
// [CreateRuntimeProjectAttachment][google.cloud.apihub.v1.RuntimeProjectAttachmentService.CreateRuntimeProjectAttachment]
// method's request.
type CreateRuntimeProjectAttachmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource for the Runtime Project Attachment.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the Runtime Project Attachment, which will
	// become the final component of the Runtime Project Attachment's name. The ID
	// must be the same as the project ID of the Google cloud project specified in
	// the runtime_project_attachment.runtime_project field.
	RuntimeProjectAttachmentId string `protobuf:"bytes,2,opt,name=runtime_project_attachment_id,json=runtimeProjectAttachmentId,proto3" json:"runtime_project_attachment_id,omitempty"`
	// Required. The Runtime Project Attachment to create.
	RuntimeProjectAttachment *RuntimeProjectAttachment `protobuf:"bytes,3,opt,name=runtime_project_attachment,json=runtimeProjectAttachment,proto3" json:"runtime_project_attachment,omitempty"`
}

func (x *CreateRuntimeProjectAttachmentRequest) Reset() {
	*x = CreateRuntimeProjectAttachmentRequest{}
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRuntimeProjectAttachmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRuntimeProjectAttachmentRequest) ProtoMessage() {}

func (x *CreateRuntimeProjectAttachmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRuntimeProjectAttachmentRequest.ProtoReflect.Descriptor instead.
func (*CreateRuntimeProjectAttachmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateRuntimeProjectAttachmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRuntimeProjectAttachmentRequest) GetRuntimeProjectAttachmentId() string {
	if x != nil {
		return x.RuntimeProjectAttachmentId
	}
	return ""
}

func (x *CreateRuntimeProjectAttachmentRequest) GetRuntimeProjectAttachment() *RuntimeProjectAttachment {
	if x != nil {
		return x.RuntimeProjectAttachment
	}
	return nil
}

// The
// [GetRuntimeProjectAttachment][google.cloud.apihub.v1.RuntimeProjectAttachmentService.GetRuntimeProjectAttachment]
// method's request.
type GetRuntimeProjectAttachmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the API resource to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_project_attachment}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRuntimeProjectAttachmentRequest) Reset() {
	*x = GetRuntimeProjectAttachmentRequest{}
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRuntimeProjectAttachmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRuntimeProjectAttachmentRequest) ProtoMessage() {}

func (x *GetRuntimeProjectAttachmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRuntimeProjectAttachmentRequest.ProtoReflect.Descriptor instead.
func (*GetRuntimeProjectAttachmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetRuntimeProjectAttachmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The
// [ListRuntimeProjectAttachments][google.cloud.apihub.v1.RuntimeProjectAttachmentService.ListRuntimeProjectAttachments]
// method's request.
type ListRuntimeProjectAttachmentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of runtime project
	// attachments. Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of runtime project attachments to return. The
	// service may return fewer than this value. If unspecified, at most 50
	// runtime project attachments will be returned. The maximum value is 1000;
	// values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// `ListRuntimeProjectAttachments` call. Provide this to retrieve the
	// subsequent page.
	//
	// When paginating, all other parameters (except page_size) provided to
	// `ListRuntimeProjectAttachments` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An expression that filters the list of RuntimeProjectAttachments.
	//
	// A filter expression consists of a field name, a comparison
	// operator, and a value for filtering. The value must be a string. All
	// standard operators as documented at https://google.aip.dev/160 are
	// supported.
	//
	// The following fields in the `RuntimeProjectAttachment` are eligible for
	// filtering:
	//
	//   - `name` - The name of the RuntimeProjectAttachment.
	//   - `create_time` - The time at which the RuntimeProjectAttachment was
	//     created. The value should be in the
	//     (RFC3339)[https://tools.ietf.org/html/rfc3339] format.
	//   - `runtime_project` - The Google cloud project associated with the
	//     RuntimeProjectAttachment.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRuntimeProjectAttachmentsRequest) Reset() {
	*x = ListRuntimeProjectAttachmentsRequest{}
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRuntimeProjectAttachmentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimeProjectAttachmentsRequest) ProtoMessage() {}

func (x *ListRuntimeProjectAttachmentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimeProjectAttachmentsRequest.ProtoReflect.Descriptor instead.
func (*ListRuntimeProjectAttachmentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListRuntimeProjectAttachmentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRuntimeProjectAttachmentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRuntimeProjectAttachmentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRuntimeProjectAttachmentsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRuntimeProjectAttachmentsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The
// [ListRuntimeProjectAttachments][google.cloud.apihub.v1.RuntimeProjectAttachmentService.ListRuntimeProjectAttachments]
// method's response.
type ListRuntimeProjectAttachmentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of runtime project attachments.
	RuntimeProjectAttachments []*RuntimeProjectAttachment `protobuf:"bytes,1,rep,name=runtime_project_attachments,json=runtimeProjectAttachments,proto3" json:"runtime_project_attachments,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRuntimeProjectAttachmentsResponse) Reset() {
	*x = ListRuntimeProjectAttachmentsResponse{}
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRuntimeProjectAttachmentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRuntimeProjectAttachmentsResponse) ProtoMessage() {}

func (x *ListRuntimeProjectAttachmentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRuntimeProjectAttachmentsResponse.ProtoReflect.Descriptor instead.
func (*ListRuntimeProjectAttachmentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListRuntimeProjectAttachmentsResponse) GetRuntimeProjectAttachments() []*RuntimeProjectAttachment {
	if x != nil {
		return x.RuntimeProjectAttachments
	}
	return nil
}

func (x *ListRuntimeProjectAttachmentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The
// [DeleteRuntimeProjectAttachment][google.cloud.apihub.v1.RuntimeProjectAttachmentService.DeleteRuntimeProjectAttachment]
// method's request.
type DeleteRuntimeProjectAttachmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Runtime Project Attachment to delete.
	// Format:
	// `projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_project_attachment}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteRuntimeProjectAttachmentRequest) Reset() {
	*x = DeleteRuntimeProjectAttachmentRequest{}
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRuntimeProjectAttachmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRuntimeProjectAttachmentRequest) ProtoMessage() {}

func (x *DeleteRuntimeProjectAttachmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRuntimeProjectAttachmentRequest.ProtoReflect.Descriptor instead.
func (*DeleteRuntimeProjectAttachmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteRuntimeProjectAttachmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The
// [LookupRuntimeProjectAttachment][google.cloud.apihub.v1.RuntimeProjectAttachmentService.LookupRuntimeProjectAttachment]
// method's request.
type LookupRuntimeProjectAttachmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Runtime project ID to look up runtime project attachment for.
	// Lookup happens across all regions. Expected format:
	// `projects/{project}/locations/{location}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *LookupRuntimeProjectAttachmentRequest) Reset() {
	*x = LookupRuntimeProjectAttachmentRequest{}
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LookupRuntimeProjectAttachmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupRuntimeProjectAttachmentRequest) ProtoMessage() {}

func (x *LookupRuntimeProjectAttachmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupRuntimeProjectAttachmentRequest.ProtoReflect.Descriptor instead.
func (*LookupRuntimeProjectAttachmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescGZIP(), []int{5}
}

func (x *LookupRuntimeProjectAttachmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The
// [ListRuntimeProjectAttachments][google.cloud.apihub.v1.RuntimeProjectAttachmentService.ListRuntimeProjectAttachments]
// method's response.
type LookupRuntimeProjectAttachmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Runtime project attachment for a project if exists, empty otherwise.
	RuntimeProjectAttachment *RuntimeProjectAttachment `protobuf:"bytes,1,opt,name=runtime_project_attachment,json=runtimeProjectAttachment,proto3" json:"runtime_project_attachment,omitempty"`
}

func (x *LookupRuntimeProjectAttachmentResponse) Reset() {
	*x = LookupRuntimeProjectAttachmentResponse{}
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LookupRuntimeProjectAttachmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupRuntimeProjectAttachmentResponse) ProtoMessage() {}

func (x *LookupRuntimeProjectAttachmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupRuntimeProjectAttachmentResponse.ProtoReflect.Descriptor instead.
func (*LookupRuntimeProjectAttachmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescGZIP(), []int{6}
}

func (x *LookupRuntimeProjectAttachmentResponse) GetRuntimeProjectAttachment() *RuntimeProjectAttachment {
	if x != nil {
		return x.RuntimeProjectAttachment
	}
	return nil
}

// Runtime project attachment represents an attachment from the runtime project
// to the host project. Api Hub looks for deployments in the attached runtime
// projects and creates corresponding resources in Api Hub for the discovered
// deployments.
type RuntimeProjectAttachment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of a runtime project attachment. Format:
	// "projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_project_attachment}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. Google cloud project name in the format:
	// "projects/abc" or "projects/123". As input, project name with either
	// project id or number are accepted. As output, this field will contain
	// project number.
	RuntimeProject string `protobuf:"bytes,2,opt,name=runtime_project,json=runtimeProject,proto3" json:"runtime_project,omitempty"`
	// Output only. Create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *RuntimeProjectAttachment) Reset() {
	*x = RuntimeProjectAttachment{}
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeProjectAttachment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeProjectAttachment) ProtoMessage() {}

func (x *RuntimeProjectAttachment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeProjectAttachment.ProtoReflect.Descriptor instead.
func (*RuntimeProjectAttachment) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescGZIP(), []int{7}
}

func (x *RuntimeProjectAttachment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RuntimeProjectAttachment) GetRuntimeProject() string {
	if x != nil {
		return x.RuntimeProject
	}
	return ""
}

func (x *RuntimeProjectAttachment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

var File_google_cloud_apihub_v1_runtime_project_attachment_service_proto protoreflect.FileDescriptor

var file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb4, 0x02, 0x0a, 0x25, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x1d, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x1a, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x73, 0x0a, 0x1a,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x70, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xf9, 0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22,
	0xc1, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x70, 0x0a, 0x1b, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x19, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x73, 0x0a, 0x25, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x30, 0x0a, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x25, 0x4c, 0x6f, 0x6f, 0x6b,
	0x75, 0x70, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x98, 0x01, 0x0a, 0x26, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6e, 0x0a, 0x1a, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x18, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xa2, 0x03, 0x0a, 0x18,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x5f, 0x0a, 0x0f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xe0,
	0x41, 0x05, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x3a, 0xc9, 0x01, 0xea, 0x41, 0xc5, 0x01, 0x0a, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2a, 0x19, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x32, 0x18, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x32, 0xac, 0x0a, 0x0a, 0x1f, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xb7, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xa3, 0x01, 0xda, 0x41, 0x3f, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x2c,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x5b, 0x3a, 0x1a, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xd9,
	0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x4c, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xec, 0x01, 0x0a, 0x1d, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xc5, 0x01, 0x0a, 0x1e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x4c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3f, 0x2a, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xf0, 0x01, 0x0a, 0x1e, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x6f, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x6f,
	0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x4f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0xc6, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x42, 0x24,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x70,
	0x62, 0x3b, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x70,
	0x69, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescOnce sync.Once
	file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescData = file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDesc
)

func file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescGZIP() []byte {
	file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescData)
	})
	return file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDescData
}

var file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_goTypes = []any{
	(*CreateRuntimeProjectAttachmentRequest)(nil),  // 0: google.cloud.apihub.v1.CreateRuntimeProjectAttachmentRequest
	(*GetRuntimeProjectAttachmentRequest)(nil),     // 1: google.cloud.apihub.v1.GetRuntimeProjectAttachmentRequest
	(*ListRuntimeProjectAttachmentsRequest)(nil),   // 2: google.cloud.apihub.v1.ListRuntimeProjectAttachmentsRequest
	(*ListRuntimeProjectAttachmentsResponse)(nil),  // 3: google.cloud.apihub.v1.ListRuntimeProjectAttachmentsResponse
	(*DeleteRuntimeProjectAttachmentRequest)(nil),  // 4: google.cloud.apihub.v1.DeleteRuntimeProjectAttachmentRequest
	(*LookupRuntimeProjectAttachmentRequest)(nil),  // 5: google.cloud.apihub.v1.LookupRuntimeProjectAttachmentRequest
	(*LookupRuntimeProjectAttachmentResponse)(nil), // 6: google.cloud.apihub.v1.LookupRuntimeProjectAttachmentResponse
	(*RuntimeProjectAttachment)(nil),               // 7: google.cloud.apihub.v1.RuntimeProjectAttachment
	(*timestamppb.Timestamp)(nil),                  // 8: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),                          // 9: google.protobuf.Empty
}
var file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_depIdxs = []int32{
	7, // 0: google.cloud.apihub.v1.CreateRuntimeProjectAttachmentRequest.runtime_project_attachment:type_name -> google.cloud.apihub.v1.RuntimeProjectAttachment
	7, // 1: google.cloud.apihub.v1.ListRuntimeProjectAttachmentsResponse.runtime_project_attachments:type_name -> google.cloud.apihub.v1.RuntimeProjectAttachment
	7, // 2: google.cloud.apihub.v1.LookupRuntimeProjectAttachmentResponse.runtime_project_attachment:type_name -> google.cloud.apihub.v1.RuntimeProjectAttachment
	8, // 3: google.cloud.apihub.v1.RuntimeProjectAttachment.create_time:type_name -> google.protobuf.Timestamp
	0, // 4: google.cloud.apihub.v1.RuntimeProjectAttachmentService.CreateRuntimeProjectAttachment:input_type -> google.cloud.apihub.v1.CreateRuntimeProjectAttachmentRequest
	1, // 5: google.cloud.apihub.v1.RuntimeProjectAttachmentService.GetRuntimeProjectAttachment:input_type -> google.cloud.apihub.v1.GetRuntimeProjectAttachmentRequest
	2, // 6: google.cloud.apihub.v1.RuntimeProjectAttachmentService.ListRuntimeProjectAttachments:input_type -> google.cloud.apihub.v1.ListRuntimeProjectAttachmentsRequest
	4, // 7: google.cloud.apihub.v1.RuntimeProjectAttachmentService.DeleteRuntimeProjectAttachment:input_type -> google.cloud.apihub.v1.DeleteRuntimeProjectAttachmentRequest
	5, // 8: google.cloud.apihub.v1.RuntimeProjectAttachmentService.LookupRuntimeProjectAttachment:input_type -> google.cloud.apihub.v1.LookupRuntimeProjectAttachmentRequest
	7, // 9: google.cloud.apihub.v1.RuntimeProjectAttachmentService.CreateRuntimeProjectAttachment:output_type -> google.cloud.apihub.v1.RuntimeProjectAttachment
	7, // 10: google.cloud.apihub.v1.RuntimeProjectAttachmentService.GetRuntimeProjectAttachment:output_type -> google.cloud.apihub.v1.RuntimeProjectAttachment
	3, // 11: google.cloud.apihub.v1.RuntimeProjectAttachmentService.ListRuntimeProjectAttachments:output_type -> google.cloud.apihub.v1.ListRuntimeProjectAttachmentsResponse
	9, // 12: google.cloud.apihub.v1.RuntimeProjectAttachmentService.DeleteRuntimeProjectAttachment:output_type -> google.protobuf.Empty
	6, // 13: google.cloud.apihub.v1.RuntimeProjectAttachmentService.LookupRuntimeProjectAttachment:output_type -> google.cloud.apihub.v1.LookupRuntimeProjectAttachmentResponse
	9, // [9:14] is the sub-list for method output_type
	4, // [4:9] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_init() }
func file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_init() {
	if File_google_cloud_apihub_v1_runtime_project_attachment_service_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_msgTypes,
	}.Build()
	File_google_cloud_apihub_v1_runtime_project_attachment_service_proto = out.File
	file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_rawDesc = nil
	file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_goTypes = nil
	file_google_cloud_apihub_v1_runtime_project_attachment_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RuntimeProjectAttachmentServiceClient is the client API for RuntimeProjectAttachmentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RuntimeProjectAttachmentServiceClient interface {
	// Attaches a runtime project to the host project.
	CreateRuntimeProjectAttachment(ctx context.Context, in *CreateRuntimeProjectAttachmentRequest, opts ...grpc.CallOption) (*RuntimeProjectAttachment, error)
	// Gets a runtime project attachment.
	GetRuntimeProjectAttachment(ctx context.Context, in *GetRuntimeProjectAttachmentRequest, opts ...grpc.CallOption) (*RuntimeProjectAttachment, error)
	// List runtime projects attached to the host project.
	ListRuntimeProjectAttachments(ctx context.Context, in *ListRuntimeProjectAttachmentsRequest, opts ...grpc.CallOption) (*ListRuntimeProjectAttachmentsResponse, error)
	// Delete a runtime project attachment in the API Hub. This call will detach
	// the runtime project from the host project.
	DeleteRuntimeProjectAttachment(ctx context.Context, in *DeleteRuntimeProjectAttachmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Look up a runtime project attachment. This API can be called in the context
	// of any project.
	LookupRuntimeProjectAttachment(ctx context.Context, in *LookupRuntimeProjectAttachmentRequest, opts ...grpc.CallOption) (*LookupRuntimeProjectAttachmentResponse, error)
}

type runtimeProjectAttachmentServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRuntimeProjectAttachmentServiceClient(cc grpc.ClientConnInterface) RuntimeProjectAttachmentServiceClient {
	return &runtimeProjectAttachmentServiceClient{cc}
}

func (c *runtimeProjectAttachmentServiceClient) CreateRuntimeProjectAttachment(ctx context.Context, in *CreateRuntimeProjectAttachmentRequest, opts ...grpc.CallOption) (*RuntimeProjectAttachment, error) {
	out := new(RuntimeProjectAttachment)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/CreateRuntimeProjectAttachment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeProjectAttachmentServiceClient) GetRuntimeProjectAttachment(ctx context.Context, in *GetRuntimeProjectAttachmentRequest, opts ...grpc.CallOption) (*RuntimeProjectAttachment, error) {
	out := new(RuntimeProjectAttachment)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/GetRuntimeProjectAttachment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeProjectAttachmentServiceClient) ListRuntimeProjectAttachments(ctx context.Context, in *ListRuntimeProjectAttachmentsRequest, opts ...grpc.CallOption) (*ListRuntimeProjectAttachmentsResponse, error) {
	out := new(ListRuntimeProjectAttachmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/ListRuntimeProjectAttachments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeProjectAttachmentServiceClient) DeleteRuntimeProjectAttachment(ctx context.Context, in *DeleteRuntimeProjectAttachmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/DeleteRuntimeProjectAttachment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeProjectAttachmentServiceClient) LookupRuntimeProjectAttachment(ctx context.Context, in *LookupRuntimeProjectAttachmentRequest, opts ...grpc.CallOption) (*LookupRuntimeProjectAttachmentResponse, error) {
	out := new(LookupRuntimeProjectAttachmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/LookupRuntimeProjectAttachment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RuntimeProjectAttachmentServiceServer is the server API for RuntimeProjectAttachmentService service.
type RuntimeProjectAttachmentServiceServer interface {
	// Attaches a runtime project to the host project.
	CreateRuntimeProjectAttachment(context.Context, *CreateRuntimeProjectAttachmentRequest) (*RuntimeProjectAttachment, error)
	// Gets a runtime project attachment.
	GetRuntimeProjectAttachment(context.Context, *GetRuntimeProjectAttachmentRequest) (*RuntimeProjectAttachment, error)
	// List runtime projects attached to the host project.
	ListRuntimeProjectAttachments(context.Context, *ListRuntimeProjectAttachmentsRequest) (*ListRuntimeProjectAttachmentsResponse, error)
	// Delete a runtime project attachment in the API Hub. This call will detach
	// the runtime project from the host project.
	DeleteRuntimeProjectAttachment(context.Context, *DeleteRuntimeProjectAttachmentRequest) (*emptypb.Empty, error)
	// Look up a runtime project attachment. This API can be called in the context
	// of any project.
	LookupRuntimeProjectAttachment(context.Context, *LookupRuntimeProjectAttachmentRequest) (*LookupRuntimeProjectAttachmentResponse, error)
}

// UnimplementedRuntimeProjectAttachmentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRuntimeProjectAttachmentServiceServer struct {
}

func (*UnimplementedRuntimeProjectAttachmentServiceServer) CreateRuntimeProjectAttachment(context.Context, *CreateRuntimeProjectAttachmentRequest) (*RuntimeProjectAttachment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRuntimeProjectAttachment not implemented")
}
func (*UnimplementedRuntimeProjectAttachmentServiceServer) GetRuntimeProjectAttachment(context.Context, *GetRuntimeProjectAttachmentRequest) (*RuntimeProjectAttachment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRuntimeProjectAttachment not implemented")
}
func (*UnimplementedRuntimeProjectAttachmentServiceServer) ListRuntimeProjectAttachments(context.Context, *ListRuntimeProjectAttachmentsRequest) (*ListRuntimeProjectAttachmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuntimeProjectAttachments not implemented")
}
func (*UnimplementedRuntimeProjectAttachmentServiceServer) DeleteRuntimeProjectAttachment(context.Context, *DeleteRuntimeProjectAttachmentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRuntimeProjectAttachment not implemented")
}
func (*UnimplementedRuntimeProjectAttachmentServiceServer) LookupRuntimeProjectAttachment(context.Context, *LookupRuntimeProjectAttachmentRequest) (*LookupRuntimeProjectAttachmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupRuntimeProjectAttachment not implemented")
}

func RegisterRuntimeProjectAttachmentServiceServer(s *grpc.Server, srv RuntimeProjectAttachmentServiceServer) {
	s.RegisterService(&_RuntimeProjectAttachmentService_serviceDesc, srv)
}

func _RuntimeProjectAttachmentService_CreateRuntimeProjectAttachment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRuntimeProjectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeProjectAttachmentServiceServer).CreateRuntimeProjectAttachment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/CreateRuntimeProjectAttachment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeProjectAttachmentServiceServer).CreateRuntimeProjectAttachment(ctx, req.(*CreateRuntimeProjectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeProjectAttachmentService_GetRuntimeProjectAttachment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRuntimeProjectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeProjectAttachmentServiceServer).GetRuntimeProjectAttachment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/GetRuntimeProjectAttachment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeProjectAttachmentServiceServer).GetRuntimeProjectAttachment(ctx, req.(*GetRuntimeProjectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeProjectAttachmentService_ListRuntimeProjectAttachments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRuntimeProjectAttachmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeProjectAttachmentServiceServer).ListRuntimeProjectAttachments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/ListRuntimeProjectAttachments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeProjectAttachmentServiceServer).ListRuntimeProjectAttachments(ctx, req.(*ListRuntimeProjectAttachmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeProjectAttachmentService_DeleteRuntimeProjectAttachment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRuntimeProjectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeProjectAttachmentServiceServer).DeleteRuntimeProjectAttachment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/DeleteRuntimeProjectAttachment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeProjectAttachmentServiceServer).DeleteRuntimeProjectAttachment(ctx, req.(*DeleteRuntimeProjectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeProjectAttachmentService_LookupRuntimeProjectAttachment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupRuntimeProjectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeProjectAttachmentServiceServer).LookupRuntimeProjectAttachment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.RuntimeProjectAttachmentService/LookupRuntimeProjectAttachment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeProjectAttachmentServiceServer).LookupRuntimeProjectAttachment(ctx, req.(*LookupRuntimeProjectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RuntimeProjectAttachmentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.apihub.v1.RuntimeProjectAttachmentService",
	HandlerType: (*RuntimeProjectAttachmentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateRuntimeProjectAttachment",
			Handler:    _RuntimeProjectAttachmentService_CreateRuntimeProjectAttachment_Handler,
		},
		{
			MethodName: "GetRuntimeProjectAttachment",
			Handler:    _RuntimeProjectAttachmentService_GetRuntimeProjectAttachment_Handler,
		},
		{
			MethodName: "ListRuntimeProjectAttachments",
			Handler:    _RuntimeProjectAttachmentService_ListRuntimeProjectAttachments_Handler,
		},
		{
			MethodName: "DeleteRuntimeProjectAttachment",
			Handler:    _RuntimeProjectAttachmentService_DeleteRuntimeProjectAttachment_Handler,
		},
		{
			MethodName: "LookupRuntimeProjectAttachment",
			Handler:    _RuntimeProjectAttachmentService_LookupRuntimeProjectAttachment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/apihub/v1/runtime_project_attachment_service.proto",
}
