// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/apihub/v1/plugin_service.proto

package apihubpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible states a plugin can have. Note that this enum may receive new
// values in the future. Consumers are advised to always code against the
// enum values expecting new states can be added later on.
type Plugin_State int32

const (
	// The default value. This value is used if the state is omitted.
	Plugin_STATE_UNSPECIFIED Plugin_State = 0
	// The plugin is enabled.
	Plugin_ENABLED Plugin_State = 1
	// The plugin is disabled.
	Plugin_DISABLED Plugin_State = 2
)

// Enum value maps for Plugin_State.
var (
	Plugin_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
	}
	Plugin_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ENABLED":           1,
		"DISABLED":          2,
	}
)

func (x Plugin_State) Enum() *Plugin_State {
	p := new(Plugin_State)
	*p = x
	return p
}

func (x Plugin_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Plugin_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apihub_v1_plugin_service_proto_enumTypes[0].Descriptor()
}

func (Plugin_State) Type() protoreflect.EnumType {
	return &file_google_cloud_apihub_v1_plugin_service_proto_enumTypes[0]
}

func (x Plugin_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Plugin_State.Descriptor instead.
func (Plugin_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_plugin_service_proto_rawDescGZIP(), []int{0, 0}
}

// A plugin resource in the API Hub.
type Plugin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the plugin.
	// Format: `projects/{project}/locations/{location}/plugins/{plugin}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the plugin. Max length is 50 characters
	// (Unicode code points).
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The type of the API.
	// This maps to the following system defined attribute:
	// `projects/{project}/locations/{location}/attributes/system-plugin-type`
	// attribute.
	// The number of allowed values for this attribute will be based on the
	// cardinality of the attribute. The same can be retrieved via GetAttribute
	// API. All values should be from the list of allowed values defined for the
	// attribute.
	Type *AttributeValues `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Optional. The plugin description. Max length is 2000 characters (Unicode
	// code points).
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Represents the state of the plugin.
	State Plugin_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.apihub.v1.Plugin_State" json:"state,omitempty"`
}

func (x *Plugin) Reset() {
	*x = Plugin{}
	mi := &file_google_cloud_apihub_v1_plugin_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Plugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Plugin) ProtoMessage() {}

func (x *Plugin) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_plugin_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Plugin.ProtoReflect.Descriptor instead.
func (*Plugin) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_plugin_service_proto_rawDescGZIP(), []int{0}
}

func (x *Plugin) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Plugin) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Plugin) GetType() *AttributeValues {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Plugin) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Plugin) GetState() Plugin_State {
	if x != nil {
		return x.State
	}
	return Plugin_STATE_UNSPECIFIED
}

// The [GetPlugin][google.cloud.apihub.v1.ApiHubPlugin.GetPlugin] method's
// request.
type GetPluginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the plugin to retrieve.
	// Format: `projects/{project}/locations/{location}/plugins/{plugin}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPluginRequest) Reset() {
	*x = GetPluginRequest{}
	mi := &file_google_cloud_apihub_v1_plugin_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPluginRequest) ProtoMessage() {}

func (x *GetPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_plugin_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPluginRequest.ProtoReflect.Descriptor instead.
func (*GetPluginRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_plugin_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetPluginRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [EnablePlugin][google.cloud.apihub.v1.ApiHubPlugin.EnablePlugin] method's
// request.
type EnablePluginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the plugin to enable.
	// Format: `projects/{project}/locations/{location}/plugins/{plugin}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EnablePluginRequest) Reset() {
	*x = EnablePluginRequest{}
	mi := &file_google_cloud_apihub_v1_plugin_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnablePluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnablePluginRequest) ProtoMessage() {}

func (x *EnablePluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_plugin_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnablePluginRequest.ProtoReflect.Descriptor instead.
func (*EnablePluginRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_plugin_service_proto_rawDescGZIP(), []int{2}
}

func (x *EnablePluginRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The [DisablePlugin][google.cloud.apihub.v1.ApiHubPlugin.DisablePlugin]
// method's request.
type DisablePluginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the plugin to disable.
	// Format: `projects/{project}/locations/{location}/plugins/{plugin}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DisablePluginRequest) Reset() {
	*x = DisablePluginRequest{}
	mi := &file_google_cloud_apihub_v1_plugin_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisablePluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisablePluginRequest) ProtoMessage() {}

func (x *DisablePluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apihub_v1_plugin_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisablePluginRequest.ProtoReflect.Descriptor instead.
func (*DisablePluginRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apihub_v1_plugin_service_proto_rawDescGZIP(), []int{3}
}

func (x *DisablePluginRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_apihub_v1_plugin_service_proto protoreflect.FileDescriptor

var file_google_cloud_apihub_v1_plugin_service_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9c, 0x03, 0x0a, 0x06, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x39, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a, 0x1c, 0x61, 0x70, 0x69, 0x68,
	0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x7d, 0x2a, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x32, 0x06, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x22, 0x4c, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x4f, 0x0a, 0x13, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x50, 0x0a, 0x14, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e,
	0x0a, 0x1c, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x32, 0xb8, 0x04, 0x0a, 0x0c, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x91, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x22, 0x3a, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa1, 0x01, 0x0a, 0x0c, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x12, 0xa4, 0x01,
	0x0a, 0x0d, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x22, 0x45, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x01, 0x2a, 0x22,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0xb4, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x42, 0x12,
	0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x70, 0x62, 0x3b,
	0x61, 0x70, 0x69, 0x68, 0x75, 0x62, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x41, 0x70, 0x69, 0x48, 0x75, 0x62, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x70, 0x69, 0x48,
	0x75, 0x62, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_apihub_v1_plugin_service_proto_rawDescOnce sync.Once
	file_google_cloud_apihub_v1_plugin_service_proto_rawDescData = file_google_cloud_apihub_v1_plugin_service_proto_rawDesc
)

func file_google_cloud_apihub_v1_plugin_service_proto_rawDescGZIP() []byte {
	file_google_cloud_apihub_v1_plugin_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_apihub_v1_plugin_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_apihub_v1_plugin_service_proto_rawDescData)
	})
	return file_google_cloud_apihub_v1_plugin_service_proto_rawDescData
}

var file_google_cloud_apihub_v1_plugin_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_apihub_v1_plugin_service_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_apihub_v1_plugin_service_proto_goTypes = []any{
	(Plugin_State)(0),            // 0: google.cloud.apihub.v1.Plugin.State
	(*Plugin)(nil),               // 1: google.cloud.apihub.v1.Plugin
	(*GetPluginRequest)(nil),     // 2: google.cloud.apihub.v1.GetPluginRequest
	(*EnablePluginRequest)(nil),  // 3: google.cloud.apihub.v1.EnablePluginRequest
	(*DisablePluginRequest)(nil), // 4: google.cloud.apihub.v1.DisablePluginRequest
	(*AttributeValues)(nil),      // 5: google.cloud.apihub.v1.AttributeValues
}
var file_google_cloud_apihub_v1_plugin_service_proto_depIdxs = []int32{
	5, // 0: google.cloud.apihub.v1.Plugin.type:type_name -> google.cloud.apihub.v1.AttributeValues
	0, // 1: google.cloud.apihub.v1.Plugin.state:type_name -> google.cloud.apihub.v1.Plugin.State
	2, // 2: google.cloud.apihub.v1.ApiHubPlugin.GetPlugin:input_type -> google.cloud.apihub.v1.GetPluginRequest
	3, // 3: google.cloud.apihub.v1.ApiHubPlugin.EnablePlugin:input_type -> google.cloud.apihub.v1.EnablePluginRequest
	4, // 4: google.cloud.apihub.v1.ApiHubPlugin.DisablePlugin:input_type -> google.cloud.apihub.v1.DisablePluginRequest
	1, // 5: google.cloud.apihub.v1.ApiHubPlugin.GetPlugin:output_type -> google.cloud.apihub.v1.Plugin
	1, // 6: google.cloud.apihub.v1.ApiHubPlugin.EnablePlugin:output_type -> google.cloud.apihub.v1.Plugin
	1, // 7: google.cloud.apihub.v1.ApiHubPlugin.DisablePlugin:output_type -> google.cloud.apihub.v1.Plugin
	5, // [5:8] is the sub-list for method output_type
	2, // [2:5] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_apihub_v1_plugin_service_proto_init() }
func file_google_cloud_apihub_v1_plugin_service_proto_init() {
	if File_google_cloud_apihub_v1_plugin_service_proto != nil {
		return
	}
	file_google_cloud_apihub_v1_common_fields_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_apihub_v1_plugin_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_apihub_v1_plugin_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_apihub_v1_plugin_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_apihub_v1_plugin_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_apihub_v1_plugin_service_proto_msgTypes,
	}.Build()
	File_google_cloud_apihub_v1_plugin_service_proto = out.File
	file_google_cloud_apihub_v1_plugin_service_proto_rawDesc = nil
	file_google_cloud_apihub_v1_plugin_service_proto_goTypes = nil
	file_google_cloud_apihub_v1_plugin_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ApiHubPluginClient is the client API for ApiHubPlugin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApiHubPluginClient interface {
	// Get details about an API Hub plugin.
	GetPlugin(ctx context.Context, in *GetPluginRequest, opts ...grpc.CallOption) (*Plugin, error)
	// Enables a plugin.
	// The `state` of the plugin after enabling is `ENABLED`
	EnablePlugin(ctx context.Context, in *EnablePluginRequest, opts ...grpc.CallOption) (*Plugin, error)
	// Disables a plugin.
	// The `state` of the plugin after disabling is `DISABLED`
	DisablePlugin(ctx context.Context, in *DisablePluginRequest, opts ...grpc.CallOption) (*Plugin, error)
}

type apiHubPluginClient struct {
	cc grpc.ClientConnInterface
}

func NewApiHubPluginClient(cc grpc.ClientConnInterface) ApiHubPluginClient {
	return &apiHubPluginClient{cc}
}

func (c *apiHubPluginClient) GetPlugin(ctx context.Context, in *GetPluginRequest, opts ...grpc.CallOption) (*Plugin, error) {
	out := new(Plugin)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHubPlugin/GetPlugin", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubPluginClient) EnablePlugin(ctx context.Context, in *EnablePluginRequest, opts ...grpc.CallOption) (*Plugin, error) {
	out := new(Plugin)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHubPlugin/EnablePlugin", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *apiHubPluginClient) DisablePlugin(ctx context.Context, in *DisablePluginRequest, opts ...grpc.CallOption) (*Plugin, error) {
	out := new(Plugin)
	err := c.cc.Invoke(ctx, "/google.cloud.apihub.v1.ApiHubPlugin/DisablePlugin", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApiHubPluginServer is the server API for ApiHubPlugin service.
type ApiHubPluginServer interface {
	// Get details about an API Hub plugin.
	GetPlugin(context.Context, *GetPluginRequest) (*Plugin, error)
	// Enables a plugin.
	// The `state` of the plugin after enabling is `ENABLED`
	EnablePlugin(context.Context, *EnablePluginRequest) (*Plugin, error)
	// Disables a plugin.
	// The `state` of the plugin after disabling is `DISABLED`
	DisablePlugin(context.Context, *DisablePluginRequest) (*Plugin, error)
}

// UnimplementedApiHubPluginServer can be embedded to have forward compatible implementations.
type UnimplementedApiHubPluginServer struct {
}

func (*UnimplementedApiHubPluginServer) GetPlugin(context.Context, *GetPluginRequest) (*Plugin, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlugin not implemented")
}
func (*UnimplementedApiHubPluginServer) EnablePlugin(context.Context, *EnablePluginRequest) (*Plugin, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnablePlugin not implemented")
}
func (*UnimplementedApiHubPluginServer) DisablePlugin(context.Context, *DisablePluginRequest) (*Plugin, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisablePlugin not implemented")
}

func RegisterApiHubPluginServer(s *grpc.Server, srv ApiHubPluginServer) {
	s.RegisterService(&_ApiHubPlugin_serviceDesc, srv)
}

func _ApiHubPlugin_GetPlugin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPluginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubPluginServer).GetPlugin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHubPlugin/GetPlugin",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubPluginServer).GetPlugin(ctx, req.(*GetPluginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHubPlugin_EnablePlugin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnablePluginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubPluginServer).EnablePlugin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHubPlugin/EnablePlugin",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubPluginServer).EnablePlugin(ctx, req.(*EnablePluginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApiHubPlugin_DisablePlugin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisablePluginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApiHubPluginServer).DisablePlugin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.apihub.v1.ApiHubPlugin/DisablePlugin",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApiHubPluginServer).DisablePlugin(ctx, req.(*DisablePluginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApiHubPlugin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.apihub.v1.ApiHubPlugin",
	HandlerType: (*ApiHubPluginServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPlugin",
			Handler:    _ApiHubPlugin_GetPlugin_Handler,
		},
		{
			MethodName: "EnablePlugin",
			Handler:    _ApiHubPlugin_EnablePlugin_Handler,
		},
		{
			MethodName: "DisablePlugin",
			Handler:    _ApiHubPlugin_DisablePlugin_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/apihub/v1/plugin_service.proto",
}
