// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dfareporting provides access to the Campaign Manager 360 API.
//
// For product documentation, see: https://developers.google.com/doubleclick-advertisers/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/dfareporting/v3.5"
//	...
//	ctx := context.Background()
//	dfareportingService, err := dfareporting.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	dfareportingService, err := dfareporting.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	dfareportingService, err := dfareporting.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package dfareporting // import "google.golang.org/api/dfareporting/v3.5"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "dfareporting:v3.5"
const apiName = "dfareporting"
const apiVersion = "v3.5"
const basePath = "https://dfareporting.googleapis.com/dfareporting/v3.5/"
const basePathTemplate = "https://dfareporting.UNIVERSE_DOMAIN/dfareporting/v3.5/"
const mtlsBasePath = "https://dfareporting.mtls.googleapis.com/dfareporting/v3.5/"

// OAuth2 scopes used by this API.
const (
	// View and manage your DoubleClick Campaign Manager's (DCM) display ad
	// campaigns
	DfatraffickingScope = "https://www.googleapis.com/auth/dfatrafficking"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/dfatrafficking",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Media = NewMediaService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Media *MediaService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

// ClickTag: Creative Click Tag.
type ClickTag struct {
	// ClickThroughUrl: Parameter value for the specified click tag. This field
	// contains a click-through url.
	ClickThroughUrl *CreativeClickThroughUrl `json:"clickThroughUrl,omitempty"`
	// EventName: Advertiser event name associated with the click tag. This field
	// is used by DISPLAY_IMAGE_GALLERY and HTML5_BANNER creatives. Applicable to
	// DISPLAY when the primary asset type is not HTML_IMAGE.
	EventName string `json:"eventName,omitempty"`
	// Name: Parameter name for the specified click tag. For DISPLAY_IMAGE_GALLERY
	// creative assets, this field must match the value of the creative asset's
	// creativeAssetId.name field.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClickThroughUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClickThroughUrl") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClickTag) MarshalJSON() ([]byte, error) {
	type NoMethod ClickTag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreativeAssetId: Creative Asset ID.
type CreativeAssetId struct {
	// Name: Name of the creative asset. This is a required field while inserting
	// an asset. After insertion, this assetIdentifier is used to identify the
	// uploaded asset. Characters in the name must be alphanumeric or one of the
	// following: ".-_ ". Spaces are allowed.
	Name string `json:"name,omitempty"`
	// Type: Type of asset to upload. This is a required field. FLASH and IMAGE are
	// no longer supported for new uploads. All image assets should use HTML_IMAGE.
	//
	// Possible values:
	//   "IMAGE"
	//   "FLASH"
	//   "VIDEO"
	//   "HTML"
	//   "HTML_IMAGE"
	//   "AUDIO"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreativeAssetId) MarshalJSON() ([]byte, error) {
	type NoMethod CreativeAssetId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreativeAssetMetadata: CreativeAssets contains properties of a creative
// asset file which will be uploaded or has already been uploaded. Refer to the
// creative sample code for how to upload assets and insert a creative.
type CreativeAssetMetadata struct {
	// AssetIdentifier: ID of the creative asset. This is a required field.
	AssetIdentifier *CreativeAssetId `json:"assetIdentifier,omitempty"`
	// ClickTags: List of detected click tags for assets. This is a read-only,
	// auto-generated field. This field is empty for a rich media asset.
	ClickTags []*ClickTag `json:"clickTags,omitempty"`
	// CounterCustomEvents: List of counter events configured for the asset. This
	// is a read-only, auto-generated field and only applicable to a rich media
	// asset.
	CounterCustomEvents []*CreativeCustomEvent `json:"counterCustomEvents,omitempty"`
	// DetectedFeatures: List of feature dependencies for the creative asset that
	// are detected by Campaign Manager. Feature dependencies are features that a
	// browser must be able to support in order to render your HTML5 creative
	// correctly. This is a read-only, auto-generated field.
	//
	// Possible values:
	//   "CSS_FONT_FACE"
	//   "CSS_BACKGROUND_SIZE"
	//   "CSS_BORDER_IMAGE"
	//   "CSS_BORDER_RADIUS"
	//   "CSS_BOX_SHADOW"
	//   "CSS_FLEX_BOX"
	//   "CSS_HSLA"
	//   "CSS_MULTIPLE_BGS"
	//   "CSS_OPACITY"
	//   "CSS_RGBA"
	//   "CSS_TEXT_SHADOW"
	//   "CSS_ANIMATIONS"
	//   "CSS_COLUMNS"
	//   "CSS_GENERATED_CONTENT"
	//   "CSS_GRADIENTS"
	//   "CSS_REFLECTIONS"
	//   "CSS_TRANSFORMS"
	//   "CSS_TRANSFORMS3D"
	//   "CSS_TRANSITIONS"
	//   "APPLICATION_CACHE"
	//   "CANVAS"
	//   "CANVAS_TEXT"
	//   "DRAG_AND_DROP"
	//   "HASH_CHANGE"
	//   "HISTORY"
	//   "AUDIO"
	//   "VIDEO"
	//   "INDEXED_DB"
	//   "INPUT_ATTR_AUTOCOMPLETE"
	//   "INPUT_ATTR_AUTOFOCUS"
	//   "INPUT_ATTR_LIST"
	//   "INPUT_ATTR_PLACEHOLDER"
	//   "INPUT_ATTR_MAX"
	//   "INPUT_ATTR_MIN"
	//   "INPUT_ATTR_MULTIPLE"
	//   "INPUT_ATTR_PATTERN"
	//   "INPUT_ATTR_REQUIRED"
	//   "INPUT_ATTR_STEP"
	//   "INPUT_TYPE_SEARCH"
	//   "INPUT_TYPE_TEL"
	//   "INPUT_TYPE_URL"
	//   "INPUT_TYPE_EMAIL"
	//   "INPUT_TYPE_DATETIME"
	//   "INPUT_TYPE_DATE"
	//   "INPUT_TYPE_MONTH"
	//   "INPUT_TYPE_WEEK"
	//   "INPUT_TYPE_TIME"
	//   "INPUT_TYPE_DATETIME_LOCAL"
	//   "INPUT_TYPE_NUMBER"
	//   "INPUT_TYPE_RANGE"
	//   "INPUT_TYPE_COLOR"
	//   "LOCAL_STORAGE"
	//   "POST_MESSAGE"
	//   "SESSION_STORAGE"
	//   "WEB_SOCKETS"
	//   "WEB_SQL_DATABASE"
	//   "WEB_WORKERS"
	//   "GEO_LOCATION"
	//   "INLINE_SVG"
	//   "SMIL"
	//   "SVG_HREF"
	//   "SVG_CLIP_PATHS"
	//   "TOUCH"
	//   "WEBGL"
	//   "SVG_FILTERS"
	//   "SVG_FE_IMAGE"
	DetectedFeatures []string `json:"detectedFeatures,omitempty"`
	// ExitCustomEvents: List of exit events configured for the asset. This is a
	// read-only, auto-generated field and only applicable to a rich media asset.
	ExitCustomEvents []*CreativeCustomEvent `json:"exitCustomEvents,omitempty"`
	// Id: Numeric ID of the asset. This is a read-only, auto-generated field.
	Id int64 `json:"id,omitempty,string"`
	// IdDimensionValue: Dimension value for the numeric ID of the asset. This is a
	// read-only, auto-generated field.
	IdDimensionValue *DimensionValue `json:"idDimensionValue,omitempty"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "dfareporting#creativeAssetMetadata".
	Kind string `json:"kind,omitempty"`
	// RichMedia: True if the uploaded asset is a rich media asset. This is a
	// read-only, auto-generated field.
	RichMedia bool `json:"richMedia,omitempty"`
	// TimerCustomEvents: List of timer events configured for the asset. This is a
	// read-only, auto-generated field and only applicable to a rich media asset.
	TimerCustomEvents []*CreativeCustomEvent `json:"timerCustomEvents,omitempty"`
	// WarnedValidationRules: Rules validated during code generation that generated
	// a warning. This is a read-only, auto-generated field. Possible values are: -
	// "ADMOB_REFERENCED" - "ASSET_FORMAT_UNSUPPORTED_DCM" - "ASSET_INVALID" -
	// "CLICK_TAG_HARD_CODED" - "CLICK_TAG_INVALID" - "CLICK_TAG_IN_GWD" -
	// "CLICK_TAG_MISSING" - "CLICK_TAG_MORE_THAN_ONE" - "CLICK_TAG_NON_TOP_LEVEL"
	// - "COMPONENT_UNSUPPORTED_DCM" - "ENABLER_UNSUPPORTED_METHOD_DCM" -
	// "EXTERNAL_FILE_REFERENCED" - "FILE_DETAIL_EMPTY" - "FILE_TYPE_INVALID" -
	// "GWD_PROPERTIES_INVALID" - "HTML5_FEATURE_UNSUPPORTED" -
	// "LINKED_FILE_NOT_FOUND" - "MAX_FLASH_VERSION_11" - "MRAID_REFERENCED" -
	// "NOT_SSL_COMPLIANT" - "ORPHANED_ASSET" - "PRIMARY_HTML_MISSING" -
	// "SVG_INVALID" - "ZIP_INVALID"
	//
	// Possible values:
	//   "CLICK_TAG_NON_TOP_LEVEL"
	//   "CLICK_TAG_MISSING"
	//   "CLICK_TAG_MORE_THAN_ONE"
	//   "CLICK_TAG_INVALID"
	//   "ORPHANED_ASSET"
	//   "PRIMARY_HTML_MISSING"
	//   "EXTERNAL_FILE_REFERENCED"
	//   "MRAID_REFERENCED"
	//   "ADMOB_REFERENCED"
	//   "FILE_TYPE_INVALID"
	//   "ZIP_INVALID"
	//   "LINKED_FILE_NOT_FOUND"
	//   "MAX_FLASH_VERSION_11"
	//   "NOT_SSL_COMPLIANT"
	//   "FILE_DETAIL_EMPTY"
	//   "ASSET_INVALID"
	//   "GWD_PROPERTIES_INVALID"
	//   "ENABLER_UNSUPPORTED_METHOD_DCM"
	//   "ASSET_FORMAT_UNSUPPORTED_DCM"
	//   "COMPONENT_UNSUPPORTED_DCM"
	//   "HTML5_FEATURE_UNSUPPORTED"
	//   "CLICK_TAG_IN_GWD"
	//   "CLICK_TAG_HARD_CODED"
	//   "SVG_INVALID"
	//   "CLICK_TAG_IN_RICH_MEDIA"
	//   "MISSING_ENABLER_REFERENCE"
	WarnedValidationRules []string `json:"warnedValidationRules,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssetIdentifier") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssetIdentifier") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreativeAssetMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CreativeAssetMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreativeClickThroughUrl: Click-through URL
type CreativeClickThroughUrl struct {
	// ComputedClickThroughUrl: Read-only convenience field representing the actual
	// URL that will be used for this click-through. The URL is computed as
	// follows: - If landingPageId is specified then that landing page's URL is
	// assigned to this field. - Otherwise, the customClickThroughUrl is assigned
	// to this field.
	ComputedClickThroughUrl string `json:"computedClickThroughUrl,omitempty"`
	// CustomClickThroughUrl: Custom click-through URL. Applicable if the
	// landingPageId field is left unset.
	CustomClickThroughUrl string `json:"customClickThroughUrl,omitempty"`
	// LandingPageId: ID of the landing page for the click-through URL.
	LandingPageId int64 `json:"landingPageId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ComputedClickThroughUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComputedClickThroughUrl") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreativeClickThroughUrl) MarshalJSON() ([]byte, error) {
	type NoMethod CreativeClickThroughUrl
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreativeCustomEvent: Creative Custom Event.
type CreativeCustomEvent struct {
	// AdvertiserCustomEventId: Unique ID of this event used by Reporting and Data
	// Transfer. This is a read-only field.
	AdvertiserCustomEventId int64 `json:"advertiserCustomEventId,omitempty,string"`
	// AdvertiserCustomEventName: User-entered name for the event.
	AdvertiserCustomEventName string `json:"advertiserCustomEventName,omitempty"`
	// AdvertiserCustomEventType: Type of the event. This is a read-only field.
	//
	// Possible values:
	//   "ADVERTISER_EVENT_TIMER"
	//   "ADVERTISER_EVENT_EXIT"
	//   "ADVERTISER_EVENT_COUNTER"
	AdvertiserCustomEventType string `json:"advertiserCustomEventType,omitempty"`
	// ArtworkLabel: Artwork label column, used to link events in Campaign Manager
	// back to events in Studio. This is a required field and should not be
	// modified after insertion.
	ArtworkLabel string `json:"artworkLabel,omitempty"`
	// ArtworkType: Artwork type used by the creative.This is a read-only field.
	//
	// Possible values:
	//   "ARTWORK_TYPE_FLASH"
	//   "ARTWORK_TYPE_HTML5"
	//   "ARTWORK_TYPE_MIXED"
	//   "ARTWORK_TYPE_IMAGE"
	ArtworkType string `json:"artworkType,omitempty"`
	// ExitClickThroughUrl: Exit click-through URL for the event. This field is
	// used only for exit events.
	ExitClickThroughUrl *CreativeClickThroughUrl `json:"exitClickThroughUrl,omitempty"`
	// Id: ID of this event. This is a required field and should not be modified
	// after insertion.
	Id int64 `json:"id,omitempty,string"`
	// PopupWindowProperties: Properties for rich media popup windows. This field
	// is used only for exit events.
	PopupWindowProperties *PopupWindowProperties `json:"popupWindowProperties,omitempty"`
	// TargetType: Target type used by the event.
	//
	// Possible values:
	//   "TARGET_BLANK"
	//   "TARGET_TOP"
	//   "TARGET_SELF"
	//   "TARGET_PARENT"
	//   "TARGET_POPUP"
	TargetType string `json:"targetType,omitempty"`
	// VideoReportingId: Video reporting ID, used to differentiate multiple videos
	// in a single creative. This is a read-only field.
	VideoReportingId string `json:"videoReportingId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvertiserCustomEventId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvertiserCustomEventId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreativeCustomEvent) MarshalJSON() ([]byte, error) {
	type NoMethod CreativeCustomEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DimensionValue: Represents a DimensionValue resource.
type DimensionValue struct {
	// DimensionName: The name of the dimension.
	DimensionName string `json:"dimensionName,omitempty"`
	// Etag: The eTag of this response for caching purposes.
	Etag string `json:"etag,omitempty"`
	// Id: The ID associated with the value if available.
	Id string `json:"id,omitempty"`
	// Kind: The kind of resource this is, in this case
	// dfareporting#dimensionValue.
	Kind string `json:"kind,omitempty"`
	// MatchType: Determines how the 'value' field is matched when filtering. If
	// not specified, defaults to EXACT. If set to WILDCARD_EXPRESSION, '*' is
	// allowed as a placeholder for variable length character sequences, and it can
	// be escaped with a backslash. Note, only paid search dimensions
	// ('dfa:paidSearch*') allow a matchType other than EXACT.
	//
	// Possible values:
	//   "EXACT"
	//   "BEGINS_WITH"
	//   "CONTAINS"
	//   "WILDCARD_EXPRESSION"
	MatchType string `json:"matchType,omitempty"`
	// Value: The value of the dimension.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DimensionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DimensionName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DimensionValue) MarshalJSON() ([]byte, error) {
	type NoMethod DimensionValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OffsetPosition: Offset Position.
type OffsetPosition struct {
	// Left: Offset distance from left side of an asset or a window.
	Left int64 `json:"left,omitempty"`
	// Top: Offset distance from top side of an asset or a window.
	Top int64 `json:"top,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Left") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Left") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OffsetPosition) MarshalJSON() ([]byte, error) {
	type NoMethod OffsetPosition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PopupWindowProperties: Popup Window Properties.
type PopupWindowProperties struct {
	// Dimension: Popup dimension for a creative. This is a read-only field.
	// Applicable to the following creative types: all RICH_MEDIA and all VPAID
	Dimension *Size `json:"dimension,omitempty"`
	// Offset: Upper-left corner coordinates of the popup window. Applicable if
	// positionType is COORDINATES.
	Offset *OffsetPosition `json:"offset,omitempty"`
	// PositionType: Popup window position either centered or at specific
	// coordinate.
	//
	// Possible values:
	//   "CENTER"
	//   "COORDINATES"
	PositionType string `json:"positionType,omitempty"`
	// ShowAddressBar: Whether to display the browser address bar.
	ShowAddressBar bool `json:"showAddressBar,omitempty"`
	// ShowMenuBar: Whether to display the browser menu bar.
	ShowMenuBar bool `json:"showMenuBar,omitempty"`
	// ShowScrollBar: Whether to display the browser scroll bar.
	ShowScrollBar bool `json:"showScrollBar,omitempty"`
	// ShowStatusBar: Whether to display the browser status bar.
	ShowStatusBar bool `json:"showStatusBar,omitempty"`
	// ShowToolBar: Whether to display the browser tool bar.
	ShowToolBar bool `json:"showToolBar,omitempty"`
	// Title: Title of popup window.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimension") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimension") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PopupWindowProperties) MarshalJSON() ([]byte, error) {
	type NoMethod PopupWindowProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Size: Represents the dimensions of ads, placements, creatives, or creative
// assets.
type Size struct {
	// Height: Height of this size. Acceptable values are 0 to 32767, inclusive.
	Height int64 `json:"height,omitempty"`
	// Iab: IAB standard size. This is a read-only, auto-generated field.
	Iab bool `json:"iab,omitempty"`
	// Id: ID of this size. This is a read-only, auto-generated field.
	Id int64 `json:"id,omitempty,string"`
	// Kind: Identifies what kind of resource this is. Value: the fixed string
	// "dfareporting#size".
	Kind string `json:"kind,omitempty"`
	// Width: Width of this size. Acceptable values are 0 to 32767, inclusive.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Size) MarshalJSON() ([]byte, error) {
	type NoMethod Size
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type MediaUploadCall struct {
	s                     *Service
	profileId             int64
	advertiserId          int64
	creativeassetmetadata *CreativeAssetMetadata
	urlParams_            gensupport.URLParams
	mediaInfo_            *gensupport.MediaInfo
	ctx_                  context.Context
	header_               http.Header
}

// Upload: Inserts a new creative asset.
//
// - advertiserId: Advertiser ID of this creative. This is a required field.
// - profileId: User profile ID associated with this request.
func (r *MediaService) Upload(profileId int64, advertiserId int64, creativeassetmetadata *CreativeAssetMetadata) *MediaUploadCall {
	c := &MediaUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.profileId = profileId
	c.advertiserId = advertiserId
	c.creativeassetmetadata = creativeassetmetadata
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk size
// may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the upload
// request will be determined by sniffing the contents of r, unless a
// MediaOption generated by googleapi.ContentType is supplied.
// At most one of Media and ResumableMedia may be set.
func (c *MediaUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *MediaUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be canceled
// with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType identifies the
// MIME media type of the upload, such as "image/png". If mediaType is "", it
// will be auto-detected. The provided ctx will supersede any context
// previously provided to the Context method.
func (c *MediaUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *MediaUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called after every
// chunk. It should be a low-latency function in order to not slow down the
// upload operation. This should only be called when using ResumableMedia (as
// opposed to Media).
func (c *MediaUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *MediaUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MediaUploadCall) Fields(s ...googleapi.Field) *MediaUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *MediaUploadCall) Context(ctx context.Context) *MediaUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MediaUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MediaUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.creativeassetmetadata)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "userprofiles/{+profileId}/creativeAssets/{+advertiserId}/creativeAssets")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/dfareporting/v3.5/userprofiles/{+profileId}/creativeAssets/{+advertiserId}/creativeAssets")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	newBody, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, newBody)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"profileId":    strconv.FormatInt(c.profileId, 10),
		"advertiserId": strconv.FormatInt(c.advertiserId, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dfareporting.media.upload", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dfareporting.media.upload" call.
// Any non-2xx status code is an error. Response headers are in either
// *CreativeAssetMetadata.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *MediaUploadCall) Do(opts ...googleapi.CallOption) (*CreativeAssetMetadata, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &CreativeAssetMetadata{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dfareporting.media.upload", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
