package rules

import (
	"github.com/zricethezav/gitleaks/v8/cmd/generate/config/utils"
	"github.com/zricethezav/gitleaks/v8/cmd/generate/secrets"
	"github.com/zricethezav/gitleaks/v8/config"
)

func CoinbaseAccessToken() *config.Rule {
	// define rule
	r := config.Rule{
		RuleID:      "coinbase-access-token",
		Description: "Detected a Coinbase Access Token, posing a risk of unauthorized access to cryptocurrency accounts and financial transactions.",
		Regex: utils.GenerateSemiGenericRegex([]string{"coinbase"},
			utils.AlphaNumericExtendedShort("64"), true),
		Keywords: []string{
			"coinbase",
		},
	}

	// validate
	tps := []string{
		utils.GenerateSampleSecret("coinbase",
			secrets.NewSecret(utils.AlphaNumericExtendedShort("64"))),
	}
	return utils.Validate(r, tps, nil)
}
