package opcodes

import (
	"github.com/git-town/git-town/v17/internal/git/gitdomain"
	"github.com/git-town/git-town/v17/internal/vm/shared"
)

// LineageParentSetToGrandParent sets the parent branch of the given branch to the grandparent of the given branch.
type LineageParentSetToGrandParent struct {
	Branch                  gitdomain.LocalBranchName
	undeclaredOpcodeMethods `exhaustruct:"optional"`
}

func (self *LineageParentSetToGrandParent) Run(args shared.RunArgs) error {
	parent, hasParent := args.Config.Value.NormalConfig.Lineage.Parent(self.Branch).Get()
	if !hasParent {
		return nil
	}
	if grandParent, hasGrandParent := args.Config.Value.NormalConfig.Lineage.Parent(parent).Get(); hasGrandParent {
		args.PrependOpcodes(&LineageParentSet{
			Branch: self.Branch,
			Parent: grandParent,
		})
	} else {
		args.PrependOpcodes(&LineageParentRemove{
			Branch: self.Branch,
		})
	}
	return nil
}
