//go:build android

package app

import "path/filepath"

// storagePath returns the location of the settings storage
func (p *preferences) storagePath() string {
	// we have no global storage, use app global instead - rootConfigDir looks up in app_mobile_and.go
	return filepath.Join(p.app.storageRoot(), "preferences.json")
}

// storageRoot returns the location of the app storage
func (a *fyneApp) storageRoot() string {
	return rootConfigDir() // we are in a sandbox, so no app ID added to this path
}

func (p *preferences) watch() {
	// no-op on mobile
}
