// Code generated by ifacemaker; DO NOT EDIT.

package awsapi

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/service/outposts"
	. "github.com/aws/aws-sdk-go-v2/service/outposts"
)

// Outposts provides an interface to the AWS Outposts service.
type Outposts interface {
	// Options returns a copy of the client configuration.
	//
	// Callers SHOULD NOT perform mutations on any inner structures within client
	// config. Config overrides should instead be made on a per-operation basis through
	// functional options.
	Options() outposts.Options
	// Cancels the capacity task.
	CancelCapacityTask(ctx context.Context, params *outposts.CancelCapacityTaskInput, optFns ...func(*Options)) (*outposts.CancelCapacityTaskOutput, error)
	// Cancels the specified order for an Outpost.
	CancelOrder(ctx context.Context, params *outposts.CancelOrderInput, optFns ...func(*Options)) (*outposts.CancelOrderOutput, error)
	// Creates an order for an Outpost.
	CreateOrder(ctx context.Context, params *outposts.CreateOrderInput, optFns ...func(*Options)) (*outposts.CreateOrderOutput, error)
	// Creates an Outpost.
	//
	// You can specify either an Availability one or an AZ ID.
	CreateOutpost(ctx context.Context, params *outposts.CreateOutpostInput, optFns ...func(*Options)) (*outposts.CreateOutpostOutput, error)
	// Creates a site for an Outpost.
	CreateSite(ctx context.Context, params *outposts.CreateSiteInput, optFns ...func(*Options)) (*outposts.CreateSiteOutput, error)
	// Deletes the specified Outpost.
	DeleteOutpost(ctx context.Context, params *outposts.DeleteOutpostInput, optFns ...func(*Options)) (*outposts.DeleteOutpostOutput, error)
	// Deletes the specified site.
	DeleteSite(ctx context.Context, params *outposts.DeleteSiteInput, optFns ...func(*Options)) (*outposts.DeleteSiteOutput, error)
	// Gets details of the specified capacity task.
	GetCapacityTask(ctx context.Context, params *outposts.GetCapacityTaskInput, optFns ...func(*Options)) (*outposts.GetCapacityTaskOutput, error)
	// Gets information about the specified catalog item.
	GetCatalogItem(ctx context.Context, params *outposts.GetCatalogItemInput, optFns ...func(*Options)) (*outposts.GetCatalogItemOutput, error)
	//	Amazon Web Services uses this action to install Outpost servers.
	//
	// Gets information about the specified connection.
	//
	// Use CloudTrail to monitor this action or Amazon Web Services managed policy for
	// Amazon Web Services Outposts to secure it. For more information, see [Amazon Web Services managed policies for Amazon Web Services Outposts]and [Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail] in
	// the Amazon Web Services Outposts User Guide.
	//
	// [Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail]: https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html
	// [Amazon Web Services managed policies for Amazon Web Services Outposts]: https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html
	GetConnection(ctx context.Context, params *outposts.GetConnectionInput, optFns ...func(*Options)) (*outposts.GetConnectionOutput, error)
	// Gets information about the specified order.
	GetOrder(ctx context.Context, params *outposts.GetOrderInput, optFns ...func(*Options)) (*outposts.GetOrderOutput, error)
	// Gets information about the specified Outpost.
	GetOutpost(ctx context.Context, params *outposts.GetOutpostInput, optFns ...func(*Options)) (*outposts.GetOutpostOutput, error)
	// Gets current and historical billing information about the specified Outpost.
	GetOutpostBillingInformation(ctx context.Context, params *outposts.GetOutpostBillingInformationInput, optFns ...func(*Options)) (*outposts.GetOutpostBillingInformationOutput, error)
	// Gets the instance types for the specified Outpost.
	GetOutpostInstanceTypes(ctx context.Context, params *outposts.GetOutpostInstanceTypesInput, optFns ...func(*Options)) (*outposts.GetOutpostInstanceTypesOutput, error)
	// Gets the instance types that an Outpost can support in InstanceTypeCapacity .
	// This will generally include instance types that are not currently configured and
	// therefore cannot be launched with the current Outpost capacity configuration.
	GetOutpostSupportedInstanceTypes(ctx context.Context, params *outposts.GetOutpostSupportedInstanceTypesInput, optFns ...func(*Options)) (*outposts.GetOutpostSupportedInstanceTypesOutput, error)
	// Gets information about the specified Outpost site.
	GetSite(ctx context.Context, params *outposts.GetSiteInput, optFns ...func(*Options)) (*outposts.GetSiteOutput, error)
	// Gets the site address of the specified site.
	GetSiteAddress(ctx context.Context, params *outposts.GetSiteAddressInput, optFns ...func(*Options)) (*outposts.GetSiteAddressOutput, error)
	// A list of Amazon EC2 instances, belonging to all accounts, running on the
	// specified Outpost. Does not include Amazon EBS or Amazon S3 instances.
	ListAssetInstances(ctx context.Context, params *outposts.ListAssetInstancesInput, optFns ...func(*Options)) (*outposts.ListAssetInstancesOutput, error)
	// Lists the hardware assets for the specified Outpost.
	//
	// Use filters to return specific results. If you specify multiple filters, the
	// results include only the resources that match all of the specified filters. For
	// a filter where you can specify multiple values, the results include items that
	// match any of the values that you specify for the filter.
	ListAssets(ctx context.Context, params *outposts.ListAssetsInput, optFns ...func(*Options)) (*outposts.ListAssetsOutput, error)
	// A list of Amazon EC2 instances running on the Outpost and belonging to the
	// account that initiated the capacity task. Use this list to specify the instances
	// you cannot stop to free up capacity to run the capacity task.
	ListBlockingInstancesForCapacityTask(ctx context.Context, params *outposts.ListBlockingInstancesForCapacityTaskInput, optFns ...func(*Options)) (*outposts.ListBlockingInstancesForCapacityTaskOutput, error)
	// Lists the capacity tasks for your Amazon Web Services account.
	//
	// Use filters to return specific results. If you specify multiple filters, the
	// results include only the resources that match all of the specified filters. For
	// a filter where you can specify multiple values, the results include items that
	// match any of the values that you specify for the filter.
	ListCapacityTasks(ctx context.Context, params *outposts.ListCapacityTasksInput, optFns ...func(*Options)) (*outposts.ListCapacityTasksOutput, error)
	// Lists the items in the catalog.
	//
	// Use filters to return specific results. If you specify multiple filters, the
	// results include only the resources that match all of the specified filters. For
	// a filter where you can specify multiple values, the results include items that
	// match any of the values that you specify for the filter.
	ListCatalogItems(ctx context.Context, params *outposts.ListCatalogItemsInput, optFns ...func(*Options)) (*outposts.ListCatalogItemsOutput, error)
	// Lists the Outpost orders for your Amazon Web Services account.
	ListOrders(ctx context.Context, params *outposts.ListOrdersInput, optFns ...func(*Options)) (*outposts.ListOrdersOutput, error)
	// Lists the Outposts for your Amazon Web Services account.
	//
	// Use filters to return specific results. If you specify multiple filters, the
	// results include only the resources that match all of the specified filters. For
	// a filter where you can specify multiple values, the results include items that
	// match any of the values that you specify for the filter.
	ListOutposts(ctx context.Context, params *outposts.ListOutpostsInput, optFns ...func(*Options)) (*outposts.ListOutpostsOutput, error)
	// Lists the Outpost sites for your Amazon Web Services account. Use filters to
	// return specific results.
	//
	// Use filters to return specific results. If you specify multiple filters, the
	// results include only the resources that match all of the specified filters. For
	// a filter where you can specify multiple values, the results include items that
	// match any of the values that you specify for the filter.
	ListSites(ctx context.Context, params *outposts.ListSitesInput, optFns ...func(*Options)) (*outposts.ListSitesOutput, error)
	// Lists the tags for the specified resource.
	ListTagsForResource(ctx context.Context, params *outposts.ListTagsForResourceInput, optFns ...func(*Options)) (*outposts.ListTagsForResourceOutput, error)
	// Starts the specified capacity task. You can have one active capacity task for
	// each order and each Outpost.
	StartCapacityTask(ctx context.Context, params *outposts.StartCapacityTaskInput, optFns ...func(*Options)) (*outposts.StartCapacityTaskOutput, error)
	//	Amazon Web Services uses this action to install Outpost servers.
	//
	// Starts the connection required for Outpost server installation.
	//
	// Use CloudTrail to monitor this action or Amazon Web Services managed policy for
	// Amazon Web Services Outposts to secure it. For more information, see [Amazon Web Services managed policies for Amazon Web Services Outposts]and [Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail] in
	// the Amazon Web Services Outposts User Guide.
	//
	// [Logging Amazon Web Services Outposts API calls with Amazon Web Services CloudTrail]: https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html
	// [Amazon Web Services managed policies for Amazon Web Services Outposts]: https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html
	StartConnection(ctx context.Context, params *outposts.StartConnectionInput, optFns ...func(*Options)) (*outposts.StartConnectionOutput, error)
	// Adds tags to the specified resource.
	TagResource(ctx context.Context, params *outposts.TagResourceInput, optFns ...func(*Options)) (*outposts.TagResourceOutput, error)
	// Removes tags from the specified resource.
	UntagResource(ctx context.Context, params *outposts.UntagResourceInput, optFns ...func(*Options)) (*outposts.UntagResourceOutput, error)
	// Updates an Outpost.
	UpdateOutpost(ctx context.Context, params *outposts.UpdateOutpostInput, optFns ...func(*Options)) (*outposts.UpdateOutpostOutput, error)
	// Updates the specified site.
	UpdateSite(ctx context.Context, params *outposts.UpdateSiteInput, optFns ...func(*Options)) (*outposts.UpdateSiteOutput, error)
	// Updates the address of the specified site.
	//
	// You can't update a site address if there is an order in progress. You must wait
	// for the order to complete or cancel the order.
	//
	// You can update the operating address before you place an order at the site, or
	// after all Outposts that belong to the site have been deactivated.
	UpdateSiteAddress(ctx context.Context, params *outposts.UpdateSiteAddressInput, optFns ...func(*Options)) (*outposts.UpdateSiteAddressOutput, error)
	// Update the physical and logistical details for a rack at a site. For more
	// information about hardware requirements for racks, see [Network readiness checklist]in the Amazon Web
	// Services Outposts User Guide.
	//
	// To update a rack at a site with an order of IN_PROGRESS , you must wait for the
	// order to complete or cancel the order.
	//
	// [Network readiness checklist]: https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist
	UpdateSiteRackPhysicalProperties(ctx context.Context, params *outposts.UpdateSiteRackPhysicalPropertiesInput, optFns ...func(*Options)) (*outposts.UpdateSiteRackPhysicalPropertiesOutput, error)
}

