// / Generated by `ec2geninfo`

package instance

var InstanceTypesMap = map[string]InstanceInfo{}

func init() {
	for _, instance := range InstanceTypes {
		InstanceTypesMap[instance.InstanceType] = instance
	}
}

type InstanceInfo struct { //nolint
	InstanceType             string
	InstanceStorageSupported bool
	EFASupported             bool
	NvidiaGPUSupported       bool
	NvidiaGPUType            string
	NeuronSupported          bool
	NeuronDeviceType         string
	CBRSupported             bool
	CPUArch                  string
}

var InstanceTypes = []InstanceInfo{
	{
		InstanceType:             "c5.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5.18xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5.9xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5a.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5a.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5a.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5ad.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5ad.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5ad.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5ad.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5ad.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5ad.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5ad.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5ad.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5d.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5d.18xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5d.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5d.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5d.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5d.9xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5d.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5d.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5n.18xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5n.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5n.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5n.9xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5n.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c5n.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gd.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gd.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gd.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gd.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gd.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gd.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gd.medium",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gd.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gn.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gn.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gn.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gn.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gn.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gn.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gn.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6gn.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c6i.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6i.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6i.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6i.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6i.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6i.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6i.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6i.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6i.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6id.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6id.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6id.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6id.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6id.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6id.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6id.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6id.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6id.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6in.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6in.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6in.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6in.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6in.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6in.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6in.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6in.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c6in.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gd.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gd.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gd.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gd.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gd.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gd.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gd.medium",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gd.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gn.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gn.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gn.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gn.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gn.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gn.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gn.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7gn.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c7i-flex.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i-flex.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i-flex.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i-flex.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i-flex.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i-flex.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i-flex.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c7i.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "c8g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c8g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c8g.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c8g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c8g.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c8g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c8g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c8g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c8g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "c8g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "d3.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "d3.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "d3.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "d3.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "d3en.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "d3en.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "d3en.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "d3en.6xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "d3en.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "d3en.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "dl1.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "dl2q.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "f1.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "f1.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "f1.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "f2.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "f2.48xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "f2.6xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4ad.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4ad.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4ad.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4ad.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4ad.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4dn.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4dn.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4dn.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4dn.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4dn.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g4dn.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g5.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "A10G",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g5.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "A10G",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g5.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "A10G",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g5.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "A10G",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g5.48xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "A10G",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g5.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "A10G",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g5.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "A10G",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g5.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "A10G",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g5g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4g",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "g5g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4g",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "g5g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4g",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "g5g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4g",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "g5g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "T4g",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "g6.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6.48xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6e.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L40S",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6e.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L40S",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6e.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L40S",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6e.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L40S",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6e.48xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L40S",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6e.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L40S",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6e.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L40S",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "g6e.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L40S",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "gr6.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "gr6.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "L4",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "h1.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "h1.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "h1.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "h1.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "hpc6a.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "hpc6id.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "hpc7a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "hpc7a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "hpc7a.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "hpc7a.96xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "hpc7g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "hpc7g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "hpc7g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i3.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3en.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3en.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3en.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3en.3xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3en.6xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3en.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i3en.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i4g.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i4g.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i4g.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i4g.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i4g.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i4g.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i4i.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i4i.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i4i.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i4i.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i4i.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i4i.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i4i.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i4i.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i4i.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i7ie.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i7ie.18xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i7ie.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i7ie.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i7ie.3xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i7ie.48xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i7ie.6xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i7ie.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i7ie.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "i8g.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i8g.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i8g.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i8g.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i8g.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i8g.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i8g.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "i8g.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "im4gn.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "im4gn.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "im4gn.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "im4gn.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "im4gn.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "im4gn.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "inf1.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Inferentia",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "inf1.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Inferentia",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "inf1.6xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Inferentia",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "inf1.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Inferentia",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "inf2.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Inferentia2",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "inf2.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Inferentia2",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "inf2.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Inferentia2",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "inf2.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Inferentia2",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "is4gen.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "is4gen.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "is4gen.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "is4gen.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "is4gen.medium",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "is4gen.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m5.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5a.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5a.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5a.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5ad.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5ad.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5ad.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5ad.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5ad.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5ad.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5ad.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5ad.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5d.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5d.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5d.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5d.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5d.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5d.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5d.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5d.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5dn.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5dn.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5dn.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5dn.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5dn.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5dn.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5dn.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5dn.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5n.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5n.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5n.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5n.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5n.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5n.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5n.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5n.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5zn.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5zn.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5zn.3xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5zn.6xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5zn.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m5zn.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6gd.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6gd.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6gd.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6gd.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6gd.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6gd.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6gd.medium",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6gd.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m6i.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6i.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6i.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6i.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6i.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6i.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6i.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6i.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6i.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6id.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6id.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6id.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6id.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6id.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6id.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6id.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6id.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6id.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6idn.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6idn.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6idn.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6idn.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6idn.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6idn.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6idn.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6idn.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6idn.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6in.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6in.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6in.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6in.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6in.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6in.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6in.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6in.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m6in.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7gd.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7gd.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7gd.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7gd.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7gd.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7gd.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7gd.medium",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7gd.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m7i-flex.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i-flex.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i-flex.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i-flex.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i-flex.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i-flex.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i-flex.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m7i.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "m8g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m8g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m8g.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m8g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m8g.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m8g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m8g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m8g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m8g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "m8g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "p3.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "V100",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "p3.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "V100",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "p3.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "V100",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "p3dn.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "V100",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "p4d.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "A100",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             true,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "p5.48xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "H100",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             true,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "p5e.48xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "H200",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             true,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "p5en.48xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       true,
		NvidiaGPUType:            "H200",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             true,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5a.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5a.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5a.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5ad.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5ad.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5ad.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5ad.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5ad.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5ad.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5ad.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5ad.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5b.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5b.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5b.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5b.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5b.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5b.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5b.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5b.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5d.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5d.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5d.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5d.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5d.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5d.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5d.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5d.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5dn.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5dn.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5dn.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5dn.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5dn.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5dn.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5dn.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5dn.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5n.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5n.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5n.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5n.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5n.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5n.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5n.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r5n.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6gd.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6gd.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6gd.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6gd.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6gd.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6gd.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6gd.medium",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6gd.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r6i.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6i.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6i.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6i.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6i.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6i.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6i.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6i.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6i.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6id.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6id.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6id.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6id.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6id.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6id.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6id.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6id.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6id.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6idn.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6idn.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6idn.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6idn.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6idn.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6idn.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6idn.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6idn.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6idn.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6in.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6in.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6in.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6in.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6in.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6in.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6in.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6in.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r6in.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7gd.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7gd.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7gd.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7gd.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7gd.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7gd.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7gd.medium",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7gd.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r7i.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7i.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7i.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7i.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7i.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7i.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7i.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7i.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7i.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7iz.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7iz.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7iz.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7iz.32xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7iz.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7iz.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7iz.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r7iz.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "r8g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r8g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r8g.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r8g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r8g.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r8g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r8g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r8g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r8g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "r8g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "t2.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t2.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t2.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t2.micro",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t2.nano",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t2.small",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t2.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3.micro",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3.nano",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3.small",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3a.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3a.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3a.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3a.micro",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3a.nano",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3a.small",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t3a.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "t4g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "t4g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "t4g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "t4g.micro",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "t4g.nano",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "t4g.small",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "t4g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "trn1.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Trainium",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "trn1.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Trainium",
		CBRSupported:             true,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "trn1n.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Trainium",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "trn2.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          true,
		NeuronDeviceType:         "Trainium2",
		CBRSupported:             true,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u-12tb1.112xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u-18tb1.112xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u-24tb1.112xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u-3tb1.56xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u-6tb1.112xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u-6tb1.56xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u-9tb1.112xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u7i-12tb.224xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u7i-6tb.112xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u7i-8tb.112xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u7in-16tb.224xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u7in-24tb.224xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "u7in-32tb.224xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "vt1.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "vt1.3xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "vt1.6xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x1.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x1.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x1e.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x1e.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x1e.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x1e.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x1e.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x1e.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2gd.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x2gd.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x2gd.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x2gd.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x2gd.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x2gd.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x2gd.medium",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x2gd.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x2idn.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2idn.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2idn.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iedn.16xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iedn.24xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iedn.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iedn.32xlarge",
		InstanceStorageSupported: true,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iedn.4xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iedn.8xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iedn.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iezn.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iezn.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iezn.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iezn.6xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x2iezn.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "x8g.12xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x8g.16xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x8g.24xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x8g.2xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x8g.48xlarge",
		InstanceStorageSupported: false,
		EFASupported:             true,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x8g.4xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x8g.8xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x8g.large",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x8g.medium",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "x8g.xlarge",
		InstanceStorageSupported: false,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "arm64",
	},
	{
		InstanceType:             "z1d.12xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "z1d.2xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "z1d.3xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "z1d.6xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "z1d.large",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
	{
		InstanceType:             "z1d.xlarge",
		InstanceStorageSupported: true,
		EFASupported:             false,
		NvidiaGPUSupported:       false,
		NvidiaGPUType:            "",
		NeuronSupported:          false,
		NeuronDeviceType:         "",
		CBRSupported:             false,
		CPUArch:                  "x86-64",
	},
}
