# Table of contents

* [Introduction to DNSControl](index.md)

## Getting Started

* [Overview](getting-started/getting-started.md)
* [Examples](getting-started/examples.md)
* [Migrating zones to DNSControl](getting-started/migrating.md)
* [TypeScript autocomplete and type checking](getting-started/typescript.md)

## Language Reference

* [JavaScript DSL](language-reference/js.md)
* Top Level Functions
  * [D](language-reference/top-level-functions/D.md)
  * [DEFAULTS](language-reference/top-level-functions/DEFAULTS.md)
  * [DOMAIN_ELSEWHERE](language-reference/top-level-functions/DOMAIN_ELSEWHERE.md)
  * [DOMAIN_ELSEWHERE_AUTO](language-reference/top-level-functions/DOMAIN_ELSEWHERE_AUTO.md)
  * [D_EXTEND](language-reference/top-level-functions/D_EXTEND.md)
  * [FETCH](language-reference/top-level-functions/FETCH.md)
  * [HASH](language-reference/top-level-functions/HASH.md)
  * [IP](language-reference/top-level-functions/IP.md)
  * [NewDnsProvider](language-reference/top-level-functions/NewDnsProvider.md)
  * [NewRegistrar](language-reference/top-level-functions/NewRegistrar.md)
  * [PANIC](language-reference/top-level-functions/PANIC.md)
  * [REV](language-reference/top-level-functions/REV.md)
  * [REVCOMPAT](language-reference/top-level-functions/REVCOMPAT.md)
  * [getConfiguredDomains](language-reference/top-level-functions/getConfiguredDomains.md)
  * [require](language-reference/top-level-functions/require.md)
  * [require_glob](language-reference/top-level-functions/require_glob.md)
* Domain Modifiers
    * [A](language-reference/domain-modifiers/A.md)
    * [AAAA](language-reference/domain-modifiers/AAAA.md)
    * [ALIAS](language-reference/domain-modifiers/ALIAS.md)
    * [AUTODNSSEC_OFF](language-reference/domain-modifiers/AUTODNSSEC_OFF.md)
    * [AUTODNSSEC_ON](language-reference/domain-modifiers/AUTODNSSEC_ON.md)
    * [CAA](language-reference/domain-modifiers/CAA.md)
    * [CAA_BUILDER](language-reference/domain-modifiers/CAA_BUILDER.md)
    * [CNAME](language-reference/domain-modifiers/CNAME.md)
    * [DHCID](language-reference/domain-modifiers/DHCID.md)
    * [DNAME](language-reference/domain-modifiers/DNAME.md)
    * [DNSKEY](language-reference/domain-modifiers/DNSKEY.md)
    * [DISABLE_IGNORE_SAFETY_CHECK](language-reference/domain-modifiers/DISABLE_IGNORE_SAFETY_CHECK.md)
    * [DKIM_BUILDER](language-reference/domain-modifiers/DKIM_BUILDER.md)
    * [DMARC_BUILDER](language-reference/domain-modifiers/DMARC_BUILDER.md)
    * [DS](language-reference/domain-modifiers/DS.md)
    * [DefaultTTL](language-reference/domain-modifiers/DefaultTTL.md)
    * [DnsProvider](language-reference/domain-modifiers/DnsProvider.md)
    * [FRAME](language-reference/domain-modifiers/FRAME.md)
    * [HTTPS](language-reference/domain-modifiers/HTTPS.md)
    * [IGNORE](language-reference/domain-modifiers/IGNORE.md)
    * [IGNORE_NAME](language-reference/domain-modifiers/IGNORE_NAME.md)
    * [IGNORE_TARGET](language-reference/domain-modifiers/IGNORE_TARGET.md)
    * [IMPORT_TRANSFORM](language-reference/domain-modifiers/IMPORT_TRANSFORM.md)
    * [IMPORT_TRANSFORM_STRIP](language-reference/domain-modifiers/IMPORT_TRANSFORM_STRIP.md)
    * [INCLUDE](language-reference/domain-modifiers/INCLUDE.md)
    * [LOC](language-reference/domain-modifiers/LOC.md)
    * [LOC_BUILDER_DD](language-reference/domain-modifiers/LOC_BUILDER_DD.md)
    * [LOC_BUILDER_DMM_STR](language-reference/domain-modifiers/LOC_BUILDER_DMM_STR.md)
    * [LOC_BUILDER_DMS_STR](language-reference/domain-modifiers/LOC_BUILDER_DMS_STR.md)
    * [LOC_BUILDER_STR](language-reference/domain-modifiers/LOC_BUILDER_STR.md)
    * [M365_BUILDER](language-reference/domain-modifiers/M365_BUILDER.md)
    * [MX](language-reference/domain-modifiers/MX.md)
    * [NAMESERVER](language-reference/domain-modifiers/NAMESERVER.md)
    * [NAMESERVER_TTL](language-reference/domain-modifiers/NAMESERVER_TTL.md)
    * [NAPTR](language-reference/domain-modifiers/NAPTR.md)
    * [NO_PURGE](language-reference/domain-modifiers/NO_PURGE.md)
    * [NS](language-reference/domain-modifiers/NS.md)
    * [OPENPGPKEY](language-reference/domain-modifiers/OPENPGPKEY.md)
    * [PTR](language-reference/domain-modifiers/PTR.md)
    * [PURGE](language-reference/domain-modifiers/PURGE.md)
    * [SMIMEA](language-reference/domain-modifiers/SMIMEA.md)
    * [SOA](language-reference/domain-modifiers/SOA.md)
    * [SPF_BUILDER](language-reference/domain-modifiers/SPF_BUILDER.md)
    * [SRV](language-reference/domain-modifiers/SRV.md)
    * [SSHFP](language-reference/domain-modifiers/SSHFP.md)
    * [SVCB](language-reference/domain-modifiers/SVCB.md)
    * [TLSA](language-reference/domain-modifiers/TLSA.md)
    * [TXT](language-reference/domain-modifiers/TXT.md)
    * [URL](language-reference/domain-modifiers/URL.md)
    * [URL301](language-reference/domain-modifiers/URL301.md)
    * Service Provider specific
        * AdGuard Home
            * [ADGUARDHOME_A_PASSTHROUGH](language-reference/domain-modifiers/ADGUARDHOME_A_PASSTHROUGH.md)
            * [ADGUARDHOME_AAAA_PASSTHROUGH](language-reference/domain-modifiers/ADGUARDHOME_AAAA_PASSTHROUGH.md)
        * Akamai Edge Dns
            * [AKAMAICDN](language-reference/domain-modifiers/AKAMAICDN.md)
        * Amazon Route 53
            * [R53_ALIAS](language-reference/domain-modifiers/R53_ALIAS.md)
        * Azure DNS
            * [AZURE_ALIAS](language-reference/domain-modifiers/AZURE_ALIAS.md)
        * Cloudflare DNS
            * [CF_REDIRECT](language-reference/domain-modifiers/CF_REDIRECT.md)
            * [CF_SINGLE_REDIRECT](language-reference/domain-modifiers/CF_SINGLE_REDIRECT.md)
            * [CF_TEMP_REDIRECT](language-reference/domain-modifiers/CF_TEMP_REDIRECT.md)
            * [CF_WORKER_ROUTE](language-reference/domain-modifiers/CF_WORKER_ROUTE.md)
        * ClouDNS
            * [CLOUDNS_WR](language-reference/domain-modifiers/CLOUDNS_WR.md)
        * PowerDNS
            * [LUA](language-reference/domain-modifiers/LUA.md)     
* Record Modifiers
    * [TTL](language-reference/record-modifiers/TTL.md)
    * Service Provider specific
        * Amazon Route 53
            * [R53_ZONE](language-reference/record-modifiers/R53_ZONE.md)
            * [R53_EVALUATE_TARGET_HEALTH](language-reference/record-modifiers/R53\_EVALUATE\_TARGET\_HEALTH.md)
* [Why CNAME/MX/NS targets require a "dot"](language-reference/why-the-dot.md)

## Provider

* [Supported providers](provider/index.md)
* [AdGuard Home](provider/adguardhome.md)
* [Akamai Edge DNS](provider/akamaiedgedns.md)
* [Amazon Route 53](provider/route53.md)
* [AutoDNS](provider/autodns.md)
* [AXFR+DDNS](provider/axfrddns.md)
* [Azure DNS](provider/azure_dns.md)
* [Azure Private DNS](provider/azure_private_dns.md)
* [BIND](provider/bind.md)
* [Bunny DNS](provider/bunny\_dns.md)
* [CentralNic Reseller (CNR) - formerly RRPProxy](provider/cnr.md)
* [Cloudflare](provider/cloudflareapi.md)
* [ClouDNS](provider/cloudns.md)
* [CSC Global](provider/cscglobal.md)
* [deSEC](provider/desec.md)
* [DigitalOcean](provider/digitalocean.md)
* [DNS Made Easy](provider/dnsmadeeasy.md)
* [DNSimple](provider/dnsimple.md)
* [DNS-over-HTTPS](provider/dnsoverhttps.md)
* [DOMAINNAMESHOP](provider/domainnameshop.md)
* [Dynadot](provider/dynadot.md)
* [easyname](provider/easyname.md)
* [Exoscale](provider/exoscale.md)
* [Fortigate](provider/fortigate.md)
* [Gandi_v5](provider/gandi_v5.md)
* [Gcore](provider/gcore.md)
* [Google Cloud DNS](provider/gcloud.md)
* [Hetzner DNS Console](provider/hetzner.md)
* [HEXONET](provider/hexonet.md)
* [hosting.de](provider/hostingde.md)
* [Huawei Cloud DNS](provider/huaweicloud.md)
* [Hurricane Electric DNS](provider/hedns.md)
* [Internet.bs](provider/internetbs.md)
* [INWX](provider/inwx.md)
* [Joker](provider/joker.md)
* [Linode](provider/linode.md)
* [Loopia](provider/loopia.md)
* [LuaDNS](provider/luadns.md)
* [Mythic Beasts](provider/mythicbeasts.md)
* [Namecheap](provider/namecheap.md)
* [Name.com](provider/namedotcom.md)
* [Netcup](provider/netcup.md)
* [Netlify](provider/netlify.md)
* [NS1](provider/ns1.md)
* [OpenSRS](provider/opensrs.md)
* [Oracle Cloud](provider/oracle.md)
* [OVH](provider/ovh.md)
* [Packetframe](provider/packetframe.md)
* [Porkbun](provider/porkbun.md)
* [PowerDNS](provider/powerdns.md)
* [Realtime Register](provider/realtimeregister.md)
* [RWTH DNS-Admin](provider/rwth.md)
* [Sakura Cloud](provider/sakuracloud.md)
* [SoftLayer DNS](provider/softlayer.md)
* [TransIP](provider/transip.md)
* [Vultr](provider/vultr.md)

## Commands

* [preview/push](commands/preview-push.md)
* [check-creds](commands/check-creds.md)
* [get-zones](commands/get-zones.md)
* [fmt](commands/fmt.md)
* [creds.json](commands/creds-json.md)
* [Global Flag](commands/globalflags.md)
* [Disabling Colors](commands/colors.md)

## Advanced features

* [Concurrency Verified](advanced-features/concurrency-verified.md)
* [CI/CD example for GitLab](advanced-features/ci-cd-gitlab.md)
* [CLI variables](advanced-features/cli-variables.md)
* [Nameservers and Delegations](advanced-features/nameservers.md)
* [Notifications](advanced-features/notifications.md)
* [Useful code tricks](advanced-features/code-tricks.md)
* [JSON Reports](advanced-features/json-reports.md)
* [Dual Host](advanced-features/dual-host.md)

## Developer info

* [Code Style Guide](advanced-features/styleguide-code.md)
* [Documentation Style Guide](advanced-features/styleguide-doc.md)
* [DNSControl is an opinionated system](advanced-features/opinions.md)
* [Writing new DNS providers](advanced-features/writing-providers.md)
* [Creating new DNS Resource Types (rtypes)](advanced-features/adding-new-rtypes.md)
* [Integration Tests](advanced-features/integration-tests.md)
* [Test a branch](advanced-features/test-a-branch.md)
* [Unit Testing DNS Data](advanced-features/unittests.md)
* [Bug Triage Process](advanced-features/bug-triage.md)
* [Bring-Your-Own-Secrets for automated testing](advanced-features/byo-secrets.md)
* [Debugging with dlv](advanced-features/debugging-with-dlv.md)
* [ALIAS Records](advanced-features/alias.md)
* [TXT record testing](advanced-features/testing-txt-records.md)
* [DNS records ordering](advanced-features/ordering.md)
* [How to add a requested provider](developer-info/provider-request.md)

## Release

* [How to build and ship a release](release/release-engineering.md)
* [Changelog v3.16.0](release/v316.md)
* [GitHub releases](https://github.com/StackExchange/dnscontrol/releases/latest)
