package io.keybase.ossifrage;

import android.os.Build;
import android.content.res.Configuration;
import expo.modules.ApplicationLifecycleDispatcher;
import expo.modules.ReactNativeHostWrapper;
import android.app.Application;
import android.content.Context;

import androidx.multidex.MultiDex;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;

import com.facebook.react.ReactInstanceManager;
import com.facebook.react.PackageList;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.defaults.DefaultNewArchitectureEntryPoint;
import com.facebook.react.defaults.DefaultReactNativeHost;
import com.facebook.soloader.SoLoader;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import io.keybase.ossifrage.modules.BackgroundSyncWorker;
import io.keybase.ossifrage.modules.NativeLogger;
import io.keybase.ossifrage.modules.StorybookConstants;
import androidx.lifecycle.ProcessLifecycleOwner;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;

import static keybase.Keybase.forceGC;

class AppLifecycleListener implements DefaultLifecycleObserver {
    private final Context context;
    public AppLifecycleListener (Context c) {
        this.context = c;
    }
    @Override
    public void onStop(LifecycleOwner owner) { // app moved to background
        new Thread(new Runnable() {
              @Override
              public void run() {
                 Glide.get(context).clearDiskCache();
              }
         }).start();
    }
}

public class MainApplication extends Application implements ReactApplication {
    private final ReactNativeHost mReactNativeHost = new DefaultReactNativeHost(this) {
        @Override
        public boolean getUseDeveloperSupport() {
            return BuildConfig.DEBUG;
        }

        @Override
        protected List<ReactPackage> getPackages() {
            //@SuppressWarnings("UnnecessaryLocalVariable")
            List<ReactPackage> packages = new PackageList(this).getPackages();
            packages.add(new KBReactPackage() {
                @Override
                public List<NativeModule> createNativeModules(ReactApplicationContext reactApplicationContext) {
                    if (BuildConfig.BUILD_TYPE == "storyBook") {
                        List<NativeModule> modules = new ArrayList<>();
                        modules.add(new StorybookConstants(reactApplicationContext));
                        return modules;
                    } else {
                        return super.createNativeModules(reactApplicationContext);
                    }
                }
            });

            return packages;
        }

        @Override
        protected String getJSMainModuleName() {
            return "index";
        }

        @Override
        protected boolean isNewArchEnabled() {
          return BuildConfig.IS_NEW_ARCHITECTURE_ENABLED;
        }
        @Override
        protected Boolean isHermesEnabled() {
          return BuildConfig.IS_HERMES_ENABLED;
        }
    };

    @Override
    public ReactNativeHost getReactNativeHost() {
        return mReactNativeHost;
    }

    @Override
    public void onCreate() {
        NativeLogger.info("MainApplication created");
        super.onCreate();
        SoLoader.init(this, /* native exopackage */ false);
        if (BuildConfig.IS_NEW_ARCHITECTURE_ENABLED) {
          // If you opted-in for the New Architecture, we load the native entry point for this app.
          DefaultNewArchitectureEntryPoint.load();
        }
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.LOLLIPOP_MR1) {
            ReactNativeFlipper.initializeFlipper(this, getReactNativeHost().getReactInstanceManager());
        }

        // KB
        ApplicationLifecycleDispatcher.onApplicationCreate(this);

        ReactInstanceManager instanceManager = getReactNativeHost().getReactInstanceManager();
        if (instanceManager != null) {
            ProcessLifecycleOwner.get().getLifecycle().addObserver(
                    new AppLifecycleListener(instanceManager.getCurrentReactContext())
                    );
        }

        WorkRequest backgroundSyncRequest =
            new PeriodicWorkRequest.Builder(BackgroundSyncWorker.class,
                    1, TimeUnit.HOURS,
                    15, TimeUnit.MINUTES)
            .build();
        WorkManager
            .getInstance(this)
            .enqueue(backgroundSyncRequest);
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ApplicationLifecycleDispatcher.onConfigurationChanged(this, newConfig);
    }

    @Override
    public void onLowMemory() {
        forceGC();
        super.onLowMemory();
    }
}
