# v1.1 - Nightly Bats

![](./v1.1/banner.png)

Nightly batch release straight from master.

## GoReleaser

Updated [goreleaser] config to adopt defaults across all projects.

> This changes the release artifact names slightly and might break some scripts.

## Nightly

Added [carapace-sh/nightly].

> Nightly builds use the same [goreleaser] config, but in a different environment.

## Selfupdate

With `carapace --selfupdate` specific [nightly] or [stable] releases can be installed.

![](./v1.1/selfupdate.cast)

Executable is installed to the [GOBIN] directory, essentially shadowing any system installation.


```sh
export PATH="$HOME/.local/bin:$HOME/go/bin:$PATH"
#            │                │            └system installation (e.g. /usr/bin/carapace)
#            │                └selfupdate/go based installation ($GOBIN)
#            └user binaries
```

### Requirements

- [curl] for downloads
- [PATH] containing the [GOBIN] directory

## Homebrew

Now installable from [homebrew-core](https://formulae.brew.sh/formula/carapace).

```sh
brew install carapace
```

## Nospace

Added `CARAPACE_NOSPACE` environment variable to control space suffix behaviour.

![](./v1.1/nospace.cast)


## Tooltip

Added `CARAPACE_TOOLTIP` environment variable to enable tooltip style.

![](./v1.1/tooltip.cast)

> Only affects Powershell.

[nightly]:https://github.com/carapace-sh/nightly/releases
[stable]:https://github.com/carapace-sh/carapace-bin/releases

[curl]:https://curl.se
[GOBIN]:https://pkg.go.dev/cmd/go#hdr-Compile_and_install_packages_and_dependencies
[PATH]:https://en.wikipedia.org/wiki/PATH_(variable)

[carapace-sh/nightly]:https://github.com/carapace-sh/nightly
[goreleaser]:https://goreleaser.com

