# v0.23 - First Amendment

![](./v0.23/banner.png)

## Bridge Actions (BREAKING CHANGE)

[Bridge](..//spec/bridge.html) actions now take multiple arguments.
Analogue to [Alias](https://carapace-sh.github.io/carapace-bin/spec/run.html#alias) this enables embedding of subcommands in macros.
Specs need to be updated though by adding `[]` brackets to the bridge macro arguments:

```yaml
completion:
  # positionalany: ["$_bridge.CarapaceBin(git)"]  # OLD
  positionalany: ["$_bridge.CarapaceBin([git])"]  # NEW
````

# Overlay

[Overlays] are essentially [Spec] files placed in [`${UserConfigDir}/carapace/overlays`] that provide additional completions.

These are merged with the existing completion and provide a workaround for issues that have yet to be fixed in upstream.

> Overlays implicitly set `CARAPACE_LENIENT` to allow unknown flags.

# Flag

```yaml
# ~/.config/carapace/overlays/doctl.yaml
name: doctl
persistentflags:
  --output=: Desired output format [text|json]
completion:
  flag:
    output: [text, json]
commands:
  - name: compute
    description: Display commands that manage infrastructure
    commands:
      - name: region
        description: Display commands to list datacenter regions
        commands:
          - name: list
            description: List datacenter regions
            flags:
              --format=: Columns for output in a comma-separated list
            completion:
              flag:
                format: ["$uniquelist(,)", Slug, Name, Available]
```

![](./v0.23/overlay.cast)

# Windows

Using zip as archive for windows releases for [winget compability](https://github.com/microsoft/winget-cli/issues/2899).

[Overlays]:https://carapace-sh.github.io/carapace-bin/overlay.html
[Spec]:../spec.md
[`${UserConfigDir}/carapace/overlays`]:https://pkg.go.dev/os#UserConfigDir
