package cmd

import (
	"github.com/carapace-sh/carapace"
	"github.com/spf13/cobra"
)

var init_phase_bootstrapTokenCmd = &cobra.Command{
	Use:     "bootstrap-token",
	Short:   "Generates bootstrap tokens used to join a node to a cluster",
	Aliases: []string{"bootstraptoken"},
	Run:     func(cmd *cobra.Command, args []string) {},
}

func init() {
	carapace.Gen(init_phase_bootstrapTokenCmd).Standalone()

	init_phase_bootstrapTokenCmd.Flags().String("config", "", "Path to a kubeadm configuration file.")
	init_phase_bootstrapTokenCmd.Flags().Bool("dry-run", false, "Don't apply any changes; just output what would be done.")
	init_phase_bootstrapTokenCmd.Flags().String("kubeconfig", "", "The kubeconfig file to use when talking to the cluster. If the flag is not set, a set of standard locations can be searched for an existing kubeconfig file.")
	init_phase_bootstrapTokenCmd.Flags().Bool("skip-token-print", false, "Skip printing of the default bootstrap token generated by 'kubeadm init'.")
	init_phaseCmd.AddCommand(init_phase_bootstrapTokenCmd)

	carapace.Gen(init_phase_bootstrapTokenCmd).FlagCompletion(carapace.ActionMap{
		"config":     carapace.ActionFiles(),
		"kubeconfig": carapace.ActionFiles(),
	})
}
