package tech.berty.bertybridgeexpo

import android.app.Activity
import android.os.Bundle
import android.util.Log
import expo.modules.core.interfaces.ReactActivityLifecycleListener

class LifecycleListener : ReactActivityLifecycleListener {
    override fun onCreate(activity: Activity, savedInstanceState: Bundle?) {
        super.onDestroy(activity)

        state = AppState.FOREGROUND
        Log.i(TAG, "onCreate")
    }

    override fun onResume(activity: Activity) {
        super.onDestroy(activity)

        state = AppState.FOREGROUND
        Log.i(TAG, "onResume")
    }

    override fun onDestroy(activity: Activity?) {
        super.onDestroy(activity)

        state = AppState.BACKGROUND
        Log.i(TAG, "onDestroy")
    }

    override fun onPause(activity: Activity?) {
        super.onPause(activity)

        state = AppState.BACKGROUND
        Log.i(TAG, "onPause")
    }

    companion object {
        enum class AppState {
            BACKGROUND, FOREGROUND
        }

        const val TAG: String = "LifecycleListener"
        var state: AppState = AppState.BACKGROUND

        fun isForeground(): Boolean {
            return state == AppState.FOREGROUND
        }
    }
}
