// Code generated by smithy-go-codegen DO NOT EDIT.

package timestreaminfluxdb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new Timestream for InfluxDB cluster.
func (c *Client) CreateDbCluster(ctx context.Context, params *CreateDbClusterInput, optFns ...func(*Options)) (*CreateDbClusterOutput, error) {
	if params == nil {
		params = &CreateDbClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDbCluster", params, optFns, c.addOperationCreateDbClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDbClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDbClusterInput struct {

	// The amount of storage to allocate for your DB storage type in GiB (gibibytes).
	//
	// This member is required.
	AllocatedStorage *int32

	// The Timestream for InfluxDB DB instance type to run InfluxDB on.
	//
	// This member is required.
	DbInstanceType types.DbInstanceType

	// Specifies the type of cluster to create.
	//
	// This member is required.
	DeploymentType types.ClusterDeploymentType

	// The name that uniquely identifies the DB cluster when interacting with the
	// Amazon Timestream for InfluxDB API and CLI commands. This name will also be a
	// prefix included in the endpoint. DB cluster names must be unique per customer
	// and per region.
	//
	// This member is required.
	Name *string

	// The password of the initial admin user created in InfluxDB. This password will
	// allow you to access the InfluxDB UI to perform various administrative tasks and
	// also use the InfluxDB CLI to create an operator token. These attributes will be
	// stored in a secret created in Secrets Manager in your account.
	//
	// This member is required.
	Password *string

	// A list of VPC security group IDs to associate with the Timestream for InfluxDB
	// cluster.
	//
	// This member is required.
	VpcSecurityGroupIds []string

	// A list of VPC subnet IDs to associate with the DB cluster. Provide at least two
	// VPC subnet IDs in different Availability Zones when deploying with a Multi-AZ
	// standby.
	//
	// This member is required.
	VpcSubnetIds []string

	// The name of the initial InfluxDB bucket. All InfluxDB data is stored in a
	// bucket. A bucket combines the concept of a database and a retention period (the
	// duration of time that each data point persists). A bucket belongs to an
	// organization.
	Bucket *string

	// The ID of the DB parameter group to assign to your DB cluster. DB parameter
	// groups specify how the database is configured. For example, DB parameter groups
	// can specify the limit for query concurrency.
	DbParameterGroupIdentifier *string

	// The Timestream for InfluxDB DB storage type to read and write InfluxDB data.
	//
	// You can choose between three different types of provisioned Influx IOPS
	// Included storage according to your workload requirements:
	//
	//   - Influx I/O Included 3000 IOPS
	//
	//   - Influx I/O Included 12000 IOPS
	//
	//   - Influx I/O Included 16000 IOPS
	DbStorageType types.DbStorageType

	// Specifies the behavior of failure recovery when the primary node of the cluster
	// fails.
	FailoverMode types.FailoverMode

	// Configuration for sending InfluxDB engine logs to a specified S3 bucket.
	LogDeliveryConfiguration *types.LogDeliveryConfiguration

	// Specifies whether the network type of the Timestream for InfluxDB cluster is
	// IPv4, which can communicate over IPv4 protocol only, or DUAL, which can
	// communicate over both IPv4 and IPv6 protocols.
	NetworkType types.NetworkType

	// The name of the initial organization for the initial admin user in InfluxDB. An
	// InfluxDB organization is a workspace for a group of users.
	Organization *string

	// The port number on which InfluxDB accepts connections.
	//
	// Valid Values: 1024-65535
	//
	// Default: 8086
	//
	// Constraints: The value can't be 2375-2376, 7788-7799, 8090, or 51678-51680
	Port *int32

	// Configures the Timestream for InfluxDB cluster with a public IP to facilitate
	// access from outside the VPC.
	PubliclyAccessible *bool

	// A list of key-value pairs to associate with the DB instance.
	Tags map[string]string

	// The username of the initial admin user created in InfluxDB. Must start with a
	// letter and can't end with a hyphen or contain two consecutive hyphens. For
	// example, my-user1. This username will allow you to access the InfluxDB UI to
	// perform various administrative tasks and also use the InfluxDB CLI to create an
	// operator token. These attributes will be stored in a secret created in Secrets
	// Manager in your account.
	Username *string

	noSmithyDocumentSerde
}

type CreateDbClusterOutput struct {

	// A service-generated unique identifier.
	DbClusterId *string

	// The status of the DB cluster.
	DbClusterStatus types.ClusterStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDbClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateDbCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateDbCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDbCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDbClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDbCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDbCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDbCluster",
	}
}
