// Code generated by smithy-go-codegen DO NOT EDIT.

package ssmincidents

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssmincidents/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Retrieve your Incident Manager replication set.
func (c *Client) GetReplicationSet(ctx context.Context, params *GetReplicationSetInput, optFns ...func(*Options)) (*GetReplicationSetOutput, error) {
	if params == nil {
		params = &GetReplicationSetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetReplicationSet", params, optFns, c.addOperationGetReplicationSetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetReplicationSetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetReplicationSetInput struct {

	// The Amazon Resource Name (ARN) of the replication set you want to retrieve.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

type GetReplicationSetOutput struct {

	// Details of the replication set.
	//
	// This member is required.
	ReplicationSet *types.ReplicationSet

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetReplicationSetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetReplicationSet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetReplicationSet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetReplicationSet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetReplicationSetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetReplicationSet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// WaitForReplicationSetActiveWaiterOptions are waiter options for
// WaitForReplicationSetActiveWaiter
type WaitForReplicationSetActiveWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// WaitForReplicationSetActiveWaiter will use default minimum delay of 30 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, WaitForReplicationSetActiveWaiter will use default max delay of 30
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetReplicationSetInput, *GetReplicationSetOutput, error) (bool, error)
}

// WaitForReplicationSetActiveWaiter defines the waiters for
// WaitForReplicationSetActive
type WaitForReplicationSetActiveWaiter struct {
	client GetReplicationSetAPIClient

	options WaitForReplicationSetActiveWaiterOptions
}

// NewWaitForReplicationSetActiveWaiter constructs a
// WaitForReplicationSetActiveWaiter.
func NewWaitForReplicationSetActiveWaiter(client GetReplicationSetAPIClient, optFns ...func(*WaitForReplicationSetActiveWaiterOptions)) *WaitForReplicationSetActiveWaiter {
	options := WaitForReplicationSetActiveWaiterOptions{}
	options.MinDelay = 30 * time.Second
	options.MaxDelay = 30 * time.Second
	options.Retryable = waitForReplicationSetActiveStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &WaitForReplicationSetActiveWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for WaitForReplicationSetActive waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *WaitForReplicationSetActiveWaiter) Wait(ctx context.Context, params *GetReplicationSetInput, maxWaitDur time.Duration, optFns ...func(*WaitForReplicationSetActiveWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for WaitForReplicationSetActive waiter
// and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *WaitForReplicationSetActiveWaiter) WaitForOutput(ctx context.Context, params *GetReplicationSetInput, maxWaitDur time.Duration, optFns ...func(*WaitForReplicationSetActiveWaiterOptions)) (*GetReplicationSetOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 30 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetReplicationSet(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for WaitForReplicationSetActive waiter")
}

func waitForReplicationSetActiveStateRetryable(ctx context.Context, input *GetReplicationSetInput, output *GetReplicationSetOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.ReplicationSet
		var v2 types.ReplicationSetStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		expectedValue := "ACTIVE"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.ReplicationSet
		var v2 types.ReplicationSetStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		expectedValue := "CREATING"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.ReplicationSet
		var v2 types.ReplicationSetStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		expectedValue := "UPDATING"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.ReplicationSet
		var v2 types.ReplicationSetStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		expectedValue := "FAILED"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// WaitForReplicationSetDeletedWaiterOptions are waiter options for
// WaitForReplicationSetDeletedWaiter
type WaitForReplicationSetDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// WaitForReplicationSetDeletedWaiter will use default minimum delay of 30 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, WaitForReplicationSetDeletedWaiter will use default max delay of 30
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetReplicationSetInput, *GetReplicationSetOutput, error) (bool, error)
}

// WaitForReplicationSetDeletedWaiter defines the waiters for
// WaitForReplicationSetDeleted
type WaitForReplicationSetDeletedWaiter struct {
	client GetReplicationSetAPIClient

	options WaitForReplicationSetDeletedWaiterOptions
}

// NewWaitForReplicationSetDeletedWaiter constructs a
// WaitForReplicationSetDeletedWaiter.
func NewWaitForReplicationSetDeletedWaiter(client GetReplicationSetAPIClient, optFns ...func(*WaitForReplicationSetDeletedWaiterOptions)) *WaitForReplicationSetDeletedWaiter {
	options := WaitForReplicationSetDeletedWaiterOptions{}
	options.MinDelay = 30 * time.Second
	options.MaxDelay = 30 * time.Second
	options.Retryable = waitForReplicationSetDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &WaitForReplicationSetDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for WaitForReplicationSetDeleted waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *WaitForReplicationSetDeletedWaiter) Wait(ctx context.Context, params *GetReplicationSetInput, maxWaitDur time.Duration, optFns ...func(*WaitForReplicationSetDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for WaitForReplicationSetDeleted waiter
// and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *WaitForReplicationSetDeletedWaiter) WaitForOutput(ctx context.Context, params *GetReplicationSetInput, maxWaitDur time.Duration, optFns ...func(*WaitForReplicationSetDeletedWaiterOptions)) (*GetReplicationSetOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 30 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetReplicationSet(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for WaitForReplicationSetDeleted waiter")
}

func waitForReplicationSetDeletedStateRetryable(ctx context.Context, input *GetReplicationSetInput, output *GetReplicationSetOutput, err error) (bool, error) {

	if err != nil {
		var errorType *types.ResourceNotFoundException
		if errors.As(err, &errorType) {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.ReplicationSet
		var v2 types.ReplicationSetStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		expectedValue := "DELETING"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.ReplicationSet
		var v2 types.ReplicationSetStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		expectedValue := "FAILED"
		var pathValue string
		pathValue = string(v2)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// GetReplicationSetAPIClient is a client that implements the GetReplicationSet
// operation.
type GetReplicationSetAPIClient interface {
	GetReplicationSet(context.Context, *GetReplicationSetInput, ...func(*Options)) (*GetReplicationSetOutput, error)
}

var _ GetReplicationSetAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetReplicationSet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetReplicationSet",
	}
}
