// Code generated by smithy-go-codegen DO NOT EDIT.

package odb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/odb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new Autonomous VM cluster in the specified Exadata infrastructure.
func (c *Client) CreateCloudAutonomousVmCluster(ctx context.Context, params *CreateCloudAutonomousVmClusterInput, optFns ...func(*Options)) (*CreateCloudAutonomousVmClusterOutput, error) {
	if params == nil {
		params = &CreateCloudAutonomousVmClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCloudAutonomousVmCluster", params, optFns, c.addOperationCreateCloudAutonomousVmClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCloudAutonomousVmClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateCloudAutonomousVmClusterInput struct {

	// The data disk group size to be allocated for Autonomous Databases, in terabytes
	// (TB).
	//
	// This member is required.
	AutonomousDataStorageSizeInTBs *float64

	// The unique identifier of the Exadata infrastructure where the VM cluster will
	// be created.
	//
	// This member is required.
	CloudExadataInfrastructureId *string

	// The number of CPU cores to be enabled per VM cluster node.
	//
	// This member is required.
	CpuCoreCountPerNode *int32

	// The display name for the Autonomous VM cluster. The name does not need to be
	// unique.
	//
	// This member is required.
	DisplayName *string

	// The amount of memory to be allocated per OCPU, in GB.
	//
	// This member is required.
	MemoryPerOracleComputeUnitInGBs *int32

	// The unique identifier of the ODB network to be used for the VM cluster.
	//
	// This member is required.
	OdbNetworkId *string

	// The total number of Autonomous CDBs that you can create in the Autonomous VM
	// cluster.
	//
	// This member is required.
	TotalContainerDatabases *int32

	// A client-provided token to ensure idempotency of the request.
	ClientToken *string

	// The list of database servers to be used for the Autonomous VM cluster.
	DbServers []string

	// A user-provided description of the Autonomous VM cluster.
	Description *string

	// Specifies whether to enable mutual TLS (mTLS) authentication for the Autonomous
	// VM cluster.
	IsMtlsEnabledVmCluster *bool

	// The Oracle license model to apply to the Autonomous VM cluster.
	LicenseModel types.LicenseModel

	// The scheduling details for the maintenance window. Patching and system updates
	// take place during the maintenance window.
	MaintenanceWindow *types.MaintenanceWindow

	// The SCAN listener port for non-TLS (TCP) protocol.
	ScanListenerPortNonTls *int32

	// The SCAN listener port for TLS (TCP) protocol.
	ScanListenerPortTls *int32

	// Free-form tags for this resource. Each tag is a key-value pair with no
	// predefined name, type, or namespace.
	Tags map[string]string

	// The time zone to use for the Autonomous VM cluster.
	TimeZone *string

	noSmithyDocumentSerde
}

type CreateCloudAutonomousVmClusterOutput struct {

	// The unique identifier of the created Autonomous VM cluster.
	//
	// This member is required.
	CloudAutonomousVmClusterId *string

	// The display name of the created Autonomous VM cluster.
	DisplayName *string

	// The current status of the Autonomous VM cluster creation process.
	Status types.ResourceStatus

	// Additional information about the current status of the Autonomous VM cluster
	// creation process, if applicable.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCloudAutonomousVmClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateCloudAutonomousVmCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateCloudAutonomousVmCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateCloudAutonomousVmCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateCloudAutonomousVmClusterMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateCloudAutonomousVmClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCloudAutonomousVmCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateCloudAutonomousVmCluster struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateCloudAutonomousVmCluster) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateCloudAutonomousVmCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateCloudAutonomousVmClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateCloudAutonomousVmClusterInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateCloudAutonomousVmClusterMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateCloudAutonomousVmCluster{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateCloudAutonomousVmCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateCloudAutonomousVmCluster",
	}
}
