// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns key information about a specific flow operation.
func (c *Client) DescribeFlowOperation(ctx context.Context, params *DescribeFlowOperationInput, optFns ...func(*Options)) (*DescribeFlowOperationOutput, error) {
	if params == nil {
		params = &DescribeFlowOperationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFlowOperation", params, optFns, c.addOperationDescribeFlowOperationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFlowOperationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFlowOperationInput struct {

	// The Amazon Resource Name (ARN) of the firewall.
	//
	// This member is required.
	FirewallArn *string

	// A unique identifier for the flow operation. This ID is returned in the
	// responses to start and list commands. You provide to describe commands.
	//
	// This member is required.
	FlowOperationId *string

	// The ID of the Availability Zone where the firewall is located. For example,
	// us-east-2a .
	//
	// Defines the scope a flow operation. You can use up to 20 filters to configure a
	// single flow operation.
	AvailabilityZone *string

	// The Amazon Resource Name (ARN) of a VPC endpoint association.
	VpcEndpointAssociationArn *string

	// A unique identifier for the primary endpoint associated with a firewall.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

type DescribeFlowOperationOutput struct {

	// The ID of the Availability Zone where the firewall is located. For example,
	// us-east-2a .
	//
	// Defines the scope a flow operation. You can use up to 20 filters to configure a
	// single flow operation.
	AvailabilityZone *string

	// The Amazon Resource Name (ARN) of the firewall.
	FirewallArn *string

	// Returns key information about a flow operation, such as related statuses,
	// unique identifiers, and all filters defined in the operation.
	FlowOperation *types.FlowOperation

	// A unique identifier for the flow operation. This ID is returned in the
	// responses to start and list commands. You provide to describe commands.
	FlowOperationId *string

	// Returns the status of the flow operation. This string is returned in the
	// responses to start, list, and describe commands.
	//
	// If the status is COMPLETED_WITH_ERRORS , results may be returned with any number
	// of Flows missing from the response. If the status is FAILED , Flows returned
	// will be empty.
	FlowOperationStatus types.FlowOperationStatus

	// Defines the type of FlowOperation .
	FlowOperationType types.FlowOperationType

	// A timestamp indicating when the Suricata engine identified flows impacted by an
	// operation.
	FlowRequestTimestamp *time.Time

	// If the asynchronous operation fails, Network Firewall populates this with the
	// reason for the error or failure. Options include Flow operation error and Flow
	// timeout .
	StatusMessage *string

	// The Amazon Resource Name (ARN) of a VPC endpoint association.
	VpcEndpointAssociationArn *string

	// A unique identifier for the primary endpoint associated with a firewall.
	VpcEndpointId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFlowOperationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeFlowOperation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeFlowOperation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeFlowOperation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeFlowOperationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFlowOperation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeFlowOperation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeFlowOperation",
	}
}
