// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesis

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesis/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a Kinesis data stream. A stream captures and transports data records
// that are continuously emitted from different data sources or producers.
// Scale-out within a stream is explicitly supported by means of shards, which are
// uniquely identified groups of data records in a stream.
//
// You can create your data stream using either on-demand or provisioned capacity
// mode. Data streams with an on-demand mode require no capacity planning and
// automatically scale to handle gigabytes of write and read throughput per minute.
// With the on-demand mode, Kinesis Data Streams automatically manages the shards
// in order to provide the necessary throughput. For the data streams with a
// provisioned mode, you must specify the number of shards for the data stream.
// Each shard can support reads up to five transactions per second, up to a maximum
// data read total of 2 MiB per second. Each shard can support writes up to 1,000
// records per second, up to a maximum data write total of 1 MiB per second. If the
// amount of data input increases or decreases, you can add or remove shards.
//
// The stream name identifies the stream. The name is scoped to the Amazon Web
// Services account used by the application. It is also scoped by Amazon Web
// Services Region. That is, two streams in two different accounts can have the
// same name, and two streams in the same account, but in two different Regions,
// can have the same name.
//
// CreateStream is an asynchronous operation. Upon receiving a CreateStream
// request, Kinesis Data Streams immediately returns and sets the stream status to
// CREATING . After the stream is created, Kinesis Data Streams sets the stream
// status to ACTIVE . You should perform read and write operations only on an
// ACTIVE stream.
//
// You receive a LimitExceededException when making a CreateStream request when
// you try to do one of the following:
//
//   - Have more than five streams in the CREATING state at any point in time.
//
//   - Create more shards than are authorized for your account.
//
// For the default shard limit for an Amazon Web Services account, see [Amazon Kinesis Data Streams Limits] in the
// Amazon Kinesis Data Streams Developer Guide. To increase this limit, [contact Amazon Web Services Support].
//
// You can use DescribeStreamSummary to check the stream status, which is returned in StreamStatus .
//
// CreateStreamhas a limit of five transactions per second per account.
//
// You can add tags to the stream when making a CreateStream request by setting
// the Tags parameter. If you pass the Tags parameter, in addition to having the
// kinesis:CreateStream permission, you must also have the kinesis:AddTagsToStream
// permission for the stream that will be created. The kinesis:TagResource
// permission won’t work to tag streams on creation. Tags will take effect from the
// CREATING status of the stream, but you can't make any updates to the tags until
// the stream is in ACTIVE state.
//
// [contact Amazon Web Services Support]: https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html
// [Amazon Kinesis Data Streams Limits]: https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html
func (c *Client) CreateStream(ctx context.Context, params *CreateStreamInput, optFns ...func(*Options)) (*CreateStreamOutput, error) {
	if params == nil {
		params = &CreateStreamInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateStream", params, optFns, c.addOperationCreateStreamMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateStreamOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input for CreateStream .
type CreateStreamInput struct {

	// A name to identify the stream. The stream name is scoped to the Amazon Web
	// Services account used by the application that creates the stream. It is also
	// scoped by Amazon Web Services Region. That is, two streams in two different
	// Amazon Web Services accounts can have the same name. Two streams in the same
	// Amazon Web Services account but in two different Regions can also have the same
	// name.
	//
	// This member is required.
	StreamName *string

	// The number of shards that the stream will use. The throughput of the stream is
	// a function of the number of shards; more shards are required for greater
	// provisioned throughput.
	ShardCount *int32

	//  Indicates the capacity mode of the data stream. Currently, in Kinesis Data
	// Streams, you can choose between an on-demand capacity mode and a provisioned
	// capacity mode for your data streams.
	StreamModeDetails *types.StreamModeDetails

	// A set of up to 50 key-value pairs to use to create the tags. A tag consists of
	// a required key and an optional value.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateStreamOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateStreamMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateStream{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateStream{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateStream"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateStreamValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateStream(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateStream(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateStream",
	}
}
