// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Used in the exception error that is thrown if you start an assessment run for
// an assessment target that includes an EC2 instance that is already participating
// in another started assessment run.
type AgentAlreadyRunningAssessment struct {

	// ID of the agent that is running on an EC2 instance that is already
	// participating in another started assessment run.
	//
	// This member is required.
	AgentId *string

	// The ARN of the assessment run that has already been started.
	//
	// This member is required.
	AssessmentRunArn *string

	noSmithyDocumentSerde
}

// Contains information about an Amazon Inspector agent. This data type is used as
// a request parameter in the ListAssessmentRunAgentsaction.
type AgentFilter struct {

	// The detailed health state of the agent. Values can be set to IDLE, RUNNING,
	// SHUTDOWN, UNHEALTHY, THROTTLED, and UNKNOWN.
	//
	// This member is required.
	AgentHealthCodes []AgentHealthCode

	// The current health state of the agent. Values can be set to HEALTHY or
	// UNHEALTHY.
	//
	// This member is required.
	AgentHealths []AgentHealth

	noSmithyDocumentSerde
}

// Used as a response element in the PreviewAgents action.
type AgentPreview struct {

	// The ID of the EC2 instance where the agent is installed.
	//
	// This member is required.
	AgentId *string

	// The health status of the Amazon Inspector Agent.
	AgentHealth AgentHealth

	// The version of the Amazon Inspector Agent.
	AgentVersion *string

	// The Auto Scaling group for the EC2 instance where the agent is installed.
	AutoScalingGroup *string

	// The hostname of the EC2 instance on which the Amazon Inspector Agent is
	// installed.
	Hostname *string

	// The IP address of the EC2 instance on which the Amazon Inspector Agent is
	// installed.
	Ipv4Address *string

	// The kernel version of the operating system running on the EC2 instance on which
	// the Amazon Inspector Agent is installed.
	KernelVersion *string

	// The operating system running on the EC2 instance on which the Amazon Inspector
	// Agent is installed.
	OperatingSystem *string

	noSmithyDocumentSerde
}

// A snapshot of an Amazon Inspector assessment run that contains the findings of
// the assessment run .
//
// Used as the response element in the DescribeAssessmentRuns action.
type AssessmentRun struct {

	// The ARN of the assessment run.
	//
	// This member is required.
	Arn *string

	// The ARN of the assessment template that is associated with the assessment run.
	//
	// This member is required.
	AssessmentTemplateArn *string

	// The time when StartAssessmentRun was called.
	//
	// This member is required.
	CreatedAt *time.Time

	// A Boolean value (true or false) that specifies whether the process of
	// collecting data from the agents is completed.
	//
	// This member is required.
	DataCollected *bool

	// The duration of the assessment run.
	//
	// This member is required.
	DurationInSeconds *int32

	// Provides a total count of generated findings per severity.
	//
	// This member is required.
	FindingCounts map[string]int32

	// The auto-generated name for the assessment run.
	//
	// This member is required.
	Name *string

	// A list of notifications for the event subscriptions. A notification about a
	// particular generated finding is added to this list only once.
	//
	// This member is required.
	Notifications []AssessmentRunNotification

	// The rules packages selected for the assessment run.
	//
	// This member is required.
	RulesPackageArns []string

	// The state of the assessment run.
	//
	// This member is required.
	State AssessmentRunState

	// The last time when the assessment run's state changed.
	//
	// This member is required.
	StateChangedAt *time.Time

	// A list of the assessment run state changes.
	//
	// This member is required.
	StateChanges []AssessmentRunStateChange

	// The user-defined attributes that are assigned to every generated finding.
	//
	// This member is required.
	UserAttributesForFindings []Attribute

	// The assessment run completion time that corresponds to the rules packages
	// evaluation completion time or failure.
	CompletedAt *time.Time

	// The time when StartAssessmentRun was called.
	StartedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about an Amazon Inspector agent. This data type is used as
// a response element in the ListAssessmentRunAgentsaction.
type AssessmentRunAgent struct {

	// The current health state of the agent.
	//
	// This member is required.
	AgentHealth AgentHealth

	// The detailed health state of the agent.
	//
	// This member is required.
	AgentHealthCode AgentHealthCode

	// The AWS account of the EC2 instance where the agent is installed.
	//
	// This member is required.
	AgentId *string

	// The ARN of the assessment run that is associated with the agent.
	//
	// This member is required.
	AssessmentRunArn *string

	// The Amazon Inspector application data metrics that are collected by the agent.
	//
	// This member is required.
	TelemetryMetadata []TelemetryMetadata

	// The description for the agent health code.
	AgentHealthDetails *string

	// The Auto Scaling group of the EC2 instance that is specified by the agent ID.
	AutoScalingGroup *string

	noSmithyDocumentSerde
}

// Used as the request parameter in the ListAssessmentRuns action.
type AssessmentRunFilter struct {

	// For a record to match a filter, the value that is specified for this data type
	// property must inclusively match any value between the specified minimum and
	// maximum values of the completedAt property of the AssessmentRundata type.
	CompletionTimeRange *TimestampRange

	// For a record to match a filter, the value that is specified for this data type
	// property must inclusively match any value between the specified minimum and
	// maximum values of the durationInSeconds property of the AssessmentRundata type.
	DurationRange *DurationRange

	// For a record to match a filter, an explicit value or a string containing a
	// wildcard that is specified for this data type property must match the value of
	// the assessmentRunName property of the AssessmentRundata type.
	NamePattern *string

	// For a record to match a filter, the value that is specified for this data type
	// property must be contained in the list of values of the rulesPackages property
	// of the AssessmentRundata type.
	RulesPackageArns []string

	// For a record to match a filter, the value that is specified for this data type
	// property must inclusively match any value between the specified minimum and
	// maximum values of the startTime property of the AssessmentRundata type.
	StartTimeRange *TimestampRange

	// For a record to match a filter, the value that is specified for this data type
	// property must match the stateChangedAt property of the AssessmentRundata type.
	StateChangeTimeRange *TimestampRange

	// For a record to match a filter, one of the values specified for this data type
	// property must be the exact match of the value of the assessmentRunState property
	// of the AssessmentRundata type.
	States []AssessmentRunState

	noSmithyDocumentSerde
}

// Used as one of the elements of the AssessmentRun data type.
type AssessmentRunNotification struct {

	// The date of the notification.
	//
	// This member is required.
	Date *time.Time

	// The Boolean value that specifies whether the notification represents an error.
	//
	// This member is required.
	Error *bool

	// The event for which a notification is sent.
	//
	// This member is required.
	Event InspectorEvent

	// The message included in the notification.
	Message *string

	// The status code of the SNS notification.
	SnsPublishStatusCode AssessmentRunNotificationSnsStatusCode

	// The SNS topic to which the SNS notification is sent.
	SnsTopicArn *string

	noSmithyDocumentSerde
}

// Used as one of the elements of the AssessmentRun data type.
type AssessmentRunStateChange struct {

	// The assessment run state.
	//
	// This member is required.
	State AssessmentRunState

	// The last time the assessment run state changed.
	//
	// This member is required.
	StateChangedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about an Amazon Inspector application. This data type is
// used as the response element in the DescribeAssessmentTargetsaction.
type AssessmentTarget struct {

	// The ARN that specifies the Amazon Inspector assessment target.
	//
	// This member is required.
	Arn *string

	// The time at which the assessment target is created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the Amazon Inspector assessment target.
	//
	// This member is required.
	Name *string

	// The time at which UpdateAssessmentTarget is called.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The ARN that specifies the resource group that is associated with the
	// assessment target.
	ResourceGroupArn *string

	noSmithyDocumentSerde
}

// Used as the request parameter in the ListAssessmentTargets action.
type AssessmentTargetFilter struct {

	// For a record to match a filter, an explicit value or a string that contains a
	// wildcard that is specified for this data type property must match the value of
	// the assessmentTargetName property of the AssessmentTargetdata type.
	AssessmentTargetNamePattern *string

	noSmithyDocumentSerde
}

// Contains information about an Amazon Inspector assessment template. This data
// type is used as the response element in the DescribeAssessmentTemplatesaction.
type AssessmentTemplate struct {

	// The ARN of the assessment template.
	//
	// This member is required.
	Arn *string

	// The number of existing assessment runs associated with this assessment
	// template. This value can be zero or a positive integer.
	//
	// This member is required.
	AssessmentRunCount *int32

	// The ARN of the assessment target that corresponds to this assessment template.
	//
	// This member is required.
	AssessmentTargetArn *string

	// The time at which the assessment template is created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The duration in seconds specified for this assessment template. The default
	// value is 3600 seconds (one hour). The maximum value is 86400 seconds (one day).
	//
	// This member is required.
	DurationInSeconds *int32

	// The name of the assessment template.
	//
	// This member is required.
	Name *string

	// The rules packages that are specified for this assessment template.
	//
	// This member is required.
	RulesPackageArns []string

	// The user-defined attributes that are assigned to every generated finding from
	// the assessment run that uses this assessment template.
	//
	// This member is required.
	UserAttributesForFindings []Attribute

	// The Amazon Resource Name (ARN) of the most recent assessment run associated
	// with this assessment template. This value exists only when the value of
	// assessmentRunCount is greaterpa than zero.
	LastAssessmentRunArn *string

	noSmithyDocumentSerde
}

// Used as the request parameter in the ListAssessmentTemplates action.
type AssessmentTemplateFilter struct {

	// For a record to match a filter, the value specified for this data type property
	// must inclusively match any value between the specified minimum and maximum
	// values of the durationInSeconds property of the AssessmentTemplatedata type.
	DurationRange *DurationRange

	// For a record to match a filter, an explicit value or a string that contains a
	// wildcard that is specified for this data type property must match the value of
	// the assessmentTemplateName property of the AssessmentTemplatedata type.
	NamePattern *string

	// For a record to match a filter, the values that are specified for this data
	// type property must be contained in the list of values of the rulesPackageArns
	// property of the AssessmentTemplatedata type.
	RulesPackageArns []string

	noSmithyDocumentSerde
}

// A collection of attributes of the host from which the finding is generated.
type AssetAttributes struct {

	// The schema version of this data type.
	//
	// This member is required.
	SchemaVersion int32

	// The ID of the agent that is installed on the EC2 instance where the finding is
	// generated.
	AgentId *string

	// The ID of the Amazon Machine Image (AMI) that is installed on the EC2 instance
	// where the finding is generated.
	AmiId *string

	// The Auto Scaling group of the EC2 instance where the finding is generated.
	AutoScalingGroup *string

	// The hostname of the EC2 instance where the finding is generated.
	Hostname *string

	// The list of IP v4 addresses of the EC2 instance where the finding is generated.
	Ipv4Addresses []string

	// An array of the network interfaces interacting with the EC2 instance where the
	// finding is generated.
	NetworkInterfaces []NetworkInterface

	// The tags related to the EC2 instance where the finding is generated.
	Tags []Tag

	noSmithyDocumentSerde
}

// This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
type Attribute struct {

	// The attribute key.
	//
	// This member is required.
	Key *string

	// The value assigned to the attribute key.
	Value *string

	noSmithyDocumentSerde
}

// This data type is used in the AssessmentTemplateFilter data type.
type DurationRange struct {

	// The maximum value of the duration range. Must be less than or equal to 604800
	// seconds (1 week).
	MaxSeconds *int32

	// The minimum value of the duration range. Must be greater than zero.
	MinSeconds *int32

	noSmithyDocumentSerde
}

// This data type is used in the Subscription data type.
type EventSubscription struct {

	// The event for which Amazon Simple Notification Service (SNS) notifications are
	// sent.
	//
	// This member is required.
	Event InspectorEvent

	// The time at which SubscribeToEvent is called.
	//
	// This member is required.
	SubscribedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about what was excluded from an assessment run.
type Exclusion struct {

	// The ARN that specifies the exclusion.
	//
	// This member is required.
	Arn *string

	// The description of the exclusion.
	//
	// This member is required.
	Description *string

	// The recommendation for the exclusion.
	//
	// This member is required.
	Recommendation *string

	// The AWS resources for which the exclusion pertains.
	//
	// This member is required.
	Scopes []Scope

	// The name of the exclusion.
	//
	// This member is required.
	Title *string

	// The system-defined attributes for the exclusion.
	Attributes []Attribute

	noSmithyDocumentSerde
}

// Contains information about what is excluded from an assessment run given the
// current state of the assessment template.
type ExclusionPreview struct {

	// The description of the exclusion preview.
	//
	// This member is required.
	Description *string

	// The recommendation for the exclusion preview.
	//
	// This member is required.
	Recommendation *string

	// The AWS resources for which the exclusion preview pertains.
	//
	// This member is required.
	Scopes []Scope

	// The name of the exclusion preview.
	//
	// This member is required.
	Title *string

	// The system-defined attributes for the exclusion preview.
	Attributes []Attribute

	noSmithyDocumentSerde
}

// Includes details about the failed items.
type FailedItemDetails struct {

	// The status code of a failed item.
	//
	// This member is required.
	FailureCode FailedItemErrorCode

	// Indicates whether you can immediately retry a request for this item for a
	// specified resource.
	//
	// This member is required.
	Retryable *bool

	noSmithyDocumentSerde
}

// Contains information about an Amazon Inspector finding. This data type is used
// as the response element in the DescribeFindingsaction.
type Finding struct {

	// The ARN that specifies the finding.
	//
	// This member is required.
	Arn *string

	// The system-defined attributes for the finding.
	//
	// This member is required.
	Attributes []Attribute

	// The time when the finding was generated.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time when AddAttributesToFindings is called.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The user-defined attributes that are assigned to the finding.
	//
	// This member is required.
	UserAttributes []Attribute

	// A collection of attributes of the host from which the finding is generated.
	AssetAttributes *AssetAttributes

	// The type of the host from which the finding is generated.
	AssetType AssetType

	// This data element is currently not used.
	Confidence int32

	// The description of the finding.
	Description *string

	// The ID of the finding.
	Id *string

	// This data element is currently not used.
	IndicatorOfCompromise *bool

	// The numeric value of the finding severity.
	NumericSeverity float64

	// The recommendation for the finding.
	Recommendation *string

	// The schema version of this data type.
	SchemaVersion int32

	// The data element is set to "Inspector".
	Service *string

	// This data type is used in the Finding data type.
	ServiceAttributes *InspectorServiceAttributes

	// The finding severity. Values can be set to High, Medium, Low, and Informational.
	Severity Severity

	// The name of the finding.
	Title *string

	noSmithyDocumentSerde
}

// This data type is used as a request parameter in the ListFindings action.
type FindingFilter struct {

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the agentId property
	// of the Findingdata type.
	AgentIds []string

	// For a record to match a filter, the list of values that are specified for this
	// data type property must be contained in the list of values of the attributes
	// property of the Findingdata type.
	Attributes []Attribute

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the autoScalingGroup
	// property of the Findingdata type.
	AutoScalingGroups []string

	// The time range during which the finding is generated.
	CreationTimeRange *TimestampRange

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the ruleName property
	// of the Findingdata type.
	RuleNames []string

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the rulesPackageArn
	// property of the Findingdata type.
	RulesPackageArns []string

	// For a record to match a filter, one of the values that is specified for this
	// data type property must be the exact match of the value of the severity property
	// of the Findingdata type.
	Severities []Severity

	// For a record to match a filter, the value that is specified for this data type
	// property must be contained in the list of values of the userAttributes property
	// of the Findingdata type.
	UserAttributes []Attribute

	noSmithyDocumentSerde
}

// This data type is used in the Finding data type.
type InspectorServiceAttributes struct {

	// The schema version of this data type.
	//
	// This member is required.
	SchemaVersion int32

	// The ARN of the assessment run during which the finding is generated.
	AssessmentRunArn *string

	// The ARN of the rules package that is used to generate the finding.
	RulesPackageArn *string

	noSmithyDocumentSerde
}

// Contains information about the network interfaces interacting with an EC2
// instance. This data type is used as one of the elements of the AssetAttributesdata type.
type NetworkInterface struct {

	// The IP addresses associated with the network interface.
	Ipv6Addresses []string

	// The ID of the network interface.
	NetworkInterfaceId *string

	// The name of a private DNS associated with the network interface.
	PrivateDnsName *string

	// The private IP address associated with the network interface.
	PrivateIpAddress *string

	// A list of the private IP addresses associated with the network interface.
	// Includes the privateDnsName and privateIpAddress.
	PrivateIpAddresses []PrivateIp

	// The name of a public DNS associated with the network interface.
	PublicDnsName *string

	// The public IP address from which the network interface is reachable.
	PublicIp *string

	// A list of the security groups associated with the network interface. Includes
	// the groupId and groupName.
	SecurityGroups []SecurityGroup

	// The ID of a subnet associated with the network interface.
	SubnetId *string

	// The ID of a VPC associated with the network interface.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about a private IP address associated with a network
// interface. This data type is used as a response element in the DescribeFindingsaction.
type PrivateIp struct {

	// The DNS name of the private IP address.
	PrivateDnsName *string

	// The full IP address of the network inteface.
	PrivateIpAddress *string

	noSmithyDocumentSerde
}

// Contains information about a resource group. The resource group defines a set
// of tags that, when queried, identify the AWS resources that make up the
// assessment target. This data type is used as the response element in the DescribeResourceGroupsaction.
type ResourceGroup struct {

	// The ARN of the resource group.
	//
	// This member is required.
	Arn *string

	// The time at which resource group is created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The tags (key and value pairs) of the resource group. This data type property
	// is used in the CreateResourceGroupaction.
	//
	// This member is required.
	Tags []ResourceGroupTag

	noSmithyDocumentSerde
}

// This data type is used as one of the elements of the ResourceGroup data type.
type ResourceGroupTag struct {

	// A tag key.
	//
	// This member is required.
	Key *string

	// The value assigned to a tag key.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about an Amazon Inspector rules package. This data type is
// used as the response element in the DescribeRulesPackagesaction.
type RulesPackage struct {

	// The ARN of the rules package.
	//
	// This member is required.
	Arn *string

	// The name of the rules package.
	//
	// This member is required.
	Name *string

	// The provider of the rules package.
	//
	// This member is required.
	Provider *string

	// The version ID of the rules package.
	//
	// This member is required.
	Version *string

	// The description of the rules package.
	Description *string

	noSmithyDocumentSerde
}

// This data type contains key-value pairs that identify various Amazon resources.
type Scope struct {

	// The type of the scope.
	Key ScopeType

	// The resource identifier for the specified scope type.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about a security group associated with a network
// interface. This data type is used as one of the elements of the NetworkInterfacedata type.
type SecurityGroup struct {

	// The ID of the security group.
	GroupId *string

	// The name of the security group.
	GroupName *string

	noSmithyDocumentSerde
}

// This data type is used as a response element in the ListEventSubscriptions action.
type Subscription struct {

	// The list of existing event subscriptions.
	//
	// This member is required.
	EventSubscriptions []EventSubscription

	// The ARN of the assessment template that is used during the event for which the
	// SNS notification is sent.
	//
	// This member is required.
	ResourceArn *string

	// The ARN of the Amazon Simple Notification Service (SNS) topic to which the SNS
	// notifications are sent.
	//
	// This member is required.
	TopicArn *string

	noSmithyDocumentSerde
}

// A key and value pair. This data type is used as a request parameter in the SetTagsForResource
// action and a response element in the ListTagsForResourceaction.
type Tag struct {

	// A tag key.
	//
	// This member is required.
	Key *string

	// A value assigned to a tag key.
	Value *string

	noSmithyDocumentSerde
}

// The metadata about the Amazon Inspector application data metrics collected by
// the agent. This data type is used as the response element in the GetTelemetryMetadataaction.
type TelemetryMetadata struct {

	// The count of messages that the agent sends to the Amazon Inspector service.
	//
	// This member is required.
	Count *int64

	// A specific type of behavioral data that is collected by the agent.
	//
	// This member is required.
	MessageType *string

	// The data size of messages that the agent sends to the Amazon Inspector service.
	DataSize *int64

	noSmithyDocumentSerde
}

// This data type is used in the AssessmentRunFilter data type.
type TimestampRange struct {

	// The minimum value of the timestamp range.
	BeginDate *time.Time

	// The maximum value of the timestamp range.
	EndDate *time.Time

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
