// Code generated by smithy-go-codegen DO NOT EDIT.

package freetier

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/freetier/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Returns a list of activities that are available. This operation supports
//
// pagination and filtering by status.
func (c *Client) ListAccountActivities(ctx context.Context, params *ListAccountActivitiesInput, optFns ...func(*Options)) (*ListAccountActivitiesOutput, error) {
	if params == nil {
		params = &ListAccountActivitiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccountActivities", params, optFns, c.addOperationListAccountActivitiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccountActivitiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccountActivitiesInput struct {

	//  The activity status filter. This field can be used to filter the response by
	// activities status.
	FilterActivityStatuses []types.ActivityStatus

	//  The language code used to return translated titles.
	LanguageCode types.LanguageCode

	//  The maximum number of items to return for this request. To get the next page
	// of items, make another request with the token returned in the output.
	MaxResults *int32

	//  A token from a previous paginated response. If this is specified, the response
	// includes records beginning from this token (inclusive), up to the number
	// specified by maxResults .
	NextToken *string

	noSmithyDocumentSerde
}

type ListAccountActivitiesOutput struct {

	//  A brief information about the activities.
	//
	// This member is required.
	Activities []types.ActivitySummary

	//  The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccountActivitiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListAccountActivities{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListAccountActivities{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccountActivities"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccountActivities(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAccountActivitiesPaginatorOptions is the paginator options for
// ListAccountActivities
type ListAccountActivitiesPaginatorOptions struct {
	//  The maximum number of items to return for this request. To get the next page
	// of items, make another request with the token returned in the output.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccountActivitiesPaginator is a paginator for ListAccountActivities
type ListAccountActivitiesPaginator struct {
	options   ListAccountActivitiesPaginatorOptions
	client    ListAccountActivitiesAPIClient
	params    *ListAccountActivitiesInput
	nextToken *string
	firstPage bool
}

// NewListAccountActivitiesPaginator returns a new ListAccountActivitiesPaginator
func NewListAccountActivitiesPaginator(client ListAccountActivitiesAPIClient, params *ListAccountActivitiesInput, optFns ...func(*ListAccountActivitiesPaginatorOptions)) *ListAccountActivitiesPaginator {
	if params == nil {
		params = &ListAccountActivitiesInput{}
	}

	options := ListAccountActivitiesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccountActivitiesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccountActivitiesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccountActivities page.
func (p *ListAccountActivitiesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccountActivitiesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAccountActivities(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAccountActivitiesAPIClient is a client that implements the
// ListAccountActivities operation.
type ListAccountActivitiesAPIClient interface {
	ListAccountActivities(context.Context, *ListAccountActivitiesInput, ...func(*Options)) (*ListAccountActivitiesOutput, error)
}

var _ ListAccountActivitiesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAccountActivities(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccountActivities",
	}
}
